/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaReacao
extends IntegracaoLabExterno
implements Exportador {
    private EscreverXML xml;

    private String substring(String str, int endIndex) {
        return str.substring(0, str.length() > endIndex ? endIndex : str.length());
    }

    @Override
    public String getTagCodigo() {
        return "laboratorio";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        StringBuilder buf = new StringBuilder();
        try {
            arquivar.call();
            String nomeArquivo = "E" + Funcoes.preencheVazio(StringUtil.getValor(configuracaoLabExterno, "laboratorio"), "0", 3, 1) + Funcoes.preencheVazio(numeroLote, "0", 7, 1) + ".xml";
            String codigoPosto = StringUtil.getValor(configuracaoLabExterno, "posto");
            String codigoConvenio = StringUtil.getValor(configuracaoLabExterno, "convenio");
            if (isColetaWeb) {
                this.montaXML(numeroLote, codigoConvenio, configuracaoLabExterno, requisicoes, buf, codigoPosto, nomeArquivo);
                this.atualizaNumeroLote(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, isColetaWeb, st, arquivar, buf);
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb(this.xml.getArquivo()));
                retorno.setExtensaoArquivo("xml");
                retorno.setImprimiu(true);
                this.xml.fecharArquivo();
                return retorno;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setSelectedFile(new File(nomeArquivo));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o Reacao (*.xml)", "xml"));
            int option = chooser.showOpenDialog(null);
            if (option == 0) {
                this.montaXML(numeroLote, codigoConvenio, configuracaoLabExterno, requisicoes, buf, codigoPosto, chooser.getSelectedFile().getPath());
                this.xml.fecharArquivo();
                this.atualizaNumeroLote(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, isColetaWeb, st, arquivar, buf);
                retorno.setImprimiu(true);
                return retorno;
            }
            if (option == 1) {
                retorno.setImprimiu(true);
                return retorno;
            }
        }
        catch (ParseException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaReacao: 62");
        }
        catch (Exception ex) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaReacao: 144");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private void atualizaNumeroLote(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, StringBuilder buf) throws SQLException, Exception {
        if (!reenvio) {
            Integer aux = Integer.parseInt(numeroLote);
            StringBuilder conf = new StringBuilder(configuracaoLabExterno);
            StringUtil.setValor(conf, "lote", String.valueOf(aux));
            buf.setLength(0);
            buf.append(" update labexterno ");
            buf.append("    set lae_configuracao = '").append(conf.toString()).append("' ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and lae_codigo = ").append(codLabExterno);
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
            }
            arquivar.call();
        }
    }

    private void montaXML(String numeroLote, String codigoConvenio, String configuracaoLabExterno, List<Registro> requisicoes, StringBuilder buf, String codigoPosto, String path) throws ParseException, SQLException {
        this.xml = new EscreverXML(path);
        buf.append("<LOTE_ENVIO LABORATORIO=\"").append(this.substring(Funcoes.preencheVazio(StringUtil.getValor(configuracaoLabExterno, "laboratorio"), "0", 3, 1), 3)).append("\"");
        buf.append(" CONVENIO=\"").append(this.substring(Funcoes.preencheVazio(codigoConvenio, "0", 3, 1), 3)).append("\"");
        buf.append(" LOTE=\"").append(this.substring(Funcoes.preencheVazio(numeroLote, "0", 5, 1), 5)).append("\"");
        buf.append(" DATA=\"").append(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date())).append("\"> ");
        this.xml.escrever(buf.toString());
        this.xml.escrever("<REQUISICOES>");
        for (Registro r : requisicoes) {
            buf.setLength(0);
            buf.append("<REQUISICAO CD_POSTO=\"").append(this.substring(Funcoes.preencheVazio(codigoPosto, "0", 3, 1), 3)).append("\"");
            buf.append(" CD_REQUISICAO=\"").append(Funcoes.preencheZero(r.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(r.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao())).append("\"");
            buf.append(" NU_SEQUENCIAL=\"").append(this.substring(Funcoes.preencheVazio(r.getString("req_codigo"), "0", 6, 1), 6)).append("\"");
            buf.append(" DT_REQUISICAO=\"").append(Funcoes.formataData("dd/MM/yyyy ", r.getDate("req_data")) + Funcoes.formataData("HH:mm:ss", r.getDate("req_hora"))).append("\"");
            buf.append(" DE_OBSERVACAO=\"").append(this.substring(StringUtil.removerAcentos(r.getString("req_obs")), 255)).append("\"");
            buf.append(" DE_OBSERVACAO_CLINICA=\"").append(this.substring(r.getString("req_dclinicos"), 255)).append("\"> ");
            this.xml.escrever(buf.toString());
            this.escreverPaciente(r, codigoPosto, configuracaoLabExterno);
            this.escreverMedico(r);
            this.xml.escrever("<EXAMES>");
            this.escreverExames(r);
            this.xml.escrever("</EXAMES>");
            this.xml.escrever("</REQUISICAO>");
        }
        this.xml.escrever("</REQUISICOES>");
        this.xml.escrever("</LOTE_ENVIO>");
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void escreverPaciente(Registro r, String codigoPosto, String configuracaoLabExterno) {
        StringBuilder buf = new StringBuilder();
        String codigoPaciente = this.substring(Funcoes.preencheVazio(r.getString("pac_codigo"), "0", 6, 1), 6);
        if (Boolean.parseBoolean(StringUtil.getValor(configuracaoLabExterno, "ignorarDigitosPaciente"))) {
            codigoPaciente = Funcoes.preencheZero(r.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + r.getString("pac_codigo");
        }
        buf.append("<PACIENTE CD_POSTO_PACIENTE=\"").append(this.substring(Funcoes.preencheVazio(codigoPosto, "0", 3, 1), 3)).append("\"");
        buf.append(" CD_PACIENTE=\"").append(codigoPaciente).append("\"");
        buf.append(" NM_PACIENTE=\"").append(this.substring(r.getString("pac_nome"), 60)).append("\"");
        buf.append(" ID_SEXO=\"").append(this.substring(r.getString("pac_sexo"), 1)).append("\"");
        try {
            buf.append(" NU_IDADE=\"").append(this.substring(Funcoes.preencheVazio(Funcoes.calculaIdade(Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc")), false), "0", 3, 1), 3)).append("\"");
            buf.append(" DT_NASCIMENTO=\"").append(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", r.getDate("pac_datanasc"))).append("\"");
            buf.append(" DT_ULTIMA_MENSTRUACAO=\"").append(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", r.getDate("req_dum"))).append("\">");
        }
        catch (ParseException pe) {
            buf.append(" NU_IDADE=\"").append("\"");
            buf.append(" DT_NASCIMENTO=\"").append("\">");
        }
        this.xml.escrever(buf.toString());
        this.xml.escrever("</PACIENTE>");
    }

    private void escreverMedico(Registro r) {
        StringBuilder buf = new StringBuilder();
        buf.append("<MEDICO CD_MEDICO=\"").append(this.substring(Funcoes.preencheVazio(r.getString("med_crm"), "0", 7, 1), 7)).append("\"");
        buf.append(" CD_CRM_MEDICO=\"").append(this.substring(Funcoes.preencheVazio(r.getString("med_crm"), "0", 7, 1), 7)).append("\"");
        buf.append(" UF_MEDICO=\"").append(this.substring(r.getString("med_uf"), 2)).append("\"");
        buf.append(" NM_MEDICO=\"").append(this.substring(r.getString("med_nome"), 60)).append("\">");
        this.xml.escrever(buf.toString());
        this.xml.escrever("</MEDICO>");
    }

    private void escreverExames(Registro r) throws SQLException {
        List exames = (List)r.getValor("listaexames");
        Statement st = Conexao.getStatement();
        for (Registro exa : exames) {
            StringBuilder buf = new StringBuilder();
            StringBuilder idAmostra = new StringBuilder();
            String xmlExame = exa.getString("ele_xmllabexterno");
            int recipiente = this.getRecipiente(st, r.getString("fil_codigo"), r.getString("req_codigo"), exa.getString("exa_codigo"), exa.getInt("mco_codigo"));
            buf.append("<EXAME CD_EXAME=\"").append(this.substring(StringUtil.getValor(xmlExame, "codigo_exame"), 5)).append("\"");
            buf.append(" ID_CODIGO_BARRA=\"").append(this.substring(Funcoes.preencheVazio(r.getString("req_codigo"), "0", 12, 1), 12)).append("\"");
            if (recipiente != 0) {
                idAmostra.append(this.substring(Funcoes.preencheVazio(r.getString("fil_codigo"), "0", ParametrosGerais.getDigitosTuboFilial(), 1), ParametrosGerais.getDigitosTuboFilial()));
                idAmostra.append(this.substring(Funcoes.preencheVazio(r.getString("req_codigo"), "0", ParametrosGerais.getDigitosTuboRequisicao(), 1), ParametrosGerais.getDigitosTuboRequisicao()));
                idAmostra.append(this.substring(Funcoes.preencheVazio(String.valueOf(recipiente), "0", ParametrosGerais.getDigitosTuboTubo(), 1), ParametrosGerais.getDigitosTuboTubo()));
                buf.append(" ID_AMOSTRA_APOIO=\"").append((CharSequence)idAmostra).append("\"");
            }
            try {
                buf.append(" DT_COLETA=\"").append(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", exa.getDate("exr_datamaterial"))).append("\"");
            }
            catch (ParseException pe) {
                buf.append(" DT_COLETA=\"").append("\"");
            }
            buf.append(" CD_MATERIAL=\"").append(this.substring(Funcoes.preencheVazio(StringUtil.getValor(xmlExame, "codigo_material_padrao"), "0", 12, 1), 12)).append("\"");
            buf.append(" DE_MATERIAL=\"").append(this.substring(StringUtil.getValor(xmlExame, "nome_material_padrao"), 40)).append("\">");
            this.xml.escrever(buf.toString());
            this.xml.escrever("</EXAME>");
        }
    }

    private int getRecipiente(Statement st, String filial, String requisicao, String exame, int material) throws SQLException {
        StringBuilder buf = new StringBuilder("select rec_codigo from examerequisicaorecipiente a ");
        buf.append("where  fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(exame).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        buf.append(" and ere_tipo = '").append("C").append("'");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getInt("rec_codigo");
        }
        return 0;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    class EscreverXML {
        private File arquivo;
        private BufferedWriter writer;

        public File getArquivo() {
            return this.arquivo;
        }

        public EscreverXML(String nomeArquivo) {
            try {
                this.arquivo = new File(nomeArquivo);
                this.writer = new BufferedWriter(new FileWriter(this.arquivo));
                this.writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }

        private void escrever(String texto, boolean quebra) {
            if (this.writer == null) {
                ErrorLogger.mostraMensagem(null, "O arquivo n\u00e3o pode ser escrito, pois n\u00e3o foi aberto", null, "ExportacaoParaReacao: 207");
            } else {
                try {
                    this.writer.write(texto);
                    if (quebra) {
                        this.writer.write(10);
                    }
                }
                catch (IOException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaReacao: 215");
                }
            }
        }

        private void escrever(String texto) {
            this.escrever(texto, true);
        }

        public void fecharArquivo() {
            if (this.writer == null) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o arquivo, pois n\u00e3o est\u00e1 aberto", null, "ExportacaoParaReacao: 256");
            } else {
                try {
                    this.writer.close();
                    this.writer = null;
                    this.arquivo = null;
                }
                catch (IOException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaReacao: 266");
                }
            }
        }

        public void cancelar() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.arquivo.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

