/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ConfirmarCondicaoAmostra;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialMercolab;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaMercolabDao;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.mercolab.MercolabService;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.mercolabws.ExameMercolab;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.print.PrintService;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ExportacaoParaMercolab
extends IntegracaoLabExterno
implements Exportador {
    public static final String GERAR_LOTE = "gerarLote";
    public static final String LEQ_RETORNO_WS = "LEQ_RETORNO_WS";
    public static final String TABELA_LOTEEXTERNO = "loteexterno";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAODESM = "loteexternoexamerequisicaodesm";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAORECIP = "loteexternoexamerequisicaorecip";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAO = "loteexternoexamerequisicao";
    public static final String TABELA_LOTEEXTERNOREQUISICAO = "loteexternorequisicao";
    public static final String MCO_KODIGO = "mco_kodigo";
    public static final String EXA_KODIGO = "exa_kodigo";
    public static final String REC_CODIGO = "rec_codigo";
    public static final String FIL_KODIGO = "fil_kodigo";
    public static final String USR_CODCRIACAO = "usr_codcriacao";
    public static final String LEX_DATAHORA = "lex_datahora";
    public static final String LEX_CODIGO = "lex_codigo";
    public static final String REQ_ALTURA = "req_altura";
    public static final String REQ_PESO = "req_peso";
    public static final String REQ_OBS = "req_obs";
    public static final String REQ_DUM = "req_dum";
    public static final String REQ_HORA = "req_hora";
    public static final String REQ_DATA = "req_data";
    public static final String REQ_IDADE = "req_idade";
    public static final String REQ_CODIGO = "req_codigo";
    public static final String REQ_DATANASC = "req_datanasc";
    public static final String EXR_VOLUMEDIURESE = "exr_volumediurese";
    public static final String EXR_TEMPODIURESE = "exr_tempodiurese";
    public static final String EXR_CODIGOAPOIADO = "exr_codigoapoiado";
    public static final String EXR_DATAMATERIAL = "exr_datamaterial";
    public static final String EXR_DESCRICAOMATERIAL = "exr_descricaomaterial";
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    public static final String PAC_DATANASC = "pac_datanasc";
    public static final String PAC_SEXO = "pac_sexo";
    public static final String PAC_NOME = "pac_nome";
    public static final String PAC_CODIGO = "pac_codigo";
    public static final String FIL_CODIGO = "fil_codigo";
    public static final String CODIGO_MATERIAL = "codigoMaterial";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String PAC_DUM = "pac_dum";
    public static final String CON_CODIGO = "con_codigo";
    public static final String LAE_CODIGO = "lae_codigo";
    public static final String ELE_XML_LAB_EXTERNO = "ele_xmllabexterno";
    public static final String EXA_DESCRICAO = "exa_descricao";
    public static final String MCO_DESCRICAO = "mco_descricao";
    public static final String REC_KODIGO = "rec_kodigo";
    public static final String CODIGO_PROTOCOLO = "codigoProtocolo";
    public static final String TIPO_IMPRESSAO = "tipoImpressao";
    public static final String ETIQUETA_ARMAZENADA = "etiquetaArmazenada";
    public static final String QTDE_ETIQUETAS = "qtdeEtiquetas";
    public static final String MED_SIGLA_CONSELHO = "med_conselho";
    public static final String MED_UF_CONSELHO = "med_uf";
    public static final String MED_NUMERO_CONSELHO = "med_crm";
    public static final String MED_NOME = "med_nome";
    public static final String TAG_ID_MEDICO_SOLICITANTE = "idMedicoSolicitante";
    public static final String TAG_ID_TUBO_LAB = "IdTuboLab";
    public static final String TAG_HORA_COLETA = "HoraColeta";
    public static final String TAG_DATA_COLETA = "DataColeta";
    public static final String TAG_CONSERVANTE = "Conservante";
    public static final String TAG_DESC_MAT = "DescMat";
    public static final String TAG_COD_EXM_APOIO = "CodExmApoio";
    public static final String TAG_COD_EXM_LAB = "CodExmLab";
    public static final String TAG_EXAME = "Exame";
    public static final String TAG_DATA_NASC = "DataNasc";
    public static final String TAG_SEXO = "Sexo";
    public static final String TAG_NOME = "Nome";
    public static final String TAG_COD_PAC_LAB = "CodPacLab";
    public static final String TAG_PACIENTE = "Paciente";
    public static final String TAG_DATA_ULT_MENS = "DataUltMens";
    public static final String TAG_HORA_PED = "HoraPed";
    public static final String TAG_DATA_PED = "DataPed";
    public static final String TAG_COD_PED_LAB = "CodPedLab";
    public static final String TAG_PEDIDO = "Pedido";
    public static final String TAG_ETIQ_COD_BAR = "EtqCodBar";
    public static final String TAG_COD_BAR_APOIO = "CodBarApoio";
    public static final String TAG_RECIPIENTES = "Recipientes";
    public static final String TAG_RECIPIENTE = "Recipiente";
    public static final String TAG_HORA_LOTE = "HoraLote";
    public static final String TAG_DATA_LOTE = "DataLote";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_LOTE = "Lote";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_REGISTRO = "Registro";
    public static final String CODIGO_LAB_EXTERNO = "codigoLabExterno";
    public static final String REQ_CODIGO_MAE = "req_codigomae";
    public static final String TAG_MEDICO = "Medico";
    public static final String TAG_SEQ_MED = "seqmed";
    public static final String TAG_SIGLA_CONSELHO_MED = "siglaConselho";
    public static final String TAG_NUMERO_CONSELHO_MED = "numeroConselho";
    public static final String TAG_UF_CONSELHO_MED = "ufConselho";
    public static final String TAG_NOME_MED = "Nome";
    public static final String TAG_CONDICAO_AMOSTRA = "Condicao";
    public static final String TAG_COD_PED_APOIO = "CodPedApoio";
    public static final String PERIODO_GESTACIONAL = "req_periodogestacional";
    public static final String DATA_SINTOMA = "req_datasintoma";
    public static final String MUNICIPIO_RESIDENCIA = "req_municipioresidencia";
    public static final String APRESENTOU_SINTOMA = "req_apresentousintoma";
    public static final String TAG_ABRIR_CDATA = "<![CDATA[";
    public static final String TAG_FECHAR_CDATA = "]]>";
    private String retornoMercolab = "";
    private XMLStringBuilder xml = new XMLStringBuilder(true);
    private final ExportacaoParaMercolabDao dao = new ExportacaoParaMercolabDao();
    private String laeCodigo = "";

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        this.enviarUsandoWS = configuracaoLabExterno.indexOf("enviarLoteWebService") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebService") : false;
        this.laeCodigo = codLabExterno;
        if (!this.validarConfiguracao(configuracaoLabExterno, false, isColetaWeb)) {
            try {
                ExportacaoParaMercolab.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            catch (NumberFormatException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (!isColetaWeb) {
            this.setCondicaoExamesDesm(this.confirmaCondicaoAmostra(Variaveis.filialPadrao, requisicoes, codLabExterno, st, agruparGuiasInterface));
        }
        retorno = this.processa(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, colunaOrdenacao, true, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, agruparInterface, st2, st3, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras.getImpressoraMercolab(), tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular);
        return retorno;
    }

    private ArrayList<InterfaceDesmembrar> confirmaCondicaoAmostra(String filial, List<Registro> requisicoes, String codigoLab, Statement st, boolean agruparGuiasInterface) {
        ArrayList<InterfaceDesmembrar> examesDesm = new ArrayList<InterfaceDesmembrar>();
        for (Registro reg : requisicoes) {
            List exames = (List)reg.getValor("listaexames");
            for (Registro ex : exames) {
                ConfirmarCondicaoAmostra confirmarCondicaoAmostra = new ConfirmarCondicaoAmostra(new Dialog(Laboratorio.getInstancia()), ex.getString(EXA_CODIGO), ex.getString(MCO_CODIGO), codigoLab, ex.getString(REQ_CODIGO));
                if (!confirmarCondicaoAmostra.contemExamesFilho()) continue;
                confirmarCondicaoAmostra.setVisible(this.exibirConfirmaCondicaoAmostra(reg, ex, requisicoes, st, agruparGuiasInterface));
                examesDesm.addAll(confirmarCondicaoAmostra.getExames());
            }
        }
        return examesDesm;
    }

    private boolean exibirConfirmaCondicaoAmostra(Registro reg, Registro ex, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface) {
        boolean perguntar = true;
        if (ExportacaoParaMercolab.possuiAgrupamentoMultiguia(reg, ex, st, agruparGuiasInterface)) {
            block0: for (Registro r : requisicoes) {
                if (r.equals(reg)) break;
                for (Registro registroComparador : (List)r.getValor("listaexames")) {
                    String nomeExame = registroComparador.getString(EXA_CODIGO);
                    if (Funcoes.objectIsNull(nomeExame) || nomeExame.isEmpty() || !nomeExame.equals(ex.getString(EXA_CODIGO)) || ex.getString(REQ_CODIGO_MAE).equals(ex.getString(REQ_CODIGO))) continue;
                    perguntar = false;
                    continue block0;
                }
            }
        }
        return perguntar;
    }

    @Override
    public String getTagCodigo() {
        return "idLaboratorio";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RetornoImpressaoEtiquetas processa(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean enviarDadosMedico, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, int agruparInterface, Statement st2, Statement st3, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        boolean isEnviarRequisicaoWebService = configuracaoLabExterno.indexOf("envioAutomatico") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "envioAutomatico") : false;
        String idLaboratorio = configuracaoLabExterno.indexOf("idLaboratorio") > 0 ? StringUtil.getValor(configuracaoLabExterno, "idLaboratorio") : null;
        String senhaWebservice = configuracaoLabExterno.indexOf("senha") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
        this.retornoMercolab = null;
        ArrayList<Registro> lista = new ArrayList<Registro>();
        for (Registro requisicao : requisicoes) {
            lista.add(requisicao.clone());
        }
        try {
            block25: {
                for (Registro registro : requisicoes) {
                    ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
                    ArrayList<String> listExa = new ArrayList<String>();
                    int[] arrayMat = new int[listaExames.size()];
                    for (Registro exa : listaExames) {
                        listExa.add(exa.getString(EXA_CODIGO));
                        arrayMat[listExa.size() - 1] = exa.getInt(MCO_CODIGO);
                    }
                    if (tipoEtiq == 0) {
                        tipoEtiq = agruparInterface == 1 ? 2 : 1;
                    }
                    String[] arrayExa = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
                    ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, registro.getString(FIL_CODIGO), registro.getString(REQ_CODIGO), arrayExa, arrayMat, true, "R", st, st2, st3, Variaveis.login, tipoEtiq, false, null, null, false, false, codigoLabExterno, false, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
                }
                arquivar.call();
                this.xml.limpar();
                this.xml.escrever("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:asc=\"https://ascherer.com.br/\"><soap:Header/> <soap:Body> <asc:getPedido> <asc:login>" + idLaboratorio + "</asc:login><asc:passwd>" + senhaWebservice + "</asc:passwd>\n <asc:XML>");
                String codigoConvenio = StringUtil.getValor(configuracaoLabExterno, "idLaboratorio");
                this.gerarXML(numeroLote, codigoConvenio, requisicoes, false, enviarDadosMedico, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao);
                this.xml.escrever("</asc:XML>      </asc:getPedido>   </soap:Body></soap:Envelope>");
                String nomeArquivo = "remessa_" + numeroLote + ".xml";
                if (!this.enviarUsandoWS && !isEnviarRequisicaoWebService) {
                    if (isColetaWeb) {
                        retorno.setNomeArquivoLote(nomeArquivo);
                        retorno.setXmlLote(this.xml.getXML());
                        retorno.setExtensaoArquivo("xml");
                        retorno.setImprimiu(true);
                    } else {
                        this.gerarArquivo(this.xml.getXML(), new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o Mercolab (*.xml)");
                    }
                } else if (this.enviarUsandoWS || isEnviarRequisicaoWebService) {
                    HttpUriRequest request;
                    String url = StringUtil.getValor(configuracaoLabExterno, "enderecoWebService") + "?wsdl";
                    String xmlEnvio = this.xml.toString().replace("<br>", " ");
                    CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
                    CloseableHttpResponse response = client.execute(request = RequestBuilder.post((String)url).addHeader("Content-Type", "application/soap+xml").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xmlEnvio, "UTF-8")).build());
                    if (this.statusOK(response)) {
                        HttpEntity entity = response.getEntity();
                        this.retornoMercolab = EntityUtils.toString((HttpEntity)entity);
                    }
                    this.retornoMercolab = StringUtil.xmlToTexto(this.retornoMercolab);
                    this.montaRetornoInvalido(response);
                    ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(this.retornoMercolab);
                    if (erroRetornoWebServiceLabExterno.getRegistroRejeitado()) {
                        if (!reenvio) {
                            ExportacaoParaMercolab.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                        }
                        if (isColetaWeb) {
                            UtilExportadores.adicionarMensagemRetorno(this.retornoMercolab, "MercolabWS", retorno);
                            retorno.setNomeArquivoLote(nomeArquivo);
                            retorno.setXmlLote(xmlEnvio);
                            retorno.setExtensaoArquivo("xml");
                            retorno.setImprimiu(false);
                            return retorno;
                        }
                        VisualizaErroRetornoWebService telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Mercolab");
                        if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                            this.gerarArquivo(xmlEnvio, new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o Mercolab (*.xml)");
                            break block25;
                        } else {
                            retorno.setImprimiu(false);
                            return retorno;
                        }
                    }
                    retorno = this.processaRetornoWebService(isColetaWeb, codigoLabExterno, numeroLote, reenvio, lista, false, st, digitosTuboFilial, impressora, tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular);
                }
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception ex) {
            try {
                if (!reenvio) {
                    ExportacaoParaMercolab.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isColetaWeb) {
                if (null != ex.getMessage() && ex.getMessage().contains("java.net.UnknownHostException")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com Mercolab.\nVerifique sua conex\u00e3o com a internet.", 2);
                } else if (null != ex.getCause() && ex.getCause().toString().contains("Badly formed SOAP Message")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com Mercolab.\nVerifique c\u00f3digo/senha na configura\u00e7\u00e3o do Laborat\u00f3rio externo.", 2);
                } else {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
            }
            UtilExportadores.adicionarMensagemRetorno(this.retornoMercolab, "N\u00e3o foi poss\u00edvel obter conex\u00e3o com Mercolab. <br>" + ex.getMessage(), retorno);
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private void montaRetornoInvalido(CloseableHttpResponse response) {
        if (!this.statusOK(response)) {
            this.retornoMercolab = "<RegistroRejeitado><Erro><Descricao>Falha na comunica\u00e7\u00e3o com o mercolab.</Descricao></Erro></RegistroRejeitado>";
        }
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    private SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    private boolean verificaAgrupaMultiguias(String filCodigo, String reqCodigo, boolean agruparGuiasInterface, Statement st) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(st, filCodigo, reqCodigo, true, false);
        return this.isAgruparMultiguias(filCodigo, multiguias, agruparGuiasInterface, st);
    }

    private void trataCampoObservacao(Registro req) {
        String observacao = req.getValor(REQ_OBS, String.class);
        if (!Funcoes.textoVazio(observacao)) {
            observacao = StringUtil.removerAcentos(observacao).replaceAll("[^a-zA-Z1-9: ]", "");
            req.setValor(REQ_OBS, observacao);
        }
    }

    protected String getSexo(String tipo) {
        if (tipo.equals("M")) {
            return "Masculino";
        }
        if (tipo.equals("F")) {
            return "Feminino";
        }
        return "Indefinido";
    }

    private boolean validaMedico(Registro registro, XMLStringBuilder xml, ArrayList<Registro> listaMedicos) {
        String crm = registro.getString("medicoCRM");
        String ufMedico = registro.getString("ufMedico");
        String conselhoMedico = registro.getString("conselhoMedico");
        if (!listaMedicos.isEmpty()) {
            for (Registro reg : listaMedicos) {
                if (!reg.getString("pedido").equals(StringUtil.getValor(xml.toString(), TAG_COD_PED_LAB)) || !reg.getString("crmMedico").equalsIgnoreCase(crm) || !reg.getString("ufMedico").equalsIgnoreCase(ufMedico) || !reg.getString("conselho").equalsIgnoreCase(conselhoMedico)) continue;
                return true;
            }
        }
        Registro re = new Registro();
        re.setValor("pedido", StringUtil.getValor(xml.toString(), TAG_COD_PED_LAB));
        re.setValor("crmMedico", crm);
        re.setValor("ufMedico", ufMedico);
        re.setValor("conselho", conselhoMedico);
        listaMedicos.add(re);
        return false;
    }

    protected String getTagIdadePaciente(Registro req) {
        if (req.getString("req_anomes").equalsIgnoreCase("A")) {
            return "IdadeAno";
        }
        if (req.getString("req_anomes").equalsIgnoreCase("M")) {
            return "IdadeMes";
        }
        return "IdadeDia";
    }

    private void criarPedido(Registro req, boolean isUtilizarHPDirect, boolean enviarDadosMedico, ArrayList<Registro> medicos, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean agruparGuiasInterface) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.abrir(TAG_PEDIDO);
        this.xml.escrever(TAG_COD_PED_LAB, Funcoes.preencheZero(req.getString(FIL_CODIGO), digitosTuboFilial) + Funcoes.preencheZero(req.getString(REQ_CODIGO), digitosTuboRequisicao));
        this.trataCampoObservacao(req);
        String obs = req.getString(REQ_OBS);
        this.xml.abrir(TAG_PACIENTE);
        this.xml.escrever(TAG_COD_PAC_LAB, req.getString(PAC_CODIGO));
        this.xml.escrever("Nome", StringUtil.limpaXmlEnvioWebService(req.getString(PAC_NOME)));
        this.xml.escrever(TAG_DATA_NASC, Funcoes.formataData("yyyy-MM-dd", req.getDate(PAC_DATANASC)));
        this.xml.escrever(TAG_SEXO, this.getSexo(req.getString(PAC_SEXO)));
        this.xml.fechar(TAG_PACIENTE);
        List listaExames = (List)req.getValor("listaexames");
        HashSet<String> chaves = new HashSet<String>();
        Map<ExameMaterialMercolab, String> exaMercolab = null;
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        for (Registro exa : listaExames) {
            String key = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
            if (listaExamesAdicionados.contains(key)) continue;
            List<Registro> listaExamesDesmembrados = ExportacaoParaMercolab.getExamesDesmembrados(req.getString(FIL_CODIGO), exa, this.laeCodigo, chaves, st);
            if (listaExamesDesmembrados != null && listaExamesDesmembrados.size() > 0) {
                exaMercolab = this.carregarExamesMercolab(listaExamesDesmembrados);
                for (Registro desm : listaExamesDesmembrados) {
                    key = desm.getString(EXA_CODIGO) + desm.getString(MCO_CODIGO);
                    if (listaExamesAdicionados.contains(key)) continue;
                    desm.setValor(TAG_ID_MEDICO_SOLICITANTE, this.getIDMedicoSolicitante(medicos, desm, req));
                    this.gravarDadosExame(desm, obs, req, isUtilizarHPDirect);
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            exa.setValor(TAG_ID_MEDICO_SOLICITANTE, this.getIDMedicoSolicitante(medicos, exa, req));
            exaMercolab = this.carregarExamesMercolab(listaExames);
            this.gravarDadosExame(exa, obs, req, isUtilizarHPDirect);
            listaExamesAdicionados.add(key);
        }
        boolean isMultiguias = this.verificaAgrupaMultiguias(req.getString(FIL_CODIGO), req.getString(REQ_CODIGO), agruparGuiasInterface, st);
        int seqMed = 0;
        if (enviarDadosMedico) {
            if (isMultiguias) {
                ArrayList<Registro> listaMedicos = new ArrayList<Registro>();
                for (Registro re : medicos) {
                    if (this.validaMedico(re, this.xml, listaMedicos)) continue;
                    this.xml.abrir(TAG_MEDICO);
                    this.xml.escrever(TAG_SEQ_MED, String.valueOf(++seqMed));
                    this.xml.escrever(TAG_SIGLA_CONSELHO_MED, re.getString("conselhoMedico"));
                    this.xml.escrever(TAG_UF_CONSELHO_MED, re.getString("ufMedico"));
                    this.xml.escrever(TAG_NUMERO_CONSELHO_MED, re.getString("medicoCRM"));
                    this.xml.escrever("Nome", StringUtil.removerAcentos(re.getString("nomeMedico")));
                    this.xml.fechar(TAG_MEDICO);
                    re.setValor(TAG_SEQ_MED, seqMed);
                }
            } else {
                this.xml.abrir(TAG_MEDICO);
                this.xml.escrever(TAG_SEQ_MED, String.valueOf(++seqMed));
                this.xml.escrever(TAG_SIGLA_CONSELHO_MED, req.getString(MED_SIGLA_CONSELHO));
                this.xml.escrever(TAG_UF_CONSELHO_MED, req.getString(MED_UF_CONSELHO));
                this.xml.escrever(TAG_NUMERO_CONSELHO_MED, req.getString(MED_NUMERO_CONSELHO));
                this.xml.escrever("Nome", StringUtil.removerAcentos(req.getString(MED_NOME)));
                this.xml.fechar(TAG_MEDICO);
                medicos.get(0).setValor(TAG_SEQ_MED, seqMed);
            }
        }
        this.xml.fechar(TAG_PEDIDO);
    }

    private List<Registro> getIDMedicoSolicitante(List<Registro> dadosMedico, Registro exa, Registro req) {
        ArrayList<Registro> solicitantes = new ArrayList<Registro>();
        for (Registro med : dadosMedico) {
            solicitantes.add(med);
        }
        return solicitantes;
    }

    private Map<ExameMaterialMercolab, String> carregarExamesMercolab(List<Registro> exames) {
        HashMap<ExameMaterialMercolab, String> map = new HashMap<ExameMaterialMercolab, String>();
        for (Registro exa : exames) {
            ExameMercolab exameMercolab = ExameMercolab.novaInstancia(exa.getString(ELE_XML_LAB_EXTERNO));
            if (exameMercolab == null) continue;
            String codExameJalis = exa.getString(EXA_CODIGO);
            exa.setValor(TAG_COD_EXM_LAB, codExameJalis);
            exa.setValor(TAG_DESC_MAT, exameMercolab.getDescricaoMaterial());
            exa.setValor(TAG_COD_EXM_APOIO, exameMercolab.getCodigoExame());
            map.put(new ExameMaterialMercolab(exameMercolab.getCodigoExame(), exameMercolab.getDescricaoMaterial(), codExameJalis), exa.getString(TAG_DESC_MAT));
        }
        return map;
    }

    protected String formatar(String masc, Date data) {
        if (masc != null && data != null) {
            return Funcoes.formataData(masc, data);
        }
        return "";
    }

    private String getCondicaoExame(Registro exa, Statement st, boolean agruparGuiasInterface) throws SQLException {
        String condicao = "";
        for (InterfaceDesmembrar ex : this.getCondicaoExamesDesm()) {
            Integer[] requisicoes = new Integer[]{exa.getInt(REQ_CODIGO_MAE)};
            boolean agruparMultiguia = this.isAgruparMultiguias(exa.getString(FIL_CODIGO), requisicoes, agruparGuiasInterface, st);
            if (!this.isMesmoExame(exa, ex, st, agruparGuiasInterface) || !ex.getCodRec().equals(exa.getString(REQ_CODIGO)) && (!agruparMultiguia || !ex.getCodRec().equals(exa.getString(REQ_CODIGO_MAE)))) continue;
            condicao = ex.getCondicaoAmostra();
            break;
        }
        return condicao;
    }

    private boolean isAgruparMultiguias(String fil_codigo, Integer[] multiguias, boolean agruparGuiasInterface, Statement st) throws SQLException {
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, fil_codigo, multiguias);
    }

    private boolean isMesmoExame(Registro exa, InterfaceDesmembrar ex, Statement st, boolean agruparGuiasInterface) {
        boolean exameIgual;
        String matCodigo = String.valueOf(ex.getMaterial().getCodigo());
        boolean bl = exameIgual = ex.getCodigo().equalsIgnoreCase(exa.getString(EXA_CODIGO)) && matCodigo.equalsIgnoreCase(exa.getString(MCO_CODIGO));
        if (!ExportacaoParaMercolab.possuiAgrupamentoMultiguia(exa, exa, st, agruparGuiasInterface)) {
            exameIgual = exameIgual && exa.getString(REQ_CODIGO).equals(ex.getCodRec());
        }
        return exameIgual;
    }

    private void gravarDadosExame(Registro exa, String obsRequisicao, Registro req, boolean isUtilizarHPDirect) throws XMLStringBuilderException, ParseException, SQLException {
        Map infoComp;
        String descrMaterial;
        this.xml.abrir(TAG_EXAME);
        this.xml.escrever(TAG_COD_EXM_LAB, exa.getString(TAG_COD_EXM_LAB));
        this.xml.escrever(TAG_COD_EXM_APOIO, exa.getString(TAG_COD_EXM_APOIO));
        ExameMaterialMercolab exaMat = new ExameMaterialMercolab(exa.getString(TAG_COD_EXM_LAB), exa.getString(TAG_DESC_MAT), exa.getString(TAG_COD_EXM_APOIO));
        String codMaterial = exa.getString(MCO_CODIGO) + "|";
        if (exaMat.material.equalsIgnoreCase("DIV") && exa.getBoolean("utilizar-mat-requisicao")) {
            descrMaterial = Funcoes.textoVazio(exa.getString(EXR_DESCRICAOMATERIAL)) ? StringUtil.limpaXmlEnvioWebService(exa.getString(MCO_DESCRICAO)) : StringUtil.limpaXmlEnvioWebService(exa.getString(EXR_DESCRICAOMATERIAL));
            descrMaterial = codMaterial + descrMaterial;
            this.xml.escrever(TAG_DESC_MAT, descrMaterial);
        } else if (!Funcoes.textoVazio(exa.getString(TAG_DESC_MAT))) {
            descrMaterial = StringUtil.limpaXmlEnvioWebService(exa.getString(TAG_DESC_MAT));
            descrMaterial = codMaterial + descrMaterial;
            this.xml.escrever(TAG_DESC_MAT, descrMaterial);
        }
        this.xml.escrever(TAG_DATA_COLETA, this.formatar("yyyy-MM-dd", exa.getDate(EXR_DATAMATERIAL) != null ? exa.getDate(EXR_DATAMATERIAL) : Funcoes.getHoraServidor()));
        this.xml.escrever(TAG_HORA_COLETA, this.formatar("HH:mm:ss", exa.getDate(EXR_DATAMATERIAL) != null ? exa.getDate(EXR_DATAMATERIAL) : Funcoes.getHoraServidor()));
        if (!Funcoes.textoVazio(exa.getString(EXR_TEMPODIURESE))) {
            String tmp = exa.getString(EXR_TEMPODIURESE);
            if (tmp.indexOf(":") > 0) {
                tmp = tmp.substring(0, tmp.indexOf(":"));
            }
            if (tmp.length() > 5) {
                tmp = tmp.substring(0, 5);
            }
            this.gravaInformacaoComplementar("TempoDiurese", tmp);
        }
        if (!Funcoes.textoVazio(exa.getString(EXR_VOLUMEDIURESE))) {
            String volume = StringUtil.limpaString(exa.getString(EXR_VOLUMEDIURESE), new String[]{",", ".", ":", "\\"});
            if (volume.length() > 5) {
                volume = volume.substring(0, 5);
            }
            Float valor = Float.valueOf(exa.getString(EXR_VOLUMEDIURESE).replaceAll("\\,", "."));
            this.gravaInformacaoComplementar("VolumeDiurese", "" + Math.round(valor.floatValue()));
        }
        if (!Funcoes.textoVazio(req.getString(REQ_PESO)) && !req.getString(REQ_PESO).equals("0.00")) {
            this.gravaInformacaoComplementar("Peso", req.getString(REQ_PESO));
        }
        if (!Funcoes.textoVazio(req.getString(REQ_ALTURA)) && Funcoes.isNumeric(req.getString(REQ_ALTURA))) {
            Float altura = Float.valueOf(Float.parseFloat(req.getString(REQ_ALTURA).replaceAll("\\,", ".")));
            if (altura.intValue() > 3) {
                if (altura.intValue() > 100) {
                    altura = Float.valueOf(altura.floatValue() / 100.0f);
                } else if (altura.intValue() > 10) {
                    altura = Float.valueOf(altura.floatValue() / 10.0f);
                }
            }
            if (altura.intValue() > 0) {
                this.gravaInformacaoComplementar("Altura", altura.toString());
            }
        }
        if (!Funcoes.textoVazio(exa.getString("exr_linfocitosabsoluto"))) {
            this.gravaInformacaoComplementar("LinfocitosAbsoluto", exa.getString("exr_linfocitosabsoluto"));
        }
        StringBuilder obs = new StringBuilder();
        if (!Funcoes.textoVazio(exa.getString("exr_tempoamostra"))) {
            this.gravaInformacaoComplementar("TempoAmostra", Funcoes.preencheZero(exa.getString("exr_tempoamostra").trim(), 2));
        }
        if (!Funcoes.textoVazio(exa.getString("exr_pesoamostra"))) {
            this.gravaInformacaoComplementar("PesoAmostra", exa.getString("exr_pesoamostra").trim());
        }
        if (!Funcoes.textoVazio(exa.getString("exr_hematocrito"))) {
            String hemato = exa.getString("exr_hematocrito").trim().replace(',', '.');
            this.gravaInformacaoComplementar("Hematocrito", hemato);
        }
        if (!Funcoes.textoVazio(exa.getString("exr_glicemia"))) {
            String glicemia = exa.getString("exr_glicemia").trim().replace(',', '.');
            this.gravaInformacaoComplementar("Glicemia", glicemia);
        }
        if (!Funcoes.textoVazio(exa.getString(PERIODO_GESTACIONAL))) {
            this.gravaInformacaoComplementar("SemanaGestacao", exa.getString(PERIODO_GESTACIONAL));
            this.gravaInformacaoComplementar("SexoColhedor", req.getString(PAC_SEXO));
        }
        if (!Funcoes.textoVazio(exa.getString(DATA_SINTOMA))) {
            String dataSintoma = !Funcoes.textoVazio(exa.getString(APRESENTOU_SINTOMA)) && exa.getString(APRESENTOU_SINTOMA).equalsIgnoreCase("Sim") ? Funcoes.formataData("dd/MM/yyyy", exa.getDate(DATA_SINTOMA)) : "";
            this.gravaInformacaoComplementar("DataSintoma", dataSintoma);
        }
        if (!Funcoes.textoVazio(exa.getString(MUNICIPIO_RESIDENCIA))) {
            this.gravaInformacaoComplementar("MunicipioResidencia", StringUtil.removerAcentos(exa.getString(MUNICIPIO_RESIDENCIA)));
        }
        if (!Funcoes.textoVazio(exa.getString(APRESENTOU_SINTOMA))) {
            String sintoma = exa.getString(APRESENTOU_SINTOMA).equals("Sim") ? "S" : "N";
            this.gravaInformacaoComplementar("Sintoma", sintoma);
        }
        if (!Funcoes.textoVazio(exa.getString("dadosAdicionais"))) {
            String[] dado = exa.getString("dadosAdicionais").replace("{", "").replace("}", "").split("=");
            this.gravaInformacaoComplementar(dado[0], dado[1]);
        }
        if ((infoComp = exa.getValor("infoComp", Map.class)) != null && !infoComp.isEmpty()) {
            for (String key : infoComp.keySet()) {
                this.gravaInformacaoComplementar(key, (String)infoComp.get(key));
            }
        }
        String tmp = obsRequisicao != null ? obsRequisicao : "";
        obs.append(StringUtil.removerAcentos(this.removerEnter(tmp)).replaceAll("\"", ""));
        if (obs.toString().trim().length() > 100) {
            tmp = obs.toString();
            obs = new StringBuilder();
            obs.setLength(0);
            obs.append(tmp.substring(0, 100));
        }
        if (!Funcoes.textoVazio(obs.toString())) {
            this.xml.escrever("Observacao", StringUtil.limpaXmlEnvioWebService(obs.toString()));
        }
        this.xml.fechar(TAG_EXAME);
    }

    private String removerEnter(String txt) {
        return txt.replaceAll("\n", " ");
    }

    private void gravaInformacaoComplementar(String infoComp, String valor) throws NumberFormatException, XMLStringBuilderException {
        this.xml.abrir("InformacaoComplementar");
        this.xml.escrever("InfoComp", infoComp);
        this.xml.escrever("Valor", valor);
        this.xml.fechar("InformacaoComplementar");
    }

    private void gerarXML(String numeroLote, String codigoConvenio, List<Registro> requisicoes, boolean isUtilizarHPDirect, boolean enviarDadosMedico, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.escrever(TAG_ABRIR_CDATA);
        this.xml.abrir(TAG_REGISTRO);
        this.xml.escrever(TAG_ID, numeroLote);
        this.xml.escrever(TAG_PROTOCOLO, "2");
        this.xml.abrir(TAG_LOTE);
        this.xml.escrever(TAG_COD_LAB, codigoConvenio);
        this.xml.escrever(TAG_COD_LOTE_LAB, numeroLote);
        this.xml.escrever(TAG_DATA_LOTE, Funcoes.formataData("yyyy-MM-dd", new Date()));
        this.xml.escrever(TAG_HORA_LOTE, Funcoes.formataData("HH:mm:ss", new Date()));
        List<Registro> requisicoesPais = ExportacaoParaMercolab.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        for (Registro req : requisicoesPais) {
            ArrayList<Registro> medicos = this.adicionaMedico(requisicoes, req);
            this.criarPedido(req, isUtilizarHPDirect, enviarDadosMedico, medicos, st, digitosTuboFilial, digitosTuboRequisicao, agruparGuiasInterface);
        }
        this.xml.fechar(TAG_LOTE);
        this.xml.fechar(TAG_REGISTRO);
        this.xml.escrever(TAG_FECHAR_CDATA);
    }

    private ArrayList<Registro> adicionaMedico(List<Registro> requisicoes, Registro requisicaoMae) {
        ArrayList<Registro> medicos = new ArrayList<Registro>();
        String reqMae = requisicaoMae.getString(REQ_CODIGO_MAE);
        for (Registro req : requisicoes) {
            if (!reqMae.equals(req.getString(REQ_CODIGO_MAE))) continue;
            Registro re = new Registro();
            re.setValor(FIL_CODIGO, req.getString(FIL_CODIGO));
            re.setValor("requisicao", req.getString(REQ_CODIGO));
            re.setValor("medicoCRM", req.getString(MED_NUMERO_CONSELHO));
            re.setValor("ufMedico", req.getString(MED_UF_CONSELHO));
            re.setValor("conselhoMedico", req.getString(MED_SIGLA_CONSELHO));
            re.setValor("nomeMedico", req.getString(MED_NOME));
            if (this.medicoJaAdicionado(medicos, re)) continue;
            medicos.add(re);
        }
        return medicos;
    }

    private boolean medicoJaAdicionado(ArrayList<Registro> listaMedicos, Registro med) {
        for (Registro medico : listaMedicos) {
            if (!medico.getString("medicoCRM").equalsIgnoreCase(med.getString("medicoCRM")) || !medico.getString("ufMedico").equalsIgnoreCase(med.getString("ufMedico"))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + labExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private boolean validarConfiguracao(String configuracaoLabExterno, boolean validaConexao, boolean isColetaWeb) {
        String enderecoWebService;
        boolean isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebService") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebService") : false;
        String idLaboratorio = configuracaoLabExterno.indexOf("idLaboratorio") > 0 ? StringUtil.getValor(configuracaoLabExterno, "idLaboratorio") : null;
        String senhaWebservice = configuracaoLabExterno.indexOf("senha") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
        String string = enderecoWebService = configuracaoLabExterno.indexOf("enderecoWebService") > 0 ? StringUtil.getValor(configuracaoLabExterno, "enderecoWebService") : null;
        if (isEnviarWebService) {
            if (Funcoes.textoVazio(idLaboratorio)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O ID para o laborat\u00f3rio Mercolab n\u00e3o foi configurado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(senhaWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A senha para o laborat\u00f3rio Mercolab n\u00e3o foi configurada.", 2);
                return false;
            }
            if (validaConexao && Funcoes.textoVazio(enderecoWebService)) {
                try {
                    if (!UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, Protocolo.MercolabWS.getDescricao()).isImprimiu()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
                    return false;
                }
            }
        }
        return true;
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(boolean isColetaWeb, String codigoLabExterno, String numeroLote, boolean reenvio, List<Registro> requisicoes, boolean isUtilizarHPDirect, Statement st, int digitosTuboFilial, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        ArrayList<Object> etiquetas;
        List<Object> list = etiquetas = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("mercolab") : new ArrayList<Object>();
        if (this.retornoMercolab.indexOf(TAG_PEDIDO) > -1) {
            String[] pedidos;
            for (String pedido : pedidos = StringUtil.getValores(this.retornoMercolab, TAG_PEDIDO)) {
                if (pedido.indexOf(TAG_RECIPIENTE) <= -1) continue;
                String filialRequisicao = StringUtil.getValor(pedido, TAG_COD_PED_LAB);
                String[] recipientes = StringUtil.getValores(pedido, TAG_RECIPIENTE);
                String filial = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
                String requisicao = StringUtil.removeZerosEsquerda(filialRequisicao.substring(digitosTuboFilial, filialRequisicao.length()));
                StringBuilder recipientesGravar = new StringBuilder();
                StringBuilder etiq = new StringBuilder();
                for (String recipiente : recipientes) {
                    if (!isUtilizarHPDirect && !Funcoes.textoVazio(recipiente)) {
                        String etiqueta = StringUtil.getValor(recipiente, TAG_ETIQ_COD_BAR);
                        etiq.append(etiqueta).append("\n");
                        String codigoTuboApoio = StringUtil.getValor(recipiente, TAG_COD_BAR_APOIO);
                        String[] examesRetorno = StringUtil.getValores(recipiente, TAG_EXAME);
                        String codigoMae = null;
                        for (Registro req : requisicoes) {
                            if (codigoMae == null || !codigoMae.equals(req.getString(REQ_CODIGO_MAE))) {
                                codigoMae = req.getString(REQ_CODIGO_MAE);
                            }
                            if (!req.getString(REQ_CODIGO).equalsIgnoreCase(requisicao) && !req.getString(REQ_CODIGO_MAE).equalsIgnoreCase(codigoMae) || !req.getString(FIL_CODIGO).equals(filial)) continue;
                            ArrayList exames = (ArrayList)req.getValor("listaexames");
                            for (String exameAlv : examesRetorno) {
                                String codigoExmApoio = StringUtil.getValor(exameAlv, TAG_COD_EXM_APOIO);
                                String[] exaRetorno = codigoExmApoio.split("\\|");
                                String exameRetorno = exaRetorno[0].trim();
                                for (Registro exa : exames) {
                                    ArrayList listaDesm = (ArrayList)exa.getValor("listaexames");
                                    if (listaDesm != null && !listaDesm.isEmpty()) {
                                        for (Registro desm : listaDesm) {
                                            String recJalis = this.getRecipiente(desm.getString(EXA_CODIGO), desm.getString(MCO_CODIGO), req.getString(REQ_CODIGO), filial, st);
                                            String exaMercolabDesm = desm.getString(CODIGO_EXAME);
                                            if (Funcoes.textoVazio(exaMercolabDesm)) {
                                                ExameMercolab exaMercolab = ExameMercolab.novaInstancia(desm.getString(ELE_XML_LAB_EXTERNO));
                                                exaMercolabDesm = exaMercolab.getCodigoExame();
                                            }
                                            if (!exaMercolabDesm.equalsIgnoreCase(exameRetorno)) continue;
                                            desm.setValor(REC_CODIGO, recJalis);
                                            desm.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                            if (!exa.nulo(TAG_COD_BAR_APOIO)) continue;
                                            exa.setValor(REC_CODIGO, recJalis);
                                            exa.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                        }
                                        continue;
                                    }
                                    String recJalis = this.getRecipiente(exa.getString(EXA_CODIGO), exa.getString(MCO_CODIGO), req.getString(REQ_CODIGO), filial, st);
                                    String exaMercolab = exa.getString(CODIGO_EXAME);
                                    if (Funcoes.textoVazio(exaMercolab)) {
                                        ExameMercolab exameMercolab = ExameMercolab.novaInstancia(exa.getString(ELE_XML_LAB_EXTERNO));
                                        exaMercolab = exameMercolab.getCodigoExame();
                                    }
                                    if (!exaMercolab.equalsIgnoreCase(exameRetorno)) continue;
                                    exa.setValor(REC_CODIGO, recJalis);
                                    exa.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                }
                            }
                        }
                    }
                    if (recipientesGravar.toString().contains(pedido)) continue;
                    recipientesGravar.append("<Pedido>");
                    recipientesGravar.append(pedido);
                    recipientesGravar.append("</Pedido>");
                }
                if (!recipientesGravar.toString().isEmpty()) {
                    arquivar.call();
                    for (Registro req : requisicoes) {
                        if (!req.getString(FIL_CODIGO).equalsIgnoreCase(filial) || !req.getString(REQ_CODIGO).equalsIgnoreCase(requisicao) && !req.getString(REQ_CODIGO_MAE).equalsIgnoreCase(requisicao)) continue;
                        StringBuilder sqlpdate = new StringBuilder();
                        String lote = !reenvio ? req.getString("novoLote") : numeroLote;
                        sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(recipientesGravar.toString())).append("'");
                        sqlpdate.append(" , leq_codigoreqapoio = '").append(StringUtil.getValor(pedido, TAG_COD_PED_APOIO)).append("'");
                        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
                        sqlpdate.append(" and req_codigo = ").append(req.getString(REQ_CODIGO));
                        sqlpdate.append(" and fil_kodigo = ").append(filial);
                        sqlpdate.append(" and lex_codigo = ").append(lote);
                        st.executeUpdate(sqlpdate.toString());
                        if (isColetaWeb || filial.equals(Variaveis.filialPadrao) && !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W")) continue;
                        IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
                    }
                    recipientesGravar.setLength(0);
                }
                this.atualizaCodigoApoiadoExameRequisicao(st, requisicoes, isColetaWeb, arquivar, anular);
                PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais));
                etiquetas.add(ImpressaoTermica.imprimirDireto(service, etiq.toString(), true, st, isColetaWeb, arquivar, anular));
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("mercolab") : new ArrayList();
        etiquetas.addAll(etq);
        etiquetasLab.put("mercolab", etiquetas);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        return retorno;
    }

    private String getRecipiente(String exaJalis, String matJalis, String requisicao, String filial, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append("select rec_kodigo from examerequisicaorecipiente ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(requisicao);
        buf.append("   and mco_codigo = ").append(matJalis);
        buf.append("   and exa_codigo = '").append(exaJalis).append("' ");
        buf.append("   and ere_codigoapoiado is null ");
        buf.append(" limit 1 ");
        ResultSet rs = null;
        try {
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                return rs.getString(REC_KODIGO);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void atualizaCodigoApoiadoExameRequisicao(Statement st, List<Registro> requisicoes, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        for (Registro req : requisicoes) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            try {
                for (Registro exa : exames) {
                    sql.setLength(0);
                    sql.append(" select exr_codigoapoiado from examerequisicao  ");
                    sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                    sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                    sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                    sql.append(" and exr_codigoapoiado is null ");
                    ResultSet rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        sql.setLength(0);
                        sql.append(" update  examerequisicao set exr_codigoapoiado = ").append(!Funcoes.textoVazio(exa.getString(TAG_COD_BAR_APOIO)) ? exa.getString(TAG_COD_BAR_APOIO) : "''");
                        sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                        sql.append("   and req_codigo = ").append(req.getString(REQ_CODIGO));
                        sql.append("   and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                        if (isColetaWeb) {
                            st.executeUpdate(sql.toString());
                        } else {
                            Conexao.executeUpdate(req.getString(FIL_CODIGO), st, sql);
                        }
                    }
                    sql.setLength(0);
                    sql.append(" select ere_codigoapoiado from examerequisicaorecipiente ");
                    sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                    sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                    sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                    sql.append(" and ere_codigoapoiado is null ");
                    rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        sql.setLength(0);
                        sql.append(" update  examerequisicaorecipiente set ere_codigoapoiado = ").append(!Funcoes.textoVazio(exa.getString(TAG_COD_BAR_APOIO)) ? exa.getString(TAG_COD_BAR_APOIO) : "''");
                        sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                        sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                        sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                        sql.append(" and mco_codigo = ").append(exa.getString(MCO_CODIGO));
                        if (isColetaWeb) {
                            st.executeUpdate(sql.toString());
                        } else {
                            Conexao.executeUpdate(req.getString(FIL_CODIGO), st, sql);
                        }
                    }
                    arquivar.call();
                }
            }
            catch (Exception e) {
                block12: {
                    try {
                        anular.call();
                    }
                    catch (Exception e1) {
                        if (isColetaWeb) break block12;
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
                if (isColetaWeb) continue;
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetaMercolab(String filial, String requisicao, LaboratorioExterno labExterno, String[] exames, int[] materiais, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, RetornoImpressaoEtiquetas retornoEtq, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        ArrayList<Object> etqs = new ArrayList<Object>();
        Integer[] multiguias = null;
        String etiqueta = "";
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        try {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi recuperar as requisi\u00e7\u00f5es multiguia\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno != null && !Funcoes.textoVazio(requisicao)) {
            try {
                String retorno = this.dao.pesquisarEtiquetaPorRequisicao(filial, multiguias, exames, materiais, st);
                String[] etiquetas = StringUtil.getValores(retorno, TAG_ETIQ_COD_BAR);
                etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
                etqs.add(termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retornoEtq.getEtiquetasLabExterno() != null && !retornoEtq.getEtiquetasLabExterno().isEmpty() ? retornoEtq.getEtiquetasLabExterno().get("mercolab") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("mercolab", etqs);
        retornoEtq.setEtiquetasLabExterno(etiquetasLab);
        return retornoEtq;
    }

    private ArrayList<String> removeEtiquetaDuplicada(String[] etiquetas) {
        ArrayList<String> novaEtiqueta = new ArrayList<String>();
        for (String etq : etiquetas) {
            if (novaEtiqueta.contains(etq)) continue;
            novaEtiqueta.add(etq);
        }
        return novaEtiqueta;
    }

    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        SplashMensagem splash = null;
        if (!isColetaWeb) {
            splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Aguarde enquanto comunicamos com o Laborat\u00f3rio Mercolab");
        }
        MercolabService serviceMercolab = new MercolabService();
        retorno = serviceMercolab.estornarExame(numeroLote, requisicoes, labSelecionado, agruparMultiguia, st, isColetaWeb, arquivar, anular, agruparInterface, login, digitosTuboFilial, digitosTuboRequisicao);
        if (!isColetaWeb) {
            splash.apagar();
        }
        if (retorno.isSucesso()) {
            retorno = super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
            arquivar.call();
        }
        return retorno;
    }
}

