/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialMaricondi;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaHPardini;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.parsers.maricondi.ExameMaricondi;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class ExportacaoParaMaricondi
extends ExportacaoParaHPardini {
    public static final String TAG_UTILIZAR_MAT_REQUISICAO = "utilizar-mat-requisicao";
    public static final String TAG_MATERIAL_SELECIONADO = "material-selecionado";
    public static final String TAG_CONSERVANTE_SELECIONADO = "conservante-selecionado";
    private XMLStringBuilder xml = new XMLStringBuilder(true);

    public boolean exportarExames(String codigoLabExterno, String numeroLote, String codigoConvenio, String adicionalLote, String configuracaoLabExterno, boolean naoEnviarObsRequisicao, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) {
        return this.processa(codigoLabExterno, numeroLote, codigoConvenio, adicionalLote, configuracaoLabExterno, naoEnviarObsRequisicao, reenvio, requisicoes, colunaOrdenacao, st, agruparGuiasInterface, digitosTuboFilial, isColetaWeb, arquivar, agruparInterface);
    }

    private boolean processa(String codigoLabExterno, String numeroLote, String codigoConvenio, String adicionalLote, String configuracaoLabExterno, boolean naoEnviarObsRequisicao, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        for (Registro requisicao : requisicoes) {
            lista.add(requisicao.clone());
        }
        try {
            for (Registro registro : requisicoes) {
                ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
                ArrayList<String> listExa = new ArrayList<String>();
                int[] arrayMat = new int[listaExames.size()];
                for (Registro exa : listaExames) {
                    listExa.add(exa.getString("exa_codigo"));
                    arrayMat[listExa.size() - 1] = Integer.parseInt(exa.getString("mco_codigo"));
                }
                String[] stringArray = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
            }
            this.gerarXML(numeroLote, codigoConvenio, adicionalLote, requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
            this.gerarArquivo(this.xml.getXML(), new File("remessa_" + numeroLote + Funcoes.formataData("_yyyyMMdd", new Date()) + ".xml"), reenvio, "Arquivo de exporta\u00e7\u00e3o Maricondi (*.xml)");
            return true;
        }
        catch (Exception ex) {
            try {
                if (!reenvio) {
                    ExportacaoParaMaricondi.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ex.getMessage() != null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), ex.getMessage(), 2);
            }
            return false;
        }
    }

    private void gerarXML(String numeroLote, String codigoConvenio, String adicionalLote, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial) throws XMLStringBuilderException, ParseException {
        this.xml.escreveHeader("1.0", "UTF-8");
        this.xml.abrir("Registro");
        this.xml.escrever("Protocolo", "2");
        this.xml.escrever("ID", numeroLote);
        this.xml.abrir("Lote");
        this.xml.escrever("CodLab", codigoConvenio);
        this.xml.escrever("CodLoteLab", (!Funcoes.textoVazio(adicionalLote) ? adicionalLote : "") + numeroLote);
        this.xml.escrever("DataLote", Funcoes.formataData("yyyy-MM-dd", new Date()));
        this.xml.escrever("HoraLote", Funcoes.formataData("HH:mm:ss", new Date()));
        requisicoes = ExportacaoParaMaricondi.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        for (Registro req : requisicoes) {
            this.criarPedido(req);
        }
        this.xml.fechar("Lote");
        this.xml.fechar("Registro");
    }

    private void criarPedido(Registro req) throws XMLStringBuilderException, ParseException {
        this.xml.abrir("Pedido");
        this.xml.escrever("CodPedLab", Funcoes.preencheZero(req.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
        this.xml.escrever("DataPed", this.formatar("yyyy-MM-dd", req.getDate("req_data")));
        this.xml.escrever("HoraPed", this.formatar("HH:mm:ss", req.getDate("req_hora")));
        this.xml.abrir("Paciente");
        this.xml.escrever("CodPacLab", req.getString("pac_codigo"));
        this.xml.escrever("Nome", StringUtil.limpaXmlEnvioWebService(req.getString("pac_nome")));
        this.xml.escrever("Sexo", this.getSexo(req.getString("pac_sexo")));
        if (req.nulo("pac_datanasc")) {
            this.xml.escrever(this.getTagIdadePaciente(req), req.getString("req_idade"));
        } else {
            this.xml.escrever("DataNasc", Funcoes.formataData("yyyy-MM-dd", req.getDate("pac_datanasc")));
        }
        this.xml.fechar("Paciente");
        List listaExames = (List)req.getValor("listaexames");
        Map<ExameMaterialMaricondi, Integer> exaMaricondi = null;
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        for (Registro exa : listaExames) {
            String key = exa.getString("exa_codigo") + exa.getString("mco_codigo");
            if (listaExamesAdicionados.contains(key)) continue;
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (listaExamesDesmembrados != null && listaExamesDesmembrados.size() > 0) {
                for (Registro desm : listaExamesDesmembrados) {
                    exaMaricondi = this.carregarExamesMaricondi(listaExamesDesmembrados);
                    key = desm.getString("exa_codigo") + desm.getString("mco_codigo");
                    if (listaExamesAdicionados.contains(key)) continue;
                    this.gravarDadosExame(desm, exaMaricondi, req);
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            exaMaricondi = this.carregarExamesMaricondi(listaExames);
            this.gravarDadosExame(exa, exaMaricondi, req);
            listaExamesAdicionados.add(key);
        }
        this.xml.fechar("Pedido");
    }

    private void gravarDadosExame(Registro exa, Map<ExameMaterialMaricondi, Integer> exaMaricondi, Registro req) throws XMLStringBuilderException, ParseException {
        String codigoNumericoExame = ExportacaoParaMaricondi.getCodigoExameImportado(exa.getString("fil_codigo"), exa.getString("codigoExame"));
        if (!Funcoes.textoVazio(codigoNumericoExame)) {
            codigoNumericoExame = Funcoes.preencheZero(codigoNumericoExame, 4);
        }
        this.xml.abrir("Exame");
        ExameMaterialMaricondi exaMat = new ExameMaterialMaricondi(exa.getString("codigoExame"), exa.getString("codigoMaterial"));
        this.xml.escrever("CodExmApoio", exaMat.material + "|" + codigoNumericoExame + "|" + (exaMaricondi.get(exaMat) + 1));
        this.xml.escrever("CodExmLab", exa.getString("exa_codigo") + "|" + exa.getString("mco_codigo"));
        this.xml.escrever("DescMat", exa.getString("DescMat"));
        exaMaricondi.put(exaMat, exaMaricondi.get(exaMat) + 1);
        if (exaMat.material.equalsIgnoreCase("DIV") && exa.getBoolean(TAG_UTILIZAR_MAT_REQUISICAO)) {
            this.xml.escrever("DescMat", Funcoes.textoVazio(exa.getString("exr_descricaomaterial")) ? StringUtil.limpaXmlEnvioWebService(exa.getString("mco_descricao")) : StringUtil.limpaXmlEnvioWebService(exa.getString("exr_descricaomaterial")));
        } else if (!Funcoes.textoVazio(exa.getString(TAG_MATERIAL_SELECIONADO))) {
            this.xml.escrever("DescMat", StringUtil.limpaXmlEnvioWebService(exa.getString(TAG_MATERIAL_SELECIONADO)));
            this.xml.escrever("Conservante", exa.getString(TAG_CONSERVANTE_SELECIONADO));
        }
        this.xml.escrever("DataColeta", this.formatar("yyyy-MM-dd", exa.getDate("exr_datamaterial")));
        this.xml.escrever("HoraColeta", this.formatar("HH:mm:ss", exa.getDate("exr_datamaterial")));
        this.xml.fechar("Exame");
    }

    protected Map<ExameMaterialMaricondi, Integer> carregarExamesMaricondi(List<Registro> exames) {
        HashMap<ExameMaterialMaricondi, Integer> map = new HashMap<ExameMaterialMaricondi, Integer>();
        for (Registro exa : exames) {
            ExameMaricondi em = ExameMaricondi.novaInstancia(exa.getString("ele_xmllabexterno"));
            if (em == null) continue;
            exa.setValor("codigoExame", em.getMnemonicoExame());
            exa.setValor("codigoMaterial", em.getMaterial());
            exa.setValor("DescMat", em.getTubo());
            map.put(new ExameMaterialMaricondi(em.getMnemonicoExame(), em.getMaterial()), 0);
        }
        return map;
    }

    public static String getCodigoExameImportado(String filial, String exame) {
        String codigoExame = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select mar_codexamenumerico \n");
                bui.append("   from examesmatrix \n");
                bui.append("  where fil_codigo = ").append(filial).append(" and \n");
                bui.append("  mar_codexame = '").append(exame).append("'");
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    codigoExame = res.getString("mar_codexamenumerico");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return codigoExame;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }
}

