/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.EscreverXML;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaroService;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.print.PrintService;
import javax.swing.JFileChooser;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Element;

public class ExportacaoParaJalisWS
extends ExportacaoParaAlvaro {
    private static final int REQ_GUIA_MAE = 0;
    private static final int REQ_GUIA_FILHA = 1;
    private boolean enviarTuboLis = false;
    private String codigoTuboLis = "";
    private String senhaweb;
    private String convenio;
    private String enderecoWebService = "";

    public ExportacaoParaJalisWS() {
        this.setDescricao("Arquivo de exporta\u00e7\u00e3o Jalis WS (*.xml)");
    }

    public ExportacaoParaJalisWS(String descricao) {
        this.setDescricao(descricao);
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressora, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        boolean bl = this.enviarTuboLis = StringUtil.getValor(configuracaoLabExterno, "enviarTuboLis").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarTuboLis");
        if (this.enviarTuboLis) {
            this.codigoTuboLis = StringUtil.getValor(configuracaoLabExterno, "codigoTuboLis");
        }
        List<Registro> novaLista = IntegracaoLabExterno.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        this.convenio = StringUtil.getValor(configuracaoLabExterno, "codigo");
        this.senhaweb = StringUtil.getValor(configuracaoLabExterno, "chave");
        return this.exportarExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, novaLista, colunaOrdenacao, true, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressora, arquivar, anular);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, boolean gravaRetornoPorRequisicao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressora, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String nomeXml = "remessa_" + numeroLote + ".xml";
        List<Object> requisicoes = new ArrayList();
        ArrayList<Registro> requisicoesJaEnviadas = new ArrayList<Registro>();
        HashSet<String> pac = new HashSet<String>();
        HashSet<String> medicos = new HashSet<String>();
        this.configuracaoLabExterno = configuracaoLabExterno;
        this.agente = StringUtil.getValor(configuracaoLabExterno, "codigo");
        this.senha = StringUtil.getValor(configuracaoLabExterno, "chave");
        this.enderecoWebService = StringUtil.getValor(configuracaoLabExterno, "enderecoWebService");
        this.enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
        this.isEnviarRequisicaoWebService = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
        if (reenvio || !this.enviarUsandoWS) {
            requisicoes = requisicoesListaOriginal;
        } else {
            for (Registro requisicao : requisicoesListaOriginal) {
                if (!Funcoes.textoVazio(requisicao.getString("metodoEnvio")) && requisicao.getString("metodoEnvio").equalsIgnoreCase("PUT")) {
                    requisicoes.add(requisicao);
                    continue;
                }
                if (Funcoes.textoVazio(requisicao.getString("metodoEnvio")) || !requisicao.getString("metodoEnvio").equalsIgnoreCase("POST")) continue;
                requisicoesJaEnviadas.add(requisicao);
            }
        }
        try {
            void var40_48;
            if (!this.validarExames(requisicoes)) {
                retorno.setImprimiu(false);
                return retorno;
            }
            List<Registro> reqsTemp = new ArrayList<Registro>();
            ArrayList<Registro> examesTemp = new ArrayList<Registro>();
            for (Registro registro : requisicoesJaEnviadas) {
                List list = (List)registro.getValor("listaexames");
                examesTemp = new ArrayList();
                for (Registro exa : list) {
                    if (!exa.getBoolean("exameNovo")) continue;
                    examesTemp.add(exa);
                }
                if (examesTemp.isEmpty()) continue;
                registro.setValor("listaexames", examesTemp);
                reqsTemp.add(registro);
            }
            ArrayList<Registro> listaBackup = new ArrayList<Registro>();
            if (!requisicoes.isEmpty()) {
                for (Registro registro : requisicoes) {
                    listaBackup.add(registro.clone());
                }
            } else if (!requisicoesJaEnviadas.isEmpty()) {
                for (Registro registro : reqsTemp) {
                    listaBackup.add(registro.clone());
                }
            }
            requisicoes = ExportacaoParaJalisWS.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
            reqsTemp = ExportacaoParaJalisWS.agruparMutiguia(reqsTemp, st, agruparGuiasInterface, digitosTuboFilial);
            arquivar.call();
            File file = new File(System.getProperty("user.home") + File.separatorChar + nomeXml);
            if (!this.enviarUsandoWS && !isColetaWeb) {
                File file2 = new File(nomeXml);
                JFileChooser jFileChooser = this.gerarArquivo(null, file2, reenvio, "Arquivo de exporta\u00e7\u00e3o \u00c1lvaro (*.xml)");
                int option = jFileChooser.showOpenDialog(null);
                if (option != 0) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                this.xml = new EscreverXML(jFileChooser.getSelectedFile().getPath());
            } else {
                this.xml = new EscreverXML(file.getPath());
            }
            if (requisicoes != null && !requisicoes.isEmpty()) {
                this.geraXmlLote(codLabExterno, configuracaoLabExterno, requisicoes, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, false, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
            }
            boolean bl = false;
            if (requisicoes != null && !requisicoes.isEmpty() && this.enviarUsandoWS) {
                if (requisicoes.isEmpty()) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                String tipoRequest = "PUT";
                if (configuracaoLabExterno.contains("<jalisWS>")) {
                    tipoRequest = "POST";
                }
                retorno = this.enviarLoteParaWebService(isColetaWeb, this.enderecoWebService, this.enviarUsandoWS, (File)var40_48, codLabExterno, requisicoes, listaBackup, numeroLote, tipoRequest, gravaRetornoPorRequisicao, reenvio, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, tipoIntegracao, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressora, agruparInterface, arquivar, anular);
                boolean bl2 = retorno.isImprimiu();
                if (!reenvio && !bl2) {
                    ExportacaoParaJalisWS.removerLote(codLabExterno, listaBackup, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                    retorno.setImprimiu(false);
                    return retorno;
                }
            }
            if (!this.enviarUsandoWS && isColetaWeb) {
                retorno.setNomeArquivoLote(nomeXml);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb((File)var40_48));
                retorno.setExtensaoArquivo("xml");
            }
            if (requisicoesJaEnviadas != null && !requisicoesJaEnviadas.isEmpty() && this.enviarUsandoWS) {
                this.xml = new EscreverXML(var40_48.getPath());
                if (requisicoesJaEnviadas.isEmpty()) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                this.geraXmlLote(codLabExterno, configuracaoLabExterno, requisicoesJaEnviadas, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, true, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
                retorno = this.enviarLoteParaWebService(isColetaWeb, this.enderecoWebService, this.enviarUsandoWS, (File)var40_48, codLabExterno, requisicoesJaEnviadas, listaBackup, numeroLote, "POST", gravaRetornoPorRequisicao, reenvio, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, tipoIntegracao, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressora, agruparInterface, arquivar, anular);
                boolean bl3 = retorno.isImprimiu();
                if (!reenvio && !bl3) {
                    ExportacaoParaJalisWS.removerLote(codLabExterno, listaBackup, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (ParseException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaJalisWS: 230");
        }
        catch (Exception ex) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaJalisWS: 236");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoImpressaoEtiquetas enviarLoteParaWebService(boolean isColetaWeb, String enderecoWebService, Boolean enviarLoteWebService, File arquivo, String codLabExterno, List<Registro> requisicoes, List<Registro> requisicoesOriginal, String numeroLote, String metod, boolean gravaRetornoPorRequisicao, boolean reenvio, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, String tipoIntegracao, boolean agruparGuiasInterface, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (enviarLoteWebService.booleanValue()) {
            File xmlGerado = arquivo;
            Scanner scanner = new Scanner(xmlGerado);
            HttpURLConnection urlConnection = null;
            try {
                retorno = UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, Protocolo.JalisWS.getDescricao());
                if (retorno.isImprimiu()) {
                    String conteudoGerado = "";
                    while (scanner.hasNext()) {
                        conteudoGerado = conteudoGerado + scanner.nextLine();
                    }
                    if (!super.validaXml(conteudoGerado, isColetaWeb)) {
                        retorno.setImprimiu(false);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    if (enderecoWebService.contains("https")) {
                        sc.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    }
                    enderecoWebService = enderecoWebService.concat("/enviarsolicitacoes");
                    CloseableHttpClient client = HttpClients.custom().build();
                    HttpUriRequest request = RequestBuilder.post((String)enderecoWebService).addParameter("codigo", this.convenio).addParameter("chave", this.senhaweb).addParameter("lote", conteudoGerado.toString()).setCharset(Charset.forName("UTF-8")).build();
                    if (this.debug) {
                        System.out.println("=====XML ENVIO=====");
                        System.out.println(conteudoGerado);
                    }
                    String retornoWebService = "";
                    CloseableHttpResponse response = client.execute(request);
                    if (null == response || response.getStatusLine().getStatusCode() != 200) {
                        String mensagem = "";
                        switch (response.getStatusLine().getStatusCode()) {
                            case 204: {
                                mensagem = "Paciente n\u00e3o localizado.";
                                break;
                            }
                            case 411: {
                                mensagem = "Nome do paciente muito longo.";
                                break;
                            }
                            case 406: {
                                mensagem = "RG do paciente muito longo.";
                                break;
                            }
                            case 206: {
                                mensagem = "Exame n\u00e3o localizado.";
                                break;
                            }
                            case 404: {
                                mensagem = "C\u00f3digo da requisicao Web n\u00e3o localizado.";
                                break;
                            }
                            case 400: {
                                mensagem = "Exame n\u00e3o identificado ou relacionamento n\u00e3o foi encontrado no sistema.";
                                break;
                            }
                            case 401: {
                                mensagem = "Acesso n\u00e3o autorizado.";
                                break;
                            }
                            case 412: {
                                mensagem = "Par\u00e2metros incorretos.";
                                break;
                            }
                            case 417: {
                                mensagem = "Solicita\u00e7\u00e3o n\u00e3o foi encontrada.";
                                break;
                            }
                            case 409: {
                                mensagem = "Exames repetidos... Este exame j\u00e1 foi encaminhado para solicita\u00e7\u00e3o.";
                                break;
                            }
                            default: {
                                mensagem = "Erro ao criar Lote.";
                            }
                        }
                        String texto = "N\u00e3o foi possivel obter conex\u00e3o com WebService.\nVerifique usu\u00e1rio e senha das configura\u00e7\u00f5es do Laborat\u00f3rio externo.";
                        if (!isColetaWeb) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
                            Funcoes.mensagem(Laboratorio.getInstancia(), texto, 2);
                        } else {
                            UtilExportadores.adicionarMensagemRetorno(mensagem + "<br>" + texto, "Jalis WS", retorno);
                        }
                        retorno.setImprimiu(false);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    retornoWebService = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (!Funcoes.textoVazio(retornoWebService)) {
                        if (this.debug) {
                            System.out.println("=====XML RETORNO=====");
                            System.out.println(retornoWebService);
                        }
                        if (retornoWebService.contains("ID ou Senha incorreta")) {
                            if (!isColetaWeb) {
                                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel obter conex\u00e3o com WebService.\nVerifique usu\u00e1rio e senha das configura\u00e7\u00f5es do Laborat\u00f3rio externo.", 2);
                            }
                            UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi possivel obter conex\u00e3o com WebService.<br>Verifique usu\u00e1rio e senha das configura\u00e7\u00f5es do Laborat\u00f3rio externo.", "Jalis WS", retorno);
                            retorno.setImprimiu(false);
                            RetornoImpressaoEtiquetas mensagem = retorno;
                            return mensagem;
                        }
                        StringBuilder erro = new StringBuilder();
                        ArrayList<Registro> requisicoesRejeitadas = this.processaRetornoWebServiceInsercao(codLabExterno, retornoWebService, erro, numeroLote, gravaRetornoPorRequisicao, requisicoesOriginal, requisicoes, reenvio, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressoras, agruparInterface, retorno, arquivar, anular).getRegistros();
                        this.tratarRejeitados(codLabExterno, numeroLote, reenvio, conteudoGerado, retornoWebService, erro, requisicoesRejeitadas, requisicoes, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, arquivar, agruparInterface, retorno);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    retorno.setImprimiu(false);
                    RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                    return retornoImpressaoEtiquetas;
                }
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas conteudoGerado = retorno;
                return conteudoGerado;
            }
            catch (Exception e) {
                if (!isColetaWeb) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar xml do lote.\n" + e.getMessage(), e.getStackTrace());
                }
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel enviar xml do lote.<br>" + e.getMessage(), "Jalis WS", retorno);
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                return retornoImpressaoEtiquetas;
            }
            finally {
                scanner.close();
                xmlGerado.delete();
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    public RetornoImpressaoEtiquetas processaRetornoWebServiceInsercao(String codLabExterno, String retornoWebService, StringBuilder erro, String numeroLote, boolean gravaRetornoPorRequisicao, List<Registro> requisicoesOriginal, List<Registro> requisicoes, boolean reenvio, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, boolean agruparGuiasInterface, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        ArrayList<Object> etqs = new ArrayList<Object>();
        if (!retornoWebService.startsWith("<?xml")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Mensagem inv\u00e1lida retornada pelo WebService do laborat\u00f3rio \u00c1lvaro.\nAcesse o site do laborat\u00f3rio de apoio e verifique a situa\u00e7\u00e3o do lote.", 2);
            return null;
        }
        List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService, "solicitacao", false);
        int qtDigitosTubo = digitosTuboFilial + digitosTuboRequisicao + digitosTuboTubo;
        ArrayList<String> chaves = new ArrayList<String>();
        HashMap mapRequisicoesExamesExcluidos = new HashMap();
        ArrayList<Registro> requisicoesRejeitadas = new ArrayList<Registro>(){

            @Override
            public boolean add(Registro a) {
                boolean isExiste = false;
                if (a != null) {
                    for (Registro b : this) {
                        if (!a.getString("fil_codigo").equals(b.getString("fil_codigo")) || !a.getString("req_codigo").equals(b.getString("req_codigo"))) continue;
                        isExiste = true;
                        break;
                    }
                    if (isExiste) {
                        return false;
                    }
                    return super.add(a);
                }
                return false;
            }
        };
        block0: for (String solicitacao : solicitacoes) {
            Object chave;
            Object identificacao;
            String incluido;
            Iterator idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
            String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
            String filial = null;
            String requisicao = null;
            if (!Funcoes.textoVazio((String)((Object)idLis))) {
                filial = StringUtil.removeZerosEsquerda(((String)((Object)idLis)).substring(0, digitosTuboFilial));
                requisicao = StringUtil.removeZerosEsquerda(((String)((Object)idLis)).substring(digitosTuboFilial, ((String)((Object)idLis)).length()));
            }
            if (!Funcoes.textoVazio(incluido = this.obterAtributoTagInformacao(solicitacao, "incluido")) && !StringUtil.getBoolean(incluido)) {
                this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, (String)((Object)idLis), solicitacao, digitosTuboFilial, digitosTuboRequisicao);
                continue;
            }
            ArrayList<String> listaAmostrasIncluidas = new ArrayList<String>();
            HashMap<Object, String> mapAmostras = new HashMap<Object, String>();
            List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
            for (String amostra : amostras) {
                String idAmostra = this.obterAtributoTagInformacao(amostra, "idAmostra");
                String material = this.obterAtributoTagInformacao(amostra, "material");
                identificacao = this.obterAtributoTagInformacao(amostra, "identificacao");
                if (Funcoes.textoVazio((String)identificacao)) {
                    identificacao = idLis;
                }
                if (Funcoes.textoVazio((String)identificacao)) {
                    identificacao = idLis;
                }
                if (!Funcoes.isNumeric(identificacao)) {
                    mapAmostras.put(idLis, amostra);
                    continue;
                }
                filial = StringUtil.removeZerosEsquerda(((String)identificacao).substring(0, digitosTuboFilial));
                requisicao = StringUtil.removeZerosEsquerda(((String)identificacao).substring(digitosTuboFilial, ((String)identificacao).length() - digitosTuboTubo));
                List<Element> filhos = this.obterAtributosTagInformacao(amostra);
                for (Element tagFilho : filhos) {
                    if (Funcoes.textoVazio(tagFilho.getAttribute("incluido")) || StringUtil.getBoolean(tagFilho.getAttribute("incluido")) || mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(((String)identificacao).concat(tagFilho.getAttribute("codigo")), amostra);
                }
                if (!Funcoes.textoVazio(this.obterAtributoTagInformacao(amostra, "incluido")) && !StringUtil.getBoolean(this.obterAtributoTagInformacao(amostra, "incluido"))) {
                    if (mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(identificacao, amostra);
                    continue;
                }
                for (Element tagFilho : filhos) {
                    chave = ((String)identificacao).concat(tagFilho.getAttribute("codigo"));
                    if (!mapAmostras.containsKey(chave)) continue;
                    mapAmostras.remove(chave);
                }
                List<Element> exames = this.obterAtributosTagInformacao(amostra);
                if (!this.enviarUsandoWS) continue;
                listaAmostrasIncluidas.add(amostra);
            }
            if (!mapAmostras.isEmpty()) {
                for (String key : mapAmostras.keySet()) {
                    String amostra = (String)mapAmostras.get(key);
                    String informacao = this.obterAtributoTagInformacao(amostra, "informacao");
                    if (!Funcoes.textoVazio(informacao)) {
                        erro.append(informacao).append("\n");
                    }
                    if (Funcoes.isNumeric((String)(identificacao = this.obterAtributoTagInformacao(amostra, "identificacao")))) {
                        DescritorCodigoEtiqueta descritor;
                        String descricao = this.obterAtributoTagInformacao(amostra, "descricao");
                        String material = this.obterAtributoTagInformacao(amostra, "material");
                        if (((String)identificacao).length() >= qtDigitosTubo && (descritor = DescritorCodigoEtiqueta.getDescritor((String)identificacao)) != null) {
                            erro.append("Amostra (Tubo): ").append(descritor.getTubo());
                        }
                        erro.append(" " + descricao + " ").append(" do material: ").append(material).append(" com identifica\u00e7\u00e3o: ").append((String)identificacao);
                        List<Element> exames = this.obterAtributosTagInformacao(amostra);
                        chave = exames.iterator();
                        while (chave.hasNext()) {
                            Element exame = (Element)chave.next();
                            filial = StringUtil.removeZerosEsquerda(((String)identificacao).substring(0, digitosTuboFilial));
                            requisicao = this.getCodigoRequisicao(qtDigitosTubo, (String)identificacao, digitosTuboFilial, digitosTuboTubo);
                            this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, requisicao, digitosTuboFilial, digitosTuboRequisicao);
                            String chave2 = filial + requisicao;
                            if (Funcoes.textoVazio(exame.getAttribute("codigo")) || StringUtil.getBoolean(exame.getAttribute("incluido"))) continue;
                            erro.append("\n");
                            erro.append("Exame: ").append(exame.getAttribute("codigo")).append(" n\u00e3o foi incluido, informa\u00e7\u00e3o: ").append(exame.getAttribute("informacao")).append(" Material: ").append(material);
                            if (!mapRequisicoesExamesExcluidos.containsKey(chave2)) {
                                mapRequisicoesExamesExcluidos.put(chave2, new ArrayList());
                            }
                            ((ArrayList)mapRequisicoesExamesExcluidos.get(chave2)).add(exame);
                        }
                        continue;
                    }
                    if (erro.indexOf((String)((Object)idLis)) <= -1) {
                        erro.append(" Requisic\u00e3o: " + idLis + " - ").append(((String)identificacao).trim()).append("\n ");
                    }
                    this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, key, digitosTuboFilial, digitosTuboRequisicao);
                }
            }
            if (solicitacao.isEmpty()) continue;
            String novaSolicitacao = solicitacao;
            int contador = 0;
            for (String amostra : listaAmostrasIncluidas) {
                identificacao = this.obterAtributoTagInformacao(amostra, "identificacao");
                if (Funcoes.textoVazio(identificacao)) {
                    identificacao = idLis;
                }
                filial = StringUtil.removeZerosEsquerda(((String)identificacao).substring(0, digitosTuboFilial));
                requisicao = this.getCodigoRequisicao(qtDigitosTubo, (String)identificacao, digitosTuboFilial, digitosTuboTubo);
                String codigoLote = " ";
                boolean proximaAmostra = false;
                for (Registro reg : requisicoes) {
                    Integer[] guias = RecepcaoUtil.verificaMultiGuias(st, filial, reg.getString("req_codigo"), true, false);
                    String guia = StringUtil.implode(Arrays.asList(guias), ",");
                    ArrayList listaExames = (ArrayList)reg.getValor("listaexames");
                    if (!reg.getString("fil_codigo").equals(filial) || !guia.contains(requisicao)) continue;
                    boolean isLoteEstornado = UtilExportadores.verificaEstornoLote(reg, st);
                    String rw = UtilExportadores.retornoWs(reg, codLabExterno, reg.getString("lex_codigo"), st);
                    List<String> examesAmostra = StringUtil.getListValoresTagAberta(amostra, "exame", false);
                    boolean temLote = !isLoteEstornado && !Funcoes.textoVazio(rw);
                    String chave3 = reg.getString("fil_codigo") + reg.getString("req_codigo");
                    if (chaves.contains(chave3)) continue;
                    chaves.add(chave3);
                    if (!reenvio && temLote) {
                        for (Registro exa : listaExames) {
                            ArrayList examesDesm = (ArrayList)exa.getValor("listaexames");
                            if (examesDesm != null && !examesDesm.isEmpty()) {
                                for (Registro exaDesm : examesDesm) {
                                    ExameAlvaro codigoAlvReq = new ExameAlvaro(exaDesm.getString("ele_xmllabexterno"));
                                    for (String exame : examesAmostra) {
                                        String exameAlvaro = StringUtil.getValor(exame, "exame");
                                        if (!Funcoes.textoVazio(exameAlvaro) || codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) continue;
                                        novaSolicitacao = StringUtil.replaceBuilder(novaSolicitacao, amostra, "");
                                        proximaAmostra = listaAmostrasIncluidas.size() - ++contador != examesDesm.size();
                                    }
                                }
                                continue;
                            }
                            ExameAlvaro codigoAlvReq = new ExameAlvaro(exa.getString("ele_xmllabexterno"));
                            for (String exame : examesAmostra) {
                                String exameAlvaro = StringUtil.getValor(exame, "exame");
                                if (!Funcoes.textoVazio(exameAlvaro) || codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) continue;
                                novaSolicitacao = StringUtil.replaceBuilder(novaSolicitacao, amostra, "");
                                proximaAmostra = listaAmostrasIncluidas.size() - ++contador != listaExames.size();
                            }
                        }
                    }
                    codigoLote = numeroLote;
                    if (reenvio) {
                        codigoLote = reg.getString("lex_codigo");
                    }
                    requisicao = reg.getString("req_codigo");
                    break;
                }
                if (proximaAmostra) continue;
                Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
                if (agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, multiguias)) {
                    requisicao = StringUtil.implode(Arrays.asList(multiguias), ",");
                }
                if (Funcoes.textoVazio(codigoLote)) continue;
                StringBuilder sqlpdate = new StringBuilder();
                sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(novaSolicitacao.toString())).append("'");
                sqlpdate.append(" , leq_codigoreqapoio = ").append(idAlvaro);
                sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                sqlpdate.append(" and lae_codigo = ").append(codLabExterno);
                sqlpdate.append(" and req_codigo in(").append(requisicao).append(") ");
                sqlpdate.append(" and lex_codigo = ").append(codigoLote);
                sqlpdate.append(" and fil_kodigo = ").append(filial).append(";");
                st.executeUpdate(sqlpdate.toString());
                if (!isColetaWeb && (!filial.equals(Variaveis.filialPadrao) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
                    IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
                }
                List<String> amostrasRecebidas = StringUtil.getListValoresTagAberta(novaSolicitacao, "layoutetiqueta", false);
                for (String novaAmostra : amostrasRecebidas) {
                    String etiqueta = StringUtil.getValor(novaAmostra, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n';
                    PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface), tamanhoNomeImpressora, impressorasLocais));
                    etqs.add(ImpressaoTermica.imprimirDireto(service, etiqueta, true, st, isColetaWeb, arquivar, anular));
                }
                if (proximaAmostra) continue;
                continue block0;
            }
        }
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        listaRequisicoes.addAll(requisicoesOriginal);
        ArrayList<Registro> listaExcluidos = new ArrayList<Registro>();
        for (String key : mapRequisicoesExamesExcluidos.keySet()) {
            List exames = (List)mapRequisicoesExamesExcluidos.get(key);
            String filial = StringUtil.removeZerosEsquerda(key.substring(0, 1));
            String requisicao = key.substring(1, key.length());
            for (Registro req : listaRequisicoes) {
                ArrayList examesJalis = (ArrayList)req.getValor("listaexames");
                ArrayList<Registro> examesExcluidos = new ArrayList<Registro>();
                if (!requisicao.equalsIgnoreCase(req.getString("req_codigomae")) || !filial.equalsIgnoreCase(req.getString("fil_codigo"))) continue;
                for (Element exaAlv : exames) {
                    for (Registro exa : examesJalis) {
                        if (!exaAlv.getAttribute("codigo").equalsIgnoreCase(exa.getString("codigo")) || StringUtil.getBoolean(exaAlv.getAttribute("incluido"))) continue;
                        examesExcluidos.add(exa);
                    }
                }
                if (!examesExcluidos.isEmpty()) {
                    req.setValor("listaexames", examesExcluidos.clone());
                }
                listaExcluidos.add(req.clone());
            }
        }
        for (Registro registro : listaExcluidos) {
            requisicoesRejeitadas.add(registro);
        }
        if (!requisicoesRejeitadas.isEmpty()) {
            for (Registro req : requisicoesRejeitadas) {
                String msgErro = req.getString("ERRO");
                if (Funcoes.textoVazio(msgErro)) continue;
                if (!Funcoes.textoVazio(erro.toString())) {
                    erro.append("\n");
                }
                erro.append(msgErro).append("\n");
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("jalisws") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("jalisws", etqs);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        retorno.setRegistros(requisicoesRejeitadas);
        return retorno;
    }

    @Override
    public void geraXmlLote(String codLabExterno, String configuracaoLabExterno, List<Registro> requisicoes, HashSet<String> pac, HashSet<String> medicos, String agente, String senha, Boolean enviarLoteWebService, String numeroLote, boolean isNovaAmostra, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        boolean enviarTuboLis = StringUtil.getValor(configuracaoLabExterno, "enviarTuboLis").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarTuboLis");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.clear();
        atributos.put("versao", "20090801");
        atributos.put("lis", "Jalis");
        atributos.put("operador", Variaveis.login);
        atributos.put("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        this.xml.abrirTag("solicitacoes", atributos);
        atributos.clear();
        atributos.put("codigo", StringUtil.getValor(configuracaoLabExterno, "codigo"));
        atributos.put("chave", StringUtil.getValor(configuracaoLabExterno, "chave"));
        this.xml.abrirTag("entidade", atributos);
        if (!isNovaAmostra && (StringUtil.getValor(configuracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarMedico"))) {
            this.xml.abrirTag("medicos");
            for (Registro r : requisicoes) {
                String crm = this.geraCrm(r, enviarLoteWebService);
                if (crm == null || medicos.contains(crm)) continue;
                medicos.add(crm);
                atributos.clear();
                atributos.put("crm", crm);
                atributos.put("nome", r.getString("med_nome"));
                this.xml.abrirTag("medico", atributos, true);
            }
            this.xml.fecharTag("medicos");
        }
        this.xml.abrirTag("pacientes");
        for (Registro r : requisicoes) {
            if (pac.contains(r.getString("pac_codigo"))) continue;
            pac.add(r.getString("pac_codigo"));
            this.escreverPaciente(r, enviarLoteWebService);
        }
        this.xml.fecharTag("pacientes");
        for (Registro r : requisicoes) {
            this.escreverSolicitacao(null, codLabExterno, configuracaoLabExterno, numeroLote, isNovaAmostra, Arrays.asList(r), digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
        }
        this.xml.fecharTag("entidade");
        if (isNovaAmostra) {
            this.xml.fecharTag("inclusoes");
        } else {
            this.xml.fecharTag("solicitacoes");
        }
        this.xml.fecharArquivo();
    }

    @Override
    public String getImpressora(ImpressorasLabExterno impressoras, int agruparInterface) {
        this.impressora = impressoras.getImpressoraAlvaro();
        if (Funcoes.textoVazio(this.impressora)) {
            this.impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                this.impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return this.impressora;
    }

    @Override
    protected void escreverPaciente(Registro r, boolean enviarLoteWebService) throws ParseException {
        String data = "";
        if (r.getDate("pac_datanasc") != null) {
            data = Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc"));
        } else if (!Funcoes.textoVazio(r.getString("req_idade"))) {
            int idade = Integer.parseInt(r.getString("req_idade"));
            String tipo = r.getString("req_anomes");
            Calendar c = Calendar.getInstance();
            if (tipo.equalsIgnoreCase("A")) {
                c.add(1, idade * -1);
            } else if (tipo.equalsIgnoreCase("M")) {
                c.add(2, idade * -1);
            } else {
                c.add(5, idade * -1);
            }
            data = Funcoes.formataData("dd/MM/yyyy", c.getTime());
        }
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        if (enviarLoteWebService && !(this instanceof ExportacaoParaJalisWS)) {
            atributos.put("codigolis", r.getString("pac_codigo"));
        } else {
            atributos.put("codigo_lis", r.getString("pac_codigo"));
        }
        String nome = StringUtil.limpaString(StringUtil.testaTamanhoString(r.getString("pac_nome"), 40), new String[]{"&"});
        atributos.put("nome", nome);
        atributos.put("datanasc", data);
        atributos.put("sexo", r.getString("pac_sexo"));
        atributos.put("rg", r.getString("pac_rg"));
        atributos.put("telefone", r.getString("pac_fone"));
        atributos.put("email", r.getString("pac_email"));
        this.xml.abrirTag("paciente", atributos, true);
    }

    public boolean tratarRejeitados(String codLabExterno, String numeroLote, boolean reenvio, String conteudoGerado, String retornoWebService, StringBuilder erro, ArrayList<Registro> requisicoesRejeitadas, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface, RetornoImpressaoEtiquetas retorno) throws Exception {
        String nomeArquivo = "remessa_" + numeroLote + ".xml";
        if (requisicoesRejeitadas == null) {
            this.gerarArquivo(conteudoGerado, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o Jalis WS (*.xml)");
            return true;
        }
        if (!Funcoes.textoVazio(erro.toString()) || !requisicoesRejeitadas.isEmpty()) {
            if (!reenvio && requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty()) {
                ExportacaoParaJalisWS.removerLote(codLabExterno, requisicoesRejeitadas, numeroLote, true, true, st, isColetaWeb, arquivar, agruparInterface);
            }
            ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erro.toString().trim(), retornoWebService.trim());
            VisualizaErroRetornoWebService telaVisualizacaoErro = null;
            if (isColetaWeb) {
                UtilExportadores.adicionarMensagemRetorno(erroRetornoWebServiceLabExterno.getXmlErro(), Protocolo.JalisWS.getDescricao(), retorno);
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(conteudoGerado);
                retorno.setExtensaoArquivo("xml");
            } else {
                telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Jalis WS");
            }
            if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                if (requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty()) {
                    HashSet<String> pac = new HashSet<String>();
                    HashSet<String> medicos = new HashSet<String>();
                    JFileChooser chooser = this.gerarArquivo(null, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o Jalis WS (*.xml)");
                    int option = chooser.showOpenDialog(null);
                    if (option == 0) {
                        this.xml = new EscreverXML(chooser.getSelectedFile().getPath());
                        requisicoes = ExportacaoParaJalisWS.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
                        this.geraXmlLote(codLabExterno, this.configuracaoLabExterno, requisicoes, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, false, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
                    }
                } else {
                    this.gerarArquivo(conteudoGerado, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o Jalis WS (*.xml)");
                }
            }
            if (requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty() && requisicoesRejeitadas.size() != requisicoes.size()) {
                arquivar.call();
                return true;
            }
            return false;
        }
        return true;
    }

    private List<Registro> agruparMultiGuias(List<Registro> requisicoes) {
        ArrayList<Registro> novaLista = new ArrayList<Registro>();
        HashMap listaReq = new HashMap();
        for (int i = 0; i < requisicoes.size(); ++i) {
            if (!Funcoes.textoVazio(requisicoes.get(i).getString("req_codigomae"))) {
                listaReq.put(i, new ArrayList());
                ((List)listaReq.get(i)).add(0, requisicoes.get(i).getString("req_codigomae"));
                ((List)listaReq.get(i)).add(1, requisicoes.get(i).getString("req_codigo"));
                continue;
            }
            novaLista.add(requisicoes.get(i));
        }
        for (Integer pos : listaReq.keySet()) {
            List exames = (List)requisicoes.get(pos).getValor("listaexames");
            List examesMae = null;
            for (Registro r : requisicoes) {
                if (!r.getString("req_codigo").equals(((List)listaReq.get(pos)).get(0))) continue;
                examesMae = (List)r.getValor("listaexames");
                for (Registro regExame : exames) {
                    boolean existe = false;
                    for (Registro regExameMae : examesMae) {
                        if (!regExame.getString("exa_codigo").equals(regExameMae.getString("exa_codigo")) || !regExame.getString("mco_codigo").equals(regExameMae.getString("mco_codigo"))) continue;
                        existe = true;
                        break;
                    }
                    if (existe) continue;
                    examesMae.add(regExame);
                }
            }
            if (examesMae != null) continue;
            requisicoes.get(pos).setValor("req_codigo", requisicoes.get(pos).getValor("req_codigomae"));
            novaLista.add(requisicoes.get(pos));
        }
        return novaLista;
    }

    @Override
    protected void escreverSolicitacao(Registro r, String codLabExterno, String xmlConfiguracaoLabExterno, String numeroLote, boolean isNovaAmostra, List<Registro> listaRequisicoes, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        for (Registro list : listaRequisicoes) {
            r = list;
            String obs = r.getString("req_obs").replaceAll("\n", " ");
            if (obs.length() > 200) {
                obs = obs.substring(0, 199).replaceAll("\n", "");
            }
            Boolean enviarLoteWebService = !Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
            StringBuilder codigo_lis = new StringBuilder();
            StringBuilder codigo_tubo_lis = new StringBuilder();
            codigo_lis.append(Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial));
            codigo_lis.append(Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao));
            String codigoLis = r.getString("req_codigomae");
            if (Funcoes.textoVazio(codigoLis)) {
                codigoLis = r.getString("req_codigo");
            }
            codigo_tubo_lis.append(this.codigoTuboLis);
            codigo_tubo_lis.append(Funcoes.preencheZero(codigoLis, digitosTuboRequisicao));
            String crm = this.geraCrm(r, false);
            TreeMap<String, String> atributos = new TreeMap<String, String>();
            atributos.put("codigo_lis", codigo_lis.toString());
            atributos.put("codigo_paciente", r.getString("pac_codigo"));
            atributos.put("observacao", StringUtil.removerAcentos(obs));
            atributos.put("data", Funcoes.formataData("dd/MM/yyyy", r.getDate("req_data")));
            atributos.put("urgente", r.getString("req_urgente"));
            atributos.put("hora", r.getString("req_hora"));
            if (crm != null && (StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(xmlConfiguracaoLabExterno, "enviarMedico"))) {
                atributos.put("crm", crm);
            }
            this.xml.abrirTag("solicitacao", atributos);
            List exames = (List)r.getValor("listaexames");
            Map<ExameMaterialAlvaro, Integer> exaAlvaro = this.carregarExamesAlvaro(exames);
            String material = "";
            HashMap amostras = new HashMap();
            HashMap<String, String> descricaoTubo = new HashMap<String, String>();
            HashMap<String, String> identificacaoTemp = new HashMap<String, String>();
            for (Registro ex : exames) {
                List desm = (List)ex.getValor("listaexames");
                if (desm != null && !desm.isEmpty()) {
                    exaAlvaro = this.carregarExamesAlvaro(desm);
                    for (Registro exaFilho : desm) {
                        material = this.escreveTagAmostra(ex, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, exaFilho, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                    }
                    continue;
                }
                material = this.escreveTagAmostra(r, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, ex, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                Map<String, String> codRecipiente = this.getRecipiente(r, st, ex, digitosTuboTubo);
                String codigoMaterialLabExterno = StringUtil.getValor(ex.getValor("ele_xmllabexterno").toString(), "material");
                Array aux = (Array)ex.getValor("rec_kodigo");
                try {
                    String[] auxInt;
                    if (aux == null) continue;
                    for (String recip : auxInt = (String[])aux.getArray()) {
                        String key = String.format("%s%s", codigo_tubo_lis.toString(), Funcoes.preencheZero(String.valueOf(recip), digitosTuboTubo)) + codigoMaterialLabExterno;
                        if (!amostras.containsKey(key)) {
                            amostras.put(key, new ArrayList());
                        }
                        descricaoTubo.put(key, codRecipiente.get(recip));
                        ((List)amostras.get(key)).add(ex);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            this.xml.fecharTag("solicitacao");
        }
    }

    public String escreveTagAmostra(Registro r, boolean isNovaAmostra, Boolean enviarLoteWebService, Map<String, String> atributos, String material, Statement st, Map<String, String> identificacaoTemp, Registro e, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws SQLException {
        ExameAlvaro exa = new ExameAlvaro(e.getString("ele_xmllabexterno"));
        boolean temTempo = false;
        if (exa.getLinhasResultado().size() > 0) {
            for (LinhaResultado l : exa.getLinhasResultado()) {
                if (l.getTempos().isEmpty()) continue;
                temTempo = true;
                for (String tempo : l.getTempos()) {
                    if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                        this.xml.fecharTag("amostra");
                    }
                    String descricao = tempo + "min.";
                    atributos.clear();
                    atributos.put("material", e.getString("material"));
                    atributos.put("descricao", descricao);
                    this.xml.abrirTag("amostra", atributos);
                    if (isNovaAmostra) {
                        this.escreverExameXMLInsercao(e);
                        continue;
                    }
                    this.escreverExameXML(e, enviarLoteWebService, false, st);
                }
            }
            if (temTempo) {
                return material;
            }
        }
        if (!e.getString("material").equalsIgnoreCase(material)) {
            boolean agruparMultiguias;
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            atributos.clear();
            atributos.put("material", e.getString("material"));
            boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, e.getString("fil_codigo"), e.getString("req_codigo"));
            if (!agruparMultiguias) {
                if (Funcoes.textoVazio(e.getString("identificacao")) || Funcoes.textoVazio(e.getString("descricao"))) {
                    LaboratorioExterno[] labs;
                    block2: for (LaboratorioExterno laboratorioExterno : labs = LaboratorioExterno.getDescricoes(st, false)) {
                        Integer[] mulIntegers;
                        if (laboratorioExterno.protocolo == null || !laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                        for (Integer guia : mulIntegers = RecepcaoUtil.verificaMultiGuias(e.getString("fil_codigo"), e.getString("req_codigo"), true)) {
                            ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                            while (examesRegistros.next()) {
                                if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                if (Funcoes.textoVazio(atributos.get("identificacao"))) continue;
                            }
                            if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block2;
                        }
                    }
                }
                if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                    atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                }
                if (Funcoes.textoVazio(atributos.get("descricao"))) {
                    atributos.put("descricao", "N\u00e3o Informado");
                }
                if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                    atributos.put("novaAmostra", "true");
                }
            }
            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                atributos.put("identificacao", this.getIdentificacao(e, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
            }
            atributos.put("descricao", Funcoes.textoVazio(e.getString("rec_descricao")) ? (Funcoes.textoVazio(identificacaoTemp.get(e.getString("material"))) ? "N\u00e3o informado" : identificacaoTemp.get(e.getString("material"))) : e.getString("rec_descricao"));
            if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                atributos.put("novaAmostra", "true");
            }
            if (!Funcoes.textoVazio(atributos.get("descricao"))) {
                this.xml.abrirTag("amostra", atributos);
            }
        }
        if (isNovaAmostra) {
            this.escreverExameXMLInsercao(e);
        } else {
            this.escreverExameXML(e, enviarLoteWebService, false, st);
        }
        material = e.getString("material");
        identificacaoTemp.put(material, e.getString("exr_codigoapoiado"));
        return material;
    }

    @Override
    protected void escreverExameXML(Registro e, boolean enviarLoteWebService, boolean enviarExameUrgente, Statement st) {
        String dadosAdicionais = e.getString("dadosadicionais");
        String lis = e.getString("exa_codigo") + "|" + e.getString("mco_codigo");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.put("codigo", e.getString("codigo"));
        if (enviarExameUrgente) {
            boolean isUrgente = e.getBoolean("exr_urgente") || ExportacaoParaAlvaroService.isRequisicaoUrgente(e.getString("fil_codigo"), e.getString("req_codigo"), e.getString("exa_codigo"), e.getString("mco_codigo"), st);
            atributos.put("urgente", String.valueOf(isUrgente));
        }
        if (enviarLoteWebService) {
            atributos.put("idlis", lis);
        } else {
            atributos.put("id_lis", lis);
        }
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            atributos.put("dados_adicionais", dadosAdicionais);
        }
        this.xml.abrirTag("exame", atributos, true);
    }

    @Override
    protected void escreverExameXMLInsercao(Registro e) {
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        String dadosAdicionais = e.getString("dadosadicionais");
        atributos.put("codigoExame", e.getString("codigo"));
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            atributos.put("dados_adicionais", dadosAdicionais);
        }
        this.xml.abrirTag("exame", atributos, true);
    }

    @Override
    protected String getIdentificacao(Registro e, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) {
        if (!Funcoes.textoVazio(e.getString("exr_codigoapoiado"))) {
            return e.getString("exr_codigoapoiado");
        }
        String fil = Funcoes.preencheZero(e.getString("fil_codigo"), digitosTuboFilial);
        String req = Funcoes.preencheZero(e.getString("req_codigo"), digitosTuboRequisicao);
        if (!Funcoes.textoVazio(e.getString("req_codigomae")) && !e.getString("req_codigomae").equals(e.getString("req_codigo"))) {
            req = Funcoes.preencheZero(e.getString("req_codigomae"), digitosTuboRequisicao);
        }
        String rec = null;
        if (!Funcoes.textoVazio(e.getString("rec_kodigo"))) {
            rec = StringUtil.limpaString(e.getString("rec_kodigo"), new String[]{"{", "}"});
            rec = Funcoes.preencheZero(rec, digitosTuboTubo);
        }
        return fil + req + (!Funcoes.textoVazio(rec) ? rec : "");
    }

    private Map<String, String> getRecipiente(Registro r, Statement st, Registro e, int digitosTuboTubo) {
        HashMap<String, String> codRecipiente = new HashMap<String, String>();
        try {
            boolean isApoio = this.isRequisicaoDeApoio(st, r.getString("fil_codigo"), r.getString("req_codigo"));
            StringBuilder buf = new StringBuilder("select a.rec_kodigo ");
            if (!isApoio) {
                buf.append(", (CASE WHEN (trim(a.ere_codigoapoiado) != '') THEN cast(trim(a.ere_codigoapoiado) AS varchar) ELSE cast(trim(exr.exr_codigoapoiado) AS varchar)  END) AS exr_codigoapoiado");
            } else {
                buf.append(", '' as exr_codigoapoiado ");
            }
            buf.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
            buf.append(" from examerequisicaorecipiente a ");
            buf.append("  left join requisicaorequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_kodigo ");
            if (!isApoio) {
                buf.append(" left join examerequisicao exr on exr.fil_codigo = a.fil_codigo and exr.req_codigo = a.req_codigo and exr.exa_codigo = a.exa_codigo and exr.mco_codigo = a.mco_codigo ");
            }
            buf.append(" join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = a.rec_kodigo ");
            buf.append("where  a.fil_codigo = ").append(r.getString("fil_codigo"));
            buf.append(" and (a.req_codigo = ").append(r.getString("req_codigo"));
            buf.append("       or b.req_codigo = ").append(r.getString("req_codigo")).append(") ");
            buf.append(" and a.exa_codigo = '").append(e.getString("exa_codigo")).append("' ");
            buf.append(" and a.mco_codigo = ").append(e.getInt("mco_codigo"));
            buf.append(" and a.ere_tipo = '").append("C").append("'");
            buf.append(" order by a.rec_codigo ");
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String tubo;
                String codigoApoiado = rs.getString("exr_codigoapoiado");
                String string = tubo = codigoApoiado != null && codigoApoiado.trim().length() > 0 ? codigoApoiado.substring(codigoApoiado.length() - digitosTuboTubo, codigoApoiado.length()) : "";
                if (tubo.trim().length() > 0 && Integer.parseInt(tubo.trim()) == rs.getInt("rec_kodigo")) {
                    codRecipiente.put(rs.getString("rec_kodigo"), rs.getString("rec_descricao"));
                    continue;
                }
                if (tubo.trim().length() != 0) continue;
                codRecipiente.put(rs.getString("rec_kodigo"), rs.getString("rec_descricao"));
            }
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace(), "ExportacaoParaConcent: 125");
        }
        return codRecipiente;
    }

    private boolean isRequisicaoDeApoio(Statement st, String filial, String requisicao) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder("select req_codigo from loteapoiorequisicao ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and req_codigo = ").append(requisicao);
            ResultSet rs = st.executeQuery(buf.toString());
            retorno = rs.next();
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace(), "ExportacaoParaConcent: 236");
        }
        return retorno;
    }
}

