/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.apoio.servidor.IServidor;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilJalis;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.jalis.ConexaoRMI;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaJalis
extends IntegracaoLabExterno
implements Exportador {
    private IServidor servidor;
    private Registro registro;
    private String etq;

    @Override
    public String getTagCodigo() {
        return "codigoCliente";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            this.registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno);
            if (!Funcoes.testaConexaoWeb(this.registro.getString("servidorRMI"), 4445)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Conex\u00e3o com a web n\u00e3o encontrada", 1);
                retorno.setImprimiu(false);
                return retorno;
            }
            this.servidor = ConexaoRMI.getServidor(this.registro.getString("servidorRMI"));
            int conectado = ConexaoRMI.testarServidor(this.servidor, this.registro.getString("filialSelecionada"), this.registro.getString("codigoCliente"), this.registro.getString("codigoConvenio"));
            if (conectado != 0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), ConexaoRMI.getTextoMensagem(conectado), 1);
                retorno.setImprimiu(false);
                return retorno;
            }
            arquivar.call();
            StringBuilder buf = new StringBuilder();
            StringBuilder xmlExames = new StringBuilder();
            StringBuilder xmlLote = new StringBuilder("<lote>");
            xmlLote.append("<lot_codigo>");
            xmlLote.append(numeroLote);
            xmlLote.append("</lot_codigo><lot_data>");
            xmlLote.append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()));
            xmlLote.append("</lot_data>");
            for (Registro requisicao : requisicoes) {
                xmlExames.delete(0, xmlExames.length());
                this.enviarPaciente(st, this.servidor, this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"), requisicao.getString("req_codigo"), codigoLabExterno, reenvio);
                List exames = (List)requisicao.getValor("listaexames");
                for (Registro exame : exames) {
                    String xml = exame.getString("ele_xmllabexterno");
                    String codigoExameApoio = StringUtil.getValor(xml, "codigoExame");
                    String codigoMaterialApoio = StringUtil.getValor(xml, "codigoMaterial");
                    xmlExames.append(this.criaXMLExame(st, requisicao.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), codigoExameApoio, codigoMaterialApoio));
                }
                buf.append(this.criaXMLRequisicao(st, requisicao.getString("req_codigo"), xmlExames.toString(), codigoLabExterno));
            }
            if (buf.length() > 0) {
                xmlLote.append(StringUtil.getTag("requisicoes", buf.toString()));
                xmlLote.append("</lote>");
                String etiquetas = this.servidor.criarLote(this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"), xmlLote.toString());
                if (StringUtil.getValor(etiquetas, "status").equalsIgnoreCase("1")) {
                    String[] requisicoesApoio;
                    for (String s : requisicoesApoio = StringUtil.getValores(StringUtil.getValor(etiquetas, "requisicoes"), "requisicao")) {
                        if (reenvio) continue;
                        String codigo = StringUtil.getValor(s, "codigo");
                        String novoCodigo = StringUtil.getValor(s, "novocodigo");
                        buf.setLength(0);
                        buf.append("select req_codigo from requisicaolabexterno where ");
                        buf.append("fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and req_codigo = ").append(codigo);
                        buf.append(" and lae_codigo = ").append(codigoLabExterno);
                        if (st.executeQuery(buf.toString()).next()) continue;
                        buf.setLength(0);
                        buf.append("insert into requisicaolabexterno (fil_codigo, req_codigo, rle_codigo, lae_codigo) values (");
                        buf.append(Variaveis.filialPadrao).append(", ").append(codigo);
                        buf.append(", '").append(novoCodigo).append("', ").append(codigoLabExterno).append(")");
                        st.execute(buf.toString());
                    }
                    this.etq = StringUtil.xmlToTexto(StringUtil.getValor(etiquetas, "etiquetas"));
                    buf.delete(0, buf.length());
                    buf.append("update loteexterno set lex_dataenvio = current_timestamp, usr_codenvio = '");
                    buf.append(Variaveis.login).append("' ");
                    buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and lae_codigo = ").append(codigoLabExterno);
                    Conexao.execute(Variaveis.filialPadrao, st, buf);
                } else {
                    String msg = StringUtil.getValor(etiquetas, "mensagemerro");
                    if (!Funcoes.textoVazio(msg)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), msg, 1);
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaJalis (118)");
            retorno.setImprimiu(false);
            return retorno;
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        String relatorio = this.servidor.getModeloRelatorio();
        UtilJalis.imprimirRelatorio(st, StringUtil.xmlToTexto(relatorio), numeroLote, this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"), codLabExterno);
        if (!Funcoes.textoVazio(this.etq)) {
            ImpressaoTermica termica = new ImpressaoTermica(ParametrosLocais.getParametro("impressoraEtqColeta"), false);
            termica.imprimirDireto(this.etq);
        }
        return null;
    }

    private void enviarPaciente(Statement st, IServidor servidor, String filial, String convenio, String requisicao, String codigoLabExterno, boolean reenvio) throws RemoteException, SQLException {
        StringBuilder buf = new StringBuilder("select c.pac_codigo, c.pac_nome, c.pac_sexo, ");
        buf.append("c.pac_datanasc, c.pac_vip, c.pac_grpsangue, c.pac_fatorrh, c.pac_fatordu, ");
        buf.append("c.pac_cor, c.pac_observ, c.pac_dadoclinico, c.pac_peso, c.pac_altura, ");
        buf.append("c.pac_matricconv, c.pac_titularconv, c.pac_profissao, c.pac_fumante, ");
        buf.append("c.pac_diabetico, c.pac_rg, c.pac_cpf, c.pac_estcivil, c.pac_numfilho, ");
        buf.append("c.pac_datahora, c.pac_dum, c.pac_fax, c.pac_celular, ");
        buf.append("c.pac_fonecomercial, c.pac_fone, c.pac_cep, c.pac_complemento, ");
        buf.append("c.pac_endereco, c.pac_numeroendereco, c.pac_tipologradouroendereco, c.pac_email, c.pac_anomes, c.pac_idade, ");
        buf.append("c.pac_fonecontato, c.pac_nomecontato, ");
        buf.append("c.pac_mae, c.pac_pai, c.pac_maladireta, d.ple_codigo ");
        buf.append("from requisicao b ");
        buf.append("left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        buf.append("left join pacientelabexterno d on b.fil_codigo = d.fil_codigo and b.pac_codigo = d.pac_codigo and d.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("where b.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and b.req_codigo = ").append(requisicao);
        buf.append(" and (d.ple_exportado is null or d.ple_exportado = false) ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            String codPaciente = rs.getString("pac_codigo");
            String paciente = XMLUtil.criaXML("paciente", new Registro(rs), new String[]{"pac_codigo"});
            String resultado = servidor.enviarPaciente(filial, convenio, paciente);
            String r = StringUtil.getValor(resultado, "resultado");
            if (r.length() > 0) {
                String novoCodigo = StringUtil.getValor(r, "codigoapoio");
                String status = StringUtil.getValor(r, "status");
                if (status.equals("1")) {
                    if (!Funcoes.textoVazio(novoCodigo) && !reenvio) {
                        buf.setLength(0);
                        buf.append("insert into pacientelabexterno (fil_codigo, pac_codigo, lae_codigo, ple_codigo, ple_exportado) values (");
                        buf.append(Variaveis.filialPadrao).append(", ").append(codPaciente);
                        buf.append(", ").append(codigoLabExterno).append(", ").append(novoCodigo).append(", true)");
                        Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    } else {
                        buf.setLength(0);
                        buf.append("update pacientelabexterno set ple_exportado = true where");
                        buf.append(" fil_codigo = ").append(Variaveis.filialPadrao).append(" and pac_codigo = ").append(codPaciente);
                        buf.append(" and lae_codigo = ").append(codigoLabExterno);
                        Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    }
                }
            }
        }
    }

    private String criaXMLRequisicao(Statement st, String codigoRequisicao, String exames, String codigoLabExterno) throws Exception {
        StringBuilder buf = new StringBuilder("select a.req_codigo,  ");
        buf.append("d.ple_codigo as pac_codigo, a.req_data, ");
        buf.append("a.req_dtfatura, a.req_urgente, a.req_dataentregaprev, a.req_dclinicos, a.req_obs, ");
        buf.append("a.req_totpago, a.req_total, a.req_horaentregaprev, a.req_horafatura, a.req_hora, ");
        buf.append("a.req_gestante, a.req_dum, a.req_anomes, a.req_idade, a.req_avisarpaciente, ");
        buf.append("a.req_titular, a.req_altura, a.req_peso, ");
        buf.append("a.req_datarequisicao, a.req_neonato, c.rle_codigo ");
        buf.append("from requisicao a ");
        buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        buf.append("left join requisicaolabexterno c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and c.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("left join pacientelabexterno d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo and d.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(codigoRequisicao);
        buf.append("order by a.req_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        StringBuilder requisicao = new StringBuilder();
        if (rs.next()) {
            requisicao.append(XMLUtil.criaXML(new Registro(rs), new String[]{"req_codigo"}));
            requisicao.append(StringUtil.getTag("exames", exames));
        }
        return StringUtil.getTag("requisicao", requisicao.toString());
    }

    private String criaXMLExame(Statement st, String requisicao, String exame, String material, String exameReal, String materialReal) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select req_codigo, exr_situacao,  ");
        buf.append("exr_dataentregaprev, ");
        buf.append("pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado, exr_resposta, ");
        buf.append("exa_codigo as exr_codexameorigem, mco_codigo as exr_codmatorigem, ");
        buf.append("'").append(StringUtil.textoDB(exameReal)).append("' as exa_codigo, ");
        buf.append(!Funcoes.textoVazio(materialReal) ? StringUtil.textoDB(materialReal) : " 0 ").append(" as mco_codigo, ");
        buf.append("exr_descricaomaterial, exr_volumediurese, ");
        buf.append("exr_obs,  ");
        buf.append("exr_data, exr_intervalojejum, exr_tempodiurese ");
        buf.append("from examerequisicao ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        if (rs.next()) {
            buf.append(XMLUtil.criaXML("examerequisicao", new Registro(rs), new String[]{"req_codigo", "exa_codigo", "mco_codigo"}));
        }
        return buf.toString();
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }
}

