/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import br.com.hermespardini.b2b.apoio.schemas.XMLServerSoapProxy;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ConfirmarCondicaoAmostra;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialPardini;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.print.PrintService;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class ExportacaoParaHPardini
extends IntegracaoLabExterno
implements Exportador {
    public static final String GERAR_LOTE = "gerarLote";
    public static final String LEQ_RETORNO_WS = "LEQ_RETORNO_WS";
    public static final String TABELA_LOTEEXTERNO = "loteexterno";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAODESM = "loteexternoexamerequisicaodesm";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAORECIP = "loteexternoexamerequisicaorecip";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAO = "loteexternoexamerequisicao";
    public static final String TABELA_LOTEEXTERNOREQUISICAO = "loteexternorequisicao";
    public static final String MCO_KODIGO = "mco_kodigo";
    public static final String EXA_KODIGO = "exa_kodigo";
    public static final String REC_CODIGO = "rec_codigo";
    public static final String FIL_KODIGO = "fil_kodigo";
    public static final String USR_CODCRIACAO = "usr_codcriacao";
    public static final String LEX_DATAHORA = "lex_datahora";
    public static final String LEX_CODIGO = "lex_codigo";
    public static final String REQ_ALTURA = "req_altura";
    public static final String REQ_PESO = "req_peso";
    public static final String REQ_OBS = "req_obs";
    public static final String REQ_DUM = "req_dum";
    public static final String REQ_HORA = "req_hora";
    public static final String REQ_DATA = "req_data";
    public static final String REQ_IDADE = "req_idade";
    public static final String REQ_CODIGO = "req_codigo";
    public static final String REQ_DATANASC = "req_datanasc";
    public static final String EXR_VOLUMEDIURESE = "exr_volumediurese";
    public static final String EXR_TEMPODIURESE = "exr_tempodiurese";
    public static final String EXR_CODIGOAPOIADO = "exr_codigoapoiado";
    public static final String EXR_DATAMATERIAL = "exr_datamaterial";
    public static final String EXR_DESCRICAOMATERIAL = "exr_descricaomaterial";
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    public static final String PAC_DATANASC = "pac_datanasc";
    public static final String PAC_SEXO = "pac_sexo";
    public static final String PAC_NOME = "pac_nome";
    public static final String PAC_CODIGO = "pac_codigo";
    public static final String FIL_CODIGO = "fil_codigo";
    public static final String CODIGO_MATERIAL = "codigoMaterial";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String PAC_DUM = "pac_dum";
    public static final String CON_CODIGO = "con_codigo";
    public static final String LAE_CODIGO = "lae_codigo";
    public static final String ELE_XML_LAB_EXTERNO = "ele_xmllabexterno";
    public static final String EXA_DESCRICAO = "exa_descricao";
    public static final String MCO_DESCRICAO = "mco_descricao";
    public static final String REC_KODIGO = "rec_kodigo";
    public static final String CODIGO_PROTOCOLO = "codigoProtocolo";
    public static final String TIPO_IMPRESSAO = "tipoImpressao";
    public static final String ETIQUETA_ARMAZENADA = "etiquetaArmazenada";
    public static final String QTDE_ETIQUETAS = "qtdeEtiquetas";
    public static final String MED_SIGLA_CONSELHO = "med_conselho";
    public static final String MED_UF_CONSELHO = "med_uf";
    public static final String MED_NUMERO_CONSELHO = "med_crm";
    public static final String MED_NOME = "med_nome";
    public static final String TAG_ID_TUBO_LAB = "IdTuboLab";
    public static final String TAG_HORA_COLETA = "HoraColeta";
    public static final String TAG_DATA_COLETA = "DataColeta";
    public static final String TAG_ID_MEDICO_SOLICITANTE = "idMedicoSolicitante";
    public static final String TAG_CONSERVANTE = "Conservante";
    public static final String TAG_DESC_MAT = "DescMat";
    public static final String TAG_COD_EXM_APOIO = "CodExmApoio";
    public static final String TAG_COD_EXM_LAB = "CodExmLab";
    public static final String TAG_EXAME = "Exame";
    public static final String TAG_DATA_NASC = "DataNasc";
    public static final String TAG_SEXO = "Sexo";
    public static final String TAG_NOME = "Nome";
    public static final String TAG_COD_PAC_LAB = "CodPacLab";
    public static final String TAG_PACIENTE = "Paciente";
    public static final String TAG_DATA_ULT_MENS = "DataUltMens";
    public static final String TAG_HORA_PED = "HoraPed";
    public static final String TAG_DATA_PED = "DataPed";
    public static final String TAG_COD_PED_LAB = "CodPedLab";
    public static final String TAG_PEDIDO = "Pedido";
    public static final String TAG_ETIQ_COD_BAR_HP = "EtqCodBar";
    public static final String TAG_COD_BAR_APOIO = "CodBarApoio";
    public static final String TAG_RECIPIENTES_HP = "Recipientes";
    public static final String TAG_RECIPIENTE_HP = "Recipiente";
    public static final String TAG_HORA_LOTE = "HoraLote";
    public static final String TAG_DATA_LOTE = "DataLote";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_LOTE = "Lote";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_REGISTRO = "Registro";
    public static final String CODIGO_LAB_EXTERNO = "codigoLabExterno";
    public static final String EXAMES_HERMES_PARDINI = "examesHermesPardini";
    public static final String REQ_CODIGO_MAE = "req_codigomae";
    public static final String TAG_MEDICO = "Medico";
    public static final String TAG_SEQ_MED = "seqmed";
    public static final String TAG_SIGLA_CONSELHO_MED = "siglaConselho";
    public static final String TAG_NUMERO_CONSELHO_MED = "numeroConselho";
    public static final String TAG_UF_CONSELHO_MED = "ufConselho";
    public static final String TAG_NOME_MED = "Nome";
    public static final String TAG_CONDICAO_AMOSTRA = "Condicao";
    public static final String TAG_COD_PED_APOIO = "CodPedApoio";
    public static final String PERIODO_GESTACIONAL = "req_periodogestacional";
    public static final String DATA_SINTOMA = "req_datasintoma";
    public static final String MUNICIPIO_RESIDENCIA = "req_municipioresidencia";
    public static final String APRESENTOU_SINTOMA = "req_apresentousintoma";
    private XMLStringBuilder xml = new XMLStringBuilder(true);
    private boolean enviarUsandoWS = false;
    private boolean enviarDadosMedico = false;
    protected LaboratorioExterno labExterno = null;
    private String retornoHPardini = null;

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        this.enviarUsandoWS = configuracaoLabExterno.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
        boolean bl = this.enviarDadosMedico = configuracaoLabExterno.indexOf("enviarDadosMedico") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarDadosMedico") : false;
        if (!this.validarConfiguracao(configuracaoLabExterno, true)) {
            try {
                ExportacaoParaHPardini.removerLote(codigoLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (!isColetaWeb) {
            try {
                this.setCondicaoExamesDesm(this.confirmaCondicaoAmostra(Variaveis.filialPadrao, requisicoes, codigoLabExterno, st, agruparGuiasInterface));
            }
            catch (ImpressaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel recuperar as condi\u00e7\u00f5es das amostras.\n" + e.getMessage(), e.getStackTrace());
                retorno.setImprimiu(false);
                return retorno;
            }
        }
        return this.processa(isColetaWeb, codigoLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, colunaOrdenacao, this.enviarDadosMedico, st, agruparInterface, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras.getImpressoraPardini(), tamanhoNomeImpressora, impressorasLocais, arquivar, anular);
    }

    @Override
    public String getTagCodigo() {
        return CODIGO_PROTOCOLO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RetornoImpressaoEtiquetas processa(boolean isColetaWeb, String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean enviarDadosMedico, Statement st, int agruparInterface, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String nomeReduzido, String tamanhoNomeImpressora, String[] impressorasLocais, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        boolean isUtilizarHPDirect = configuracaoLabExterno.indexOf("enviarEtiquetaHpDirect") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarEtiquetaHpDirect") : false;
        boolean isEnviarRequisicaoWebService = configuracaoLabExterno.indexOf("envioAutomatico") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "envioAutomatico") : false;
        String codigoWebservice = configuracaoLabExterno.indexOf(CODIGO_PROTOCOLO) > 0 ? StringUtil.getValor(configuracaoLabExterno, CODIGO_PROTOCOLO) : null;
        String senhaWebservice = configuracaoLabExterno.indexOf("senhaWeb") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senhaWeb") : null;
        this.retornoHPardini = null;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Registro> lista = new ArrayList<Registro>();
        for (Registro requisicao : requisicoes) {
            lista.add(requisicao.clone());
        }
        try {
            block27: {
                for (Registro registro : requisicoes) {
                    ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
                    ArrayList<String> listExa = new ArrayList<String>();
                    int[] arrayMat = new int[listaExames.size()];
                    for (Registro exa : listaExames) {
                        listExa.add(exa.getString(EXA_CODIGO));
                        arrayMat[listExa.size() - 1] = exa.getInt(MCO_CODIGO);
                    }
                    if (tipoEtiq == 0) {
                        tipoEtiq = agruparInterface == 1 ? 2 : 1;
                    }
                    String[] arrayExa = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
                    ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, registro.getString(FIL_CODIGO), registro.getString(REQ_CODIGO), arrayExa, arrayMat, true, "R", st, st2, st3, Variaveis.login, tipoEtiq, false, null, null, false, false, codigoLabExterno, false, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
                }
                arquivar.call();
                boolean naoEnviarObsRequisicao = StringUtil.getBoolean(configuracaoLabExterno, "naoEnviarObsRequisicao");
                String adicionalLote = StringUtil.getValor(configuracaoLabExterno, "adicionalLote");
                this.gerarXML(numeroLote, codigoWebservice, adicionalLote, naoEnviarObsRequisicao, requisicoes, isUtilizarHPDirect, enviarDadosMedico, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao);
                String nomeArquivo = "remessa_" + numeroLote + ".xml";
                if (!this.enviarUsandoWS && !isEnviarRequisicaoWebService) {
                    if (isColetaWeb) {
                        retorno.setNomeArquivoLote(nomeArquivo);
                        retorno.setXmlLote(this.xml.getXML());
                        retorno.setExtensaoArquivo("xml");
                    } else {
                        this.gerarArquivo(this.xml.getXML(), new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o H. Pardini (*.xml)");
                    }
                } else if (this.enviarUsandoWS || isEnviarRequisicaoWebService) {
                    this.retornoHPardini = new XMLServerSoapProxy().getPedido(codigoWebservice, senhaWebservice, this.xml.toString());
                    ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(this.retornoHPardini);
                    if (erroRetornoWebServiceLabExterno.getRegistroRejeitado()) {
                        if (!reenvio) {
                            ExportacaoParaHPardini.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                        }
                        VisualizaErroRetornoWebService telaVisualizacaoErro = null;
                        if (!isColetaWeb) {
                            telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Hermes Pardini");
                        } else {
                            retorno.setNomeArquivoLote(nomeArquivo);
                            retorno.setXmlLote(this.xml.getXML());
                            retorno.setExtensaoArquivo("xml");
                            UtilExportadores.adicionarMensagemRetorno(erroRetornoWebServiceLabExterno.getXmlErro() + "<br>" + erroRetornoWebServiceLabExterno.getXmlDetalhe(), "HPardini", retorno);
                        }
                        if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                            this.gerarArquivo(this.xml.getXML(), new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o H. Pardini (*.xml)");
                            break block27;
                        } else {
                            retorno.setImprimiu(false);
                            return retorno;
                        }
                    }
                    this.processaRetornoWebService(isColetaWeb, codigoLabExterno, numeroLote, reenvio, lista, isUtilizarHPDirect, st, digitosTuboFilial, nomeReduzido, tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular);
                }
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception ex) {
            try {
                if (!reenvio) {
                    ExportacaoParaHPardini.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != ex.getMessage() && ex.getMessage().contains("java.net.UnknownHostException")) {
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com Hermes Pardini.\nVerifique sua conex\u00e3o com a internet.", 2);
                }
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel obter conex\u00e3o com Hermes Pardini. <br> Verifique sua conex\u00e3o com a internet.", "HPardini", retorno);
            } else if (null != ex.getCause() && ex.getCause().toString().contains("Badly formed SOAP Message")) {
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com Hermes Pardini.\nVerifique c\u00f3digo/senha na configura\u00e7\u00e3o do Laborat\u00f3rio externo.", 2);
                }
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel obter conex\u00e3o com Hermes Pardini. <br>Verifique c\u00f3digo/senha na configura\u00e7\u00e3o do Laborat\u00f3rio externo.", "HPardini", retorno);
            } else if (!isColetaWeb) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
            }
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private ArrayList<InterfaceDesmembrar> confirmaCondicaoAmostra(String filial, List<Registro> requisicoes, String codigoLab, Statement st, boolean agruparGuiasInterface) throws ImpressaoException {
        ArrayList<InterfaceDesmembrar> examesDesm = new ArrayList<InterfaceDesmembrar>();
        for (Registro reg : requisicoes) {
            List exames = (List)reg.getValor("listaexames");
            for (Registro ex : exames) {
                ConfirmarCondicaoAmostra confirmarCondicaoAmostra = new ConfirmarCondicaoAmostra(new Dialog(Laboratorio.getInstancia()), ex.getString(EXA_CODIGO), ex.getString(MCO_CODIGO), codigoLab, ex.getString(REQ_CODIGO));
                if (!confirmarCondicaoAmostra.contemExamesFilho()) continue;
                confirmarCondicaoAmostra.setVisible(this.exibirConfirmaCondicaoAmostra(reg, ex, requisicoes, st, agruparGuiasInterface));
                examesDesm.addAll(confirmarCondicaoAmostra.getExames());
            }
        }
        return examesDesm;
    }

    private boolean exibirConfirmaCondicaoAmostra(Registro reg, Registro ex, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface) {
        boolean perguntar = true;
        if (ExportacaoParaHPardini.possuiAgrupamentoMultiguia(reg, ex, st, agruparGuiasInterface)) {
            block0: for (Registro r : requisicoes) {
                if (r.equals(reg)) break;
                for (Registro registroComparador : (List)r.getValor("listaexames")) {
                    String nomeExame = registroComparador.getString(EXA_CODIGO);
                    if (Funcoes.objectIsNull(nomeExame) || nomeExame.isEmpty() || !nomeExame.equals(ex.getString(EXA_CODIGO)) || ex.getString(REQ_CODIGO_MAE).equals(ex.getString(REQ_CODIGO))) continue;
                    perguntar = false;
                    continue block0;
                }
            }
        }
        return perguntar;
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(boolean isColetaWeb, String codigoLabExterno, String numeroLote, boolean reenvio, List<Registro> requisicoes, boolean isUtilizarHPDirect, Statement st, int digitosTuboFilial, String nomeReduzido, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        ArrayList<Object> etqs = new ArrayList<Object>();
        if (this.retornoHPardini.indexOf(TAG_PEDIDO) > -1) {
            String[] pedidos;
            for (String pedido : pedidos = StringUtil.getValores(this.retornoHPardini.toString(), TAG_PEDIDO)) {
                if (pedido.indexOf(TAG_RECIPIENTE_HP) <= -1) continue;
                String filialRequisicao = StringUtil.getValor(pedido, TAG_COD_PED_LAB);
                String[] recipientes = StringUtil.getValores(pedido, TAG_RECIPIENTE_HP);
                String filial = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
                String requisicao = StringUtil.removeZerosEsquerda(filialRequisicao.substring(digitosTuboFilial, filialRequisicao.length()));
                StringBuilder recipientesGravar = new StringBuilder();
                recipientesGravar.append("<Recipientes>");
                StringBuilder etiq = new StringBuilder();
                for (String recipiente : recipientes) {
                    String[] examesHPardini = StringUtil.getValores(recipiente, TAG_EXAME);
                    if (!isUtilizarHPDirect && !Funcoes.textoVazio(recipiente)) {
                        String etiqueta = StringUtil.getValor(recipiente, TAG_ETIQ_COD_BAR_HP);
                        etiq.append(etiqueta).append("\n");
                        String codigoTuboApoio = StringUtil.getValor(recipiente, TAG_COD_BAR_APOIO);
                        String[] examesRetorno = StringUtil.getValores(recipiente, TAG_EXAME);
                        String codigoMae = null;
                        for (Registro req : requisicoes) {
                            if (codigoMae == null || !codigoMae.equals(req.getString(REQ_CODIGO_MAE))) {
                                codigoMae = req.getString(REQ_CODIGO_MAE);
                            }
                            if (!req.getString(REQ_CODIGO).equalsIgnoreCase(requisicao) && !req.getString(REQ_CODIGO_MAE).equalsIgnoreCase(codigoMae) || !req.getString(FIL_CODIGO).equals(filial)) continue;
                            ArrayList exames = (ArrayList)req.getValor("listaexames");
                            for (String exameAlv : examesRetorno) {
                                String codigoExmApoio = StringUtil.getValor(exameAlv, TAG_COD_EXM_APOIO);
                                String[] exaRetorno = codigoExmApoio.split("\\|");
                                String exameRetorno = exaRetorno[1].trim();
                                for (Registro exa : exames) {
                                    ArrayList listaDesm = (ArrayList)exa.getValor("listaexames");
                                    if (listaDesm != null && !listaDesm.isEmpty()) {
                                        for (Registro desm : listaDesm) {
                                            String recJalis = this.getRecipiente(desm.getString(EXA_CODIGO), desm.getString(MCO_CODIGO), req.getString(REQ_CODIGO), filial, st);
                                            String exaHpDesm = desm.getString(CODIGO_EXAME);
                                            if (Funcoes.textoVazio(exaHpDesm)) {
                                                ExameHPardini ehp = ExameHPardini.novaInstancia(desm.getString(ELE_XML_LAB_EXTERNO));
                                                exaHpDesm = ehp.getMnemonicoExame();
                                            }
                                            if (!exaHpDesm.equalsIgnoreCase(exameRetorno)) continue;
                                            desm.setValor(REC_CODIGO, recJalis);
                                            desm.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                            if (!exa.nulo(TAG_COD_BAR_APOIO)) continue;
                                            exa.setValor(REC_CODIGO, recJalis);
                                            exa.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                        }
                                        continue;
                                    }
                                    String recJalis = this.getRecipiente(exa.getString(EXA_CODIGO), exa.getString(MCO_CODIGO), req.getString(REQ_CODIGO), filial, st);
                                    String exaHp = exa.getString(CODIGO_EXAME);
                                    if (Funcoes.textoVazio(exaHp)) {
                                        ExameHPardini ehp = ExameHPardini.novaInstancia(exa.getString(ELE_XML_LAB_EXTERNO));
                                        exaHp = ehp.getMnemonicoExame();
                                    }
                                    if (!exaHp.equalsIgnoreCase(exameRetorno)) continue;
                                    exa.setValor(REC_CODIGO, recJalis);
                                    exa.setValor(TAG_COD_BAR_APOIO, codigoTuboApoio);
                                }
                            }
                        }
                    }
                    recipientesGravar.append("<Recipiente>");
                    recipientesGravar.append(recipiente);
                    recipientesGravar.append("</Recipiente>");
                }
                recipientesGravar.append("</Recipientes>");
                if (!recipientesGravar.toString().isEmpty()) {
                    arquivar.call();
                    for (Registro req : requisicoes) {
                        if (!req.getString(FIL_CODIGO).equalsIgnoreCase(filial) || !req.getString(REQ_CODIGO).equalsIgnoreCase(requisicao) && !req.getString(REQ_CODIGO_MAE).equalsIgnoreCase(requisicao)) continue;
                        StringBuilder sqlpdate = new StringBuilder();
                        String lote = !reenvio ? req.getString("novoLote") : numeroLote;
                        sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(recipientesGravar.toString())).append("'");
                        sqlpdate.append(" , leq_codigoreqapoio = '").append(StringUtil.getValor(pedido, TAG_COD_PED_APOIO)).append("'");
                        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
                        sqlpdate.append(" and req_codigo = ").append(req.getString(REQ_CODIGO));
                        sqlpdate.append(" and fil_kodigo = ").append(filial);
                        sqlpdate.append(" and lex_codigo = ").append(lote);
                        st.executeUpdate(sqlpdate.toString());
                        if (isColetaWeb || filial.equals(Variaveis.filialPadrao) && !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W")) continue;
                        IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
                    }
                    recipientesGravar.setLength(0);
                }
                this.atualizaCodigoApoiadoExameRequisicao(st, requisicoes, isColetaWeb, arquivar, anular);
                PrintService service = null;
                if (!isColetaWeb) {
                    service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(nomeReduzido, tamanhoNomeImpressora, impressorasLocais));
                }
                etqs.add(ImpressaoTermica.imprimirDireto(service, etiq.toString(), true, st, isColetaWeb, arquivar, anular));
            }
        }
        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("hpardini") : new ArrayList();
        etqs.addAll(etq);
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("hpardini", etqs);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        return retorno;
    }

    private void gerarXML(String numeroLote, String codigoConvenio, String adicionalLote, boolean naoEnviarObsRequisicao, List<Registro> requisicoes, boolean isUtilizarHPDirect, boolean enviarDadosMedico, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.escreveHeader("1.0", "ISO-8859-1");
        this.xml.abrir(TAG_REGISTRO);
        this.xml.escrever(TAG_ID, numeroLote);
        this.xml.escrever(TAG_PROTOCOLO, "2");
        this.xml.abrir(TAG_LOTE);
        this.xml.escrever(TAG_COD_LAB, codigoConvenio);
        this.xml.escrever(TAG_COD_LOTE_LAB, (!Funcoes.textoVazio(adicionalLote) ? adicionalLote : "") + numeroLote);
        this.xml.escrever(TAG_DATA_LOTE, Funcoes.formataData("yyyy-MM-dd", new Date()));
        this.xml.escrever(TAG_HORA_LOTE, Funcoes.formataData("HH:mm:ss", new Date()));
        List<Registro> requisicoesPais = ExportacaoParaHPardini.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        for (Registro req : requisicoesPais) {
            ArrayList<Registro> medicos = this.adicionaMedico(requisicoes, req);
            this.criarPedido(req, naoEnviarObsRequisicao, isUtilizarHPDirect, enviarDadosMedico, medicos, digitosTuboFilial, digitosTuboRequisicao, st, agruparGuiasInterface);
        }
        this.xml.fechar(TAG_LOTE);
        this.xml.fechar(TAG_REGISTRO);
    }

    private ArrayList<Registro> adicionaMedico(List<Registro> requisicoes, Registro requisicaoMae) {
        ArrayList<Registro> medicos = new ArrayList<Registro>();
        String reqMae = requisicaoMae.getString(REQ_CODIGO_MAE);
        for (Registro req : requisicoes) {
            if (!reqMae.equals(req.getString(REQ_CODIGO_MAE))) continue;
            Registro re = new Registro();
            re.setValor(FIL_CODIGO, req.getString(FIL_CODIGO));
            re.setValor("requisicao", req.getString(REQ_CODIGO));
            re.setValor("medicoCRM", req.getString(MED_NUMERO_CONSELHO));
            re.setValor("ufMedico", req.getString(MED_UF_CONSELHO));
            re.setValor("conselhoMedico", req.getString(MED_SIGLA_CONSELHO));
            re.setValor("nomeMedico", req.getString(MED_NOME));
            if (this.medicoJaAdicionado(medicos, re)) continue;
            medicos.add(re);
        }
        return medicos;
    }

    private boolean medicoJaAdicionado(ArrayList<Registro> listaMedicos, Registro med) {
        for (Registro medico : listaMedicos) {
            if (!medico.getString("medicoCRM").equalsIgnoreCase(med.getString("medicoCRM")) || !medico.getString("ufMedico").equalsIgnoreCase(med.getString("ufMedico"))) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Registro> getExamesRequisicao(Registro req) {
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        List exames = (List)req.getValor("listaexames");
        for (Registro exa : exames) {
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (!Funcoes.objectIsNull(listaExamesDesmembrados) && listaExamesDesmembrados.size() > 0) {
                for (Registro desm : listaExamesDesmembrados) {
                    if (!this.isMesmoCodigoRequisicao(req, desm)) continue;
                    listaExames.add(desm);
                }
                continue;
            }
            if (!this.isMesmoCodigoRequisicao(req, exa)) continue;
            listaExames.add(exa);
        }
        return listaExames;
    }

    private boolean isMesmoCodigoRequisicao(Registro req, Registro exame) {
        return req.getString(FIL_CODIGO).equalsIgnoreCase(exame.getString(FIL_KODIGO)) && req.getString(REQ_CODIGO).equalsIgnoreCase(exame.getString(REQ_CODIGO));
    }

    private boolean validarConfiguracao(String configuracaoLabExterno, boolean validaConexao) {
        String senhaWebservice;
        boolean isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
        String codigoWebservice = configuracaoLabExterno.indexOf(CODIGO_PROTOCOLO) > 0 ? StringUtil.getValor(configuracaoLabExterno, CODIGO_PROTOCOLO) : null;
        String string = senhaWebservice = configuracaoLabExterno.indexOf("senhaWeb") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senhaWeb") : null;
        if (isEnviarWebService) {
            if (Funcoes.textoVazio(codigoWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O c\u00f3digo do protocolo do Hermes Pardini n\u00e3o foi configurado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(senhaWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A senha do Hermes Pardini n\u00e3o foi configurada.", 2);
                return false;
            }
            if (validaConexao) {
                try {
                    if (!UtilExportadores.comunicacaoOk("https://www.hermespardini.com.br/b2b/HPWS.XMLServer.cls", false, Protocolo.HPardini.getDescricao()).isImprimiu()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
                    return false;
                }
            }
        }
        return true;
    }

    private void atualizaCodigoApoiadoExameRequisicao(Statement st, List<Registro> requisicoes, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        for (Registro req : requisicoes) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            try {
                for (Registro exa : exames) {
                    sql.setLength(0);
                    sql.append(" select exr_codigoapoiado from examerequisicao  ");
                    sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                    sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                    sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                    sql.append(" and exr_codigoapoiado is null ");
                    ResultSet rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        sql.setLength(0);
                        sql.append(" update  examerequisicao set exr_codigoapoiado = ").append(!Funcoes.textoVazio(exa.getString(TAG_COD_BAR_APOIO)) ? exa.getString(TAG_COD_BAR_APOIO) : "''");
                        sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                        sql.append("   and req_codigo = ").append(req.getString(REQ_CODIGO));
                        sql.append("   and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                        if (isColetaWeb) {
                            st.executeUpdate(sql.toString());
                        } else {
                            Conexao.executeUpdate(req.getString(FIL_CODIGO), st, sql);
                        }
                    }
                    sql.setLength(0);
                    sql.append(" select ere_codigoapoiado from examerequisicaorecipiente ");
                    sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                    sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                    sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                    sql.append(" and ere_codigoapoiado is null ");
                    rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        sql.setLength(0);
                        sql.append(" update  examerequisicaorecipiente set ere_codigoapoiado = ").append(!Funcoes.textoVazio(exa.getString(TAG_COD_BAR_APOIO)) ? exa.getString(TAG_COD_BAR_APOIO) : "''");
                        sql.append(" where fil_codigo = ").append(req.getString(FIL_CODIGO));
                        sql.append(" and req_codigo =  ").append(req.getString(REQ_CODIGO));
                        sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                        sql.append(" and mco_codigo = ").append(exa.getString(MCO_CODIGO));
                        if (isColetaWeb) {
                            st.executeUpdate(sql.toString());
                        } else {
                            Conexao.executeUpdate(req.getString(FIL_CODIGO), st, sql);
                        }
                    }
                    arquivar.call();
                }
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private String getRecipiente(String exaJalis, String matJalis, String requisicao, String filial, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append("select rec_kodigo from examerequisicaorecipiente ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(requisicao);
        buf.append("   and mco_codigo = ").append(matJalis);
        buf.append("   and exa_codigo = '").append(exaJalis).append("' ");
        buf.append("   and ere_codigoapoiado is null ");
        buf.append(" limit 1 ");
        ResultSet rs = null;
        try {
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                return rs.getString(REC_KODIGO);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void criarPedido(Registro req, boolean naoEnviarObsRequisicao, boolean isUtilizarHPDirect, boolean enviarDadosMedico, ArrayList<Registro> medicos, int digitosTuboFilial, int digitosTuboRequisicao, Statement st, boolean agruparGuiasInterface) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.abrir(TAG_PEDIDO);
        this.xml.escrever(TAG_COD_PED_LAB, Funcoes.preencheZero(req.getString(FIL_CODIGO), digitosTuboFilial) + Funcoes.preencheZero(req.getString(REQ_CODIGO), digitosTuboRequisicao));
        this.xml.escrever(TAG_DATA_PED, this.formatar("yyyy-MM-dd", req.getDate(REQ_DATA)));
        this.xml.escrever(TAG_HORA_PED, this.formatar("HH:mm:ss", req.getDate(REQ_HORA)));
        this.xml.escrever(TAG_DATA_ULT_MENS, this.formatar("yyyy-MM-dd", req.getDate(REQ_DUM)));
        this.trataCampoObservacao(req);
        String obs = req.getString(REQ_OBS);
        if (naoEnviarObsRequisicao) {
            obs = "";
        }
        this.xml.escrever("Obs", this.removerEnter(obs.length() > 100 ? obs.substring(0, 100) : obs).replaceAll("\"", ""));
        this.xml.abrir(TAG_PACIENTE);
        this.xml.escrever(TAG_COD_PAC_LAB, req.getString(PAC_CODIGO));
        this.xml.escrever("Nome", StringUtil.limpaXmlEnvioWebService(req.getString(PAC_NOME)));
        this.xml.escrever(TAG_SEXO, this.getSexo(req.getString(PAC_SEXO)));
        if (req.nulo(PAC_DATANASC)) {
            this.xml.escrever(this.getTagIdadePaciente(req), req.getString(REQ_IDADE));
        } else {
            this.xml.escrever(TAG_DATA_NASC, Funcoes.formataData("yyyy-MM-dd", req.getDate(PAC_DATANASC)));
        }
        this.xml.fechar(TAG_PACIENTE);
        boolean isMultiguias = this.verificaAgrupaMultiguias(req.getString(FIL_CODIGO), req.getString(REQ_CODIGO), st, agruparGuiasInterface);
        int seqMed = 0;
        if (enviarDadosMedico) {
            if (isMultiguias) {
                ArrayList<Registro> listaMedicos = new ArrayList<Registro>();
                for (Registro re : medicos) {
                    if (this.validaMedico(re, this.xml, listaMedicos)) continue;
                    this.xml.abrir(TAG_MEDICO);
                    this.xml.escrever(TAG_SEQ_MED, String.valueOf(++seqMed));
                    this.xml.escrever(TAG_SIGLA_CONSELHO_MED, re.getString("conselhoMedico"));
                    this.xml.escrever(TAG_UF_CONSELHO_MED, re.getString("ufMedico"));
                    this.xml.escrever(TAG_NUMERO_CONSELHO_MED, re.getString("medicoCRM"));
                    this.xml.escrever("Nome", StringUtil.removerAcentos(re.getString("nomeMedico")));
                    this.xml.fechar(TAG_MEDICO);
                    re.setValor(TAG_SEQ_MED, seqMed);
                }
            } else {
                this.xml.abrir(TAG_MEDICO);
                this.xml.escrever(TAG_SEQ_MED, String.valueOf(++seqMed));
                this.xml.escrever(TAG_SIGLA_CONSELHO_MED, req.getString(MED_SIGLA_CONSELHO));
                this.xml.escrever(TAG_UF_CONSELHO_MED, req.getString(MED_UF_CONSELHO));
                this.xml.escrever(TAG_NUMERO_CONSELHO_MED, req.getString(MED_NUMERO_CONSELHO));
                this.xml.escrever("Nome", StringUtil.removerAcentos(req.getString(MED_NOME)));
                this.xml.fechar(TAG_MEDICO);
                medicos.get(0).setValor(TAG_SEQ_MED, seqMed);
            }
        }
        List listaExames = (List)req.getValor("listaexames");
        Map<ExameMaterialPardini, Integer> exaPardini = null;
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        for (Registro exa : listaExames) {
            String key = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
            if (listaExamesAdicionados.contains(key)) continue;
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (listaExamesDesmembrados != null && listaExamesDesmembrados.size() > 0) {
                exaPardini = this.carregarExamesPardini(listaExamesDesmembrados);
                for (Registro desm : listaExamesDesmembrados) {
                    key = desm.getString(EXA_CODIGO) + desm.getString(MCO_CODIGO);
                    if (listaExamesAdicionados.contains(key)) continue;
                    desm.setValor(TAG_ID_MEDICO_SOLICITANTE, this.getIDMedicoSolicitante(medicos, desm, req));
                    this.gravarDadosExame(desm, exaPardini, obs, req, isUtilizarHPDirect, st, agruparGuiasInterface);
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            exa.setValor(TAG_ID_MEDICO_SOLICITANTE, this.getIDMedicoSolicitante(medicos, exa, req));
            exaPardini = this.carregarExamesPardini(listaExames);
            this.gravarDadosExame(exa, exaPardini, obs, req, isUtilizarHPDirect, st, agruparGuiasInterface);
            listaExamesAdicionados.add(key);
        }
        this.xml.fechar(TAG_PEDIDO);
    }

    private Registro getDadosMedicos(Registro req, int seqMed) {
        Registro regMed = new Registro();
        regMed.setValor(TAG_SEQ_MED, String.valueOf(seqMed));
        regMed.setValor(TAG_SIGLA_CONSELHO_MED, req.getString(MED_SIGLA_CONSELHO));
        regMed.setValor(TAG_UF_CONSELHO_MED, req.getString(MED_UF_CONSELHO));
        regMed.setValor(TAG_NUMERO_CONSELHO_MED, req.getString(MED_NUMERO_CONSELHO));
        regMed.setValor("Nome", StringUtil.removerAcentos(req.getString(MED_NOME)));
        regMed.setValor(REQ_CODIGO, req.getValor(REQ_CODIGO));
        List listaExames = (List)req.getValor("listaexames");
        regMed.setValor("listaexames", listaExames);
        return regMed;
    }

    private boolean validaMedico(Registro registro, XMLStringBuilder xml, ArrayList<Registro> listaMedicos) {
        String crm = registro.getString("medicoCRM");
        String ufMedico = registro.getString("ufMedico");
        String conselhoMedico = registro.getString("conselhoMedico");
        if (!listaMedicos.isEmpty()) {
            for (Registro reg : listaMedicos) {
                if (!reg.getString("pedido").equals(StringUtil.getValor(xml.toString(), TAG_COD_PED_LAB)) || !reg.getString("crmMedico").equalsIgnoreCase(crm) || !reg.getString("ufMedico").equalsIgnoreCase(ufMedico) || !reg.getString("conselho").equalsIgnoreCase(conselhoMedico)) continue;
                return true;
            }
        }
        Registro re = new Registro();
        re.setValor("pedido", StringUtil.getValor(xml.toString(), TAG_COD_PED_LAB));
        re.setValor("crmMedico", crm);
        re.setValor("ufMedico", ufMedico);
        re.setValor("conselho", conselhoMedico);
        listaMedicos.add(re);
        return false;
    }

    private boolean verificaAgrupaMultiguias(String fil_codigo, String req_codigo, Statement st, boolean agruparGuiasInterface) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(st, fil_codigo, req_codigo, true, false);
        return this.isAgruparMultiguias(fil_codigo, multiguias, st, agruparGuiasInterface);
    }

    private boolean isAgruparMultiguias(String fil_codigo, Integer[] multiguias, Statement st, boolean agruparGuiasInterface) throws SQLException {
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, fil_codigo, multiguias);
    }

    private void trataCampoObservacao(Registro req) {
        String observacao = req.getValor(REQ_OBS, String.class);
        if (!Funcoes.textoVazio(observacao)) {
            observacao = StringUtil.removerAcentos(observacao).replaceAll("[^a-zA-Z1-9: ]", "");
            req.setValor(REQ_OBS, observacao);
        }
    }

    private String removerEnter(String txt) {
        return txt.replaceAll("\n", " ");
    }

    private void gravarDadosExame(Registro exa, Map<ExameMaterialPardini, Integer> exaPardini, String obsRequisicao, Registro req, boolean isUtilizarHPDirect, Statement st, boolean agruparGuiasInterface) throws XMLStringBuilderException, ParseException, SQLException {
        Map infoComp;
        Double altura;
        Double peso;
        String volumeDiurese;
        Map<String, String> dadosAdicionais;
        String tempoDiurese;
        String condicao;
        this.xml.abrir(TAG_EXAME);
        this.xml.escrever(TAG_COD_EXM_LAB, exa.getString(EXA_CODIGO) + "|" + exa.getString(MCO_CODIGO));
        ExameMaterialPardini exaMat = new ExameMaterialPardini(exa.getString(CODIGO_EXAME), exa.getString(CODIGO_MATERIAL));
        this.xml.escrever(TAG_COD_EXM_APOIO, exaMat.material + "|" + exaMat.exame + "|" + exa.getInt("numero-amostra"));
        exaPardini.put(exaMat, exaPardini.get(exaMat) + 1);
        if (exaMat.material.equalsIgnoreCase("DIV") && exa.getBoolean("utilizar-mat-requisicao")) {
            this.xml.escrever(TAG_DESC_MAT, Funcoes.textoVazio(exa.getString(EXR_DESCRICAOMATERIAL)) ? StringUtil.limpaXmlEnvioWebService(exa.getString(MCO_DESCRICAO)) : StringUtil.limpaXmlEnvioWebService(exa.getString(EXR_DESCRICAOMATERIAL)));
        } else if (!Funcoes.textoVazio(exa.getString("material-selecionado"))) {
            this.xml.escrever(TAG_DESC_MAT, StringUtil.limpaXmlEnvioWebService(exa.getString("material-selecionado")));
        }
        if (this.contemCondicaoAmostra() && !Funcoes.textoVazio(condicao = this.getCondicaoExame(exa, st, agruparGuiasInterface))) {
            this.xml.escrever(TAG_CONDICAO_AMOSTRA, StringUtil.limpaXmlEnvioWebService(condicao));
        }
        this.xml.escrever(TAG_CONSERVANTE, exa.getString("conservante-selecionado"));
        this.xml.escrever(TAG_DATA_COLETA, this.formatar("yyyy-MM-dd", exa.getDate(EXR_DATAMATERIAL) != null ? exa.getDate(EXR_DATAMATERIAL) : Funcoes.getHoraServidor()));
        this.xml.escrever(TAG_HORA_COLETA, this.formatar("HH:mm:ss", exa.getDate(EXR_DATAMATERIAL) != null ? exa.getDate(EXR_DATAMATERIAL) : Funcoes.getHoraServidor()));
        List solicitantes = (List)exa.getValor(TAG_ID_MEDICO_SOLICITANTE);
        for (Registro solicitante : solicitantes) {
            this.xml.escrever(TAG_ID_MEDICO_SOLICITANTE, solicitante.getString(TAG_SEQ_MED));
        }
        if (isUtilizarHPDirect && !Funcoes.textoVazio(exa.getString(EXR_CODIGOAPOIADO))) {
            this.xml.escrever(TAG_ID_TUBO_LAB, exa.getString(EXR_CODIGOAPOIADO));
        }
        if (!Funcoes.textoVazio(tempoDiurese = this.getTempoDiurese(exa, dadosAdicionais = this.getDadosAdicionaisExame(exa)))) {
            this.gravaInformacaoComplementar("TempoDiurese", tempoDiurese);
        }
        if (!Funcoes.textoVazio(volumeDiurese = this.getVolumeDiurese(exa, dadosAdicionais))) {
            this.gravaInformacaoComplementar("VolumeDiurese", volumeDiurese);
        }
        if ((peso = this.getPeso(req, dadosAdicionais)).intValue() >= 0) {
            this.gravaInformacaoComplementar("Peso", peso.toString());
        }
        if ((altura = this.getAltura(req, dadosAdicionais)).intValue() >= 0) {
            this.gravaInformacaoComplementar("Altura", altura.toString());
        }
        if (!Funcoes.textoVazio(exa.getString("exr_linfocitosabsoluto"))) {
            this.gravaInformacaoComplementar("LinfocitosAbsoluto", exa.getString("exr_linfocitosabsoluto"));
        }
        StringBuilder obs = new StringBuilder();
        if (!Funcoes.textoVazio(exa.getString("exr_tempoamostra"))) {
            this.gravaInformacaoComplementar("TempoAmostra", Funcoes.preencheZero(exa.getString("exr_tempoamostra").trim(), 2));
        }
        if (!Funcoes.textoVazio(exa.getString("exr_pesoamostra"))) {
            this.gravaInformacaoComplementar("PesoAmostra", exa.getString("exr_pesoamostra").trim());
        }
        if (!Funcoes.textoVazio(exa.getString("exr_hematocrito"))) {
            String hemato = exa.getString("exr_hematocrito").trim().replace(',', '.');
            this.gravaInformacaoComplementar("Hematocrito", hemato);
        }
        if (!Funcoes.textoVazio(exa.getString("exr_glicemia"))) {
            String glicemia = exa.getString("exr_glicemia").trim().replace(',', '.');
            this.gravaInformacaoComplementar("Glicemia", glicemia);
        }
        if (!Funcoes.textoVazio(exa.getString(PERIODO_GESTACIONAL))) {
            this.gravaInformacaoComplementar("SemanaGestacao", exa.getString(PERIODO_GESTACIONAL));
            this.gravaInformacaoComplementar("SexoColhedor", req.getString(PAC_SEXO));
        }
        if (!Funcoes.textoVazio(exa.getString(DATA_SINTOMA))) {
            String dataSintoma = !Funcoes.textoVazio(exa.getString(APRESENTOU_SINTOMA)) && exa.getString(APRESENTOU_SINTOMA).equalsIgnoreCase("Sim") ? Funcoes.formataData("dd/MM/yyyy", exa.getDate(DATA_SINTOMA)) : "";
            this.gravaInformacaoComplementar("DataSintoma", dataSintoma);
        }
        if (!Funcoes.textoVazio(exa.getString(MUNICIPIO_RESIDENCIA))) {
            this.gravaInformacaoComplementar("MunicipioResidencia", StringUtil.removerAcentos(exa.getString(MUNICIPIO_RESIDENCIA)));
        }
        if (!Funcoes.textoVazio(exa.getString(APRESENTOU_SINTOMA))) {
            String sintoma = exa.getString(APRESENTOU_SINTOMA).equals("Sim") ? "S" : "N";
            this.gravaInformacaoComplementar("Sintoma", sintoma);
        }
        if ((infoComp = exa.getValor("infoComp", Map.class)) != null && !infoComp.isEmpty()) {
            for (String key : infoComp.keySet()) {
                this.gravaInformacaoComplementar(key, (String)infoComp.get(key));
            }
        }
        String tmp = obsRequisicao != null ? obsRequisicao : "";
        obs.append(StringUtil.removerAcentos(this.removerEnter(tmp)).replaceAll("\"", ""));
        if (obs.toString().trim().length() > 100) {
            tmp = obs.toString();
            obs = new StringBuilder();
            obs.setLength(0);
            obs.append(tmp.substring(0, 100));
        }
        if (!Funcoes.textoVazio(obs.toString())) {
            this.xml.escrever("Observacao", StringUtil.limpaXmlEnvioWebService(obs.toString()));
        }
        this.xml.fechar(TAG_EXAME);
    }

    private Map<String, String> getDadosAdicionaisExame(Registro exame) {
        return exame.getValor("dadosadicionais") != null ? (HashMap)exame.getValor("dadosadicionais") : new HashMap();
    }

    private Double getAltura(Registro req, Map<String, String> dadosAdicionais) {
        Double altura = 0.0;
        if (dadosAdicionais.containsKey("Altura") && !Funcoes.textoVazio(dadosAdicionais.get("Altura")) && Funcoes.isNumeric(dadosAdicionais.get("Altura"))) {
            altura = Double.parseDouble(dadosAdicionais.get("Altura").replace("\\,", "."));
        } else if (!Funcoes.textoVazio(req.getString(REQ_ALTURA)) && Funcoes.isNumeric(req.getString(REQ_ALTURA))) {
            altura = Double.parseDouble(req.getString(REQ_ALTURA).replace("\\,", "."));
        }
        if (altura.intValue() > 3) {
            if (altura.intValue() > 100) {
                altura = altura / 100.0;
            } else if (altura.intValue() > 10) {
                altura = altura / 10.0;
            }
        }
        return altura;
    }

    private String getTempoDiurese(Registro exa, Map<String, String> dadosAdicionais) {
        String tempoDiurese = "00";
        if (dadosAdicionais.containsKey("TempoDiurese") && !Funcoes.textoVazio(dadosAdicionais.get("TempoDiurese"))) {
            tempoDiurese = dadosAdicionais.get("TempoDiurese");
        } else if (!Funcoes.textoVazio(exa.getString(EXR_TEMPODIURESE))) {
            tempoDiurese = exa.getString(EXR_TEMPODIURESE);
        }
        if (!Funcoes.textoVazio(tempoDiurese)) {
            if (tempoDiurese.indexOf(":") >= 1) {
                tempoDiurese = tempoDiurese.substring(0, tempoDiurese.indexOf(":"));
            }
            if (tempoDiurese.length() > 5) {
                tempoDiurese = tempoDiurese.substring(0, 5);
            }
        }
        return tempoDiurese;
    }

    private String getVolumeDiurese(Registro exa, Map<String, String> dadosAdicionais) {
        Float valor;
        String volumeDiurese = "0";
        if (dadosAdicionais.containsKey("TempoDiurese") && !Funcoes.textoVazio(dadosAdicionais.get("TempoDiurese"))) {
            volumeDiurese = StringUtil.limpaString(dadosAdicionais.get("VolumeDiurese"), new String[]{",", ".", ":", "\\"});
        } else if (!Funcoes.textoVazio(exa.getString(EXR_VOLUMEDIURESE))) {
            volumeDiurese = StringUtil.limpaString(exa.getString(EXR_VOLUMEDIURESE), new String[]{",", ".", ":", "\\"});
        }
        if (volumeDiurese.length() > 5) {
            volumeDiurese = volumeDiurese.substring(0, 5);
        }
        if ((valor = Float.valueOf(volumeDiurese.replace("\\,", "."))).floatValue() > 0.0f) {
            volumeDiurese = String.valueOf(Math.round(valor.floatValue()));
        }
        return volumeDiurese;
    }

    private Double getPeso(Registro req, Map<String, String> dadosAdicionais) {
        Double peso = 0.0;
        if (dadosAdicionais.containsKey("Peso") && !Funcoes.textoVazio(dadosAdicionais.get("Peso")) && Funcoes.isNumeric(dadosAdicionais.get("Peso"))) {
            return Double.valueOf(dadosAdicionais.get("Peso"));
        }
        if (!Funcoes.textoVazio(req.getString(REQ_PESO)) && Funcoes.isNumeric(req.getString(REQ_PESO))) {
            return Double.valueOf(req.getString(REQ_PESO));
        }
        return peso;
    }

    private List<Registro> getIDMedicoSolicitante(List<Registro> dadosMedico, Registro exa, Registro req) {
        ArrayList<Registro> solicitantes = new ArrayList<Registro>();
        List exaSolicitante = (List)exa.getValor("solicitantes");
        for (Registro med : dadosMedico) {
            if (exaSolicitante == null) continue;
            for (Registro exaMed : exaSolicitante) {
                if (!med.getString("medicoCRM").equalsIgnoreCase(exaMed.getString("medicoCRM")) || !med.getString("ufMedico").equalsIgnoreCase(exaMed.getString("ufMedico"))) continue;
                solicitantes.add(med);
            }
        }
        return solicitantes;
    }

    private String getCondicaoExame(Registro exa, Statement st, boolean agruparGuiasInterface) throws SQLException {
        String condicao = "";
        for (InterfaceDesmembrar ex : this.getCondicaoExamesDesm()) {
            Integer[] requisicoes = new Integer[]{exa.getInt(REQ_CODIGO_MAE)};
            boolean agruparMultiguia = this.isAgruparMultiguias(exa.getString(FIL_CODIGO), requisicoes, st, agruparGuiasInterface);
            if (!this.isMesmoExame(exa, ex, st, agruparGuiasInterface) || !ex.getCodRec().equals(exa.getString(REQ_CODIGO)) && (!agruparMultiguia || !ex.getCodRec().equals(exa.getString(REQ_CODIGO_MAE)))) continue;
            condicao = ex.getCondicaoAmostra();
            break;
        }
        return condicao;
    }

    private boolean isMesmoExame(Registro exa, InterfaceDesmembrar ex, Statement st, boolean agruparGuiasInterface) {
        boolean exameIgual;
        String matCodigo = String.valueOf(ex.getMaterial().getCodigo());
        boolean bl = exameIgual = ex.getCodigo().equalsIgnoreCase(exa.getString(EXA_CODIGO)) && matCodigo.equalsIgnoreCase(exa.getString(MCO_CODIGO));
        if (!ExportacaoParaHPardini.possuiAgrupamentoMultiguia(exa, exa, st, agruparGuiasInterface)) {
            exameIgual = exameIgual && exa.getString(REQ_CODIGO).equals(ex.getCodRec());
        }
        return exameIgual;
    }

    private boolean contemCondicaoAmostra() {
        return !this.getCondicaoExamesDesm().isEmpty();
    }

    private void gravaInformacaoComplementar(String infoComp, String valor) throws NumberFormatException, XMLStringBuilderException {
        this.xml.abrir("InformacaoComplementar");
        this.xml.escrever("InfoComp", infoComp);
        this.xml.escrever("Valor", valor);
        this.xml.fechar("InformacaoComplementar");
    }

    private Map<ExameMaterialPardini, Integer> carregarExamesPardini(List<Registro> exames) {
        HashMap<ExameMaterialPardini, Integer> map = new HashMap<ExameMaterialPardini, Integer>();
        for (Registro exa : exames) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(exa.getString(ELE_XML_LAB_EXTERNO));
            if (ehp == null) continue;
            exa.setValor(CODIGO_EXAME, ehp.getMnemonicoExame());
            exa.setValor(CODIGO_MATERIAL, ehp.getMnemonicoMaterial());
            exa.setValor("utilizar-mat-requisicao", ehp.utilizarMatRequisicao());
            exa.setValor("material-selecionado", ehp.getMaterialSelecinado());
            exa.setValor("conservante-selecionado", ehp.getConservanteSelecionado());
            exa.setValor("numero-amostra", ehp.getNumeroAmostra());
            if (ehp.getNumeroAmostra().isEmpty()) {
                exa.setValor("numero-amostra", "1");
            }
            map.put(new ExameMaterialPardini(ehp.getMnemonicoExame(), ehp.getMnemonicoMaterial()), exa.getInt("numero-amostra"));
        }
        return map;
    }

    protected String formatar(String masc, Date data) {
        if (masc != null && data != null) {
            return Funcoes.formataData(masc, data);
        }
        return "";
    }

    protected String getTagIdadePaciente(Registro req) {
        if (req.getString("req_anomes").equalsIgnoreCase("A")) {
            return "IdadeAno";
        }
        if (req.getString("req_anomes").equalsIgnoreCase("M")) {
            return "IdadeMes";
        }
        return "IdadeDia";
    }

    protected String getSexo(String tipo) {
        if (tipo.equals("M")) {
            return "Masculino";
        }
        if (tipo.equals("F")) {
            return "Feminino";
        }
        return "Indefinido";
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public String getEtiquetaWebService() {
        if (Funcoes.textoVazio(this.retornoHPardini)) {
            return null;
        }
        String etiqueta = StringUtil.getValor(this.retornoHPardini, TAG_ETIQ_COD_BAR_HP);
        if (Funcoes.textoVazio(etiqueta)) {
            return null;
        }
        return etiqueta;
    }

    public static ArrayList<Registro> verificaExamesComLote(String filial, String requisicao, ArrayList<Registro> listaExames, ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir, Statement st) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as materialExame, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_codigo = ").append(filial);
        buf.append("   and lot.req_codigo = ").append(requisicao).append(" ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (!listaExamesNaoImprimir.isEmpty()) {
            buf.append("   and lotex.exa_codigo not in (").append(ExportacaoParaHPardini.condicaoExameIn(listaExamesNaoImprimir)).append(") ");
            buf.append("\t and lotex.mco_codigo not in (").append(ExportacaoParaHPardini.condicaoMaterialIn(listaExamesNaoImprimir)).append(") ");
        }
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                Integer lote = rs.getInt(LEX_CODIGO);
                for (Registro reg : listaExames) {
                    if (lista.contains(reg) || !reg.getString(EXA_CODIGO).equalsIgnoreCase(rs.getString(CODIGO_EXAME)) || !reg.getString(MCO_CODIGO).equalsIgnoreCase(rs.getString("materialExame"))) continue;
                    reg.setValor(LEQ_RETORNO_WS, rs.getString("retornoWs"));
                    reg.setValor(LEX_CODIGO, lote);
                    reg.setValor(GERAR_LOTE, false);
                    lista.add(reg);
                }
            }
            for (Registro reg : lista) {
                if (!listaExames.contains(reg)) continue;
                listaExames.remove(listaExames.indexOf(reg));
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
        }
        return lista;
    }

    private static String condicaoExameIn(ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir) {
        StringBuilder sql = new StringBuilder();
        for (ExameMaterial exame : listaExamesNaoImprimir) {
            sql.append("'").append(exame.getCodigoExame()).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }

    private static String condicaoMaterialIn(ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir) {
        StringBuilder sql = new StringBuilder();
        for (ExameMaterial exame : listaExamesNaoImprimir) {
            sql.append(exame.getCodigoMaterial()).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }

    public static ArrayList<Registro> verificaRequisicoesComLote(List<Registro> listaRequisicoes, Integer[] multiguias, String filial, Statement st) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.leq_retornows as retornoWs, lot.lex_codigo ");
        buf.append("  from loteexternorequisicao lot ");
        buf.append(" where lot.fil_codigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                lista.add(new Registro(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
        }
        return lista;
    }

    class ListaRegistro
    extends ArrayList<Registro> {
        ListaRegistro() {
        }

        @Override
        public boolean add(Registro a) {
            boolean isExiste = false;
            for (Registro b : this) {
                if (!b.getString(ExportacaoParaHPardini.EXA_CODIGO).equalsIgnoreCase(a.getString(ExportacaoParaHPardini.EXA_CODIGO)) || !b.getString(ExportacaoParaHPardini.MCO_CODIGO).equalsIgnoreCase(a.getString(ExportacaoParaHPardini.MCO_CODIGO))) continue;
                isExiste = true;
                break;
            }
            if (isExiste) {
                return false;
            }
            return super.add(a);
        }
    }
}

