/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class ExportacaoParaConcent
extends ExportacaoParaAlvaro {
    private static final int REQ_GUIA_MAE = 0;
    private static final int REQ_GUIA_FILHA = 1;
    private boolean enviarTuboLis = false;
    private String codigoTuboLis = "";

    public ExportacaoParaConcent() {
        this.setDescricao("Arquivo de exporta\u00e7\u00e3o Concent (*.xml)");
    }

    public ExportacaoParaConcent(String descricao) {
        this.setDescricao(descricao);
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        boolean bl = this.enviarTuboLis = StringUtil.getValor(configuracaoLabExterno, "enviarTuboLis").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarTuboLis");
        if (this.enviarTuboLis) {
            this.codigoTuboLis = StringUtil.getValor(configuracaoLabExterno, "codigoTuboLis");
        }
        List<Registro> novaLista = IntegracaoLabExterno.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        return super.exportarExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, novaLista, colunaOrdenacao, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, agruparMultiguia);
    }

    private List<Registro> agruparMultiGuias(List<Registro> requisicoes) {
        ArrayList<Registro> novaLista = new ArrayList<Registro>();
        HashMap listaReq = new HashMap();
        for (int i = 0; i < requisicoes.size(); ++i) {
            if (!Funcoes.textoVazio(requisicoes.get(i).getString("req_codigomae"))) {
                listaReq.put(i, new ArrayList());
                ((List)listaReq.get(i)).add(0, requisicoes.get(i).getString("req_codigomae"));
                ((List)listaReq.get(i)).add(1, requisicoes.get(i).getString("req_codigo"));
                continue;
            }
            novaLista.add(requisicoes.get(i));
        }
        for (Integer pos : listaReq.keySet()) {
            List exames = (List)requisicoes.get(pos).getValor("listaexames");
            List examesMae = null;
            for (Registro r : requisicoes) {
                if (!r.getString("req_codigo").equals(((List)listaReq.get(pos)).get(0))) continue;
                examesMae = (List)r.getValor("listaexames");
                for (Registro regExame : exames) {
                    boolean existe = false;
                    for (Registro regExameMae : examesMae) {
                        if (!regExame.getString("exa_codigo").equals(regExameMae.getString("exa_codigo")) || !regExame.getString("mco_codigo").equals(regExameMae.getString("mco_codigo"))) continue;
                        existe = true;
                        break;
                    }
                    if (existe) continue;
                    examesMae.add(regExame);
                }
            }
            if (examesMae != null) continue;
            requisicoes.get(pos).setValor("req_codigo", requisicoes.get(pos).getValor("req_codigomae"));
            novaLista.add(requisicoes.get(pos));
        }
        return novaLista;
    }

    @Override
    protected void escreverSolicitacao(Registro r, String codLabExterno, String xmlConfiguracaoLabExterno, String numeroLote, boolean isNovaAmostra, List<Registro> listaRequisicoes, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        if (!this.enviarTuboLis) {
            super.escreverSolicitacao(r, codLabExterno, xmlConfiguracaoLabExterno, numeroLote, isNovaAmostra, listaRequisicoes, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
        } else {
            for (Registro list : listaRequisicoes) {
                r = list;
                String obs = r.getString("req_obs").replaceAll("\n", " ");
                if (obs.length() > 200) {
                    obs = obs.substring(0, 199).replaceAll("\n", "");
                }
                Boolean enviarLoteWebService = !Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
                StringBuilder codigo_lis = new StringBuilder();
                StringBuilder codigo_tubo_lis = new StringBuilder();
                codigo_lis.append(Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial));
                codigo_lis.append(Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao));
                String codigoLis = r.getString("req_codigomae");
                if (Funcoes.textoVazio(codigoLis)) {
                    codigoLis = r.getString("req_codigo");
                }
                codigo_tubo_lis.append(this.codigoTuboLis);
                codigo_tubo_lis.append(Funcoes.preencheZero(codigoLis, digitosTuboRequisicao));
                String crm = this.geraCrm(r, false);
                TreeMap<String, String> atributos = new TreeMap<String, String>();
                atributos.put("codigo_lis", codigo_lis.toString());
                atributos.put("codigo_paciente", r.getString("pac_codigo"));
                atributos.put("observacao", StringUtil.removerAcentos(obs));
                atributos.put("data", Funcoes.formataData("dd/MM/yyyy", r.getDate("req_data")));
                if (crm != null && (StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(xmlConfiguracaoLabExterno, "enviarMedico"))) {
                    atributos.put("crm", crm);
                }
                this.xml.abrirTag("solicitacao", atributos);
                List exames = (List)r.getValor("listaexames");
                Map<ExameMaterialAlvaro, Integer> exaAlvaro = this.carregarExamesAlvaro(exames);
                String material = "";
                HashMap amostras = new HashMap();
                HashMap<String, String> descricaoTubo = new HashMap<String, String>();
                HashMap<String, String> identificacaoTemp = new HashMap<String, String>();
                for (Registro ex : exames) {
                    List desm = (List)ex.getValor("listaexames");
                    if (desm != null && !desm.isEmpty()) {
                        exaAlvaro = this.carregarExamesAlvaro(desm);
                        for (Registro exaFilho : desm) {
                            material = this.escreveTagAmostra(ex, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, exaFilho, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface);
                        }
                        continue;
                    }
                    material = this.escreveTagAmostra(r, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, ex, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface);
                    Map<String, String> codRecipiente = this.getRecipiente(r, st, ex, digitosTuboTubo);
                    String codigoMaterialLabExterno = StringUtil.getValor(ex.getValor("ele_xmllabexterno").toString(), "material");
                    Array aux = (Array)ex.getValor("rec_kodigo");
                    try {
                        String[] auxInt;
                        if (aux == null) continue;
                        for (String recip : auxInt = (String[])aux.getArray()) {
                            String key = String.format("%s%s", codigo_tubo_lis.toString(), Funcoes.preencheZero(String.valueOf(recip), digitosTuboTubo)) + codigoMaterialLabExterno;
                            if (!amostras.containsKey(key)) {
                                amostras.put(key, new ArrayList());
                            }
                            descricaoTubo.put(key, codRecipiente.get(recip));
                            ((List)amostras.get(key)).add(ex);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                    this.xml.fecharTag("amostra");
                }
                this.xml.fecharTag("solicitacao");
            }
        }
    }

    public String escreveTagAmostra(Registro r, boolean isNovaAmostra, Boolean enviarLoteWebService, Map<String, String> atributos, String material, Statement st, Map<String, String> identificacaoTemp, Registro e, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface) throws SQLException {
        ExameAlvaro exa = new ExameAlvaro(e.getString("ele_xmllabexterno"));
        boolean temTempo = false;
        if (!exa.getLinhasResultado().isEmpty()) {
            for (LinhaResultado l : exa.getLinhasResultado()) {
                if (l.getTempos().isEmpty()) continue;
                temTempo = true;
                for (String tempo : l.getTempos()) {
                    if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                        this.xml.fecharTag("amostra");
                    }
                    String descricao = tempo + "min.";
                    atributos.clear();
                    atributos.put("material", e.getString("material"));
                    atributos.put("descricao", descricao);
                    this.xml.abrirTag("amostra", atributos);
                    if (isNovaAmostra) {
                        this.escreverExameXMLInsercao(e);
                        continue;
                    }
                    this.escreverExameXML(e, enviarLoteWebService, false, st);
                }
            }
            if (temTempo) {
                return material;
            }
        }
        if (!e.getString("material").equalsIgnoreCase(material)) {
            boolean agruparMultiguias;
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            atributos.clear();
            atributos.put("material", e.getString("material"));
            boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, e.getString("fil_codigo"), e.getString("req_codigo"));
            if (!agruparMultiguias) {
                if (Funcoes.textoVazio(e.getString("identificacao")) || Funcoes.textoVazio(e.getString("descricao"))) {
                    LaboratorioExterno[] labs;
                    block2: for (LaboratorioExterno laboratorioExterno : labs = LaboratorioExterno.getDescricoes(st, false)) {
                        Integer[] mulIntegers;
                        if (!laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                        for (Integer guia : mulIntegers = RecepcaoUtil.verificaMultiGuias(st, e.getString("fil_codigo"), e.getString("req_codigo"), true)) {
                            ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                            while (examesRegistros.next()) {
                                if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                if (Funcoes.textoVazio(atributos.get("identificacao"))) continue;
                            }
                            if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block2;
                        }
                    }
                }
                if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                    atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                }
                if (Funcoes.textoVazio(atributos.get("descricao"))) {
                    atributos.put("descricao", "N\u00e3o Informado");
                }
                if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                    atributos.put("novaAmostra", "true");
                }
            }
            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                atributos.put("identificacao", this.getIdentificacao(e, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
            }
            atributos.put("descricao", Funcoes.textoVazio(e.getString("rec_descricao")) ? (Funcoes.textoVazio(identificacaoTemp.get(e.getString("material"))) ? "N\u00e3o informado" : identificacaoTemp.get(e.getString("material"))) : e.getString("rec_descricao"));
            if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                atributos.put("novaAmostra", "true");
            }
            if (!Funcoes.textoVazio(atributos.get("descricao"))) {
                this.xml.abrirTag("amostra", atributos);
            }
        }
        if (isNovaAmostra) {
            this.escreverExameXMLInsercao(e);
        } else {
            this.escreverExameXML(e, enviarLoteWebService, false, st);
        }
        material = e.getString("material");
        identificacaoTemp.put(material, e.getString("exr_codigoapoiado"));
        return material;
    }

    @Override
    protected String getIdentificacao(Registro e, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) {
        if (!Funcoes.textoVazio(e.getString("exr_codigoapoiado"))) {
            return e.getString("exr_codigoapoiado");
        }
        String fil = Funcoes.preencheZero(e.getString("fil_codigo"), digitosTuboFilial);
        String req = Funcoes.preencheZero(e.getString("req_codigo"), digitosTuboRequisicao);
        if (!Funcoes.textoVazio(e.getString("req_codigomae")) && !e.getString("req_codigomae").equals(e.getString("req_codigo"))) {
            req = Funcoes.preencheZero(e.getString("req_codigomae"), digitosTuboRequisicao);
        }
        String rec = null;
        if (!Funcoes.textoVazio(e.getString("rec_kodigo"))) {
            rec = StringUtil.limpaString(e.getString("rec_kodigo"), new String[]{"{", "}"});
            rec = Funcoes.preencheZero(rec, digitosTuboTubo);
        }
        return fil + req + (!Funcoes.textoVazio(rec) ? rec : "");
    }

    private Map<String, String> getRecipiente(Registro r, Statement st, Registro e, int digitosTuboTubo) {
        HashMap<String, String> codRecipiente = new HashMap<String, String>();
        try {
            boolean isApoio = this.isRequisicaoDeApoio(st, r.getString("fil_codigo"), r.getString("req_codigo"));
            StringBuilder buf = new StringBuilder("select a.rec_kodigo ");
            if (!isApoio) {
                buf.append(", (CASE WHEN (trim(a.ere_codigoapoiado) != '') THEN cast(trim(a.ere_codigoapoiado) AS varchar) ELSE cast(trim(exr.exr_codigoapoiado) AS varchar)  END) AS exr_codigoapoiado");
            } else {
                buf.append(", '' as exr_codigoapoiado ");
            }
            buf.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
            buf.append(" from examerequisicaorecipiente a ");
            buf.append("  left join requisicaorequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_kodigo ");
            if (!isApoio) {
                buf.append(" left join examerequisicao exr on exr.fil_codigo = a.fil_codigo and exr.req_codigo = a.req_codigo and exr.exa_codigo = a.exa_codigo and exr.mco_codigo = a.mco_codigo ");
            }
            buf.append(" join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = a.rec_kodigo ");
            buf.append("where  a.fil_codigo = ").append(r.getString("fil_codigo"));
            buf.append(" and (a.req_codigo = ").append(r.getString("req_codigo"));
            buf.append("       or b.req_codigo = ").append(r.getString("req_codigo")).append(") ");
            buf.append(" and a.exa_codigo = '").append(e.getString("exa_codigo")).append("' ");
            buf.append(" and a.mco_codigo = ").append(e.getInt("mco_codigo"));
            buf.append(" and a.ere_tipo = '").append("C").append("'");
            buf.append(" order by a.rec_codigo ");
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String tubo;
                String codigoApoiado = rs.getString("exr_codigoapoiado");
                String string = tubo = codigoApoiado != null && codigoApoiado.trim().length() > 0 ? codigoApoiado.substring(codigoApoiado.length() - digitosTuboTubo, codigoApoiado.length()) : "";
                if (tubo.trim().length() > 0 && Integer.parseInt(tubo.trim()) == rs.getInt("rec_kodigo")) {
                    codRecipiente.put(rs.getString("rec_kodigo"), rs.getString("rec_descricao"));
                    continue;
                }
                if (tubo.trim().length() != 0) continue;
                codRecipiente.put(rs.getString("rec_kodigo"), rs.getString("rec_descricao"));
            }
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace(), "ExportacaoParaConcent: 125");
        }
        return codRecipiente;
    }

    private boolean isRequisicaoDeApoio(Statement st, String filial, String requisicao) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder("select req_codigo from loteapoiorequisicao ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and req_codigo = ").append(requisicao);
            ResultSet rs = st.executeQuery(buf.toString());
            retorno = rs.next();
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace(), "ExportacaoParaConcent: 236");
        }
        return retorno;
    }
}

