/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.EscreveArquivoXML;
import jalis.util.xml.EscreveArquivoXMLException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaBalague
extends IntegracaoLabExterno
implements Exportador {
    private EscreveArquivoXML xml = new EscreveArquivoXML(false);

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String nomeArquivo = Funcoes.formataData("dd-MM-yyyy_HH-mm-ss", new Date()) + ".xml";
        try {
            arquivar.call();
            if (isColetaWeb) {
                this.montaXml(requisicoes, st, nomeArquivo, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface);
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb(this.xml.getArquivo()));
                this.xml.fecharArquivo();
                retorno.setImprimiu(true);
                retorno.setExtensaoArquivo("xml");
                return retorno;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setSelectedFile(new File(nomeArquivo));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o Balagu\u00e9 (*.xml)", "xml"));
            int option = chooser.showOpenDialog(null);
            if (option == 0) {
                this.montaXml(requisicoes, st, chooser.getSelectedFile().getPath(), digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface);
                this.xml.fecharArquivo();
                retorno.setImprimiu(true);
            } else if (option == 1) {
                retorno.setImprimiu(true);
                return retorno;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel exportar exames " + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private void montaXml(List<Registro> requisicoes, Statement st, String path, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface) throws EscreveArquivoXMLException, ParseException, SQLException {
        this.xml.abrirArquivo(path);
        this.xml.abrir("pedidos");
        this.xml.abrir("pacientes");
        for (Registro registro : requisicoes) {
            this.escreverPaciente(st, registro, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface);
        }
        this.xml.fechar("pacientes");
        this.xml.fechar("pedidos");
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void escreverPaciente(Statement st, Registro registro, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface) throws EscreveArquivoXMLException, ParseException, SQLException {
        List exames = (List)registro.getValor("listaexames");
        this.xml.abrir("paciente");
        this.xml.escreverItem("cd_paciente", registro.getString("pac_codigo"));
        this.xml.escreverItem("cd_pedido", Funcoes.preencheZero(registro.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(registro.getString("req_codigo"), digitosTuboRequisicao));
        this.xml.escreverItem("nome", StringUtil.removerAcentos(registro.getString("pac_nome")));
        this.xml.escreverItem("sexo", registro.getString("pac_sexo"));
        this.xml.escreverItem("dt_nascimento", Funcoes.formataData("yyyy-MM-dd", registro.getDate("pac_datanasc")));
        this.xml.escreverItem("dt_atendimento", Funcoes.formataData("yyyy-MM-dd", registro.getDate("req_data")));
        this.xml.escreverItem("dum", Funcoes.formataData("yyyy-MM-dd", registro.getDate("req_dum")));
        this.xml.escreverItem("conselho", registro.getString("med_conselho") + "-" + registro.getString("med_uf"));
        this.xml.escreverItem("cd_conselho", registro.getString("med_crm"));
        this.xml.escreverItem("ds_conselho", StringUtil.removerAcentos(registro.getString("med_nome")));
        this.xml.escreverItem("obs", StringUtil.removerAcentos(registro.getString("req_obs")));
        this.xml.escreverItem("peso", String.valueOf(registro.getInt("req_peso")));
        this.xml.escreverItem("altura", Funcoes.formataDecimal(registro.getDouble("req_altura")));
        this.xml.abrir("exames");
        this.escreverExames(st, exames, registro, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface);
        this.xml.fechar("exames");
        this.xml.fechar("paciente");
    }

    private void escreverExames(Statement st, List<Registro> exames, Registro reg, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface) throws EscreveArquivoXMLException, SQLException, ParseException {
        StringBuilder bui = new StringBuilder();
        for (Registro ex : exames) {
            bui.setLength(0);
            this.xml.abrir("exame");
            bui.append(Funcoes.preencheZero(reg.getString("fil_codigo"), digitosTuboFilial));
            bui.append(Funcoes.preencheZero(reg.getString("req_codigo"), digitosTuboRequisicao));
            this.xml.escreverItem("cd_pedido", bui.toString());
            int recipiente = this.getRecipiente(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), ex.getString("exa_codigo"), ex.getInt("mco_codigo"), agruparInterface);
            if (recipiente != 0) {
                bui.append(Funcoes.preencheZero(recipiente, digitosTuboTubo));
                this.xml.escreverItem("cd_barra", bui.toString());
            }
            this.xml.escreverItem("dt_coleta", Funcoes.formataData("yyyy-MM-dd HH:mm:ss", ex.getDate("exr_datamaterial")));
            bui.setLength(0);
            this.xml.escreverItem("cd_exame", StringUtil.getValor(ex.getString("ele_xmllabexterno"), "codigo"));
            this.xml.escreverItem("material", StringUtil.getValor(ex.getString("ele_xmllabexterno"), "material"));
            this.xml.escreverItem("volume", ex.getString("exr_volumediurese"));
            this.xml.fechar("exame");
        }
    }

    private int getRecipiente(Statement st, String filial, String requisicao, String exame, int material, int agruparInterface) throws SQLException {
        String tipoReciepente = "C";
        if (agruparInterface == 1) {
            tipoReciepente = "T";
        }
        StringBuilder buf = new StringBuilder("select rec_codigo from examerequisicaorecipiente a ");
        buf.append("where  fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(exame).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        buf.append(" and ere_tipo = '").append(tipoReciepente).append("'");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            return rs.getInt("rec_codigo");
        }
        return 0;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }
}

