/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.EscreverXML;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.atitude.ParserImportacaoAtitude;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaAtitude
extends IntegracaoLabExterno
implements Exportador {
    private static final String TAG_ID_AMOSTRAS = "idAmostras";
    private static final String ATRIBUTO_VALOR = "valor";
    private static final String ATRIBUTO_ID_MATERIAL = "idMaterial";
    private static final String ATRIBUTO_DATA_LIBERACAO = "dataLiberacao";
    private static final String ATRIBUTO_DESCRICAO = "descricao";
    private static final String ATRIBUTO_COD_BARRAS_ORIGEM = "codBarrasOrigem";
    private static final String ATRIBUTO_COD_BARRAS = "codBarras";
    private static final String ATRIBUTO_ID_AMOSTRA = "idAmostra";
    private static final String ATRIBUTO_ID_MATERIAL_EXAME = "idMaterial";
    private static final String ATRIBUTO_MEDICAMENTOS = "medicamentos";
    private static final String ATRIBUTO_OBSERVACAO = "observacao";
    private static final String ATRIBUTO_OBSERVACAO_EXAME = "observacao";
    private static final String ATRIBUTO_DATA_ENTRADA = "dataEntrada";
    private static final String TAG_AMOSTRAS = "amostras";
    private static final String TAG_AMOSTRA = "amostra";
    private static final String ATRIBUTO_CRM = "crm";
    private static final String ATRIBUTO_CRM_UF = "crmUf";
    private static final String ATRIBUTO_DATA_NASCIMENTO = "dataNasc";
    private static final String ATRIBUTO_SEXO = "sexo";
    private static final String ATRIBUTO_NOME = "nome";
    private static final String ATRIBUTO_ID_LIS = "idLis";
    private static final String ATRIBUTO_ID_EXAME = "idExame";
    private static final String ATRIBUTO_ID_LIS_EXAME = "idLis";
    private static final String ATRIBUTO_AMOSTRAS = "amostras";
    private static final String ATRIBUTO_ID_LIS_AMOSTRA = "idLis";
    private static final String ATRIBUTO_GERADO_EM = "geradoEm";
    private static final String ATRIBUTO_IDENTIFICADOR = "identificador";
    private static final String ATRIBUTO_AUTORIZACAO = "autorizacao";
    private static final String ATRIBUTO_VERSAO = "versao";
    private static final String TAG_INTEGRADOR = "integrador";
    private static final String TAG_REQUISICAO = "requisicao";
    private static final String TAG_REQUISICOES = "requisicoes";
    private static final String TAG_MEDICO = "medico";
    private static final String TAG_PACIENTE = "paciente";
    private static final String TAG_INTEGRACAO = "integracao";
    private EscreverXML xml;
    private String configuracaoLabExterno;

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        String msg;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        this.configuracaoLabExterno = configuracaoLabExterno;
        if (StringUtil.getValor(configuracaoLabExterno, "etiquetaAtitude").equals("false") && !Funcoes.textoVazio(msg = this.validaExames(st, requisicoes))) {
            Funcoes.mensagem(null, "Os seguintes exames n\u00e3o possuem etiqueta de coleta:\n" + msg, 2);
            retorno.setImprimiu(false);
            return retorno;
        }
        if (!this.validarExames(requisicoes)) {
            retorno.setImprimiu(false);
            return retorno;
        }
        try {
            arquivar.call();
            String nomeArquivo = "remessa_" + numeroLote + ".xml";
            if (isColetaWeb) {
                this.montaXml(codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, nomeArquivo);
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb(this.xml.getArquivo()));
            } else {
                JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
                chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setSelectedFile(new File(nomeArquivo));
                chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o Atitude (*.xml)", "xml"));
                int option = chooser.showOpenDialog(null);
                if (option == 0) {
                    this.montaXml(codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, chooser.getSelectedFile().getPath());
                    retorno.setImprimiu(true);
                    return retorno;
                }
                if (option == 1) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
            }
        }
        catch (ParseException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAtitude: 236");
        }
        catch (Exception ex) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaAtitude: 240");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private void montaXml(String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, String pathArquivo) throws ParseException, SQLException {
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        this.xml = new EscreverXML(pathArquivo);
        atributos.clear();
        atributos.put(ATRIBUTO_VERSAO, "20110901");
        atributos.put(ATRIBUTO_AUTORIZACAO, StringUtil.getValor(configuracaoLabExterno, ATRIBUTO_AUTORIZACAO));
        atributos.put(ATRIBUTO_IDENTIFICADOR, numeroLote);
        atributos.put(ATRIBUTO_GERADO_EM, Funcoes.formataData("dd-MM-yyyy HH:mm:ss", new Date()));
        atributos.put(TAG_INTEGRADOR, "Jalis");
        this.xml.abrirTag(TAG_INTEGRACAO, atributos);
        this.xml.abrirTag(TAG_REQUISICOES);
        for (Registro r : requisicoes) {
            this.escreverRequisicao(r, codLabExterno);
        }
        this.xml.fecharTag(TAG_REQUISICOES);
        this.xml.fecharTag(TAG_INTEGRACAO);
        this.xml.fecharArquivo();
    }

    private boolean validarExames(List<Registro> requisicoes) {
        for (Registro r : requisicoes) {
            List exames = (List)r.getValor("listaexames");
            if (exames.size() != 0 || Funcoes.mensagem(null, "As requisi\u00e7\u00f5es possuem exames que n\u00e3o ser\u00e3o exportados!\nDeseja continuar mesmo assim?", 4) != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void escreverPaciente(Registro r) throws ParseException {
        String data = "";
        if (r.getDate("pac_datanasc") != null) {
            data = Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc"));
        } else if (!Funcoes.textoVazio(r.getString("req_idade"))) {
            int idade = Integer.parseInt(r.getString("req_idade"));
            String tipo = r.getString("req_anomes");
            Calendar c = Calendar.getInstance();
            if (tipo.equalsIgnoreCase("A")) {
                c.add(1, idade * -1);
            } else if (tipo.equalsIgnoreCase("M")) {
                c.add(2, idade * -1);
            } else {
                c.add(5, idade * -1);
            }
            data = Funcoes.formataData("dd/MM/yyyy", c.getTime());
        } else {
            data = Funcoes.formataData("dd/MM/yyyy", new Date());
        }
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.put("idLis", r.getString("pac_codigo"));
        atributos.put(ATRIBUTO_NOME, r.getString("pac_nome"));
        atributos.put(ATRIBUTO_SEXO, r.getString("pac_sexo"));
        atributos.put(ATRIBUTO_DATA_NASCIMENTO, data);
        this.xml.abrirTag(TAG_PACIENTE, atributos, true);
    }

    private void escreverRequisicao(Registro r, String codLabExterno) throws ParseException, SQLException {
        String obs = r.getString("req_obs").replaceAll("\n", " ");
        if (obs.length() > 200) {
            obs = obs.substring(0, 199).replaceAll("\n", "");
        }
        Statement st = Conexao.getStatement();
        StringBuilder codigo_lis = new StringBuilder();
        codigo_lis.append(Funcoes.preencheZero(r.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()));
        codigo_lis.append(Funcoes.preencheZero(r.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
        String dataHora = String.format("%s %s", Funcoes.formataData("dd-MM-yyyy", r.getDate("req_data")), Funcoes.formataHora(r.getDate("req_hora"), true));
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.put("idLis", codigo_lis.toString());
        atributos.put(ATRIBUTO_DATA_ENTRADA, dataHora);
        atributos.put("observacao", StringUtil.removerAcentos(obs));
        String medicamentos = this.getMedicamentos(st, r);
        if (!Funcoes.textoVazio(medicamentos)) {
            atributos.put(ATRIBUTO_MEDICAMENTOS, medicamentos);
        }
        this.xml.abrirTag(TAG_REQUISICAO, atributos);
        this.escreverPaciente(r);
        this.escreveMedico(r, atributos);
        this.xml.abrirTag("amostras");
        List exames = (List)r.getValor("listaexames");
        this.escreverAmostras(r, atributos, st, exames);
        this.xml.fecharTag("amostras");
        for (Registro e : exames) {
            Registro exa = ParserImportacaoAtitude.getExame(e.getString("ele_xmllabexterno"), e.getString("exa_codigo"), e.getString("mco_codigo"));
            if (Funcoes.textoVazio(exa.getString("linhasResultado")) && exa.getValor("linhasResultado", List.class).size() > 0) {
                List list = exa.getValor("linhasResultado", List.class);
            }
            this.escreverExameXML(e, codigo_lis.toString());
        }
        this.xml.fecharTag(TAG_REQUISICAO);
    }

    private void escreverAmostras(Registro r, Map<String, String> atributos, Statement st, List<Registro> exames) throws SQLException, ParseException {
        HashMap<String, List> exameAmostras = new HashMap<String, List>();
        HashMap<String, List<String>> etiquetas = new HashMap<String, List<String>>();
        HashMap<String, HashMap<String, String>> amostrasIdCurvas = new HashMap<String, HashMap<String, String>>();
        boolean etiquetaAtitude = StringUtil.getBoolean(this.configuracaoLabExterno, "etiquetaAtitude");
        int i = -1;
        for (Registro e : exames) {
            Map<String, Registro> amostras = this.getIdAmostra(st, r, e);
            String idExameJalis = this.getIdExameJalis(e);
            String xmlLabExt = e.getString("ele_xmllabexterno");
            String idMaterialExt = StringUtil.getValor(xmlLabExt, "material");
            e.setValor(TAG_ID_AMOSTRAS, new ArrayList());
            List am = e.getValor(TAG_ID_AMOSTRAS, List.class);
            for (String key : amostras.keySet()) {
                HashMap<String, String> idAmostrasCurvas = new HashMap<String, String>();
                List curvas = e.getValor("possuiCurva", List.class);
                if (key.substring(key.length() - 2).equals(Funcoes.preencheZero(idMaterialExt, 2)) && etiquetas.containsKey(key)) {
                    if (!this.amostraGerada(amostrasIdCurvas, am, key, curvas, etiquetas)) {
                        i = this.insereAmostrasdeCurva(atributos, etiquetaAtitude, i, amostras, idMaterialExt, am, key, curvas, idAmostrasCurvas);
                        amostrasIdCurvas.put(key, idAmostrasCurvas);
                        continue;
                    }
                } else if (i > -1 && exameAmostras.containsKey(key) && !((List)exameAmostras.get(key)).contains(String.valueOf(i))) {
                    ((List)exameAmostras.get(key)).add(String.valueOf(i));
                    if (!this.amostraGerada(amostrasIdCurvas, am, key, curvas, etiquetas)) {
                        i = this.insereAmostrasdeCurva(atributos, etiquetaAtitude, i, amostras, idMaterialExt, am, key, curvas, idAmostrasCurvas);
                        amostrasIdCurvas.put(key, idAmostrasCurvas);
                        continue;
                    }
                } else if (i > -1) {
                    if (!am.contains(String.valueOf(i)) && etiquetas.containsKey(key) && !((List)etiquetas.get(key)).contains(String.valueOf(i))) {
                        am.add(String.valueOf(i));
                    }
                    exameAmostras.put(key, am);
                }
                if (amostrasIdCurvas.containsKey(key)) continue;
                if (!etiquetas.containsKey(key)) {
                    etiquetas.put(key, am);
                    String material = idMaterialExt;
                    String[] idMat = StringUtil.getValor(xmlLabExt, "materiais").split(",");
                    String[] idRec = StringUtil.getValor(xmlLabExt, "recipientes").split(",");
                    if (idRec.length > 0 && !Funcoes.textoVazio(idRec[0]) && idMat.length == idRec.length) {
                        int pos = 0;
                        int posIni = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        int posFim = ParametrosGerais.getDigitosTuboTubo() + posIni;
                        for (String recipiente : idRec) {
                            String tubo = Funcoes.preencheZero(recipiente.trim(), ParametrosGerais.getDigitosTuboTubo());
                            if (tubo.equals(key.substring(posIni, posFim))) {
                                material = idMat[pos];
                            }
                            ++pos;
                        }
                    }
                    i = this.addAmostra(atributos, i, amostras, etiquetaAtitude, material, key, "Basal");
                    am.add(String.valueOf(i));
                    idAmostrasCurvas.put("Basal", String.valueOf(i));
                    amostrasIdCurvas.put(key, idAmostrasCurvas);
                    this.xml.abrirTag(TAG_AMOSTRA, atributos, true);
                    if (curvas == null) continue;
                    i = this.insereAmostrasdeCurva(atributos, etiquetaAtitude, i, amostras, idMaterialExt, am, key, curvas, idAmostrasCurvas);
                    continue;
                }
                if (curvas == null) continue;
                i = this.insereAmostrasdeCurva(atributos, etiquetaAtitude, i, amostras, idMaterialExt, am, key, curvas, idAmostrasCurvas);
            }
        }
    }

    private int insereAmostrasdeCurva(Map<String, String> atributos, boolean etiquetaAtitude, int i, Map<String, Registro> amostras, String idMaterialExt, List<String> am, String key, List<Registro> curvas, HashMap<String, String> idAmostrasCurvas) {
        int j = 0;
        for (Registro registro : curvas) {
            atributos.clear();
            String descricao = String.format("%sMin", registro.getString("possuiCurva" + j));
            i = this.addAmostra(atributos, i, amostras, etiquetaAtitude, idMaterialExt, key, descricao);
            if (!am.contains(String.valueOf(i))) {
                am.add(String.valueOf(i));
            }
            idAmostrasCurvas.put(descricao, String.valueOf(i));
            this.xml.abrirTag(TAG_AMOSTRA, atributos, true);
            ++j;
        }
        return i;
    }

    private boolean amostraGerada(Map<String, HashMap<String, String>> amostrasIdCurvas, List<String> am, String key, List<Registro> curvas, Map<String, List<String>> etiquetas) {
        boolean ret = true;
        int p = 0;
        for (String chave : amostrasIdCurvas.keySet()) {
            if (!chave.equals(key)) continue;
            String id = amostrasIdCurvas.get(chave).get("Basal");
            if (id != null) {
                am.add(id);
                continue;
            }
            if (etiquetas.get(key) == null) continue;
            am.add(etiquetas.get(key).get(0));
        }
        if (curvas != null) {
            for (Registro c : curvas) {
                String descricao = String.format("%sMin", c.getString("possuiCurva" + p));
                for (String chave : amostrasIdCurvas.keySet()) {
                    if (!chave.equals(key)) continue;
                    String id = amostrasIdCurvas.get(chave).get(descricao);
                    if (id != null) {
                        am.add(id);
                        continue;
                    }
                    ret = false;
                }
                ++p;
            }
        } else if (am.size() == 0) {
            am.addAll((Collection<String>)etiquetas.get(key));
        }
        return ret;
    }

    private int addAmostra(Map<String, String> atributos, int i, Map<String, Registro> amostras, boolean etiquetaAtitude, String idMaterialExt, String idAmostra, String descricao) {
        atributos.clear();
        atributos.put("idLis", String.format("%s%s", idAmostra, Funcoes.preencheZero(++i, 2)));
        atributos.put(ATRIBUTO_ID_AMOSTRA, String.valueOf(i));
        if (etiquetaAtitude) {
            atributos.put(ATRIBUTO_COD_BARRAS, ParserImportacaoAtitude.retornaBase36(0, 0));
        } else {
            String codBarras = amostras.get(idAmostra).getString(ATRIBUTO_COD_BARRAS_ORIGEM);
            codBarras = codBarras.substring(0, codBarras.length() - 2);
            atributos.put(ATRIBUTO_COD_BARRAS_ORIGEM, codBarras);
        }
        atributos.put(ATRIBUTO_DESCRICAO, descricao);
        atributos.put("idMaterial", idMaterialExt);
        return i;
    }

    private String getIdExameJalis(Registro exame) {
        return String.format("%s|%s", exame.getString("exa_codigo"), exame.getString("mco_codigo"));
    }

    private Map<String, Registro> getIdAmostra(Statement st, Registro req, Registro exa) throws SQLException {
        StringBuilder buf = new StringBuilder("select distinct a.rec_codigo, a.mco_codigo, b.mco_descricao from examerequisicaorecipiente a ");
        buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo");
        buf.append(" where  a.fil_codigo = ").append(req.getInt("fil_codigo"));
        buf.append(" and a.req_codigo = ").append(req.getString("req_codigo"));
        buf.append(" and a.exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
        buf.append(" and a.mco_codigo = ").append(exa.getString("mco_codigo"));
        buf.append(" and a.ere_tipo = '").append("C").append("'");
        buf.append(" order by a.rec_codigo, a.mco_codigo ");
        String xmlLabExt = exa.getString("ele_xmllabexterno");
        String material = StringUtil.getValor(xmlLabExt, "material");
        ResultSet rs = Conexao.executeQuery(st, buf);
        StringBuilder idAmostra = new StringBuilder();
        HashMap<String, Registro> ret = new HashMap<String, Registro>();
        while (rs.next()) {
            idAmostra.setLength(0);
            idAmostra.append(this.substring(Funcoes.preencheVazio(req.getString("fil_codigo"), "0", ParametrosGerais.getDigitosTuboFilial(), 1), ParametrosGerais.getDigitosTuboFilial()));
            idAmostra.append(this.substring(Funcoes.preencheVazio(req.getString("req_codigo"), "0", ParametrosGerais.getDigitosTuboRequisicao(), 1), ParametrosGerais.getDigitosTuboRequisicao()));
            idAmostra.append(this.substring(Funcoes.preencheVazio(String.valueOf(rs.getInt("rec_codigo")), "0", ParametrosGerais.getDigitosTuboTubo(), 1), ParametrosGerais.getDigitosTuboTubo()));
            idAmostra.append(Funcoes.preencheZero(material, 2));
            Registro reg = new Registro(rs);
            reg.setValor("idMaterial", material);
            reg.setValor(ATRIBUTO_COD_BARRAS_ORIGEM, idAmostra.toString());
            ret.put(idAmostra.toString(), reg);
        }
        return ret;
    }

    private void escreveMedico(Registro r, Map<String, String> atributos) {
        String crm = this.geraCrm(r);
        atributos.clear();
        if (crm != null) {
            atributos.put("idLis", crm);
            atributos.put(ATRIBUTO_CRM, r.getString("med_crm"));
            atributos.put(ATRIBUTO_NOME, r.getString("med_nome"));
            atributos.put(ATRIBUTO_CRM_UF, r.getString("med_uf"));
        }
        this.xml.abrirTag(TAG_MEDICO, atributos, true);
    }

    private void escreverExameXML(Registro e, String requisicao_lis) {
        boolean possuiDadosAdicionais;
        Map dadosAdicionais = e.getValor("dadosadicionais", Map.class);
        String possuiCurva = e.getString("possuiCurva");
        String lis = e.getString("exa_codigo") + "|" + e.getString("mco_codigo");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        List am = e.getValor(TAG_ID_AMOSTRAS, List.class);
        String amostras = StringUtil.implode(am, ",");
        String ex = StringUtil.getValor(e.getString("ele_xmllabexterno"), "exame");
        String idExame = StringUtil.getValor(ex, "codigo");
        atributos.put("idLis", String.format("%s|%s", requisicao_lis, lis));
        atributos.put("amostras", amostras);
        atributos.put(ATRIBUTO_ID_EXAME, idExame);
        if (!Funcoes.textoVazio(e.getString("exr_observacao"))) {
            atributos.put("observacao", StringUtil.tratarEntidadesHTML(e.getString("exr_observacao"), false));
        }
        boolean bl = possuiDadosAdicionais = dadosAdicionais != null && dadosAdicionais.size() > 0;
        if (possuiDadosAdicionais) {
            possuiDadosAdicionais = false;
            for (String key : dadosAdicionais.keySet()) {
                if (key.contains("possuiCurva")) continue;
                possuiDadosAdicionais = true;
            }
        }
        this.xml.abrirTag("exame", atributos, !possuiDadosAdicionais);
        if (possuiDadosAdicionais) {
            this.escreverDadosAdicionais(dadosAdicionais, atributos);
        }
    }

    private void escreverDadosAdicionais(Map<String, String> dadosAdicionais, Map<String, String> atributos) {
        this.xml.abrirTag("dadosAdicionais");
        for (String key : dadosAdicionais.keySet()) {
            atributos.clear();
            if (key.contains("possuiCurva")) continue;
            atributos.put(ATRIBUTO_VALOR, dadosAdicionais.get(key));
            this.xml.abrirTag(key, atributos, true);
        }
        this.xml.fecharTag("dadosAdicionais");
        this.xml.fecharTag("exame");
    }

    private String geraCrm(Registro r) {
        if (Funcoes.textoVazio(r.getString("med_conselho")) || Funcoes.textoVazio(r.getString("med_crm")) || Funcoes.textoVazio(r.getString("med_uf")) || r.getString("med_crm").length() > 5) {
            return null;
        }
        return String.format("%s-%s-%s", r.getString("med_conselho"), r.getString("med_crm"), r.getString("med_uf")).toUpperCase();
    }

    private String getMedicamentos(Statement st, Registro req) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct b.mto_descricao from requisicaomedicamento a");
        bui.append(" left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo");
        bui.append(" where a.fil_codigo =  ").append(req.getString("fil_codigo"));
        bui.append(" and a.req_codigo =  ").append(req.getString("req_codigo"));
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            ArrayList<String> med = new ArrayList<String>();
            do {
                med.add(rs.getString("mto_descricao"));
            } while (rs.next());
            return StringUtil.implode(med, ",");
        }
        return "";
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    private String substring(String str, int endIndex) {
        return str.substring(0, str.length() > endIndex ? endIndex : str.length());
    }

    private String validaExames(Statement st, List<Registro> requisicoes) {
        StringBuilder ret = new StringBuilder();
        StringBuilder buf = new StringBuilder("select distinct a.fil_codigo, a.req_codigo, a.exa_codigo, b.ere_tipo from examerequisicao a ");
        buf.append("left join examerequisicaorecipiente b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("where ( ");
        for (Registro reg : requisicoes) {
            buf.append(" \n(a.fil_codigo = ").append(reg.getString("fil_codigo"));
            buf.append("  and  a.req_codigo =").append(reg.getString("req_codigo")).append(" and (");
            List exames = (List)reg.getValor("listaexames");
            for (Registro exa : exames) {
                buf.append("(a.exa_codigo = '").append(exa.getString("exa_codigo")).append("'");
                buf.append(" and  a.mco_codigo = ").append(exa.getInt("mco_codigo")).append(")");
                if ((exa.getString("exa_codigo") + exa.getString("mco_codigo")).equals(((Registro)exames.get(exames.size() - 1)).getString("exa_codigo") + ((Registro)exames.get(exames.size() - 1)).getString("mco_codigo"))) continue;
                buf.append(" or ");
            }
            buf.append("))");
            if (reg.getString("req_codigo").equals(requisicoes.get(requisicoes.size() - 1).getString("req_codigo"))) continue;
            buf.append(" or ");
        }
        buf.append(") ");
        buf.append(" and  (b.ere_tipo <> '").append("T").append("' and  b.ere_tipo <> '").append("C").append("' or b.ere_tipo is null ) order by a.fil_codigo, a.req_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            String codigoReq = "";
            while (rs.next()) {
                if (!rs.getString("req_codigo").equals(codigoReq)) {
                    codigoReq = rs.getString("req_codigo");
                    ret.append("\n Req.: ").append(rs.getString("req_codigo")).append(" Exames: ").append(rs.getString("exa_codigo"));
                    continue;
                }
                ret.append(", ").append(rs.getString("exa_codigo"));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAtitude: 578");
        }
        return ret.toString();
    }
}

