/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.AlvaroService;
import jalis.laboratorio.triagem.externo.exportadores.EscreverXML;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaroService;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaConcent;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaJalisWS;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExportacaoParaAlvaro
extends IntegracaoLabExterno
implements Exportador {
    public EscreverXML xml;
    public String descricao;
    public static final String EXA_KODIGO = "exa_kodigo";
    private static final String TAG_CODIGOBARRAS = "codigoBarras";
    protected String impressora;
    protected String agente = "";
    protected String senha = "";
    private String enderecoWebService = "";
    protected String configuracaoLabExterno = "";
    boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public ExportacaoParaAlvaro() {
        this.descricao = "Arquivo de exporta\u00e7\u00e3o Alvaro (*.xml)";
    }

    public ExportacaoParaAlvaro(String descricao) {
        this.descricao = descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        return this.exportarExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoesListaOriginal, colunaOrdenacao, true, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, arquivar, anular, labExterno, agruparMultiguia);
    }

    @Override
    public String getTagCodigo() {
        return "agente";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, boolean gravaRetornoPorRequisicao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String nomeXml = "remessa_" + numeroLote + ".xml";
        List<Object> requisicoes = new ArrayList();
        ArrayList<Registro> requisicoesJaEnviadas = new ArrayList<Registro>();
        HashSet<String> pac = new HashSet<String>();
        HashSet<String> medicos = new HashSet<String>();
        this.configuracaoLabExterno = configuracaoLabExterno;
        this.agente = StringUtil.getValor(configuracaoLabExterno, "agente");
        this.senha = StringUtil.getValor(configuracaoLabExterno, "senha");
        this.enderecoWebService = StringUtil.getValor(configuracaoLabExterno, "enderecoWebService");
        this.enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
        this.isEnviarRequisicaoWebService = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
        if (reenvio || !this.enviarUsandoWS) {
            requisicoes = requisicoesListaOriginal;
        } else {
            for (Registro requisicao : requisicoesListaOriginal) {
                if (!Funcoes.textoVazio(requisicao.getString("metodoEnvio")) && requisicao.getString("metodoEnvio").equalsIgnoreCase("PUT")) {
                    requisicoes.add(requisicao);
                    continue;
                }
                if (Funcoes.textoVazio(requisicao.getString("metodoEnvio")) || !requisicao.getString("metodoEnvio").equalsIgnoreCase("POST")) continue;
                requisicoesJaEnviadas.add(requisicao);
            }
        }
        try {
            void var42_50;
            if (!this.validarExames(requisicoes)) {
                retorno.setImprimiu(false);
                return retorno;
            }
            List<Registro> reqsTemp = new ArrayList<Registro>();
            ArrayList<Registro> examesTemp = new ArrayList<Registro>();
            for (Registro registro : requisicoesJaEnviadas) {
                List list = (List)registro.getValor("listaexames");
                examesTemp = new ArrayList();
                for (Registro exa : list) {
                    if (!exa.getBoolean("exameNovo")) continue;
                    examesTemp.add(exa);
                }
                if (examesTemp.isEmpty()) continue;
                registro.setValor("listaexames", examesTemp);
                reqsTemp.add(registro);
            }
            ArrayList<Registro> listaBackup = new ArrayList<Registro>();
            if (!requisicoes.isEmpty()) {
                for (Registro registro : requisicoes) {
                    listaBackup.add(registro.clone());
                }
            } else if (!requisicoesJaEnviadas.isEmpty()) {
                for (Registro registro : reqsTemp) {
                    listaBackup.add(registro.clone());
                }
            }
            requisicoes = ExportacaoParaAlvaro.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
            reqsTemp = ExportacaoParaAlvaro.agruparMutiguia(reqsTemp, st, agruparGuiasInterface, digitosTuboFilial);
            arquivar.call();
            File file = new File(System.getProperty("user.home") + File.separatorChar + nomeXml);
            if (!this.enviarUsandoWS && !isColetaWeb) {
                File file2 = new File(nomeXml);
                JFileChooser jFileChooser = this.gerarArquivo(null, file2, reenvio, "Arquivo de exporta\u00e7\u00e3o \u00c1lvaro (*.xml)");
                int option = jFileChooser.showOpenDialog(null);
                if (option != 0) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                this.xml = new EscreverXML(jFileChooser.getSelectedFile().getPath());
            } else {
                this.xml = new EscreverXML(file.getPath());
            }
            if (requisicoes != null && !requisicoes.isEmpty()) {
                this.geraXmlLote(codLabExterno, configuracaoLabExterno, requisicoes, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, false, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
            }
            boolean bl = false;
            if (requisicoes != null && !requisicoes.isEmpty() && this.enviarUsandoWS) {
                if (requisicoes.isEmpty()) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                String tipoRequest = "PUT";
                if (configuracaoLabExterno.contains("<jalisWS>")) {
                    tipoRequest = "POST";
                }
                retorno = this.enviarLoteParaWebService(isColetaWeb, this.enderecoWebService, this.enviarUsandoWS, (File)var42_50, codLabExterno, requisicoes, listaBackup, numeroLote, tipoRequest, gravaRetornoPorRequisicao, reenvio, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, tipoIntegracao, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressoras, agruparInterface, arquivar, anular);
                boolean bl2 = retorno.isImprimiu();
                if (!reenvio && !bl2) {
                    ExportacaoParaAlvaro.removerLote(codLabExterno, listaBackup, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                    retorno.setImprimiu(false);
                    return retorno;
                }
            }
            if (!this.enviarUsandoWS && isColetaWeb) {
                retorno.setNomeArquivoLote(nomeXml);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb((File)var42_50));
                retorno.setExtensaoArquivo("xml");
            }
            if (requisicoesJaEnviadas != null && !requisicoesJaEnviadas.isEmpty() && this.enviarUsandoWS) {
                this.xml = new EscreverXML(var42_50.getPath());
                if (requisicoesJaEnviadas.isEmpty()) {
                    retorno.setImprimiu(false);
                    return retorno;
                }
                this.geraXmlLote(codLabExterno, configuracaoLabExterno, requisicoesJaEnviadas, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, true, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
                retorno = this.enviarLoteParaWebService(isColetaWeb, this.enderecoWebService, this.enviarUsandoWS, (File)var42_50, codLabExterno, requisicoesJaEnviadas, listaBackup, numeroLote, "POST", gravaRetornoPorRequisicao, reenvio, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, tipoIntegracao, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressoras, agruparInterface, arquivar, anular);
                boolean bl3 = retorno.isImprimiu();
                if (!reenvio && !bl3) {
                    ExportacaoParaAlvaro.removerLote(codLabExterno, listaBackup, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                    retorno.setImprimiu(false);
                    return retorno;
                }
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (ParseException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAlvaro: 62");
        }
        catch (Exception ex) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaAlvaro: 144");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    public void geraXmlLote(String codLabExterno, String configuracaoLabExterno, List<Registro> requisicoes, HashSet<String> pac, HashSet<String> medicos, String agente, String senha, Boolean enviarLoteWebService, String numeroLote, boolean isNovaAmostra, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        boolean enviarTuboLis = StringUtil.getValor(configuracaoLabExterno, "enviarTuboLis").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarTuboLis");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.clear();
        if (!isNovaAmostra) {
            atributos.put("versao", "20090801");
        }
        if (enviarLoteWebService.booleanValue()) {
            String dataHora = Funcoes.formataData("yyyy-MM-dd", new Date());
            dataHora = dataHora + "T" + Funcoes.formataData("HH:mm:ss", new Date());
            atributos.put("datahora", dataHora);
        } else {
            atributos.put("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        }
        atributos.put("operador", Variaveis.login);
        atributos.put("lis", "Jalis");
        if (enviarLoteWebService.booleanValue()) {
            atributos.put("idagente", agente);
            atributos.put("senha", senha);
        }
        if (!isNovaAmostra) {
            this.xml.abrirTag("solicitacoes", atributos);
        } else {
            this.xml.abrirTag("inclusoes", atributos);
        }
        atributos.clear();
        atributos.put("codigo", StringUtil.getValor(configuracaoLabExterno, "codigo"));
        if (!enviarLoteWebService.booleanValue() || this instanceof ExportacaoParaJalisWS) {
            atributos.put("chave", StringUtil.getValor(configuracaoLabExterno, "chave"));
        }
        this.xml.abrirTag("entidade", atributos);
        if (!isNovaAmostra) {
            this.xml.abrirTag("pacientes");
            for (Registro r : requisicoes) {
                if (pac.contains(r.getString("pac_codigo"))) continue;
                pac.add(r.getString("pac_codigo"));
                this.escreverPaciente(r, enviarLoteWebService);
            }
            this.xml.fecharTag("pacientes");
        }
        if (!isNovaAmostra && (StringUtil.getValor(configuracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarMedico"))) {
            this.xml.abrirTag("medicos");
            for (Registro r : requisicoes) {
                String crm = this.geraCrm(r, enviarLoteWebService);
                if (crm == null || medicos.contains(crm)) continue;
                medicos.add(crm);
                atributos.clear();
                atributos.put("crm", crm);
                atributos.put("nome", r.getString("med_nome"));
                this.xml.abrirTag("medico", atributos, true);
            }
            this.xml.fecharTag("medicos");
        }
        for (Registro r : requisicoes) {
            if (this instanceof ExportacaoParaConcent && enviarTuboLis || this instanceof ExportacaoParaJalisWS) {
                this.escreverSolicitacao(null, codLabExterno, configuracaoLabExterno, numeroLote, isNovaAmostra, requisicoes, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
                break;
            }
            if (r.getValor("listaexames") == null || ((ArrayList)r.getValor("listaexames")).size() <= 0) continue;
            this.escreverSolicitacao(r, codLabExterno, configuracaoLabExterno, numeroLote, isNovaAmostra, null, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
        }
        this.xml.fecharTag("entidade");
        if (isNovaAmostra) {
            this.xml.fecharTag("inclusoes");
        } else {
            this.xml.fecharTag("solicitacoes");
        }
        this.xml.fecharArquivo();
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetornoImpressaoEtiquetas enviarLoteParaWebService(boolean isColetaWeb, String enderecoWebService, Boolean enviarLoteWebService, File arquivo, String codLabExterno, List<Registro> requisicoes, List<Registro> requisicoesOriginal, String numeroLote, String metod, boolean gravaRetornoPorRequisicao, boolean reenvio, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, String tipoIntegracao, boolean agruparGuiasInterface, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (enviarLoteWebService.booleanValue()) {
            File xmlGerado = arquivo;
            Scanner scanner = new Scanner(xmlGerado);
            HttpURLConnection urlConnection = null;
            try {
                retorno = UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, Protocolo.Alvaro.getDescricao());
                if (retorno.isImprimiu()) {
                    String linha;
                    String conteudoGerado = "";
                    while (scanner.hasNext()) {
                        conteudoGerado = conteudoGerado + scanner.nextLine();
                    }
                    if (!this.validaXml(conteudoGerado, isColetaWeb)) {
                        retorno.setImprimiu(false);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    if (enderecoWebService.contains("https")) {
                        sc.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    }
                    URL url = new URL(enderecoWebService);
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setDoOutput(true);
                    urlConnection.setDoInput(true);
                    urlConnection.setRequestMethod(metod);
                    urlConnection.setRequestProperty("Content-type", "text/xml; charset=ISO-8859-1");
                    urlConnection.connect();
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(conteudoGerado.toString().getBytes());
                    os.flush();
                    if (this.debug) {
                        System.out.println("=====XML ENVIO=====");
                        System.out.println(conteudoGerado);
                    }
                    BufferedReader leitura = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                    StringBuilder retornoWebService = new StringBuilder();
                    StringBuilder erro = new StringBuilder();
                    while ((linha = leitura.readLine()) != null) {
                        retornoWebService.append(linha);
                    }
                    leitura.close();
                    if (this.debug) {
                        System.out.println("=====XML RETORNO=====");
                        System.out.println(retornoWebService.toString());
                    }
                    if (!Funcoes.textoVazio(retornoWebService.toString())) {
                        if (retornoWebService.toString().contains("ID ou Senha incorreta")) {
                            String mensagem = "N\u00e3o foi possivel obter conex\u00e3o com WebService do \u00c1lvaro.\nVerifique usu\u00e1rio e senha das configura\u00e7\u00f5es do Laborat\u00f3rio externo.";
                            UtilExportadores.adicionarMensagemRetorno(mensagem, "Alvaro", retorno);
                            if (!isColetaWeb) {
                                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
                            }
                            retorno.setImprimiu(false);
                            RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                            return retornoImpressaoEtiquetas;
                        }
                        if (retornoWebService.toString().contains("j\u00e1 est\u00e1 cadastrada para o agente")) {
                            url = new URL(enderecoWebService);
                            urlConnection = (HttpURLConnection)url.openConnection();
                            urlConnection.setDoOutput(true);
                            urlConnection.setDoInput(true);
                            urlConnection.setRequestMethod("POST");
                            urlConnection.setRequestProperty("Content-type", "text/xml; charset=ISO-8859-1");
                            urlConnection.connect();
                            List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService.toString(), "solicitacao", false);
                            for (String solicitacao : solicitacoes) {
                                if (!solicitacao.contains("j\u00e1 est\u00e1 cadastrada para o agente")) continue;
                                AlvaroService service = new AlvaroService();
                                String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                                String entidade = StringUtil.getValor(this.configuracaoLabExterno, "codigo");
                                String xml = this.xmlSolicitaEtiquetasSegundaVia(idAlvaro, entidade);
                                CloseableHttpClient httpClient = HttpClients.createDefault();
                                StringEntity xmlEntity = new StringEntity(xml, "UTF-8");
                                HttpPost request = new HttpPost(url.toString());
                                if (request == null) continue;
                                request.setEntity((HttpEntity)xmlEntity);
                                request.setHeader("Content-Type", "text/xml; charset=ISO-8859-1");
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                                String xmlRetorno = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                                retorno = service.processaRetornoWsSegundaViaEtiqueta(isColetaWeb, codLabExterno, xmlRetorno, erro, numeroLote, gravaRetornoPorRequisicao, requisicoesOriginal, requisicoes, reenvio, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, tipoIntegracao, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressoras, agruparInterface, arquivar, anular);
                            }
                            retorno.setImprimiu(true);
                            RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                            return retornoImpressaoEtiquetas;
                        }
                        retorno = this.processaRetornoWebServiceInsercao(codLabExterno, retornoWebService.toString(), erro, numeroLote, gravaRetornoPorRequisicao, requisicoesOriginal, requisicoes, reenvio, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, agruparGuiasInterface, tamanhoNomeImpressora, impressorasLocais, impressoras, agruparInterface, arquivar, anular);
                        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("alvaro") : new ArrayList();
                        this.tratarRejeitados(isColetaWeb, codLabExterno, numeroLote, reenvio, conteudoGerado, retornoWebService, erro, retorno.getRegistros(), requisicoesOriginal, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, retorno, arquivar, agruparInterface);
                        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
                        etiquetasLab.put("alvaro", etq);
                        retorno.setEtiquetasLabExterno(etiquetasLab);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    retorno.setImprimiu(false);
                    RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                    return retornoImpressaoEtiquetas;
                }
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas conteudoGerado = retorno;
                return conteudoGerado;
            }
            catch (Exception e) {
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel enviar xml do lote. <br>" + e.getMessage(), "Alvaro", retorno);
                } else {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar xml do lote.\n" + e.getMessage(), e.getStackTrace());
                }
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                return retornoImpressaoEtiquetas;
            }
            finally {
                scanner.close();
                xmlGerado.delete();
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    private String xmlSolicitaEtiquetasSegundaVia(String idAlvaro, String entidade) {
        StringBuilder solicitaEtiquetas = new StringBuilder();
        solicitaEtiquetas.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        solicitaEtiquetas.append("<inclusoes datahora=\"2018-06-04T11:00:00\" idagente=\"" + this.agente + "\" lis=\"jalis\" ");
        solicitaEtiquetas.append("operador=\"" + Variaveis.login + "\" senha=\"" + this.senha + "\">");
        solicitaEtiquetas.append("<entidade codigo=\"" + entidade + "\">");
        solicitaEtiquetas.append("<solicitacao idAlvaro=\"" + idAlvaro + "\" >");
        solicitaEtiquetas.append("</solicitacao>");
        solicitaEtiquetas.append("</entidade>");
        solicitaEtiquetas.append("</inclusoes>");
        return solicitaEtiquetas.toString();
    }

    public RetornoImpressaoEtiquetas tratarRejeitados(boolean isColetaWeb, String codLabExterno, String numeroLote, boolean reenvio, String conteudoGerado, StringBuilder retornoWebService, StringBuilder erro, ArrayList<Registro> requisicoesRejeitadas, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, int agruparInterface) throws Exception {
        String nomeArquivo = "remessa_" + numeroLote + ".xml";
        if (requisicoesRejeitadas == null) {
            if (isColetaWeb) {
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(conteudoGerado);
                retorno.setExtensaoArquivo("xml");
            } else {
                this.gerarArquivo(conteudoGerado, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o \u00c1lvaro (*.xml)");
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        if (!Funcoes.textoVazio(erro.toString()) || !requisicoesRejeitadas.isEmpty()) {
            if (!reenvio && requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty()) {
                ExportacaoParaAlvaro.removerLote(codLabExterno, requisicoesRejeitadas, numeroLote, true, true, st, isColetaWeb, arquivar, agruparInterface);
            }
            ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erro.toString().trim(), retornoWebService.toString().trim());
            if (isColetaWeb) {
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(conteudoGerado);
                retorno.setExtensaoArquivo("xml");
                UtilExportadores.adicionarMensagemRetorno(erro.toString(), "Alvaro", retorno);
                if (requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty()) {
                    List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService.toString(), "solicitacoes", false);
                    if (solicitacoes != null && !solicitacoes.isEmpty()) {
                        StringBuilder mensagensRetorno = new StringBuilder();
                        for (String solicitacao : solicitacoes) {
                            List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                            if (amostras == null || amostras.isEmpty()) continue;
                            for (String amostra : amostras) {
                                if (!this.obterAtributoTagInformacao(amostra, "incluido").equalsIgnoreCase("false")) continue;
                                mensagensRetorno.append(this.obterAtributoTagInformacao(amostra, "informacao")).append("<br>");
                            }
                        }
                        UtilExportadores.adicionarMensagemRetorno(mensagensRetorno.toString(), "Alvaro", retorno);
                    }
                } else {
                    UtilExportadores.adicionarMensagemRetorno(erro.toString(), "Alvaro", retorno);
                }
            } else {
                VisualizaErroRetornoWebService telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Alvaro");
                if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                    if (requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty()) {
                        HashSet<String> pac = new HashSet<String>();
                        HashSet<String> medicos = new HashSet<String>();
                        JFileChooser chooser = this.gerarArquivo(null, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o \u00c1lvaro (*.xml)");
                        int option = chooser.showOpenDialog(null);
                        if (option == 0) {
                            this.xml = new EscreverXML(chooser.getSelectedFile().getPath());
                            requisicoes = ExportacaoParaAlvaro.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
                            this.geraXmlLote(codLabExterno, this.configuracaoLabExterno, requisicoes, pac, medicos, this.agente, this.senha, this.enviarUsandoWS, numeroLote, false, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
                        }
                    } else {
                        this.gerarArquivo(conteudoGerado, new File(nomeArquivo), false, "Arquivo de exporta\u00e7\u00e3o \u00c1lvaro (*.xml)");
                    }
                }
            }
            if (requisicoesRejeitadas != null && !requisicoesRejeitadas.isEmpty() && requisicoesRejeitadas.size() != requisicoes.size()) {
                arquivar.call();
                retorno.setImprimiu(true);
                return retorno;
            }
            retorno.setImprimiu(false);
            return retorno;
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    protected boolean validarExames(List<Registro> requisicoes) {
        for (Registro r : requisicoes) {
            List exames = (List)r.getValor("listaexames");
            if (!exames.isEmpty() || Funcoes.mensagem(null, "As requisi\u00e7\u00f5es possuem exames que n\u00e3o ser\u00e3o exportados!\nDeseja continuar mesmo assim?", 4) != 1) continue;
            return false;
        }
        return true;
    }

    public boolean validaXml(String conteudoGerado, boolean isColetaWeb) {
        if (conteudoGerado.contains("amostra") && conteudoGerado.contains("solicitacao")) {
            return true;
        }
        if (!conteudoGerado.contains("amostra") && !isColetaWeb) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Xml de envio n\u00e3o possui nenhuma tag de amostra.", 2);
        } else if (!conteudoGerado.contains("solicitacao") && !isColetaWeb) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Xml de envio n\u00e3o possui nenhuma tag de solicitacao.", 2);
        }
        return false;
    }

    public RetornoImpressaoEtiquetas processaRetornoWebServiceInsercao(String codLabExterno, String retornoWebService, StringBuilder erro, String numeroLote, boolean gravaRetornoPorRequisicao, List<Registro> requisicoesOriginal, List<Registro> requisicoes, boolean reenvio, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, boolean agruparGuiasInterface, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Object> listEtq = new ArrayList<Object>();
        if (!retornoWebService.startsWith("<?xml")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Mensagem inv\u00e1lida retornada pelo WebService do laborat\u00f3rio \u00c1lvaro.\nAcesse o site do laborat\u00f3rio de apoio e verifique a situa\u00e7\u00e3o do lote.", 2);
            return retorno;
        }
        List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService, "solicitacao", false);
        int qtDigitosTubo = digitosTuboFilial + digitosTuboRequisicao + digitosTuboTubo;
        ArrayList chaves = new ArrayList();
        HashMap mapRequisicoesExamesExcluidos = new HashMap();
        ArrayList<Registro> requisicoesRejeitadas = new ArrayList<Registro>(){

            @Override
            public boolean add(Registro a) {
                boolean isExiste = false;
                if (a != null) {
                    for (Registro b : this) {
                        if (!a.getString("fil_codigo").equals(b.getString("fil_codigo")) || !a.getString("req_codigo").equals(b.getString("req_codigo"))) continue;
                        isExiste = true;
                        break;
                    }
                    if (isExiste) {
                        return false;
                    }
                    return super.add(a);
                }
                return false;
            }
        };
        block0: for (String solicitacao : solicitacoes) {
            String amostra;
            Object key2;
            Object chave;
            String identificacao;
            String incluido;
            String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
            String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
            String filial = null;
            String requisicao = null;
            if (!Funcoes.textoVazio(idLis)) {
                filial = StringUtil.removeZerosEsquerda(idLis.substring(0, digitosTuboFilial));
                requisicao = StringUtil.removeZerosEsquerda(idLis.substring(digitosTuboFilial, idLis.length()));
            }
            if (!Funcoes.textoVazio(incluido = this.obterAtributoTagInformacao(solicitacao, "incluido")) && !StringUtil.getBoolean(incluido)) {
                this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, idLis, solicitacao, digitosTuboFilial, digitosTuboRequisicao);
                continue;
            }
            ArrayList<String> listaAmostrasIncluidas = new ArrayList<String>();
            HashMap<String, String> mapAmostras = new HashMap<String, String>();
            List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
            for (String amostra2 : amostras) {
                String idAmostra = this.obterAtributoTagInformacao(amostra2, "idAmostra");
                String material = this.obterAtributoTagInformacao(amostra2, "material");
                identificacao = this.obterAtributoTagInformacao(amostra2, "identificacao");
                if (Funcoes.textoVazio(identificacao)) {
                    identificacao = idLis;
                }
                if (Funcoes.textoVazio(identificacao)) {
                    identificacao = idLis;
                }
                if (!Funcoes.isNumeric(identificacao)) {
                    mapAmostras.put(idLis, amostra2);
                    continue;
                }
                if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) {
                    filial = StringUtil.removeZerosEsquerda(identificacao.substring(0, digitosTuboFilial));
                    requisicao = StringUtil.removeZerosEsquerda(identificacao.substring(digitosTuboFilial, identificacao.length()));
                    requisicao = requisicao.substring(0, requisicao.length() - digitosTuboTubo);
                }
                List<Element> filhos = this.obterAtributosTagInformacao(amostra2);
                for (Element tagFilho : filhos) {
                    if (Funcoes.textoVazio(tagFilho.getAttribute("incluido")) || StringUtil.getBoolean(tagFilho.getAttribute("incluido")) || mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(identificacao.concat(tagFilho.getAttribute("codigo")), amostra2);
                }
                if (!Funcoes.textoVazio(this.obterAtributoTagInformacao(amostra2, "incluido")) && !StringUtil.getBoolean(this.obterAtributoTagInformacao(amostra2, "incluido"))) {
                    if (mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(identificacao, amostra2);
                    continue;
                }
                for (Element tagFilho : filhos) {
                    chave = identificacao.concat(tagFilho.getAttribute("codigo"));
                    if (!mapAmostras.containsKey(chave)) continue;
                    mapAmostras.remove(chave);
                }
                List<Element> exames = this.obterAtributosTagInformacao(amostra2);
                if (!this.enviarUsandoWS) continue;
                listaAmostrasIncluidas.add(amostra2);
            }
            if (!mapAmostras.isEmpty()) {
                for (Object key2 : mapAmostras.keySet()) {
                    amostra = (String)mapAmostras.get(key2);
                    String informacao = this.obterAtributoTagInformacao(amostra, "informacao");
                    if (!Funcoes.textoVazio(informacao)) {
                        erro.append(informacao).append("\n");
                    }
                    if (Funcoes.isNumeric(identificacao = this.obterAtributoTagInformacao(amostra, "identificacao"))) {
                        String descricao = this.obterAtributoTagInformacao(amostra, "descricao");
                        String material = this.obterAtributoTagInformacao(amostra, "material");
                        if (identificacao.length() >= qtDigitosTubo) {
                            erro.append("Amostra (Tubo): ").append(identificacao);
                        }
                        erro.append(" " + descricao + " ").append(" do material: ").append(material).append(" com identifica\u00e7\u00e3o: ").append(identificacao);
                        List<Element> exames = this.obterAtributosTagInformacao(amostra);
                        chave = exames.iterator();
                        while (chave.hasNext()) {
                            Element exame = (Element)chave.next();
                            filial = StringUtil.removeZerosEsquerda(identificacao.substring(0, digitosTuboFilial));
                            requisicao = this.getCodigoRequisicao(qtDigitosTubo, identificacao, digitosTuboFilial, digitosTuboTubo);
                            this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, requisicao, digitosTuboFilial, digitosTuboRequisicao);
                            String chave2 = filial + requisicao;
                            if (Funcoes.textoVazio(exame.getAttribute("codigo")) || StringUtil.getBoolean(exame.getAttribute("incluido"))) continue;
                            erro.append("\n");
                            erro.append("Exame: ").append(exame.getAttribute("codigo")).append(" n\u00e3o foi incluido, informa\u00e7\u00e3o: ").append(exame.getAttribute("informacao")).append(" Material: ").append(material);
                            if (!mapRequisicoesExamesExcluidos.containsKey(chave2)) {
                                mapRequisicoesExamesExcluidos.put(chave2, new ArrayList());
                            }
                            ((ArrayList)mapRequisicoesExamesExcluidos.get(chave2)).add(exame);
                        }
                        continue;
                    }
                    if (erro.indexOf(idLis) <= -1) {
                        erro.append(" Requisic\u00e3o: " + idLis + " - ").append(identificacao.trim()).append("\n ");
                    }
                    this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, (String)key2, digitosTuboFilial, digitosTuboRequisicao);
                }
            }
            if (solicitacao.isEmpty()) continue;
            String novaSolicitacao = solicitacao;
            key2 = listaAmostrasIncluidas.iterator();
            while (key2.hasNext()) {
                amostra = (String)key2.next();
                String identificacao2 = this.obterAtributoTagInformacao(amostra, "identificacao");
                String codigoEtiqueta = this.obterAtributoTagInformacao(amostra, TAG_CODIGOBARRAS);
                if (Funcoes.textoVazio(identificacao2)) {
                    identificacao2 = idLis;
                }
                if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) {
                    filial = StringUtil.removeZerosEsquerda(identificacao2.substring(0, digitosTuboFilial));
                    requisicao = this.getCodigoRequisicao(qtDigitosTubo, identificacao2, digitosTuboFilial, digitosTuboTubo);
                }
                String codigoLote = " ";
                boolean proximaAmostra = false;
                for (Registro reg : requisicoes) {
                    boolean temLote;
                    Integer[] guias = RecepcaoUtil.verificaMultiGuias(st, filial, reg.getString("req_codigo"), true, false);
                    String guia = StringUtil.implode(Arrays.asList(guias), ",");
                    ArrayList listaExames = (ArrayList)reg.getValor("listaexames");
                    if (!reg.getString("fil_codigo").equals(filial) || !requisicao.contains(guia) && !guia.contains(requisicao)) continue;
                    reg.setValor(TAG_CODIGOBARRAS, codigoEtiqueta);
                    boolean isLoteEstornado = UtilExportadores.verificaEstornoLote(reg, st);
                    String rw = UtilExportadores.retornoWs(reg, codLabExterno, reg.getString("lex_codigo"), st);
                    ArrayList<String> examesAmostra = new ArrayList<String>();
                    Document doc = this.getDocumentAmostra(amostra);
                    this.getExamesAmostra(examesAmostra, doc.getChildNodes());
                    boolean bl = temLote = !isLoteEstornado && !Funcoes.textoVazio(rw);
                    if (!reenvio) {
                        for (Registro exame : listaExames) {
                            novaSolicitacao = this.getNovaSolicitacao(novaSolicitacao, amostra, codigoEtiqueta, examesAmostra, temLote, exame);
                            ArrayList examesDemembramento = (ArrayList)exame.getValor("listaexames");
                            if (examesDemembramento == null || examesDemembramento.isEmpty()) continue;
                            for (Registro exameFilho : examesDemembramento) {
                                novaSolicitacao = this.getNovaSolicitacao(novaSolicitacao, amostra, codigoEtiqueta, examesAmostra, temLote, exameFilho, exame);
                            }
                        }
                        proximaAmostra = this.existeExameSemEtiqueta(listaExames);
                    }
                    codigoLote = numeroLote;
                    if (reenvio) {
                        codigoLote = reg.getString("lex_codigo");
                    }
                    requisicao = reg.getString("req_codigo");
                }
                if (proximaAmostra) continue;
                Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
                if (agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, multiguias)) {
                    requisicao = StringUtil.implode(Arrays.asList(multiguias), ",");
                }
                if (Funcoes.textoVazio(codigoLote)) continue;
                StringBuilder sqlpdate = new StringBuilder();
                sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(novaSolicitacao)).append("'");
                sqlpdate.append(" , leq_codigoreqapoio = ").append(idAlvaro);
                sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                sqlpdate.append(" and lae_codigo = ").append(codLabExterno);
                sqlpdate.append(" and req_codigo in(").append(requisicao).append(") ");
                sqlpdate.append(" and lex_codigo = ").append(codigoLote);
                sqlpdate.append(" and fil_kodigo = ").append(filial).append(";");
                st.executeUpdate(sqlpdate.toString());
                if (!isColetaWeb && (!filial.equals(Variaveis.filialPadrao) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
                    IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
                }
                this.atualizaCodigoApoiadoExameRequisicao(st, requisicoes, isColetaWeb, arquivar, anular);
                List<String> amostrasRecebidas = StringUtil.getListValoresTagAberta(novaSolicitacao, "amostra", false);
                for (String novaAmostra : amostrasRecebidas) {
                    String etiqueta = StringUtil.getValor(novaAmostra, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n';
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface), tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
                    listEtq.add(termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular));
                }
                if (proximaAmostra) continue;
                continue block0;
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("alvaro") : new ArrayList();
        listEtq.addAll(etq);
        etiquetasLab.put("alvaro", listEtq);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        listaRequisicoes.addAll(requisicoesOriginal);
        ArrayList<Registro> listaExcluidos = new ArrayList<Registro>();
        for (String key : mapRequisicoesExamesExcluidos.keySet()) {
            List exames = (List)mapRequisicoesExamesExcluidos.get(key);
            String filial = StringUtil.removeZerosEsquerda(key.substring(0, 1));
            String requisicao = key.substring(1, key.length());
            for (Registro req : listaRequisicoes) {
                ArrayList examesJalis = (ArrayList)req.getValor("listaexames");
                ArrayList<Registro> examesExcluidos = new ArrayList<Registro>();
                if (!requisicao.equalsIgnoreCase(req.getString("req_codigomae")) || !filial.equalsIgnoreCase(req.getString("fil_codigo"))) continue;
                for (Element exaAlv : exames) {
                    for (Registro exa : examesJalis) {
                        if (!exaAlv.getAttribute("codigo").equalsIgnoreCase(exa.getString("codigo")) || StringUtil.getBoolean(exaAlv.getAttribute("incluido"))) continue;
                        examesExcluidos.add(exa);
                    }
                }
                if (!examesExcluidos.isEmpty()) {
                    req.setValor("listaexames", examesExcluidos.clone());
                }
                listaExcluidos.add(req.clone());
            }
        }
        for (Registro registro : listaExcluidos) {
            requisicoesRejeitadas.add(registro);
        }
        if (!requisicoesRejeitadas.isEmpty()) {
            for (Registro req : requisicoesRejeitadas) {
                String msgErro = req.getString("ERRO");
                if (Funcoes.textoVazio(msgErro)) continue;
                if (!Funcoes.textoVazio(erro.toString())) {
                    erro.append("\n");
                }
                erro.append(msgErro).append("\n");
            }
        }
        retorno.setRegistros(requisicoesRejeitadas);
        return retorno;
    }

    protected void adicionaRequisicaoRejeitada(List<Registro> requisicoesOriginal, ArrayList<Registro> requisicoesRejeitadas, String requisicao, int digitosTuboFilial, int digitosTuboRequisicao) {
        this.adicionaRequisicaoRejeitada(requisicoesOriginal, requisicoesRejeitadas, requisicao, null, digitosTuboFilial, digitosTuboRequisicao);
    }

    protected void adicionaRequisicaoRejeitada(List<Registro> requisicoesOriginal, ArrayList<Registro> requisicoesRejeitadas, String requisicao, String solicitacao, int digitosTuboFilial, int digitosTuboRequisicao) {
        if (Funcoes.textoVazio(solicitacao)) {
            return;
        }
        StringBuilder info = new StringBuilder();
        info.append(this.obterAtributoTagInformacao(solicitacao, "informacao"));
        String idLis = Funcoes.textoVazio(solicitacao) ? "" : this.obterAtributoTagInformacao(solicitacao, "idLis");
        List<Element> amostras = this.obterAtributosTagInformacao(solicitacao);
        for (Element element : amostras) {
            if (!element.hasAttribute("identificacao") || Funcoes.textoVazio(element.getAttribute("identificacao"))) continue;
            info.append(element.getAttribute("identificacao")).append(" - Req.: ").append(idLis).append("\n");
        }
        for (Registro req : requisicoesOriginal) {
            String codigoRequisicao = Funcoes.preencheZero(req.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(req.getString("req_codigomae"), digitosTuboRequisicao);
            if (!codigoRequisicao.equals(requisicao)) continue;
            Registro reg = req.clone();
            reg.setValor("ERRO", StringUtil.trataCaracteresEspeciais(info.toString()));
            requisicoesRejeitadas.add(reg);
        }
    }

    protected String getCodigoRequisicao(int qtDigitosTubo, String identificacao, int digitosTuboFilial, int digitosTuboTubo) {
        String requisicao = identificacao.length() == qtDigitosTubo ? StringUtil.removeZerosEsquerda(identificacao.substring(digitosTuboFilial, identificacao.length() - digitosTuboTubo)) : StringUtil.removeZerosEsquerda(identificacao.substring(digitosTuboFilial, identificacao.length()));
        return requisicao;
    }

    private void escreverErro(StringBuilder erro, HashMap<String, ArrayList<Element>> mapRequisicoesExamesExcluidos, String material, String chave, Element exame, String amostra) {
        if (!mapRequisicoesExamesExcluidos.containsKey(chave)) {
            mapRequisicoesExamesExcluidos.put(chave, new ArrayList());
        }
        mapRequisicoesExamesExcluidos.get(chave).add(exame);
        String codigoExame = exame.getAttribute("exame");
        if (Funcoes.textoVazio(codigoExame)) {
            codigoExame = StringUtil.getValor(amostra, "exame");
        }
        erro.append("\n");
        erro.append("Exame: ").append(exame.getAttribute("exame")).append(" n\u00e3o foi incluido, informa\u00e7\u00e3o: ").append(exame.getAttribute("informacao")).append(" Material: ").append(material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> processaRetornoWebService(boolean isColetaWeb, String codLabExterno, String retornoWebService, StringBuilder erro, String numeroLote, boolean gravaRetornoPorRequisicao, List<Registro> requisicoes, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws Exception {
        ArrayList<Registro> arrayList;
        block11: {
            List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService, "solicitacao", false);
            try {
                ArrayList<Registro> requisicoesRejeitadas = new ArrayList<Registro>();
                for (String solicitacao : solicitacoes) {
                    List<String> amostras;
                    String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
                    String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                    String filial = StringUtil.removeZerosEsquerda(idLis.substring(0, digitosTuboFilial));
                    String requisicao = StringUtil.removeZerosEsquerda(idLis.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboTubo));
                    boolean isIncluido = StringUtil.getBoolean(this.obterAtributoTagInformacao(solicitacao, "incluido"));
                    if (isIncluido) {
                        amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                        for (String amostra : amostras) {
                            if (this.isEnviarRequisicaoWebService || !this.enviarUsandoWS) continue;
                            String etiqueta = StringUtil.getValor(amostra, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n';
                            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface), tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
                            termica.imprimirDireto(etiqueta);
                        }
                        Integer[] multiguias = null;
                        if (gravaRetornoPorRequisicao) {
                            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
                            requisicao = StringUtil.implode(Arrays.asList(multiguias), ",");
                        }
                        if (!Funcoes.textoVazio(filial) && !Funcoes.textoVazio(requisicao)) {
                            if (solicitacao.isEmpty()) continue;
                            StringBuilder sqlpdate = new StringBuilder();
                            sqlpdate.append(" update  loteexternorequisicao set ");
                            sqlpdate.append("  leq_retornows = '").append(StringUtil.textoDB(solicitacao)).append("'");
                            sqlpdate.append(", leq_codigoreqapoio = ").append(idAlvaro);
                            sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                            sqlpdate.append(" and lae_codigo = ").append(codLabExterno);
                            if (gravaRetornoPorRequisicao) {
                                sqlpdate.append(" and req_codigo in(").append(requisicao).append(") ");
                            }
                            sqlpdate.append(" and lex_codigo = ").append(numeroLote);
                            sqlpdate.append(" and fil_kodigo = ").append(filial);
                            st.executeUpdate(sqlpdate.toString());
                            continue;
                        }
                        erro.append("\n");
                        erro.append("Filial e requisi\u00e7\u00e3o n\u00e3o encontrada para as amostras: \n");
                        for (String descricao : amostras) {
                            erro.append(this.obterAtributoTagInformacao(descricao, "identificacao")).append("\n");
                        }
                        continue;
                    }
                    erro.append("\n");
                    erro.append(this.obterAtributoTagInformacao(solicitacao, "informacao")).append("\n");
                    amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                    String id = idLis.substring(0, digitosTuboFilial + digitosTuboRequisicao);
                    this.adicionaRequisicaoRejeitada(requisicoes, requisicoesRejeitadas, id, digitosTuboFilial, digitosTuboRequisicao);
                    for (String amostra : amostras) {
                        String identificacao = this.obterAtributoTagInformacao(amostra, "identificacao");
                        String idAmostra = this.obterAtributoTagInformacao(amostra, "idAmostra");
                        String material = this.obterAtributoTagInformacao(amostra, "material");
                        erro.append("\n");
                        erro.append("Amostra: ").append(idAmostra).append(" do material: ").append(material).append(" Identifica\u00e7\u00e3o: ").append(identificacao);
                    }
                }
                arrayList = requisicoesRejeitadas;
                if (isColetaWeb) break block11;
            }
            catch (Throwable throwable) {
                if (!isColetaWeb) {
                    Conexao.fecharStatement(st);
                }
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        return arrayList;
    }

    private void excluirExame(String codLabExterno, Statement st, String filial, String requisicao, Element exame, String numerLote, String material) throws NumberFormatException, Exception {
        StringBuilder buf = new StringBuilder();
        String exameJalis = "";
        buf.append(" SELECT DISTINCT a.exa_codigo, ele_xmllabexterno FROM examematcoletalabexterno a ");
        buf.append(" LEFT JOIN examematcoleta emc ON emc.fil_codigo = a.fil_codigo ");
        buf.append(" AND emc.mco_codigo = a.mco_codigo ");
        buf.append(" AND emc.met_codigo = a.met_codigo ");
        buf.append(" AND emc.exa_codigo = a.exa_codigo ");
        buf.append(" LEFT JOIN examelayout b ON a.fil_codigo = b.fil_codigo ");
        buf.append(" AND a.exa_codigo = b.exa_codigo ");
        buf.append(" AND a.mco_codigo = b.mco_codigo ");
        buf.append(" LEFT JOIN examelayoutmetodo c ON b.fil_codigo = c.fil_codigo ");
        buf.append(" AND b.exa_codigo = c.exa_codigo ");
        buf.append(" AND b.mco_codigo = c.mco_codigo ");
        buf.append(" AND b.ela_idadeini = c.ela_idadeini ");
        buf.append(" AND b.ela_idadefim = c.ela_idadefim ");
        buf.append(" AND b.ela_idadeinitipo = c.ela_idadeinitipo ");
        buf.append(" AND b.ela_idadefimtipo = c.ela_idadefimtipo ");
        buf.append(" AND b.lay_codigo = c.lay_codigo ");
        buf.append(" WHERE a.fil_codigo = ").append(filial);
        buf.append("   AND a.lae_codigo = ").append(codLabExterno);
        buf.append("   AND b.ela_padrao = TRUE ");
        buf.append("   AND ele_xmllabexterno like '%<codigo>").append(exame.getAttribute("codigo")).append("</codigo>%'");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            exameJalis = rs.getString("exa_codigo");
        }
        buf = new StringBuilder();
        buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
        buf.append("where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(exameJalis).append("'");
        Conexao.execute(filial, st, buf);
        buf = new StringBuilder();
        buf.append("delete from loteexternoexamerequisicao where ");
        buf.append("fil_codigo = ").append(filial);
        buf.append(" and lae_codigo = ").append(codLabExterno);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and lex_codigo = ").append(numerLote);
        buf.append(" and exa_codigo = '").append(exameJalis).append("'");
        Conexao.execute(filial, st, buf);
        ArrayList<Registro> exames = UtilExportadores.pegaExamesRequisicaoRecipiente(st, Integer.parseInt(codLabExterno), requisicao.toString(), filial.toString(), numerLote.toString());
        for (Registro exa : exames) {
            buf = new StringBuilder();
            buf.append("delete from loteexternoexamerequisicaorecip where ");
            buf.append("fil_codigo = ").append(filial);
            buf.append(" and lae_codigo = ").append(codLabExterno);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and lex_codigo = ").append(numerLote);
            if (!Funcoes.textoVazio(exa.getString("rec_kodigo"))) {
                buf.append(" and rec_codigo = ").append(exa.getString("rec_kodigo"));
            }
            buf.append(" and exa_codigo = '").append(exameJalis).append("'");
            Conexao.execute(filial, st, buf);
        }
    }

    private void excluirRequisicao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isColetaWeb, Callable<Boolean> arquivar) throws NumberFormatException, Exception {
        List exames = (List)requisicao.getValor("listaexames");
        String filial = requisicao.getString("fil_codigo");
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao.getString("req_codigo"), true, false);
        String req = StringUtil.implode(Arrays.asList(multiguias), ",");
        StringBuilder buf = new StringBuilder();
        buf.append("select * from loteexternorequisicao ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and lae_codigo = ").append(codLabExterno);
        buf.append(" and lex_codigo = ").append(numeroLote);
        buf.append(" and req_codigo in (").append(req).append(") ");
        buf.append(" and leq_dataestorno is null ");
        ResultSet resultSetExisteLote = st.executeQuery(buf.toString());
        boolean temLoteRequisicao = resultSetExisteLote.next();
        for (Registro exame : exames) {
            String[] valores;
            List desmembrados;
            buf.setLength(0);
            buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
            buf.append("where fil_codigo = ").append(filial);
            buf.append(" and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append(" and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(filial, st, buf);
            }
            if (temLoteRequisicao) {
                buf.setLength(0);
                buf.append("delete from loteexternoexamerequisicao where ");
                buf.append("     fil_codigo = ").append(filial);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in( ").append(req).append(") ");
                buf.append(" and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
                if (isColetaWeb) {
                    st.executeUpdate(buf.toString());
                } else {
                    Conexao.execute(filial, st, buf);
                }
                arquivar.call();
                buf.setLength(0);
                buf.append("select 1 from loteexternoexamerequisicao where ");
                buf.append("     fil_codigo = ").append(filial);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in( ").append(req).append(") ");
                ResultSet resultSetExisteExameLote = st.executeQuery(buf.toString());
                if (!resultSetExisteExameLote.next()) {
                    buf.setLength(0);
                    buf.append("delete from requisicaolabexterno");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append(" and req_codigo in( ").append(req).append(") ");
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filial, st, buf);
                    }
                    buf.setLength(0);
                    buf.append("delete from loteexternorequisicao ");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and req_codigo in( ").append(req).append(") ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                    }
                    buf.setLength(0);
                    buf.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                    }
                }
            }
            if (exame.getValor("listaexames") != null && (desmembrados = (List)exame.getValor("listaexames")).size() > 0) {
                for (int k = 0; k < desmembrados.size(); ++k) {
                    Registro desm = (Registro)desmembrados.get(k);
                    buf.setLength(0);
                    buf.append("select * from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString("mco_codigo"));
                    buf.append("   and exa_kodigo = '").append(desm.getString("exa_codigo")).append("' ");
                    ResultSet existe = st.executeQuery(buf.toString());
                    if (!existe.next()) continue;
                    buf.setLength(0);
                    buf.append("delete from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString("mco_codigo"));
                    buf.append("   and exa_kodigo = '").append(desm.getString("exa_codigo")).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                        continue;
                    }
                    Conexao.execute(filial, st, buf);
                }
            }
            if (exame.getValor("rec_kodigo") == null || !(exame.getValor("rec_kodigo") instanceof Array) || (valores = (String[])((Array)exame.getValor("rec_kodigo")).getArray()).length <= 0 || valores.length == 1 && Funcoes.textoVazio(valores[0])) continue;
            boolean existe = false;
            buf.setLength(0);
            buf.append("select * from loteexternoexamerequisicaorecip lexr ");
            buf.append(" where lexr.fil_codigo = ").append(requisicao.getString("fil_codigo"));
            buf.append(" \t and lexr.lex_codigo = ").append(requisicao.getString("lex_codigo"));
            buf.append("   and lexr.lae_codigo = ").append(codLabExterno);
            buf.append("   and lexr.req_codigo = ").append(requisicao.getString("req_codigo"));
            buf.append("   and lexr.mco_codigo = ").append(exame.getString("mco_codigo"));
            buf.append("   and lexr.exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            ResultSet rsExiste = st.executeQuery(buf.toString());
            existe = rsExiste.next();
            if (!existe || !Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exame.getString("rec_kodigo"), new String[]{"{", "}"}))) continue;
            buf.setLength(0);
            buf.append("delete from loteexternoexamerequisicaorecip ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and lae_codigo = ").append(codLabExterno);
            buf.append("   and lex_codigo = ").append(numeroLote);
            buf.append("   and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append("   and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            if (!Funcoes.textoVazio(exame.getString("rec_kodigo"))) {
                buf.append(" and rec_codigo = ").append(exame.getString("rec_kodigo"));
            }
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
                continue;
            }
            Conexao.execute(filial, st, buf);
        }
        arquivar.call();
    }

    private void excluirExamesInsercao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isColetaWeb, Callable<Boolean> arquivar) throws NumberFormatException, Exception {
        List exames = (List)requisicao.getValor("listaexames");
        String filial = requisicao.getString("fil_codigo");
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(filial, requisicao.getString("req_codigo"), true);
        String req = StringUtil.implode(Arrays.asList(multiguias), ",");
        StringBuilder buf = new StringBuilder();
        for (Registro exame : exames) {
            String[] valores;
            List desmembrados;
            buf.setLength(0);
            buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
            buf.append("where fil_codigo = ").append(filial);
            buf.append(" and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append(" and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(filial, st, buf);
            }
            buf.setLength(0);
            buf.append("delete from loteexternoexamerequisicao where ");
            buf.append("     fil_codigo = ").append(filial);
            buf.append(" and lae_codigo = ").append(codLabExterno);
            buf.append(" and lex_codigo = ").append(numeroLote);
            buf.append(" and req_codigo in( ").append(req).append(") ");
            buf.append(" and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(filial, st, buf);
            }
            arquivar.call();
            if (exame.getValor("listaexames") != null && (desmembrados = (List)exame.getValor("listaexames")).size() > 0) {
                for (int k = 0; k < desmembrados.size(); ++k) {
                    Registro desm = (Registro)desmembrados.get(k);
                    buf.setLength(0);
                    buf.append("select * from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString("mco_codigo"));
                    buf.append("   and exa_kodigo = '").append(desm.getString("exa_codigo")).append("' ");
                    ResultSet existe = st.executeQuery(buf.toString());
                    if (!existe.next()) continue;
                    buf.setLength(0);
                    buf.append("delete from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString("mco_codigo"));
                    buf.append("   and exa_kodigo = '").append(desm.getString("exa_codigo")).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                        continue;
                    }
                    Conexao.execute(filial, st, buf);
                }
            }
            if (exame.getValor("rec_kodigo") == null || !(exame.getValor("rec_kodigo") instanceof Array) || (valores = (String[])((Array)exame.getValor("rec_kodigo")).getArray()).length <= 0 || valores.length == 1 && Funcoes.textoVazio(valores[0])) continue;
            boolean existe = false;
            buf.setLength(0);
            buf.append("select * from loteexternoexamerequisicaorecip lexr ");
            buf.append(" where lexr.fil_codigo = ").append(requisicao.getString("fil_codigo"));
            buf.append(" \t and lexr.lex_codigo = ").append(requisicao.getString("lex_codigo"));
            buf.append("   and lexr.lae_codigo = ").append(codLabExterno);
            buf.append("   and lexr.req_codigo = ").append(requisicao.getString("req_codigo"));
            buf.append("   and lexr.mco_codigo = ").append(exame.getString("mco_codigo"));
            buf.append("   and lexr.exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            ResultSet rsExiste = st.executeQuery(buf.toString());
            existe = rsExiste.next();
            if (!existe || !Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exame.getString("rec_kodigo"), new String[]{"{", "}"}))) continue;
            buf.setLength(0);
            buf.append("delete from loteexternoexamerequisicaorecip ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and lae_codigo = ").append(codLabExterno);
            buf.append("   and lex_codigo = ").append(numeroLote);
            buf.append("   and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append("   and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
            if (!Funcoes.textoVazio(exame.getString("rec_kodigo"))) {
                buf.append(" and rec_codigo = ").append(exame.getString("rec_kodigo"));
            }
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
                continue;
            }
            Conexao.execute(filial, st, buf);
        }
        arquivar.call();
    }

    protected String obterAtributoTagInformacao(String xml, String atributo) {
        String retorno = "";
        try {
            Document doc = XMLUtil.analisarXMLString(xml);
            Element raiz = doc.getDocumentElement();
            retorno = raiz.getAttribute(atributo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel identificar o atributo \"" + atributo + "\"", e.getStackTrace());
        }
        return retorno;
    }

    protected List<Element> obterAtributosTagInformacao(String xml) {
        List<Element> retorno = new ArrayList<Element>();
        try {
            Document doc = XMLUtil.analisarXMLString(xml);
            Element raiz = doc.getDocumentElement();
            retorno = XMLUtil.getElementosFilhos(raiz);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar o XML", e.getStackTrace());
        }
        return retorno;
    }

    public boolean validarRetorno(String retorno, String tag) {
        if (Funcoes.textoVazio(retorno)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Retorno inv\u00e1lido", 2);
            return false;
        }
        String tagAolRetorno = StringUtil.getValor(retorno, tag);
        if (Funcoes.textoVazio(tagAolRetorno)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O processo de estorno n\u00e3o foi conclu\u00eddo.\n" + retorno, 2);
            return false;
        }
        return true;
    }

    protected String geraCrm(Registro r, boolean enviarLoteWebService) {
        if (Funcoes.textoVazio(r.getString("med_crm")) || Funcoes.textoVazio(r.getString("med_uf"))) {
            return null;
        }
        if (!enviarLoteWebService) {
            return r.getString("med_crm") + "-" + r.getString("med_uf").toUpperCase();
        }
        return Funcoes.preencheZero(r.getString("med_crm") + "-" + r.getString("med_uf").toUpperCase(), 7);
    }

    protected void escreverPacienteInsercao(Registro r, boolean enviarLoteWebService) throws ParseException {
        String data = "";
        if (r.getDate("pac_datanasc") != null) {
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", r.getDate("pac_datanasc")) : Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc"));
        } else if (!Funcoes.textoVazio(r.getString("req_idade"))) {
            int idade = Integer.parseInt(r.getString("req_idade"));
            String tipo = r.getString("req_anomes");
            Calendar c = Calendar.getInstance();
            if (tipo.equalsIgnoreCase("A")) {
                c.add(1, idade * -1);
            } else if (tipo.equalsIgnoreCase("M")) {
                c.add(2, idade * -1);
            } else {
                c.add(5, idade * -1);
            }
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", c.getTime()) : Funcoes.formataData("dd/MM/yyyy", c.getTime());
        } else {
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", new Date()) : Funcoes.formataData("dd/MM/yyyy", new Date());
        }
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        if (enviarLoteWebService) {
            atributos.put("codigolis", r.getString("pac_codigo"));
        } else {
            atributos.put("codigo_lis", r.getString("pac_codigo"));
        }
        atributos.put("nome", StringUtil.testaTamanhoString(r.getString("pac_nome"), 40));
        atributos.put("datanasc", data);
        atributos.put("sexo", r.getString("pac_sexo"));
        this.xml.abrirTag("paciente", atributos, true);
    }

    protected void escreverPaciente(Registro r, boolean enviarLoteWebService) throws ParseException {
        String data = "";
        if (r.getDate("pac_datanasc") != null) {
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", r.getDate("pac_datanasc")) : Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc"));
        } else if (!Funcoes.textoVazio(r.getString("req_idade"))) {
            int idade = Integer.parseInt(r.getString("req_idade"));
            String tipo = r.getString("req_anomes");
            Calendar c = Calendar.getInstance();
            if (tipo.equalsIgnoreCase("A")) {
                c.add(1, idade * -1);
            } else if (tipo.equalsIgnoreCase("M")) {
                c.add(2, idade * -1);
            } else {
                c.add(5, idade * -1);
            }
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", c.getTime()) : Funcoes.formataData("dd/MM/yyyy", c.getTime());
        } else {
            data = enviarLoteWebService ? Funcoes.formataData("yyyy-MM-dd", new Date()) : Funcoes.formataData("dd/MM/yyyy", new Date());
        }
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        if (enviarLoteWebService && !(this instanceof ExportacaoParaJalisWS)) {
            atributos.put("codigolis", r.getString("pac_codigo"));
        } else {
            atributos.put("codigo_lis", r.getString("pac_codigo"));
        }
        String nome = StringUtil.limpaString(StringUtil.testaTamanhoString(r.getString("pac_nome"), 40), new String[]{"&"});
        atributos.put("nome", nome);
        atributos.put("datanasc", data);
        atributos.put("sexo", r.getString("pac_sexo"));
        this.xml.abrirTag("paciente", atributos, true);
    }

    public String obterCodigoAlvaroRetornado(Registro registro, String codLabExterno, String numeroLote, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) {
        String retorno;
        block7: {
            retorno = " ";
            try {
                String leq_retornows = UtilExportadores.retornoWs(registro, codLabExterno, numeroLote, st);
                if (Funcoes.textoVazio(leq_retornows)) {
                    leq_retornows = UtilExportadores.retornoWs(registro, codLabExterno, null, st);
                }
                if (Funcoes.textoVazio(leq_retornows)) break block7;
                if (leq_retornows != null && !leq_retornows.contains("<solicitacoes>") && !leq_retornows.contains("</solicitacoes>")) {
                    leq_retornows = "<solicitacoes>" + leq_retornows + "</solicitacoes>";
                }
                List<String> solicitacoes = StringUtil.getListValoresTagAberta(leq_retornows.toString(), "solicitacao", false);
                Collections.reverse(solicitacoes);
                String filial = registro.getString("fil_codigo");
                String requisicao = registro.getString("req_codigo");
                for (String solicitacao : solicitacoes) {
                    String identificacao;
                    String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                    List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                    String idLis = identificacao = this.obterAtributoTagInformacao(amostras.get(0), "identificacao");
                    filial = StringUtil.removeZerosEsquerda(idLis.substring(0, digitosTuboFilial));
                    requisicao = StringUtil.removeZerosEsquerda(idLis.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboFilial));
                    Integer[] guias = null;
                    String reqAux = null;
                    try {
                        guias = RecepcaoUtil.verificaMultiGuias(st, registro.getString("fil_codigo"), registro.getString("req_codigo"), true, false);
                        reqAux = StringUtil.implode(Arrays.asList(guias), ",");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (null == reqAux || reqAux.indexOf(requisicao) <= -1 || !filial.equalsIgnoreCase(registro.getString("fil_codigo"))) continue;
                    retorno = idAlvaro;
                    break;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void escreverSolicitacaoInserirExame(Registro r, String codLabExterno, String xmlConfiguracaoLabExterno, String numeroLote, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isAgruparGuiasInterface, boolean isColetaWeb) throws NumberFormatException, Exception {
        String obs = r.getString("req_obs").replaceAll("\n", " ");
        if (obs.length() > 200) {
            obs = obs.substring(0, 199).replaceAll("\n", "");
        }
        StringBuilder codigo_lis = new StringBuilder();
        codigo_lis.append(Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial));
        codigo_lis.append(Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao));
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.put("idAlvaro", this.obterCodigoAlvaroRetornado(r, codLabExterno, numeroLote, st, digitosTuboFilial, digitosTuboRequisicao));
        this.xml.abrirTag("solicitacao", atributos);
        List exames = (List)r.getValor("listaexames");
        Map<ExameMaterialAlvaro, Integer> exaAlvaro = this.carregarExamesAlvaro(exames);
        String material = "";
        try {
            for (Registro e : exames) {
                ExameAlvaro exa = new ExameAlvaro(e.getString("ele_xmllabexterno"));
                boolean temTempo = false;
                if (exa.getLinhasResultado().size() > 0) {
                    for (LinhaResultado l : exa.getLinhasResultado()) {
                        if (l.getTempos().isEmpty()) continue;
                        temTempo = true;
                        for (String string : l.getTempos()) {
                            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                                this.xml.fecharTag("amostra");
                            }
                            String descricao = string + " min.";
                            atributos.clear();
                            atributos.put("material", e.getString("material"));
                            atributos.put("descricao", descricao);
                            atributos.put("identificacao", e.getString("exr_codigoapoiado"));
                            if (Funcoes.textoVazio((String)atributos.get("identificacao"))) {
                                String fil = Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial);
                                String req = Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao);
                                String tubo = Funcoes.preencheZero(r.getString("rec_kodigo"), digitosTuboTubo);
                                atributos.put("identificacao", fil + req + tubo);
                            }
                            atributos.put("novaAmostra", "true");
                            if (!Funcoes.textoVazio(descricao)) {
                                this.xml.abrirTag("amostra", atributos);
                            }
                            this.escreverExameXMLInsercao(e);
                        }
                    }
                    if (temTempo) continue;
                }
                if (!e.getString("material").equalsIgnoreCase(material)) {
                    String req;
                    String fil;
                    boolean agruparMultiguias;
                    if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                        this.xml.fecharTag("amostra");
                    }
                    atributos.clear();
                    atributos.put("material", e.getString("material"));
                    atributos.put("identificacao", e.getString("exr_codigoapoiado"));
                    atributos.put("descricao", e.getString("rec_descricao"));
                    boolean bl = agruparMultiguias = isAgruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, r.getString("fil_codigo"), r.getString("req_codigo"));
                    if (!agruparMultiguias) {
                        if (Funcoes.textoVazio((String)atributos.get("identificacao")) || Funcoes.textoVazio((String)atributos.get("descricao"))) {
                            LaboratorioExterno[] labs;
                            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(e.getString("fil_codigo"), e.getString("req_codigo"), true);
                            for (LaboratorioExterno laboratorioExterno : labs = LaboratorioExterno.getDescricoes(st, false)) {
                                if (!laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                                for (Integer guia : multiguias) {
                                    ResultSet rs = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                                    while (rs.next()) {
                                        if (!rs.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                        atributos.put("identificacao", rs.getString("exr_codigoapoiado"));
                                        atributos.put("descricao", rs.getString("rec_descricao"));
                                        break;
                                    }
                                    if (!Funcoes.textoVazio((String)atributos.get("identificacao"))) break;
                                }
                                if (!Funcoes.textoVazio((String)atributos.get("identificacao"))) break;
                            }
                        }
                        if (Funcoes.textoVazio((String)atributos.get("identificacao"))) {
                            fil = Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial);
                            req = Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao);
                            String string = Funcoes.preencheZero(r.getString("rec_kodigo"), digitosTuboTubo);
                            atributos.put("identificacao", fil + req + string);
                        }
                        if (Funcoes.textoVazio((String)atributos.get("descricao"))) {
                            atributos.put("descricao", "N\u00e3o Informado");
                        }
                    }
                    if (Funcoes.textoVazio((String)atributos.get("identificacao"))) {
                        fil = Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial);
                        req = Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao);
                        String string = Funcoes.preencheZero(r.getString("rec_kodigo"), digitosTuboTubo);
                        atributos.put("identificacao", fil + req + string);
                    }
                    if (Funcoes.textoVazio((String)atributos.get("descricao"))) {
                        atributos.put("descricao", "N\u00e3o Informado");
                    }
                    atributos.put("novaAmostra", "true");
                    if (!Funcoes.textoVazio((String)atributos.get("descricao"))) {
                        this.xml.abrirTag("amostra", atributos);
                    }
                }
                this.escreverExameXMLInsercao(e);
                material = e.getString("material");
            }
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            this.xml.fecharTag("solicitacao");
            if (isColetaWeb) return;
        }
        catch (Throwable throwable) {
            if (isColetaWeb) throw throwable;
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    protected void escreverSolicitacao(Registro r, String codLabExterno, String xmlConfiguracaoLabExterno, String numeroLote, boolean isNovaAmostra, List<Registro> listaRequisicoes, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        Boolean enviarLoteWebService = !Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
        Boolean enviarExameUrgente = !Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarUrgente")) ? Boolean.valueOf(StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarUrgente")) : Boolean.FALSE;
        String obs = r.getString("req_obs").replaceAll("\n", " ");
        if (obs.length() > 200) {
            obs = obs.substring(0, 199).replaceAll("\n", "");
        }
        StringBuilder codigo_lis = new StringBuilder();
        codigo_lis.append(Funcoes.preencheZero(r.getString("fil_codigo"), digitosTuboFilial));
        codigo_lis.append(Funcoes.preencheZero(r.getString("req_codigo"), digitosTuboRequisicao));
        String crm = this.geraCrm(r, enviarLoteWebService);
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        if (!isNovaAmostra) {
            if (enviarLoteWebService.booleanValue()) {
                atributos.put("codigolis", codigo_lis.toString());
                atributos.put("codigopaciente", r.getString("pac_codigo"));
                atributos.put("data", Funcoes.formataData("yyyy-MM-dd", r.getDate("req_data")));
            } else {
                atributos.put("codigo_lis", codigo_lis.toString());
                atributos.put("codigo_paciente", r.getString("pac_codigo"));
                atributos.put("data", Funcoes.formataData("dd/MM/yyyy", r.getDate("req_data")));
            }
            atributos.put("observacao", StringUtil.removerAcentos(obs));
        } else {
            atributos.put("idAlvaro", this.obterCodigoAlvaroRetornado(r, codLabExterno, numeroLote, st, digitosTuboFilial, digitosTuboRequisicao));
        }
        if (!isNovaAmostra && crm != null && (StringUtil.getValor(xmlConfiguracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(xmlConfiguracaoLabExterno, "enviarMedico"))) {
            atributos.put("crm", crm);
        }
        this.xml.abrirTag("solicitacao", atributos);
        List exames = (List)r.getValor("listaexames");
        Map<ExameMaterialAlvaro, Integer> exaAlvaro = this.carregarExamesAlvaro(exames);
        String material = "";
        HashMap<String, String> identificacaoTemp = new HashMap<String, String>();
        for (Registro e : exames) {
            List desm = (List)e.getValor("listaexames");
            if (desm != null && !desm.isEmpty()) {
                exaAlvaro = this.carregarExamesAlvaro(desm);
                for (Registro exaFilho : desm) {
                    material = this.escreveTagAmostra(e, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, exaFilho, enviarExameUrgente, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                }
                continue;
            }
            material = this.escreveTagAmostra(r, isNovaAmostra, enviarLoteWebService, atributos, material, st, identificacaoTemp, e, enviarExameUrgente, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
        }
        if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
            this.xml.fecharTag("amostra");
        }
        this.xml.fecharTag("solicitacao");
    }

    public String escreveTagAmostra(Registro r, boolean isNovaAmostra, Boolean enviarLoteWebService, Map<String, String> atributos, String material, Statement st, Map<String, String> identificacaoTemp, Registro e, boolean enviarExameUrgente, boolean isAgruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws SQLException {
        boolean agruparMultiguias;
        ExameAlvaro exa = new ExameAlvaro(e.getString("ele_xmllabexterno"));
        boolean temTempo = false;
        boolean bl = agruparMultiguias = isAgruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, e.getString("fil_codigo"), e.getString("req_codigo"));
        if (exa.getLinhasResultado().size() > 0) {
            for (LinhaResultado l : exa.getLinhasResultado()) {
                if (l.getTempos().isEmpty()) continue;
                temTempo = true;
                for (String tempo : l.getTempos()) {
                    if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                        this.xml.fecharTag("amostra");
                    }
                    String descricao = tempo;
                    atributos.clear();
                    atributos.put("material", e.getString("material"));
                    atributos.put("descricao", descricao);
                    if (enviarLoteWebService.booleanValue()) {
                        atributos.put("identificacao", e.getString("exr_codigoapoiado"));
                        if (!agruparMultiguias) {
                            if (Funcoes.textoVazio(atributos.get("identificacao")) || Funcoes.textoVazio(atributos.get("descricao"))) {
                                LaboratorioExterno[] labs = LaboratorioExterno.getDescricoes(st, false);
                                block2: for (LaboratorioExterno laboratorioExterno : labs) {
                                    Integer[] mulIntegers;
                                    if (laboratorioExterno.protocolo == null || !laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                                    for (Integer guia : mulIntegers = RecepcaoUtil.verificaMultiGuias(e.getString("fil_codigo"), e.getString("req_codigo"), true)) {
                                        ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                                        while (examesRegistros.next()) {
                                            if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                            atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                            atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                            break;
                                        }
                                        if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block2;
                                    }
                                }
                            }
                            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                                atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                            }
                            if (Funcoes.textoVazio(atributos.get("descricao"))) {
                                atributos.put("descricao", "N\u00e3o Informado");
                            }
                            if (isNovaAmostra) {
                                atributos.put("novaAmostra", "true");
                            }
                        }
                        if (!Funcoes.textoVazio(descricao)) {
                            this.xml.abrirTag("amostra", atributos);
                        }
                    } else {
                        this.xml.abrirTag("amostra", atributos);
                    }
                    if (isNovaAmostra) {
                        this.escreverExameXMLInsercao(e);
                        continue;
                    }
                    this.escreverExameXML(e, enviarLoteWebService, enviarExameUrgente, st);
                }
            }
            if (temTempo) {
                material = e.getString("material");
                return material;
            }
        }
        if (!e.getString("material").equalsIgnoreCase(material)) {
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            atributos.clear();
            atributos.put("material", e.getString("material"));
            if (!agruparMultiguias) {
                if (Funcoes.textoVazio(e.getString("identificacao")) || Funcoes.textoVazio(e.getString("descricao"))) {
                    LaboratorioExterno[] labs;
                    block5: for (LaboratorioExterno laboratorioExterno : labs = LaboratorioExterno.getDescricoes(st, false)) {
                        if (!Protocolo.Alvaro.equals((Object)laboratorioExterno.protocolo)) continue;
                        Integer[] mulIntegers = RecepcaoUtil.verificaMultiGuias(st, e.getString("fil_codigo"), e.getString("req_codigo"), true, false);
                        for (Integer guia : mulIntegers) {
                            ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                            while (examesRegistros.next()) {
                                if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                if (Funcoes.textoVazio(atributos.get("identificacao"))) continue;
                            }
                            if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block5;
                        }
                    }
                }
                if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                    atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                }
                if (Funcoes.textoVazio(atributos.get("descricao"))) {
                    atributos.put("descricao", "N\u00e3o Informado");
                }
                if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                    atributos.put("novaAmostra", "true");
                }
            }
            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                atributos.put("identificacao", this.getIdentificacao(e, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
            }
            atributos.put("descricao", Funcoes.textoVazio(e.getString("rec_descricao")) ? (Funcoes.textoVazio(identificacaoTemp.get(e.getString("material"))) ? "N\u00e3o informado" : identificacaoTemp.get(e.getString("material"))) : e.getString("rec_descricao"));
            if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                atributos.put("novaAmostra", "true");
            }
            if (!Funcoes.textoVazio(atributos.get("descricao"))) {
                this.xml.abrirTag("amostra", atributos);
            }
        }
        if (isNovaAmostra) {
            this.escreverExameXMLInsercao(e);
        } else {
            this.escreverExameXML(e, enviarLoteWebService, enviarExameUrgente, st);
        }
        material = e.getString("material");
        identificacaoTemp.put(material, e.getString("exr_codigoapoiado"));
        return material;
    }

    protected String getIdentificacao(Registro e, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) {
        if (!Funcoes.textoVazio(e.getString("exr_codigoapoiado"))) {
            return e.getString("exr_codigoapoiado");
        }
        String fil = Funcoes.preencheZero(e.getString("fil_codigo"), digitosTuboFilial);
        String req = Funcoes.preencheZero(e.getString("req_codigo"), digitosTuboRequisicao);
        if (!Funcoes.textoVazio(e.getString("req_codigomae")) && !e.getString("req_codigomae").equals(e.getString("req_codigo"))) {
            req = Funcoes.preencheZero(e.getString("req_codigomae"), digitosTuboRequisicao);
        }
        String rec = null;
        if (!Funcoes.textoVazio(e.getString("rec_kodigo"))) {
            rec = StringUtil.limpaString(e.getString("rec_kodigo"), new String[]{"{", "}"});
            rec = Funcoes.preencheZero(rec, digitosTuboTubo);
        }
        return fil + req + (!Funcoes.textoVazio(rec) ? rec : "");
    }

    protected Map<ExameMaterialAlvaro, Integer> carregarExamesAlvaro(List<Registro> exames) {
        HashMap<ExameMaterialAlvaro, Integer> map = new HashMap<ExameMaterialAlvaro, Integer>();
        for (Registro exa : exames) {
            ExameAlvaro alv = new ExameAlvaro(exa.getString("ele_xmllabexterno"));
            if (alv != null) {
                exa.setValor("codigo", alv.getCodigo());
                exa.setValor("descricao", alv.getDescricao());
                exa.setValor("material", alv.getMaterial());
                exa.setValor("material_descricao", alv.getMaterialDescricao());
            }
            map.put(new ExameMaterialAlvaro(alv.getCodigo(), alv.getMaterial()), 0);
        }
        return map;
    }

    protected void escreverExameXMLInsercao(Registro e) {
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        String dadosAdicionais = e.getString("dadosadicionais");
        atributos.put("codigoExame", e.getString("codigo"));
        String lis = e.getString("exa_codigo") + "|" + e.getString("mco_codigo");
        atributos.put("idlis", lis);
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            atributos.put("dadosadicionais", dadosAdicionais);
        }
        this.xml.abrirTag("exame", atributos, true);
    }

    protected void escreverExameXML(Registro e, boolean enviarLoteWebService, boolean enviarExameUrgente, Statement st) {
        String dadosAdicionais = e.getString("dadosadicionais");
        String lis = e.getString("exa_codigo") + "|" + e.getString("mco_codigo");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.put("codigo", e.getString("codigo"));
        if (enviarExameUrgente) {
            boolean isUrgente = e.getBoolean("exr_urgente") || ExportacaoParaAlvaroService.isRequisicaoUrgente(e.getString("fil_codigo"), e.getString("req_codigo"), e.getString("exa_codigo"), e.getString("mco_codigo"), st);
            atributos.put("urgente", String.valueOf(isUrgente));
        }
        if (enviarLoteWebService) {
            atributos.put("idlis", lis);
        } else {
            atributos.put("id_lis", lis);
        }
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            if (enviarLoteWebService) {
                atributos.put("dadosadicionais", dadosAdicionais);
            } else {
                atributos.put("dados_adicionais", dadosAdicionais);
            }
        }
        this.xml.abrirTag("exame", atributos, true);
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public String getImpressora(ImpressorasLabExterno impressoras, int agruparInterface) {
        this.impressora = impressoras.getImpressoraAlvaro();
        if (Funcoes.textoVazio(this.impressora)) {
            this.impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                this.impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return this.impressora;
    }

    public void setImpressora(String impressora) {
        this.impressora = impressora;
    }

    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        AlvaroService service = new AlvaroService();
        RetornoEstornarLote retorno = service.processaWebServiceAlvaro(st, labSelecionado, requisicoes, numeroLote, isColetaWeb, arquivar, anular, login, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, agruparMultiguia);
        if (retorno.isSucesso()) {
            retorno = super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
        }
        return retorno;
    }

    private void getExamesAmostra(List<String> examesAmostra, NodeList node) {
        for (int i = 0; i < node.getLength(); ++i) {
            if (node.item(i) == null) continue;
            NamedNodeMap atributoExame = node.item(i).getAttributes();
            if (atributoExame != null && atributoExame.getNamedItem("exame") != null && !Funcoes.textoVazio(atributoExame.getNamedItem("exame").getNodeValue())) {
                examesAmostra.add(atributoExame.getNamedItem("exame").getNodeValue());
                continue;
            }
            if (node.item(i).getNodeName().equalsIgnoreCase("exame") && !Funcoes.textoVazio(node.item(i).getTextContent())) {
                examesAmostra.add(node.item(i).getTextContent());
                continue;
            }
            this.getExamesAmostra(examesAmostra, node.item(i).getChildNodes());
        }
    }

    private boolean existeExameSemEtiqueta(ArrayList<Registro> listaExames) {
        for (Registro exa : listaExames) {
            ArrayList examesDemembramento = (ArrayList)exa.getValor("listaexames");
            if (Funcoes.textoVazio(exa.getString(TAG_CODIGOBARRAS)) && (examesDemembramento == null || examesDemembramento.isEmpty())) {
                return true;
            }
            if (examesDemembramento == null || examesDemembramento.isEmpty()) continue;
            for (Registro exameFilho : examesDemembramento) {
                if (!Funcoes.textoVazio(exameFilho.getString(TAG_CODIGOBARRAS))) continue;
                return true;
            }
        }
        return false;
    }

    private String getNovaSolicitacao(String novaSolicitacao, String amostra, String codigoEtiqueta, List<String> examesAmostra, boolean temLote, Registro exame, Registro examePai) {
        ExameAlvaro codigoAlvReq = new ExameAlvaro(exame.getString("ele_xmllabexterno"));
        for (String exameAlvaro : examesAmostra) {
            if (temLote && Funcoes.textoVazio(exameAlvaro) && !codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) {
                novaSolicitacao = StringUtil.replaceBuilder(novaSolicitacao, amostra, "");
                continue;
            }
            if (!codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) continue;
            exame.setValor(TAG_CODIGOBARRAS, codigoEtiqueta);
            if (examePai == null) continue;
            examePai.setValor(TAG_CODIGOBARRAS, codigoEtiqueta);
        }
        return novaSolicitacao;
    }

    private String getNovaSolicitacao(String novaSolicitacao, String amostra, String codigoEtiqueta, List<String> examesAmostra, boolean temLote, Registro exame) {
        return this.getNovaSolicitacao(novaSolicitacao, amostra, codigoEtiqueta, examesAmostra, temLote, exame, null);
    }

    private Document getDocumentAmostra(String amostra) throws ParserConfigurationException, SAXException, IOException, UnsupportedEncodingException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(new ByteArrayInputStream(amostra.getBytes("UTF-8")));
    }

    private void atualizaCodigoApoiadoExameRequisicao(Statement st, List<Registro> requisicoes, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        for (Registro req : requisicoes) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            try {
                for (Registro exa : exames) {
                    sql.setLength(0);
                    sql.append(" select exr_codigoapoiado from examerequisicao  ");
                    sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                    sql.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                    ResultSet rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        sql.setLength(0);
                        sql.append(" update  examerequisicao set exr_codigoapoiado = ").append(StringUtil.textoDBEscape(!Funcoes.textoVazio(exa.getString(TAG_CODIGOBARRAS)) ? exa.getString(TAG_CODIGOBARRAS) : req.getString(TAG_CODIGOBARRAS)));
                        sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                        sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                        sql.append("   and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                        if (isColetaWeb) {
                            st.executeUpdate(sql.toString());
                        } else {
                            Conexao.executeUpdate(req.getString("fil_codigo"), st, sql);
                        }
                    }
                    arquivar.call();
                }
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }
}

