/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class EtiquetasExameRede
extends JDialog
implements DisposeListener {
    private JPanel panelTopo = new JPanel(new BorderLayout());
    private JPanel panelInfoRequisicao = new JPanel(null);
    private JPanel panelEditaEtiqueta = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelPaciente = new JLabel("Paciente:");
    private JLabel labelDescFilial = new JLabel();
    private JLabel labelDescRequisicao = new JLabel();
    private JLabel labelDescPacienteCodigo = new JLabel();
    private JLabel labelDescPacienteNome = new JLabel();
    private JLabel labelEtiqueta = new JLabel("Etiqueta");
    private JLabel labelCodExame = new JLabel();
    private JLabel labelCodMaterial = new JLabel();
    private JLabel labelDescExame = new JLabel();
    private TTextField txtEtiqueta = new TTextField(12);
    private JButton buttonOKEtiqueta = new JButton("OK");
    private JTable tableExame = new JTable();
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Descri\u00e7\u00e3o", "Etiqueta", "Tubo"});
    private Registro requisicao;
    private boolean utilizaFaixa;
    private int ultimaFaixaEnviada = 0;
    private int ultimaFaixaUltilizada = 0;
    private String configuracaoLabExterno;
    private boolean isOK = false;
    private int linhaAlterada = -1;
    public static final int COLUNA_CODIGO = 0;
    public static final int COLUNA_MATERIAL = 1;
    public static final int COLUNA_DESCRICAO = 2;
    public static final int COLUNA_ETIQUETA_FAIXA = 3;
    public static final int COLUNA_RECIPIENTE = 4;
    public static final int COLUNA_DIGITADO_ETQ = 5;

    public EtiquetasExameRede(Frame owner, Registro requisicao, String configuracaoLabExterno) {
        super(owner, "Etiquetas de exames");
        this.requisicao = requisicao;
        this.configuracaoLabExterno = configuracaoLabExterno;
        this.utilizaFaixa = StringUtil.getValor(configuracaoLabExterno, "utilizaFaixa").equals("true");
        if (this.utilizaFaixa) {
            this.ultimaFaixaEnviada = Integer.parseInt(StringUtil.getValor(configuracaoLabExterno, "ultimaFaixa"));
        }
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setSize(520, 420);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.tableExame.setModel(this.modeloExame);
        this.modeloExame.setColumnSize(new int[]{60, 60, 0, 130, 50}, this.tableExame);
        this.buttonOKEtiqueta.setEnabled(false);
        this.txtEtiqueta.setEnabled(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelTopo, "North");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelTopo.add((Component)this.panelInfoRequisicao, "North");
        this.panelTopo.add((Component)this.panelEditaEtiqueta, "South");
        this.panelInfoRequisicao.setBorder(BorderFactory.createTitledBorder("Informa\u00e7\u00f5es da requisi\u00e7\u00e3o"));
        this.panelInfoRequisicao.add(this.labelFilial);
        this.panelInfoRequisicao.add(this.labelDescFilial);
        this.panelInfoRequisicao.add(this.labelRequisicao);
        this.panelInfoRequisicao.add(this.labelDescRequisicao);
        this.panelInfoRequisicao.add(this.labelPaciente);
        this.panelInfoRequisicao.add(this.labelDescPacienteCodigo);
        this.panelInfoRequisicao.add(this.labelDescPacienteNome);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentro.add((Component)this.scrollExame, "Center");
        this.panelEditaEtiqueta.setBorder(BorderFactory.createTitledBorder("Exame"));
        this.panelEditaEtiqueta.add(this.labelEtiqueta);
        this.panelEditaEtiqueta.add(this.labelCodExame);
        this.panelEditaEtiqueta.add(this.labelCodMaterial);
        this.panelEditaEtiqueta.add(this.labelDescExame);
        this.panelEditaEtiqueta.add(this.txtEtiqueta);
        this.panelEditaEtiqueta.add(this.buttonOKEtiqueta);
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.tableExame.setToolTipText("Barra de espa\u00e7os / duplo clique para editar");
        this.panelInfoRequisicao.setPreferredSize(new Dimension(100, 65));
        this.labelFilial.setBounds(5, 19, 59, 20);
        this.labelDescFilial.setBounds(65, 19, 89, 20);
        this.labelRequisicao.setBounds(160, 19, 79, 20);
        this.labelDescRequisicao.setBounds(240, 19, 89, 20);
        this.labelPaciente.setBounds(5, 40, 59, 20);
        this.labelDescPacienteCodigo.setBounds(65, 40, 89, 20);
        this.labelDescPacienteNome.setBounds(155, 40, 349, 20);
        this.panelEditaEtiqueta.setPreferredSize(new Dimension(100, 45));
        this.labelCodExame.setBounds(5, 19, 69, 20);
        this.labelCodMaterial.setBounds(75, 19, 80, 20);
        this.labelDescExame.setBounds(156, 19, 150, 20);
        this.txtEtiqueta.setBounds(307, 19, 150, 20);
        this.buttonOKEtiqueta.setBounds(458, 19, 40, 20);
        this.buttonOKEtiqueta.setMargin(new Insets(2, 2, 2, 2));
        this.labelDescFilial.setText(this.requisicao.getString("fil_codigo"));
        this.labelDescRequisicao.setText(this.requisicao.getString("req_codigo"));
        this.labelDescPacienteCodigo.setText(this.requisicao.getString("pac_codigo"));
        this.labelDescPacienteNome.setText(this.requisicao.getString("pac_nome"));
        this.tableExame.grabFocus();
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        ScreenUtil.setBorda(new Component[]{this.labelCodExame, this.labelCodMaterial, this.labelDescExame, this.labelDescFilial, this.labelDescRequisicao, this.labelDescPacienteCodigo, this.labelDescPacienteNome}, new TitledBorder(""));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (EtiquetasExameRede.this.modeloExame.getRowCount() > 0) {
                    EtiquetasExameRede.this.tableExame.setRowSelectionInterval(0, 0);
                    EtiquetasExameRede.this.tableExame.grabFocus();
                }
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtiquetasExameRede.this.isOK = false;
                EtiquetasExameRede.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EtiquetasExameRede.this.todosPreenchidos()) {
                    Funcoes.mensagem(EtiquetasExameRede.this, "Alguns exames est\u00e3o sem ".concat(EtiquetasExameRede.this.utilizaFaixa ? "a faixa preenchida" : "o n\u00famero da etiqueta").concat(", \n\u00e9 necess\u00e1rio informar para Salvar."), 1);
                } else {
                    if (EtiquetasExameRede.this.utilizaFaixa) {
                        for (int i = 0; i < EtiquetasExameRede.this.modeloExame.getRowCount(); ++i) {
                            int faixa = Integer.parseInt(EtiquetasExameRede.this.modeloExame.getValueAt(i, 3).toString().substring(5, 12));
                            if (faixa <= EtiquetasExameRede.this.ultimaFaixaUltilizada) continue;
                            EtiquetasExameRede.this.ultimaFaixaUltilizada = faixa;
                        }
                    }
                    EtiquetasExameRede.this.isOK = true;
                    EtiquetasExameRede.this.setVisible(false);
                }
            }
        });
        this.tableExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    EtiquetasExameRede.this.alteraLinha(EtiquetasExameRede.this.tableExame.getSelectedRow());
                    EtiquetasExameRede.this.buttonOKEtiqueta.setEnabled(true);
                    EtiquetasExameRede.this.txtEtiqueta.setEnabled(true);
                }
            }
        });
        this.tableExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EtiquetasExameRede.this.alteraLinha(EtiquetasExameRede.this.tableExame.getSelectedRow());
                    EtiquetasExameRede.this.buttonOKEtiqueta.setEnabled(true);
                    EtiquetasExameRede.this.txtEtiqueta.setEnabled(true);
                }
            }
        });
        this.buttonOKEtiqueta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EtiquetasExameRede.this.utilizaFaixa) {
                    int ultimaFaixaEnviada = StringUtil.getInt(EtiquetasExameRede.this.configuracaoLabExterno, "ultimaFaixa");
                    int faixaInicial = StringUtil.getInt(EtiquetasExameRede.this.configuracaoLabExterno, "faixaInicial");
                    int faixaFinal = StringUtil.getInt(EtiquetasExameRede.this.configuracaoLabExterno, "faixaFinal");
                    String tubo = "";
                    String etiquetaDigita = Funcoes.preencheZero(EtiquetasExameRede.this.txtEtiqueta.getText(), 12).substring(6);
                    if (EtiquetasExameRede.this.modeloExame.getValueAt(EtiquetasExameRede.this.linhaAlterada, 4).toString().equals("0")) {
                        Funcoes.mensagem(EtiquetasExameRede.this, "C\u00f3digo do tubo n\u00e3o pode ser 0 provavelmente n\u00e3o impressa a etiqueta de coleta para o exame", 2);
                    } else if (Integer.parseInt(etiquetaDigita) < faixaInicial || Integer.parseInt(etiquetaDigita) > faixaFinal || Integer.parseInt(etiquetaDigita) <= ultimaFaixaEnviada || Integer.parseInt(etiquetaDigita) <= EtiquetasExameRede.this.ultimaFaixaUltilizada) {
                        if (Funcoes.mensagem(EtiquetasExameRede.this, "Sequ\u00eancia fora do intervalo permitido ou maior que o permitido, deseja continuar", 4) == 1) {
                            return;
                        }
                    } else {
                        EtiquetasExameRede.this.modeloExame.setValueAt(EtiquetasExameRede.this.txtEtiqueta.getText(), EtiquetasExameRede.this.linhaAlterada, 3);
                        tubo = EtiquetasExameRede.this.modeloExame.getValueAt(EtiquetasExameRede.this.linhaAlterada, 4).toString();
                    }
                    if (EtiquetasExameRede.this.modeloExame.getRowCount() > 1 && Funcoes.mensagem(EtiquetasExameRede.this, "Deseja aplicar o n\u00famero da etiqueta para todos os exames do mesmo tubo", 4) == 0) {
                        for (int i = 0; i < EtiquetasExameRede.this.modeloExame.getRowCount(); ++i) {
                            if (!tubo.equals(EtiquetasExameRede.this.modeloExame.getValueAt(i, 4).toString())) continue;
                            EtiquetasExameRede.this.modeloExame.setValueAt(EtiquetasExameRede.this.txtEtiqueta.getText(), i, 3);
                        }
                    }
                } else {
                    String mat = "";
                    boolean matDif = false;
                    if (EtiquetasExameRede.this.linhaAlterada > -1) {
                        if (EtiquetasExameRede.this.verificaEtqMaterial(EtiquetasExameRede.this.modeloExame.getValueAt(EtiquetasExameRede.this.linhaAlterada, 0).toString(), EtiquetasExameRede.this.txtEtiqueta.getText(), EtiquetasExameRede.this.modeloExame.getValueAt(EtiquetasExameRede.this.linhaAlterada, 1).toString())) {
                            Funcoes.mensagem(EtiquetasExameRede.this, "Etiqueta j\u00e1 foi informada para um exame com material diferente!", 2);
                            matDif = true;
                        } else {
                            EtiquetasExameRede.this.modeloExame.setValueAt(EtiquetasExameRede.this.txtEtiqueta.getText(), EtiquetasExameRede.this.linhaAlterada, 3);
                            mat = EtiquetasExameRede.this.modeloExame.getValueAt(EtiquetasExameRede.this.linhaAlterada, 1).toString();
                        }
                    }
                    if (!matDif && EtiquetasExameRede.this.modeloExame.getRowCount() > 1 && Funcoes.mensagem(EtiquetasExameRede.this, "Deseja aplicar o n\u00famero da etiqueta para todos os exames sem etiqueta com o mesmo material?", 4) == 0) {
                        for (int i = 0; i < EtiquetasExameRede.this.modeloExame.getRowCount(); ++i) {
                            if (!Funcoes.textoVazio(EtiquetasExameRede.this.modeloExame.getValueAt(i, 3).toString()) || !mat.equals(EtiquetasExameRede.this.modeloExame.getValueAt(i, 1).toString())) continue;
                            EtiquetasExameRede.this.modeloExame.setValueAt(EtiquetasExameRede.this.txtEtiqueta.getText(), i, 3);
                        }
                    }
                }
                EtiquetasExameRede.this.linhaAlterada = -1;
                EtiquetasExameRede.this.labelCodExame.setText("");
                EtiquetasExameRede.this.labelCodMaterial.setText("");
                EtiquetasExameRede.this.labelDescExame.setText("");
                EtiquetasExameRede.this.txtEtiqueta.clear();
                EtiquetasExameRede.this.tableExame.grabFocus();
                EtiquetasExameRede.this.buttonOKEtiqueta.setEnabled(false);
                EtiquetasExameRede.this.txtEtiqueta.setEnabled(false);
            }
        });
    }

    private void alteraLinha(int linha) {
        if (linha <= -1) {
            return;
        }
        this.linhaAlterada = linha;
        this.labelCodExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 0).toString());
        this.labelCodMaterial.setText(this.modeloExame.getValueAt(this.linhaAlterada, 1).toString());
        this.labelDescExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 2).toString());
        this.txtEtiqueta.setText(this.modeloExame.getValueAt(this.linhaAlterada, 3).toString());
        this.txtEtiqueta.grabFocus();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public int getUltimaFaixaUltilizada() {
        return this.ultimaFaixaUltilizada;
    }

    public void adicionarExames(String codigo, DadosMaterial material, String descricao, String etiqueta, boolean etiquetaDigitada) {
        if (!this.achaDuplicado(codigo, material)) {
            this.modeloExame.addLine(new Object[]{codigo, material, descricao, etiqueta, this.tuboExame(codigo, material.getCodigo()), etiquetaDigitada});
        }
    }

    public int preencheFaixa(int ultimaFaixa, int faixaInicial, int faixaFinal) {
        this.modeloExame.ordenarColuna(4);
        StringBuilder examesSemEtiqueta = new StringBuilder("");
        int recipiente = 0;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (recipiente != Integer.parseInt(this.modeloExame.getValueAt(i, 4).toString())) {
                this.ultimaFaixaUltilizada = ++ultimaFaixa;
                if (ultimaFaixa > faixaFinal) {
                    ultimaFaixa = faixaInicial;
                }
                recipiente = Integer.parseInt(this.modeloExame.getValueAt(i, 4).toString());
            }
            if (recipiente >= 0) {
                this.modeloExame.setValueAt(Funcoes.preencheZero(StringUtil.getValor(this.configuracaoLabExterno, "laboratorio"), 3).concat(Funcoes.preencheZero(String.valueOf(Calendar.getInstance().get(1)).substring(2), 2)).concat(Funcoes.preencheZero(ultimaFaixa, 7)), i, 3);
                continue;
            }
            if (examesSemEtiqueta.length() == 0) {
                examesSemEtiqueta.append("O(s) exame(s) ");
            } else {
                examesSemEtiqueta.append(", ");
            }
            examesSemEtiqueta.append(this.modeloExame.getValueAt(i, 0).toString());
        }
        if (!Funcoes.textoVazio(examesSemEtiqueta.toString())) {
            examesSemEtiqueta.append(" n\u00e3o foi emitido a etiqueta de coleta do jalis verifique!");
            Funcoes.mensagem(this, examesSemEtiqueta.toString(), 2);
        }
        return ultimaFaixa;
    }

    private Integer tuboExame(String codigoExame, int codigoMaterial) {
        Integer retorno = 0;
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("Select a.rec_codigo from examerequisicaorecipiente a ");
            buf.append("join recipcoleta b on a.fil_codigo = b.fil_codigo and a.rec_codigo = b.rec_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("where a.fil_codigo = ").append(this.requisicao.getInt("fil_codigo"));
            buf.append(" and  a.exa_codigo ='").append(codigoExame).append("' ");
            buf.append(" and  a.mco_codigo = ").append(codigoMaterial);
            buf.append(" and  a.req_codigo = ").append(this.requisicao.getInt("req_codigo"));
            buf.append(" and  a.ere_tipo   ='").append("C").append("'");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                retorno = rs.getInt("rec_codigo");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EtiquetasExameRede");
        }
        return retorno;
    }

    public void limpaExames() {
        this.modeloExame.clear();
    }

    public int getCountExames() {
        return this.modeloExame.getRowCount();
    }

    public String getCodigoExame(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 0).toString();
        }
        return "";
    }

    public int localizaExame(String codigoExame, DadosMaterial material) {
        return ExameUtil.localizaExame(codigoExame, material, this.modeloExame, 0, 1);
    }

    public DadosMaterial getDadosMaterial(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return (DadosMaterial)this.modeloExame.getValueAt(linha, 1);
        }
        return null;
    }

    public String getEtiqueta(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 3).toString();
        }
        return null;
    }

    private boolean achaDuplicado(String codigo, DadosMaterial material) {
        boolean retorno = false;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!this.modeloExame.getValueAt(i, 0).toString().equals(codigo) || !this.modeloExame.getValueAt(i, 1).equals(material)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    private boolean verificaEtqMaterial(String exame, String etiqueta, String material) {
        boolean retorno = false;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 0).toString().equals(exame) || this.modeloExame.getValueAt(i, 3).toString().equals("") || !this.modeloExame.getValueAt(i, 3).toString().equals(etiqueta) || this.modeloExame.getValueAt(i, 1).toString().equals(material)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    private boolean todosPreenchidos() {
        boolean retorno = true;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 3) != null && !Funcoes.textoVazio(this.modeloExame.getValueAt(i, 3).toString())) continue;
            return false;
        }
        return retorno;
    }
}

