/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.util.logger.ErrorLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;

public class EscreverXML {
    private File arquivo;
    private BufferedWriter writer;
    private Stack<String> abertas = new Stack();

    public EscreverXML(String nomeArquivo) {
        try {
            this.arquivo = new File(nomeArquivo);
            this.writer = new BufferedWriter(new FileWriter(this.arquivo));
            this.writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAlvaro: 186");
        }
    }

    public File getArquivo() {
        return this.arquivo;
    }

    public void abrirTag(String tag, Map<String, String> atributos, boolean fechar) {
        this.escrever("<" + tag + " ");
        if (atributos != null) {
            for (Map.Entry<String, String> atributo : atributos.entrySet()) {
                if (atributo.getKey() == null || atributo.getValue() == null) continue;
                this.escrever(atributo.getKey().trim());
                this.escrever("=\"");
                this.escrever(atributo.getValue().trim());
                this.escrever("\" ");
            }
        }
        if (fechar) {
            this.escrever("/>", true);
        } else {
            this.escrever(">", true);
            this.abertas.add(tag);
        }
    }

    public void abrirTag(String tag) {
        this.abrirTag(tag, null, false);
    }

    public void abrirTag(String tag, Map<String, String> atributos) {
        this.abrirTag(tag, atributos, false);
    }

    private void escrever(String texto, boolean quebra) {
        if (this.writer == null) {
            ErrorLogger.mostraMensagem(null, "O arquivo n\u00e3o pode ser escrito, pois n\u00e3o foi aberto", null, "ExportacaoParaAlvaro: 207");
        } else {
            try {
                this.writer.write(texto);
                if (quebra) {
                    this.writer.write(10);
                }
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAlvaro: 215");
            }
        }
    }

    private void escrever(String texto) {
        this.escrever(texto, false);
    }

    public void fecharTag(String tag) {
        if (this.abertas.isEmpty()) {
            ErrorLogger.mostraMensagem(null, "A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois n\u00e3o foi aberta", null, "ExportacaoParaAlvaro: 241");
        } else if (!this.abertas.peek().equalsIgnoreCase(tag)) {
            ErrorLogger.mostraMensagem(null, "A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois a tag \"" + this.abertas.peek() + "\" ainda est\u00e1 aberta", null, "ExportacaoParaAlvaro: 243");
        } else {
            this.escrever("</" + tag + ">", true);
            this.abertas.pop();
        }
    }

    public void fecharArquivo() {
        if (this.writer == null) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o arquivo, pois n\u00e3o est\u00e1 aberto", null, "ExportacaoParaAlvaro: 256");
        } else if (!this.abertas.isEmpty()) {
            ErrorLogger.mostraMensagem(null, "O arquivo n\u00e3o pode ser fechado, pois a tag \"" + this.abertas.peek() + "\" ainda est\u00e1 aberta", null, "ExportacaoParaAlvaro: 258");
        } else {
            try {
                this.writer.close();
                this.writer = null;
                this.arquivo = null;
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaAlvaro: 266");
            }
        }
    }

    public void cancelar() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.arquivo.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String ultimaTag() {
        return this.abertas.peek();
    }
}

