/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.exportadores.DadosAdicionaisHPardini;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;

public class DadosAdicionaisSolucao
extends DadosAdicionaisHPardini {
    private DadosAdicionaisService service = new DadosAdicionaisService();

    @Override
    public void configurarDadosAdicionais(List<InfoComplementar> dados, String exame, String requisicao, String paciente) {
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        int i = 0;
        for (InfoComplementar info : dados) {
            TTextField editDado;
            JLabel labelDado = new JLabel(info.getNome());
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelDado, c);
            if (info.getTag().equals("VolumeDiurese")) {
                editDado = ComponenteFactory.novoTTextField(4, 1);
                editDado.setToolTipText("O volume deve ser informado em mililitros.");
            } else {
                editDado = ComponenteFactory.novoTTextField(15, 3);
            }
            editDado.setPreferredSize(new Dimension(100, 20));
            editDado.setName(info.getTag());
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)editDado, c);
            c.gridy = i + 1;
            if (i == 0) {
                ScreenUtil.requisitarFoco(editDado);
            }
            ++i;
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    public boolean carregaDadosAdicionais(String exame, String material, String codLabExterno, Statement st, Registro exa, Registro requisicao, boolean isConfirmarDados) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select ele_xmllabexterno from examematcoletalabexterno");
            sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao).append(" and lae_codigo = ").append(codLabExterno);
            sql.append(" and exa_codigo = '").append(exame).append("'").append(" and mco_codigo = ").append(material);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            if (!rs.next()) {
                return true;
            }
            String xml = rs.getString("ele_xmllabexterno");
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            ExameHPardini exHPardini = ExameHPardini.novaInstancia(xml);
            HashMap<String, String> dadosValor = new HashMap<String, String>();
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementar(exHPardini, exa, requisicao);
            float volume = Funcoes.textoVazio(exa.getString("exr_volumediurese")) ? 0.0f : Float.valueOf(exa.getString("exr_volumediurese")).floatValue();
            String peso = requisicao.getString("req_peso");
            String altura = requisicao.getString("req_altura");
            if (this.service.contemValores(infoComplementares) || isConfirmarDados) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao.getString("req_codigo"), requisicao.getString("pac_codigo"));
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "O exame " + exame + " possui dados adicionais que n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    dadosValor.put(textField.getName(), textField.getText());
                }
            }
            HashMap infoComp = new HashMap();
            for (String key : dadosValor.keySet()) {
                if (key.equalsIgnoreCase("VolumeDiurese") && dadosValor.get("VolumeDiurese") != null) {
                    exa.setValor("exr_volumediurese", dadosValor.get("VolumeDiurese"));
                    continue;
                }
                if (dadosValor.get(key) == null) continue;
                infoComp.put(key, dadosValor.get(key));
                if (key.equalsIgnoreCase("Altura")) {
                    requisicao.setValor("req_altura", dadosValor.get(key));
                    continue;
                }
                if (!key.equalsIgnoreCase("Peso")) continue;
                requisicao.setValor("req_peso", dadosValor.get(key));
            }
            exa.setValor("infoComp", infoComp);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.size() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        for (Registro r : exames) {
            ArrayList examesDesm = (ArrayList)r.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                for (Registro exaDesm : examesDesm) {
                    if (this.carregaDadosAdicionais(exaDesm.getString("exa_codigo"), exaDesm.getString("mco_codigo"), codLabExterno, st, exaDesm, requisicao, isConfirmarDados)) continue;
                    return false;
                }
                continue;
            }
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), r.getString("mco_codigo"), codLabExterno, st, r, requisicao, isConfirmarDados)) continue;
            return false;
        }
        return true;
    }
}

