/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisHPardini
extends JDialog
implements DadosAdicionais,
ActionListener {
    JPanel panelExame = new JPanel(new GridBagLayout());
    JPanel panelDados = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JLabel labelExame = new JLabel();
    JLabel labelRequisicao = new JLabel();
    private DadosAdicionaisService service;

    public DadosAdicionaisHPardini() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(this.getParent());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
    }

    public void configurarDadosAdicionais(List<InfoComplementar> dados, String exame, String requisicao, String paciente) {
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o: " + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        int i = 0;
        c.gridy = 0;
        TTextField editDadoPrimeiro = null;
        for (InfoComplementar dado : dados) {
            JComponent editDado;
            JLabel labelDado = new JLabel(dado.getNome());
            JLabel labelUnidade = new JLabel(dado.getUnidade());
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelDado, c);
            if (dado.getTag().equals("TempoAmostra")) {
                editDado = ComponenteFactory.novoTTextField(2, 1);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("PesoAmostra")) {
                editDado = ComponenteFactory.novoTTextField(3, 1);
            } else if (dado.getTag().equals("TempoDiurese")) {
                editDado = ComponenteFactory.novoTTextField(5, 13);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("LinfocitosAbsoluto")) {
                editDado = ComponenteFactory.novoTTextField(5, 1);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("Altura")) {
                editDado = new TTextField(3, 2);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("Peso")) {
                editDado = new TTextField(5, 2);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("VolumeDiurese")) {
                editDado = new TTextField(4, 1);
                editDado.setText(dado.getValor().toString());
                editDado.setToolTipText("O volume deve ser informado em mililitros.");
            } else if (dado.getTag().equals("Hematocrito")) {
                editDado = new TTextField(3, 2, 1);
                editDado.setText(dado.getValor().toString());
            } else if (DadosAdicionaisHPardini.isGlicemia(dado.getTag())) {
                editDado = new TTextField(4, 2, 1);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("SemanaGestacao")) {
                editDado = new TTextField(2, 1);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("DataSintoma")) {
                editDado = new TTextField(10, 4);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("MunicipioResidencia")) {
                editDado = new TTextField(80, 3);
                editDado.setText(dado.getValor().toString());
            } else {
                editDado = dado.getTag().equals("Sintoma") ? new JComboBox<Object>(new Object[]{"Sim", "N\u00e3o"}) : ComponenteFactory.novoTTextField(15, 3);
            }
            if (editDado instanceof TTextField) {
                editDado.setPreferredSize(new Dimension(100, 20));
                editDado.setName(dado.getTag());
            }
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            if (editDado instanceof TTextField) {
                this.panelDados.add((Component)editDado, c);
            } else {
                this.panelDados.add((Component)((JComboBox)editDado), c);
            }
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelUnidade, c);
            if (editDadoPrimeiro == null && editDado instanceof TTextField) {
                editDadoPrimeiro = editDado;
            }
            c.gridy = i + 1;
            ++i;
        }
        if (editDadoPrimeiro != null) {
            ScreenUtil.requisitarFoco(editDadoPrimeiro);
        }
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    private static boolean isGlicemia(String s) {
        return s.equals("Glicemia") || s.contains("Glicemia");
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.size() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        for (Registro r : exames) {
            ArrayList examesDesm = (ArrayList)r.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                for (Registro exaDesm : examesDesm) {
                    if (this.carregaDadosAdicionais(exaDesm.getString("exa_codigo"), exaDesm.getString("mco_codigo"), codLabExterno, st, exaDesm, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"), requisicao, isConfirmarDados)) continue;
                    return false;
                }
                continue;
            }
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), r.getString("mco_codigo"), codLabExterno, st, r, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"), requisicao, isConfirmarDados)) continue;
            return false;
        }
        return true;
    }

    public boolean carregaDadosAdicionais(String exame, String material, String codLabExterno, Statement st, Registro exa, String requisicao, String paciente, Registro req, boolean isConfirmarDados) {
        try {
            HashMap<String, String> dadosComValores = new HashMap<String, String>();
            String xml = this.service.getXMLExame(exa, codLabExterno);
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            ExameHPardini exHPardini = ExameHPardini.novaInstancia(xml);
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementar(exHPardini, exa, req);
            if (!this.service.contemValores(infoComplementares) || isConfirmarDados && !infoComplementares.isEmpty()) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao, paciente);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    String nomeCampo;
                    String valor;
                    if (c instanceof TTextField) {
                        TTextField textField = (TTextField)c;
                        if (Funcoes.textoVazio(textField)) {
                            Funcoes.mensagem(this, "O exame " + exame + " possui dados adicionais que n\u00e3o foram preenchidos!", 5);
                            return false;
                        }
                        valor = ((TTextField)c).getText();
                        nomeCampo = ((TTextField)c).getName();
                        DadosAdicionaisHPardini.atualizaValores(valor, nomeCampo, exa, req, dadosComValores);
                        if (nomeCampo.equals("SemanaGestacao")) {
                            new RequisicaoService().atualizarPeriodoGestacional(req.getString("fil_codigo"), req.getString("req_codigo"), valor);
                        } else if (nomeCampo.equals("DataSintoma") && !Funcoes.textoVazio(valor)) {
                            new RequisicaoService().atualizarDataSintoma(req.getString("fil_codigo"), req.getString("req_codigo"), valor);
                        } else if (nomeCampo.equals("MunicipioResidencia") && !Funcoes.textoVazio(valor)) {
                            new RequisicaoService().atualizarMunicipioResidencia(req.getString("fil_codigo"), req.getString("req_codigo"), valor);
                        }
                    }
                    if (!(c instanceof JComboBox)) continue;
                    JComboBox comboBox = (JComboBox)c;
                    valor = ((JComboBox)c).getSelectedItem().toString();
                    nomeCampo = "Sintoma";
                    DadosAdicionaisHPardini.atualizaValores(valor, nomeCampo, exa, req, dadosComValores);
                    if (Funcoes.textoVazio(valor)) continue;
                    new RequisicaoService().atualizarApresentacaoSintoma(req.getString("fil_codigo"), req.getString("req_codigo"), valor);
                }
            } else {
                for (InfoComplementar info : infoComplementares) {
                    DadosAdicionaisHPardini.atualizaValores(info.getValor().toString(), info.getTag(), exa, req, dadosComValores);
                }
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static void atualizaValores(String valor, String nomeCampo, Registro exa, Registro req, Map<String, String> dadosComValores) {
        float v;
        boolean isVolume = nomeCampo.contains("VolumeDiurese");
        boolean isPeso = nomeCampo.contains("Peso");
        boolean isAltura = nomeCampo.contains("Altura");
        boolean isTempoDiuresi = nomeCampo.contains("TempoDiurese");
        boolean isHematocrito = nomeCampo.contains("Hematocrito");
        boolean isLinfocitosAbsolutos = nomeCampo.contains("LinfocitosAbsoluto");
        boolean isTempoAmostra = nomeCampo.contains("TempoAmostra");
        boolean isPesoAmostra = nomeCampo.contains("PesoAmostra");
        boolean isSemanaGestacao = nomeCampo.contains("SemanaGestacao");
        boolean isDataSintoma = nomeCampo.equalsIgnoreCase("DataSintoma");
        boolean isMunicipioResidencia = nomeCampo.contains("MunicipioResidencia");
        boolean isApresentouSintoma = nomeCampo.equalsIgnoreCase("Sintoma");
        float f = v = !Funcoes.textoVazio(valor = valor.replace(",", ".")) && Funcoes.isNumeric(valor) ? Float.valueOf(valor).floatValue() : 0.0f;
        if (isVolume) {
            valor = String.valueOf((int)v);
            exa.setValor("exr_volumediurese", valor);
        }
        if (isPeso) {
            int peso = Math.round(v);
            valor = String.valueOf(peso);
        }
        if (isAltura) {
            String altura;
            valor = altura = valor.replace(".", "");
        }
        if (isTempoDiuresi) {
            exa.setValor("exr_tempodiurese", valor);
        }
        if (isHematocrito) {
            exa.setValor("exr_hematocrito", Float.valueOf(v));
        }
        if (isLinfocitosAbsolutos) {
            exa.setValor("exr_linfocitosabsoluto", valor);
        }
        if (isTempoAmostra) {
            exa.setValor("exr_tempoamostra", valor);
        }
        if (isPesoAmostra) {
            exa.setValor("exr_pesoamostra", valor);
        }
        if (DadosAdicionaisHPardini.isGlicemia(nomeCampo)) {
            exa.setValor("exr_glicemia", Float.valueOf(v));
        }
        if (isSemanaGestacao) {
            exa.setValor("req_periodogestacional", valor);
        }
        if (isDataSintoma) {
            exa.setValor("req_datasintoma", valor);
        }
        if (isMunicipioResidencia) {
            exa.setValor("req_municipioresidencia", valor);
        }
        if (isApresentouSintoma) {
            exa.setValor("req_apresentousintoma", valor);
        }
        if (!isDataSintoma) {
            valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        }
        dadosComValores.put(nomeCampo, valor);
        exa.setValor("dadosadicionais", dadosComValores);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        return this.carregaAdicionais(codLabExterno, requisicao, false);
    }
}

