/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisConcent
extends JDialog
implements DadosAdicionais,
ActionListener {
    protected static final String EXR_VOLUMEDIURESE = "exr_volumediurese";
    protected static final String EXR_PLAQUETA = "exr_plaquetas";
    protected static final String EXR_IDADE = "exr_idade";
    protected static final String PAC_DUM = "pac_dum";
    protected static final String REQ_ALTURA = "req_altura";
    protected static final String REQ_PESO = "req_peso";
    protected static final String PAC_CPF = "pac_cpf";
    protected static final String TIPO = "tipo";
    protected static final String ALTURA = "altura";
    protected static final String PESO = "peso";
    protected static final String VOLUME = "volume";
    protected static final String DUM = "data";
    protected static final String IDADE = "idade";
    protected static final String RG = "rg";
    protected static final String CPF = "cpf";
    protected static final String NUMERO = "numero";
    List<InfoComplementar> dados;
    JPanel panelExame = new JPanel(new GridBagLayout());
    JPanel panelDados = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JLabel labelExame = new JLabel();
    JLabel labelRequisicao = new JLabel();
    private DadosAdicionaisService service;
    private boolean isConfirmarDados = false;

    public DadosAdicionaisConcent() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
    }

    public void configurarDadosAdicionais(List<InfoComplementar> infoComplementar, String exame, String requisicao, String paciente) {
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        int i = 0;
        for (InfoComplementar info : infoComplementar) {
            TTextField editDado;
            JLabel labelDado = new JLabel(info.getNome());
            JLabel labelUnidade = new JLabel(info.getUnidade());
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelDado, c);
            if (info.getTag().equalsIgnoreCase(PESO) || info.getTag().equalsIgnoreCase(ALTURA)) {
                editDado = ComponenteFactory.novoTTextField(5, 2);
                editDado.setText(info.getValor().toString());
            } else if (info.getTag().equalsIgnoreCase(VOLUME)) {
                editDado = new TTextField(4, 1);
                editDado.setText(info.getValor().toString());
            } else if (info.getTag().equalsIgnoreCase(PESO) || info.getTag().equalsIgnoreCase(ALTURA)) {
                editDado = ComponenteFactory.novoTTextField(5, 2);
                editDado.setText(info.getValor().toString());
            } else {
                editDado = ComponenteFactory.novoTTextField(15, 3);
            }
            editDado.setPreferredSize(new Dimension(100, 20));
            editDado.setName(info.getTag());
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)editDado, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelUnidade, c);
            c.gridy = i + 1;
            if (++i != 0) continue;
            ScreenUtil.requisitarFoco(editDado);
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.size() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        HashMap<String, Registro> chaves = new HashMap<String, Registro>();
        for (Registro r : exames) {
            String chave = r.getString("exa_codigo").concat(r.getString("mco_codigo"));
            if (chaves.containsKey(chave)) {
                r.setValor("dadosadicionais", ((Registro)chaves.get(chave)).getValor("dadosadicionais"));
                continue;
            }
            chaves.put(chave, r);
            if (this.carregaDadosAdicionais(codLabExterno, st, r, requisicao)) continue;
            return false;
        }
        return true;
    }

    private boolean carregaDadosAdicionais(String codLabExterno, Statement st, Registro exa, Registro req) {
        String exame = exa.getString("exa_codigo");
        String material = exa.getString("mco_codigo");
        String paciente = req.getString("pac_codigo");
        String requisicao = req.getString("req_codigo");
        ArrayList<String> dadosComValores = new ArrayList<String>();
        try {
            String xml = this.service.getXMLExame(exa, codLabExterno);
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            ExameAlvaro exAlvaro = new ExameAlvaro(xml);
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementarConcent(exAlvaro, exa, req);
            if (!this.service.contemValores(infoComplementares) || this.isConfirmarDados && !infoComplementares.isEmpty()) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao, paciente);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "Os dados adicionais do exame " + exame + " n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    String valor = ((TTextField)c).getText();
                    String nomeCampo = ((TTextField)c).getName();
                    DadosAdicionaisConcent.atualizaValores(valor, nomeCampo, exa, req, dadosComValores);
                }
            } else {
                for (InfoComplementar info : infoComplementares) {
                    DadosAdicionaisConcent.atualizaValores(info.getValor().toString(), info.getTag(), exa, req, dadosComValores);
                }
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static void atualizaValores(String valor, String nomeCampo, Registro exa, Registro req, List<String> dadosComValores) {
        float v;
        boolean isVolume = nomeCampo.contains(VOLUME);
        boolean isPeso = nomeCampo.contains(PESO);
        boolean isAltura = nomeCampo.contains(ALTURA);
        boolean isDum = nomeCampo.contains(DUM);
        float f = v = !Funcoes.textoVazio(valor = valor.replace(",", ".")) && Funcoes.isNumeric(valor) ? Float.valueOf(valor).floatValue() : 0.0f;
        if (isVolume) {
            valor = String.valueOf((int)v);
            exa.setValor(EXR_VOLUMEDIURESE, valor);
        }
        if (isPeso) {
            int peso = Math.round(v);
            valor = String.valueOf(peso);
        }
        if (isAltura) {
            String altura;
            valor = altura = valor.replace(".", "");
        }
        if (isDum) {
            req.setValor(PAC_DUM, valor);
        }
        valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        if (!isDum && !isVolume) {
            exa.setValor("exr_" + nomeCampo, valor);
        }
        dadosComValores.add(nomeCampo + "=" + valor);
        String adicionais = StringUtil.implode(dadosComValores, "&#xA;");
        exa.setValor("dadosadicionais", adicionais);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        this.isConfirmarDados = isConfirmarDados;
        return this.carregaAdicionais(codLabExterno, requisicao);
    }
}

