/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.util.parsers.atitude.ParserImportacaoAtitude;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisAtitude
extends JDialog
implements DadosAdicionais,
ActionListener {
    List<Registro> dados;
    JPanel panelExame = new JPanel(new GridBagLayout());
    JPanel panelDados = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JLabel labelExame = new JLabel();
    JLabel labelRequisicao = new JLabel();

    public DadosAdicionaisAtitude() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
    }

    public void configurarDadosAdicionais(List<Registro> dados, String exame, String requisicao, String paciente) {
        this.dados = dados;
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        for (int i = 0; i < dados.size(); ++i) {
            JLabel labelDado = new JLabel(dados.get(i).getString("descricao"));
            JLabel labelUnidade = new JLabel(dados.get(i).getString("unidade"));
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelDado, c);
            TTextField editDado = ComponenteFactory.novoTTextField(15, 3);
            editDado.setPreferredSize(new Dimension(100, 20));
            editDado.setName(dados.get(i).getString("codigo"));
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)editDado, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelUnidade, c);
            c.gridy = i + 1;
            if (i != 0) continue;
            ScreenUtil.requisitarFoco(editDado);
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.size() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        for (Registro r : exames) {
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), r.getString("mco_codigo"), codLabExterno, st, r, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"))) continue;
            return false;
        }
        return true;
    }

    private boolean carregaDadosAdicionais(String exame, String material, String codLabExterno, Statement st, Registro exa, String requisicao, String paciente) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select ele_xmllabexterno from examematcoletalabexterno where fil_codigo = ");
            sql.append(Variaveis.filialPadrao);
            sql.append(" and lae_codigo = ").append(codLabExterno);
            sql.append(" and exa_codigo = '").append(exame).append("'");
            sql.append(" and mco_codigo = ").append(material);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            if (!rs.next()) {
                return true;
            }
            Registro exAtitude = ParserImportacaoAtitude.getExame(rs.getString("ele_xmllabexterno"), exame, material);
            List dadosAd = exAtitude.getValor("dadosAdicionais", List.class);
            if ((dadosAd == null || dadosAd.size() == 0) && Funcoes.textoVazio(exAtitude.getString("possuiCurva"))) {
                return true;
            }
            float volume = Float.valueOf(exa.getString("exr_volumediurese")).floatValue();
            LinkedList<Registro> dados = new LinkedList<Registro>();
            LinkedHashMap<String, String> dadosComValores = new LinkedHashMap<String, String>();
            if (dadosAd != null) {
                for (Registro dado : dadosAd) {
                    if (dado.getString("descricao").equalsIgnoreCase("volume") && volume > 0.0f) {
                        String vlr = StringUtil.removeCaractere(StringUtil.formatFloat(String.valueOf(volume)), ',');
                        dadosComValores.put(dado.getString("codigo"), vlr);
                        continue;
                    }
                    dados.add(dado);
                }
            }
            int qtdeTempos = 0;
            if (exAtitude.getValor("possuiCurva") != null) {
                qtdeTempos = Integer.parseInt(exAtitude.getString("possuiCurva"));
                for (int i = 0; i < qtdeTempos; ++i) {
                    Registro r = new Registro();
                    r.setValor("possuiCurva" + i, "possuiCurva" + i);
                    r.setValor("codigo", "possuiCurva" + i);
                    r.setValor("descricao", String.format("Intervalo da %s\u00ba coleta ", String.valueOf(i + 1)));
                    dados.add(r);
                }
            }
            if (dados.size() > 0) {
                this.configurarDadosAdicionais(dados, exame, requisicao, paciente);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "O exame " + exame + " possue dados adicionais que n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    dadosComValores.put(((TTextField)c).getName(), ((TTextField)c).getText());
                }
            }
            if (qtdeTempos > 0) {
                int p = 0;
                LinkedList<Registro> curvas = new LinkedList<Registro>();
                for (Registro dado : dados) {
                    if (dado.getString("possuiCurva" + p) != null && dado.getString("possuiCurva" + p).contains("possuiCurva")) {
                        dado.setValor("possuiCurva" + p, dadosComValores.get("possuiCurva" + p));
                        curvas.add(dado);
                        ++p;
                    }
                    exa.setValor("possuiCurva", curvas);
                }
            }
            exa.setValor("dadosadicionais", dadosComValores);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        return false;
    }
}

