/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.externo.ExclusaoLoteAlvoroWebService;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AlvaroService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetornoEstornarLote processaWebServiceAlvaro(Statement st, LaboratorioExterno labSelecionado, List<Registro> listaRequisicoes, String codigoLote, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String login, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, boolean agruparMultiguia) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        HttpURLConnection urlConnection = null;
        StringBuilder retornoWebService = new StringBuilder();
        StringBuilder erros = new StringBuilder();
        boolean requisicoesDesmarcadas = false;
        boolean validaRetorno = true;
        try {
            String configuracao = labSelecionado.configuracao;
            if (StringUtil.getBoolean(StringUtil.getValor(configuracao, "enviarLoteWebService"))) {
                String descricao;
                ExportacaoParaAlvaro exp = new ExportacaoParaAlvaro();
                String enderecoWebService = StringUtil.getValor(configuracao, "enderecoWebService");
                if (UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, descricao = labSelecionado.protocolo.getDescricao()).isImprimiu()) {
                    String agente = StringUtil.getValor(configuracao, "agente");
                    String senha = StringUtil.getValor(configuracao, "senha");
                    String codigo = StringUtil.getValor(configuracao, "codigo");
                    ExclusaoLoteAlvoroWebService xmlExclusao = new ExclusaoLoteAlvoroWebService(agente, "Jalis", login, senha, codigo);
                    for (int i = 0; i < listaRequisicoes.size(); ++i) {
                        Registro req = listaRequisicoes.get(i);
                        String idAlvaro = this.obterCodigoAlvaroRetornadoNovo(req, labSelecionado.codigoLab, codigoLote, st, digitosTuboFilial, digitosTuboRequisicao);
                        ArrayList exames = (ArrayList)req.getValor("listaexames");
                        req.setValor("idAlvaro", idAlvaro);
                        ArrayList<Registro> listaExamesExclusao = new ArrayList<Registro>();
                        for (Registro exame : exames) {
                            exame.setValor("idAlvaro", idAlvaro);
                            List desm = (List)exame.getValor("listaexames");
                            if (desm != null && !desm.isEmpty()) {
                                for (Registro exaDesm : desm) {
                                    exaDesm.setValor("idAlvaro", idAlvaro);
                                    ExameAlvaro alv = new ExameAlvaro(exaDesm.getString("ele_xmllabexterno"));
                                    alv.setExameJalis(exaDesm.getString("exa_codigo"));
                                    xmlExclusao.addExame(idAlvaro, alv.getCodigo());
                                    exaDesm.setValor("exameAlvaro", alv.getCodigo());
                                }
                            } else {
                                ExameAlvaro alv = new ExameAlvaro(exame.getString("ele_xmllabexterno"));
                                alv.setExameJalis(exame.getString("exa_codigo"));
                                xmlExclusao.addExame(idAlvaro, alv.getCodigo());
                                exame.setValor("exameAlvaro", alv.getCodigo());
                            }
                            listaExamesExclusao.add(exame.clone());
                        }
                        if (listaExamesExclusao.isEmpty()) continue;
                        req.substituirValor("listaexames", listaExamesExclusao);
                    }
                    if (xmlExclusao.xmlExclusao().contains("solicitacao")) {
                        String linha;
                        URL url = new URL(enderecoWebService);
                        urlConnection = (HttpURLConnection)url.openConnection();
                        urlConnection.setDoOutput(true);
                        urlConnection.setDoInput(true);
                        urlConnection.setRequestMethod("DELETE");
                        urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                        urlConnection.connect();
                        OutputStream os = urlConnection.getOutputStream();
                        os.write(xmlExclusao.xmlExclusao().getBytes());
                        os.flush();
                        BufferedReader leitura = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                        while ((linha = leitura.readLine()) != null) {
                            retornoWebService.append(linha);
                        }
                        System.out.println("=========== XML ENVIO ===========");
                        System.out.println(xmlExclusao.xmlExclusao());
                        leitura.close();
                        validaRetorno = exp.validarRetorno(retornoWebService.toString(), "exclusoes");
                        System.out.println("=========== Retorno Alvaro ===========");
                        System.out.println(retornoWebService.toString());
                        if (validaRetorno) {
                            this.processaRetornoWebServiceExclusao(st, retornoWebService, listaRequisicoes, codigoLote, labSelecionado, isColetaWeb, arquivar, anular, agruparInterface, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
                        }
                    } else if (!requisicoesDesmarcadas) {
                        erros.append("O envio n\u00e3o possui a TAG -> <solicitacao>");
                    }
                }
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        if (!Funcoes.textoVazio(erros.toString())) {
            anular.call();
            if (isColetaWeb) {
                retorno.setSucesso(false);
                retorno.setMensagem("N\u00e3o foi poss\u00edvel remover os exame/solicita\u00e7\u00f5es do lote, pois o \u00c1lvaro retornou a seguinte mensagem: <br> " + erros.toString());
            } else {
                String msg = "N\u00e3o foi poss\u00edvel remover os exame/solicita\u00e7\u00f5es do lote, pois o \u00c1lvaro retornou a seguinte mensagem: \n " + erros.toString();
                erros = new StringBuilder();
                erros.append(msg);
                if (isColetaWeb) {
                    retorno.setSucesso(false);
                    retorno.setMensagem(erros.toString() + "<br>" + retornoWebService.toString());
                } else {
                    ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erros.toString(), retornoWebService.toString());
                    VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Exames que n\u00e3o foram exclu\u00eddos: ", erroRetornoWebServiceLabExterno, false, "Alvaro");
                }
            }
        } else {
            if (!validaRetorno) {
                return retorno;
            }
            String texto = "Solicita\u00e7\u00e3o de exclus\u00e3o atendida com sucesso pelo Apoio.";
            if (!isColetaWeb) {
                Funcoes.mensagem(null, texto, 2);
            } else {
                retorno.setMensagem(texto);
            }
            retorno.setSucesso(true);
        }
        return retorno;
    }

    public String obterCodigoAlvaroRetornadoNovo(Registro registro, String codLabExterno, String numeroLote, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) {
        String retorno;
        block6: {
            retorno = "";
            try {
                String leqRetornows = UtilExportadores.retornoWs(registro, codLabExterno, Funcoes.textoVazio(numeroLote) ? null : numeroLote, st);
                if (Funcoes.textoVazio(leqRetornows)) {
                    leqRetornows = UtilExportadores.retornoWs(registro, codLabExterno, null, st);
                }
                if (Funcoes.textoVazio(leqRetornows)) break block6;
                if (leqRetornows != null && !leqRetornows.contains("<solicitacoes>") && !leqRetornows.contains("</solicitacoes>")) {
                    leqRetornows = "<solicitacoes>" + leqRetornows + "</solicitacoes>";
                }
                List<String> solicitacoes = StringUtil.getListValoresTagAberta(leqRetornows.toString(), "solicitacao", false);
                Collections.reverse(solicitacoes);
                String filial = registro.getString("fil_codigo");
                String requisicao = registro.getString("req_codigo");
                for (String solicitacao : solicitacoes) {
                    String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                    String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
                    if (Funcoes.textoVazio(idLis)) {
                        String identificacao;
                        List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                        idLis = identificacao = this.obterAtributoTagInformacao(amostras.get(0), "identificacao");
                    }
                    filial = StringUtil.removeZerosEsquerda(idLis.substring(0, digitosTuboFilial));
                    requisicao = StringUtil.removeZerosEsquerda(idLis.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboFilial));
                    if (!requisicao.equalsIgnoreCase(registro.getString("req_codigomae")) && !requisicao.equalsIgnoreCase(registro.getString("req_codigo")) || !filial.equalsIgnoreCase(registro.getString("fil_codigo"))) continue;
                    retorno = idAlvaro;
                    break;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return retorno;
    }

    private String obterCodigoAlvaroRetornado(Statement statement, Registro registro, boolean agruparGuiasInterface) throws Exception {
        Integer[] multiGuias = null;
        boolean agruparMultiguia = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, registro.getString("fil_kodigo"), registro.getString("req_codigo"));
        multiGuias = agruparMultiguia ? RecepcaoUtil.verificaMultiGuias(statement, registro.getString("fil_kodigo"), registro.getString("req_codigo"), true) : new Integer[]{Integer.parseInt(registro.getString("req_codigo"))};
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select leq_retornows from loteexternorequisicao where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lex_codigo=").append(registro.getString("lex_codigo"));
        sql.append(" and req_codigo in(").append(StringUtil.implode(Arrays.asList(multiGuias), ",")).append(")");
        sql.append(" and lae_codigo=").append(registro.getString("lae_codigo"));
        sql.append(" and fil_kodigo=").append(registro.getString("fil_kodigo"));
        sql.append(" and leq_dataestorno is null ");
        sql.append(" and usr_codestorno is null ");
        ResultSet rs = statement.executeQuery(sql.toString());
        if (rs.next()) {
            String leqRetornows = rs.getString("leq_retornows");
            if (leqRetornows != null && !leqRetornows.contains("<solicitacoes>") && !leqRetornows.contains("</solicitacoes>")) {
                leqRetornows = "<solicitacoes>" + rs.getString("leq_retornows") + "</solicitacoes>";
            }
            block0: do {
                if (Funcoes.textoVazio(leqRetornows)) continue;
                List<String> solicitacoes = StringUtil.getListValoresTagAberta(leqRetornows, "solicitacao", false);
                Collections.reverse(solicitacoes);
                for (String solicitacao : solicitacoes) {
                    String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                    String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
                    if (Funcoes.textoVazio(idLis)) {
                        String identificacao;
                        List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                        idLis = identificacao = this.obterAtributoTagInformacao(amostras.get(0), "identificacao");
                    }
                    if (Funcoes.textoVazio(retorno = idAlvaro)) continue;
                    registro.setValor("idAlvaro", idAlvaro);
                    continue block0;
                }
            } while (rs.next());
        }
        return retorno;
    }

    public boolean isNovaAmostra(Statement statement, Registro registro, String amostra, boolean agruparGuiasInterface) throws Exception {
        Integer[] multiGuias = null;
        boolean agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, registro.getString("fil_codigo"), registro.getString("req_codigo"));
        multiGuias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(statement, registro.getString("fil_codigo"), registro.getString("req_codigo"), true) : new Integer[]{Integer.parseInt(registro.getString("req_codigo"))};
        StringBuilder sql = new StringBuilder();
        sql.append("select leq_retornows from loteexternorequisicao where fil_codigo = ").append(registro.getValor("fil_codigo"));
        sql.append(" and req_codigo in(").append(StringUtil.implode(Arrays.asList(multiGuias), ",")).append(")");
        sql.append(" and fil_kodigo=").append(registro.getString("fil_codigo"));
        ResultSet rs = statement.executeQuery(sql.toString());
        if (rs.next()) {
            String leqRetornows = rs.getString("leq_retornows");
            if (leqRetornows != null && !leqRetornows.contains("<solicitacoes>") && !leqRetornows.contains("</solicitacoes>")) {
                leqRetornows = "<solicitacoes>" + rs.getString("leq_retornows") + "</solicitacoes>";
            }
            do {
                if (Funcoes.textoVazio(leqRetornows)) continue;
                List<String> solicitacoes = StringUtil.getListValoresTagAberta(leqRetornows, "solicitacao", false);
                for (String solicitacao : solicitacoes) {
                    List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                    for (String amostraCodigo : amostras) {
                        String identificacao = this.obterAtributoTagInformacao(amostraCodigo, "identificacao");
                        if (!identificacao.equalsIgnoreCase(amostra)) continue;
                        return false;
                    }
                }
            } while (rs.next());
        }
        return true;
    }

    private void processaRetornoWebServiceExclusao(Statement st, StringBuilder retornoWebService, List<Registro> requisicoes, String codigoLote, LaboratorioExterno labExterno, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService.toString(), "solicitacao", false);
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        HashMap<String, List<Element>> mapSolicitacoes = new HashMap<String, List<Element>>();
        for (String solicitacao : solicitacoes) {
            String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
            ByteArrayInputStream is = new ByteArrayInputStream(solicitacao.getBytes());
            InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
            InputSource io = new InputSource(reader);
            io.setEncoding("UTF-8");
            DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dbf.parse(io);
            Element raiz = doc.getDocumentElement();
            List<Element> listaExamesAlv = XMLUtil.getElementosFilhos(raiz);
            mapSolicitacoes.put(idAlvaro, listaExamesAlv);
        }
        for (Registro req : requisicoes) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            List examesSolicitacao = (List)mapSolicitacoes.get(req.getString("idAlvaro"));
            ArrayList<Registro> listaExames = new ArrayList<Registro>();
            block2: for (Registro exa : exames) {
                ArrayList examesDesm = (ArrayList)exa.getValor("listaexames");
                if (examesDesm != null && !examesDesm.isEmpty()) {
                    ArrayList<Registro> listaExamesDesm = new ArrayList<Registro>();
                    block3: for (Registro regDesm : examesDesm) {
                        for (Element exaAlv : examesSolicitacao) {
                            if (!regDesm.getString("exameAlvaro").equalsIgnoreCase(exaAlv.getAttribute("codigoExame")) || !StringUtil.getBoolean(exaAlv.getAttribute("excluido"))) continue;
                            listaExamesDesm.add(exa.clone());
                            continue block3;
                        }
                    }
                    if (!listaExamesDesm.isEmpty()) {
                        exa.setValor("listaexames", listaExamesDesm.clone());
                    }
                    listaExames.add(exa.clone());
                    continue;
                }
                for (Element exaAlv : examesSolicitacao) {
                    if (!exa.getString("exameAlvaro").equalsIgnoreCase(exaAlv.getAttribute("codigoExame")) || !StringUtil.getBoolean(exaAlv.getAttribute("excluido"))) continue;
                    listaExames.add(exa.clone());
                    continue block2;
                }
            }
            if (!listaExames.isEmpty()) {
                req.setValor("listaexames", listaExames.clone());
            }
            listaExames.clear();
            listaRequisicoes.add(req.clone());
        }
        for (Registro req : listaRequisicoes) {
            for (String solicitacao : solicitacoes) {
                String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
                if (!req.getString("idAlvaro").equals(idAlvaro)) continue;
                StringBuilder sqlpdate = new StringBuilder();
                sqlpdate.append(" update  loteexternorequisicao set leq_retornows = leq_retornows || E'").append("<exclusoes>" + solicitacao.replaceAll("solicitacao", "deletado") + "</exclusoes>").append("'");
                sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                sqlpdate.append(" and lae_codigo = ").append(req.getString("lae_codigo"));
                sqlpdate.append(" and req_codigo in(").append(req.getString("req_codigo")).append(")");
                sqlpdate.append(" and lex_codigo = ").append(req.getString("lex_codigo"));
                sqlpdate.append(" and fil_kodigo = ").append(req.getString("fil_kodigo")).append(";");
                if (isColetaWeb) {
                    st.executeUpdate(sqlpdate.toString());
                    continue;
                }
                Conexao.executeUpdate(Variaveis.filialPadrao, st, sqlpdate.toString());
            }
        }
    }

    private void excluirRequisicaoWebService(boolean isColetaWeb, Statement st, Registro r, String login) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
        buf.append("where fil_codigo = ").append(r.getInt("fil_kodigo"));
        buf.append(" and req_codigo = ").append(r.getString("req_codigo"));
        buf.append(" and exa_codigo = '").append(r.getString("exa_codigo")).append("' ");
        buf.append(" and mco_codigo = ").append(r.getString("mco_codigo"));
        if (isColetaWeb) {
            st.executeUpdate(buf.toString());
        } else {
            Conexao.execute(r.getString("fil_kodigo"), st, buf);
        }
        buf.delete(0, buf.length());
        buf.append("update loteexternorequisicao set leq_dataestorno = current_timestamp,  usr_codestorno ='").append(login).append("'");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("  and fil_kodigo = ").append(r.getString("fil_kodigo"));
        buf.append("  and lex_codigo = ").append(r.getString("lex_codigo"));
        buf.append("  and req_codigo = ").append(r.getString("req_codigo"));
        buf.append("  and lae_codigo = ").append(r.getString("lae_codigo"));
        buf.append("  and lae_codigo = ").append(r.getString("lae_codigo"));
        if (isColetaWeb) {
            st.executeUpdate(buf.toString());
        } else {
            Conexao.executeUpdate(r.getString("fil_codigo"), st, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirLoteExterno(boolean isColetaWeb, Statement st, String lote, String login, Callable<Boolean> arquivar) throws Exception {
        StringBuilder buf = new StringBuilder();
        arquivar.call();
        buf.append("select * from loteexternorequisicao where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lex_codigo = ").append(lote);
        buf.append(" and leq_dataestorno is null and usr_codestorno is null ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (!rs.next()) {
                buf.delete(0, buf.length());
                buf.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(login).append("'");
                buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("  and lex_codigo = ").append(lote);
                if (isColetaWeb) {
                    st.executeUpdate(buf.toString());
                } else {
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                }
            }
        }
    }

    private String obterAtributoTagInformacao(String xml, String atributo) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.removerAcentos(xml).getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        InputSource io = new InputSource(reader);
        io.setEncoding("UTF-8");
        DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dbf.parse(io);
        Element raiz = doc.getDocumentElement();
        return raiz.getAttribute(atributo);
    }

    public RetornoImpressaoEtiquetas processaRetornoWsSegundaViaEtiqueta(boolean isColetaWeb, String codLabExterno, String retornoWebService, StringBuilder erro, String numeroLote, boolean gravaRetornoPorRequisicao, List<Registro> requisicoesOriginal, List<Registro> requisicoes, boolean reenvio, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, String tipoIntegracao, boolean agruparGuiasInterface, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (!retornoWebService.startsWith("<?xml")) {
            String mensagem = "Mensagem inv\u00e1lida retornada pelo WebService do laborat\u00f3rio \u00c1lvaro.\nAcesse o site do laborat\u00f3rio de apoio e verifique a situa\u00e7\u00e3o do lote.";
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
            }
            UtilExportadores.adicionarMensagemRetorno(mensagem, "Alvaro", retorno);
            return retorno;
        }
        List<String> solicitacoes = StringUtil.getListValoresTagAberta(retornoWebService, "solicitacao", false);
        int qtDigitosTubo = digitosTuboFilial + digitosTuboRequisicao + digitosTuboTubo;
        ArrayList<String> chaves = new ArrayList<String>();
        ArrayList<byte[]> etiquetas = new ArrayList<byte[]>();
        for (String solicitacao : solicitacoes) {
            String idAlvaro = this.obterAtributoTagInformacao(solicitacao, "idAlvaro");
            String filial = null;
            String requisicao = null;
            ArrayList<String> listaAmostrasIncluidas = new ArrayList<String>();
            HashMap<String, String> mapAmostras = new HashMap<String, String>();
            List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
            for (String amostra : amostras) {
                this.obterAtributoTagInformacao(amostra, "idAmostra");
                this.obterAtributoTagInformacao(amostra, "material");
                String identificacao = this.obterAtributoTagInformacao(amostra, "identificacao");
                if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) {
                    filial = StringUtil.removeZerosEsquerda(identificacao.substring(0, digitosTuboFilial));
                    requisicao = identificacao.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboFilial);
                }
                List<Element> filhos = this.obterAtributosTagInformacao(amostra);
                for (Element tagFilho : filhos) {
                    if (Funcoes.textoVazio(tagFilho.getAttribute("incluido")) || StringUtil.getBoolean(tagFilho.getAttribute("incluido")) || mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(identificacao.concat(tagFilho.getAttribute("codigo")), amostra);
                }
                if (!Funcoes.textoVazio(this.obterAtributoTagInformacao(amostra, "incluido")) && !StringUtil.getBoolean(this.obterAtributoTagInformacao(amostra, "incluido"))) {
                    if (mapAmostras.containsKey(identificacao)) continue;
                    mapAmostras.put(identificacao, amostra);
                    continue;
                }
                for (Element tagFilho : filhos) {
                    String chave = identificacao.concat(tagFilho.getAttribute("codigo"));
                    if (!mapAmostras.containsKey(chave)) continue;
                    mapAmostras.remove(chave);
                }
                this.obterAtributosTagInformacao(amostra);
                listaAmostrasIncluidas.add(amostra);
            }
            List<Object> amostrasRecebidas = new ArrayList();
            if (solicitacao.isEmpty()) continue;
            String novaSolicitacao = solicitacao;
            int contador = 0;
            for (String amostra : listaAmostrasIncluidas) {
                String identificacao = this.obterAtributoTagInformacao(amostra, "identificacao");
                if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) {
                    filial = StringUtil.removeZerosEsquerda(identificacao.substring(0, digitosTuboFilial));
                    requisicao = this.getCodigoRequisicao(qtDigitosTubo, identificacao, digitosTuboFilial, digitosTuboTubo);
                }
                boolean proximaAmostra = false;
                for (Registro reg : requisicoes) {
                    Integer[] guias = RecepcaoUtil.verificaMultiGuias(st, filial, reg.getString("req_codigo"), true, false);
                    String guia = StringUtil.implode(Arrays.asList(guias), ",");
                    ArrayList listaExames = (ArrayList)reg.getValor("listaexames");
                    if (!reg.getString("fil_codigo").equals(filial) || !guia.contains(requisicao)) continue;
                    boolean isLoteEstornado = UtilExportadores.verificaEstornoLote(reg, st);
                    String rw = UtilExportadores.retornoWs(reg, codLabExterno, reg.getString("lex_codigo"), st);
                    List<String> examesAmostra = StringUtil.getListValoresTagAberta(amostra, "exame", false);
                    boolean temLote = !isLoteEstornado && !Funcoes.textoVazio(rw);
                    String chave = reg.getString("fil_codigo") + reg.getString("req_codigo");
                    if (chaves.contains(chave)) continue;
                    chaves.add(chave);
                    if (!reenvio && temLote) {
                        for (Registro exa : listaExames) {
                            ArrayList examesDesm = (ArrayList)exa.getValor("listaexames");
                            if (examesDesm != null && !examesDesm.isEmpty()) {
                                for (Registro exaDesm : examesDesm) {
                                    ExameAlvaro codigoAlvReq = new ExameAlvaro(exaDesm.getString("ele_xmllabexterno"));
                                    for (String exame : examesAmostra) {
                                        String exameAlvaro = StringUtil.getValor(exame, "exame");
                                        if (!Funcoes.textoVazio(exameAlvaro) || codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) continue;
                                        novaSolicitacao = StringUtil.replaceBuilder(novaSolicitacao, amostra, "");
                                        proximaAmostra = listaAmostrasIncluidas.size() - ++contador != examesDesm.size();
                                    }
                                }
                                continue;
                            }
                            ExameAlvaro codigoAlvReq = new ExameAlvaro(exa.getString("ele_xmllabexterno"));
                            for (String exame : examesAmostra) {
                                String exameAlvaro = StringUtil.getValor(exame, "exame");
                                if (!Funcoes.textoVazio(exameAlvaro) || codigoAlvReq.getCodigo().equalsIgnoreCase(exameAlvaro)) continue;
                                novaSolicitacao = StringUtil.replaceBuilder(novaSolicitacao, amostra, "");
                                proximaAmostra = listaAmostrasIncluidas.size() - ++contador != listaExames.size();
                            }
                        }
                    }
                    requisicao = reg.getString("req_codigo");
                    break;
                }
                if (proximaAmostra) continue;
                if (requisicao.contains(",")) {
                    requisicao = this.getCodigoRequisicao(qtDigitosTubo, identificacao, digitosTuboFilial, digitosTuboTubo);
                }
                Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
                if (agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, multiguias)) {
                    requisicao = StringUtil.implode(Arrays.asList(multiguias), ",");
                }
                if (Funcoes.textoVazio(numeroLote)) continue;
                StringBuilder sqlpdate = new StringBuilder();
                sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(novaSolicitacao)).append("'");
                sqlpdate.append(" , leq_codigoreqapoio = ").append(idAlvaro);
                sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                sqlpdate.append(" and lae_codigo = ").append(codLabExterno);
                sqlpdate.append(" and req_codigo in(").append(requisicao).append(") ");
                sqlpdate.append(" and lex_codigo = ").append(numeroLote);
                sqlpdate.append(" and fil_kodigo = ").append(filial).append(";");
                st.executeUpdate(sqlpdate.toString());
                if (!isColetaWeb && (!filial.equals(Variaveis.filialPadrao) || tipoIntegracao.equals("F") || tipoIntegracao.equals("W"))) {
                    IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
                }
                amostrasRecebidas = StringUtil.getListValoresTagAberta(novaSolicitacao, "amostra", false);
            }
            for (String novaAmostra : amostrasRecebidas) {
                String etiqueta = StringUtil.getValor(novaAmostra, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n';
                ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(agruparInterface, impressoras), tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
                etiquetas.add(termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular));
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("alvaro", etiquetas);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        listaRequisicoes.addAll(requisicoesOriginal);
        return retorno;
    }

    public String getImpressora(int agruparInterface, ImpressorasLabExterno impressoras) {
        String impressora = impressoras.getImpressoraAlvaro();
        if (Funcoes.textoVazio(impressora)) {
            impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return impressora;
    }

    private String getCodigoRequisicao(int qtDigitosTubo, String identificacao, int digitosTuboFilial, int digitosTuboTubo) {
        String requisicao = identificacao.length() == qtDigitosTubo ? StringUtil.removeZerosEsquerda(identificacao.substring(digitosTuboFilial, identificacao.length() - digitosTuboTubo)) : StringUtil.removeZerosEsquerda(identificacao.substring(digitosTuboFilial, identificacao.length()));
        return requisicao;
    }

    private List<Element> obterAtributosTagInformacao(String xml) {
        List<Element> retorno = new ArrayList<Element>();
        try {
            Document doc = XMLUtil.analisarXMLString(xml);
            Element raiz = doc.getDocumentElement();
            retorno = XMLUtil.getElementosFilhos(raiz);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar o XML", e.getStackTrace());
        }
        return retorno;
    }
}

