/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Tipos;
import jalis.laboratorio.triagem.externo.CriaLoteExportacao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

class RendererRequisicao
extends CorTableCellRenderer {
    RendererRequisicao() {
    }

    public static RendererRequisicao novaInstancia(int ... alinhamentos) {
        RendererRequisicao renderer = new RendererRequisicao();
        for (int i = 0; i < alinhamentos.length; ++i) {
            if (alinhamentos[i] <= -1) continue;
            renderer.setAlinhamentoColuna(i, alinhamentos[i]);
        }
        return renderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ModeloGridTable model = (ModeloGridTable)table.getModel();
        Registro reg = this.hashMapToReg(row, model);
        if (Funcoes.textoVazio(reg.getString("pac_datanasc"))) {
            this.setBackground(ScreenUtil.clarearCor(Color.RED, 180));
            this.setToolTipText("Paciente da requisi\u00e7\u00e3o n\u00e3o possui data de nascimento");
        } else if (reg.getBoolean("exa_exportado")) {
            this.setToolTipText("Cont\u00e9m exames exportados");
            this.setBackground(ScreenUtil.clarearCor(Tipos.COR_CONFERIDO[0], 30));
        }
        if (reg.getBoolean("req_deveguia")) {
            this.setToolTipText("Requisi\u00e7\u00e3o sem guia");
            this.setBackground(CriaLoteExportacao.COR_FALTAGUIA);
        } else {
            double total = reg.getDouble("req_total");
            double totalPago = reg.getDouble("req_totpago");
            if (totalPago < total) {
                this.setBackground(CriaLoteExportacao.COR_SALDODEVEDOR);
            }
        }
        return this;
    }

    private Registro hashMapToReg(int line, ModeloGridTable modReq) {
        Registro reg = new Registro();
        for (int i = 0; i < CriaLoteExportacao.campos.length; ++i) {
            reg.setValor(CriaLoteExportacao.campos[i], modReq.getValueAt(line, i));
        }
        return reg;
    }
}

