/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.ReimpressaoRelatorioEtiqueta;
import jalis.laboratorio.triagem.externo.exportadores.ReimprimirRelatorioEtiquetaLabApoio;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ReimprimirRelatorioEtiqueta
extends JPanel
implements ListSelectionListener,
ActionListener {
    public static final int TIPO_ETIQUETA = 1;
    public static final int TIPO_RELATORIO = 2;
    private static final long ACESSO_ETIQUETA = Long.parseLong("0300600300");
    private static final long ACESSO_RELATORIO = Long.parseLong("0300600400");
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_EXAMES = 3;
    private int lae_codigo;
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    protected ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Paciente"});
    protected ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 30, 70, 0);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JComboBox comboLaboratorio = ComponenteFactory.novoJComboBox(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true), this, true, new Dimension(400, 20));
    private JLabel labelCombo = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", 'L', null, this.comboLaboratorio);
    private TTextField textLote = new TTextField(10, 1);
    private JButton buttonLote = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JLabel labelLote = ComponenteFactory.novoJLabel("   Lote:", 't', null, this.textLote);
    private LaboratorioExterno labSelecionado;
    int status = 1;
    int tipo = 1;

    public ReimprimirRelatorioEtiqueta(int tipo) {
        this.tipo = tipo;
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        if (this.tipo == 1) {
            Funcoes.criaBarraDescricao(this, "Reimprimir etiqueta de lote", "Reimpress\u00e3o de etiquetas para lotes enviados ao laborat\u00f3rio de apoio", "triagem/lab_externo_reimprimir_etq_lote.jpg");
        } else {
            Funcoes.criaBarraDescricao(this, "Reimprimir relat\u00f3rio de lote", "Reimpress\u00e3o do relat\u00f3rio para lotes enviados ao laborat\u00f3rio de apoio", "triagem/lab_externo_reimprimir_relatorio_lote.jpg");
        }
        this.textLote.setPreferredSize(new Dimension(80, 20));
        this.textLote.setMinimumSize(new Dimension(80, 20));
        this.buttonLote.setFocusable(false);
        this.panelBotoes.add(this.buttonImprimir);
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        JPanel panelReq = new JPanel(new BorderLayout());
        JPanel panelExm = new JPanel(new BorderLayout());
        panelReq.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        panelExm.setBorder(new TitledBorder("Exames"));
        panelReq.add((Component)this.scrollRequisicoes, "Center");
        panelExm.add((Component)this.scrollExames, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        JPanel p = new JPanel(new FlowLayout(0, 1, 1));
        p.setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
        this.panelCentro.add((Component)p, c);
        p.add(this.labelCombo);
        p.add(this.comboLaboratorio);
        p.add(this.labelLote);
        p.add(this.textLote);
        p.add(this.buttonLote);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        this.panelCentro.add((Component)panelReq, c);
        c.gridx = 1;
        this.panelCentro.add((Component)panelExm, c);
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.textLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ReimprimirRelatorioEtiqueta.this.buscaDadosLote();
                } else if (e.getKeyCode() == 113) {
                    ReimprimirRelatorioEtiqueta.this.pesquisaLote();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReimprimirRelatorioEtiqueta.this.novo();
            }
        });
        this.comboLaboratorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReimprimirRelatorioEtiqueta.this.labSelecionado = (LaboratorioExterno)ReimprimirRelatorioEtiqueta.this.comboLaboratorio.getSelectedItem();
                ReimprimirRelatorioEtiqueta.this.comboLaboratorio.setEnabled(false);
            }
        });
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == 1) {
            return ACESSO_ETIQUETA;
        }
        return ACESSO_RELATORIO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.modeloExames.clear();
        if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3) instanceof ArrayList) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3);
            for (Registro r : exames) {
                this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao")});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonImprimir) {
            this.imprimir(this.textLote.getText());
        } else if (o == this.buttonLote) {
            this.pesquisaLote();
        }
    }

    private void pesquisaLote() {
        boolean retorno;
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        this.labSelecionado = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        Hashtable resultado = Pesquisas.loteExterno(this.getTopLevelAncestor(), this.labSelecionado.codigoLab);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textLote.setText(resultado.get("lex_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void imprimir(String lote) {
        Statement st = Conexao.getStatement();
        if (this.tipo == 1) {
            Callable<Boolean> arquivar = () -> {
                try {
                    Conexao.arquivaSQL();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            };
            Callable<Boolean> anular = () -> {
                try {
                    Conexao.anulaSQL();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            };
            this.imprimirEtiqueta(lote, this.lae_codigo, arquivar, anular);
        } else {
            this.imprimirRelatorio(false, Variaveis.filialPadrao, st, ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial(), ParametrosLocais.getParametro("impressoraRelatorio"));
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirEtiqueta(String lote, int codigoLabExterno, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        Statement st4;
        Statement st3;
        Statement st2;
        Statement st;
        block10: {
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            st3 = Conexao.getStatement();
            st4 = Conexao.getStatement();
            ImpressorasLabExterno impressoras = new ImpressorasLabExterno();
            impressoras.setImpressoraAlvaro(ParametrosLocais.getParametro("impressoraWebServiceAlvaro"));
            impressoras.setImpressoraDiagnosticosBrasil(ParametrosLocais.getParametro("impressoraWebServiceDb"));
            impressoras.setImpressoraIndLab("");
            impressoras.setImpressoraJalisWS(ParametrosLocais.getParametro("impressoraJalisWs"));
            impressoras.setImpressoraMercolab(ParametrosLocais.getParametro("impressoraWebServiceMercolab"));
            impressoras.setImpressoraPardini(ParametrosLocais.getParametro("impressoraWebServiceHp"));
            impressoras.setImpressoraRedeWS(ParametrosLocais.getParametro("impressoraWebServiceRede"));
            impressoras.setImpressoraSaoMarcos(ParametrosLocais.getParametro("impressoraWebServiceSm"));
            impressoras.setImpressoraShift(ParametrosLocais.getParametro("impressoraWebServiceShift"));
            impressoras.setImpressoraSoftLab(ParametrosLocais.getParametro("impressoraWebServiceSoftLab"));
            impressoras.setImpressoraMaricondi(ParametrosLocais.getParametro("impressoraWebServiceMaricondi"));
            impressoras.setImpressoraEtqTriagem(ParametrosLocais.getParametro("impressoraEtqTriagem"));
            impressoras.setImpressoraEtqColeta(ParametrosLocais.getParametro("impressoraEtqColeta"));
            try {
                Protocolo p = Protocolo.getProtocolo(this.getNomeProtocolo(st, codigoLabExterno));
                ReimpressaoRelatorioEtiqueta imp = FabricaExportador.novoReimprimirEtiqueta(p);
                if (imp != null) {
                    String xmlConfiguracao = UtilExportadores.getXMLConfiguracaoProtocolo(st, codigoLabExterno);
                    if (p == Protocolo.Jalis) {
                        this.imprimirEtiquetaJalis(imp, null, xmlConfiguracao, st, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), false, arquivar, anular, impressoras.getImpressoraEtqColeta());
                    } else if (p == Protocolo.Rede) {
                        imp.reimprimirEtiquetas(String.valueOf(this.lae_codigo), lote, null, xmlConfiguracao, st, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), false, arquivar, anular, ParametrosLocais.getParametro("impressoraEtqColeta"));
                    } else {
                        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                            Integer codigoFilial = (Integer)this.modeloRequisicoes.getValueAt(i, 0);
                            String codigoRequisicao = (String)this.modeloRequisicoes.getValueAt(i, 1);
                            List exames = (List)this.modeloRequisicoes.getValueAt(i, 3);
                            imp.reimprimirEtiquetas(codigoRequisicao, String.valueOf(codigoFilial), exames, st, st2, st3, st4, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), false, arquivar, anular, ParametrosLocais.getParametro("impressoraEtqColeta"), ParametrosGerais.getAgruparInterface(), ParametrosGerais.isAgruparGuiasInterface(), Variaveis.login, impressoras, ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getLayCodigo(), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), ParametrosLocais.getParametro("cabecalhoEtiqueta") == null ? "" : ParametrosLocais.getParametro("cabecalhoEtiqueta"), ParametrosGerais.getExportarInterface(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getTipoEtiquetaSoroteca(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), p, null);
                        }
                    }
                    break block10;
                }
                Funcoes.mensagem(this, "O protocolo do lote n\u00e3o permite reimpress\u00e3o de etiquetas", 1);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiqueta (250)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2, st3, st4);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2, st3, st4);
            }
        }
        Conexao.fecharStatement(st, st2, st3, st4);
    }

    private void imprimirEtiquetaJalis(ReimpressaoRelatorioEtiqueta imp, AbstractConfiguradorProtocolo conf, String xmlConfiguracao, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta) {
        ArrayList<String> listaExames = new ArrayList<String>();
        ArrayList<String> listaMateriais = new ArrayList<String>();
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 3);
            for (Registro exa : exames) {
                String codigoApoio = this.getExameApoio(exa.getString("fil_kodigo"), exa.getString("exa_codigo"), exa.getString("mco_codigo"), this.lae_codigo);
                if (Funcoes.textoVazio(codigoApoio)) continue;
                String exaApoio = codigoApoio.split("-")[0];
                String matApoio = codigoApoio.split("-")[1];
                if (!listaExames.contains(exaApoio)) {
                    listaExames.add(exaApoio);
                }
                if (listaMateriais.contains(matApoio)) continue;
                listaMateriais.add(matApoio);
            }
        }
        String listaExa = StringUtil.implode(listaExames, ",");
        String listaMat = StringUtil.implode(listaMateriais, ",");
        imp.reimprimirEtiquetas(String.valueOf(this.lae_codigo), this.textLote.getText(), null, xmlConfiguracao, listaExa, listaMat, st, digitosTuboFilial, digitosTuboRequisicao, isColetaWeb, arquivar, anular, impressoraEtqColeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExameApoio(String filial, String exame, String material, int labExterno) {
        Statement st;
        block4: {
            String string;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select ele_xmllabexterno from examematcoletalabexterno ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and exa_codigo = '").append(exame).append("' ");
            buf.append("   and mco_codigo = ").append(material);
            buf.append("   and lae_codigo = ").append(labExterno);
            try {
                String xml;
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next() || Funcoes.textoVazio(xml = res.getString("ele_xmllabexterno"))) break block4;
                String tagExame = StringUtil.getValor(xml, "exame");
                String exa_codigo = StringUtil.getValor(tagExame, "codigoExame");
                String mco_codigo = StringUtil.getValor(tagExame, "codigoMaterial");
                res.close();
                string = exa_codigo + "-" + mco_codigo;
            }
            catch (SQLException e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar as configura\u00e7\u00f5es do exame do laborat\u00f3rio apoio.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    private void imprimirRelatorio(boolean isColetaWeb, String filial, Statement st, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) {
        try {
            Protocolo p = Protocolo.getProtocolo(this.getNomeProtocolo(st, this.lae_codigo));
            ReimpressaoRelatorioEtiqueta imp = FabricaExportador.novoReimprimirRelatorio(p);
            if (imp != null) {
                AbstractConfiguradorProtocolo conf = FabricaConfigurador.novoConfiguradorProtocolo(this.getTopLevelAncestor(), p, String.valueOf(this.lae_codigo));
                String xmlConfiguracao = UtilExportadores.getXMLConfiguracaoProtocolo(st, this.lae_codigo);
                conf.setXML(xmlConfiguracao, false);
                imp.reimprimirRelatorio(String.valueOf(this.lae_codigo), this.textLote.getText(), conf.getCodigoConvenio(), xmlConfiguracao);
            } else {
                ReimprimirRelatorioEtiquetaLabApoio rel = new ReimprimirRelatorioEtiquetaLabApoio();
                ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
                for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                    Registro registro = new Registro();
                    registro.setValor("lex_codigo", this.textLote.getText());
                    registro.setValor("lae_codigo", String.valueOf(this.lae_codigo));
                    registro.setValor("req_codigo", this.modeloRequisicoes.getValueAt(i, 1));
                    registro.setValor("fil_codigo", this.modeloRequisicoes.getValueAt(i, 0));
                    registro.setValor("fil_codigo", this.modeloRequisicoes.getValueAt(i, 0));
                    registro.setValor("listaexamestela", this.modeloRequisicoes.getValueAt(i, 3));
                    listaRequisicoes.add(registro);
                }
                rel.reimprimirRelatorioLabApoio(String.valueOf(this.lae_codigo), this.textLote.getText(), p, listaRequisicoes, isColetaWeb, filial, st, digitosTuboRequisicao, digitosTuboFilial, impressoraRelatorio);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiqueta (270)");
        }
    }

    private void controlaCampos() {
        this.comboLaboratorio.setEnabled(this.status == 2);
        this.textLote.setEnabled(this.status == 2);
        this.buttonLote.setEnabled(this.status == 2);
    }

    private void controlaBotoesEstorno() {
        this.buttonImprimir.setEnabled(this.status == 2 && this.tableRequisicoes.getRowCount() > 0);
    }

    private void limpaCampos() {
        this.comboLaboratorio.setSelectedItem(null);
        this.labSelecionado = null;
        this.textLote.clear();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        this.controlaBotoesEstorno();
        ScreenUtil.requisitarFoco(this.textLote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosLote() {
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        if (Funcoes.textoVazio(this.textLote.getText())) {
            ScreenUtil.requisitarFoco(this.textLote);
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select c.fil_kodigo, a.req_codigo, b.pac_nome, c.lae_codigo ");
            buf.append("from loteexternorequisicao c ");
            buf.append("left join requisicao a on c.fil_kodigo = a.fil_codigo and c.req_codigo = a.req_codigo ");
            buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            buf.append("where c.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and c.lex_codigo = ").append(this.textLote.getText());
            buf.append(" and c.lae_codigo = ").append(this.labSelecionado.codigoLab);
            buf.append(" and a.req_excluida = false ");
            buf.append(" order by c.fil_kodigo, a.req_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                boolean parar = false;
                this.lae_codigo = rs.getInt("lae_codigo");
                Protocolo p = Protocolo.getProtocolo(this.getNomeProtocolo(st2, this.lae_codigo));
                parar = this.tipo == 1 && !p.getReimprimirEtiquetas();
                if (parar) {
                    Funcoes.mensagem(this, "O protocolo do lote n\u00e3o permite a reimpress\u00e3o de etiquetas", 1);
                } else {
                    parar = this.tipo == 2 && !p.getReimprimirRelatorio();
                    if (parar) {
                        Funcoes.mensagem(this, "O protocolo do lote n\u00e3o permite a reimpress\u00e3o de relat\u00f3rio de requisi\u00e7\u00f5es enviadas", 1);
                    }
                }
                if (!parar) {
                    this.textLote.setEnabled(false);
                    this.buttonLote.setEnabled(false);
                    do {
                        ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, this.lae_codigo, rs.getString("req_codigo"), this.textLote.getText(), rs.getString("fil_kodigo"));
                        this.modeloRequisicoes.addLine(new Object[]{rs.getInt("fil_kodigo"), rs.getString("req_codigo"), rs.getString("pac_nome"), exames});
                    } while (rs.next());
                } else {
                    this.limpaCampos();
                    this.novo();
                }
            } else {
                Funcoes.mensagem(this, "Lote n\u00e3o encontrado", 2);
                this.textLote.clear();
                ScreenUtil.requisitarFoco(this.textLote);
            }
            this.controlaBotoesEstorno();
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiqueta: 285");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
    }

    private String getNomeProtocolo(Statement st, int codigoLaboratorioExterno) throws Exception {
        StringBuilder buf = new StringBuilder("select lae_protocolo from labexterno ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigoLaboratorioExterno);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getString("lae_protocolo");
        }
        return "";
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, int laboratorioExterno, String requisicao, String codigoLote, String filialDaRequisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
        buf.append("from loteexternoexamerequisicao a ");
        buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.lae_codigo = ").append(laboratorioExterno);
        buf.append(" and a.lex_codigo = ").append(codigoLote);
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }
}

