/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ReenviarLoteExterno
extends IntegracaoLabExterno
implements ListSelectionListener,
ActionListener {
    private static final long ACESSO = Long.parseLong("0300600500");
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_EXAMES = 3;
    private final int COLUNA_DADOS_EXPORTACAO = 4;
    private int lae_codigo;
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Paciente"});
    private ModeloGridTable modeloRequisicoesEnviadas = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Paciente"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 30, 70, 0);
    private JTable tableRequisicoesEnviadas = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoesEnviadas, (ListSelectionListener)this, 30, 70, 0);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private JScrollPane scrollRequisicoesEnviadas = new JScrollPane(this.tableRequisicoesEnviadas);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JButton buttonReenviar = ComponenteFactory.novoJButton("Reenviar", 'R', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JComboBox comboLaboratorio = ComponenteFactory.novoJComboBox(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true), this, true, new Dimension(400, 20));
    private JLabel labelCombo = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", 'L', null, this.comboLaboratorio);
    private TTextField textLote = new TTextField(10, 1);
    private JButton buttonLote = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JLabel labelLote = ComponenteFactory.novoJLabel("   Lote:", 't', null, this.textLote);
    private LaboratorioExterno labSelecionado;
    int status = 1;

    public ReenviarLoteExterno() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Reenviar lote", "Reenvio de lotes ao laborat\u00f3rio de apoio", "triagem/lab_externo_reenviar_lote.jpg");
        this.textLote.setPreferredSize(new Dimension(80, 20));
        this.textLote.setMinimumSize(new Dimension(80, 20));
        this.buttonLote.setFocusable(false);
        this.panelBotoes.add(this.buttonReenviar);
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        JPanel panelReq = new JPanel(new BorderLayout());
        JPanel panelExm = new JPanel(new BorderLayout());
        JPanel panelEnviadas = new JPanel(new BorderLayout());
        panelReq.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        panelExm.setBorder(new TitledBorder("Exames"));
        panelEnviadas.setBorder(new TitledBorder("Enviadas"));
        panelEnviadas.setPreferredSize(new Dimension(100, 150));
        panelReq.add((Component)this.scrollRequisicoes, "Center");
        panelReq.add((Component)panelEnviadas, "South");
        panelExm.add((Component)this.scrollExames, "Center");
        panelEnviadas.add((Component)this.scrollRequisicoesEnviadas, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        JPanel p = new JPanel(new FlowLayout(0, 1, 1));
        p.setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
        this.panelCentro.add((Component)p, c);
        p.add(this.labelCombo);
        p.add(this.comboLaboratorio);
        p.add(this.labelLote);
        p.add(this.textLote);
        p.add(this.buttonLote);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        this.panelCentro.add((Component)panelReq, c);
        c.gridx = 1;
        this.panelCentro.add((Component)panelExm, c);
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.textLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ReenviarLoteExterno.this.buscaDadosLote(ParametrosGerais.getAgruparInterface());
                } else if (e.getKeyCode() == 113) {
                    ReenviarLoteExterno.this.pesquisaLote();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReenviarLoteExterno.this.novo();
            }
        });
        this.comboLaboratorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReenviarLoteExterno.this.labSelecionado = (LaboratorioExterno)ReenviarLoteExterno.this.comboLaboratorio.getSelectedItem();
                ReenviarLoteExterno.this.comboLaboratorio.setEnabled(false);
            }
        });
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JTable tabela = this.tableRequisicoes.hasFocus() ? this.tableRequisicoes : this.tableRequisicoesEnviadas;
        ModeloGridTable modelo = this.tableRequisicoes.hasFocus() ? this.modeloRequisicoes : this.modeloRequisicoesEnviadas;
        this.modeloExames.clear();
        if (tabela.getSelectedRow() > -1 && modelo.getValueAt(tabela.getSelectedRow(), 3) != null && modelo.getValueAt(tabela.getSelectedRow(), 3) instanceof ArrayList) {
            ArrayList exames = (ArrayList)modelo.getValueAt(tabela.getSelectedRow(), 3);
            for (Registro r : exames) {
                this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao")});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonReenviar) {
            ImpressorasLabExterno impressoras = new ImpressorasLabExterno();
            impressoras.setImpressoraAlvaro(ParametrosLocais.getParametro("impressoraWebServiceAlvaro"));
            impressoras.setImpressoraDiagnosticosBrasil(ParametrosLocais.getParametro("impressoraWebServiceDb"));
            impressoras.setImpressoraIndLab("");
            impressoras.setImpressoraJalisWS(ParametrosLocais.getParametro("impressoraJalisWs"));
            impressoras.setImpressoraMercolab(ParametrosLocais.getParametro("impressoraWebServiceMercolab"));
            impressoras.setImpressoraPardini(ParametrosLocais.getParametro("impressoraWebServiceHp"));
            impressoras.setImpressoraRedeWS(ParametrosLocais.getParametro("impressoraWebServiceRede"));
            impressoras.setImpressoraSoftLab(ParametrosLocais.getParametro("impressoraWebServiceSoftLab"));
            impressoras.setImpressoraShift(ParametrosLocais.getParametro("impressoraWebServiceShift"));
            impressoras.setImpressoraMaricondi(ParametrosLocais.getParametro("impressoraWebServiceMaricondi"));
            impressoras.setImpressoraSaoMarcos(ParametrosLocais.getParametro("impressoraWebServiceSm"));
            impressoras.setImpressoraEtqTriagem(ParametrosLocais.getParametro("impressoraEtqTriagem"));
            impressoras.setImpressoraEtqColeta(ParametrosLocais.getParametro("impressoraEtqColeta"));
            impressoras.setImpressoraRelatorio(ParametrosLocais.getParametro("impressoraRelatorio"));
            this.reenviar(this.textLote.getText(), false, ParametrosGerais.getAgruparInterface(), Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), Variaveis.login, ParametrosGerais.isAgruparGuiasInterface(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), ParametrosGerais.getTipoIntegracao(), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), impressoras, ParametrosGerais.getTipoEtiquetaSoroteca(), Variaveis.login);
        } else if (o == this.buttonLote) {
            this.pesquisaLote();
        }
    }

    private void pesquisaLote() {
        boolean retorno;
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        this.labSelecionado = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        Hashtable resultado = Pesquisas.loteExterno(this.getTopLevelAncestor(), this.labSelecionado.codigoLab);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textLote.setText(resultado.get("lex_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void reenviar(String lote, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, String login) {
        try {
            int i;
            ArrayList<Registro> registros = new ArrayList<Registro>();
            for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                if (!(this.modeloRequisicoes.getValueAt(i, 4) instanceof Registro)) continue;
                registros.add((Registro)this.modeloRequisicoes.getValueAt(i, 4));
            }
            for (i = 0; i < this.modeloRequisicoesEnviadas.getRowCount(); ++i) {
                if (!(this.modeloRequisicoesEnviadas.getValueAt(i, 4) instanceof Registro)) continue;
                registros.add((Registro)this.modeloRequisicoesEnviadas.getValueAt(i, 4));
            }
            boolean exportou = this.reenviarLote(lote, (LaboratorioExterno)this.comboLaboratorio.getSelectedItem(), Variaveis.filialPadrao, registros, this.modeloRequisicoes.getColunaOrdenacao(), isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, () -> {
                try {
                    Conexao.arquivaSQL();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, () -> {
                try {
                    Conexao.anulaSQL();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, login).isSucesso();
            if (exportou) {
                Conexao.arquivaSQL();
            } else {
                this.novo();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReenviarLoteExterno (240)");
        }
    }

    private void controlaCampos() {
        this.comboLaboratorio.setEnabled(this.status == 2);
        this.textLote.setEnabled(this.status == 2);
        this.buttonLote.setEnabled(this.status == 2);
    }

    private void controlaBotoesEstorno() {
        this.buttonReenviar.setEnabled(this.status == 2 && this.tableRequisicoes.getRowCount() > 0);
    }

    private void limpaCampos() {
        this.comboLaboratorio.setSelectedItem(null);
        this.labSelecionado = null;
        this.textLote.clear();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.modeloRequisicoesEnviadas.clear();
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        this.controlaBotoesEstorno();
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void buscaDadosLote(int agruparInterface) {
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        if (Funcoes.textoVazio(this.textLote.getText())) {
            ScreenUtil.requisitarFoco(this.textLote);
            return;
        }
        LaboratorioExterno labExterno = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        Statement st = Conexao.getStatement();
        ArrayList<Registro> listaRequisicoes = ReenviarLoteExterno.carregarLote(Long.parseLong(this.textLote.getText()), labExterno, Variaveis.filialPadrao, st, false, agruparInterface);
        if (!listaRequisicoes.isEmpty()) {
            this.lae_codigo = Integer.parseInt(labExterno.codigoLab);
            this.textLote.setEnabled(false);
            this.buttonLote.setEnabled(false);
            for (Registro reg : listaRequisicoes) {
                ArrayList exames = (ArrayList)reg.getValor("listaexames");
                DadosAdicionais dadosAdicionais = FabricaExportador.novoDadosAdicionais(this.labSelecionado.protocolo);
                if (dadosAdicionais != null && !dadosAdicionais.carregaAdicionais(this.labSelecionado.codigoLab, reg)) {
                    return;
                }
                if (reg.getBoolean("enviado") && labExterno.protocolo != Protocolo.Maricondi && labExterno.protocolo != Protocolo.DBV2) {
                    this.modeloRequisicoesEnviadas.addLine(new Object[]{reg.getInt("fil_kodigo"), reg.getString("req_codigo"), reg.getString("pac_nome"), exames, reg});
                    continue;
                }
                this.modeloRequisicoes.addLine(new Object[]{reg.getInt("fil_kodigo"), reg.getString("req_codigo"), reg.getString("pac_nome"), exames, reg});
            }
        } else {
            Funcoes.mensagem(this, "Lote n\u00e3o encontrado", 2);
            this.textLote.clear();
            ScreenUtil.requisitarFoco(this.textLote);
        }
        Conexao.fecharStatement(st);
        this.controlaBotoesEstorno();
    }
}

