/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class LaboratorioExterno {
    public final String codigoLab;
    public final String descricao;
    public String configuracao;
    public final Protocolo protocolo;
    public boolean agruparMultiguias;

    public static LaboratorioExterno construtorTesteUnitario(String codigoLab, String descricao, Protocolo protocolo) {
        return new LaboratorioExterno(codigoLab, descricao, protocolo);
    }

    private LaboratorioExterno(String codigoLab, String descricao, Protocolo protocolo) {
        this.codigoLab = codigoLab;
        this.descricao = descricao;
        this.protocolo = protocolo;
    }

    private LaboratorioExterno(String codigoLab, String protocolo, String descricao, String configuracao) {
        this.codigoLab = codigoLab;
        this.protocolo = Protocolo.getProtocolo(protocolo);
        this.descricao = descricao;
        this.configuracao = configuracao;
    }

    private LaboratorioExterno(String codigoLab, String protocolo, String descricao, String configuracao, boolean agruparMultiguias) {
        this.codigoLab = codigoLab;
        this.protocolo = Protocolo.getProtocolo(protocolo);
        this.descricao = descricao;
        this.configuracao = configuracao;
        this.agruparMultiguias = agruparMultiguias;
    }

    public Protocolo getProtocolo() {
        return this.protocolo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LaboratorioExterno[] getDescricoes(Statement st, boolean fecharStatement) {
        ArrayList<LaboratorioExterno> array = new ArrayList<LaboratorioExterno>();
        String SQL = "";
        if (st == null) return array.toArray(new LaboratorioExterno[array.size()]);
        try {
            StringBuilder bui = new StringBuilder("select \n");
            bui.append("  lae_codigo, lae_protocolo, lae_descricao, lae_configuracao, lae_agruparmultiguias \n");
            bui.append("from labexterno \n");
            bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and (lae_inativo is null or not lae_inativo) ");
            bui.append(" order by lae_descricao ");
            st.setPoolable(true);
            SQL = bui.toString();
            ResultSet res = st.executeQuery(SQL);
            while (res.next()) {
                array.add(new LaboratorioExterno(res.getString("lae_codigo"), res.getString("lae_protocolo"), res.getString("lae_descricao"), res.getString("lae_configuracao"), res.getBoolean("lae_agruparmultiguias")));
            }
            if (!fecharStatement) return array.toArray(new LaboratorioExterno[array.size()]);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CriaLoteExportacao[DescricaoProtocolo]: 320");
                if (!fecharStatement) return array.toArray(new LaboratorioExterno[array.size()]);
            }
            catch (Throwable throwable) {
                if (!fecharStatement) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return array.toArray(new LaboratorioExterno[array.size()]);
        }
        Conexao.fecharStatement(st);
        return array.toArray(new LaboratorioExterno[array.size()]);
    }

    public static LaboratorioExterno getLabExterno(String codigoLab) {
        return LaboratorioExterno.getLabExterno(codigoLab, Conexao.getStatement(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LaboratorioExterno getLabExterno(String codigoLab, Statement st, boolean fecharStatement) {
        block4: {
            LaboratorioExterno laboratorioExterno;
            String SQL = "";
            if (st == null) return null;
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  lae_codigo, lae_protocolo, lae_descricao, lae_configuracao, lae_agruparmultiguias \n");
                bui.append("from labexterno \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append("  and lae_codigo = ").append(codigoLab);
                SQL = bui.toString();
                ResultSet res = st.executeQuery(SQL);
                if (!res.next()) break block4;
                laboratorioExterno = new LaboratorioExterno(res.getString("lae_codigo"), res.getString("lae_protocolo"), res.getString("lae_descricao"), res.getString("lae_configuracao"), res.getBoolean("lae_agruparmultiguias"));
                if (!fecharStatement) return laboratorioExterno;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CriaLoteExportacao[DescricaoProtocolo]: 320");
                    if (!fecharStatement) return null;
                }
                catch (Throwable throwable) {
                    if (!fecharStatement) throw throwable;
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return null;
            }
            Conexao.fecharStatement(st);
            return laboratorioExterno;
        }
        if (!fecharStatement) return null;
        Conexao.fecharStatement(st);
        return null;
    }

    public void salvarConfiguracao(Statement st, boolean isColetaWeb) throws Exception {
        if (st != null) {
            if (this.protocolo == Protocolo.Rede) {
                String config = this.getConfiguracao();
                if (config.contains("ultimaFaixa")) {
                    config = StringUtil.getValor(config, "ultimaFaixa");
                }
                if (!Funcoes.textoVazio(config)) {
                    String tag = StringUtil.getTag("ultimaFaixa", config);
                    StringBuilder buf = new StringBuilder(this.configuracao);
                    String tagFim = "</ultimaFaixa>";
                    int ini = this.configuracao.indexOf("<ultimaFaixa");
                    int fim = this.configuracao.indexOf(tagFim) + tagFim.length();
                    buf.replace(ini, fim, tag);
                    this.configuracao = buf.toString();
                }
            }
            if (isColetaWeb) {
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE labexterno SET lae_configuracao = '");
                sql.append(StringUtil.textoDB(this.configuracao)).append("' WHERE fil_codigo = ");
                sql.append(Variaveis.filialPadrao).append(" and  lae_codigo = ");
                sql.append(this.codigoLab);
                st.executeUpdate(sql.toString());
            } else {
                SalvaDados salvar = new SalvaDados("labexterno", 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("lae_codigo", 2, false, true, this.codigoLab);
                salvar.adicionaCampo("lae_configuracao", 0, true, false, StringUtil.textoDB(this.configuracao));
                String filiasCopiaLabExterno = ParametrosGerais.getCopiaLabExterno();
                if (this.isIgnorarCopiaConfiguracao()) {
                    filiasCopiaLabExterno = StringUtil.getTag("filiais", "");
                }
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", filiasCopiaLabExterno);
            }
        }
    }

    public String toString() {
        return this.descricao;
    }

    public void setConfiguracao(String configuracao) {
        this.configuracao = configuracao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfiguracao() {
        ResultSet rs;
        Statement st;
        block5: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select lae_configuracao from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(this.codigoLab);
            rs = Conexao.executeQuery(st, buf.toString());
            if (!rs.next()) break block5;
            String string = rs.getString("lae_configuracao");
            Conexao.fecharStatement(st);
            return string;
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar as configura\u00e7\u00f5es do laborat\u00f3rio externo.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean agruparMultiguias(Statement st, String filialPadrao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select lae_agruparmultiguias from labexterno where fil_codigo = ").append(filialPadrao);
        sql.append(" and lae_codigo = ").append(this.codigoLab);
        try (ResultSet rs = null;){
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                boolean bl = rs.getBoolean("lae_agruparmultiguias");
                return bl;
            }
        }
        return false;
    }

    private boolean isIgnorarCopiaConfiguracao() throws SQLException {
        String sql = "select lae_ignorarcopiaconfiguracao from labexterno where fil_codigo = ? and lae_codigo = ?";
        PreparedStatement prs = Conexao.getPreparedStatement(sql);
        prs.setInt(1, Integer.valueOf(Variaveis.filialPadrao));
        prs.setInt(2, Integer.valueOf(this.codigoLab));
        ResultSet rs = prs.executeQuery();
        if (rs.next()) {
            return rs.getBoolean("lae_ignorarcopiaconfiguracao");
        }
        return false;
    }
}

