/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.DialogoFiltroRecoleta;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.service.triagem.externo.ImprimirEtiquetasRecoletaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ImprimirEtiquetasRecoleta
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener {
    private static final String TEXTO_FORMULARIO = "Imprimir etiquetas de Recoleta";
    private static final String TEXTO_DESCRICAO = "Impress\u00e3o das etiquetas dos exames marcados como Recoleta pelo laborat\u00f3rio de apoio";
    private static final String ICONE = "triagem/lab_externo_reimprimir_etq_lote.jpg";
    private static final int ALTURA_PADRAO = 20;
    private static final int COLUNA_CHAVE_REQUISICAO = 13;
    private static final String RECOLETA = "R";
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_EXAMES = 3;
    private JComboBox comboLaboratorio = ComponenteFactory.novoJComboBox(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true), this, true, new Dimension(430, 20));
    private TTextField textRequisicao = new TTextField(12, 1);
    private TTextField textFilial = new TTextField(8, 1);
    private JLabel labelLaboratorio = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", 'L', null);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.textFilial);
    private JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", 'R', null, this.textRequisicao);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonImprimirRecoleta = ComponenteFactory.novoJButton("Imprimir recoleta", 'r', this);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Paciente"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private ModeloGridTable modeloOutrosExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableRequisicoes;
    private JTable tableExames;
    private JTable tableOutrosExames;
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JScrollPane scrollOutrosExames = new JScrollPane(this.tableOutrosExames);
    private JPanel panel = new JPanel(new BorderLayout());
    private LaboratorioExterno labSelecionado;
    private final ImprimirEtiquetasRecoletaService service = new ImprimirEtiquetasRecoletaService();
    private String[] filtroExame;
    private String codigoDB = null;
    private String senhaDB = null;
    private String enderecoWS = null;
    private int status = 2;

    public ImprimirEtiquetasRecoleta() {
        this.montaTela();
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0300600600");
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, TEXTO_FORMULARIO, TEXTO_DESCRICAO, ICONE);
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImprimirRecoleta, this.buttonNovo, this.buttonFechar), ComponenteFactory.novoJPanelFlowLayout(0, this.buttonFiltrar)), "South");
        this.add((Component)this.panel, "Center");
        this.construirtabelas();
        this.constuirSplit();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.add((Component)this.panel, "North");
        this.contruirPanelSuperior();
        this.adicionarListener();
        this.comboLaboratorio.setSelectedItem(null);
        this.buttonImprimirRecoleta.setEnabled(false);
        this.textFilial.setText(Variaveis.filialPadrao);
        ScreenUtil.requisitarFoco(this.comboLaboratorio);
    }

    private void construirtabelas() {
        this.tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 50, 70, 0);
        int[] largura = new int[]{50, 30, 0, 30};
        this.tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, largura);
        this.tableOutrosExames = ComponenteFactory.novoJTable((TableModel)this.modeloOutrosExames, largura);
    }

    private void contruirPanelSuperior() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        JPanel painelSuperior = new JPanel(new FlowLayout(0, 1, 1));
        this.panel.add((Component)painelSuperior, gbc);
        painelSuperior.add(this.labelLaboratorio);
        painelSuperior.add(this.comboLaboratorio);
        painelSuperior.add(new JPanel());
        painelSuperior.add(this.labelFilial);
        painelSuperior.add(this.textFilial);
        painelSuperior.add(this.buttonFilial);
        painelSuperior.add(new JPanel());
        painelSuperior.add(this.labelRequisicao);
        painelSuperior.add(this.textRequisicao);
        painelSuperior.add(this.buttonRequisicao);
        int largura = 80;
        this.textFilial.setPreferredSize(new Dimension(largura, 20));
        this.textFilial.setMinimumSize(new Dimension(largura, 20));
        this.textRequisicao.setPreferredSize(new Dimension(largura, 20));
        this.textRequisicao.setMinimumSize(new Dimension(largura, 20));
    }

    private void constuirSplit() {
        JSplitPane splitExames = new JSplitPane(0, ComponenteFactory.novoJPanelBorderLayout("Exames", (Component)new JScrollPane(this.tableExames), null, null, null, null), ComponenteFactory.novoJPanelBorderLayout("Outros Exames", (Component)new JScrollPane(this.tableOutrosExames), null, null, null, null));
        splitExames.setResizeWeight(0.5);
        splitExames.setDividerSize(3);
        splitExames.setBorder(null);
        JSplitPane split = new JSplitPane(1, ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", (Component)new JScrollPane(this.tableRequisicoes), null, null, null, null), splitExames);
        split.setDividerLocation(620);
        split.setDividerSize(3);
        split.setBorder(null);
        this.panel.add((Component)split, "Center");
    }

    private void adicionarListener() {
        this.textRequisicao.addKeyListener(this);
        this.textFilial.addKeyListener(this);
        this.comboLaboratorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirEtiquetasRecoleta.this.buttonFiltrar.setEnabled(ImprimirEtiquetasRecoleta.this.comboLaboratorio.getSelectedItem() != null);
                ScreenUtil.requisitarFoco(ImprimirEtiquetasRecoleta.this.textFilial);
                ImprimirEtiquetasRecoleta.this.controlaCampos();
            }
        });
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ImprimirEtiquetasRecoleta.this.tableRequisicoes.getSelectedRowCount() > 0) {
                    String msn;
                    int[] indices = ImprimirEtiquetasRecoleta.this.tableRequisicoes.getSelectedRows();
                    String string = msn = indices.length == 1 ? "Deseja remover a requisi\u00e7\u00e3o selecionada?" : "Deseja remover as requisi\u00e7\u00f5es selecionadas?";
                    if (Funcoes.mensagem(ImprimirEtiquetasRecoleta.this.tableRequisicoes, msn, 4) == 0) {
                        for (int i = indices.length - 1; i > -1; --i) {
                            ImprimirEtiquetasRecoleta.this.modeloRequisicoes.removeLine(indices[i]);
                        }
                        ImprimirEtiquetasRecoleta.this.atualizarModeloRequisicoes();
                        TableUtil.selecionarLinha(ImprimirEtiquetasRecoleta.this.tableRequisicoes, Math.min(indices[0], ImprimirEtiquetasRecoleta.this.tableRequisicoes.getRowCount() - 1));
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.fechar();
        } else if (o == this.comboLaboratorio) {
            this.validarlaboratorioSelecionado();
        } else if (o == this.buttonFilial) {
            this.pesquisarFilial();
        } else if (o == this.buttonRequisicao) {
            this.pesquisarRequisicao();
        } else if (o == this.buttonFiltrar) {
            this.filtrarRequisicoes();
            this.controlaCampos();
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonImprimirRecoleta) {
            this.imprimirEtiquetasRecoleta();
            this.limpaTela();
        }
    }

    private void filtrarRequisicoes() {
        DialogoFiltroRecoleta dfr = DialogoFiltroRecoleta.novaInstancia(this.getTopLevelAncestor(), this.labSelecionado.codigoLab);
        if (dfr != null) {
            dfr.setVisible(true);
            if (dfr.isOk().booleanValue()) {
                this.filtroExame = dfr.getFiltroExame();
                this.textRequisicao.clear();
                for (Registro reg : dfr.getRequisicoesSelecionados()) {
                    if (!Funcoes.processarFuncaoNumeroTubo(null, this.textRequisicao)) continue;
                    this.adicionarRequisicao(reg.getString("req_codigo"));
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.modeloExames.clear();
        this.modeloOutrosExames.clear();
        if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3) instanceof ArrayList) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3);
            for (Registro r : exames) {
                if (r.getString("exr_situacao").equals(RECOLETA)) {
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao")});
                    continue;
                }
                this.modeloOutrosExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao")});
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textRequisicao && e.getKeyCode() == 10 || e.getKeyChar() == '\t') {
            if (!Funcoes.textoVazio(this.textRequisicao.getText())) {
                this.adicionarRequisicao(this.textRequisicao.getText());
                this.textRequisicao.setText("");
                this.controlaCampos();
            } else {
                ScreenUtil.requisitarFoco(this.textRequisicao);
            }
        } else if (o == this.textRequisicao && e.getKeyCode() == 113) {
            this.pesquisarRequisicao();
        } else if (o == this.textFilial && e.getKeyCode() == 10) {
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        this.atualizarModeloRequisicoes();
    }

    private void imprimirEtiquetasRecoleta() {
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.DBV2)) {
            ArrayList requisicoes = new ArrayList();
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                ArrayList<Registro> requisicoesParaEnviar = new ArrayList<Registro>();
                requisicoes = (ArrayList)this.modeloRequisicoes.getValueAt(i, 3);
                for (Registro req : requisicoes) {
                    if (!req.getString("exr_situacao").equals(RECOLETA) || this.service.validaReimpressaoEtiqueta(req)) continue;
                    requisicoesParaEnviar.add(req);
                }
                if (requisicoesParaEnviar.isEmpty()) continue;
                this.service.imprimirEtiquetasDB(this.labSelecionado, requisicoesParaEnviar);
            }
        }
    }

    private void validarlaboratorioSelecionado() {
        String conf;
        this.labSelecionado = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        if (!(this.labSelecionado == null || (conf = StringUtil.getValor(this.labSelecionado.configuracao, "enviarLoteWebservice")).equalsIgnoreCase("true") && this.labSelecionado.protocolo.equals((Object)Protocolo.DBV2))) {
            Funcoes.mensagem(this, "O Laborat\u00f3rio de apoio selecionado, n\u00e3o disponibiliza o processo de solicita\u00e7\u00e3o\n de impress\u00e3o de etiquetas de Recoleta", 2);
            this.comboLaboratorio.setSelectedItem(null);
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
        }
    }

    private void pesquisarFilial() {
        Hashtable filialSelecionada = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (filialSelecionada != null) {
            this.textFilial.setText(filialSelecionada.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void pesquisarRequisicao() {
        Hashtable requisicaoSelecionada = Pesquisas.requisicao(this.getTopLevelAncestor(), this.getCodFilial(), false, false, false);
        if (requisicaoSelecionada != null) {
            this.adicionarRequisicao(requisicaoSelecionada.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private void adicionarRequisicao(String codRequisicao) {
        if (this.requisicaoValida(codRequisicao)) {
            ArrayList<Registro> registro = this.service.buscaDadosRequisicao(this.getCodFilial(), codRequisicao);
            for (Registro r : registro) {
                ArrayList<Registro> exames = this.service.getExamesRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), this.labSelecionado.codigoLab);
                if (exames.isEmpty()) continue;
                this.modeloRequisicoes.addLine(new Object[]{r.getInt("fil_codigo"), r.getInt("req_codigo"), r.getString("pac_nome"), exames});
            }
        }
    }

    private boolean requisicaoValida(String codRequisicao) {
        if (this.modeloRequisicoes.localizar(1, codRequisicao) >= 0) {
            Funcoes.mensagem(this, String.format("A requisi\u00e7\u00e3o \"%s\" j\u00e1 foi adicionada.", codRequisicao), 2);
            return false;
        }
        HashMap<String, Boolean> requisicaoValida = this.service.validarRequisicao(this.getCodFilial(), codRequisicao, this.labSelecionado.codigoLab);
        for (Map.Entry<String, Boolean> requisicao : requisicaoValida.entrySet()) {
            if (requisicao.getValue().booleanValue()) continue;
            Funcoes.mensagem(this, requisicao.getKey(), 2);
            this.textRequisicao.setText("");
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        return true;
    }

    private String getCodFilial() {
        return Funcoes.textoVazio(this.textFilial.getText()) ? Variaveis.filialPadrao : this.textFilial.getText();
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.comboLaboratorio);
    }

    private void fechar() {
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
        this.setVisible(false);
    }

    private void controlaCampos() {
        this.comboLaboratorio.setEnabled(this.status == 2);
        this.textFilial.setEnabled(this.comboLaboratorio.getSelectedItem() != null);
        this.textRequisicao.setEnabled(this.comboLaboratorio.getSelectedItem() != null);
        this.buttonImprimirRecoleta.setEnabled(this.tableRequisicoes.getRowCount() > 0);
        this.buttonFilial.setEnabled(this.comboLaboratorio.getSelectedItem() != null);
        this.buttonRequisicao.setEnabled(this.comboLaboratorio.getSelectedItem() != null);
    }

    private void limpaCampos() {
        this.comboLaboratorio.setSelectedItem(null);
        this.textRequisicao.setText("");
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.modeloOutrosExames.clear();
    }

    private void limpaTela() {
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.modeloOutrosExames.clear();
        this.textRequisicao.setText("");
        this.textRequisicao.grabFocus();
        this.buttonImprimirRecoleta.setEnabled(false);
    }

    private void atualizarModeloRequisicoes() {
        this.modeloRequisicoes.fireTableDataChanged();
        this.buttonNovo.setEnabled(this.modeloRequisicoes.getRowCount() > 0);
    }
}

