/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.util.Funcoes;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExclusaoLoteAlvoroWebService {
    private String idagente = "";
    private String lis = "";
    private String operador = "";
    private String senha = "";
    private String codigo = "";
    private Map<String, Set<String>> exames = new HashMap<String, Set<String>>();

    public ExclusaoLoteAlvoroWebService(String idagente, String lis, String operador, String senha, String codigo) {
        this.idagente = idagente;
        this.lis = lis;
        this.operador = operador;
        this.senha = senha;
        this.codigo = codigo;
    }

    public void addExame(String idAlvaro, String codigoExame) {
        if (this.exames.containsKey(idAlvaro)) {
            this.exames.get(idAlvaro).add(codigoExame);
        } else {
            HashSet<String> exame = new HashSet<String>();
            exame.add(codigoExame);
            this.exames.put(idAlvaro, exame);
        }
    }

    public String xmlExclusao() {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<exclusoes idagente=\"").append(this.idagente).append("\"").append(" ");
        xml.append("lis=\"").append(this.lis).append("\"").append(" ");
        xml.append("datahora=\"").append(this.geraDataHora()).append("\"").append(" ");
        xml.append("operador=\"").append(this.operador).append("\"").append(" ");
        xml.append("senha=\"").append(this.senha).append("\"").append(">\n ");
        xml.append("<entidade codigo=\"").append(this.codigo).append("\"").append("> \n");
        for (String solicitacao : this.exames.keySet()) {
            xml.append("<solicitacao  idAlvaro=\"").append(solicitacao).append("\">\n");
            for (String exame : this.exames.get(solicitacao)) {
                xml.append("<exame codigoExame=\"").append(exame).append("\" />").append("\n");
            }
            xml.append("</solicitacao>");
        }
        xml.append("</entidade>");
        xml.append("</exclusoes>");
        return xml.toString();
    }

    private String geraDataHora() {
        Date dataAtual = Calendar.getInstance().getTime();
        String data = Funcoes.formataData("yyyy-MM-dd", dataAtual);
        String hora = Funcoes.formataData("HH:mm:ss", dataAtual);
        return data + "T" + hora;
    }
}

