/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RenderRequisicoes;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class EstornoLoteExportacao
extends IntegracaoLabExterno
implements ListSelectionListener,
ActionListener {
    private static final long ACESSO = Long.parseLong("0300600200");
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_ENVIADO = 3;
    private final int COLUNA_EXAMES = 4;
    private final int COLUNA_OBJETO_REQUISICAO = 5;
    private final int COLUNA_EXAME_CHECKBOX = 3;
    private final int COLUNA_EXAME_OBJETO = 4;
    private static final String EXAME_SELECIONADO = "exameSelecionado";
    private static final String MENSAGEM_CONFIRMA_ESTORNAR_TODOS = "O lote ser\u00e1 exclu\u00eddo, confirma o estorno das requisi\u00e7\u00f5es?";
    private static final String MENSAGEM_CONFIRMA_ESTORNAR_REQUISICAO = "O lote possui apenas uma requisi\u00e7\u00e3o, o estorno remover\u00e1 o lote por completo.\nConfirma o estorno?";
    private static final String MENSAGEM_ESTORNAR_REQUISICAO = "O estorno desmarcar\u00e1  o paciente enviado ao laborat\u00f3rio de apoio para um novo envio,\nse deseja apenas reenviar o lote, utilize a op\u00e7\u00e3o Reenvio de Lote.\nDeseja continuar o estorno?";
    private static final String MENSAGEM_ESTORNAR_TODOS = "O estorno desmarcar\u00e1 todos os pacientes enviados ao laborat\u00f3rio de apoio para um novo envio,\nse deseja apenas reenviar o lote, utilize a op\u00e7\u00e3o Reenvio de Lote.\nDeseja continuar o estorno?";
    private static final String MENSAGEM_ESTORNAR_EXAMES_SELCIONADOS = "O estorno desmarcar\u00e1 os pacientes das requisi\u00e7\u00f5es %s enviadas ao laborat\u00f3rio de apoio para um novo envio, se deseja apenas reenviar o lote, utilize a op\u00e7\u00e3o Reenvio de Lote.\nDeseja continuar o estorno?";
    private static final String MENSAGEM_ESTORNO_SOMENTE_JALIS = "O estorno do lote s\u00f3 ocorrer\u00e1 no Sistema Jalis. Tem certeza que deseja estornar?";
    private static final String MENSAGEM_SUCESSO_INDLAB = "Requisi\u00e7\u00f5es estornadas com sucesso!";
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelBotoesRequisicao = new JPanel(new FlowLayout(2));
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Paciente"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 30, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", ""}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 3 ? Boolean.class : super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }
    };
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonEstornarTodos = ComponenteFactory.novoJButton("Estornar todos", 't', this);
    private JButton buttonEstornarRequisicao = ComponenteFactory.novoJButton("Estornar", 'r', this);
    private JButton buttonEstornarExame = ComponenteFactory.novoJButton("Estornar Selecionado", 'r', this);
    private JButton buttonEstornarExamesSelecionados = ComponenteFactory.novoJButton("Estornar", 'o', this);
    private JComboBox comboLaboratorio = ComponenteFactory.novoJComboBox(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true), this, true, new Dimension(400, 20));
    private JLabel labelCombo = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", 'L', null, this.comboLaboratorio);
    private TTextField textLote = new TTextField(10, 1);
    private JButton buttonLote = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JLabel labelLote = ComponenteFactory.novoJLabel("   Lote:", 't', null, this.textLote);
    private LaboratorioExterno labSelecionado;
    int status = 1;

    public EstornoLoteExportacao() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Estornar lote", "Estorno de lotes enviados para laborat\u00f3rios de apoio", "triagem/lab_externo_estornar_lote.jpg");
        this.textLote.setPreferredSize(new Dimension(80, 20));
        this.textLote.setMinimumSize(new Dimension(80, 20));
        this.tableRequisicoes.setDefaultRenderer(Object.class, new RenderRequisicoes(3));
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        this.buttonLote.setFocusable(false);
        this.panelBotoesRequisicao.add(this.buttonEstornarTodos);
        this.panelBotoesRequisicao.add(this.buttonEstornarRequisicao);
        JPanel panelReq = new JPanel(new BorderLayout());
        JPanel panelExm = new JPanel(new BorderLayout());
        panelReq.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        panelExm.setBorder(new TitledBorder("Exames"));
        panelReq.add((Component)this.scrollRequisicoes, "Center");
        panelReq.add((Component)this.panelBotoesRequisicao, "South");
        panelExm.add((Component)this.scrollExames, "Center");
        JPanel panelButton = new JPanel(new FlowLayout(2));
        this.buttonEstornarExame.setVisible(false);
        this.buttonEstornarExame.setEnabled(false);
        panelButton.add(this.buttonEstornarExame);
        this.buttonEstornarExamesSelecionados.setVisible(false);
        this.buttonEstornarExamesSelecionados.setEnabled(false);
        panelButton.add(this.buttonEstornarExamesSelecionados);
        panelExm.add((Component)panelButton, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        JPanel p = new JPanel(new FlowLayout(0, 1, 1));
        p.setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
        this.panelCentro.add((Component)p, c);
        p.add(this.labelCombo);
        p.add(this.comboLaboratorio);
        p.add(this.labelLote);
        p.add(this.textLote);
        p.add(this.buttonLote);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        this.panelCentro.add((Component)panelReq, c);
        c.gridx = 1;
        this.panelCentro.add((Component)panelExm, c);
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.textLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    EstornoLoteExportacao.this.buscaDadosLote(ParametrosGerais.getAgruparInterface());
                } else if (e.getKeyCode() == 113) {
                    EstornoLoteExportacao.this.pesquisaLote();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EstornoLoteExportacao.this.novo();
            }
        });
        this.comboLaboratorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstornoLoteExportacao.this.labSelecionado = (LaboratorioExterno)EstornoLoteExportacao.this.comboLaboratorio.getSelectedItem();
                EstornoLoteExportacao.this.alterarGridExamesPorProtocolo();
                if (EstornoLoteExportacao.this.labSelecionado != null) {
                    EstornoLoteExportacao.this.buttonEstornarExame.setVisible(((EstornoLoteExportacao)EstornoLoteExportacao.this).labSelecionado.protocolo.equals((Object)Protocolo.Jalis));
                    EstornoLoteExportacao.this.buttonEstornarExamesSelecionados.setVisible(((EstornoLoteExportacao)EstornoLoteExportacao.this).labSelecionado.protocolo.permiteEstornoPorExame());
                }
                EstornoLoteExportacao.this.comboLaboratorio.setEnabled(false);
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EstornoLoteExportacao.this.tableExameChanged();
            }
        });
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EstornoLoteExportacao.this.selecionarTodosNaMultiguia();
                EstornoLoteExportacao.this.tableExameChanged();
            }
        });
    }

    private void tableExameChanged() {
        if (this.tableExames.getSelectedRow() >= 0) {
            for (int linhaExa = 0; linhaExa < this.modeloExames.getRowCount(); ++linhaExa) {
                boolean exameSelecionado = (Boolean)this.modeloExames.getValueAt(linhaExa, 3);
                Registro r = (Registro)this.modeloExames.getValueAt(linhaExa, 4);
                r.setValor(EXAME_SELECIONADO, exameSelecionado);
            }
            this.controlaBotoesEstorno();
        }
    }

    private void selecionarTodosNaMultiguia() {
        if (this.agrupaMultiguias()) {
            Registro requisicao = (Registro)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 5);
            try {
                Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(requisicao.getString("fil_kodigo"), requisicao.getString("req_codigo"), true);
                if (multiguias != null && multiguias.length > 1) {
                    Registro exame = (Registro)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 4);
                    List<Integer> guias = Arrays.asList(multiguias);
                    for (int linhaReq = 0; linhaReq < this.modeloRequisicoes.getRowCount(); ++linhaReq) {
                        Registro req = (Registro)this.modeloRequisicoes.getValueAt(linhaReq, 5);
                        if (!guias.contains(req.getInt("req_codigo"))) continue;
                        List exames = (List)req.getValor("listaexames");
                        for (Registro exa : exames) {
                            if (!exa.getString("exa_codigo").equals(exame.getString("exa_codigo")) || exa.getInt("mco_codigo") != exame.getInt("mco_codigo")) continue;
                            exa.setValor(EXAME_SELECIONADO, exame.getBoolean(EXAME_SELECIONADO));
                        }
                    }
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "N\u00e3o foi poss\u00edvel selecionar o exame em todas as guias.");
            }
        }
    }

    private void alterarGridExamesPorProtocolo() {
        int tamColCod = 50;
        int tamColMat = 40;
        int tamColDescExame = 0;
        if (this.labSelecionado != null && this.labSelecionado.protocolo.permiteEstornoPorExame()) {
            String[] nomeColunas = new String[]{"C\u00f3d.", "Mat.", "Exame", ""};
            int[] tamanhoColunas = new int[]{tamColCod, tamColMat, tamColDescExame, 20};
            this.modeloExames.setColumnName(nomeColunas);
            this.modeloExames.setColumnSize(tamanhoColunas, this.tableExames);
        } else {
            String[] nomeColunas = new String[]{"C\u00f3d.", "Mat.", "Exame"};
            int[] tamanhoColunas = new int[]{tamColCod, tamColMat, tamColDescExame};
            this.modeloExames.setColumnName(nomeColunas);
            this.modeloExames.setColumnSize(tamanhoColunas, this.tableExames);
        }
        this.tableExames.revalidate();
        this.tableExames.repaint();
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.modeloExames.clear();
        if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4) instanceof ArrayList) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4);
            exames.forEach(r -> this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getBoolean(EXAME_SELECIONADO), r}));
            this.controlaBotoesEstorno();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonEstornarRequisicao) {
            this.estornarRequisicao();
        } else if (o == this.buttonEstornarTodos) {
            this.estornarTodos();
        } else if (o == this.buttonLote) {
            this.pesquisaLote();
        } else if (o == this.buttonEstornarExame) {
            this.estornarExames(false);
        } else if (o == this.buttonEstornarExamesSelecionados) {
            this.estornarExamesSelecionados();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estornarExamesSelecionados() {
        block12: {
            int linha = this.tableRequisicoes.getSelectedRow();
            if (linha <= -1) break block12;
            HashMap<String, Integer> examesSelecionadosPorRequisicao = this.getExamesSelecionadosPorRequisicao();
            int requisicoesSelecionadas = 0;
            ArrayList<String> codRequisicoesEstornar = new ArrayList<String>();
            for (int req = 0; req < this.modeloRequisicoes.getRowCount(); ++req) {
                Registro requisicao = (Registro)this.modeloRequisicoes.getValueAt(req, 5);
                List exames = (List)requisicao.getValor("listaexames");
                String codRequisicao = requisicao.getString("req_codigo");
                for (Map.Entry<String, Integer> reqSel : examesSelecionadosPorRequisicao.entrySet()) {
                    if (!codRequisicao.equals(reqSel.getKey()) || exames.size() != reqSel.getValue().intValue()) continue;
                    codRequisicoesEstornar.add(codRequisicao);
                    ++requisicoesSelecionadas;
                }
            }
            if (requisicoesSelecionadas == this.modeloRequisicoes.getRowCount()) {
                this.estornarTodos();
                return;
            }
            if (this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab) && Funcoes.mensagem(this, MENSAGEM_ESTORNO_SOMENTE_JALIS, 4) == 1) {
                return;
            }
            if (!codRequisicoesEstornar.isEmpty()) {
                StringBuilder mensagem = new StringBuilder();
                codRequisicoesEstornar.forEach(rpe -> mensagem.append((String)rpe).append(", "));
                mensagem.replace(mensagem.length() - 2, mensagem.length(), "");
                if (Funcoes.mensagem(this, String.format(MENSAGEM_ESTORNAR_EXAMES_SELCIONADOS, mensagem), 4) == 1) {
                    return;
                }
            }
            ArrayList<Registro> requisicoes = new ArrayList<Registro>();
            for (int linhaReq = 0; linhaReq < this.modeloRequisicoes.getRowCount(); ++linhaReq) {
                Registro req = (Registro)this.modeloRequisicoes.getValueAt(linhaReq, 5);
                ArrayList examesSelecionados = new ArrayList();
                List examesRequisicao = (List)req.getValor("listaexames");
                examesRequisicao.forEach(exame -> {
                    if (exame.getBoolean(EXAME_SELECIONADO)) {
                        examesSelecionados.add(exame.clone());
                    }
                });
                if (examesSelecionados.isEmpty()) continue;
                if (examesSelecionados.size() == examesRequisicao.size()) {
                    this.modeloRequisicoes.removeLine(linhaReq);
                }
                Registro r = req.clone();
                r.setValor("listaexames", examesSelecionados);
                requisicoes.add(r);
            }
            Statement st = Conexao.getStatement();
            try {
                this.estornarExames(st, requisicoes, this.agrupaMultiguias(), false, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, ParametrosGerais.getAgruparInterface(), Variaveis.login);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    this.anularSQL(ex);
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            this.atualizarTelaAposEstorno();
        }
    }

    private HashMap<String, Integer> getExamesSelecionadosPorRequisicao() {
        HashMap<String, Integer> examesSelecionadosPorRequisicao = new HashMap<String, Integer>();
        for (int req = 0; req < this.modeloRequisicoes.getRowCount(); ++req) {
            Registro requisicao = (Registro)this.modeloRequisicoes.getValueAt(req, 5);
            List exames = (List)requisicao.getValor("listaexames");
            int examesSelecionados = 0;
            for (Registro exa : exames) {
                if (!exa.getBoolean(EXAME_SELECIONADO)) continue;
                ++examesSelecionados;
            }
            examesSelecionadosPorRequisicao.put(requisicao.getString("req_codigo"), examesSelecionados);
        }
        return examesSelecionadosPorRequisicao;
    }

    private void estornarExames(boolean isColetaWeb) {
        Registro req = (Registro)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 5);
        try {
            int[] listaExames;
            ArrayList<Registro> exames = new ArrayList<Registro>();
            for (int i : listaExames = this.tableExames.getSelectedRows()) {
                String codExame = (String)this.modeloExames.getValueAt(i, 0);
                List lista = (List)req.getValor("listaexames");
                for (Registro registro : lista) {
                    if (!codExame.equals(registro.getString("exa_codigo"))) continue;
                    exames.add(registro);
                    this.modeloExames.removeLine(i);
                }
            }
            if (!exames.isEmpty()) {
                EstornoLoteExportacao.excluirRequisicaoJalis(this.labSelecionado.codigoLab, Conexao.getStatement(), this.textLote.getText(), req, false, false, false, exames, Variaveis.filialPadrao, req.getString("req_codigo"), isColetaWeb, () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, ParametrosGerais.getAgruparInterface());
            }
            this.atualizarTelaAposEstorno();
            Statement st = Conexao.getStatement();
            boolean agruparMultiguia = EstornoLoteExportacao.agruparMultiguia(req.getString("fil_codigo"), req.getString("req_codigo"), st, ParametrosGerais.isAgruparGuiasInterface());
            Conexao.fecharStatement(st);
            if (agruparMultiguia && this.labSelecionado.getProtocolo().isAlertaReemiteEtiquetas()) {
                Funcoes.showAlertaOK(Laboratorio.getInstancia(), "Etiquetas para multiguia agrupada e estornada n\u00e3o foi regerada. Desconsidere o exame da requisi\u00e7\u00e3o estornada.");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "N\u00e3o foi poss\u00edvel estornar exames da requisi\u00e7\u00e3o do lote.");
        }
    }

    private void atualizarTelaAposEstorno() {
        if (!Funcoes.textoVazio(this.textLote.getText()) && this.modeloRequisicoes.getRowCount() >= 1) {
            this.modeloRequisicoes.clear();
            this.buscaDadosLote(ParametrosGerais.getAgruparInterface());
        } else if (this.modeloExames.getRowCount() == 0) {
            this.novo();
        }
        this.tableExames.clearSelection();
    }

    private void pesquisaLote() {
        boolean retorno;
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        this.labSelecionado = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        Hashtable resultado = Pesquisas.loteExterno(this.getTopLevelAncestor(), this.labSelecionado.codigoLab);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textLote.setText(resultado.get("lex_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private int contaLaboratoriosExternos(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder("select count(lae_codigo) as contagem ");
        buf.append("from labexterno ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(st, buf);
        return rs.next() ? rs.getInt("contagem") : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estornarRequisicao() {
        int linha = this.tableRequisicoes.getSelectedRow();
        if (linha < 0) {
            return;
        }
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab) && Funcoes.mensagem(this, MENSAGEM_ESTORNO_SOMENTE_JALIS, 4) == 1) {
            return;
        }
        if (this.tableRequisicoes.getRowCount() == 1 && Funcoes.mensagem(this, MENSAGEM_CONFIRMA_ESTORNAR_REQUISICAO, 4) == 1) {
            return;
        }
        Statement st = Conexao.getStatement();
        try {
            boolean respostaPergunta;
            int contagem = this.contaLaboratoriosExternos(st);
            boolean bl = respostaPergunta = Funcoes.mensagem(this.getTopLevelAncestor(), MENSAGEM_ESTORNAR_REQUISICAO, 4) == 0;
            if ((contagem == 1 || contagem > 1 && respostaPergunta) && this.tableRequisicoes.getRowCount() >= 1) {
                this.estornar(linha, st, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, ParametrosGerais.getAgruparInterface());
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.anularSQL(ex);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estornarTodos() {
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab) && Funcoes.mensagem(this, MENSAGEM_ESTORNO_SOMENTE_JALIS, 4) == 1) {
            return;
        }
        if (Funcoes.mensagem(this, MENSAGEM_CONFIRMA_ESTORNAR_TODOS, 4) == 1) {
            return;
        }
        Statement st = Conexao.getStatement();
        try {
            boolean respostaPergunta;
            int contagem = this.contaLaboratoriosExternos(st);
            boolean bl = respostaPergunta = Funcoes.mensagem(this.getTopLevelAncestor(), MENSAGEM_ESTORNAR_TODOS, 4) == 0;
            if (contagem == 1 || contagem > 1 && respostaPergunta) {
                this.estornar(-1, st, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, ParametrosGerais.getAgruparInterface());
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.anularSQL(ex);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void anularSQL(Exception ex) {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
    }

    private void exibirMensagemSucessoIndLab() {
        if (this.labSelecionado != null && this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab)) {
            Funcoes.mensagem(this, MENSAGEM_SUCESSO_INDLAB, 5);
        }
    }

    private void estornar(int linha, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface) throws NumberFormatException, Exception {
        Integer resposta;
        LaboratorioExterno lab = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
        if (this.labSelecionado.protocolo == Protocolo.Alvaro && !this.isLabAlvaroWebService()) {
            Funcoes.mensagem(this, "O estorno deste lote ser\u00e1 realizado apenas no sistema, \npara concluir o processo de estorno, entrar em contato com o Apoio.", 2);
        }
        if (this.labSelecionado.protocolo == Protocolo.SaoMarcos && (resposta = Integer.valueOf(Funcoes.mensagem(Laboratorio.getInstancia(), "J\u00e1 solicitou o Cancelamento do Lote/Requisi\u00e7\u00e3o no Laborat\u00f3rio S\u00e3o Marcos? O lote s\u00f3 deve ser estornado, ap\u00f3s cancelamento no S\u00e3o Marcos, pois esse processo no sistema Jalis, n\u00e3o poder\u00e1 mais ser revertido. Confirma o estorno?", 4))) == 1) {
            return;
        }
        boolean agruparMultiguia = false;
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        boolean temAlertaReenviarEtiqueta = this.labSelecionado.protocolo.isAlertaReemiteEtiquetas();
        if (this.isRequisicaoSelecionada(linha)) {
            Registro req = (Registro)this.modeloRequisicoes.getValueAt(linha, 5);
            agruparMultiguia = EstornoLoteExportacao.agruparMultiguia(req.getString("fil_codigo"), req.getString("req_codigo"), st, ParametrosGerais.isAgruparGuiasInterface());
            if (!agruparMultiguia) {
                requisicoes.add(req.clone());
            }
            if (agruparMultiguia) {
                Integer[] multiguias;
                for (Integer multiguia : multiguias = RecepcaoUtil.verificaMultiGuias(req.getString("fil_codigo"), req.getString("req_codigo"), true)) {
                    for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                        String reqCodigo = (String)this.modeloRequisicoes.getValueAt(i, 1);
                        if (!reqCodigo.equals(multiguia.toString())) continue;
                        Registro guia = (Registro)this.modeloRequisicoes.getValueAt(i, 5);
                        requisicoes.add(guia);
                        this.modeloRequisicoes.removeLine(i);
                    }
                }
            } else {
                this.modeloRequisicoes.removeLine(linha);
            }
            this.estornarExames(st, requisicoes, agruparMultiguia, false, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, Variaveis.login);
        } else {
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                Registro req = (Registro)this.modeloRequisicoes.getValueAt(i, 5);
                agruparMultiguia = EstornoLoteExportacao.agruparMultiguia(req.getString("fil_codigo"), req.getString("req_codigo"), st, ParametrosGerais.isAgruparGuiasInterface());
                requisicoes.add(req.clone());
            }
            List<Registro> requisicoesWSTodos = this.validaMultiguiaTodos(requisicoes, this.modeloRequisicoes);
            this.estornarExames(st, requisicoesWSTodos, agruparMultiguia, false, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, Variaveis.login);
        }
        if (this.estornouTodos(linha)) {
            this.novo();
        }
        if (agruparMultiguia && temAlertaReenviarEtiqueta) {
            Funcoes.showAlertaOK(Laboratorio.getInstancia(), "Etiquetas para multiguia agrupada e estornada n\u00e3o foi gerada novamente. Desconsidere o exame da requisi\u00e7\u00e3o estornada.");
        }
    }

    private void estornarExames(Statement st, List<Registro> requisicoes, boolean agruparMultiguia, boolean isColetaWeb, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, String login) throws Exception {
        if (this.contemRequisicoes(requisicoes)) {
            Exportador exportador = FabricaExportador.novoExportador(this.labSelecionado.protocolo);
            exportador.estornarExames(this.labSelecionado.codigoLab, requisicoes, this.textLote.getText(), isColetaWeb, st, arquivar, anular, agruparInterface, this.labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
        }
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab)) {
            this.exibirMensagemSucessoIndLab();
        }
        this.atualizarTelaAposEstorno();
    }

    private boolean contemRequisicoes(List<Registro> requisicoes) {
        return requisicoes != null && !requisicoes.isEmpty();
    }

    private boolean isLabAlvaroWebService() {
        boolean isLabAlvaroWS = false;
        String enviarWebService = StringUtil.getValor(this.labSelecionado.configuracao, "enviarLoteWebService");
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.Alvaro) && Boolean.valueOf(enviarWebService).booleanValue()) {
            Registro req = (Registro)this.modeloRequisicoes.getValueAt(0, 5);
            StringBuilder buf = new StringBuilder();
            buf.append(" select leq_codigoreqapoio from loteexternorequisicao ");
            buf.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
            buf.append(" and lae_codigo = ").append(this.labSelecionado.codigoLab);
            buf.append(" and lex_codigo = ").append(this.textLote.getText());
            buf.append(" and req_codigo = ").append(req.getString("req_codigo"));
            try {
                Statement st = Conexao.getStatement();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    isLabAlvaroWS = rs.getString("leq_codigoreqapoio") != null;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return isLabAlvaroWS;
    }

    private List<Registro> validaMultiguiaTodos(List<Registro> requisicoesWS, ModeloGridTable modeloRequisicoes) throws Exception {
        Boolean isMultiguia = false;
        ArrayList<String> listaExames = new ArrayList<String>();
        ArrayList<Integer> listaMateriais = new ArrayList<Integer>();
        ArrayList listaExamesReqSelecionado = new ArrayList();
        ArrayList novaListaRequisicoesWS = new ArrayList();
        ArrayList<Registro> novaRequisicoesWS = new ArrayList<Registro>();
        Statement st2 = Conexao.getStatement();
        novaListaRequisicoesWS = (ArrayList)EstornoLoteExportacao.agruparMutiguia(requisicoesWS, st2, ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getDigitosTuboFilial());
        Conexao.fecharStatement(st2);
        Integer filial = null;
        Integer req = null;
        Integer codigoLab = null;
        for (Registro r : novaListaRequisicoesWS) {
            filial = Integer.valueOf(r.getString("fil_codigo"));
            req = Integer.valueOf(r.getString("req_codigo"));
            codigoLab = Integer.valueOf(r.getString("lae_codigo"));
            listaExamesReqSelecionado = (ArrayList)r.getValor("listaexames");
            for (Registro er : listaExamesReqSelecionado) {
                listaExames.add(er.getString("exa_codigo"));
                listaMateriais.add(Integer.valueOf(er.getString("mco_codigo")));
            }
            Integer[] multiguias = null;
            multiguias = RecepcaoUtil.verificaMultiGuias(filial.toString(), req.toString(), true);
            if (this.existeMultiguia(multiguias)) {
                isMultiguia = true;
            }
            Registro registroNovo = null;
            registroNovo = r;
            ArrayList<Registro> listaTodosExames = new ArrayList<Registro>();
            for (int i = 0; i < modeloRequisicoes.getRowCount(); ++i) {
                String rec = modeloRequisicoes.getValueAt(i, 1).toString();
                if (multiguias == null || !this.contemMultiguia(rec, multiguias)) continue;
                Registro reg = (Registro)modeloRequisicoes.getValueAt(i, 5);
                List listaExameAux = (List)reg.getValor("listaexames");
                for (Registro exa : listaExameAux) {
                    listaTodosExames.add(exa);
                }
            }
            requisicoesWS.clear();
            registroNovo.setValor("listaexames", listaTodosExames);
            novaRequisicoesWS.add(registroNovo);
        }
        return novaRequisicoesWS;
    }

    private boolean isRequisicaoSelecionada(int linha) {
        return linha > -1;
    }

    private boolean estornouTodos(int linha) {
        return this.modeloRequisicoes.getRowCount() == 0 || linha == -1;
    }

    private boolean contemMultiguia(String rec, Integer[] multiguias) {
        for (int i = 0; i < multiguias.length; ++i) {
            if (!rec.contentEquals(multiguias[i].toString())) continue;
            return true;
        }
        return false;
    }

    private boolean existeMultiguia(Integer[] multiguias) {
        return multiguias != null && multiguias.length > 0;
    }

    private void controlaCampos() {
        this.comboLaboratorio.setEnabled(this.status == 2);
        this.textLote.setEnabled(this.status == 2);
        this.buttonLote.setEnabled(this.status == 2);
    }

    private void controlaBotoesEstorno() {
        boolean habilitaBotaoEstornarExamesSelecionados = false;
        for (int req = 0; req < this.modeloRequisicoes.getRowCount(); ++req) {
            List exames = (List)this.modeloRequisicoes.getValueAt(req, 4);
            for (Registro exame : exames) {
                boolean exameSelecionado = exame.getBoolean(EXAME_SELECIONADO);
                if (!exameSelecionado) continue;
                habilitaBotaoEstornarExamesSelecionados = true;
            }
        }
        this.buttonEstornarRequisicao.setEnabled(!habilitaBotaoEstornarExamesSelecionados && this.tableRequisicoes.getSelectedRow() > -1);
        this.buttonEstornarTodos.setEnabled(this.modeloRequisicoes.getRowCount() > 0);
        this.buttonEstornarExame.setEnabled(this.labSelecionado != null && this.labSelecionado.protocolo.equals((Object)Protocolo.Jalis));
        this.buttonEstornarExamesSelecionados.setEnabled(this.labSelecionado != null && (this.labSelecionado.protocolo.equals((Object)Protocolo.INDLab) || this.labSelecionado.protocolo.equals((Object)Protocolo.MercolabWS)) && habilitaBotaoEstornarExamesSelecionados);
    }

    private void limpaCampos() {
        this.comboLaboratorio.setSelectedItem(null);
        this.labSelecionado = null;
        this.textLote.clear();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        this.controlaBotoesEstorno();
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void buscaDadosLote(int agruparInterface) {
        if (this.comboLaboratorio.getSelectedItem() == null) {
            ScreenUtil.requisitarFoco(this.comboLaboratorio);
            return;
        }
        if (Funcoes.textoVazio(this.textLote.getText())) {
            ScreenUtil.requisitarFoco(this.textLote);
            return;
        }
        Statement st = Conexao.getStatement();
        ArrayList<Registro> listaRequisicoes = EstornoLoteExportacao.carregarLote(Long.parseLong(this.textLote.getText()), (LaboratorioExterno)this.comboLaboratorio.getSelectedItem(), Variaveis.filialPadrao, st, true, agruparInterface);
        if (!listaRequisicoes.isEmpty()) {
            this.textLote.setEnabled(false);
            this.buttonLote.setEnabled(false);
            for (Registro reg : listaRequisicoes) {
                ArrayList exames = (ArrayList)reg.getValor("listaexames");
                exames.forEach(exa -> exa.setValor(EXAME_SELECIONADO, Boolean.FALSE));
                this.modeloRequisicoes.addLine(new Object[]{reg.getString("fil_kodigo"), reg.getString("req_codigo"), reg.getString("pac_nome"), reg.getBoolean("enviado"), exames, reg});
            }
            this.controlaBotoesEstorno();
        } else {
            Funcoes.mensagem(this, "Lote n\u00e3o encontrado", 2);
            this.textLote.clear();
            ScreenUtil.requisitarFoco(this.textLote);
        }
        Conexao.fecharStatement(st);
    }

    private boolean agrupaMultiguias() {
        return ParametrosGerais.isAgruparGuiasInterface() || this.labSelecionado.agruparMultiguias;
    }
}

