/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.model.vo.triagem.externo.DialogoFiltroRecoletaVO;
import jalis.service.triagem.externo.DialogoFiltroRecoletaService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ManualFocusPolicy;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class DialogoFiltroRecoleta
extends JDialog
implements ActionListener {
    public static final String TIPO_DATA_REQUISICAO = "Requisi\u00e7\u00e3o";
    public static final String TIPO_DATA_RECOLETA = "Recoleta";
    private static final String ULTIMO_FILTRO = "DialogoFiltroRecoleta.ultimoFiltro";
    private static final String TITULO = "Filtrando requisi\u00e7\u00f5es";
    private static final String SELECIONADO = "selecionado";
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", '\u0000', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private TTextField textDataIni = new TTextField(10, 4);
    private TTextField textDataFin = new TTextField(10, 4);
    private TTextField textHoraIni = new TTextField(5, 6);
    private TTextField textHoraFin = new TTextField(5, 6);
    private JComboBox comboTipoData = new JComboBox<String>(new String[]{"Requisi\u00e7\u00e3o", "Recoleta"});
    private JTable tableReq = new JTable();
    private ModeloResultSet modReq = new ModeloResultSet("Filial", "fil_codigo", "Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado");
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemExame;
    private JPanel panel;
    private String codigoLabExterno;
    private Boolean ok = Boolean.FALSE;
    private DialogoFiltroRecoletaService service;

    public static DialogoFiltroRecoleta novaInstancia(Object pai, String codigoLabExterno) {
        return pai instanceof Frame ? new DialogoFiltroRecoleta((Frame)pai, codigoLabExterno) : new DialogoFiltroRecoleta((Dialog)pai, codigoLabExterno);
    }

    private DialogoFiltroRecoleta() {
    }

    private DialogoFiltroRecoleta(Frame pai, String codigoLabExterno) {
        super(pai, TITULO, true);
        this.service = new DialogoFiltroRecoletaService();
        this.codigoLabExterno = codigoLabExterno;
        this.construirTela();
    }

    private DialogoFiltroRecoleta(Dialog pai, String codigoLabExterno) {
        super(pai, TITULO, true);
        this.service = new DialogoFiltroRecoletaService();
        this.codigoLabExterno = codigoLabExterno;
        this.construirTela();
    }

    private void construirTela() {
        this.getContentPane().setLayout(new BorderLayout());
        this.panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "South");
        this.panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        this.panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        this.panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)this.panel, "Center");
        this.construirTabelas();
        this.adicionarScroll();
        this.construirItensCheckBox();
        this.panel = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)this.panel, "North");
        this.posicionarComponentes();
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.adicionarAcoes();
        this.adicionarPoliticaDeFocus();
        this.carregarParametros();
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void posicionarComponentes() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        if (!Variaveis.integrarDadosEntreFiliais) {
            this.panel.add((Component)this.itemFilial, cons);
            cons.gridy = 1;
        }
        cons.gridx = 0;
        this.panel.add((Component)this.itemColeta, cons);
        cons.gridy = !Variaveis.integrarDadosEntreFiliais ? 2 : 1;
        cons.gridx = 0;
        this.panel.add((Component)this.itemDestino, cons);
        cons.gridy = !Variaveis.integrarDadosEntreFiliais ? 3 : 2;
        cons.gridx = 0;
        this.panel.add((Component)this.itemConvenio, cons);
        cons.gridy = !Variaveis.integrarDadosEntreFiliais ? 4 : 3;
        cons.gridx = 0;
        this.panel.add((Component)this.itemExame, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        this.panel.add((Component)new JLabel("Data Inicial:"), cons);
        cons.gridx = 1;
        cons.gridy = 1;
        this.panel.add((Component)new JLabel("Data Final:"), cons);
        cons.gridx = 1;
        cons.gridy = 2;
        this.panel.add((Component)new JLabel("Hora Inicial:"), cons);
        cons.gridx = 1;
        cons.gridy = 3;
        this.panel.add((Component)new JLabel("Hora Final:"), cons);
        cons.gridx = 2;
        cons.gridy = 0;
        this.buttonDataIni.setFocusable(false);
        this.panel.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataIni, null, null, this.buttonDataIni, null), cons);
        cons.gridx = 2;
        cons.gridy = 1;
        this.buttonDataFin.setFocusable(false);
        this.panel.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataFin, null, null, this.buttonDataFin, null), cons);
        cons.gridx = 2;
        cons.gridy = 2;
        this.panel.add((Component)this.textHoraIni, cons);
        cons.gridx = 2;
        cons.gridy = 3;
        this.panel.add((Component)this.textHoraFin, cons);
        cons.gridx = 1;
        cons.gridy = 4;
        this.panel.add((Component)new JLabel("Filtrar por data:"), cons);
        cons.gridx = 2;
        cons.gridy = 4;
        this.panel.add((Component)this.comboTipoData, cons);
        cons.gridx = 2;
        cons.gridy = 6;
        cons.gridwidth = 1;
        this.panel.add((Component)this.buttonConsultar, cons);
    }

    private void construirTabelas() {
        this.modReq.setColunaEditavel(SELECIONADO);
        this.tableReq = ComponenteFactory.novoJTable((TableModel)this.modReq, 30, 75, 0, 85, 25);
        this.modReq.setOrdenarColunas(true);
        this.tableReq.getTableHeader().addMouseListener(this.modReq);
        this.tableReq.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(4, 4, -1, 4));
    }

    private void adicionarScroll() {
        JScrollPane scroll = new JScrollPane(this.tableReq);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        this.panel.add((Component)scroll, "Center");
    }

    private void adicionarPoliticaDeFocus() {
        ManualFocusPolicy policy = new ManualFocusPolicy();
        policy.setFirstComponent(this, this.itemFilial);
        policy.setNextFocusableComponent(this.itemFilial, this.itemFilial);
        policy.setNextFocusableComponent(this.itemColeta, this.itemDestino);
        policy.setNextFocusableComponent(this.itemDestino, this.itemConvenio);
        policy.setNextFocusableComponent(this.itemConvenio, this.itemExame);
        policy.setNextFocusableComponent(this.itemExame, this.textDataIni);
        policy.setNextFocusableComponent(this.textDataIni, this.textDataFin);
        policy.setNextFocusableComponent(this.textDataFin, this.textHoraIni);
        policy.setNextFocusableComponent(this.textHoraIni, this.textHoraFin);
        policy.setNextFocusableComponent(this.textHoraFin, this.comboTipoData);
        policy.setNextFocusableComponent(this.comboTipoData, this.buttonConsultar);
        policy.setNextFocusableComponent(this.buttonConsultar, this.tableReq);
        this.setFocusTraversalPolicy(policy);
    }

    private void adicionarAcoes() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltroRecoleta.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroRecoleta.this.textDataIni, DialogoFiltroRecoleta.this.buttonDataIni, (JPanel)DialogoFiltroRecoleta.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltroRecoleta.this.textDataFin.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroRecoleta.this.textDataFin, DialogoFiltroRecoleta.this.buttonDataFin, (JPanel)DialogoFiltroRecoleta.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.tableReq.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = DialogoFiltroRecoleta.this.tableReq.getSelectedRow();
                DialogoFiltroRecoleta.this.tableReq.setFocusable(true);
                if (row >= 0 && e.getKeyCode() == 32) {
                    DialogoFiltroRecoleta.this.modReq.getRegistro(row).setValor(DialogoFiltroRecoleta.SELECIONADO, !DialogoFiltroRecoleta.this.modReq.getRegistro(row).getBoolean(DialogoFiltroRecoleta.SELECIONADO));
                    DialogoFiltroRecoleta.this.modReq.fireTableRowsUpdated(row, row);
                }
            }
        });
    }

    private void construirItensCheckBox() {
        this.itemFilial = new CheckItemFiltro("Filiais", "Filtrar", "Filtrando Filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemExame = new CheckItemFiltro("Exames", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            this.marcarDesmarcarTodos(o);
        } else if (o == this.buttonDataIni) {
            this.exibirCalendario(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            this.exibirCalendario(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.modReq.limpar();
            if (this.validaCampos()) {
                this.consultarRequisicoes();
                this.gravarParametros();
            }
        }
    }

    private void marcarDesmarcarTodos(Object o) {
        boolean marcar = o == this.buttonMarcarTodos;
        for (Registro reg : this.modReq.getRegistros()) {
            reg.setValor(SELECIONADO, marcar);
        }
        this.modReq.fireTableDataChanged();
    }

    private void exibirCalendario(TTextField textData, JButton buttonData, JPanel parent, boolean focus) {
        Funcoes.mostraData(textData, buttonData, parent, focus);
    }

    private void consultarRequisicoes() {
        String tipoDataSelecionado = (String)this.comboTipoData.getSelectedItem();
        DialogoFiltroRecoletaVO filtroDialogo = new DialogoFiltroRecoletaVO.Builder(tipoDataSelecionado, this.codigoLabExterno).dataFinal(this.textDataFin.getText()).dataInicial(this.textDataIni.getText()).horaFinal(this.textHoraFin.getText()).horaInicial(this.textHoraIni.getText()).itemColeta(this.itemColeta).itemConvenio(this.itemConvenio).itemDestino(this.itemDestino).itemExame(this.itemExame).itemFilial(this.itemFilial).build();
        ArrayList<Registro> requisicoes = this.service.pesquisarRequisicoesEmRecoleta(filtroDialogo);
        for (Registro reg : requisicoes) {
            this.modReq.addRegistro(reg);
            this.modReq.fireTableDataChanged();
        }
        this.gravarParametros();
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemFilial, StringUtil.getValor(str, "filial"));
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            this.textHoraIni.setText(StringUtil.getValor(str, "horaInicial"));
            this.textHoraFin.setText(StringUtil.getValor(str, "horaFinal"));
            this.comboTipoData.setSelectedItem(StringUtil.getValor(str, "tipoData"));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemFilial, "filial"));
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("horaInicial", this.textHoraIni.getText()));
        bui.append(StringUtil.getTag("horaFinal", this.textHoraFin.getText()));
        bui.append(StringUtil.getTag("tipoData", this.comboTipoData.getSelectedItem().toString()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDataIni) || Funcoes.textoVazio(this.textDataFin)) {
            Funcoes.mensagem(this, "Informe os filtros Data Inicial e Data Final.", 2);
            return false;
        }
        return true;
    }

    public Boolean isOk() {
        return this.ok;
    }

    public String[] getFiltroExame() {
        return this.itemExame.getSelecionados(0);
    }

    public List<Registro> getRequisicoesSelecionados() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modReq.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }
}

