/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.DialogoFiltroExportacao;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RendererRequisicao;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ExamePardiniDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.vo.cadastro.exame.ExameSetorVO;
import jalis.service.cadastro.exame.ExameSetorService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ConstrutorInsert;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CriaLoteExportacao
extends IntegracaoLabExterno
implements ActionListener,
KeyListener,
ListSelectionListener {
    public static final String EXA_EXPORTADO = "exa_exportado";
    public static final String EXA_LAB_SELECIONADO = "exa_externo";
    public static final String BACKUP_LISTA_EXAMES = "backup_lista_exames";
    public static final String COLUNA_CHAVE = "chave";
    public static final String EXR_SITUACAO = "exr_situacao";
    private static final Color COR_EXPORTADO = ScreenUtil.clarearCor(Tipos.COR_CONFERIDO[0], 30);
    private static final Color COR_NAO_ENVIAR = ScreenUtil.clarearCor(Color.YELLOW, 125);
    private static final Color COR_SEM_DATANASCIMENTO = ScreenUtil.clarearCor(Color.RED, 180);
    private static final Color COR_FALTA_MATERIAL = new Color(255, 102, 102);
    private static final Color COR_RECOLETA = Tipos.COR_RECOLETA[0];
    private static final Color COR_REPETICAO = Tipos.COR_REPETICAO[0];
    private static final int COLUNA_REQ = 1;
    private static final int COLUNA_EXAMES_EXPORTAR = 4;
    private static final int COLUNA_EXAMES_BACKUP = 5;
    public static final int COLUNA_EXAMES_NAO_EXPORTAR = 6;
    private static final int COLUNA_REQ_CHAVE = 13;
    public static final Color COR_SALDODEVEDOR = ScreenUtil.clarearCor(Color.BLUE, 120);
    public static final Color COR_FALTAGUIA = Color.ORANGE;
    private static final String CONFIRMAR_DADOS_ADICIONAIS = "confirmarDadosAdicionais";
    private String[] filtroSetor;
    private String[] filtroExame;
    private ExameSetorService serviceExameSetor = new ExameSetorService();
    private JComboBox comboLaboratorio = ComponenteFactory.novoJComboBox(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true), this, true, new Dimension(150, 20));
    private TTextField textRequisicao = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private JButton buttonBuscaReq = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    private JCheckBox checkConfirmarDadosAdicionais = new JCheckBox("Confirmar dados adicionais");
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonCriarLote = ComponenteFactory.novoJButton("Criar Lote", 'L', this, null, null, false);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    public static final String LISTA_EXAMES_DESM_TELA = "listaexamestela";
    private JTable tableReq;
    private JTable tableExa;
    private JTable tableOutrosExa;
    private ModeloGridTable modReq = new ModeloGridTable(new String[]{"Fil.", "Requisi\u00e7\u00e3o", "Paciente", "Data"});
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Sit.", "exr_situacao", "Tubo/Rec.", "recipapresentacao");
    private ModeloResultSet modOutrosExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Sit.", "exr_situacao", "Tubo/Rec.", "recipapresentacao");
    private RendererRequisicao rendererReq = RendererRequisicao.novaInstancia(4, 4, -1, 4);
    private CorTableCellRenderer rendererExa = CorTableCellRenderer.novaInstancia(0, -1, 0, 0);
    private CorTableCellRenderer rendererOutrosExa = CorTableCellRenderer.novaInstancia(0, -1, 0, 0);
    private DadosAdicionais dadosAdicionais = null;
    private boolean criandoLote;
    private LaboratorioExterno labSelecionado;
    private JLabel jLabelMsg = new JLabel();
    protected static final String[] campos = new String[]{"fil_codigo", "req_codigo", "pac_nome", "req_data", "listaexames", "backup_lista_exames", "listaexamesrequisicao", "med_nome", "pac_datanasc", "req_idade", "req_peso", "req_totpago", "req_obs", "chave", "pac_codigo", "req_anomes", "med_conselho", "pac_sexo", "req_total", "req_dum", "med_uf", "req_hora", "req_deveguia", "med_crm", "req_altura", "req_dclinicos", "req_codigomae", "con_codigo", "con_razao", "pac_cpf", "pac_rg", "req_urgente", "pac_dadoclinico", "pac_nomesocial", "req_obs", "pac_cpf", "pac_celular", "pac_endereco", "pac_numeroendereco", "pac_complemento"};
    static String SQL;

    public CriaLoteExportacao() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return 300600100L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonBuscaReq) {
            this.pesquisarRequisicao();
        } else if (o == this.buttonFiltrar) {
            DialogoFiltroExportacao dfe = DialogoFiltroExportacao.novaInstancia(this.getTopLevelAncestor(), this.labSelecionado.codigoLab);
            if (dfe != null) {
                dfe.setVisible(true);
                if (dfe.getOk()) {
                    this.filtroSetor = dfe.getFiltroSetor();
                    this.filtroExame = dfe.getFiltroExame();
                    this.textRequisicao.clear();
                    for (Registro reg : dfe.getRequisicoesSelecionados()) {
                        if (!Funcoes.processarFuncaoNumeroTubo(null, this.textRequisicao)) continue;
                        this.adicionarRequisicao(reg, "", ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao());
                    }
                    this.atualizarModeloRequisicoes();
                    TableUtil.selecionarLinha(this.tableReq, this.tableReq.getRowCount() - 1);
                    this.renderizaTabela(this.modOutrosExa, this.rendererOutrosExa);
                }
            }
        } else if (o == this.buttonCancelar && Funcoes.mensagem(this, "Deseja cancelar a cria\u00e7\u00e3o de lote?", 4) == 0) {
            this.limpar();
        } else if (o == this.comboLaboratorio) {
            this.labSelecionado = (LaboratorioExterno)this.comboLaboratorio.getSelectedItem();
            boolean bl = this.criandoLote = this.labSelecionado != null;
            if (this.criandoLote) {
                if (this.labSelecionado.protocolo == Protocolo.Alvaro || this.labSelecionado.protocolo == Protocolo.JalisWS) {
                    this.enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(this.labSelecionado.configuracao, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(this.labSelecionado.configuracao, "enviarLoteWebService")) : Boolean.FALSE;
                    this.isEnviarRequisicaoWebService = !Funcoes.textoVazio(StringUtil.getValor(this.labSelecionado.configuracao, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(this.labSelecionado.configuracao, "envioAutomatico")) : Boolean.FALSE;
                } else if (this.isLabHPardini()) {
                    this.enviarUsandoWS = this.labSelecionado.configuracao.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(this.labSelecionado.configuracao, "enviarLoteWebservice") : Boolean.FALSE;
                    this.isEnviarRequisicaoWebService = this.labSelecionado.configuracao.indexOf("envioAutomatico") > 0 ? StringUtil.getBoolean(this.labSelecionado.configuracao, "envioAutomatico") : Boolean.FALSE;
                }
            }
            ScreenUtil.requisitarFoco(this.criandoLote ? this.textRequisicao : this.comboLaboratorio);
        } else if (o == this.buttonCriarLote) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Statement st3 = Conexao.getStatement();
            ImpressorasLabExterno impressoras = new ImpressorasLabExterno();
            impressoras.setImpressoraAlvaro(ParametrosLocais.getParametro("impressoraWebServiceAlvaro"));
            impressoras.setImpressoraDiagnosticosBrasil(ParametrosLocais.getParametro("impressoraWebServiceDb"));
            impressoras.setImpressoraIndLab("");
            impressoras.setImpressoraJalisWS(ParametrosLocais.getParametro("impressoraJalisWs"));
            impressoras.setImpressoraMercolab(ParametrosLocais.getParametro("impressoraWebServiceMercolab"));
            impressoras.setImpressoraPardini(ParametrosLocais.getParametro("impressoraWebServiceHp"));
            impressoras.setImpressoraRedeWS(ParametrosLocais.getParametro("impressoraWebServiceRede"));
            impressoras.setImpressoraSoftLab(ParametrosLocais.getParametro("impressoraWebServiceSoftLab"));
            impressoras.setImpressoraShift(ParametrosLocais.getParametro("impressoraWebServiceShift"));
            impressoras.setImpressoraMaricondi(ParametrosLocais.getParametro("impressoraWebServiceMaricondi"));
            impressoras.setImpressoraSaoMarcos(ParametrosLocais.getParametro("impressoraWebServiceSm"));
            impressoras.setImpressoraEtqTriagem(ParametrosLocais.getParametro("impressoraEtqTriagem"));
            impressoras.setImpressoraEtqColeta(ParametrosLocais.getParametro("impressoraEtqColeta"));
            impressoras.setImpressoraRelatorio(ParametrosLocais.getParametro("impressoraRelatorio"));
            this.criarLote(false, ParametrosGerais.getAgruparInterface(), st, st2, st3, Variaveis.login, ParametrosGerais.isAgruparGuiasInterface(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), ParametrosGerais.getTipoIntegracao(), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), impressoras, ParametrosGerais.getTipoEtiquetaSoroteca(), () -> {
                try {
                    Conexao.arquivaSQL();
                    return true;
                }
                catch (Exception e2) {
                    return false;
                }
            }, () -> {
                try {
                    Conexao.anulaSQL();
                    return true;
                }
                catch (Exception e3) {
                    return false;
                }
            });
        } else if (o == this.buttonNovo) {
            this.novoLote();
        }
        this.habilitarDesabilitarBotoes();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg;
        this.modExa.limpar();
        this.modOutrosExa.limpar();
        this.rendererExa.limpar();
        this.rendererOutrosExa.limpar();
        if (this.tableReq.getSelectedRowCount() == 1 && (reg = this.objectToReg(this.tableReq.getSelectedRow())) != null) {
            this.modExa.addRegistros((Collection)reg.getValor("listaexames"));
            this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
            if (this.labSelecionado.protocolo != Protocolo.DBV2) {
                this.modExa.ordenarColuna(0);
                this.modOutrosExa.ordenarColuna(0);
            }
            this.renderizaTabela(this.modExa, this.rendererExa);
            this.renderizaTabela(this.modOutrosExa, this.rendererOutrosExa);
            this.modExa.fireTableDataChanged();
            this.modOutrosExa.fireTableDataChanged();
        }
    }

    private void renderizaTabela(ModeloResultSet modExa, CorTableCellRenderer renderer) {
        for (int i = 0; i < modExa.getRowCount(); ++i) {
            renderer.setHintLinha(i, Tipos.tipoSituacaoExame(modExa.getRegistro(i).getString(EXR_SITUACAO)));
            if (modExa.getRegistro(i).getBoolean(EXA_EXPORTADO)) {
                renderer.setHintLinha(i, "Exame j\u00e1 foi exportado");
                renderer.setCorLinha(COR_EXPORTADO, i);
            } else if (!modExa.getRegistro(i).getBoolean(EXA_LAB_SELECIONADO)) {
                renderer.setHintLinha(i, "Exame n\u00e3o configurado para este laborat\u00f3rio");
                renderer.setCorLinha(COR_NAO_ENVIAR, i);
            }
            if (modExa.getRegistro(i).getBoolean("validarSetor") || !this.verificaDataMaterial(modExa.getRegistro(i))) {
                renderer.setHintLinha(i, "Exame n\u00e3o configurado para este setor");
                renderer.setCorLinha(COR_NAO_ENVIAR, i);
            }
            if (modExa.getRegistro(i).getString(EXR_SITUACAO).equalsIgnoreCase("F")) {
                renderer.setCorLinha(COR_FALTA_MATERIAL, i);
                continue;
            }
            if (modExa.getRegistro(i).getString(EXR_SITUACAO).equalsIgnoreCase("R")) {
                renderer.setCorLinha(COR_RECOLETA, i);
                continue;
            }
            if (!modExa.getRegistro(i).getString(EXR_SITUACAO).equalsIgnoreCase("O")) continue;
            renderer.setCorLinha(COR_REPETICAO, i);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.atualizarLabelMsg();
        Object o = e.getSource();
        if (e.getSource() == this.tableReq && e.getKeyCode() == 127 && this.tableReq.getSelectedRowCount() > 0) {
            String msn;
            int[] indices = this.tableReq.getSelectedRows();
            String string = msn = indices.length == 1 ? "Deseja remover a requisi\u00e7\u00e3o selecionada?" : "Deseja remover as requisi\u00e7\u00f5es selecionadas?";
            if (Funcoes.mensagem(this, msn, 4) == 0) {
                for (int i = indices.length - 1; i > -1; --i) {
                    this.modReq.removeLine(indices[i]);
                }
                this.atualizarModeloRequisicoes();
                TableUtil.selecionarLinha(this.tableReq, Math.min(indices[0], this.tableReq.getRowCount() - 1));
            }
        } else if (e.getSource() == this.tableExa && this.tableExa.getSelectedRow() >= 0 && e.getKeyCode() == 127) {
            if (Funcoes.mensagem(this, "Deseja remover o exame selecionado?", 4) == 0) {
                int row = this.tableExa.getSelectedRow();
                Registro req = this.objectToReg(this.tableReq.getSelectedRow());
                List exames = (List)req.getValor("listaexames");
                List examesLis = (List)req.getValor("listaexames");
                Registro exame = this.modExa.getRegistro(row);
                for (Registro registro : exames) {
                    if (!registro.getString("req_codigo").equals(exame.getString("req_codigo")) || !registro.getString("rec_kodigo").equals(exame.getString("rec_kodigo")) || !registro.getString("mco_codigo").equals(exame.getString("mco_codigo")) || !registro.getString("exa_codigo").equals(exame.getString("exa_codigo"))) continue;
                    exames.remove(registro);
                    break;
                }
                for (int i = 0; i < examesLis.size(); ++i) {
                    Registro registro;
                    registro = (Registro)examesLis.get(i);
                    if (registro.getString("req_codigo").equals(exame.getString("req_codigo")) && registro.getString("rec_kodigo").equals(exame.getString("rec_kodigo")) && registro.getString("mco_codigo").equals(exame.getString("mco_codigo")) && registro.getString("exa_codigo").equals(exame.getString("exa_codigo"))) {
                        examesLis.remove(registro);
                        break;
                    }
                    if (!registro.getString("req_codigo").equals(exame.getString("req_codigo")) || !registro.getString("rec_kodigo").equals(exame.getString("rec_kodigo")) || !registro.getString("mco_kodigo").equals(exame.getString("mco_codigo")) || !registro.getString("exa_kodigo").equals(exame.getString("exa_codigo"))) continue;
                    examesLis.remove(registro);
                    --i;
                }
                if (exames.isEmpty()) {
                    Funcoes.mensagem(this, "Requisi\u00e7\u00e3o ser\u00e1 removida pois n\u00e3o possui exame para cria\u00e7\u00e3o do lote.", 3);
                    this.modReq.removeLine(this.tableReq.getSelectedRow());
                }
                req.setValor("listaexames", exames);
                this.valueChanged(null);
            }
        } else if (o == this.textRequisicao && e.getKeyCode() == 10 || e.getKeyChar() == '\t') {
            this.buscarRequisicaoAoPerdeFoco();
        } else if (o == this.textRequisicao && e.getKeyCode() == 113) {
            this.pesquisarRequisicao();
        } else if (!(!this.criandoLote || o == this.textRequisicao || !Character.isDigit(e.getKeyChar()) || e.isAltDown() && e.isControlDown() && e.isShiftDown())) {
            this.textRequisicao.setText(String.valueOf(e.getKeyChar()));
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        this.habilitarDesabilitarBotoes();
    }

    private void atualizarLabelMsg() {
        this.jLabelMsg.setText("");
        this.jLabelMsg.repaint();
    }

    private void criarLote(boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        String configuracaoOriginal = this.labSelecionado.configuracao;
        this.labSelecionado.configuracao = CriaLoteExportacao.atualizaConfiguracao(this.labSelecionado.codigoLab);
        AbstractConfiguradorProtocolo conf = FabricaConfigurador.novoConfiguradorProtocolo(this.getTopLevelAncestor(), this.labSelecionado.protocolo, this.labSelecionado.codigoLab);
        Exportador exp = FabricaExportador.novoExportador(this.labSelecionado.protocolo);
        if (conf == null) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi encontrado configurador para o protocolo \"" + (Object)((Object)this.labSelecionado.protocolo) + "\"", null, "CriaLoteExportacao: 165");
        } else if (exp == null) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi encontrado exportador para o protocolo \"" + (Object)((Object)this.labSelecionado.protocolo) + "\"", null, "CriaLoteExportacao: 167");
        } else {
            try {
                StringBuilder retornoRequisicoes = this.buscaRegistrosRequisicao();
                if (retornoRequisicoes.length() > 0) {
                    retornoRequisicoes.replace(retornoRequisicoes.length() - 2, retornoRequisicoes.length(), "");
                    String requisicoesComLotes = retornoRequisicoes.substring(0, retornoRequisicoes.length() - 2);
                    String termoRequisicaoMensagem = requisicoesComLotes.contains(",") ? "as requisi\u00e7\u00f5es" : "a requisi\u00e7\u00e3o";
                    Funcoes.mensagem(this, String.format("Todos os exames do laborat\u00f3rio selecionado j\u00e1 foram exportados para %s \"" + retornoRequisicoes + "\".", termoRequisicaoMensagem), 2);
                    return;
                }
                if (!this.removerExamesQueNaoSeraoExportados(st)) {
                    Funcoes.mensagem(this, "As requisi\u00e7\u00f5es selecionadas n\u00e3o possuem exames que satisfa\u00e7am as condi\u00e7\u00f5es de cria\u00e7\u00e3o do lote", 2);
                    return;
                }
                conf.setXML(this.labSelecionado.configuracao, true);
                int novoLote = Integer.valueOf(this.retornaCodigoLote(this.labSelecionado.codigoLab, st));
                if (this.labSelecionado.protocolo.equals((Object)Protocolo.Jalis) && novoLote == 0) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel obter o n\u00famero do pr\u00f3ximo lote verifique se o WebService est\u00e1 ativo!", 2);
                    return;
                }
                int maiorLote = exp.getMaiorCodigoLote(String.valueOf(novoLote), conf.getCodigoConvenio(), this.labSelecionado, st);
                if (novoLote < maiorLote) {
                    novoLote = maiorLote;
                }
                conf.setNumeroLote(novoLote);
                String tagParamRelacionamento = "paramrelacionamento";
                String paramRelacionamento = StringUtil.getValor(configuracaoOriginal, tagParamRelacionamento);
                String xmlConfiguracao = conf.getXML();
                if (!Funcoes.textoVazio(paramRelacionamento) && Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, tagParamRelacionamento))) {
                    xmlConfiguracao = xmlConfiguracao + "\n<" + tagParamRelacionamento + ">";
                    xmlConfiguracao = xmlConfiguracao + paramRelacionamento;
                    xmlConfiguracao = xmlConfiguracao + "</" + tagParamRelacionamento + ">";
                }
                this.labSelecionado.configuracao = xmlConfiguracao;
                List<Registro> requisicoes = this.gravarLote(novoLote, st, agruparGuiasInterface);
                if (this.labSelecionado.protocolo == Protocolo.HPardini) {
                    CriaLoteExportacao.gravaSolicitanteExame(requisicoes);
                }
                if (this.protocoloAgrupaRequisicoes()) {
                    requisicoes = CriaLoteExportacao.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
                }
                if (this.isLabSaoMarcos(this.labSelecionado)) {
                    if (!this.validarConexao(Variaveis.filialPadrao, this.labSelecionado, st, isColetaWeb)) {
                        return;
                    }
                    conf.setXML(CriaLoteExportacao.atualizaConfiguracao(this.labSelecionado.codigoLab), true);
                }
                if (requisicoes.isEmpty()) {
                    Funcoes.mensagem(this, "Requisi\u00e7\u00f5es j\u00e1 possuem lote!", 2);
                    return;
                }
                if (this.labSelecionado.protocolo != Protocolo.SoftLab) {
                    this.trataCampoObservacao(requisicoes);
                }
                int pos = 0;
                for (Registro registro : requisicoes) {
                    registro.setValor(registro.getString("req_codigo"), pos);
                    ++pos;
                }
                if (exp.exportarExames(this.labSelecionado.codigoLab, String.valueOf(novoLote), conf.getXML(), false, requisicoes, this.modReq.getColunaOrdenacao(), isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, this.labSelecionado, agruparGuiasInterface).isImprimiu()) {
                    arquivar.call();
                    LaboratorioExterno labExt = this.labSelecionado;
                    this.labSelecionado.salvarConfiguracao(st, isColetaWeb);
                    arquivar.call();
                    int colunaOrdenacao = this.modReq.getColunaOrdenacao();
                    if (this.labSelecionado.protocolo == Protocolo.DBV2) {
                        colunaOrdenacao = -10;
                    }
                    exp.imprimeRelatorio(isColetaWeb, this.labSelecionado.codigoLab, String.valueOf(novoLote), requisicoes, colunaOrdenacao, st, Integer.valueOf(Variaveis.filialPadrao), digitosTuboRequisicao, digitosTuboFilial, impressoras.getImpressoraRelatorio());
                    if (this.labSelecionado.protocolo == Protocolo.DBV2) {
                        this.limparExamesRequisicoesExportadas();
                    } else {
                        this.limparRequisicoesExportadas();
                    }
                    this.voltarExamesQueNaoSeraoExportados(st);
                    if (this.checkConfirmarDadosAdicionais.isSelected()) {
                        this.atualizaInfoExames(requisicoes);
                        arquivar.call();
                    }
                    if (this.isLabHPardini()) {
                        this.atualizarDadosCondicaoAmostra(Variaveis.filialPadrao, this.getCondicaoExamesDesm(), novoLote, this.labSelecionado.codigoLab, st, isColetaWeb, arquivar);
                    }
                    if (this.modReq.getRowCount() == 0) {
                        if (Funcoes.mensagem(this, "Deseja criar outro lote para o laborat\u00f3rio \"" + labExt.descricao + "\"?", 4) == 0) {
                            labExt.configuracao = CriaLoteExportacao.atualizaConfiguracao(this.labSelecionado.codigoLab);
                            this.comboLaboratorio.setSelectedItem(labExt);
                            this.criandoLote = true;
                        } else {
                            this.labSelecionado.configuracao = CriaLoteExportacao.atualizaConfiguracao(this.labSelecionado.codigoLab);
                            this.criandoLote = false;
                        }
                    } else {
                        Funcoes.mensagem(this, "As requisi\u00e7\u00f5es que n\u00e3o atenderam as exig\u00eancias do laborat\u00f3rio  de apoio, n\u00e3o foram exportadas.\nEstas requisi\u00e7\u00f5es poder\u00e3o ser exportadas posteriormente.", 2);
                    }
                } else {
                    this.labSelecionado.configuracao = configuracaoOriginal;
                    this.voltarExamesQueNaoSeraoExportados(st);
                    anular.call();
                }
            }
            catch (Exception e) {
                this.labSelecionado.configuracao = configuracaoOriginal;
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CriaLoteExportacao: 164");
            }
        }
        this.habilitarDesabilitarBotoes();
        ParametrosUsuarios.setValor(CONFIRMAR_DADOS_ADICIONAIS, String.valueOf(this.checkConfirmarDadosAdicionais.isSelected()));
    }

    private boolean protocoloAgrupaRequisicoes() {
        return this.labSelecionado.protocolo != Protocolo.HPardini && this.labSelecionado.protocolo != Protocolo.Alvaro && this.labSelecionado.protocolo != Protocolo.SolucaoV2 && this.labSelecionado.protocolo != Protocolo.Maricondi && this.labSelecionado.protocolo != Protocolo.DBV2 && this.labSelecionado.protocolo != Protocolo.Concent && this.labSelecionado.protocolo != Protocolo.Unilab && this.labSelecionado.protocolo != Protocolo.Cerba && this.labSelecionado.protocolo != Protocolo.Syslab && this.labSelecionado.protocolo != Protocolo.SaoCamilo && this.labSelecionado.protocolo != Protocolo.SaoMarcos && this.labSelecionado.protocolo != Protocolo.Rede && this.labSelecionado.protocolo != Protocolo.RedeWS && this.labSelecionado.protocolo != Protocolo.INDLab && this.labSelecionado.protocolo != Protocolo.MercolabWS && this.labSelecionado.protocolo != Protocolo.Shift && this.labSelecionado.protocolo != Protocolo.SoftLab;
    }

    private StringBuilder buscaRegistrosRequisicao() throws SQLException {
        StringBuilder retornoSQL = new StringBuilder();
        ArrayList<String> regExames = new ArrayList<String>();
        ArrayList<String> regMateriais = new ArrayList<String>();
        for (int z = 0; z < this.modReq.getRowCount(); ++z) {
            Registro reg = this.objectToReg(z);
            String codFilial = reg.getString("fil_codigo");
            Integer codRequisicao = (Integer)this.modReq.getValueAt(z, 1);
            List exames = new ArrayList();
            exames = (List)reg.getValor("listaexames");
            exames.forEach(r -> {
                regExames.add(r.getString("exa_codigo"));
                regMateriais.add(r.getString("mco_codigo"));
            });
            List<String> requisicoesComLote = this.pesquisarRequisicoesComLote(regExames, regMateriais, codFilial, codRequisicao);
            requisicoesComLote.forEach(r -> retornoSQL.append((String)r).append(", "));
        }
        return retornoSQL;
    }

    private List<String> pesquisarRequisicoesComLote(List<String> regExames, List<String> regMateriais, Object regFilial, Object regRequisicao) throws SQLException {
        Statement stReq = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        String ultimaRequisicao = "";
        bui.append(" select leer.req_codigo ");
        bui.append(" from loteexternoexamerequisicao leer ");
        bui.append(" join loteexternorequisicao ler on leer.fil_kodigo = ler.fil_kodigo and leer.req_codigo = ler.req_codigo and leer.lae_codigo = ler.lae_codigo and leer.lex_codigo = ler.lex_codigo ");
        bui.append(" join loteexterno le on le.fil_codigo = ler.fil_codigo and ler.lex_codigo = le.lex_codigo and ler.lae_codigo = le.lae_codigo ");
        bui.append(" where leer.fil_kodigo = ").append(regFilial);
        bui.append(" and leer.req_codigo = ").append(regRequisicao);
        bui.append(" and (leer.exa_codigo, leer.mco_codigo) in (");
        for (int p = 0; p < regExames.size(); ++p) {
            bui.append("('").append(regExames.get(p)).append("', ").append(regMateriais.get(p)).append("),");
        }
        bui.replace(bui.length() - 1, bui.length(), "");
        bui.append(") and ");
        bui.append(" (leer.ler_datahoraestorno is null and leer.usr_codestorno is null) and ");
        bui.append(" (ler.leq_dataestorno is null and ler.usr_codestorno is null) and ");
        bui.append(" (le.lex_dataestorno is null and le.usr_codestorno is null) ");
        ResultSet rs = Conexao.executeQuery(stReq, bui.toString());
        ArrayList<String> requisicoes = new ArrayList<String>();
        while (rs.next()) {
            requisicoes.add(rs.getString("req_codigo"));
        }
        if (rs != null) {
            bui.setLength(0);
            regExames.clear();
            regMateriais.clear();
            Conexao.fecharResultSet(rs);
        }
        if (stReq != null) {
            Conexao.fecharStatement(stReq);
        }
        return requisicoes.stream().distinct().collect(Collectors.toList());
    }

    private boolean isLabHPardini() {
        return this.labSelecionado.protocolo == Protocolo.HPardini;
    }

    private void atualizarDadosCondicaoAmostra(String filial, ArrayList<InterfaceDesmembrar> examesDesm, int numeroLote, String codigoLab, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar) throws ImpressaoException {
        ExamePardiniDao examesDao = new ExamePardiniDao();
        try {
            for (InterfaceDesmembrar exa : examesDesm) {
                examesDao.atualizarDadosCondicaoAmostra(filial, exa, numeroLote, codigoLab, st, isColetaWeb, arquivar);
            }
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
    }

    private void atualizaInfoExames(List<Registro> requisicoes) throws SQLException {
        for (Registro reg : requisicoes) {
            ArrayList listaExames = (ArrayList)reg.getValor("listaexames");
            for (Registro exa : listaExames) {
                this.atualizaDadosAdicionais(exa);
            }
        }
    }

    private void atualizaDadosAdicionais(Registro exa) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("update examerequisicao set ");
        buf.append(" exr_volumediurese = ").append(exa.getString("exr_volumediurese"));
        if (!Funcoes.textoVazio(exa.getString("exr_tempodiurese"))) {
            buf.append(" , exr_tempodiurese = '").append(exa.getString("exr_tempodiurese")).append("'");
        }
        buf.append(" where fil_codigo = ").append(exa.getString("fil_codigo"));
        buf.append(" and req_codigo = ").append(exa.getString("req_codigo"));
        buf.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("'");
        buf.append(" and mco_codigo = ").append(exa.getString("mco_codigo"));
        Conexao.executeUpdate(exa.getString("fil_codigo"), st, buf.toString());
        if (exa.possuiCampo("req_periodogestacional")) {
            new RequisicaoService().atualizarPeriodoGestacional(exa.getString("fil_codigo"), exa.getString("req_codigo"), exa.getString("req_periodogestacional"));
        }
        st.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String atualizaConfiguracao(String codigoLab) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            block5: {
                String string;
                try {
                    StringBuilder bui = new StringBuilder("select lae_configuracao ");
                    bui.append("from labexterno \n");
                    bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                    bui.append(" and lae_codigo =  ").append(codigoLab);
                    SQL = bui.toString();
                    ResultSet res = st.executeQuery(SQL);
                    if (!res.next()) break block5;
                    string = res.getString("lae_configuracao");
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CriaLoteExportacao:");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                return string;
            }
            Conexao.fecharStatement(st);
        }
        return "";
    }

    private boolean removerExamesQueNaoSeraoExportados(Statement st) throws Exception {
        boolean retorno = false;
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Registro req = this.objectToReg(i);
            ArrayList<Registro> exames = new ArrayList<Registro>();
            for (Registro exa : (List)req.getValor("listaexames")) {
                int qtd = UtilExportadores.quantidadeTuboRecipiente(exa, st);
                if ((!exa.getBoolean(EXA_LAB_SELECIONADO) || exa.getBoolean(EXA_EXPORTADO) || !Funcoes.textoVazio(exa.getString(EXR_SITUACAO)) && !exa.getString(EXR_SITUACAO).equals("T") && !exa.getString(EXR_SITUACAO).equals("O")) && (!exa.getBoolean(EXA_EXPORTADO) || qtd <= 1)) continue;
                exames.add(exa);
                retorno = true;
            }
            this.modReq.setValueAt(req.getValor("listaexames"), i, 5);
            req.setValor("listaexames", exames);
        }
        return retorno;
    }

    private void voltarExamesQueNaoSeraoExportados(Statement st) throws Exception {
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Registro req = this.objectToReg(i);
            req.setValor("listaexames", req.getValor(BACKUP_LISTA_EXAMES));
            UtilExportadores.processaDesm(req, (List)req.getValor(BACKUP_LISTA_EXAMES), this.labSelecionado, st);
        }
    }

    public ArrayList<Registro> gravarLote(int novoLote, Statement st, boolean isAgruparGuiasInterface) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        if (st != null) {
            ConstrutorInsert insert = new ConstrutorInsert("loteexterno");
            insert.addCampoValor("fil_codigo", Variaveis.filialPadrao);
            insert.addCampoValor("lex_codigo", novoLote);
            insert.addCampoValor("lae_codigo", this.labSelecionado.codigoLab);
            insert.addCampoValor("lex_datahora", "current_timestamp");
            insert.addCampoValor("usr_codcriacao", Variaveis.login, true);
            SQL = insert.getSQL();
            Conexao.execute(Variaveis.filialPadrao, st, SQL);
            for (int i = 0; i < this.modReq.getRowCount(); ++i) {
                Registro req = this.objectToReg(i);
                List exames = (List)req.getValor("listaexames");
                ArrayList<Registro> examesTodos = new ArrayList<Registro>();
                req.setValor(LISTA_EXAMES_DESM_TELA, exames);
                if (this.labSelecionado.protocolo == Protocolo.Maricondi || this.labSelecionado.protocolo == Protocolo.Cerba || this.labSelecionado.protocolo == Protocolo.Syslab) {
                    CriaLoteExportacao.carregarExamesDesmembrados(req, this.labSelecionado, st);
                }
                if (this.protocoloAgrupaExameDesmembrado()) {
                    if (exames != null && !exames.isEmpty()) {
                        for (Registro registro : exames) {
                            List registros = (List)registro.getValor("listaexames");
                            if (registros != null && !registros.isEmpty()) {
                                examesTodos.addAll(registros);
                                continue;
                            }
                            examesTodos.add(registro);
                        }
                    }
                    req.setValor("listaexames", examesTodos);
                }
                if (exames.size() == 0) continue;
                req.setValor("lex_codigo", novoLote);
                req.setValor("lae_codigo", this.labSelecionado.codigoLab);
                this.descobriMetodoEnvioWebService(req, this.labSelecionado, st, isAgruparGuiasInterface);
                retorno.add(req);
                insert.limpar("loteexternorequisicao");
                insert.addCampoValor("fil_codigo", Variaveis.filialPadrao);
                insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                insert.addCampoValor("lex_codigo", novoLote);
                insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                insert.addCampoValor("lae_codigo", this.labSelecionado.codigoLab);
                req.setValor("novoLote", novoLote);
                SQL = insert.getSQL();
                Conexao.execute(Variaveis.filialPadrao, st, SQL);
                HashSet<String> chaves = new HashSet<String>();
                for (Registro exa : exames) {
                    List desmembrados;
                    String[] valores;
                    String chave = exa.getString("exa_codigo") + exa.getString("mco_codigo");
                    int qtd = UtilExportadores.quantidadeTuboRecipiente(exa, st);
                    if ((!exa.getBoolean(EXA_LAB_SELECIONADO) || exa.getBoolean(EXA_EXPORTADO) || chaves.contains(chave)) && (!exa.getBoolean(EXA_EXPORTADO) || qtd <= 1 || chaves.contains(chave))) continue;
                    insert.limpar("loteexternoexamerequisicao");
                    insert.addCampoValor("fil_codigo", Variaveis.filialPadrao);
                    insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                    insert.addCampoValor("lex_codigo", novoLote);
                    insert.addCampoValor("lae_codigo", this.labSelecionado.codigoLab);
                    insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                    insert.addCampoValor("exa_codigo", exa.getString("exa_codigo"), true);
                    insert.addCampoValor("mco_codigo", exa.getString("mco_codigo"));
                    insert.addCampoValor("ler_prazo", exa.getString("ele_diasprazo") != null ? exa.getInt("ele_diasprazo") : 0);
                    insert.addCampoValor("ler_custo", exa.getString("ele_valorexame") != null ? exa.getDouble("ele_valorexame") : 0.0);
                    SQL = insert.getSQL();
                    Conexao.execute(Variaveis.filialPadrao, st, SQL);
                    if (exa.getValor("rec_kodigo") != null && exa.getValor("rec_kodigo") instanceof Array && (valores = (String[])((Array)exa.getValor("rec_kodigo")).getArray()).length > 0 && (valores.length != 1 || !Funcoes.textoVazio(valores[0])) && Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exa.getString("rec_kodigo"), new String[]{"{", "}"}))) {
                        insert.limpar("loteexternoexamerequisicaorecip");
                        insert.addCampoValor("fil_codigo", Variaveis.filialPadrao);
                        insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                        insert.addCampoValor("lex_codigo", novoLote);
                        insert.addCampoValor("lae_codigo", this.labSelecionado.codigoLab);
                        insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                        insert.addCampoValor("exa_codigo", exa.getString("exa_codigo"), true);
                        insert.addCampoValor("mco_codigo", exa.getString("mco_codigo"));
                        insert.addCampoValor("rec_codigo", StringUtil.limpaString(exa.getString("rec_kodigo"), new String[]{"{", "}"}));
                        SQL = insert.getSQL();
                        Conexao.execute(Variaveis.filialPadrao, st, SQL);
                    }
                    if (exa.getValor("listaexames") != null && (desmembrados = (List)exa.getValor("listaexames")).size() > 0) {
                        for (int k = 0; k < desmembrados.size(); ++k) {
                            Registro desm = (Registro)desmembrados.get(k);
                            insert.limpar("loteexternoexamerequisicaodesm");
                            insert.addCampoValor("fil_codigo", Variaveis.filialPadrao);
                            insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                            insert.addCampoValor("lex_codigo", novoLote);
                            insert.addCampoValor("lae_codigo", this.labSelecionado.codigoLab);
                            insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                            insert.addCampoValor("exa_codigo", Funcoes.textoVazio(exa.getString("exa_kodigo")) ? exa.getString("exa_codigo") : exa.getString("exa_kodigo"), true);
                            insert.addCampoValor("mco_codigo", Funcoes.textoVazio(exa.getString("mco_kodigo")) ? exa.getString("mco_codigo") : exa.getString("mco_kodigo"));
                            insert.addCampoValor("exa_kodigo", desm.getValor("exa_codigo"), true);
                            insert.addCampoValor("mco_kodigo", desm.getValor("mco_codigo"));
                            SQL = insert.getSQL();
                            Conexao.execute(Variaveis.filialPadrao, st, SQL);
                        }
                    }
                    insert.addCampoValor("mco_descricao", exa.getString("mco_descricao"));
                    insert.addCampoValor("mco_codigo", exa.getString("mco_solicitarmat"));
                    chaves.add(chave);
                    CriaLoteExportacao.gravarExamesExportados(req, exa, st, false);
                }
            }
        }
        return retorno;
    }

    private boolean protocoloAgrupaExameDesmembrado() {
        return this.labSelecionado.protocolo != Protocolo.HPardini && this.labSelecionado.protocolo != Protocolo.Alvaro && this.labSelecionado.protocolo != Protocolo.SolucaoV2 && this.labSelecionado.protocolo != Protocolo.Maricondi && this.labSelecionado.protocolo != Protocolo.DBV2 && this.labSelecionado.protocolo != Protocolo.Concent && this.labSelecionado.protocolo != Protocolo.Unilab && this.labSelecionado.protocolo != Protocolo.Cerba && this.labSelecionado.protocolo != Protocolo.Syslab && this.labSelecionado.protocolo != Protocolo.SaoCamilo && this.labSelecionado.protocolo != Protocolo.SaoMarcos && this.labSelecionado.protocolo != Protocolo.RedeWS && this.labSelecionado.protocolo != Protocolo.INDLab && this.labSelecionado.protocolo != Protocolo.JalisWS && this.labSelecionado.protocolo != Protocolo.MercolabWS && this.labSelecionado.protocolo != Protocolo.Shift && this.labSelecionado.protocolo != Protocolo.SoftLab;
    }

    private String obterAtributoTagInformacao(String xml, String atributo) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.removerAcentos(xml.toString()).getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        InputSource io = new InputSource(reader);
        io.setEncoding("UTF-8");
        DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dbf.parse(io);
        Element raiz = doc.getDocumentElement();
        return raiz.getAttribute(atributo);
    }

    public static void gravarExamesExportados(Registro req, Registro exa, Statement st, boolean isColetaWeb) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update examerequisicao ");
        bui.append("set exr_dataloteexterno = current_timestamp, ");
        bui.append("    usr_codloteexterno = '").append(Variaveis.login).append("' ");
        bui.append("where ");
        bui.append("  fil_codigo = ").append(req.getValor("fil_codigo")).append(" and ");
        bui.append("  req_codigo = ").append(req.getValor("req_codigo")).append(" and ");
        bui.append("  exa_codigo = '").append(exa.getString("exa_codigo")).append("' and ");
        bui.append("  mco_codigo = ").append(exa.getString("mco_codigo"));
        if (isColetaWeb) {
            st.executeUpdate(bui.toString());
        } else {
            SQL = bui.toString();
            Conexao.executeUpdate(req.getValor("fil_codigo").toString(), st, SQL);
        }
    }

    private void pesquisarRequisicao() {
        this.atualizarLabelMsg();
        Hashtable hash = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, false, false);
        if (hash != null) {
            this.adicionarRequisicao(hash.get("req_codigo").toString(), Variaveis.filialPadrao, "");
            this.atualizarModeloRequisicoes();
            TableUtil.selecionarLinha(this.tableReq, this.tableReq.getRowCount() - 1);
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private String trocaCodigo(String codigoRequisicao, String codRecipiente) {
        if (codigoRequisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return codigoRequisicao.substring(ParametrosGerais.getDigitosTuboFilial(), codigoRequisicao.length() - ParametrosGerais.getDigitosTuboTubo());
        }
        return codigoRequisicao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionarRequisicao(String codigoRequisicao, String filial, String codRecipiente) {
        String codigoReq = this.trocaCodigo(codigoRequisicao, codRecipiente);
        SituacaoReq situacao = this.verificaSituacaoRequisicao(codigoReq, filial, codRecipiente);
        if (Variaveis.integrarDadosEntreFiliais && situacao != SituacaoReq.REQ_NAO_CADASTRADA && situacao != SituacaoReq.ETIQUETA_NAO_LOCALIZADA) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            try {
                chaves.put("req_codigo", codigoReq);
                chaves.put("fil_codigo", filial);
                RequisicaoBean requisicaoBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                if (requisicaoBean != null && requisicaoBean.getFilial() != null) {
                    Integer filialLogada = Integer.parseInt(Variaveis.filialPadrao);
                    if (!requisicaoBean.getFilial().getCodigo().equals(filialLogada)) {
                        this.exibirMsg();
                        return;
                    }
                    this.atualizarLabelMsg();
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel consultar requisi\u00e7\u00e3o pra validar a integra\u00e7\u00e3o da filial.", 1);
            }
        }
        if (situacao != SituacaoReq.REQ_OK) {
            String msn;
            switch (situacao) {
                case REQ_JA_ADICIONADA: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" j\u00e1 foi adicionada.";
                    break;
                }
                case NAO_CONTEM_EXAMES: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o cont\u00e9m exames para o laborat\u00f3rio selecionado.";
                    break;
                }
                case EXAMES_JA_EXPORTADOS: {
                    msn = "Todos os exames do laborat\u00f3rio selecionado j\u00e1 foram exportados para a requisi\u00e7\u00e3o \"" + codigoReq + "\".";
                    break;
                }
                case ETIQUETA_NAO_LOCALIZADA: {
                    msn = "O tubo informado n\u00e3o foi localizado para a requisi\u00e7\u00e3o \"" + codigoReq + "\".";
                    break;
                }
                case ETIQUETA_JA_ADICIONADA: {
                    msn = "O tubo \"" + codRecipiente + "\" para a requisi\u00e7\u00e3o \"" + codigoReq + "\" j\u00e1 foi adicionado.";
                    break;
                }
                default: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o foi cadastrada.";
                }
            }
            Funcoes.mensagem(this, msn, 2);
            return;
        }
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                boolean agruparMultiguias;
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, \n");
                bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, con.con_codigo, con.con_razao, \n");
                bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, a.req_totpago, a.req_total, a.req_deveguia, \n");
                bui.append("  a.med_conselho, a.med_crm, a.med_uf, c.med_nome, a.req_dclinicos, coalesce(d.req_codigo, a.req_codigo) as req_codigomae \n");
                bui.append(", a.req_periodogestacional, req_municipioresidencia, req_datasintoma, req_apresentousintoma, b.pac_cpf, b.pac_rg  ");
                bui.append(", b.pac_dadoclinico, b.pac_nomesocial, a.req_obs, b.pac_celular, b.pac_endereco, b.pac_numeroendereco, b.pac_complemento, req_urgente ");
                bui.append("from requisicao a \n");
                bui.append("left join paciente b \n");
                bui.append("  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
                bui.append("left join medico c \n");
                bui.append("  on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf \n");
                bui.append(" left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                bui.append("left join requisicaorequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_kodigo \n");
                bui.append("where ");
                bui.append("  a.fil_codigo = ").append(filial).append(" and \n");
                Object codigoMae = Integer.parseInt(codigoReq);
                boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, codigoReq);
                if (agruparMultiguias) {
                    Object[] guias = RecepcaoUtil.verificaMultiGuias(filial, codigoReq, true);
                    if (guias != null && guias.length > 0) {
                        Arrays.sort(guias);
                        codigoMae = guias[0];
                        bui.append("  (a.req_codigo = ").append(guias[0]);
                        bui.append(" or d.req_codigo = ").append(guias[0]);
                        bui.append(" or d.req_kodigo = ").append(guias[0]);
                    } else {
                        bui.append("  (a.req_codigo = ").append(codigoReq);
                        bui.append(" or d.req_codigo = ").append(codigoReq);
                        bui.append(" or d.req_kodigo = ").append(codigoReq);
                    }
                } else {
                    bui.append("  (a.req_codigo = ").append(codigoReq);
                }
                bui.append(") and a.req_excluida = false ");
                bui.append(" order by a.req_codigo ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                boolean continuar = res.next();
                String pesoNovo = "";
                String alturaNova = "";
                do {
                    if (!continuar) {
                        Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o est\u00e1 cadastrada", 1);
                        break;
                    }
                    Registro reg = new Registro(res);
                    reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
                    reg.setValor("req_codigomae", codigoMae);
                    this.atualizarCampoAdicionalDB("req_peso", pesoNovo, reg);
                    this.atualizarCampoAdicionalDB("req_altura", alturaNova, reg);
                    this.adicionarRequisicao(reg, codRecipiente, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao());
                    pesoNovo = String.valueOf(reg.getValor("req_peso"));
                    alturaNova = String.valueOf(reg.getValor("req_altura"));
                    this.atualizarCampoAdicionalRequisicaoMultiguiaDB(pesoNovo, alturaNova, reg);
                } while (continuar = res.next());
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CriaLoteExportacao: 101");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        this.habilitarDesabilitarBotoes();
    }

    private void atualizarCampoAdicionalRequisicaoMultiguiaDB(String pesoNovo, String alturaNova, Registro reg) {
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.DBV2)) {
            for (int i = 0; i < this.modReq.getRowCount(); ++i) {
                Registro requisicao = this.objectToReg(i);
                if (!requisicao.getString("req_codigo").equals(reg.getString("req_codigomae"))) continue;
                this.atualizarCampoAdicionalDB("req_peso", pesoNovo, requisicao);
                this.atualizarCampoAdicionalDB("req_altura", alturaNova, requisicao);
                this.atualizarLinhaRequisicao(this.RegToObj(requisicao), i);
            }
        }
    }

    private void atualizarLinhaRequisicao(Object[] valores, int linha) {
        for (int i = 0; i < campos.length; ++i) {
            this.modReq.setValueAt(valores[i], linha, i);
        }
    }

    private void atualizarCampoAdicionalDB(String campo, String novoValor, Registro registro) {
        if (this.labSelecionado.protocolo.equals((Object)Protocolo.DBV2) && (!Funcoes.textoVazio(novoValor) || Funcoes.textoVazio(registro.getString(campo)))) {
            registro.setValor(campo, novoValor);
        }
    }

    /*
     * Exception decompiling
     */
    private void adicionarRequisicao(Registro reg, String codRecipiente, int digitosTuboFilial, int digitosTuboRequisicao) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean labExternoSelecionadoExportaExamesDesmembrados() {
        return this.labSelecionado.protocolo == Protocolo.Alvaro || this.labSelecionado.protocolo == Protocolo.HPardini || this.labSelecionado.protocolo == Protocolo.DBV2 || this.labSelecionado.protocolo == Protocolo.SaoMarcos || this.labSelecionado.protocolo == Protocolo.SolucaoV2 || this.labSelecionado.protocolo == Protocolo.Concent || this.labSelecionado.protocolo == Protocolo.Unilab || this.labSelecionado.protocolo == Protocolo.SaoCamilo || this.labSelecionado.protocolo == Protocolo.RedeWS || this.labSelecionado.protocolo == Protocolo.INDLab || this.labSelecionado.protocolo == Protocolo.JalisWS || this.labSelecionado.protocolo == Protocolo.MercolabWS || this.labSelecionado.protocolo == Protocolo.Shift || this.labSelecionado.protocolo == Protocolo.SoftLab;
    }

    private void verificaAdicionaExame(Registro exa, ResultSet res, String codRecipiente, ArrayList<Registro> exames, ArrayList<Registro> examesNaoExp, int qtd) throws SQLException {
        String msgaColetarFaltaMat = null;
        boolean validarExame = this.validarExame(exa, res, codRecipiente);
        if (validarExame && qtd >= 0 && this.verificaDataMaterial(exa)) {
            exames.add(exa);
        } else {
            examesNaoExp.add(exa);
        }
        if ((exa.getValor(EXA_EXPORTADO) == null || !exa.getBoolean(EXA_EXPORTADO)) && exa.getValor(EXA_LAB_SELECIONADO) != null && exa.getBoolean(EXA_LAB_SELECIONADO) && (res.getString(EXR_SITUACAO) != null && res.getString(EXR_SITUACAO).equals("T") || res.getString(EXR_SITUACAO).equals("F"))) {
            msgaColetarFaltaMat = "a coletar ou falta material!";
        }
        if (Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) && exa.getValor(EXA_LAB_SELECIONADO) != null && exa.getBoolean(EXA_LAB_SELECIONADO)) {
            Funcoes.mensagem(this, String.format("O exame %s|%s n\u00e3o possui o exame relacionado na sua configura\u00e7\u00e3o para o laborat\u00f3rio externo, verifique!", exa.getString("exa_codigo"), exa.getString("mco_codigo")), 2);
        }
    }

    private boolean verificaExameInserido(ArrayList<String> examesInserido, List<String> setoresFiltro, String codigoSetor, String chaves) {
        return !examesInserido.contains(chaves) && setoresFiltro.contains(codigoSetor);
    }

    private boolean verificaDataMaterial(Registro exa) {
        return !Funcoes.textoVazio(exa.getString("exr_datamaterial")) || !Funcoes.textoVazio(exa.getString(EXR_SITUACAO));
    }

    private boolean validarExame(Registro exa, ResultSet res, String codRecipiente) throws SQLException {
        if (this.filtroSetorSelecionado()) {
            if (!this.validarFiltroSetor(exa.getString("fil_codigo"), exa.getString("exa_codigo"), exa.getString("set_codigo"))) {
                exa.setValor("validarSetor", true);
            }
            return this.exameValidoSetor(exa, res, codRecipiente);
        }
        return this.exameValidoSemSetor(exa, res, codRecipiente);
    }

    private boolean exameValidoSetor(Registro exa, ResultSet res, String codRecipiente) throws SQLException {
        return !(!this.validarFiltroSetor(exa.getString("fil_codigo"), exa.getString("exa_codigo"), exa.getString("set_codigo")) || exa.getBoolean(EXA_EXPORTADO) || !exa.getBoolean(EXA_LAB_SELECIONADO) || Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) || !Funcoes.textoVazio(res.getString(EXR_SITUACAO)) && !res.getString(EXR_SITUACAO).equals("O") || !Funcoes.textoVazio(codRecipiente) && !res.getBoolean("etiquetaDigitada"));
    }

    private boolean exameValidoSemSetor(Registro exa, ResultSet res, String codRecipiente) throws SQLException {
        return !(exa.getBoolean(EXA_EXPORTADO) || !exa.getBoolean(EXA_LAB_SELECIONADO) || Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) || !Funcoes.textoVazio(res.getString(EXR_SITUACAO)) && !res.getString(EXR_SITUACAO).equals("O") || !Funcoes.textoVazio(codRecipiente) && !res.getBoolean("etiquetaDigitada"));
    }

    private boolean filtroSetorSelecionado() {
        return Funcoes.textoVazio(this.textRequisicao.getText()) && this.getFiltroSetor().size() > 0;
    }

    private List<String> getFiltroSetor() {
        ArrayList<String> setores = new ArrayList<String>();
        if (this.filtroSetor != null && this.filtroSetor.length > 0) {
            for (int i = 0; i < this.filtroSetor.length; ++i) {
                setores.add(this.filtroSetor[i]);
            }
        }
        return setores;
    }

    private boolean validarFiltroSetor(String codigoFilial, String codigoExame, String setCodigo) {
        boolean filtroUtilizado = false;
        ArrayList<ExameSetorVO> listaSetoresExame = null;
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", codigoFilial);
        chaves.put("exa_codigo", codigoExame);
        chaves.put("set_codigo", setCodigo);
        try {
            listaSetoresExame = this.serviceExameSetor.getSetoresExameVO(chaves);
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o  foi poss\u00edvel carregar os setores do exame.\n" + e2.getMessage(), e2.getStackTrace());
        }
        if (this.filtroSetor != null && this.filtroSetor.length > 0) {
            block2: for (int i = 0; i < this.filtroSetor.length; ++i) {
                if (!this.existeSetoresExame(listaSetoresExame)) continue;
                for (ExameSetorVO vo : listaSetoresExame) {
                    if (!this.verificaSetorIgual(this.filtroSetor[i], vo)) continue;
                    filtroUtilizado = true;
                    continue block2;
                }
            }
        }
        return filtroUtilizado;
    }

    private boolean verificaSetorIgual(String filtroSetor, ExameSetorVO vo) {
        return filtroSetor.equals(vo.getSetor().getCodigo().toString());
    }

    private boolean existeSetoresExame(ArrayList<ExameSetorVO> listaSetoresExame) {
        return listaSetoresExame != null && listaSetoresExame.size() > 0;
    }

    private StringBuilder getSqlRequisicao(String filial, String requisicao, String codRecipiente) {
        String tipoReciepente = "C";
        if (ParametrosGerais.getAgruparInterface() == 1) {
            tipoReciepente = "T";
        }
        StringBuilder bui = new StringBuilder("select CASE WHEN a.exr_intervaloJejum is null then TO_CHAR(a.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(a.exr_intervaloJejum,'HH24:MI:SS') end as exr_intervaloJejum, a.fil_codigo, a.req_codigo, pac.pac_cpf, pac.pac_rg, pac.pac_datanasc, pac.pac_cartaosus, pac.pac_dum, \n");
        bui.append("  pac.pac_dadoclinico, pac.pac_nomesocial, req_obs, pac.pac_cpf, pac.pac_celular, pac.pac_endereco, pac.pac_numeroendereco, pac.pac_complemento, ");
        bui.append("  (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado, ");
        bui.append("  a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as exr_tempodiurese, ");
        bui.append("  a.exr_situacao, con.con_codigo, con.con_razao, ");
        if (!Funcoes.textoVazio(codRecipiente)) {
            bui.append(" (CASE WHEN f.rec_kodigo is null THEN coalesce(a.exr_dataloteexterno is not null, false) ELSE coalesce((a.exr_dataloteexterno is not null and f.rec_kodigo is not null), false) END) ").append(EXA_EXPORTADO).append(", ");
        } else {
            bui.append(" coalesce(a.exr_dataloteexterno is not null, false) as ").append(EXA_EXPORTADO).append(", ");
        }
        bui.append("  b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao,");
        bui.append("  c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao, ");
        bui.append("  g.ele_xmllabexterno, a.exr_datamaterial, ");
        bui.append("  g.ele_diasprazo, g.ele_valorexame, coalesce(h.req_codigo, a.req_codigo) as req_codigomae, req_municipioresidencia, req_datasintoma, req_apresentousintoma, ");
        bui.append("  coalesce(g.lae_codigo = ").append(this.labSelecionado.codigoLab).append(", false) as ").append(EXA_LAB_SELECIONADO);
        bui.append(" ,'' as recipapresentacao ");
        bui.append(" ,case when (f.rec_kodigo is not null) then array_agg(distinct cast(f.rec_kodigo as varchar))::varchar[] else null END as rec_kodigo ");
        if (!Funcoes.textoVazio(codRecipiente)) {
            bui.append(" ,array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] as etiquetaDigitada ");
        } else {
            bui.append(" , '' as etiquetaDigitada ");
        }
        bui.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end, es.set_codigo");
        bui.append(" from examerequisicao a ");
        bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append(" left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append(" left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        bui.append(" left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append(tipoReciepente).append("' ");
        bui.append(" left join loteexternoexamerequisicaorecip lr on a.fil_codigo = lr.fil_kodigo and a.exa_codigo = lr.exa_codigo and a.mco_codigo = lr.mco_codigo and e.req_codigo = lr.req_codigo and f.rec_codigo = lr.rec_codigo ");
        bui.append(" left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo and g.lae_codigo = ").append(this.labSelecionado.codigoLab);
        bui.append(" left join requisicaorequisicao h on a.fil_codigo = h.fil_codigo and a.req_codigo = h.req_kodigo ");
        bui.append(" left join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = f.rec_kodigo  ");
        bui.append(" left join paciente pac on a.fil_codigo = pac.fil_codigo and e.pac_codigo =  pac.pac_codigo ");
        bui.append(" left join examesetor es on a.fil_codigo = es.fil_codigo and a.exa_codigo = es.exa_codigo ");
        bui.append(" left join convenios con on a.fil_codigo = con.fil_codigo and e.con_codigo = con.con_codigo ");
        bui.append(" where ");
        bui.append(" a.fil_codigo = ").append(filial).append(" and ");
        bui.append(" a.req_codigo = ").append(requisicao);
        bui.append(" and a.exr_excluido = false ");
        bui.append(" and coalesce(g.ele_bloqueado, false) = false ");
        if (!Funcoes.objectIsNull(this.filtroExame) && this.filtroExame.length > 0) {
            bui.append("and \n  ");
            bui.append(ImpressaoResultados.getExpressao("a.exa_codigo", this.filtroExame, true));
            bui.append(" ");
        }
        bui.append("  group by (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) ");
        bui.append(" ,a.exr_descricaomaterial ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,a.exr_volumediurese ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,b.exa_codigo ");
        bui.append(" ,b.exa_descricao ");
        bui.append(" ,a.exr_urgente ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,c.mco_codigo ");
        bui.append(" ,c.mco_abreviatura ");
        bui.append(" ,c.mco_solicitarmat ");
        bui.append(" ,c.mco_descricao ");
        bui.append(" ,g.ele_xmllabexterno ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,g.ele_diasprazo ");
        bui.append(" ,g.ele_valorexame ");
        bui.append("  ,h.req_codigo ");
        bui.append(" ,a.exr_tempodiurese ");
        bui.append(" ,a.exr_dataloteexterno ");
        bui.append(" ,g.lae_codigo ");
        bui.append(" ,f.rec_kodigo ");
        bui.append(" ,lr.rec_codigo");
        bui.append(" ,rec.rec_descricao, a.fil_codigo, a.req_codigo ");
        bui.append(" ,pac.pac_cpf");
        bui.append(" ,pac.pac_rg");
        bui.append(" ,pac.pac_datanasc");
        bui.append(" ,pac.pac_cartaosus");
        bui.append(" ,pac.pac_dum, es.set_codigo, con.con_codigo, con.con_razao, req_municipioresidencia, req_datasintoma, req_apresentousintoma , a.exr_intervalojejum, a.exr_tempoJejum ");
        bui.append(" ,pac.pac_dadoclinico, pac.pac_nomesocial, e.req_obs, pac.pac_cpf, pac.pac_celular, pac.pac_endereco, pac.pac_numeroendereco, pac.pac_complemento ");
        if (this.labSelecionado.protocolo == Protocolo.DBV2) {
            bui.append(" ,a.exr_ordem order by a.exr_ordem asc ");
        }
        return bui;
    }

    private boolean verificaMultiguia(String filial, String requisicao, String codRecipiente) throws SQLException {
        boolean agruparMultiguias;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao);
        if (!agruparMultiguias) {
            return true;
        }
        Statement st = Conexao.getStatement();
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(filial, requisicao);
        if (multiguias != null) {
            for (int i = 0; i < multiguias.length; ++i) {
                StringBuilder sql = this.getSqlRequisicao(filial, String.valueOf(multiguias[i]), codRecipiente);
                ResultSet res = Conexao.executeQuery(st, sql.toString());
                if (!res.next()) continue;
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int quantidadeTuboRecipiente(Registro exa, Statement st) {
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select count(1) as qtd from examerequisicaorecipiente  ");
            sql.append(" where fil_codigo = ").append(exa.getString("fil_codigo"));
            sql.append(" and req_codigo = ").append(exa.getInt("req_codigo"));
            sql.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
            sql.append(" and mco_codigo = ").append(exa.getInt("mco_codigo"));
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                int n = rs.getInt("qtd");
                return n;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar os tubos.", e.getStackTrace());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean podeProcessarRequisicao(String codigoReq, String filial) {
        Statement st2;
        Statement st;
        block4: {
            boolean bl;
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                ResultSet totalExamesLote = Conexao.executeQuery(st, "select count(distinct(lex.exa_codigo || lex.mco_codigo || lex.req_codigo || lex.fil_codigo)) as totalExamesLote from loteexternoexamerequisicao  lex inner join loteexternorequisicao ler on lex.fil_codigo = ler.fil_codigo and  lex.req_codigo = ler.req_codigo  where lex.fil_codigo = " + filial + " and lex.req_codigo = " + codigoReq + "  and ler.usr_codestorno is null");
                ResultSet totalExameReq = Conexao.executeQuery(st2, "select count(distinct (cast(fil_codigo as varchar)  || req_codigo || mco_codigo || exa_codigo)) as totalExameReq from examerequisicao where fil_codigo = " + filial + " and req_codigo = " + codigoReq);
                if (!totalExamesLote.next() || !totalExameReq.next()) break block4;
                bl = totalExamesLote.getInt("totalExamesLote") == totalExameReq.getInt("totalExameReq") && totalExamesLote.getInt("totalExamesLote") > 0 && totalExameReq.getInt("totalExameReq") > 0;
            }
            catch (SQLException sQLException) {
                Conexao.fecharStatement(st, st2);
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st, st2);
            return bl;
        }
        Conexao.fecharStatement(st, st2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean podeProcessarExame(String codigoReq, String filial, String exame, String material) {
        boolean bl;
        Statement st = Conexao.getStatement();
        try {
            ResultSet totalExamesLote = Conexao.executeQuery(st, "select count(distinct(lex.exa_codigo || lex.mco_codigo || lex.req_codigo || lex.fil_codigo)) as totalExamesLote from loteexternoexamerequisicao  lex inner join loteexternorequisicao ler on lex.fil_codigo = ler.fil_codigo and  lex.req_codigo = ler.req_codigo  where  lex.exa_codigo = '" + exame + "' and lex.mco_codigo = " + material + "  and   lex.fil_codigo = " + filial + " and lex.req_codigo = " + codigoReq + "  and ler.usr_codestorno is null");
            totalExamesLote.next();
            bl = totalExamesLote.getInt("totalExamesLote") > 0;
        }
        catch (SQLException sQLException) {
            Conexao.fecharStatement(st);
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return bl;
        return false;
    }

    /*
     * Exception decompiling
     */
    private SituacaoReq verificaSituacaoRequisicao(String codigoReq, String filial, String codRecipiente) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void limpar() {
        this.textRequisicao.setText("");
        this.modReq.clear();
        this.modExa.limpar();
        this.modOutrosExa.limpar();
        this.rendererReq.limpar();
        this.rendererExa.limpar();
        this.rendererOutrosExa.limpar();
        this.comboLaboratorio.removeAllItems();
        this.comboLaboratorio.setModel(new DefaultComboBoxModel<LaboratorioExterno>(LaboratorioExterno.getDescricoes(Conexao.getStatement(), true)));
        this.comboLaboratorio.setSelectedItem(null);
        this.dadosAdicionais = null;
        this.atualizarLabelMsg();
    }

    private String getChave(String filial, String requisicao) {
        return Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()).concat(Funcoes.preencheZero(requisicao, ParametrosGerais.getDigitosTuboRequisicao()));
    }

    private void limparRequisicoesExportadas() {
        this.modExa.limpar();
        ArrayList<Registro> requisicoes_old = new ArrayList<Registro>();
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            requisicoes_old.add(this.objectToReg(i));
        }
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        block1: for (Registro r : requisicoes_old) {
            List exames = (List)r.getValor("listaexames");
            if (exames.size() == 0) {
                requisicoes.add(r);
                continue;
            }
            exames = (List)r.getValor(BACKUP_LISTA_EXAMES);
            for (Registro exa : exames) {
                if (exa.getBoolean(EXA_EXPORTADO) || Funcoes.textoVazio(exa.getString(EXR_SITUACAO)) || exa.getString(EXR_SITUACAO).equals("O")) continue;
                requisicoes.add(r);
                continue block1;
            }
        }
        this.modReq.clear();
        for (Registro registro : requisicoes) {
            this.modReq.addLine(this.RegToObj(registro));
        }
    }

    private void limparExamesRequisicoesExportadas() {
        this.modExa.limpar();
        ArrayList<Registro> requisicoesOld = new ArrayList<Registro>();
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            requisicoesOld.add(this.objectToReg(i));
        }
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        for (Registro r : requisicoesOld) {
            List exames = (List)r.getValor("listaexames");
            if (exames.isEmpty()) {
                requisicoes.add(r);
                continue;
            }
            exames = (List)r.getValor(BACKUP_LISTA_EXAMES);
            ArrayList<Registro> examesNovos = new ArrayList<Registro>();
            List listaExameRequisicao = (List)r.getValor("listaexamesrequisicao");
            boolean possuiExames = false;
            for (Registro exa : exames) {
                if (!(exa.getBoolean(EXA_EXPORTADO) || Funcoes.textoVazio(exa.getString(EXR_SITUACAO)) || exa.getString(EXR_SITUACAO).equals("O"))) {
                    if (exa.getString(EXR_SITUACAO).equals("0")) {
                        exa.setValor(EXR_SITUACAO, "");
                    }
                    examesNovos.add(exa);
                    possuiExames = true;
                    continue;
                }
                listaExameRequisicao.add(exa);
            }
            if (!possuiExames) continue;
            r.substituirValor("listaexames", examesNovos);
            r.setValor("listaexamesrequisicao", listaExameRequisicao);
            requisicoes.add(r);
        }
        this.modReq.clear();
        for (Registro registro : requisicoes) {
            this.modReq.addLine(this.RegToObj(registro));
        }
    }

    private void habilitarDesabilitarBotoes() {
        this.comboLaboratorio.setEnabled(this.criandoLote && this.modReq.getRowCount() == 0);
        this.textRequisicao.setEnabled(this.comboLaboratorio.getSelectedItem() != null && this.criandoLote);
        this.buttonBuscaReq.setEnabled(this.comboLaboratorio.getSelectedItem() != null && this.criandoLote);
        this.buttonCriarLote.setEnabled(this.criandoLote && this.modReq.getRowCount() > 0);
        this.buttonFiltrar.setEnabled(this.criandoLote && this.comboLaboratorio.getSelectedItem() != null);
        this.checkConfirmarDadosAdicionais.setEnabled(this.criandoLote && this.comboLaboratorio.getSelectedItem() != null);
        this.buttonCancelar.setEnabled(this.criandoLote);
        this.buttonFechar.setEnabled(!this.criandoLote);
        this.buttonNovo.setEnabled(!this.criandoLote);
    }

    private void atualizarModeloRequisicoes() {
        this.modReq.fireTableDataChanged();
        this.buttonCriarLote.setEnabled(this.modReq.getRowCount() > 0);
        this.buttonNovo.setEnabled(this.modReq.getRowCount() > 0);
    }

    private JPanel montaPanelLegendaRequisicao() {
        JPanel panelLegenda = new JPanel(new FlowLayout(0));
        JPanel panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_FALTAGUIA);
        panelLegenda.add(panelCorLegenda);
        JLabel labelLegenda = new JLabel("Sem Guia");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_SALDODEVEDOR);
        panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("Saldo Devedor");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_SEM_DATANASCIMENTO);
        panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("Sem Data de Nascimento");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        return panelLegenda;
    }

    private JPanel montaPanelLegendaExame() {
        JPanel panelLegenda = new JPanel(new FlowLayout(0));
        JPanel panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_EXPORTADO);
        panelLegenda.add(panelCorLegenda);
        JLabel labelLegenda = new JLabel("Exportado");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_FALTA_MATERIAL);
        panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("Falta Material");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_NAO_ENVIAR);
        panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("N\u00e3o enviado");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(COR_RECOLETA);
        panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("Recoleta");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        return panelLegenda;
    }

    private void iniciar() {
        JPanel panelLegendaRequisicao = this.montaPanelLegendaRequisicao();
        JPanel panelLegendaExame = this.montaPanelLegendaExame();
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Criar lote", "Cria\u00e7\u00e3o de Lote de Exames para laborat\u00f3rios externos", "triagem/lab_externo_criar_lote.jpg");
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.jLabelMsg, null, null, ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonCriarLote, this.buttonCancelar, this.buttonFechar), ComponenteFactory.novoJPanelFlowLayout(0, this.buttonFiltrar, this.checkConfirmarDadosAdicionais)), "South");
        this.marcaCheckDadosAdicionais();
        JPanel panelAux = new JPanel(new BorderLayout());
        this.add((Component)panelAux, "Center");
        this.tableReq = ComponenteFactory.novoJTable((TableModel)this.modReq, (ListSelectionListener)this, this.rendererReq, 25, 82, 0, 85);
        this.modReq.setColumnSize(new int[]{25, 82, 0, 85}, this.tableReq);
        this.tableReq.getTableHeader().addMouseListener(this.modReq);
        this.tableReq.setDefaultRenderer(String.class, this.rendererReq);
        this.tableReq.setDefaultRenderer(Number.class, this.rendererReq);
        this.tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, 60, 0, 40, 40, 70);
        this.tableExa.setDefaultRenderer(String.class, this.rendererExa);
        this.tableOutrosExa = ComponenteFactory.novoJTable((TableModel)this.modOutrosExa, 60, 0, 40, 40, 70);
        this.tableOutrosExa.setDefaultRenderer(String.class, this.rendererOutrosExa);
        JSplitPane splitExames = new JSplitPane(0, ComponenteFactory.novoJPanelBorderLayout("Exames para enviar", (Component)new JScrollPane(this.tableExa), null, null, null, null), ComponenteFactory.novoJPanelBorderLayout("Outros Exames", (Component)new JScrollPane(this.tableOutrosExa), null, (Component)panelLegendaExame, null, null));
        splitExames.setResizeWeight(0.5);
        splitExames.setDividerSize(3);
        splitExames.setBorder(null);
        JSplitPane split = new JSplitPane(1, ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", (Component)new JScrollPane(this.tableReq), null, (Component)panelLegendaRequisicao, null, null), splitExames);
        split.setDividerLocation(350);
        split.setDividerSize(3);
        split.setBorder(null);
        panelAux.add((Component)split, "Center");
        JPanel jPanel = panelAux;
        panelAux = new JPanel(new GridBagLayout());
        jPanel.add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(5, 5, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panelAux.add((Component)ComponenteFactory.novoJLabel("Laborat\u00f3rio:", new Dimension(85, 22)), cons);
        cons.gridx = 1;
        cons.gridwidth = 4;
        cons.weightx = 0.5;
        cons.insets.left = 1;
        this.comboLaboratorio.setPreferredSize(new Dimension(80, 20));
        this.comboLaboratorio.setMaximumSize(new Dimension(80, 20));
        this.comboLaboratorio.setMinimumSize(new Dimension(80, 20));
        this.comboLaboratorio.setSelectedItem(null);
        panelAux.add((Component)this.comboLaboratorio, cons);
        cons.gridx = 4;
        cons.gridwidth = 1;
        panelAux.add((Component)new JPanel(), cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = new Insets(1, 5, 1, 1);
        panelAux.add((Component)ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", new Dimension(85, 22)), cons);
        cons.gridx = 1;
        cons.insets = new Insets(1, 1, 1, 0);
        this.textRequisicao.setPreferredSize(new Dimension(150, 22));
        panelAux.add((Component)this.textRequisicao, cons);
        cons.gridx = 2;
        cons.insets.left = 0;
        this.buttonBuscaReq.setFocusable(false);
        panelAux.add((Component)this.buttonBuscaReq, cons);
        cons.gridx = 3;
        cons.gridwidth = 2;
        cons.weightx = 0.5;
        panelAux.add((Component)this.jLabelMsg, cons);
        panelAux.add(new JPanel());
        this.tableReq.addKeyListener(this);
        this.tableExa.addKeyListener(this);
        this.textRequisicao.addKeyListener(this);
        this.buttonFiltrar.addKeyListener(this);
        this.buttonCriarLote.addKeyListener(this);
        this.buttonCancelar.addKeyListener(this);
        this.buttonFechar.addKeyListener(this);
        this.buttonNovo.addKeyListener(this);
        this.criandoLote = true;
        this.habilitarDesabilitarBotoes();
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registro reg;
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)CriaLoteExportacao.this.getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)CriaLoteExportacao.this.getTopLevelAncestor(), glassPaneMensagem);
                if (CriaLoteExportacao.this.criandoLote && CriaLoteExportacao.this.tableReq.getSelectedRow() > -1 && (reg = CriaLoteExportacao.this.objectToReg(CriaLoteExportacao.this.tableReq.getSelectedRow())) != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
                CriaLoteExportacao.this.getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    private void marcaCheckDadosAdicionais() {
        String parametro = ParametrosUsuarios.getValor(CONFIRMAR_DADOS_ADICIONAIS);
        if (!Funcoes.textoVazio(parametro)) {
            this.checkConfirmarDadosAdicionais.setSelected(Boolean.valueOf(parametro));
        }
    }

    private void buscarRequisicaoAoPerdeFoco() {
        if (this.textRequisicao.getText().matches("\\d+")) {
            String original = this.textRequisicao.getText();
            DescritorCodigoEtiqueta de = DescritorCodigoEtiqueta.getDescritor(original);
            if (de != null) {
                new TuboDao();
                if (!TuboDao.contemCadastro(de)) {
                    Funcoes.mensagem(this, "A etiqueta \"" + original + "\" n\u00e3o est\u00e1 cadastrada", 1);
                    this.textRequisicao.selectAll();
                    return;
                }
            }
            if (de != null) {
                this.textRequisicao.setText(de.getRequisicao());
                this.adicionarRequisicao(de.getRequisicao(), de.getFilial(), de.getTubo());
            } else if (original.length() <= ParametrosGerais.getDigitosTuboRequisicao()) {
                this.adicionarRequisicao(this.textRequisicao.getText(), Variaveis.filialPadrao, "");
            } else {
                Funcoes.mensagem(this, "A etiqueta informada n\u00e3o foi localizada ou \u00e9 inv\u00e1lida.", 2);
            }
            this.atualizarModeloRequisicoes();
            TableUtil.selecionarLinha(this.tableReq, this.tableReq.getRowCount() - 1);
        }
        this.textRequisicao.setText("");
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void novoLote() {
        this.limpar();
        this.criandoLote = true;
    }

    private Registro objectToReg(int line) {
        Registro reg = new Registro();
        for (int i = 0; i < campos.length; ++i) {
            reg.setValor(campos[i], this.modReq.getValueAt(line, i));
        }
        return reg;
    }

    private Object[] RegToObj(Registro reg) {
        ArrayList<Object> req = new ArrayList<Object>();
        for (String key : campos) {
            req.add(reg.getValor(key));
        }
        return req.toArray();
    }

    private void trataCampoObservacao(List<Registro> requisicoes) {
        for (Registro registro : requisicoes) {
            String observacao = registro.getValor("req_obs", String.class);
            if (!Funcoes.textoVazio(observacao)) {
                observacao = StringUtil.removerAcentos(observacao).replaceAll("[^a-zA-Z1-9: ]", "");
            }
            registro.setValor("req_obs", observacao);
        }
    }

    public void exibirMsg() {
        this.jLabelMsg.setText("Requisi\u00e7\u00e3o pertence a outra filial.");
        this.jLabelMsg.setForeground(Color.RED);
    }

    private static /* synthetic */ Boolean lambda$adicionarRequisicao$4() throws Exception {
        try {
            Conexao.arquivaSQL();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum SituacaoReq {
        REQ_OK,
        REQ_JA_ADICIONADA,
        REQ_NAO_CADASTRADA,
        NAO_CONTEM_EXAMES,
        EXAMES_JA_EXPORTADOS,
        ETIQUETA_NAO_LOCALIZADA,
        ETIQUETA_JA_ADICIONADA;

    }
}

