/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ConferenciaDeLotesUtil {
    private static final String COD_COLETA = "cod_coleta";
    private static final String DES_COLETA = "des_coleta";
    private static final String COD_TRIAGEM = "cod_triagem";
    private static final String DES_TRIAGEM = "des_triagem";
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBO_TRIADO = "tuboTriado";

    public static boolean etiquetaJaConferida(DescritorCodigoEtiqueta dce) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select (a.err_datatriagem is not null) as conferido from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ").append(dce.getFilial());
                bui.append(" and a.req_codigo = ").append(dce.getRequisicao());
                bui.append(" and a.rec_codigo = ").append(dce.getTubo());
                bui.append(" and c.exr_excluido = false ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                return res.first() && res.getBoolean("conferido");
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaDeLotes: 791");
            }
        }
        return false;
    }

    public static String updateLoteApoioTriagem(Statement st, DescritorCodigoLote lote) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update loteapoio set lot_datahoratriagem = current_timestamp, lot_triagem = true, usr_codigo = '").append(Variaveis.login).append("'");
        if (null != lote && !Funcoes.textoVazio(lote.getCodigoLote())) {
            bui.append(" ,usr_codrecebeucaixa = '").append(Variaveis.login).append("', lot_datarecebeucaixa = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("'");
        }
        if (null != lote) {
            bui.append(" where fil_codigo = ").append(lote.getCodigoFilial());
            bui.append(" and con_codigo = ").append(lote.getCodigoConvenio());
            bui.append(" and lot_codigo = ").append(lote.getCodigoLote());
            bui.append(" and lot_datahoratriagem is null ");
            Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
        }
        return bui.toString();
    }

    public static ArrayList<Registro> carregaRequisicao(DescritorCodigoLote codigoLote, Statement st) throws SQLException {
        ArrayList<Registro> registros = new ArrayList<Registro>();
        StringBuilder bui = new StringBuilder();
        bui.setLength(0);
        bui.append("select a.req_codigo, b.lot_triagem, b.lot_caixaapoio, b.usr_codrecebeucaixa, b.lot_datarecebeucaixa, c.pac_nome from loteapoiorequisicao a ");
        bui.append(" left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
        bui.append(" left join requisicao req on a.req_codigo = req.req_codigo and a.fil_codigo = req.fil_codigo ");
        bui.append(" left join paciente c on req.fil_codigo = c.fil_codigo and req.pac_codigo = c.pac_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(codigoLote.getCodigoFilial());
        bui.append(" and b.lot_codigo = ");
        bui.append(codigoLote.getCodigoLote());
        bui.append(" and req.req_excluida = false ");
        String SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        if (res.next()) {
            do {
                Registro reg = new Registro();
                reg.setValor("lot_triagem", res.getBoolean("lot_triagem"));
                reg.setValor("lot_caixaapoio", res.getString("lot_caixaapoio"));
                reg.setValor("lot_datarecebeucaixa", res.getDate("lot_datarecebeucaixa"));
                reg.setValor("usr_codrecebeucaixa", res.getString("usr_codrecebeucaixa"));
                reg.setValor("req_codigo", res.getString("req_codigo"));
                reg.setValor("pac_nome", res.getString("pac_nome"));
                registros.add(reg);
            } while (res.next());
        }
        return registros;
    }

    public static String updateRequisicaoExameRecipienteTriagem(Statement st, Registro req, Registro exa, Registro col) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update examerequisicaorecipiente set err_datatriagem = current_timestamp, usr_codtriagem = '").append(Variaveis.login);
        bui.append("' where fil_codigo = ").append(req.getString("fil_codigo"));
        bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
        bui.append(" and exa_codigo = '").append(exa.getString("exa_codigo"));
        bui.append("' and mco_codigo = ").append(exa.getString("mco_codigo"));
        bui.append(" and rec_kodigo = ").append(col.getString(COD_COLETA));
        bui.append(" and err_datatriagem is null");
        Conexao.execute(req.getString("fil_codigo"), st, bui.toString());
        return bui.toString();
    }

    public static String updateExameRequisicaoTriagem(Statement st, Registro req, Registro exa) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update examerequisicao set exr_datatriagem = current_timestamp, usr_codtriagem = '").append(Variaveis.login);
        bui.append("' where fil_codigo = ").append(req.getString("fil_codigo"));
        bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
        bui.append(" and exa_codigo = '").append(exa.getString("exa_codigo"));
        bui.append("' and mco_codigo = ").append(exa.getString("mco_codigo"));
        bui.append(" and exr_datatriagem is null");
        Conexao.execute(req.getString("fil_codigo"), st, bui.toString());
        return bui.toString();
    }

    public static String updateRequisicaoComUsuario(Statement st, Registro req) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update requisicao set usr_codigo = '").append(Variaveis.login);
        bui.append("' ");
        bui.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
        Conexao.execute(req.getString("fil_codigo"), st, bui.toString());
        bui.setLength(0);
        bui.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
        bui.append(req.getString("fil_codigo"));
        bui.append(", ");
        bui.append(req.getString("req_codigo"));
        bui.append(", '");
        bui.append(Variaveis.login);
        bui.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
        Conexao.execute(req.getString("fil_codigo"), st, bui.toString());
        return bui.toString();
    }

    public static void updateExameRequisicaoSemSituacao(Registro reg, Statement st, String jejum, Date entrega, String dataEntrega) throws SQLException {
        StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '', exr_datamaterial = current_timestamp, ");
        bui.append("usr_codmaterial = '");
        bui.append(Variaveis.login);
        bui.append("', exr_dataentregaprev = ");
        if (entrega != null) {
            bui.append("'").append(dataEntrega).append("'");
        } else {
            bui.append("null");
        }
        bui.append(", exr_intervalojejum = ");
        if (!Funcoes.textoVazio(jejum)) {
            bui.append("'").append(jejum).append("'");
        } else {
            bui.append(" null ");
        }
        bui.append(" where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and req_codigo = ");
        bui.append(reg.getString("req_codigo"));
        bui.append(" and exa_codigo = '");
        bui.append(reg.getString("exa_codigo"));
        bui.append("' and mco_codigo = ");
        bui.append(reg.getString("mco_codigo"));
        DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "", false);
        Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
    }

    public static String updateRequisicaoRecoleta(Registro reg, Statement st, String motivo) throws SQLException {
        StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '");
        bui.append("R");
        bui.append("', exr_datarecoleta = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("', ");
        bui.append(" usr_codrecoleta = '").append(StringUtil.textoDB(Variaveis.login)).append("', ");
        bui.append(" exr_motivorecoleta = '").append(StringUtil.textoDB(motivo)).append("' ");
        bui.append(" where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and req_codigo = ");
        bui.append(reg.getString("req_codigo"));
        bui.append(" and exa_codigo = '");
        bui.append(reg.getString("exa_codigo"));
        bui.append("' and mco_codigo = ");
        bui.append(reg.getString("mco_codigo"));
        DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "R", false);
        String SQL = bui.toString();
        Conexao.execute(Variaveis.filialPadrao, st, SQL);
        return SQL;
    }

    public static Registro carregaRequisicaoEtiqueta(Statement st, String filial, String requisicao, ModeloResultSet modeloExa, ArrayList<DescritorCodigoEtiqueta> etqConferidas, ModeloResultSet modeloCol, ModeloResultSet modeloTri) throws Exception {
        String SQL = "";
        Registro reg = new Registro();
        StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, b.des_codigo, ");
        bui.append(" a.err_datatriagem, c.pac_nome, d.exa_descricao, l.mco_abreviatura, b.con_codigo, coalesce(b.req_urgente, false) as req_urgente, ");
        bui.append(" coalesce(a.rec_kodigo, a.rec_codigo) as ").append(COD_COLETA).append(", f.rec_descricao as ").append(DES_COLETA).append(",");
        bui.append(" h.rec_codigo as ").append(COD_TRIAGEM).append(", h.rec_descricao as ").append(DES_TRIAGEM).append(",");
        bui.append(" i.exr_situacao, i.exr_intervalojejum, i.exr_dataetqtriagem, j.prz_codigo, j.emc_solicitarjejum, coalesce(i.exr_urgente, false) as exr_urgente, coalesce(j.emc_materialcongelado, false) as emc_materialcongelado ");
        bui.append(" from examerequisicao i ");
        bui.append(" left join examerequisicaorecipiente a on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo and a.exa_codigo = i.exa_codigo and a.mco_codigo = i.mco_codigo");
        bui.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        bui.append(" left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo");
        bui.append(" left join exames d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo");
        bui.append(" left join recipcoleta e on a.fil_codigo = e.fil_codigo and a.rec_codigo = e.rec_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo");
        bui.append(" left join recipientes f on e.fil_codigo = f.fil_codigo and e.rec_codigo = f.rec_codigo");
        bui.append(" left join reciptriagem g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo");
        bui.append(" left join recipientes h on g.fil_codigo = h.fil_codigo and g.rec_codigo = h.rec_codigo");
        bui.append(" left join examematcoleta j on a.fil_codigo = j.fil_codigo and a.exa_codigo = j.exa_codigo and a.mco_codigo = j.mco_codigo");
        bui.append(" left join materialcoleta l on a.fil_codigo = l.fil_codigo and a.mco_codigo = l.mco_codigo");
        bui.append(" where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and i.exr_excluido = false and b.req_excluida = false ");
        bui.append(" order by d.exa_codigo, f.rec_codigo, h.rec_codigo");
        SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        if (res.first()) {
            reg.setValor("fil_codigo", res.getString("fil_codigo"));
            reg.setValor("req_codigo", res.getString("req_codigo"));
            reg.setValor("pac_nome", res.getString("pac_nome"));
            reg.setValor("req_urgente", res.getBoolean("req_urgente"));
            ArrayList<String> listExa = new ArrayList<String>();
            ArrayList<String> listCol = new ArrayList<String>();
            ArrayList<String> listTri = new ArrayList<String>();
            ModeloResultSet modExa = (ModeloResultSet)modeloExa.clone();
            ModeloResultSet modCol = null;
            ModeloResultSet modTri = null;
            do {
                Registro tmp;
                String obj;
                DescritorCodigoEtiqueta dce;
                if ((dce = ConferenciaDeLotesUtil.getEtiqueta(res.getString("fil_codigo"), res.getString("req_codigo"), res.getString(COD_COLETA))) != null && res.getObject("err_datatriagem") != null && !etqConferidas.contains(dce)) {
                    etqConferidas.add(dce);
                }
                if (!listExa.contains(obj = res.getString("exa_codigo") + res.getString("mco_codigo"))) {
                    tmp = new Registro();
                    tmp.setValor("fil_codigo", res.getString("fil_codigo"));
                    tmp.setValor("exa_codigo", res.getString("exa_codigo"));
                    tmp.setValor("mco_codigo", res.getObject("mco_codigo"));
                    tmp.setValor("mco_abreviatura", res.getString("mco_abreviatura"));
                    tmp.setValor("exa_descricao", res.getString("exa_descricao"));
                    tmp.setValor("exr_situacao", res.getString("exr_situacao"));
                    tmp.setValor("exr_intervalojejum", res.getString("exr_intervalojejum"));
                    modCol = (ModeloResultSet)modeloCol.clone();
                    tmp.setValor(MODELO_COLETA, modCol);
                    modTri = (ModeloResultSet)modeloTri.clone();
                    tmp.setValor(MODELO_TRIAGEM, modTri);
                    tmp.setValor("req_codigo", res.getString("req_codigo"));
                    tmp.setValor("prz_codigo", res.getString("prz_codigo"));
                    tmp.setValor("con_codigo", res.getString("con_codigo"));
                    tmp.setValor("emc_solicitarjejum", res.getBoolean("emc_solicitarjejum"));
                    tmp.setValor("codigoDestino", res.getString("des_codigo"));
                    tmp.setValor("exr_urgente", res.getBoolean("exr_urgente"));
                    tmp.setValor("emc_materialcongelado", res.getBoolean("emc_materialcongelado"));
                    modExa.addRegistro(tmp);
                    listExa.add(obj);
                    listCol.clear();
                    listTri.clear();
                }
                if ((obj = res.getString(COD_COLETA)) != null && !listCol.contains(obj) && modCol != null) {
                    tmp = new Registro();
                    tmp.setValor(COD_COLETA, obj);
                    tmp.setValor(DES_COLETA, res.getString(DES_COLETA));
                    tmp.setValor(TUBO_CONFERIDO, res.getObject("err_datatriagem") != null);
                    modCol.addRegistro(tmp);
                    listCol.add(obj);
                }
                if ((obj = res.getString(COD_TRIAGEM)) == null || listTri.contains(obj) || modTri == null) continue;
                tmp = new Registro();
                tmp.setValor(COD_TRIAGEM, obj);
                tmp.setValor(DES_TRIAGEM, res.getString(DES_TRIAGEM));
                tmp.setValor(TUBO_TRIADO, res.getObject("exr_dataetqtriagem") != null);
                modTri.addRegistro(tmp);
                listTri.add(obj);
            } while (res.next());
            reg.setValor(MODELO_EXAMES, modExa);
        }
        return reg;
    }

    public static DescritorCodigoEtiqueta getEtiqueta(String filial, String requisicao, String tubo) {
        StringBuilder bui = new StringBuilder(StringUtil.preencheString(filial, ParametrosGerais.getDigitosTuboFilial(), '0', 1));
        bui.append(StringUtil.preencheString(requisicao, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
        bui.append(StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
        return DescritorCodigoEtiqueta.getDescritor(bui.toString());
    }

    public static boolean loteCadastrado(DescritorCodigoLote dcl, String tipoBase) throws Exception {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            StringBuilder bui = new StringBuilder("select fil_codigo from loteapoio where fil_codigo = ");
            bui.append(dcl.getCodigoFilial());
            bui.append(" and con_codigo = ").append(dcl.getCodigoConvenio());
            bui.append(" and lot_codigo = ").append(dcl.getCodigoLote());
            SQL = bui.toString();
            return Conexao.executeQuery(st, SQL).first();
        }
        return false;
    }

    public static boolean loteContemRequisicoes(DescritorCodigoLote dcl) throws Exception {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            StringBuilder bui = new StringBuilder("select a.req_codigo from loteapoiorequisicao a ");
            bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
            bui.append(" left join requisicao req on a.req_codigo = req.req_codigo and a.fil_codigo = req.fil_codigo ");
            bui.append("where a.fil_codigo = ");
            bui.append(dcl.getCodigoFilial());
            bui.append(" and b.con_codigo = ").append(dcl.getCodigoConvenio());
            bui.append(" and b.lot_codigo = ").append(dcl.getCodigoLote());
            bui.append(" and req.req_excluida = false ");
            SQL = bui.toString();
            return Conexao.executeQuery(st, SQL).first();
        }
        return false;
    }

    public static boolean loteContemEtiquetas(DescritorCodigoLote dcl) throws Exception {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            StringBuilder bui = new StringBuilder("select a.rec_codigo from examerequisicaorecipiente a ");
            bui.append("left join loteapoiorequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            bui.append("left join loteapoio d on a.fil_codigo = b.fil_codigo and b.lot_id = d.lot_id ");
            bui.append("where b.fil_codigo = ").append(dcl.getCodigoFilial());
            bui.append(" and d.con_codigo = ").append(dcl.getCodigoConvenio());
            bui.append(" and d.lot_codigo = ").append(dcl.getCodigoLote());
            bui.append(" and c.exr_excluido = false ");
            SQL = bui.toString();
            return Conexao.executeQuery(st, SQL).first();
        }
        return false;
    }

    public static boolean contemCadastro(DescritorCodigoEtiqueta dce) throws Exception {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            StringBuilder bui = new StringBuilder("select a.fil_codigo from examerequisicaorecipiente a ");
            bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            bui.append("where a.fil_codigo = ");
            bui.append(dce.getFilial());
            bui.append(" and a.req_codigo = ");
            bui.append(dce.getRequisicao());
            bui.append(" and (a.rec_codigo = ").append(dce.getTubo()).append(" or a.rec_kodigo = ").append(dce.getTubo()).append(") ");
            bui.append(" and c.exr_excluido = false ");
            SQL = bui.toString();
            return Conexao.executeQuery(st, SQL).first();
        }
        return false;
    }

    public static List<DescritorCodigoLote> getLoteRequisicao(String filial, String requisicao) throws Exception {
        Statement st = Conexao.getStatement();
        ArrayList<DescritorCodigoLote> lotes = new ArrayList<DescritorCodigoLote>();
        String SQL = "";
        if (st != null) {
            StringBuilder bui = new StringBuilder();
            bui.append("select b.pac_codigo, b.con_codigo, b.lot_codigo, c.fil_tipobase from loteapoiorequisicao a ");
            bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
            bui.append("left join filiais_postocoleta c on a.fil_codigo = c.fil_codigo ");
            bui.append("where a.fil_codigo = ").append(filial);
            bui.append(" and a.req_codigo = ").append(requisicao);
            SQL = bui.toString();
            ResultSet res = Conexao.executeQuery(st, SQL);
            while (res.next()) {
                String codigoConvenio = res.getString("con_codigo");
                lotes.add(new DescritorCodigoLote(filial, res.getString("lot_codigo"), codigoConvenio));
            }
        }
        return lotes;
    }

    public static List<String> getTuboDeConferidas(String filial, String requisicao, Statement st, String sql) throws Exception {
        ArrayList<String> conf = new ArrayList<String>();
        StringBuilder bui = new StringBuilder("select distinct a.rec_codigo, (a.err_datatriagem is not null) as conferido ");
        bui.append("from examerequisicaorecipiente a ");
        bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and c.req_codigo = ").append(requisicao);
        sql = bui.toString();
        ResultSet res = Conexao.executeQuery(st, sql);
        while (res.next()) {
            if (!res.getBoolean("conferido")) continue;
            conf.add(res.getString("rec_codigo"));
        }
        return conf;
    }

    public static List<String> getTuboDeConferidas(String filial, String requisicao, Statement st) throws Exception {
        StringBuilder bui = new StringBuilder("select distinct a.rec_codigo, (a.err_datatriagem is not null) as conferido ");
        bui.append("from examerequisicaorecipiente a ");
        bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and c.req_codigo = ").append(requisicao);
        ResultSet res = Conexao.executeQuery(st, bui.toString());
        ArrayList<String> conferidos = new ArrayList<String>();
        while (res.next()) {
            if (!res.getBoolean("conferido")) continue;
            conferidos.add(res.getString("rec_codigo"));
        }
        return conferidos;
    }

    public static List<Object[]> getTubos(String filial, String requisicao, Statement st, String sql) throws Exception {
        ArrayList<Object[]> conf = new ArrayList<Object[]>();
        StringBuilder bui = new StringBuilder("select distinct a.rec_codigo, (a.err_datatriagem is not null) as conferido ");
        bui.append("from examerequisicaorecipiente a ");
        bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and c.req_codigo = ").append(requisicao);
        sql = bui.toString();
        ResultSet res = Conexao.executeQuery(st, sql);
        while (res.next()) {
            conf.add(new Object[]{res.getString("rec_codigo"), res.getBoolean("conferido")});
        }
        return conf;
    }

    public static HashMap<Integer, StringBuilder> getExameDeConferidas(String filial, String requisicao, Statement st, String sql) throws Exception {
        HashMap<Integer, StringBuilder> tmp = new HashMap<Integer, StringBuilder>();
        StringBuilder bui = new StringBuilder();
        bui.append("select coalesce(a.rec_kodigo, a.rec_codigo) as rec_codigo, b.exa_descricao, c.mco_abreviatura ");
        bui.append("from examerequisicaorecipiente a ");
        bui.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("left join examerequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and d.exr_excluido = false ");
        sql = bui.toString();
        ResultSet res = Conexao.executeQuery(st, sql);
        while (res.next()) {
            Integer tubo = res.getInt("rec_codigo");
            StringBuilder exa = tmp.get(tubo);
            if (exa == null) {
                exa = new StringBuilder();
                tmp.put(tubo, exa);
            } else {
                if (exa.indexOf("<html>") == -1) {
                    exa.insert(0, "<html>");
                }
                exa.append("<br>");
            }
            exa.append(res.getString("exa_descricao")).append(" (");
            exa.append(res.getString("mco_abreviatura")).append(")");
        }
        return tmp;
    }

    public static String getBaseWeb(Statement st, String SQL) throws Exception {
        StringBuilder bui = new StringBuilder();
        bui.append("select fil_baseweb from filiais_postocoleta where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            return rs.getString("fil_baseweb");
        }
        return null;
    }

    public static void updateRequisicaoFaltaMaterial(Statement st, Registro reg) throws Exception {
        String SQL = "";
        StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '");
        bui.append("F");
        bui.append("', exr_datamaterial = null, usr_codmaterial = null, exr_dataentregaprev = null, exr_intervalojejum = null where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and req_codigo = ");
        bui.append(reg.getString("req_codigo"));
        bui.append(" and exa_codigo = '");
        bui.append(reg.getString("exa_codigo"));
        bui.append("' and mco_codigo = ");
        bui.append(reg.getString("mco_codigo"));
        DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "F", false);
        SQL = bui.toString();
        Conexao.execute(Variaveis.filialPadrao, st, SQL);
    }

    public static String getDescricaoConvenio(DescritorCodigoLote dcl, String tipoBase) throws Exception {
        Statement st = Conexao.getStatement();
        if (st != null && dcl != null) {
            StringBuilder bui = new StringBuilder();
            bui.append("select con_fantasia as nome from convenios");
            bui.append(" where fil_codigo = ").append(dcl.getCodigoFilial());
            bui.append(" and con_codigo = ").append(dcl.getCodigoConvenio());
            ResultSet res = Conexao.executeQuery(st, bui.toString());
            if (res.next()) {
                bui.delete(0, bui.length());
                bui.append(" ");
                bui.append(dcl.getCodigoLote());
                bui.append(" - ");
                bui.append(res.getString("nome"));
                return bui.toString();
            }
        }
        return "";
    }

    public static String getTipoFilial() throws Exception {
        Statement st = Conexao.getStatement();
        String SQL = "";
        String tipoBase = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select fil_tipobase from filiais_postocoleta");
        bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        if (res.next()) {
            tipoBase = res.getString("fil_tipobase");
        }
        return tipoBase;
    }

    public static Registro getInformacoesLote(DescritorCodigoLote lote) throws Exception {
        Registro reg = new Registro();
        StringBuilder bui = new StringBuilder("select a.lot_codigo, a.lot_datahora, b.con_fantasia from loteapoio a ");
        bui.append(" inner join convenios b on a.con_codigo = b.con_codigo and b.fil_codigo = a.fil_codigo ");
        bui.append(" where a.fil_codigo = ").append(lote.getCodigoFilial());
        bui.append(" and a.lot_codigo = ").append(lote.getCodigoLote());
        ResultSet res = Conexao.executeQuery(Conexao.getStatement(), bui.toString());
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor("lot_datahora", Funcoes.formataData(reg.getDate("lot_datahora")));
            reg.setValor("con_fantasia", reg.getString("con_fantasia"));
        }
        return reg;
    }

    public static Registro getInformacoesLote(String lote) throws Exception {
        Registro reg = new Registro();
        StringBuilder bui = new StringBuilder("select a.lot_codigo, a.lot_datahora, b.con_fantasia, a.con_codigo, a.lot_datahoratriagem from loteapoio a ");
        bui.append(" inner join convenios b on a.con_codigo = b.con_codigo and b.fil_codigo = a.fil_codigo ");
        bui.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and a.lot_codigo = ").append(lote);
        ResultSet res = Conexao.executeQuery(Conexao.getStatement(), bui.toString());
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor("lot_codigo", lote);
            reg.setValor("lot_datahora", Funcoes.formataData(reg.getDate("lot_datahora")));
            reg.setValor("con_fantasia", reg.getString("con_fantasia"));
            reg.setValor("con_codigo", reg.getString("con_codigo"));
            reg.setValor("fil_codigo", Variaveis.filialPadrao);
            reg.setValor("lot_datahoratriagem", Funcoes.formataData(reg.getDate("lot_datahoratriagem")));
        }
        return reg;
    }

    public static String buscaExameTriagem(Statement st, StringBuilder bui, Registro req, ModeloResultSet modExa) throws Exception {
        bui.delete(0, bui.length());
        bui.append("select (exr_dataetqtriagem is not null) as exametriado, exa_codigo, mco_codigo from examerequisicao ");
        bui.append("where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and req_codigo = ");
        bui.append(req.getString("req_codigo"));
        bui.append(" and exr_excluido = false ");
        String SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        block0: while (res.next()) {
            for (Registro exa : modExa.getRegistros()) {
                if (!exa.getValor("exa_codigo").equals(res.getObject("exa_codigo")) || !exa.getValor("mco_codigo").equals(res.getObject("mco_codigo"))) continue;
                exa.setValor(TUBO_TRIADO, res.getBoolean("exametriado"));
                continue block0;
            }
        }
        return SQL;
    }
}

