/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesUtil;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class ConferenciaDeLotesFiltroLoteUtil {
    private static final String SELECIONADO = "selecionado";

    public static List<Registro> pesquisarLotes(String[] lotes, String[] convenios, TTextField txtDataInicial, TTextField txtDataFinal, TTextField txtHoraInicial, TTextField txtHoraFinal, boolean checkApresentarLotesRecebidos) throws Exception {
        int i;
        String aux;
        String filtros = "select a.fil_codigo, a.lot_codigo, a.con_codigo, a.lot_datahora, a.lot_datahoratriagem, b.con_fantasia from loteapoio a  inner join convenios b on a.con_codigo = b.con_codigo and b.fil_codigo = a.fil_codigo  where a.fil_codigo = " + Variaveis.filialPadrao;
        if (lotes != null) {
            aux = "";
            for (i = 0; lotes != null && i < lotes.length; ++i) {
                aux = aux.length() > 0 ? aux + ", " + lotes[i] : lotes[i];
            }
            if (!Funcoes.textoVazio(aux)) {
                filtros = filtros.concat(" and a.lot_codigo in (").concat(aux).concat(")");
            }
        }
        if (convenios != null) {
            aux = "";
            for (i = 0; convenios != null && i < convenios.length; ++i) {
                aux = aux.length() > 0 ? aux + ", " + convenios[i] : convenios[i];
            }
            if (!Funcoes.textoVazio(aux)) {
                filtros = filtros.concat(" and a.con_codigo in (").concat(aux).concat(")");
            }
        }
        if (!txtDataInicial.getText().isEmpty() && Funcoes.verificaData(txtDataInicial.getText())) {
            filtros = filtros.concat(" and CAST(a.lot_datahora AS DATE) >= '").concat(Funcoes.formataData("yyyy-MM-dd", txtDataInicial.getText())).concat("'");
        }
        if (!txtDataFinal.getText().isEmpty() && Funcoes.verificaData(txtDataFinal.getText())) {
            filtros = filtros.concat(" and CAST(a.lot_datahora AS DATE) <= '").concat(Funcoes.formataData("yyyy-MM-dd", txtDataFinal.getText())).concat("'");
        }
        if (!txtHoraInicial.getText().isEmpty() && Funcoes.verificaHora(txtHoraInicial.getText())) {
            filtros = filtros.concat(" and CAST(a.lot_datahora AS TIME) >= '").concat(txtHoraInicial.getText()).concat("'");
        }
        if (!txtHoraFinal.getText().isEmpty() && Funcoes.verificaHora(txtHoraFinal.getText())) {
            filtros = filtros.concat(" and CAST(a.lot_datahora AS TIME) <= '").concat(txtHoraFinal.getText()).concat("'");
        }
        if (!checkApresentarLotesRecebidos) {
            filtros = filtros.concat(" and a.lot_datarecebeucaixa is null ");
        }
        String SQL = "";
        Statement st = Conexao.getStatement();
        ArrayList<Registro> registros = new ArrayList<Registro>();
        SQL = filtros.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        if (res.next()) {
            do {
                Registro reg = new Registro(res);
                reg.setValor(SELECIONADO, false);
                String dataHora = null != res.getTimestamp("lot_datahora") ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(res.getTimestamp("lot_datahora")) : "";
                reg.setValor("lot_datahora", dataHora);
                String dataHoraTriagem = null != res.getTimestamp("lot_datahoratriagem") ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(res.getTimestamp("lot_datahoratriagem")) : "";
                reg.setValor("lot_datahoratriagem", dataHoraTriagem);
                DescritorCodigoLote dcl = new DescritorCodigoLote(res.getString("fil_codigo"), res.getString("lot_codigo"), res.getString("con_codigo"));
                if (!ConferenciaDeLotesUtil.loteContemEtiquetas(dcl) || !ConferenciaDeLotesUtil.loteContemRequisicoes(dcl)) continue;
                registros.add(reg);
            } while (res.next());
        }
        return registros;
    }
}

