/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio.util;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.recepcao.util.SolicitarJejum;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.triagem.LoteFilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ConferenciaDeLotesCarregaLoteUtil {
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private static final String COD_COLETA = "cod_coleta";
    private static final String DES_COLETA = "des_coleta";
    private static final String COD_TRIAGEM = "cod_triagem";
    private static final String DES_TRIAGEM = "des_triagem";
    private static final String TUBO_TRIADO = "tuboTriado";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBOS_OK = "tubosOk";
    private String carregaExamestempoJejum = "";
    private Boolean carregaExamesJejum = false;
    public static final ModeloResultSet modeloExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat.", "mco_abreviatura", "Exame", "exa_descricao", "Sit", "exr_situacao");
    public static final ModeloResultSet modeloCol = new ModeloResultSet("C\u00f3digo", "cod_coleta", "Descri\u00e7\u00e3o", "des_coleta");
    public static final ModeloResultSet modeloTri = new ModeloResultSet("C\u00f3digo", "cod_triagem", "Descri\u00e7\u00e3o", "des_triagem");
    private LoteFilialService loteFilialService;
    private boolean recebeAutomatico;

    public ConferenciaDeLotesCarregaLoteUtil(LoteFilialService loteFilialService, boolean recebeAutomatico) {
        this.loteFilialService = loteFilialService;
        this.recebeAutomatico = recebeAutomatico;
    }

    public Registro carregarLote(String codigoLote, ArrayList<DescritorCodigoEtiqueta> etqConferidas, boolean isExibiuJejum, String tempoJejum, String requisicao, List<String> tubos) {
        Registro lote = this.getInformacoesLote(codigoLote);
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                DescritorCodigoLote dcl = new DescritorCodigoLote(lote.getString("fil_codigo"), lote.getString("lot_codigo"), lote.getString("con_codigo"));
                lote = this.validarLote(dcl, lote);
                if (lote != null) {
                    this.adicionarRequisicao(dcl, dcl.getCodigoFilial(), etqConferidas, lote, isExibiuJejum, tempoJejum, requisicao, tubos);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaDeLotesCarregaLoteUtil: 834");
            }
        }
        return lote;
    }

    private void adicionarRequisicao(DescritorCodigoLote lote, String filial, ArrayList<DescritorCodigoEtiqueta> etqConferidas, Registro regLote, boolean isExibiuJejum, String tempoJejum, String codReqDigitada, List<String> tubos) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                ArrayList<Registro> registros = ConferenciaDeLotesUtil.carregaRequisicao(lote, st);
                ArrayList<Registro> requisicoes = new ArrayList<Registro>();
                for (Registro reg : registros) {
                    boolean requisicaoConf = codReqDigitada != null && reg.getString("req_codigo").equals(codReqDigitada);
                    Registro req = this.carregaRequisicaoEtiqueta(st, filial, reg.getString("req_codigo"), etqConferidas, isExibiuJejum, tempoJejum, requisicaoConf, tubos, codReqDigitada);
                    req.setValor("lot_triagem", reg.getBoolean("lot_triagem"));
                    req.setValor("lot_caixaapoio", reg.getString("lot_caixaapoio"));
                    req.setValor("lot_datarecebeucaixa", reg.getDate("lot_datarecebeucaixa"));
                    req.setValor("usr_codrecebeucaixa", reg.getString("usr_codrecebeucaixa"));
                    req.setValor("req_codigo", reg.getString("req_codigo"));
                    req.setValor("pac_nome", reg.getString("pac_nome"));
                    if (requisicaoConf) {
                        req.setValor(TUBOS_OK, true);
                    }
                    requisicoes.add(req);
                }
                regLote.setValor("requisicoes", requisicoes);
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaDeLotesCarregaLoteUtil: 630");
            }
        }
    }

    private Registro carregaRequisicaoEtiqueta(Statement st, String filial, String requisicao, ArrayList<DescritorCodigoEtiqueta> etqConferidas, boolean isExibiuJejum, String tempoJejum, boolean requisicaoConf, List<String> tubos, String codReqDigitada) {
        String SQL = "";
        Registro reg = new Registro();
        StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, b.des_codigo, a.rec_codigo, ");
        bui.append(" a.err_datatriagem, c.pac_nome, d.exa_descricao, l.mco_abreviatura, b.con_codigo, coalesce(b.req_urgente, false) as req_urgente, ");
        bui.append(" coalesce(a.rec_kodigo, a.rec_codigo) as ").append(COD_COLETA).append(", f.rec_descricao as ").append(DES_COLETA).append(",");
        bui.append(" h.rec_codigo as ").append(COD_TRIAGEM).append(", h.rec_descricao as ").append(DES_TRIAGEM).append(",");
        bui.append(" i.exr_situacao, i.exr_intervalojejum, i.exr_dataetqtriagem, j.prz_codigo, j.emc_solicitarjejum, coalesce(i.exr_urgente, false) as exr_urgente, coalesce(j.emc_materialcongelado, false) as emc_materialcongelado ");
        bui.append(" from examerequisicao i ");
        bui.append(" left join examerequisicaorecipiente a on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo and a.exa_codigo = i.exa_codigo and a.mco_codigo = i.mco_codigo");
        bui.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        bui.append(" left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo");
        bui.append(" left join exames d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo");
        bui.append(" left join recipcoleta e on a.fil_codigo = e.fil_codigo and a.rec_codigo = e.rec_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo");
        bui.append(" left join recipientes f on a.fil_codigo = f.fil_codigo and a.rec_codigo = f.rec_codigo");
        bui.append(" left join reciptriagem g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo");
        bui.append(" left join recipientes h on g.fil_codigo = h.fil_codigo and g.rec_codigo = h.rec_codigo");
        bui.append(" left join examematcoleta j on a.fil_codigo = j.fil_codigo and a.exa_codigo = j.exa_codigo and a.mco_codigo = j.mco_codigo");
        bui.append(" left join materialcoleta l on a.fil_codigo = l.fil_codigo and a.mco_codigo = l.mco_codigo");
        bui.append(" where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and i.exr_excluido = false and b.req_excluida = false ");
        bui.append(" order by d.exa_codigo, f.rec_codigo, h.rec_codigo");
        try {
            SQL = bui.toString();
            ResultSet res = Conexao.executeQuery(st, SQL);
            if (res.first()) {
                reg.setValor("fil_codigo", res.getString("fil_codigo"));
                reg.setValor("req_codigo", res.getString("req_codigo"));
                reg.setValor("pac_nome", res.getString("pac_nome"));
                reg.setValor("req_urgente", res.getBoolean("req_urgente"));
                ArrayList listExa = new ArrayList();
                ModeloResultSet modExa = (ModeloResultSet)modeloExa.clone();
                ModeloResultSet modCol = (ModeloResultSet)modeloCol.clone();
                ModeloResultSet modTri = (ModeloResultSet)modeloTri.clone();
                do {
                    DescritorCodigoEtiqueta dce;
                    if ((dce = ConferenciaDeLotesUtil.getEtiqueta(res.getString("fil_codigo"), res.getString("req_codigo"), res.getString(COD_COLETA))) != null && res.getObject("err_datatriagem") != null && !etqConferidas.contains(dce)) {
                        etqConferidas.add(dce);
                    }
                    boolean tuboOk = false;
                    if (!tubos.isEmpty()) {
                        for (String tubo : tubos) {
                            if (!tubo.equals(res.getString("rec_codigo"))) continue;
                            tuboOk = true;
                            break;
                        }
                    }
                    boolean tubosOk = this.carregaEtiquetasColeta(res, modCol, requisicaoConf, tuboOk);
                    this.carregaEtiquetasTriagem(res, modTri, requisicaoConf, tuboOk);
                    this.carregaExames(res, listExa, modExa, modCol, modTri, isExibiuJejum, tempoJejum, tubosOk, requisicaoConf, codReqDigitada, tubos);
                    reg.setValor(MODELO_EXAMES, modExa);
                    reg.setValor(TUBOS_OK, tubosOk);
                    modCol = (ModeloResultSet)modeloCol.clone();
                    modTri = (ModeloResultSet)modeloTri.clone();
                } while (res.next());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaLoteFiltroLote: 198");
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receberMaterial(Registro reg, boolean isExibiuJejum, String tempoJejum) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        String jejum = "";
        if (st != null && reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            try {
                String dataEntrega;
                Date entrega = ExameUtil.calculaDataEntrega(Variaveis.filialPadrao, reg.getString("prz_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("con_codigo"), reg.getString("codigoDestino"));
                String string = dataEntrega = entrega != null ? Funcoes.formataData("MM/dd/yyyy HH:mm", entrega) : null;
                if (this.isSolicitarJejum(reg)) {
                    jejum = reg.getString("exr_intervalojejum");
                    if (!isExibiuJejum && !this.carregaExamesJejum.booleanValue()) {
                        tempoJejum = jejum = this.solicitarJejum(jejum);
                        isExibiuJejum = true;
                        reg.setValor("exr_intervalojejum", jejum);
                        this.carregaExamesJejum = isExibiuJejum;
                        this.carregaExamestempoJejum = tempoJejum;
                    } else {
                        jejum = tempoJejum;
                        if (jejum != null) {
                            jejum = this.carregaExamestempoJejum;
                        }
                    }
                }
                ConferenciaDeLotesUtil.updateExameRequisicaoSemSituacao(reg, st, jejum, entrega, dataEntrega);
                Optional<Date> dataEntregaRequisicaoOpt = this.buscarDataEntregaRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"));
                if (entrega != null && dataEntregaRequisicaoOpt.isPresent() && dataEntregaRequisicaoOpt.get().before(entrega)) {
                    this.atualizarDataEntregaPrevRequisicao(st, entrega, reg.getString("fil_codigo"), reg.getString("req_codigo"));
                }
                if (this.exportarParaWeb()) {
                    this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "", "dataColetaExameRequisicao", Funcoes.formataData("dd/MM/yyyy", new Date()), "horaColetaExameRequisicao", Funcoes.formataData("HH:mm", new Date()));
                }
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                reg.setValor("exr_intervalojejum", jejum);
                reg.setValor("exr_dataentregaprev", dataEntrega);
                reg.setValor("usr_codmaterial", Variaveis.login);
                reg.setValor("exr_situacao", "");
                reg.setValor("exr_datamaterial", new Date());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 879");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void alterarExameRequisicaoWeb(Statement st, Registro reg, String ... campos) throws Exception {
        String baseWeb = this.getBaseWeb();
        if (baseWeb != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(reg.getString("exa_codigo"));
            tmp.add("materialExameRequisicao");
            tmp.add(reg.getString("mco_codigo"));
            tmp.add("dataEnvioExameRequisicao");
            tmp.add("current_timestamp");
            for (String campo : campos) {
                tmp.add(campo);
            }
            DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexame", "A", true, tmp.toArray(new String[tmp.size()]));
        }
    }

    private String getBaseWeb() {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                return ConferenciaDeLotesUtil.getBaseWeb(st, SQL);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 957");
            }
        }
        return null;
    }

    private boolean exportarParaWeb() throws SQLException {
        FilialService filService = new FilialService();
        Statement st = Conexao.getStatement();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, Variaveis.filialPadrao);
        if (Funcoes.carregouVO(filialVO)) {
            return Funcoes.isExportarBaseWeb(filialVO);
        }
        return false;
    }

    private boolean isSolicitarJejum(Registro reg) {
        return reg.getBoolean("emc_solicitarjejum");
    }

    private String solicitarJejum(String tempoJejum) {
        SolicitarJejum sj = SolicitarJejum.novaInstancia(Laboratorio.getInstancia());
        if (sj != null) {
            sj.setTempoJejum(tempoJejum);
            sj.setVisible(true);
            return sj.getTempoJejum().trim();
        }
        return "";
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaLote: 907");
        }
    }

    private void carregaEtiquetasTriagem(ResultSet res, ModeloResultSet modTri, boolean requisicaoConf, boolean tuboOk) throws SQLException {
        String obj = res.getString(COD_TRIAGEM);
        if (obj != null && modTri != null) {
            Registro tmp = new Registro();
            tmp.setValor(COD_TRIAGEM, obj);
            tmp.setValor(DES_TRIAGEM, res.getString(DES_TRIAGEM));
            tmp.setValor(TUBO_TRIADO, res.getObject("exr_dataetqtriagem") != null);
            tmp.setValor(TUBOS_OK, res.getObject("exr_dataetqtriagem") != null || requisicaoConf && tuboOk);
            modTri.addRegistro(tmp);
        }
    }

    private boolean carregaEtiquetasColeta(ResultSet res, ModeloResultSet modCol, boolean requisicaoConf, boolean tuboOk) throws SQLException {
        String obj = res.getString(COD_COLETA);
        if (obj != null && modCol != null) {
            Registro tmp = new Registro();
            tmp.setValor(COD_COLETA, obj);
            tmp.setValor(DES_COLETA, res.getString(DES_COLETA));
            tmp.setValor(TUBO_CONFERIDO, res.getObject("err_datatriagem") != null);
            tmp.setValor(TUBOS_OK, res.getObject("err_datatriagem") != null || requisicaoConf && tuboOk);
            modCol.addRegistro(tmp);
            return res.getObject("err_datatriagem") != null;
        }
        return false;
    }

    private void carregaExames(ResultSet res, ArrayList listExa, ModeloResultSet modExa, ModeloResultSet modCol, ModeloResultSet modTri, boolean isExibiuJejum, String tempoJejum, Boolean tubosOk, boolean requisicaoConf, String codReqDigitada, List<String> tubos) throws SQLException {
        String exameCodigo = res.getString("exa_codigo");
        String mcocodigo = res.getString("mco_codigo");
        String filcodigo = res.getString("fil_codigo");
        String codColeta = res.getString(COD_COLETA);
        String obj = exameCodigo + mcocodigo;
        if (!listExa.contains(obj)) {
            Registro tmp = new Registro();
            tmp.setValor("fil_codigo", res.getString("fil_codigo"));
            tmp.setValor("exa_codigo", res.getString("exa_codigo"));
            tmp.setValor("mco_codigo", res.getObject("mco_codigo"));
            tmp.setValor("mco_abreviatura", res.getString("mco_abreviatura"));
            tmp.setValor("exa_descricao", res.getString("exa_descricao"));
            tmp.setValor("exr_situacao", res.getString("exr_situacao"));
            tmp.setValor("exr_intervalojejum", res.getString("exr_intervalojejum"));
            tmp.setValor(MODELO_COLETA, modCol);
            tmp.setValor(MODELO_TRIAGEM, modTri);
            tmp.setValor("req_codigo", res.getString("req_codigo"));
            tmp.setValor("prz_codigo", res.getString("prz_codigo"));
            tmp.setValor("con_codigo", res.getString("con_codigo"));
            tmp.setValor("emc_solicitarjejum", res.getBoolean("emc_solicitarjejum"));
            tmp.setValor("codigoDestino", res.getString("des_codigo"));
            tmp.setValor("exr_urgente", res.getBoolean("exr_urgente"));
            tmp.setValor("emc_materialcongelado", res.getBoolean("emc_materialcongelado"));
            tmp.setValor(TUBOS_OK, tubosOk != false || requisicaoConf);
            if (this.recebeAutomatico && res.getString("exr_situacao").equals("F")) {
                if (codReqDigitada != null && res.getString("req_codigo").equals(codReqDigitada)) {
                    this.receberMaterial(tmp, isExibiuJejum, tempoJejum);
                } else {
                    for (String tubo : tubos) {
                        if (!tubo.equals(codColeta) || codReqDigitada == null || codReqDigitada.length() <= res.getString("req_codigo").length() || !this.getNumRequisicaoFromEtiqueta(codReqDigitada).equals(res.getString("req_codigo"))) continue;
                        this.receberMaterial(tmp, isExibiuJejum, tempoJejum);
                    }
                }
            }
            modExa.addRegistro(tmp);
            listExa.add(obj);
        } else {
            Registro registro = modExa.getRegistros().stream().filter(a -> a.getString("exa_codigo").equals(exameCodigo) && a.getString("fil_codigo").equals(filcodigo) && a.getString("mco_codigo").equals(mcocodigo)).findAny().get();
            modCol.getRegistros().forEach(r -> {
                if (((ModeloResultSet)registro.getValor(MODELO_COLETA)).getRegistros().stream().noneMatch(m -> m.getString(COD_COLETA).equals(r.getString(COD_COLETA)))) {
                    ((ModeloResultSet)modExa.getRegistros().stream().filter(a -> a.getString("exa_codigo").equals(exameCodigo) && a.getString("fil_codigo").equals(filcodigo) && a.getString("mco_codigo").equals(mcocodigo)).findAny().get().getValor(MODELO_COLETA)).addRegistro((Registro)r);
                }
            });
            modTri.getRegistros().forEach(r -> {
                if (((ModeloResultSet)registro.getValor(MODELO_TRIAGEM)).getRegistros().stream().noneMatch(m -> m.getString(COD_TRIAGEM).equals(r.getString(COD_TRIAGEM)))) {
                    ((ModeloResultSet)modExa.getRegistros().stream().filter(a -> a.getString("exa_codigo").equals(exameCodigo) && a.getString("fil_codigo").equals(filcodigo) && a.getString("mco_codigo").equals(mcocodigo)).findAny().get().getValor(MODELO_TRIAGEM)).addRegistro((Registro)r);
                }
            });
        }
    }

    private String getNumRequisicaoFromEtiqueta(String etiqueta) {
        String numReq = etiqueta.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        return StringUtil.removeZerosEsquerda(numReq);
    }

    private Registro validarLote(DescritorCodigoLote codigoLote, Registro lote) throws Exception {
        ArrayList<String> requisicoesExcluidas;
        String tipoBase = ConferenciaDeLotesUtil.getTipoFilial();
        if (tipoBase == null) {
            throw new Exception("Filial n\u00e3o encontrada");
        }
        if (!Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && tipoBase.equalsIgnoreCase("A")) {
            lote = null;
            Funcoes.mensagem(Laboratorio.getInstancia(), "O lote \"" + codigoLote.getCodigoLote() + "\" \u00e9 do tipo Alimentos", 1);
        }
        if (!this.loteCadastrado(codigoLote, tipoBase)) {
            lote = null;
            Funcoes.mensagem(Laboratorio.getInstancia(), "O lote \"" + codigoLote.getCodigoLote() + "\" n\u00e3o est\u00e1 cadastrado", 1);
        }
        if (!this.loteContemRequisicoes(codigoLote)) {
            lote = null;
            Funcoes.mensagem(Laboratorio.getInstancia(), "O lote \"" + codigoLote.getCodigoLote() + "\" n\u00e3o cont\u00e9m requisi\u00e7\u00f5es cadastradas", 1);
        }
        if (!this.loteContemEtiquetas(codigoLote)) {
            lote = null;
            Funcoes.mensagem(Laboratorio.getInstancia(), "O lote \"" + codigoLote.getCodigoLote() + "\" n\u00e3o cont\u00e9m etiquetas cadastradas", 1);
        }
        if ((requisicoesExcluidas = this.loteFilialService.getRequisicoesExcluidasLote(codigoLote, tipoBase)) != null) {
            lote = null;
            Funcoes.mensagem(Laboratorio.getInstancia(), "Algumas requisi\u00e7\u00f5es do lote " + codigoLote.getCodigoLote() + " foram exclu\u00eddas.\nC\u00f3digos: " + StringUtil.implode(requisicoesExcluidas, ", ") + ".", 2);
        }
        return lote;
    }

    private boolean loteCadastrado(DescritorCodigoLote dcl, String tipoBase) {
        try {
            return ConferenciaDeLotesUtil.loteCadastrado(dcl, tipoBase);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaDeLotes: 1257");
            return false;
        }
    }

    private boolean loteContemRequisicoes(DescritorCodigoLote dcl) {
        try {
            return ConferenciaDeLotesUtil.loteContemRequisicoes(dcl);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaDeLotes: 1267");
            return false;
        }
    }

    private boolean loteContemEtiquetas(DescritorCodigoLote dcl) {
        try {
            return ConferenciaDeLotesUtil.loteContemEtiquetas(dcl);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ConferenciaDeLotes: 1282");
            return false;
        }
    }

    private void carregaExamesRequisicao(Registro req) {
        boolean tubosOk = true;
        ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
        if (modExa != null) {
            for (Registro exa : modExa.getRegistros()) {
                if (exa.getBoolean(TUBOS_OK)) continue;
                tubosOk = false;
                break;
            }
        }
        req.setValor(TUBOS_OK, tubosOk);
    }

    private Registro getInformacoesLote(String lote) {
        Registro reg = new Registro();
        try {
            reg = ConferenciaDeLotesUtil.getInformacoesLote(lote);
            return reg;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return reg;
        }
    }

    public Optional<Date> buscarDataEntregaRequisicao(String codFilial, String codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder("select req_dataentregaprev from requisicao");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        Optional<Date> dataEntrega = Optional.empty();
        if (rs.next()) {
            dataEntrega = Optional.of(rs.getDate("req_dataentregaprev"));
        }
        ConexaoTemporaria.fecharStatement(st);
        return dataEntrega;
    }

    public void atualizarDataEntregaPrevRequisicao(Statement st, Date dataEntregaPrev, String codFilial, String codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder("update requisicao set ");
        sql.append(" req_dataentregaprev = '").append(Funcoes.formataData("yyyy-MM-dd", dataEntregaPrev)).append("'");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        Conexao.execute(Variaveis.filialPadrao, st, sql.toString());
    }
}

