/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio.conferencialote;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.apoio.conferencialote.ConferenciaLoteDao;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;

public class ConferenciaLoteService {
    private ConferenciaLoteDao dao = new ConferenciaLoteDao();

    public void receberMaterial(String jejum, Registro regExame) throws Exception {
        Statement st = Conexao.getStatement();
        try {
            this.gravarLogExameSituacaoExameRequisicao(st, regExame);
            Optional<Date> dataEntregaOpt = this.getDataEntrega(regExame);
            if (dataEntregaOpt.isPresent()) {
                this.dao.atualizarJejumEEntregaNoExame(st, Funcoes.formataData("MM/dd/yyyy HH:mm", dataEntregaOpt.get()), jejum, regExame);
                this.atualizarDataEntregaRequisicao(st, dataEntregaOpt.get(), regExame.getString("fil_codigo"), regExame.getString("req_codigo"));
            } else {
                ConferenciaDeLotesUtil.updateExameRequisicaoSemSituacao(regExame, st, jejum, null, null);
            }
            this.alterarExameRequisicaoWeb(st, regExame, "situacaoExameRequisicao", "", "dataColetaExameRequisicao", Funcoes.formataData("dd/MM/yyyy", new Date()), "horaColetaExameRequisicao", Funcoes.formataData("HH:mm", new Date()));
            ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(regExame.getString("req_codigo")), regExame.getString("exa_codigo"), regExame.getInt("mco_codigo"), "U", "U");
            Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, regExame.getString("req_codigo"), regExame.getString("exa_codigo"), regExame.getString("mco_codigo"));
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    private void atualizarDataEntregaRequisicao(Statement st, Date dataEntregaExame, String codFilial, String codRequisicao) throws SQLException {
        Optional<Date> dataEntregaRequisicaoOpt = this.dao.buscarDataEntregaRequisicao(codFilial, codRequisicao);
        if (dataEntregaRequisicaoOpt.isPresent() && dataEntregaRequisicaoOpt.get().before(dataEntregaExame)) {
            this.dao.atualizarDataEntregaPrevRequisicao(st, dataEntregaExame, codFilial, codRequisicao);
        }
    }

    private void gravarLogExameSituacaoExameRequisicao(Statement st, Registro regExame) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, regExame.getString("req_codigo"), regExame.getString("exa_codigo"), regExame.getString("mco_codigo"), "", false);
    }

    private Optional<Date> getDataEntrega(Registro regExame) throws SQLException {
        Date entrega = ExameUtil.calculaDataEntrega(Variaveis.filialPadrao, regExame.getString("prz_codigo"), regExame.getString("exa_codigo"), regExame.getString("mco_codigo"), regExame.getString("con_codigo"), regExame.getString("codigoDestino"));
        return entrega != null ? Optional.of(entrega) : Optional.empty();
    }

    public void alterarExameRequisicaoWeb(Statement st, Registro reg, String ... campos) throws Exception {
        String baseWeb;
        if (this.exportarParaWeb() && (baseWeb = this.dao.getBaseWeb()) != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(reg.getString("exa_codigo"));
            tmp.add("materialExameRequisicao");
            tmp.add(reg.getString("mco_codigo"));
            tmp.add("dataEnvioExameRequisicao");
            tmp.add("current_timestamp");
            for (String campo : campos) {
                tmp.add(campo);
            }
            DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexame", "A", true, tmp.toArray(new String[tmp.size()]));
        }
    }

    private boolean exportarParaWeb() throws SQLException {
        FilialService filService = new FilialService();
        Statement st = Conexao.getStatement();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, Variaveis.filialPadrao);
        if (Funcoes.carregouVO(filialVO)) {
            return Funcoes.isExportarBaseWeb(filialVO);
        }
        return false;
    }
}

