/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio.conferencialote;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.AdicionaMensagem;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.recepcao.util.SolicitarJejum;
import jalis.laboratorio.recepcao.util.SolicitarMotivoRecoleta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.laboratorio.triagem.apoio.DialogoExamesRequisicao;
import jalis.laboratorio.triagem.apoio.DialogoRequisicaoIncompleta;
import jalis.laboratorio.triagem.apoio.conferencialote.ConferenciaLoteService;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.model.bean.estoque.EstoqueManualBean;
import jalis.model.bean.estoque.EstoqueManualMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.bean.triagem.MaterialIdentificadoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.EstoqueManualVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.EstoqueManualService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.service.recepcao.ExameRequisicaoRecipienteService;
import jalis.service.triagem.LoteFilialService;
import jalis.service.triagem.MaterialIdentificadoService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.Legenda;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ConferenciaLote
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener,
FocusListener,
TableCellRenderer {
    public static final Color COR_LIDO = new Color(180, 255, 180);
    public static final Color COR_TRIADO = new Color(130, 235, 255);
    private static final String RECEBER_AUTOMATICO = "ConferenciaLote.receberAutomatico";
    private static final int IMPR_REQ = 0;
    private static final int IMPR_EXA = 1;
    private static final int ETQ_TRIAGEM = 0;
    private static final int ETQ_COLETA = 1;
    private static final String IMPR_INCOMPLETO = "imprimirIncompleto";
    private static final String REIMPRIMIR = "reimprimir";
    private static final String TUBO_LIDO = "tuboLido";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBO_TRIADO = "tuboTriado";
    private static final String TUBOS_OK = "tubosOk";
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private static final String COD_COLETA = "cod_coleta";
    private static final String DES_COLETA = "des_coleta";
    private static final String COD_TRIAGEM = "cod_triagem";
    private static final String DES_TRIAGEM = "des_triagem";
    private static Border bordaSimples = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static Border bordaSelecionada = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final JLabel labelRenderer = new JLabel();
    private static final ModeloResultSet modeloExa;
    private static final ModeloResultSet modeloCol;
    private static final ModeloResultSet modeloTri;
    private ModeloResultSet modeloReq = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome");
    private ModeloResultSet modeloReqOutro = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome");
    private JTextField textLote = new TTextField(20, 1);
    private JTextField textTubo = new TTextField(12, 1);
    private JLabel labelConvenio = new JLabel();
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloReq, (ListSelectionListener)this, new int[0]);
    private JTable tableReqOutroLote = ComponenteFactory.novoJTable((TableModel)this.modeloReqOutro, (ListSelectionListener)this, new int[0]);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)modeloExa, (ListSelectionListener)this, new int[0]);
    private JTable tableColeta = ComponenteFactory.novoJTable((TableModel)modeloCol, (ListSelectionListener)this, new int[0]);
    private JTable tableTriagem = ComponenteFactory.novoJTable(modeloTri);
    private JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es", 'O', this, null, null, false);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Conferir", 'C', this, null, null);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonBuscaLote = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkAutomatico = ComponenteFactory.novoJCheckBox("Receber material autom\u00e1tico", this);
    private JPanel panelOutroLote;
    private JPanel panelCaixa = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Caixa"));
    private JLabel labelCaixa = new JLabel("Caixa recebida");
    private JButton buttonCaixa = ComponenteFactory.novoJButton("Receber caixa", this);
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JMenuItem subImprimirTodos = ComponenteFactory.novoJMenu(this.menuImprimir, "Imprimir Todos", '\u0000');
    private JMenuItem subImprimir = ComponenteFactory.novoJMenu(this.menuImprimir, "", '\u0000');
    private JMenuItem itemImprimirTodosColeta = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirTodosTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirTodosMapa = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Mapa", (ActionListener)this);
    private JMenuItem itemImprimirColeta = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirTriagem = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirMapa = ComponenteFactory.novoJMenuItem(this.subImprimir, "Mapa", (ActionListener)this);
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemAdicionarMensagem = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Adicionar mensagem", (ActionListener)this);
    private JMenuItem itemReceberMaterial = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Receber material", (ActionListener)this);
    private JMenuItem itemMarcarMaterialFaltante = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como material faltante", (ActionListener)this);
    private JMenuItem itemMarcarRecoleta = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como recoleta", (ActionListener)this);
    private Legenda panelLegenda = new Legenda(10);
    private ImageIcon imagemCongelado = ImagemUtils.carregaImagemJalis("congelado.gif");
    private ArrayList<DescritorCodigoEtiqueta> etqLidas = new ArrayList();
    private ArrayList<DescritorCodigoEtiqueta> etqConferidas = new ArrayList();
    private DescritorCodigoLote codigoLote;
    private ArrayList<DescritorCodigoLote> outrosLotes = new ArrayList();
    private int referenciaImpressao = 0;
    private JTable tableReqImpressao = this.tableRequisicoes;
    private boolean acessoMarcarMaterialFaltante;
    private boolean acessoReceberMaterial;
    private boolean acessoMarcarRecoleta;
    private boolean conferindoLote;
    private boolean loteSalvo;
    private boolean isExibiuJejum = false;
    private String tempoJejum = "";
    private boolean caixaRecebida = false;
    private String etiquetaCaixaRecebida = null;
    private LoteFilialService loteFilialService = new LoteFilialService();
    private ExameRequisicaoRecipienteService exameRequisicaoRecipienteService = new ExameRequisicaoRecipienteService();
    private ConferenciaLoteService service = new ConferenciaLoteService();

    public ConferenciaLote() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return 300400300L;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        value = value == null ? "" : value;
        labelRenderer.setText(value.toString());
        if (table != null) {
            Color back;
            Color fore;
            boolean ok;
            labelRenderer.setFont(table.getFont());
            labelRenderer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getColor("Table.gridColor")));
            ModeloResultSet mod = (ModeloResultSet)table.getModel();
            Registro reg = mod.getRegistro(row);
            Color corTmp = COR_TRIADO;
            boolean bl = ok = this.isNotNull(reg) && reg.getBoolean(TUBO_TRIADO);
            if (!ok) {
                ok = this.isNotNull(reg) && (table == this.tableColeta && (reg.getBoolean(TUBO_CONFERIDO) || reg.getBoolean(TUBO_LIDO)) || reg.getBoolean(TUBOS_OK));
                corTmp = COR_LIDO;
            }
            Color color = fore = isSelected ? table.getSelectionForeground() : table.getForeground();
            if (table == this.tableRequisicoes && reg.getBoolean("req_urgente")) {
                Color color2 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            if (table == this.tableExames && reg.getBoolean("exr_urgente")) {
                Color color3 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            Color color4 = isSelected ? (ok ? ScreenUtil.escurecerCor(corTmp, 30) : table.getSelectionBackground()) : (back = ok ? corTmp : table.getBackground());
            if (table == this.tableExames && column != 2) {
                if (column == 3) {
                    labelRenderer.setToolTipText(Tipos.tipoSituacaoExame(value.toString()));
                }
                labelRenderer.setHorizontalAlignment(0);
            } else {
                labelRenderer.setToolTipText(table.getToolTipText());
                labelRenderer.setHorizontalAlignment(table != this.tableExames && column == 0 ? 0 : 2);
            }
            if (table == this.tableExames && column == 1 && reg.getBoolean("emc_materialcongelado")) {
                labelRenderer.setHorizontalTextPosition(10);
                labelRenderer.setIcon(this.imagemCongelado);
            } else {
                labelRenderer.setIcon(null);
            }
            if (back == COR_LIDO || isSelected) {
                labelRenderer.setBorder(bordaSimples);
            }
            labelRenderer.setBackground(back);
            labelRenderer.setForeground(fore);
        }
        return labelRenderer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block50: {
            try {
                MaterialIdentificadoBean matIdent;
                Object o = e.getSource();
                if (o == this.buttonBuscaLote) {
                    this.pesquisarLote();
                    break block50;
                }
                if (o == this.buttonFechar) {
                    if (this.getParent() != null) {
                        this.getParent().removeAll();
                    }
                    this.setVisible(false);
                    break block50;
                }
                if (o == this.buttonNovo) {
                    if (this.verificaMateriaisRecebidos()) {
                        this.limpaCampos();
                        this.habilitarDesabilitarBotoes();
                        this.revalidate();
                        this.repaint();
                        ScreenUtil.requisitarFoco(this.textLote);
                    }
                    break block50;
                }
                if (o == this.buttonSalvar) {
                    String mensagem = "O lote n\u00e3o est\u00e1 completamente conferido. Deseja marcar como conferido?";
                    if (this.todasRequisicoesCompletas() || Funcoes.mensagem(this, mensagem, 4) == 0) {
                        this.salvarLote();
                    }
                    break block50;
                }
                if (o == this.buttonImprimir) {
                    this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() - this.menuImprimir.getPreferredSize().height - 1);
                    break block50;
                }
                if (o == this.buttonOpcoes) {
                    this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - this.menuOpcoes.getPreferredSize().height - 1);
                    break block50;
                }
                if (o == this.itemMarcarMaterialFaltante) {
                    int row = this.tableExames.getSelectedRow();
                    ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
                    Registro reg = mod.getRegistro(row);
                    if (this.isNotNull(reg)) {
                        this.marcarMaterialFaltante(reg);
                        reg.setValor("exr_situacao", "F");
                        reg.setValor("exr_intervalojejum", "");
                        mod.fireTableDataChanged();
                        this.tableExames.setRowSelectionInterval(row, row);
                    }
                    break block50;
                }
                if (o == this.itemMarcarRecoleta) {
                    int row = this.tableExames.getSelectedRow();
                    ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
                    Registro reg = mod.getRegistro(row);
                    if (this.isNotNull(reg)) {
                        this.marcarRecoleta(reg);
                        mod.fireTableDataChanged();
                        this.tableExames.setRowSelectionInterval(row, row);
                    }
                    break block50;
                }
                if (o == this.itemReceberMaterial) {
                    int tamanhoCompleto;
                    int row = this.tableExames.getSelectedRow();
                    ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
                    Registro reg = mod.getRegistro(row);
                    String codigoEtiqueta = this.exameRequisicaoRecipienteService.retornaCodigoEtiqueta(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                    if (this.verificaTamanhoTubo(codigoEtiqueta, tamanhoCompleto = this.validaTamanhoTubo())) {
                        this.adicionarEtiqueta(codigoEtiqueta, true);
                        this.isExibiuJejum = false;
                        this.tempoJejum = "";
                        mod.fireTableDataChanged();
                    }
                    this.habilitarDesabilitarBotoes();
                    break block50;
                }
                if (o == this.itemAdicionarMensagem) {
                    this.adicionarMensagem();
                    break block50;
                }
                if (o == this.itemImprimirTriagem || o == this.itemImprimirColeta) {
                    if (this.referenciaImpressao == 0) {
                        this.imprimirRequisicoes(this.tableReqImpressao.getSelectedRows(), o == this.itemImprimirTriagem ? 0 : 1);
                    } else if (this.referenciaImpressao == 1) {
                        this.imprimirExames(this.tableExames.getSelectedRows(), o == this.itemImprimirTriagem ? 0 : 1);
                    }
                    break block50;
                }
                if (o == this.itemImprimirTodosTriagem || o == this.itemImprimirTodosColeta) {
                    if (this.referenciaImpressao == 0) {
                        this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableReqImpressao.getRowCount()), o == this.itemImprimirTodosTriagem ? 0 : 1);
                    } else if (this.referenciaImpressao == 1) {
                        this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExames.getRowCount()), o == this.itemImprimirTodosTriagem ? 0 : 1);
                    }
                    break block50;
                }
                if (o == this.itemImprimirMapa) {
                    try {
                        if (this.referenciaImpressao == 0) {
                            for (int linha : this.tableRequisicoes.getSelectedRows()) {
                                String codigoFilial = this.modeloReq.getRegistro(linha).getString("fil_codigo");
                                String codigoRequisicao = this.modeloReq.getRegistro(linha).getString("req_codigo");
                                Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
                            }
                        } else if (this.referenciaImpressao == 1) {
                            String codigoFilial = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("fil_codigo");
                            String codigoRequisicao = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("req_codigo");
                            String[] exame = new String[]{};
                            int[] material = new int[]{};
                            for (int linha : this.tableExames.getSelectedRows()) {
                                int codigoMaterial = ((ModeloResultSet)this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getValor(MODELO_EXAMES)).getRegistro(linha).getInt("mco_codigo");
                                exame = ArraysUtil.concatenar(exame, new String[]{((ModeloResultSet)this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getValor(MODELO_EXAMES)).getRegistro(linha).getString("exa_codigo")});
                                material = ArraysUtil.concatenar(material, new int[]{ExameUtil.getDadosMaterial(codigoFilial, codigoMaterial).getCodigo()});
                            }
                            Impressao.imprimirMapa(codigoFilial, codigoRequisicao, exame, material, true, false, -1);
                        }
                        break block50;
                    }
                    catch (Exception ex) {
                        Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
                    }
                    break block50;
                }
                if (o == this.itemImprimirTodosMapa) {
                    if (this.referenciaImpressao == 0) {
                        for (Registro registro : this.modeloReq.getRegistros()) {
                            String codigoFilial = registro.getString("fil_codigo");
                            String codigoRequisicao = registro.getString("req_codigo");
                            try {
                                Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
                            }
                            catch (Exception ex) {
                                Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
                            }
                        }
                    } else if (this.referenciaImpressao == 1) {
                        String codigoFilial = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("fil_codigo");
                        String codigoRequisicao = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("req_codigo");
                        try {
                            Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
                        }
                        catch (Exception ex) {
                            Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
                        }
                    }
                    break block50;
                }
                if (o == this.checkAutomatico) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ParametrosUsuarios.setValor(ConferenciaLote.RECEBER_AUTOMATICO, String.valueOf(ConferenciaLote.this.checkAutomatico.isSelected()));
                            ParametrosUsuarios.salvarParametros(true);
                        }
                    });
                    break block50;
                }
                if (o != this.buttonCaixa || this.etiquetaCaixaRecebida == null || (matIdent = this.buscarDadosEtiqueta(this.etiquetaCaixaRecebida)) == null) break block50;
                matIdent.setDataRetorno(new Date());
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                matIdent.setUsuarioRetorno(usuario);
                int resp = Funcoes.mensagem(this, "O material \u00e9 reutiliz\u00e1vel?", 4, true);
                try {
                    new MaterialIdentificadoService().gravaAutoCopiaSemCommit(matIdent, 1, Variaveis.filialPadrao, null);
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    if (resp == 1) {
                        EstoqueManualBean estoqueManual = new EstoqueManualBean();
                        estoqueManual.setFilial(filial);
                        estoqueManual.setDataHora(new Date());
                        estoqueManual.setObservacao("Materiais inutilizados pelo recebimento de caixa - CONFERENCIA DE LOTE.");
                        estoqueManual.setUsuario(usuario);
                        EstoqueManualMaterialBean mat = new EstoqueManualMaterialBean();
                        mat.setFilial(filial);
                        mat.setCelula(matIdent.getCelula());
                        mat.setEstoqueManual((EstoqueManualVO)estoqueManual.toVO());
                        mat.setMaterial(matIdent.getMaterial());
                        mat.setQuantidade(1.0);
                        mat.setTipoOperacao("N");
                        ArrayList<EstoqueManualMaterialBean> listaMat = new ArrayList<EstoqueManualMaterialBean>();
                        listaMat.add(mat);
                        estoqueManual.setMateriais(listaMat);
                        new EstoqueManualService().gravaAutoCopiaSemCommit(estoqueManual, 0, Variaveis.filialPadrao, null, null);
                    } else {
                        TransfEstoqueBean transf = new TransfEstoqueBean();
                        transf.setFilial(filial);
                        transf.setCelulaOrigem(matIdent.getCelula());
                        transf.setCelulaDestino(this.pegaCelulaPadraoEstacao());
                        transf.setDataHora(new Date());
                        transf.setOrigem("R");
                        transf.setUsuario(usuario);
                        TransfEstoqueMaterialBean auxMat = new TransfEstoqueMaterialBean();
                        auxMat.setFilial(filial);
                        auxMat.setMaterial(matIdent.getMaterial());
                        auxMat.setQuantidade(1.0);
                        ArrayList<TransfEstoqueMaterialBean> listaMat = new ArrayList<TransfEstoqueMaterialBean>();
                        listaMat.add(auxMat);
                        transf.setMateriais(listaMat);
                        new TransfEstoqueService().gravaAutoCopiaSemCommit(transf, 0, Variaveis.filialPadrao, null);
                        new TransfEstoqueService().conciliaTransferencia(transf);
                    }
                    Conexao.arquivaSQL();
                    this.buttonCaixa.setEnabled(false);
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaLote: 259");
            }
        }
    }

    private boolean verificaMateriaisRecebidos() {
        for (int i = 0; i < this.modeloReq.getRowCount(); ++i) {
            Registro reg = this.modeloReq.getRegistro(i);
            ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
            if (!this.isNotNull(modExa)) continue;
            for (Registro exa : modExa.getRegistros()) {
                if (!exa.getBoolean(TUBOS_OK)) continue;
                return Funcoes.mensagem(this, "As informa\u00e7\u00f5es alteradas ser\u00e3o perdidas, Deseja continuar?", 4) == 0;
            }
        }
        return true;
    }

    private void limpaCampos() {
        this.isExibiuJejum = false;
        this.tempoJejum = "";
        this.limparModelos();
        this.textLote.setText("");
        this.labelConvenio.setText("");
        this.panelOutroLote.setVisible(false);
        this.panelCaixa.setVisible(false);
        this.conferindoLote = false;
        this.loteSalvo = false;
        this.caixaRecebida = false;
        this.buttonOpcoes.setEnabled(false);
    }

    private boolean verificaTamanhoTubo(String codigoEtiqueta, int tamanhoCompleto) {
        return codigoEtiqueta.length() == tamanhoCompleto;
    }

    private int validaTamanhoTubo() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    private CelulaEstoqueVO pegaCelulaPadraoEstacao() {
        try {
            return (CelulaEstoqueVO)new CelulaEstoqueService().getCelulaPadraoEstacao(Variaveis.filialPadrao).toVO();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private MaterialIdentificadoBean buscarDadosEtiqueta(String etiqueta) {
        if (etiqueta != null && !Funcoes.textoVazio(etiqueta)) {
            int qtdeFilial = MaterialIdentificadoBean.QTDE_CARAC_FILIAL;
            int qtdeCelula = MaterialIdentificadoBean.QTDE_CARAC_CELULA;
            int qtdeMaterial = MaterialIdentificadoBean.QTDE_CARAC_MATERIAL;
            if (etiqueta.length() == qtdeFilial + qtdeCelula + qtdeMaterial) {
                String filial = etiqueta.substring(0, qtdeFilial);
                String celula = etiqueta.substring(qtdeFilial, qtdeFilial + qtdeCelula);
                String codigo = etiqueta.substring(qtdeFilial + qtdeCelula, qtdeFilial + qtdeCelula + qtdeMaterial);
                MaterialIdentificadoBean matBean = null;
                try {
                    matBean = (MaterialIdentificadoBean)new MaterialIdentificadoService().getBean(filial, celula, codigo);
                    if (matBean != null && matBean.getDataRetorno() != null) {
                        Funcoes.mensagem(this, "A etiqueta j\u00e1 foi recebida.", 2);
                        return null;
                    }
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "Erro ao carregar dados da etiqueta. - " + e.getMessage(), e.getStackTrace());
                    return null;
                }
                return matBean;
            }
            Funcoes.mensagem(this, "Etiqueta incorreta.", 2);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        block19: {
            Object o;
            block17: {
                block18: {
                    o = e.getSource();
                    if (o != this.textLote) break block17;
                    if (e.getKeyCode() != 10) break block18;
                    SplashMensagem splash = SplashMensagem.getInstancia(this);
                    try {
                        splash.mostrar("Selecionando requisi\u00e7\u00f5es do lote, aguarde...");
                        this.conferindoLote = this.carregarLote(this.textLote.getText());
                        if (this.conferindoLote) {
                            this.habilitarDesabilitarBotoes();
                        } else {
                            this.textLote.setText("");
                        }
                        splash.apagar();
                        ScreenUtil.requisitarFoco(this.conferindoLote ? this.textTubo : this.textLote);
                    }
                    catch (Throwable throwable) {
                        splash.apagar();
                        ScreenUtil.requisitarFoco(this.conferindoLote ? this.textTubo : this.textLote);
                        throw throwable;
                    }
                    break block19;
                }
                if (e.getKeyCode() == 113) {
                    this.pesquisarLote();
                }
                break block19;
            }
            if (o == this.textTubo && e.getKeyCode() == 10) {
                int tamanhoCompleto;
                String tmp = this.textTubo.getText();
                if (this.verificaTamanhoTubo(tmp, tamanhoCompleto = this.validaTamanhoTubo())) {
                    this.adicionarEtiqueta(tmp, this.checkAutomatico.isSelected());
                    this.isExibiuJejum = false;
                    this.tempoJejum = "";
                } else if (tmp.length() <= ParametrosGerais.getDigitosTuboRequisicao() && tmp.length() > 0) {
                    this.selecionarExamesRequisicao(this.codigoLote.getCodigoFilial(), StringUtil.removeZerosEsquerda(tmp), this.checkAutomatico.isSelected());
                } else if (tmp.length() > tamanhoCompleto || tmp.length() > ParametrosGerais.getDigitosTuboRequisicao() && tmp.length() < tamanhoCompleto) {
                    Funcoes.mensagem(this, "O c\u00f3digo \"" + tmp + "\" n\u00e3o \u00e9 v\u00e1lido", 1);
                }
                this.textTubo.setText("");
                this.tableRequisicoes.repaint();
                this.tableReqOutroLote.repaint();
                this.tableExames.repaint();
                this.tableColeta.repaint();
                ScreenUtil.requisitarFoco(this.textTubo);
                this.habilitarDesabilitarBotoes();
            } else if (o == this.tableRequisicoes && e.getKeyCode() == 39) {
                ScreenUtil.requisitarFoco(this.tableExames);
            } else if (o == this.tableExames && e.getKeyCode() == 37) {
                ScreenUtil.requisitarFoco(this.tableRequisicoes);
            } else if (!(!this.conferindoLote || o == this.textTubo || !Character.isDigit(e.getKeyChar()) || e.isAltDown() && e.isControlDown() && e.isShiftDown())) {
                this.textTubo.setText(String.valueOf(e.getKeyChar()));
                ScreenUtil.requisitarFoco(this.textTubo);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes || o == this.tableReqOutroLote || o == this.tableExames) {
            if (o == this.tableRequisicoes || o == this.tableReqOutroLote) {
                (o == this.tableRequisicoes ? this.tableReqOutroLote : this.tableRequisicoes).clearSelection();
            }
            JTable table = (JTable)o;
            table.setBorder(bordaSelecionada);
            this.tableReqImpressao = o == this.tableExames ? this.tableReqImpressao : (JTable)o;
            int n = this.referenciaImpressao = o == this.tableRequisicoes || o == this.tableReqOutroLote ? 0 : 1;
            if (o == this.tableRequisicoes || o == this.tableReqOutroLote) {
                ListSelectionModel model = table.getSelectionModel();
                this.valueChanged(new ListSelectionEvent(model, model.getMinSelectionIndex(), model.getMaxSelectionIndex(), false));
            }
            this.atualizarTextoBotaoImprimir(table);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes || o == this.tableReqOutroLote || o == this.tableExames) {
            JTable table = (JTable)o;
            table.setBorder(bordaSimples);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes.getSelectionModel() || o == this.tableReqOutroLote.getSelectionModel()) {
            JTable tableTemp = o == this.tableRequisicoes.getSelectionModel() ? this.tableRequisicoes : this.tableReqOutroLote;
            ModeloResultSet modTemp = (ModeloResultSet)tableTemp.getModel();
            if (tableTemp.getSelectedRowCount() > 1) {
                this.tableExames.setModel(modeloExa);
                this.tableColeta.setModel(modeloCol);
                this.tableTriagem.setModel(modeloTri);
            } else {
                ModeloResultSet mrs;
                Registro reg = modTemp.getRegistro(tableTemp.getSelectedRow());
                if (reg != null && (mrs = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) != null) {
                    this.tableExames.setModel(mrs);
                    if (mrs.getRowCount() > 0) {
                        this.tableExames.setRowSelectionInterval(0, 0);
                    }
                }
            }
            this.atualizarTextoBotaoImprimir(tableTemp);
        } else if (o == this.tableExames.getSelectionModel()) {
            ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
            if (modExa != null) {
                if (this.tableExames.getSelectedRowCount() > 1) {
                    this.tableColeta.setModel(modeloCol);
                    this.tableTriagem.setModel(modeloTri);
                } else {
                    ModeloResultSet mrs;
                    Registro reg = modExa.getRegistro(this.tableExames.getSelectedRow());
                    if (reg != null && (mrs = (ModeloResultSet)reg.getValor(MODELO_COLETA)) != null) {
                        this.tableColeta.setModel(mrs);
                        if (this.isNotNull(reg) && (mrs = (ModeloResultSet)reg.getValor(MODELO_TRIAGEM)) != null) {
                            this.tableTriagem.setModel(mrs);
                        }
                    }
                }
                this.habilitarOpcoes(modExa.getRegistro(this.tableExames.getSelectedRow()));
            }
            this.atualizarTextoBotaoImprimir(this.tableExames);
            this.redimensionarColunas();
        }
    }

    private boolean carregarLote(String codigoDozeDigitos) {
        return this.carregarLote(new DescritorCodigoLote(codigoDozeDigitos), codigoDozeDigitos);
    }

    private boolean carregarLote(DescritorCodigoLote codigoLote, String lote) {
        if (Funcoes.textoVazio(this.textLote)) {
            return false;
        }
        if (!codigoLote.isValido()) {
            Funcoes.mensagem(this, "O lote \"" + lote + "\" n\u00e3o \u00e9 v\u00e1lido", 1);
            return false;
        }
        this.codigoLote = codigoLote;
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                String tipoBase = "";
                StringBuilder bui = new StringBuilder();
                bui.append("select fil_tipobase from filiais_postocoleta");
                bui.append(" where fil_codigo = ").append(codigoLote.getCodigoFilial());
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                if (!res.next()) {
                    throw new Exception("Filial n\u00e3o encontrada");
                }
                tipoBase = res.getString("fil_tipobase");
                if (!Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && tipoBase.equalsIgnoreCase("A")) {
                    Funcoes.mensagem(this, "O lote \"" + lote + "\" \u00e9 do tipo Alimentos", 1);
                    return false;
                }
                if (!this.loteCadastrado(codigoLote, tipoBase)) {
                    Funcoes.mensagem(this, "O lote \"" + lote + "\" n\u00e3o est\u00e1 cadastrado", 1);
                    return false;
                }
                if (!this.loteContemRequisicoes(codigoLote, tipoBase)) {
                    Funcoes.mensagem(this, "O lote \"" + lote + "\" n\u00e3o cont\u00e9m requisi\u00e7\u00f5es cadastradas", 1);
                    return false;
                }
                if (!this.loteContemEtiquetas(codigoLote, tipoBase)) {
                    Funcoes.mensagem(this, "O lote \"" + lote + "\" n\u00e3o cont\u00e9m etiquetas cadastradas", 1);
                    return false;
                }
                ArrayList<String> requisicoesExcluidas = this.loteFilialService.getRequisicoesExcluidasLote(codigoLote, tipoBase);
                if (requisicoesExcluidas != null) {
                    Funcoes.mensagem(this, "Algumas requisi\u00e7\u00f5es do lote foram exclu\u00eddas.\nC\u00f3digos: " + StringUtil.implode(requisicoesExcluidas, ", ") + ".", 2);
                }
                bui.setLength(0);
                bui.append("select a.req_codigo, b.lot_triagem, b.lot_caixaapoio, b.usr_codrecebeucaixa, b.lot_datarecebeucaixa from loteapoiorequisicao a ");
                bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
                bui.append("where a.fil_codigo = ");
                bui.append(codigoLote.getCodigoFilial());
                bui.append(" and b.con_codigo = ");
                bui.append(codigoLote.getCodigoConvenio());
                bui.append(" and b.lot_codigo = ");
                bui.append(codigoLote.getCodigoLote());
                SQL = bui.toString();
                res = Conexao.executeQuery(st, SQL);
                if (res.next()) {
                    this.loteSalvo = res.getBoolean("lot_triagem");
                    this.controlaCamposCaixa(res.getString("lot_caixaapoio"), res.getDate("lot_datarecebeucaixa"), res.getString("usr_codrecebeucaixa"));
                    this.etiquetaCaixaRecebida = res.getString("lot_caixaapoio");
                    do {
                        this.adicionarRequisicao(this.modeloReq, codigoLote.getCodigoFilial(), res.getString("req_codigo"));
                    } while (res.next());
                }
                for (Registro req : this.modeloReq.getRegistros()) {
                    boolean tubosOk = true;
                    ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                    if (modExa != null) {
                        for (Registro exa : modExa.getRegistros()) {
                            if (exa.getBoolean(TUBOS_OK)) continue;
                            tubosOk = false;
                            break;
                        }
                    }
                    req.setValor(TUBOS_OK, tubosOk);
                }
                this.marcarExamesRequisicoesOk(this.modeloReq);
                if (this.tableRequisicoes.getRowCount() > 0) {
                    this.tableRequisicoes.setRowSelectionInterval(0, 0);
                    this.labelConvenio.setText(this.getDescricaoConvenio(codigoLote, tipoBase));
                    return true;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 429");
            }
        }
        return false;
    }

    private void adicionarEtiqueta(String etiqueta, boolean isReceberMaterial) {
        int i;
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
        if (dce == null) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida", 1);
            return;
        }
        if (!this.contemCadastro(dce)) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada", 1);
            return;
        }
        if (this.etqConferidas.contains(dce) && !isReceberMaterial) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi conferida", 2);
            return;
        }
        if (this.etqLidas.contains(dce) && !isReceberMaterial) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi adicionada", 2);
            return;
        }
        if (this.etqLidas.contains(dce) && isReceberMaterial) {
            this.etqLidas.remove(dce);
        }
        if (!this.modeloReq.contemValor("req_codigo", dce.requisicao) && this.etiquetaJaConferida(dce)) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi conferida em outro lote.", 2);
            return;
        }
        JTable tabela = this.tableRequisicoes;
        ModeloResultSet modelo = this.modeloReq;
        if (!this.modeloReq.contemValor("req_codigo", dce.requisicao)) {
            DescritorCodigoLote lote = this.getLoteRequisicao(dce.filial, dce.requisicao);
            if (lote == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A requisi\u00e7\u00e3o \"" + dce.requisicao + "\" n\u00e3o faz parte de um lote, e n\u00e3o ser\u00e1 adicionada.", 2);
                return;
            }
            if (!this.outrosLotes.contains(lote)) {
                this.outrosLotes.add(lote);
            }
            tabela = this.tableReqOutroLote;
            modelo = this.modeloReqOutro;
            if (!this.panelOutroLote.isVisible()) {
                this.panelOutroLote.setVisible(true);
                this.revalidate();
                this.repaint();
            }
        }
        ArrayList<DescritorCodigoEtiqueta> tmp = new ArrayList<DescritorCodigoEtiqueta>();
        tmp.add(dce);
        this.etqLidas.add(dce);
        this.confereRequisicao(dce.filial, dce.requisicao, tabela, modelo, tmp, isReceberMaterial);
        Integer[] guias = null;
        try {
            if (this.isAgrupaMultiguias(dce) && this.contemMultiguias(guias = RecepcaoUtil.verificaMultiGuias(dce.filial, dce.requisicao))) {
                for (i = 0; i < guias.length; ++i) {
                    this.confereRequisicao(dce.filial, String.valueOf(guias[i]), tabela, modelo, tmp, isReceberMaterial);
                }
            }
            guias = this.verificaAgrupaMultiguias(dce.filial, dce.requisicao);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        if (guias != null) {
            for (i = 0; i < guias.length; ++i) {
                this.confereRequisicao(dce.filial, String.valueOf(guias[i]), tabela, modelo, tmp, isReceberMaterial);
            }
        }
        ScreenUtil.requisitarFoco(tabela);
        this.marcarExamesRequisicoesOk(modelo);
        this.loteSalvo = false;
    }

    private boolean contemMultiguias(Integer[] guias) {
        return guias != null && guias.length > 0;
    }

    private boolean isAgrupaMultiguias(DescritorCodigoEtiqueta dce) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), dce.filial, dce.requisicao);
    }

    private Integer[] verificaAgrupaMultiguias(String filial, String requisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(filial, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(requisicao)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String filial, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, multiguias);
    }

    private void confereRequisicao(String filial, String requisicao, JTable tabela, ModeloResultSet modelo, ArrayList<DescritorCodigoEtiqueta> tmp, boolean isReceberMaterial) {
        int indice;
        if (!modelo.contemValor("req_codigo", requisicao)) {
            this.adicionarRequisicao(modelo, filial, requisicao);
            modelo.fireTableDataChanged();
        }
        if ((indice = modelo.getIndice("req_codigo", requisicao)) > -1) {
            tabela.setRowSelectionInterval(indice, indice);
        }
        this.conferirEtiquetas(tmp, modelo.getRegistro(indice), isReceberMaterial);
    }

    private void selecionarExamesRequisicao(String filial, String requisicao, boolean isReceberMaterial) {
        List conferidos = this.getTubosRequisicao(filial, requisicao);
        boolean todosConferidos = true;
        for (int i = 2; i < conferidos.size() && todosConferidos; i += 3) {
            if (((Boolean)conferidos.get(i)).booleanValue()) continue;
            todosConferidos = false;
        }
        if (conferidos.isEmpty()) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" n\u00e3o cont\u00e9m etiquetas cadastradas", 1);
        } else if (todosConferidos) {
            if (this.modeloReq.contemValor("req_codigo", requisicao)) {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" j\u00e1 est\u00e1 completamente conferida", 2);
            } else {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" j\u00e1 est\u00e1 completamente conferida em outro lote", 2);
            }
        } else {
            DialogoExamesRequisicao der = DialogoExamesRequisicao.novaInstancia(this.getTopLevelAncestor(), requisicao, conferidos);
            if (der != null) {
                der.setVisible(true);
                if (der.ok()) {
                    int indice;
                    JTable tabela = this.tableRequisicoes;
                    ModeloResultSet modelo = this.modeloReq;
                    DescritorCodigoLote lote = this.codigoLote;
                    if (!this.modeloReq.contemValor("req_codigo", requisicao)) {
                        lote = this.getLoteRequisicao(filial, requisicao);
                        if (lote == null) {
                            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o faz parte de um lote.", 2);
                            return;
                        }
                        if (!this.outrosLotes.contains(lote)) {
                            this.outrosLotes.add(lote);
                        }
                        tabela = this.tableReqOutroLote;
                        modelo = this.modeloReqOutro;
                        if (!modelo.contemValor("req_codigo", requisicao) && lote != null) {
                            this.adicionarRequisicao(modelo, lote.getCodigoFilial(), requisicao);
                            modelo.fireTableDataChanged();
                        }
                        if (!this.panelOutroLote.isVisible()) {
                            this.panelOutroLote.setVisible(true);
                            this.revalidate();
                            this.repaint();
                        }
                    }
                    if ((indice = modelo.getIndice("req_codigo", requisicao)) > -1) {
                        tabela.setRowSelectionInterval(indice, indice);
                    }
                    ArrayList<DescritorCodigoEtiqueta> etqs = new ArrayList<DescritorCodigoEtiqueta>();
                    for (String tubo : der.getSelecionados()) {
                        if (lote == null) continue;
                        DescritorCodigoEtiqueta dce = this.getEtiqueta(lote.getCodigoFilial(), requisicao, tubo);
                        this.etqLidas.add(dce);
                        etqs.add(dce);
                    }
                    this.conferirEtiquetas(etqs, modelo.getRegistro(indice), isReceberMaterial);
                    this.marcarExamesRequisicoesOk(modelo);
                    this.loteSalvo = false;
                }
            }
        }
    }

    private void conferirEtiquetas(List<DescritorCodigoEtiqueta> etqs, Registro regReq, boolean isReceberMaterial) {
        ModeloResultSet modExa;
        if (this.isNotNull(regReq) && this.isNotNull(modExa = (ModeloResultSet)regReq.getValor(MODELO_EXAMES))) {
            for (Registro exa : modExa.getRegistros()) {
                boolean contemTubo = false;
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (this.isNotNull(modCol)) {
                    for (Registro col : modCol.getRegistros()) {
                        if (!this.contemTubo(etqs, col.getString(COD_COLETA))) continue;
                        contemTubo = true;
                        col.setValor(TUBO_LIDO, Boolean.TRUE);
                    }
                }
                if (!contemTubo || !this.isMateriaNaoRecebido(exa) || !isReceberMaterial) continue;
                this.receberMaterial(exa);
                exa.setValor("exr_situacao", "");
            }
            this.habilitarOpcoes(modExa.getRegistro(this.tableExames.getSelectedRow()));
        }
    }

    private boolean isMateriaNaoRecebido(Registro exa) {
        return exa.getString("exr_situacao").equalsIgnoreCase("T") || exa.getString("exr_situacao").equalsIgnoreCase("R") || exa.getString("exr_situacao").equalsIgnoreCase("F");
    }

    private boolean isNotNull(Object obj) {
        return obj != null;
    }

    private boolean contemTubo(List<DescritorCodigoEtiqueta> etqs, String tubo) {
        for (DescritorCodigoEtiqueta dce : etqs) {
            if (!dce.getTubo().equalsIgnoreCase(tubo)) continue;
            return true;
        }
        return false;
    }

    private void adicionarRequisicao(ModeloResultSet modReq, String filial, String requisicao) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null && modReq != null) {
            try {
                StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, b.des_codigo, ");
                bui.append(" a.err_datatriagem, c.pac_nome, d.exa_descricao, l.mco_abreviatura, b.con_codigo, coalesce(b.req_urgente, false) as req_urgente, ");
                bui.append(" coalesce(a.rec_kodigo, a.rec_codigo) as ").append(COD_COLETA).append(", f.rec_descricao as ").append(DES_COLETA).append(",");
                bui.append(" h.rec_codigo as ").append(COD_TRIAGEM).append(", h.rec_descricao as ").append(DES_TRIAGEM).append(",");
                bui.append(" i.exr_situacao, i.exr_intervalojejum, i.exr_dataetqtriagem, j.prz_codigo, j.emc_solicitarjejum, coalesce(i.exr_urgente, false) as exr_urgente, coalesce(j.emc_materialcongelado, false) as emc_materialcongelado ");
                bui.append(" from examerequisicao i ");
                bui.append(" left join examerequisicaorecipiente a on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo and a.exa_codigo = i.exa_codigo and a.mco_codigo = i.mco_codigo");
                bui.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
                bui.append(" left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo");
                bui.append(" left join exames d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo");
                bui.append(" left join recipcoleta e on a.fil_codigo = e.fil_codigo and a.rec_codigo = e.rec_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo");
                bui.append(" left join recipientes f on e.fil_codigo = f.fil_codigo and e.rec_codigo = f.rec_codigo");
                bui.append(" left join reciptriagem g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo");
                bui.append(" left join recipientes h on g.fil_codigo = h.fil_codigo and g.rec_codigo = h.rec_codigo");
                bui.append(" left join examematcoleta j on a.fil_codigo = j.fil_codigo and a.exa_codigo = j.exa_codigo and a.mco_codigo = j.mco_codigo");
                bui.append(" left join materialcoleta l on a.fil_codigo = l.fil_codigo and a.mco_codigo = l.mco_codigo");
                bui.append(" where a.fil_codigo = ").append(filial);
                bui.append(" and a.req_codigo = ").append(requisicao);
                bui.append(" and i.exr_excluido = false and b.req_excluida = false ");
                bui.append(" order by d.exa_codigo, f.rec_codigo, h.rec_codigo");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                if (res.first()) {
                    Registro reg = new Registro();
                    reg.setValor("fil_codigo", res.getString("fil_codigo"));
                    reg.setValor("req_codigo", res.getString("req_codigo"));
                    reg.setValor("pac_nome", res.getString("pac_nome"));
                    reg.setValor("req_urgente", res.getBoolean("req_urgente"));
                    ArrayList<String> listExa = new ArrayList<String>();
                    ArrayList<String> listCol = new ArrayList<String>();
                    ArrayList<String> listTri = new ArrayList<String>();
                    ModeloResultSet modExa = (ModeloResultSet)modeloExa.clone();
                    ModeloResultSet modCol = null;
                    ModeloResultSet modTri = null;
                    do {
                        Registro tmp;
                        String obj;
                        DescritorCodigoEtiqueta dce;
                        if ((dce = this.getEtiqueta(res.getString("fil_codigo"), res.getString("req_codigo"), res.getString(COD_COLETA))) != null && res.getObject("err_datatriagem") != null && !this.etqConferidas.contains(dce)) {
                            this.etqConferidas.add(dce);
                        }
                        if (!listExa.contains(obj = res.getString("exa_codigo") + res.getString("mco_codigo"))) {
                            tmp = new Registro();
                            tmp.setValor("fil_codigo", res.getString("fil_codigo"));
                            tmp.setValor("exa_codigo", res.getString("exa_codigo"));
                            tmp.setValor("mco_codigo", res.getObject("mco_codigo"));
                            tmp.setValor("mco_abreviatura", res.getString("mco_abreviatura"));
                            tmp.setValor("exa_descricao", res.getString("exa_descricao"));
                            tmp.setValor("exr_situacao", res.getString("exr_situacao"));
                            tmp.setValor("exr_intervalojejum", res.getString("exr_intervalojejum"));
                            modCol = (ModeloResultSet)modeloCol.clone();
                            tmp.setValor(MODELO_COLETA, modCol);
                            modTri = (ModeloResultSet)modeloTri.clone();
                            tmp.setValor(MODELO_TRIAGEM, modTri);
                            tmp.setValor("req_codigo", res.getString("req_codigo"));
                            tmp.setValor("prz_codigo", res.getString("prz_codigo"));
                            tmp.setValor("con_codigo", res.getString("con_codigo"));
                            tmp.setValor("emc_solicitarjejum", res.getBoolean("emc_solicitarjejum"));
                            tmp.setValor("codigoDestino", res.getString("des_codigo"));
                            tmp.setValor("exr_urgente", res.getBoolean("exr_urgente"));
                            tmp.setValor("emc_materialcongelado", res.getBoolean("emc_materialcongelado"));
                            modExa.addRegistro(tmp);
                            listExa.add(obj);
                            listCol.clear();
                            listTri.clear();
                        }
                        if ((obj = res.getString(COD_COLETA)) != null && !listCol.contains(obj) && modCol != null) {
                            tmp = new Registro();
                            tmp.setValor(COD_COLETA, obj);
                            tmp.setValor(DES_COLETA, res.getString(DES_COLETA));
                            tmp.setValor(TUBO_CONFERIDO, res.getObject("err_datatriagem") != null);
                            modCol.addRegistro(tmp);
                            listCol.add(obj);
                        }
                        if ((obj = res.getString(COD_TRIAGEM)) == null || listTri.contains(obj) || modTri == null) continue;
                        tmp = new Registro();
                        tmp.setValor(COD_TRIAGEM, obj);
                        tmp.setValor(DES_TRIAGEM, res.getString(DES_TRIAGEM));
                        tmp.setValor(TUBO_TRIADO, res.getObject("exr_dataetqtriagem") != null);
                        modTri.addRegistro(tmp);
                        listTri.add(obj);
                    } while (res.next());
                    reg.setValor(MODELO_EXAMES, modExa);
                    modReq.addRegistro(reg);
                    modReq.fireTableDataChanged();
                }
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 630");
            }
        }
    }

    private DescritorCodigoEtiqueta getEtiqueta(String filial, String requisicao, String tubo) {
        StringBuilder bui = new StringBuilder(StringUtil.preencheString(filial, ParametrosGerais.getDigitosTuboFilial(), '0', 1));
        bui.append(StringUtil.preencheString(requisicao, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
        bui.append(StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
        return DescritorCodigoEtiqueta.getDescritor(bui.toString());
    }

    private boolean loteCadastrado(DescritorCodigoLote dcl, String tipoBase) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select fil_codigo from loteapoio where fil_codigo = ");
                bui.append(dcl.getCodigoFilial());
                bui.append(" and con_codigo = ").append(dcl.getCodigoConvenio());
                bui.append(" and lot_codigo = ").append(dcl.getCodigoLote());
                SQL = bui.toString();
                return Conexao.executeQuery(st, SQL).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 807");
            }
        }
        return false;
    }

    private boolean loteContemRequisicoes(DescritorCodigoLote dcl, String tipoBase) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select a.req_codigo from loteapoiorequisicao a ");
                bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
                bui.append("where a.fil_codigo = ");
                bui.append(dcl.getCodigoFilial());
                bui.append(" and b.con_codigo = ").append(dcl.getCodigoConvenio());
                bui.append(" and b.lot_codigo = ").append(dcl.getCodigoLote());
                SQL = bui.toString();
                return Conexao.executeQuery(st, SQL).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 804");
            }
        }
        return false;
    }

    private boolean loteContemEtiquetas(DescritorCodigoLote dcl, String tipoBase) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select a.rec_codigo from examerequisicaorecipiente a ");
                bui.append("left join loteapoiorequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("left join loteapoio d on a.fil_codigo = b.fil_codigo and b.lot_id = d.lot_id ");
                bui.append("where b.fil_codigo = ").append(dcl.getCodigoFilial());
                bui.append(" and d.con_codigo = ").append(dcl.getCodigoConvenio());
                bui.append(" and d.lot_codigo = ").append(dcl.getCodigoLote());
                bui.append(" and c.exr_excluido = false ");
                SQL = bui.toString();
                return Conexao.executeQuery(st, SQL).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 826");
            }
        }
        return false;
    }

    private boolean contemCadastro(DescritorCodigoEtiqueta dce) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select a.fil_codigo from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ");
                bui.append(dce.getFilial());
                bui.append(" and a.req_codigo = ");
                bui.append(dce.getRequisicao());
                bui.append(" and (a.rec_codigo = ").append(dce.getTubo()).append(" or a.rec_kodigo = ").append(dce.getTubo()).append(") ");
                bui.append(" and c.exr_excluido = false ");
                SQL = bui.toString();
                return Conexao.executeQuery(st, SQL).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 693");
            }
        }
        return false;
    }

    private boolean etiquetaJaConferida(DescritorCodigoEtiqueta dce) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select (a.err_datatriagem is not null) as conferido from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ").append(dce.filial);
                bui.append(" and a.req_codigo = ").append(dce.requisicao);
                bui.append(" and a.rec_codigo = ").append(dce.tubo);
                bui.append(" and c.exr_excluido = false ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                return res.first() && res.getBoolean("conferido");
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 791");
            }
        }
        return false;
    }

    private DescritorCodigoLote getLoteRequisicao(String filial, String requisicao) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select b.pac_codigo, b.con_codigo, b.lot_codigo, c.fil_tipobase from loteapoiorequisicao a ");
                bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
                bui.append("left join filiais_postocoleta c on a.fil_codigo = c.fil_codigo ");
                bui.append("where a.fil_codigo = ").append(filial);
                bui.append(" and a.req_codigo = ").append(requisicao);
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                if (res.next()) {
                    String codigoConvenio = res.getString("con_codigo");
                    return new DescritorCodigoLote(filial, res.getString("lot_codigo"), codigoConvenio);
                }
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 817");
            }
        }
        return null;
    }

    private List getTubosRequisicao(String filial, String requisicao) {
        ArrayList<Object> tubos = new ArrayList<Object>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                HashMap<Integer, StringBuilder> tmp = new HashMap<Integer, StringBuilder>();
                ArrayList<DescritorCodigoEtiqueta> conferidas = new ArrayList<DescritorCodigoEtiqueta>();
                StringBuilder bui = new StringBuilder("select distinct a.rec_codigo, (a.err_datatriagem is not null) as conferido ");
                bui.append("from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ").append(filial);
                bui.append(" and c.req_codigo = ").append(requisicao);
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    if (!res.getBoolean("conferido")) continue;
                    conferidas.add(this.getEtiqueta(filial, requisicao, res.getString("rec_codigo")));
                }
                bui.delete(0, bui.length());
                bui.append("select coalesce(a.rec_kodigo, a.rec_codigo) as rec_codigo, b.exa_descricao, c.mco_abreviatura ");
                bui.append("from examerequisicaorecipiente a ");
                bui.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                bui.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("left join examerequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                bui.append("where a.fil_codigo = ").append(filial);
                bui.append(" and a.req_codigo = ").append(requisicao);
                bui.append(" and d.exr_excluido = false ");
                SQL = bui.toString();
                res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    Integer tubo = res.getInt("rec_codigo");
                    StringBuilder exa = (StringBuilder)tmp.get(tubo);
                    if (exa == null) {
                        exa = new StringBuilder();
                        tmp.put(tubo, exa);
                    } else {
                        if (exa.indexOf("<html>") == -1) {
                            exa.insert(0, "<html>");
                        }
                        exa.append("<br>");
                    }
                    exa.append(res.getString("exa_descricao")).append(" (");
                    exa.append(res.getString("mco_abreviatura")).append(")");
                }
                for (Integer tubo : tmp.keySet()) {
                    DescritorCodigoEtiqueta dce = this.getEtiqueta(filial, requisicao, tubo.toString());
                    StringBuilder exa = (StringBuilder)tmp.get(tubo);
                    if (exa.indexOf("<html>") > -1) {
                        exa.append("</html>");
                    }
                    tubos.add(tubo.toString());
                    tubos.add(exa.toString());
                    tubos.add(this.etqLidas.contains(dce) || conferidas.contains(dce));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 733");
            }
        }
        return tubos;
    }

    private void atualizarTextoBotaoImprimir(JTable table) {
        if (table == this.tableRequisicoes) {
            this.subImprimirTodos.setText("Imprimir Todas as Requisi\u00e7\u00f5es");
            this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Requisi\u00e7\u00f5es" : "Imprimir Requisi\u00e7\u00e3o");
        } else if (table == this.tableReqOutroLote) {
            this.subImprimirTodos.setText("Imp. Todas Req. de Outro Lote");
            this.subImprimir.setText("Imp. Req. de Outro Lote");
        } else if (table == this.tableExames) {
            if (this.tableReqImpressao == this.tableReqOutroLote) {
                this.subImprimirTodos.setText("Imp. Todos os Exames de Outro Lote");
                this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Exames de Outro Lote" : "Imprimir Exame de Outro Lote");
            } else {
                this.subImprimirTodos.setText("Imprimir Todos os Exames");
                this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Exames" : "Imprimir Exame");
            }
        }
    }

    private void habilitarDesabilitarBotoes() {
        this.textLote.setEnabled(!this.conferindoLote);
        this.textLote.setEditable(!this.conferindoLote);
        this.textLote.setOpaque(!this.conferindoLote);
        this.buttonBuscaLote.setEnabled(!this.conferindoLote);
        this.textTubo.setEnabled(this.conferindoLote);
        this.buttonNovo.setEnabled(this.conferindoLote);
        this.buttonSalvar.setEnabled(this.conferindoLote && this.etqLidas.size() > 0);
        this.buttonImprimir.setEnabled(this.loteSalvo && this.etqLidas.size() == 0);
        this.buttonOpcoes.setEnabled(this.conferindoLote);
    }

    private void limparModelos() {
        for (Registro reg : this.modeloReqOutro.getRegistros()) {
            this.modeloReq.addRegistro(reg);
        }
        for (Registro reg : this.modeloReq.getRegistros()) {
            ModeloResultSet exa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
            if (exa == null) continue;
            for (Registro tmp : exa.getRegistros()) {
                ModeloResultSet mod = (ModeloResultSet)tmp.getValor(MODELO_COLETA);
                if (mod != null) {
                    mod.limpar();
                }
                if ((mod = (ModeloResultSet)tmp.getValor(MODELO_TRIAGEM)) == null) continue;
                mod.limpar();
            }
            exa.limpar();
        }
        this.modeloReq.limpar();
        this.modeloReqOutro.limpar();
        this.etqConferidas.clear();
        this.etqLidas.clear();
    }

    private void marcarMaterialFaltante(Registro reg) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null && this.isNotNull(reg)) {
            try {
                StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '");
                bui.append("F");
                bui.append("', exr_datamaterial = null, usr_codmaterial = null, exr_dataentregaprev = null, exr_intervalojejum = null where fil_codigo = ");
                bui.append(Variaveis.filialPadrao);
                bui.append(" and req_codigo = ");
                bui.append(reg.getString("req_codigo"));
                bui.append(" and exa_codigo = '");
                bui.append(reg.getString("exa_codigo"));
                bui.append("' and mco_codigo = ");
                bui.append(reg.getString("mco_codigo"));
                DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "F", false);
                SQL = bui.toString();
                Conexao.execute(Variaveis.filialPadrao, st, SQL);
                this.service.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "F", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 835");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarRecoleta(Registro reg) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String sql = "";
        StringBuilder bui = new StringBuilder();
        if (st != null && this.isNotNull(reg)) {
            block5: {
                try {
                    String motivo = "";
                    SolicitarMotivoRecoleta recoleta = SolicitarMotivoRecoleta.novaInstancia(this.getTopLevelAncestor(), false, Variaveis.filialPadrao);
                    recoleta.setVisible(true);
                    if (!recoleta.getOK()) break block5;
                    motivo = recoleta.getDescricaoMotivo();
                    bui.append("update examerequisicao set exr_situacao = '");
                    bui.append("R");
                    bui.append("', exr_datarecoleta = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("', ");
                    bui.append(" usr_codrecoleta = '").append(StringUtil.textoDB(Variaveis.login)).append("', ");
                    bui.append(" exr_motivorecoleta = '").append(StringUtil.textoDB(motivo)).append("' ");
                    bui.append(" where fil_codigo = ");
                    bui.append(Variaveis.filialPadrao);
                    bui.append(" and req_codigo = ");
                    bui.append(reg.getString("req_codigo"));
                    bui.append(" and exa_codigo = '");
                    bui.append(reg.getString("exa_codigo"));
                    bui.append("' and mco_codigo = ");
                    bui.append(reg.getString("mco_codigo"));
                    DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "R", false);
                    Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
                    this.service.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "R", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                    reg.setValor("exr_situacao", "R");
                    Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                    this.enviarMensagemSmsRecoleta(reg, st, st2);
                    this.enviarMensagemEmailRecoleta(reg, st, st2);
                    this.enviarMensagemWhatsappRecoleta(reg, st, st2);
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + sql, e.getStackTrace(), "ConferenciaLote: 835");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2);
                }
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void enviarMensagemSmsRecoleta(Registro reg, Statement st, Statement st2) throws Exception {
        if (!SMSUtil.isBloquearSMSRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
            SMSUtil.criaLogSmsComDadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"), ExportaSMS.TipoSMS.RECOLETA, st, st2);
        }
    }

    private void enviarMensagemEmailRecoleta(Registro reg, Statement st, Statement st2) throws Exception {
        if (!EmailUtil.isBloquearEmailRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
            EmailUtil.criaLogEmail(Variaveis.filialPadrao, reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RECOLETA, true, st);
        }
    }

    private void enviarMensagemWhatsappRecoleta(Registro reg, Statement st, Statement st2) {
        try {
            if (!WhatsAppUtil.isBloquearWhatsappRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"), TipoWhatsapp.RECOLETA, st, st2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdicionaMensagem novoAdicionaMensagem() {
        Container pai = this.getTopLevelAncestor();
        if (pai instanceof Frame) {
            return new AdicionaMensagem((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new AdicionaMensagem((Dialog)pai);
        }
        return null;
    }

    private void adicionarMensagem() {
        Statement st = Conexao.getStatement();
        AdicionaMensagem msg = this.novoAdicionaMensagem();
        if (msg != null && st != null) {
            try {
                msg.setVisible(true);
                if (msg.isOK() && !Funcoes.textoVazio(msg.getMensagem())) {
                    SalvaDados salvar = new SalvaDados("conveniomensagem", 0);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("con_codigo", 2, false, true, this.codigoLote.getCodigoConvenio());
                    salvar.adicionaCampo("cme_mensagem", 0, true, false, StringUtil.textoDB(msg.getMensagem()));
                    salvar.adicionaCampo("cme_titulo", 0, true, false, StringUtil.textoDB(msg.getTitulo()));
                    salvar.adicionaCampo("usr_codigo", 0, true, false, StringUtil.textoDB(Variaveis.login));
                    salvar.adicionaCampo("cme_data", 5, true, false, 0);
                    salvar.adicionaCampo("cme_exportado", 4, true, false, "false");
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaConvenio());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaLote: 1143");
            }
        }
    }

    private void receberMaterial(Registro reg) {
        if (this.isNotNull(reg)) {
            try {
                String jejum = "";
                if (this.isSolicitarJejum(reg)) {
                    jejum = reg.getString("exr_intervalojejum");
                    if (!this.isExibiuJejum) {
                        this.tempoJejum = jejum = this.solicitarJejum(jejum);
                        this.isExibiuJejum = true;
                    } else {
                        jejum = this.tempoJejum;
                    }
                }
                this.service.receberMaterial(jejum, reg);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 879");
            }
        }
    }

    private boolean isSolicitarJejum(Registro reg) {
        return reg.getBoolean("emc_solicitarjejum");
    }

    private String solicitarJejum(String tempoJejum) {
        SolicitarJejum sj = SolicitarJejum.novaInstancia(this.getTopLevelAncestor());
        if (sj != null) {
            sj.setTempoJejum(tempoJejum);
            sj.setVisible(true);
            return sj.getTempoJejum().trim();
        }
        return "";
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 907");
        }
    }

    private void habilitarOpcoes(Registro reg) {
        if (this.isNotNull(reg)) {
            String s = reg.getString("exr_situacao").trim();
            boolean semResultado = s.length() == 0;
            this.itemReceberMaterial.setVisible(this.acessoReceberMaterial && (s.equalsIgnoreCase("F") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("R")));
            this.itemMarcarMaterialFaltante.setVisible(this.acessoMarcarMaterialFaltante && semResultado);
            this.itemMarcarRecoleta.setVisible(this.acessoMarcarRecoleta && semResultado);
        }
    }

    private void atualizarExamesTriados(int[] indices) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                int[] rowsReq = this.tableRequisicoes.getSelectedRows();
                int[] rowsExa = this.tableExames.getSelectedRows();
                StringBuilder bui = new StringBuilder();
                for (Registro req : this.modeloReq.getRegistros(indices)) {
                    ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                    if (modExa == null) continue;
                    bui.delete(0, bui.length());
                    bui.append("select (exr_dataetqtriagem is not null) as exametriado, exa_codigo, mco_codigo from examerequisicao ");
                    bui.append("where fil_codigo = ");
                    bui.append(Variaveis.filialPadrao);
                    bui.append(" and req_codigo = ");
                    bui.append(req.getString("req_codigo"));
                    bui.append(" and exr_excluido = false ");
                    SQL = bui.toString();
                    ResultSet res = Conexao.executeQuery(st, SQL);
                    block3: while (res.next()) {
                        for (Registro exa : modExa.getRegistros()) {
                            if (!exa.getValor("exa_codigo").equals(res.getObject("exa_codigo")) || !exa.getValor("mco_codigo").equals(res.getObject("mco_codigo"))) continue;
                            exa.setValor(TUBO_TRIADO, res.getBoolean("exametriado"));
                            continue block3;
                        }
                    }
                    boolean tuboTriado = true;
                    for (Registro exa : modExa.getRegistros()) {
                        if (exa.getBoolean(TUBO_TRIADO)) continue;
                        tuboTriado = false;
                        break;
                    }
                    req.setValor(TUBO_TRIADO, tuboTriado);
                    this.tableRequisicoes.repaint();
                    this.tableExames.repaint();
                    this.tableColeta.repaint();
                    this.tableTriagem.repaint();
                    if (rowsReq == null) continue;
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsReq)) {
                        this.tableRequisicoes.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                    if (rowsReq.length != 1) continue;
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsExa)) {
                        this.tableExames.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 1052");
            }
        }
    }

    private void imprimirRequisicoes(int[] indices, int tipo) {
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        List<Registro> list;
        String chaveImp = "campoImprimir";
        if (tipo == 0 && (list = this.getRequisicoesIncompletas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Imprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es incompletas");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisic\u00f5es listadas abaixo est\u00e3o incompletas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja imprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(IMPR_INCOMPLETO, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        if (tipo == 0 && (list = this.getRequisicoesJaTriadas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Imprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es j\u00e1 triados");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisi\u00e7\u00f5es listadas abaixo cont\u00eam etiquetas de triagem j\u00e1 impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        try {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            for (Registro reg : ((ModeloResultSet)this.tableReqImpressao.getModel()).getRegistros(indices)) {
                exames.clear();
                materiais.clear();
                ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
                if (modExa != null) {
                    for (Registro regExa : modExa.getRegistros()) {
                        ModeloResultSet modCol = (ModeloResultSet)regExa.getValor(MODELO_COLETA);
                        for (Registro regCol : modCol.getRegistros()) {
                            if (tipo != 1 && (!regCol.getBoolean(TUBO_CONFERIDO) || regCol.getBoolean(TUBO_TRIADO) && !regCol.getBoolean(REIMPRIMIR)) || exames.contains(regExa.getString("exa_codigo")) && materiais.contains(new Integer(regExa.getInt("mco_codigo")))) continue;
                            exames.add(regExa.getString("exa_codigo"));
                            materiais.add(new Integer(regExa.getInt("mco_codigo")));
                        }
                    }
                }
                if (exames.size() <= 0) continue;
                if (tipo == 0) {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), reg.getBoolean(REIMPRIMIR), Variaveis.login, 2);
                } else {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 1);
                }
                Conexao.arquivaSQL();
            }
            this.atualizarExamesTriados(indices);
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1145");
        }
    }

    private int[] getInteiros(ArrayList<Integer> lista) {
        int[] ints = new int[lista.size()];
        for (int i = 0; i < lista.size(); ++i) {
            ints[i] = lista.get(i);
        }
        return ints;
    }

    private void imprimirExames(int[] indices, int tipo) {
        Registro regReq;
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        List<Registro> list;
        String chaveImp = "campoImprimir";
        if (tipo == 0 && (list = this.getExamesIncompletos(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao");
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames incompletos");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("Os exames listados abaixo est\u00e3o incompletos e n\u00e3o ser\u00e3o impressos.");
                dri.setConfirmacaoImpressao(false);
                dri.centralizar();
                dri.setVisible(true);
            }
        }
        if (tipo == 0 && (list = this.getExamesJaTriados(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames j\u00e1 triados");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As etiquetas de triagem dos exames listados abaixo j\u00e1 foram impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque os que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        if (this.isNotNull(regReq = ((ModeloResultSet)this.tableReqImpressao.getModel()).getRegistro(this.tableReqImpressao.getSelectedRow()))) {
            try {
                ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
                ArrayList<String> exames = new ArrayList<String>();
                ArrayList<Integer> materiais = new ArrayList<Integer>();
                for (Registro reg : modExa.getRegistros(indices)) {
                    ModeloResultSet modCol = (ModeloResultSet)reg.getValor(MODELO_COLETA);
                    for (Registro regCol : modCol.getRegistros()) {
                        if (tipo != 1 && (!regCol.getBoolean(TUBO_CONFERIDO) || regCol.getBoolean(TUBO_TRIADO) && !regCol.getBoolean(REIMPRIMIR))) continue;
                        exames.add(reg.getString("exa_codigo"));
                        materiais.add(new Integer(reg.getInt("mco_codigo")));
                    }
                }
                if (tipo == 0) {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 2);
                } else {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 1);
                }
                Conexao.arquivaSQL();
                this.atualizarExamesTriados(indices);
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1236");
            }
        }
    }

    private List<Registro> getRequisicoesIncompletas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            Registro reg = this.modeloReq.getRegistro(i);
            if (!this.isNotNull(reg) || reg.getBoolean(TUBOS_OK)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private boolean todasRequisicoesCompletas() {
        for (Registro reg : this.modeloReq.getRegistros()) {
            if (reg.getBoolean(TUBOS_OK)) continue;
            return false;
        }
        return true;
    }

    private List<Registro> getRequisicoesJaTriadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (!this.isNotNull(reg) || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) == null) continue;
            boolean triado = false;
            for (int j = 0; !triado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                triado = this.isNotNull(r) && r.getBoolean(TUBO_TRIADO);
            }
            if (!triado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesIncompletos(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (!this.isNotNull(reg) || reg.getBoolean(TUBOS_OK)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesJaTriados(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (!this.isNotNull(reg) || !reg.getBoolean(TUBO_TRIADO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private String getDescricaoConvenio(DescritorCodigoLote dcl, String tipoBase) {
        Statement st = Conexao.getStatement();
        if (st != null && dcl != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select con_fantasia as nome from convenios");
                bui.append(" where fil_codigo = ").append(dcl.getCodigoFilial());
                bui.append(" and con_codigo = ").append(dcl.getCodigoConvenio());
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    bui.delete(0, bui.length());
                    bui.append(" ");
                    bui.append(dcl.getCodigoLote());
                    bui.append(" - ");
                    bui.append(res.getString("nome"));
                    return bui.toString();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1376");
            }
        }
        return "";
    }

    private void salvarLote() {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                int resp;
                StringBuilder bui = new StringBuilder();
                ArrayList<Registro> registros = new ArrayList<Registro>(this.modeloReq.getRegistros());
                registros.addAll(this.modeloReqOutro.getRegistros());
                if (!this.caixaRecebida && (resp = Funcoes.mensagem(this, "A caixa n\u00e3o foi recebida para o lote, deseja confirmar o recebimento?", 4)) == 0) {
                    this.buttonCaixa.doClick();
                }
                for (Registro req : registros) {
                    bui.delete(0, bui.length());
                    bui.append("update requisicao set usr_codigo = '").append(Variaveis.login);
                    bui.append("' ");
                    bui.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
                    SQL = bui.toString();
                    Conexao.execute(req.getString("fil_codigo"), st, SQL);
                    bui.setLength(0);
                    bui.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
                    bui.append(req.getString("fil_codigo"));
                    bui.append(", ");
                    bui.append(req.getString("req_codigo"));
                    bui.append(", '");
                    bui.append(Variaveis.login);
                    bui.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
                    SQL = bui.toString();
                    Conexao.execute(req.getString("fil_codigo"), st, SQL);
                    ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                    if (modExa != null) {
                        for (Registro exa : modExa.getRegistros()) {
                            if (!exa.getBoolean(TUBO_LIDO)) continue;
                            bui.delete(0, bui.length());
                            bui.append("update examerequisicao set exr_datatriagem = current_timestamp, usr_codtriagem = '").append(Variaveis.login);
                            bui.append("' where fil_codigo = ").append(req.getString("fil_codigo"));
                            bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
                            bui.append(" and exa_codigo = '").append(exa.getString("exa_codigo"));
                            bui.append("' and mco_codigo = ").append(exa.getString("mco_codigo"));
                            SQL = bui.toString();
                            Conexao.execute(req.getString("fil_codigo"), st, SQL);
                            ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                            if (modCol == null) continue;
                            for (Registro col : modCol.getRegistros()) {
                                if (!col.getBoolean(TUBO_LIDO)) continue;
                                bui.delete(0, bui.length());
                                bui.append("update examerequisicaorecipiente set err_datatriagem = current_timestamp, usr_codtriagem = '").append(Variaveis.login);
                                bui.append("' where fil_codigo = ").append(req.getString("fil_codigo"));
                                bui.append(" and req_codigo = ").append(req.getString("req_codigo"));
                                bui.append(" and exa_codigo = '").append(exa.getString("exa_codigo"));
                                bui.append("' and mco_codigo = ").append(exa.getString("mco_codigo"));
                                bui.append(" and rec_kodigo = ").append(col.getString(COD_COLETA));
                                SQL = bui.toString();
                                Conexao.execute(req.getString("fil_codigo"), st, SQL);
                                col.setValor(TUBO_CONFERIDO, Boolean.TRUE);
                                col.setValor(TUBO_LIDO, Boolean.FALSE);
                            }
                        }
                    }
                    if (ParametrosGerais.getExportarInterface() != 0) continue;
                    ExportarInterface.criaInterface(req.getString("fil_codigo"), req.getString("req_codigo"), "requisicao");
                }
                this.outrosLotes.add(this.codigoLote);
                for (DescritorCodigoLote lote : this.outrosLotes) {
                    bui.delete(0, bui.length());
                    bui.append("update loteapoio set lot_datahoratriagem = current_timestamp, lot_triagem = true, usr_codigo = '").append(Variaveis.login).append("'");
                    if (lote != null && lote.getCodigoLote() != null && this.codigoLote != null && this.codigoLote.getCodigoLote() != null && lote.getCodigoLote() == this.codigoLote.getCodigoLote()) {
                        bui.append(" ,usr_codrecebeucaixa = '").append(Variaveis.login).append("', lot_datarecebeucaixa = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date())).append("'");
                    }
                    if (lote == null) continue;
                    bui.append(" where fil_codigo = ").append(lote.getCodigoFilial());
                    bui.append(" and con_codigo = ").append(lote.getCodigoConvenio());
                    bui.append(" and lot_codigo = ").append(lote.getCodigoLote());
                    SQL = bui.toString();
                    Conexao.execute(lote.getCodigoFilial(), st, SQL);
                }
                this.etqConferidas.addAll(this.etqLidas);
                this.etqLidas.clear();
                this.loteSalvo = true;
                this.habilitarDesabilitarBotoes();
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 1307");
            }
        }
    }

    private void marcarExamesRequisicoesOk(ModeloResultSet modReq) {
        for (Registro req : modReq.getRegistros()) {
            ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
            if (modExa == null) continue;
            Boolean reqOk = Boolean.TRUE;
            for (Registro exa : modExa.getRegistros()) {
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (modCol == null) continue;
                Boolean exaLido = Boolean.FALSE;
                Boolean exaOk = Boolean.TRUE;
                for (Registro col : modCol.getRegistros()) {
                    if (!col.getBoolean(TUBO_LIDO) && !col.getBoolean(TUBO_CONFERIDO)) {
                        exaOk = Boolean.FALSE;
                    }
                    if (!col.getBoolean(TUBO_LIDO)) continue;
                    exaLido = Boolean.TRUE;
                }
                exa.setValor(TUBOS_OK, exaOk);
                exa.setValor(TUBO_LIDO, exaLido);
                if (exaOk.booleanValue()) continue;
                reqOk = Boolean.FALSE;
            }
            req.setValor(TUBOS_OK, reqOk);
        }
    }

    private void iniciar() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de Lote", "Confer\u00eancia de Lote", "triagem/conferencia_lote_apoio.jpg");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "South");
        panel.add((Component)this.panelCaixa, "North");
        JPanel aux = new JPanel(new FlowLayout(0, 3, 3));
        panel.add((Component)aux, "West");
        aux.add(this.buttonOpcoes);
        aux.add(this.checkAutomatico);
        aux = new JPanel(new FlowLayout(2, 3, 2));
        panel.add((Component)aux, "East");
        aux.add(this.buttonNovo);
        aux.add(this.buttonSalvar);
        aux.add(this.buttonImprimir);
        aux.add(this.buttonFechar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.panelCaixa.add((Component)this.labelCaixa, cons);
        ++cons.gridx;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 0.0;
        this.panelCaixa.add((Component)this.buttonCaixa, cons);
        this.panelCaixa.setVisible(false);
        this.buttonBuscaLote.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaLote.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaLote.setMargin(new Insets(0, 0, 0, 0));
        panel = new JPanel(new GridBagLayout());
        this.add((Component)panel, "Center");
        cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.weighty = 0.0;
        aux = new JPanel(new FlowLayout(0, 1, 0));
        panel.add((Component)aux, cons);
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(50, 20));
        aux.add(labelLote);
        aux.add(this.textLote);
        aux.add(this.buttonBuscaLote);
        aux.add(this.labelConvenio);
        labelLote.setLabelFor(this.textLote);
        labelLote.setDisplayedMnemonic('L');
        this.textLote.addKeyListener(this);
        this.textLote.setPreferredSize(new Dimension(120, 20));
        cons.gridy = 1;
        aux = new JPanel(new FlowLayout(0, 1, 1));
        panel.add((Component)aux, cons);
        JLabel labelTubo = ComponenteFactory.novoJLabel("Tubo:", new Dimension(50, 20));
        aux.add(labelTubo);
        aux.add(this.textTubo);
        labelTubo.setLabelFor(this.textTubo);
        labelTubo.setDisplayedMnemonic('T');
        this.textTubo.addKeyListener(this);
        this.textTubo.setPreferredSize(new Dimension(120, 20));
        cons.fill = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.weighty = 1.0;
        cons.gridwidth = 1;
        cons.gridheight = 2;
        ++cons.gridy;
        aux = new JPanel(new BorderLayout());
        panel.add((Component)aux, cons);
        this.tableRequisicoes.setDefaultRenderer(Object.class, this);
        this.tableRequisicoes.addFocusListener(this);
        this.tableRequisicoes.addKeyListener(this);
        this.tableReqOutroLote.setDefaultRenderer(Object.class, this);
        this.tableReqOutroLote.addFocusListener(this);
        this.tableReqOutroLote.addKeyListener(this);
        aux.add((Component)this.novoJPanel(this.tableRequisicoes, "Requisi\u00e7\u00f5es"), "Center");
        this.panelOutroLote = this.novoJPanel(this.tableReqOutroLote, "Requisi\u00e7\u00f5es de outro lote");
        aux.add((Component)this.panelOutroLote, "South");
        this.panelOutroLote.setPreferredSize(new Dimension(10, 150));
        this.panelOutroLote.setVisible(false);
        cons.weightx = 0.8;
        cons.gridx = 1;
        this.tableExames.setDefaultRenderer(Object.class, this);
        this.tableExames.addFocusListener(this);
        this.tableExames.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableExames, "Exames"), cons);
        cons.weightx = 0.4;
        cons.gridx = 2;
        cons.gridheight = 1;
        this.tableColeta.setRowSelectionAllowed(false);
        this.tableColeta.setDefaultRenderer(Object.class, this);
        this.tableColeta.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableColeta, "Etiquetas Coleta"), cons);
        ++cons.gridy;
        this.tableTriagem.setRowSelectionAllowed(false);
        this.tableTriagem.setDefaultRenderer(Object.class, this);
        this.tableTriagem.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableTriagem, "Etiquetas Triagem"), cons);
        this.panelLegenda.addItem(COR_LIDO, "Tubo identificado");
        this.panelLegenda.addItem(COR_TRIADO, "Tubo triado");
        this.panelLegenda.addItem(Color.RED, "Urgente");
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 4;
        cons.fill = 2;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        panel.add((Component)this.panelLegenda.getPanel(), cons);
        this.acessoMarcarMaterialFaltante = Acesso.getAcesso(300400301L);
        this.acessoReceberMaterial = Acesso.getAcesso(300400302L);
        this.acessoMarcarRecoleta = Acesso.getAcesso(300400303L);
        this.checkAutomatico.setVisible(this.acessoReceberMaterial);
        if (this.checkAutomatico.isVisible()) {
            this.checkAutomatico.setSelected(StringUtil.getBoolean(ParametrosUsuarios.getValor(RECEBER_AUTOMATICO)));
        } else {
            this.checkAutomatico.setSelected(false);
        }
        this.buttonOpcoes.addKeyListener(this);
        this.buttonNovo.addKeyListener(this);
        this.buttonSalvar.addKeyListener(this);
        this.buttonImprimir.addKeyListener(this);
        this.buttonFechar.addKeyListener(this);
        this.habilitarDesabilitarBotoes();
        this.configurarTeclas();
        this.redimensionarColunas();
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private JPanel novoJPanel(JTable tabela, String titulo) {
        JPanel panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder(titulo));
        panel.add((Component)new JScrollPane(tabela, 20, 30), "Center");
        return panel;
    }

    private void configurarTeclas() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(10, 0, false), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                }
            }
        });
    }

    private void redimensionarColunas() {
        this.tableRequisicoes.getColumnModel().getColumn(0).setMaxWidth(60);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(60);
        this.tableReqOutroLote.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableReqOutroLote.getColumnModel().getColumn(0).setMinWidth(45);
        this.tableExames.getColumnModel().getColumn(0).setMaxWidth(50);
        this.tableExames.getColumnModel().getColumn(1).setMaxWidth(50);
        this.tableExames.getColumnModel().getColumn(3).setMaxWidth(20);
        this.tableColeta.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableColeta.getColumnModel().getColumn(0).setMinWidth(45);
        this.tableTriagem.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableTriagem.getColumnModel().getColumn(0).setMinWidth(45);
    }

    private void pesquisarLote() {
        Hashtable resultado = null;
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            String codigoConvenio = "";
            if (null != this.codigoLote) {
                codigoConvenio = this.codigoLote.getCodigoConvenio();
            }
            resultado = Pesquisas.loteApoioAlimentos(this.getTopLevelAncestor(), false, codigoConvenio);
        } else {
            resultado = Pesquisas.loteapoio(this.getTopLevelAncestor(), false);
        }
        if (resultado != null) {
            StringBuilder bui = new StringBuilder();
            bui.append(StringUtil.preencheString(Variaveis.filialPadrao, 2, '0', 1));
            bui.append(StringUtil.preencheString(resultado.get("con_codigo").toString(), 4, '0', 1));
            bui.append(StringUtil.preencheString(resultado.get("lot_codigo").toString(), 9, '0', 1));
            this.textLote.setText(bui.toString());
        }
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void controlaCamposCaixa(String caixa, Date dataRecebimentoCaixa, String usuarioRecebimentoCaixa) {
        this.caixaRecebida = caixa != null && !Funcoes.textoVazio(caixa) ? dataRecebimentoCaixa != null : true;
        this.panelCaixa.setVisible(caixa != null && !Funcoes.textoVazio(caixa));
        this.buttonCaixa.setVisible(!this.caixaRecebida);
        if (!this.caixaRecebida) {
            this.labelCaixa.setText("Caixa enviada: " + caixa);
        } else {
            this.labelCaixa.setText("Caixa " + caixa + " recebida em " + Funcoes.formataData("dd/MM/yyyy HH:mm", dataRecebimentoCaixa) + " por " + usuarioRecebimentoCaixa);
        }
    }

    @Override
    @Deprecated
    public void keyPressed(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    static {
        labelRenderer.setOpaque(true);
        modeloExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat.", "mco_abreviatura", "Exame", "exa_descricao", "Sit", "exr_situacao");
        modeloCol = new ModeloResultSet("C\u00f3digo", COD_COLETA, "Descri\u00e7\u00e3o", DES_COLETA);
        modeloTri = new ModeloResultSet("C\u00f3digo", COD_TRIAGEM, "Descri\u00e7\u00e3o", DES_TRIAGEM);
    }
}

