/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.comum.Tipos;
import jalis.laboratorio.triagem.apoio.ConferenciaLote;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderConferenciaLote
extends DefaultTableCellRenderer {
    private ImageIcon imagemCongelado = ImagemUtils.carregaImagemJalis("congelado.gif");
    public static final int TIPO_REQUISICAO = 1;
    public static final int TIPO_COLETA = 2;
    public static final int TIPO_EXAMES = 3;
    private int tipo = 1;

    public RenderConferenciaLote(int tipo) {
        this.tipo = tipo;
    }

    public static boolean isNotNull(Object obj) {
        return obj != null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        value = value == null ? "" : value;
        this.setText(value.toString());
        if (table != null) {
            Color back;
            Color fore;
            boolean ok;
            this.setFont(table.getFont());
            ModeloResultSet mod = (ModeloResultSet)table.getModel();
            Registro reg = mod.getRegistro(row);
            Color corTmp = ConferenciaLote.COR_TRIADO;
            boolean bl = ok = RenderConferenciaLote.isNotNull(reg) && reg.getBoolean("tuboTriado");
            if (!ok) {
                ok = RenderConferenciaLote.isNotNull(reg) && (this.tipo == 2 && (reg.getBoolean("tuboConferido") || reg.getBoolean("tuboLido")) || reg.getBoolean("tubosOk"));
                corTmp = ConferenciaLote.COR_LIDO;
            }
            Color color = fore = isSelected ? table.getSelectionForeground() : table.getForeground();
            if (this.tipo == 1 && reg.getBoolean("req_urgente")) {
                Color color2 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            if (this.tipo == 3 && reg.getBoolean("exr_urgente")) {
                Color color3 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            Color color4 = isSelected ? (ok ? ScreenUtil.escurecerCor(corTmp, 30) : table.getSelectionBackground()) : (back = ok ? corTmp : table.getBackground());
            if (this.tipo == 3 && column != 2) {
                if (column == 3) {
                    this.setToolTipText(Tipos.tipoSituacaoExame(value.toString()));
                }
                this.setHorizontalAlignment(0);
            } else {
                this.setToolTipText(table.getToolTipText());
                this.setHorizontalAlignment(this.tipo != 3 && column == 0 ? 0 : 2);
            }
            if (this.tipo == 3 && column == 1 && reg.getBoolean("emc_materialcongelado")) {
                this.setHorizontalTextPosition(10);
                this.setIcon(this.imagemCongelado);
            } else {
                this.setIcon(null);
            }
            this.setBackground(back);
            this.setForeground(fore);
        }
        return this;
    }
}

