/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.CelulaEstoque;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.EstoqueManualBean;
import jalis.model.bean.estoque.EstoqueManualMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.bean.triagem.MaterialIdentificadoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.EstoqueManualVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.EstoqueManualService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.service.triagem.MaterialIdentificadoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ReceberMaterialEnviado
extends FrmCadPadrao
implements ActionListener {
    JPanel panelInformacoes = new JPanel(new GridBagLayout());
    JPanel panelMateriais = new JPanel(new BorderLayout());
    JPanel panelDestino = new JPanel(new GridBagLayout());
    JPanel panelAdicionar = new JPanel(new FlowLayout(2));
    JLabel labelDataEnvio = new JLabel("Data Envio:");
    JLabel labelVlrDataEnvio = new JLabel();
    JLabel labelMaterial = new JLabel("Material:");
    JLabel labelVlrMaterial = new JLabel();
    JLabel labelCelula = new JLabel("C\u00e9lula:");
    JLabel labelVlrCelula = new JLabel();
    JLabel labelDescCelula = new JLabel();
    JLabel labelCelulaDestino = new JLabel("C\u00e9lula Destino:");
    JLabel labelDescCelulaDestino = new JLabel();
    JLabel labelEtiqueta = new JLabel("Etiqueta:");
    ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"Etiqueta", "Material", "A\u00e7\u00e3o", "Objeto"}){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            try {
                ReceberMaterialEnviado.this.tableMaterial.removeColumn(ReceberMaterialEnviado.this.tableMaterial.getColumn("Objeto"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (ReceberMaterialEnviado.this.tableMaterial != null) {
                    ReceberMaterialEnviado.this.tableMaterial.removeColumn(ReceberMaterialEnviado.this.tableMaterial.getColumn("Objeto"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    JTable tableMaterial = new JTable(this.modeloMaterial);
    JScrollPane scrollMaterial = new JScrollPane(this.tableMaterial);
    JCheckBox checkReutilizavel = new JCheckBox();
    TTextField textCelulaDestino = new TTextField(5, 1);
    TTextField textEtiqueta = new TTextField(14, 1);
    JButton buttonBuscaCelulaDestino = ComponenteFactory.novoJButton(this, true);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", this);
    MaterialIdentificadoBean materialIdentificado = null;
    boolean isEditando = false;

    public ReceberMaterialEnviado() {
        Funcoes.criaBarraDescricao(this, "Receber material enviado", "Recebe materiais previamente enviados para laborat\u00f3rio apoiado", "triagem/receber_material_apoio.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrDataEnvio, this.labelVlrMaterial, this.labelVlrCelula, this.labelDescCelula, this.labelDescCelulaDestino}, new TitledBorder(""));
        this.painelBotoes.remove(this.botaoEditar);
        this.painelBotoes.remove(this.botaoExcluir);
        this.buttonOk.setMnemonic('O');
        this.modeloMaterial.setColumnSize(new int[]{120, 0, 90, 0}, this.tableMaterial);
        this.tableMaterial.removeColumn(this.tableMaterial.getColumn("Objeto"));
        this.tableMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelInformacoes.setBorder(BorderFactory.createTitledBorder("Informa\u00e7\u00f5es"));
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelDestino.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Destino"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelInformacoes.add((Component)this.labelDataEnvio, gridBagConstraints);
        this.labelVlrDataEnvio.setMinimumSize(new Dimension(90, 20));
        this.labelVlrDataEnvio.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelInformacoes.add((Component)this.labelVlrDataEnvio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelInformacoes.add((Component)this.labelMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.labelVlrMaterial.setMinimumSize(new Dimension(20, 20));
        this.labelVlrMaterial.setPreferredSize(new Dimension(20, 20));
        this.panelInformacoes.add((Component)this.labelVlrMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelInformacoes.add((Component)this.labelCelula, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.labelVlrCelula.setHorizontalAlignment(4);
        this.labelVlrCelula.setMinimumSize(new Dimension(20, 20));
        this.labelVlrCelula.setPreferredSize(new Dimension(20, 20));
        this.panelInformacoes.add((Component)this.labelVlrCelula, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.labelDescCelula.setMinimumSize(new Dimension(20, 20));
        this.labelDescCelula.setPreferredSize(new Dimension(20, 20));
        this.panelInformacoes.add((Component)this.labelDescCelula, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelInformacoes, gridBagConstraints);
        this.panelMateriais.add(this.scrollMaterial);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.labelCelulaDestino.setDisplayedMnemonic('D');
        this.labelCelulaDestino.setLabelFor(this.textCelulaDestino);
        this.panelDestino.add((Component)this.labelCelulaDestino, gridBagConstraints);
        this.textCelulaDestino.setMinimumSize(new Dimension(80, 20));
        this.textCelulaDestino.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDestino.add((Component)this.textCelulaDestino, gridBagConstraints);
        this.buttonBuscaCelulaDestino.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCelulaDestino.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDestino.add((Component)this.buttonBuscaCelulaDestino, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.labelDescCelulaDestino.setMinimumSize(new Dimension(20, 20));
        this.labelDescCelulaDestino.setPreferredSize(new Dimension(20, 20));
        this.panelDestino.add((Component)this.labelDescCelulaDestino, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelDestino, gridBagConstraints);
        this.labelEtiqueta.setDisplayedMnemonic('E');
        this.labelEtiqueta.setLabelFor(this.textEtiqueta);
        this.labelEtiqueta.setText(" Etiqueta:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.painelCentral.add((Component)this.labelEtiqueta, gridBagConstraints);
        this.textEtiqueta.setMinimumSize(new Dimension(120, 20));
        this.textEtiqueta.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.painelCentral.add((Component)this.textEtiqueta, gridBagConstraints);
        this.checkReutilizavel.setText("Reutilizar");
        this.checkReutilizavel.setMnemonic('R');
        this.panelAdicionar.add(this.checkReutilizavel);
        this.buttonOk.setMinimumSize(new Dimension(40, 20));
        this.buttonOk.setPreferredSize(new Dimension(40, 20));
        this.buttonOk.setText("OK");
        this.panelAdicionar.add(this.buttonOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelAdicionar, gridBagConstraints);
        this.textEtiqueta.addFocusListener(new AdaptadorFoco());
        this.textCelulaDestino.addFocusListener(new AdaptadorFoco());
        this.textCelulaDestino.addKeyListener(new AdaptadorTecla());
        this.tableMaterial.addKeyListener(new AdaptadorTecla());
        this.controlaCampos();
    }

    private void removerEtiquetaSelecionada() {
        int resp;
        int row = this.tableMaterial.getSelectedRow();
        if (row > -1 && (resp = Funcoes.mensagem(this, "Deseja remover a etiqueta?", 4)) == 0) {
            this.modeloMaterial.removeLine(row);
        }
    }

    private void editarEtiquetaSelecionada() {
        int row = this.tableMaterial.getSelectedRow();
        if (row > -1) {
            this.isEditando = true;
            this.materialIdentificado = (MaterialIdentificadoBean)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("Objeto"));
            String auxReutilizar = (String)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("A\u00e7\u00e3o"));
            Boolean reutilizavel = false;
            if (auxReutilizar != null && !Funcoes.textoVazio(auxReutilizar) && auxReutilizar.equalsIgnoreCase("Reutilizar")) {
                reutilizavel = true;
            }
            this.textEtiqueta.setText(this.materialIdentificado.toString());
            this.labelVlrDataEnvio.setText(Funcoes.formataData("dd/MM/yyyy", this.materialIdentificado.getDataEnvio()));
            this.labelVlrMaterial.setText(this.materialIdentificado.getMaterial().getDescricao());
            this.labelVlrCelula.setText(this.materialIdentificado.getCelula().getCodigo().toString());
            this.labelDescCelula.setText(this.materialIdentificado.getCelula().getDescricao());
            this.checkReutilizavel.setSelected(reutilizavel);
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.checkReutilizavel);
        }
    }

    private void buscaCelulaDestino(String codigo) {
        CelulaEstoqueVO celula = null;
        try {
            celula = (CelulaEstoqueVO)new CelulaEstoqueService().getVO(codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar c\u00e9lula de destino. - " + e.getMessage(), e.getStackTrace());
        }
        if (celula == null) {
            this.textCelulaDestino.selectAll();
            this.labelDescCelulaDestino.setText("N\u00e3o cadastrado");
            ScreenUtil.requisitarFoco(this.textCelulaDestino);
        } else {
            this.textCelulaDestino.setText(celula.getCodigo().toString());
            this.labelDescCelulaDestino.setText(celula.getDescricao());
        }
    }

    private void buscaCelulaDestino() {
        CelulaEstoqueVO celula = (CelulaEstoqueVO)new CelulaEstoqueService().pesquisaVO(Laboratorio.getInstancia(), new CelulaEstoqueVO(), "Pesquisando c\u00e9lula de estoque", Acesso.getAcesso(CelulaEstoque.getModuloAcesso()));
        if (celula != null) {
            this.textCelulaDestino.setText(celula.getCodigo().toString());
            this.labelDescCelulaDestino.setText(celula.getDescricao());
        }
        ScreenUtil.requisitarFoco(this.textCelulaDestino);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk) {
            this.adicionarDadosEtiqueta(this.materialIdentificado);
            this.materialIdentificado = null;
            this.textEtiqueta.clear();
            this.labelVlrDataEnvio.setText("");
            this.labelVlrCelula.setText("");
            this.labelVlrMaterial.setText("");
            this.labelDescCelula.setText("");
            this.checkReutilizavel.setSelected(false);
            this.isEditando = false;
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textEtiqueta);
        } else if (o == this.buttonBuscaCelulaDestino) {
            this.buscaCelulaDestino();
        }
    }

    private void adicionarDadosEtiqueta(MaterialIdentificadoBean etiqueta) {
        if (this.isEditando) {
            for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                MaterialIdentificadoBean aux = (MaterialIdentificadoBean)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("Objeto"));
                if (aux != etiqueta) continue;
                this.modeloMaterial.setValueAt(this.checkReutilizavel.isSelected() ? "Reutilizar" : "Inutilizar", i, this.modeloMaterial.findColumn("A\u00e7\u00e3o"));
                break;
            }
        } else if (!this.isEtiquetaAdicionada(etiqueta)) {
            this.modeloMaterial.addLine(new Object[]{etiqueta.toString(), etiqueta.getMaterial().getDescricao(), this.checkReutilizavel.isSelected() ? "Reutilizar" : "Inutilizar", etiqueta});
        }
    }

    private boolean isEtiquetaAdicionada(MaterialIdentificadoBean etiqueta) {
        if (etiqueta != null) {
            for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                MaterialIdentificadoBean etiqAux = (MaterialIdentificadoBean)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("Objeto"));
                if (etiqueta.getFilial().getCodigo().intValue() != etiqAux.getFilial().getCodigo().intValue() || etiqueta.getCelula().getCodigo().intValue() != etiqAux.getCelula().getCodigo().intValue() || etiqueta.getCodigo().intValue() != etiqAux.getCodigo().intValue()) continue;
                Funcoes.mensagem(this, "A etiqueta j\u00e1 foi adicionada.", 2);
                return true;
            }
            return false;
        }
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300400500");
    }

    public static long getModuloAcessoCelulaEstoque() {
        return Long.parseLong("0300400501");
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.pegaCelulaPadraoEstacao();
        this.setStatus(2);
        this.controlaCampos();
        this.textEtiqueta.grabFocus();
    }

    private void pegaCelulaPadraoEstacao() {
        try {
            CelulaEstoqueBean celula = new CelulaEstoqueService().getCelulaPadraoEstacao(Variaveis.filialPadrao);
            if (celula != null) {
                this.textCelulaDestino.setText(celula.getCodigo().toString());
                this.labelDescCelulaDestino.setText(celula.getDescricao());
            } else {
                this.textCelulaDestino.clear();
                this.labelDescCelulaDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private FilialVO getFilial() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        return filial;
    }

    private UsuarioVO getUsuario() {
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        return usuario;
    }

    private EstoqueManualBean getEstoqueManual(ArrayList<MaterialIdentificadoBean> listaMateriais) {
        EstoqueManualBean bean = new EstoqueManualBean();
        bean.setFilial(this.getFilial());
        bean.setDataHora(new Date());
        bean.setObservacao("Materiais inutilizados pelo RECEBIMENTO DE MATERIAIS ENVIADOS.");
        bean.setUsuario(this.getUsuario());
        DadosMateriais array = new DadosMateriais();
        for (int i = 0; i < listaMateriais.size(); ++i) {
            MaterialIdentificadoBean aux = listaMateriais.get(i);
            array.adicionar(aux.getMaterial(), aux.getCelula(), 1);
        }
        ArrayList<EstoqueManualMaterialBean> lista = new ArrayList<EstoqueManualMaterialBean>();
        for (int i = 0; i < array.size(); ++i) {
            EstoqueManualMaterialBean mat = new EstoqueManualMaterialBean();
            mat.setFilial(this.getFilial());
            mat.setCelula(array.getCelula(i));
            mat.setEstoqueManual((EstoqueManualVO)bean.toVO());
            mat.setMaterial(array.getMaterial(i));
            mat.setQuantidade(array.getQtde(i));
            mat.setTipoOperacao("N");
            lista.add(mat);
        }
        bean.setMateriais(lista);
        return bean;
    }

    private CelulaEstoqueVO getCelulaDestino() {
        CelulaEstoqueVO celula = new CelulaEstoqueVO();
        celula.setFilial(this.getFilial());
        celula.setCodigo(Integer.parseInt(this.textCelulaDestino.getText()));
        return celula;
    }

    private ArrayList<TransfEstoqueBean> getListaTransfEstoque(ArrayList<MaterialIdentificadoBean> listaMateriais) {
        DadosTransferencia array = new DadosTransferencia();
        for (int i = 0; i < listaMateriais.size(); ++i) {
            MaterialIdentificadoBean aux = listaMateriais.get(i);
            array.adicionar(aux.getMaterial(), aux.getCelula(), 1);
        }
        ArrayList<TransfEstoqueBean> listaTransf = new ArrayList<TransfEstoqueBean>();
        for (int i = 0; i < array.size(); ++i) {
            CelulaEstoqueVO auxCelula = array.getCelula(i);
            DadosCelula auxDados = array.getDadosCelula(i);
            TransfEstoqueBean transf = new TransfEstoqueBean();
            transf.setFilial(this.getFilial());
            transf.setCelulaOrigem(auxCelula);
            transf.setCelulaDestino(this.getCelulaDestino());
            transf.setDataHora(new Date());
            transf.setOrigem("R");
            transf.setUsuario(this.getUsuario());
            ArrayList<TransfEstoqueMaterialBean> listaMatTransf = new ArrayList<TransfEstoqueMaterialBean>();
            for (int j = 0; j < auxDados.size(); ++j) {
                TransfEstoqueMaterialBean auxMat = new TransfEstoqueMaterialBean();
                auxMat.setFilial(this.getFilial());
                auxMat.setMaterial(auxDados.getMaterial(j));
                auxMat.setQuantidade(auxDados.getQtde(j));
                listaMatTransf.add(auxMat);
            }
            transf.setMateriais(listaMatTransf);
            listaTransf.add(transf);
        }
        return listaTransf;
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                ArrayList<MaterialIdentificadoBean> listaMat = this.getBeanPreenchido();
                ArrayList<MaterialIdentificadoBean> listaInutilizados = new ArrayList<MaterialIdentificadoBean>();
                ArrayList<MaterialIdentificadoBean> listaReutilizaveis = new ArrayList<MaterialIdentificadoBean>();
                MaterialIdentificadoService serviceMatIdent = new MaterialIdentificadoService();
                for (int i = 0; i < listaMat.size(); ++i) {
                    if (listaMat.get(i).getInutilizado().booleanValue()) {
                        listaInutilizados.add(listaMat.get(i));
                    } else {
                        listaReutilizaveis.add(listaMat.get(i));
                    }
                    listaMat.get(i).setDataRetorno(new Date());
                    listaMat.get(i).setUsuarioRetorno(this.getUsuario());
                    serviceMatIdent.gravaAutoCopiaSemCommit(listaMat.get(i), 1, Variaveis.filialPadrao, null);
                }
                if (listaInutilizados.size() > 0) {
                    EstoqueManualBean estoqueManual = this.getEstoqueManual(listaInutilizados);
                    new EstoqueManualService().gravaAutoCopiaSemCommit(estoqueManual, 0, Variaveis.filialPadrao, null, null);
                }
                if (listaReutilizaveis.size() > 0) {
                    ArrayList<TransfEstoqueBean> listaTransf = this.getListaTransfEstoque(listaReutilizaveis);
                    TransfEstoqueService serviceTransf = new TransfEstoqueService();
                    for (int i = 0; i < listaTransf.size(); ++i) {
                        TransfEstoqueBean transf = listaTransf.get(i);
                        serviceTransf.gravaAutoCopiaSemCommit(transf, 0, Variaveis.filialPadrao, null);
                        serviceTransf.conciliaTransferencia(transf);
                    }
                }
                Conexao.arquivaSQL();
                this.setStatus(1);
                this.limparCampos();
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private ArrayList<MaterialIdentificadoBean> getBeanPreenchido() {
        ArrayList<MaterialIdentificadoBean> listaMat = new ArrayList<MaterialIdentificadoBean>();
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            MaterialIdentificadoBean mat = (MaterialIdentificadoBean)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("Objeto"));
            String auxReut = (String)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("A\u00e7\u00e3o"));
            mat.setInutilizado(auxReut.equalsIgnoreCase("Inutilizar"));
            listaMat.add(mat);
        }
        return listaMat;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    public void limparCampos() {
        this.textEtiqueta.clear();
        this.labelVlrDataEnvio.setText("");
        this.labelVlrMaterial.setText("");
        this.labelVlrCelula.setText("");
        this.labelDescCelula.setText("");
        this.checkReutilizavel.setSelected(false);
        this.modeloMaterial.clear();
        this.textCelulaDestino.clear();
        this.labelDescCelulaDestino.setText("");
        this.materialIdentificado = null;
    }

    public void controlaCampos() {
        boolean habilita = this.getStatus() != 1;
        this.textEtiqueta.setEnabled(habilita && !this.isEditando);
        this.checkReutilizavel.setEnabled(habilita && this.materialIdentificado != null);
        this.buttonOk.setEnabled(habilita && this.materialIdentificado != null);
        this.tableMaterial.setEnabled(habilita);
        this.textCelulaDestino.setEnabled(habilita && Acesso.getAcesso(ReceberMaterialEnviado.getModuloAcessoCelulaEstoque()));
        this.buttonBuscaCelulaDestino.setEnabled(habilita && Acesso.getAcesso(ReceberMaterialEnviado.getModuloAcessoCelulaEstoque()));
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.modeloMaterial.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhuma etiqueta foi inserida.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.textCelulaDestino)) {
            Funcoes.mensagem(this, "Uma c\u00e9lula de destino deve ser selecionada.", 2);
            return false;
        }
        try {
            if (new CelulaEstoqueService().getVO(Variaveis.filialPadrao, this.textCelulaDestino.getText()) == null) {
                Funcoes.mensagem(this, "A c\u00e9lula de destino n\u00e3o existe.", 2);
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da c\u00e9lula de destino. - " + e.getMessage(), e.getStackTrace());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buscarDadosEtiqueta(String etiqueta) {
        if (etiqueta == null) return;
        if (Funcoes.textoVazio(etiqueta)) return;
        int qtdeFilial = MaterialIdentificadoBean.QTDE_CARAC_FILIAL;
        int qtdeCelula = MaterialIdentificadoBean.QTDE_CARAC_CELULA;
        int qtdeMaterial = MaterialIdentificadoBean.QTDE_CARAC_MATERIAL;
        if (etiqueta.length() != qtdeFilial + qtdeCelula + qtdeMaterial) {
            Funcoes.mensagem(this, "Etiqueta incorreta. Verifique a digita\u00e7\u00e3o.", 2);
            this.textEtiqueta.selectAll();
            ScreenUtil.requisitarFoco(this.textEtiqueta);
            return;
        }
        String filial = etiqueta.substring(0, qtdeFilial);
        String celula = etiqueta.substring(qtdeFilial, qtdeFilial + qtdeCelula);
        String codigo = etiqueta.substring(qtdeFilial + qtdeCelula, qtdeFilial + qtdeCelula + qtdeMaterial);
        MaterialIdentificadoBean matBean = null;
        try {
            matBean = (MaterialIdentificadoBean)new MaterialIdentificadoService().getBean(filial, celula, codigo);
            if (matBean != null && matBean.getDataRetorno() != null) {
                Funcoes.mensagem(this, "O material da etiqueta j\u00e1 foi recebido.", 2);
                this.textEtiqueta.selectAll();
                ScreenUtil.requisitarFoco(this.textEtiqueta);
                return;
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da etiqueta. - " + e.getMessage(), e.getStackTrace());
            this.textEtiqueta.selectAll();
            ScreenUtil.requisitarFoco(this.textEtiqueta);
            return;
        }
        if (matBean != null) {
            this.materialIdentificado = matBean;
            this.labelVlrDataEnvio.setText(Funcoes.formataData("dd/MM/yyyy", matBean.getDataEnvio()));
            this.labelVlrMaterial.setText(matBean.getMaterial().getDescricao());
            this.labelVlrCelula.setText(matBean.getCelula().getCodigo().toString());
            this.labelDescCelula.setText(matBean.getCelula().getDescricao());
            return;
        }
        Funcoes.mensagem(this, "Dados da etiqueta n\u00e3o encontrados.", 2);
        this.textEtiqueta.selectAll();
        ScreenUtil.requisitarFoco(this.textEtiqueta);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DadosTransferencia {
        ArrayList<CelulaEstoqueVO> celulas = new ArrayList();
        ArrayList<DadosCelula> dados = new ArrayList();

        DadosTransferencia() {
        }

        public void adicionar(MaterialVO material, CelulaEstoqueVO celula, Integer qtde) {
            boolean encontrado = false;
            for (int i = 0; i < this.celulas.size() && !encontrado; ++i) {
                CelulaEstoqueVO auxCel = this.celulas.get(i);
                if (auxCel.getCodigo().intValue() != celula.getCodigo().intValue()) continue;
                this.dados.get(i).adicionar(material, qtde);
                encontrado = true;
                break;
            }
            if (!encontrado) {
                DadosCelula auxDados = new DadosCelula();
                auxDados.adicionar(material, qtde);
                this.celulas.add(celula);
                this.dados.add(auxDados);
            }
        }

        public int size() {
            return this.celulas.size();
        }

        public CelulaEstoqueVO getCelula(int pos) {
            return this.celulas.get(pos);
        }

        public DadosCelula getDadosCelula(int pos) {
            return this.dados.get(pos);
        }
    }

    class DadosCelula {
        ArrayList<MaterialVO> materiais = new ArrayList();
        ArrayList<Double> qtdes = new ArrayList();

        DadosCelula() {
        }

        public void adicionar(MaterialVO material, Integer qtde) {
            boolean encontrado = false;
            for (int i = 0; i < this.materiais.size() && !encontrado; ++i) {
                MaterialVO auxMat = this.materiais.get(i);
                if (auxMat.getCodigo().intValue() != material.getCodigo().intValue()) continue;
                this.qtdes.set(i, this.qtdes.get(i) + 1.0);
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.materiais.add(material);
                this.qtdes.add(1.0);
            }
        }

        public int size() {
            return this.materiais.size();
        }

        public MaterialVO getMaterial(int pos) {
            return this.materiais.get(pos);
        }

        public Double getQtde(int pos) {
            return this.qtdes.get(pos);
        }
    }

    class DadosMateriais {
        ArrayList<MaterialVO> materiais = new ArrayList();
        ArrayList<CelulaEstoqueVO> celulas = new ArrayList();
        ArrayList<Double> qtdes = new ArrayList();

        DadosMateriais() {
        }

        public void adicionar(MaterialVO material, CelulaEstoqueVO celula, Integer qtde) {
            boolean encontrado = false;
            for (int i = 0; i < this.materiais.size() && !encontrado; ++i) {
                MaterialVO auxMat = this.materiais.get(i);
                CelulaEstoqueVO auxCel = this.celulas.get(i);
                if (auxMat.getCodigo().intValue() != material.getCodigo().intValue() || auxCel.getCodigo().intValue() != celula.getCodigo().intValue()) continue;
                this.qtdes.set(i, this.qtdes.get(i) + 1.0);
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.materiais.add(material);
                this.celulas.add(celula);
                this.qtdes.add(1.0);
            }
        }

        public int size() {
            return this.materiais.size();
        }

        public MaterialVO getMaterial(int pos) {
            return this.materiais.get(pos);
        }

        public CelulaEstoqueVO getCelula(int pos) {
            return this.celulas.get(pos);
        }

        public Double getQtde(int pos) {
            return this.qtdes.get(pos);
        }
    }

    class AdaptadorFoco
    implements FocusListener {
        AdaptadorFoco() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() == ReceberMaterialEnviado.this.textEtiqueta && !e.isTemporary() && e.getOppositeComponent() != ReceberMaterialEnviado.this.botaoCancelar) {
                ReceberMaterialEnviado.this.buscarDadosEtiqueta(ReceberMaterialEnviado.this.textEtiqueta.getText());
                ReceberMaterialEnviado.this.controlaCampos();
                if (ReceberMaterialEnviado.this.materialIdentificado != null) {
                    ScreenUtil.requisitarFoco(ReceberMaterialEnviado.this.checkReutilizavel);
                }
            } else if (e.getSource() == ReceberMaterialEnviado.this.textCelulaDestino && !Funcoes.textoVazio(ReceberMaterialEnviado.this.textCelulaDestino.getText())) {
                ReceberMaterialEnviado.this.buscaCelulaDestino(ReceberMaterialEnviado.this.textCelulaDestino.getText());
            }
        }
    }

    class AdaptadorTecla
    extends KeyAdapter {
        AdaptadorTecla() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() == ReceberMaterialEnviado.this.textCelulaDestino) {
                if (e.getKeyCode() == 113) {
                    ReceberMaterialEnviado.this.buscaCelulaDestino();
                }
            } else if (e.getSource() == ReceberMaterialEnviado.this.tableMaterial) {
                if (e.getKeyCode() == 127) {
                    ReceberMaterialEnviado.this.removerEtiquetaSelecionada();
                } else if (e.getKeyCode() == 32) {
                    ReceberMaterialEnviado.this.editarEtiquetaSelecionada();
                }
            }
        }
    }

    class AdaptadorMouse
    extends MouseAdapter {
        AdaptadorMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ReceberMaterialEnviado.this.editarEtiquetaSelecionada();
            }
        }
    }
}

