/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.cadastro.CelulaEstoque;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasMaterialEnviado;
import jalis.laboratorio.util.impressao.ImprimirReciboMaterialEnviado;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.bean.triagem.MaterialEnviadoBean;
import jalis.model.bean.triagem.MaterialEnviadoMaterialBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.TransfEstoqueVO;
import jalis.model.vo.triagem.MaterialEnviadoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.PacienteService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.service.triagem.MaterialEnviadoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class EnviarMaterial
extends FrmPadrao
implements ActionListener {
    protected JPanel panelCentro = new JPanel(new GridBagLayout());
    protected TTextField textCodigoConvenio = new TTextField(5, 1);
    protected TTextField textCodigoPaciente = new TTextField(8, 1);
    protected TTextField textCodigoMaterial = new TTextField(5, 1);
    protected TTextField textQuantidadeMaterial = new TTextField(5, 1);
    protected TTextField textCodigoCelulaOrigem = new TTextField(5, 1);
    protected JLabel labelDescricaoConvenio = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JLabel labelDescricaoPaciente = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JLabel labelCodigoCelula = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JLabel labelDescricaoCelula = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JLabel labelDescricaoMaterial = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JLabel labelDescricaoCelulaOrigem = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    protected JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    protected JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'E', this);
    protected JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    protected JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir \u25bc", 'I', this);
    protected JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    protected JButton buttonBuscaConvenio = ComponenteFactory.novoJButton(this, true);
    protected JButton buttonBuscaPaciente = ComponenteFactory.novoJButton(this, true);
    protected JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    protected JButton buttonBuscaCelulaOrigem = ComponenteFactory.novoJButton(this, true);
    protected JButton buttonOKMaterial = ComponenteFactory.novoJButton("OK", this);
    protected JPanel panelMaterial = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Materiais"));
    protected ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade"});
    protected JTable tabela = new JTable(this.modelo);
    protected JPopupMenu menu = new JPopupMenu();
    protected JMenuItem itemImprimirEtiqueta = ComponenteFactory.novoJMenuItem(this.menu, "Etiqueta", (ActionListener)this);
    protected JMenuItem itemImprimirRecibo = ComponenteFactory.novoJMenuItem(this.menu, "Recibo de entrega", (ActionListener)this);
    protected int status = 1;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_QTDE = 2;
    private final boolean permitirAlterarCelulaOrigem = Acesso.getAcesso(EnviarMaterial.getModuloAcessoCelulaEstoque());
    private int codigoGerado = -1;
    boolean isEditando = false;
    private MaterialVO materialVO = null;

    public EnviarMaterial() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Enviar material", "Enviar materiais para laborat\u00f3rio apoiado", "triagem/enviar_material_apoio.jpg");
        this.add((Component)this.panelCentro, "Center");
        this.modelo.setColumnSize(new int[]{80, 0, 100}, this.tabela);
        GridBagConstraints c = new GridBagConstraints();
        JPanel panelCelulaOrigem = new JPanel(new GridBagLayout());
        panelCelulaOrigem.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("C\u00e9lula de estoque origem"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        c.gridx = 0;
        c.gridy = 0;
        JLabel labelAux = new JLabel("C\u00e9lula estoque:");
        labelAux.setDisplayedMnemonic('s');
        labelAux.setLabelFor(this.textCodigoCelulaOrigem);
        panelCelulaOrigem.add((Component)labelAux, c);
        Dimension dim = new Dimension(70, 20);
        ++c.gridx;
        this.textCodigoCelulaOrigem.setPreferredSize(dim);
        this.textCodigoCelulaOrigem.setMinimumSize(dim);
        panelCelulaOrigem.add((Component)this.textCodigoCelulaOrigem, c);
        dim = new Dimension(20, 20);
        ++c.gridx;
        this.buttonBuscaCelulaOrigem.setPreferredSize(dim);
        this.buttonBuscaCelulaOrigem.setMinimumSize(dim);
        panelCelulaOrigem.add((Component)this.buttonBuscaCelulaOrigem, c);
        dim = new Dimension(80, 20);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDescricaoCelulaOrigem.setPreferredSize(dim);
        this.labelDescricaoCelulaOrigem.setMinimumSize(dim);
        panelCelulaOrigem.add((Component)this.labelDescricaoCelulaOrigem, c);
        this.buttonBuscaCelulaOrigem.setVisible(this.permitirAlterarCelulaOrigem);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.fill = 2;
        Insets ioriginal = c.insets;
        c.anchor = 17;
        this.panelCentro.add((Component)panelCelulaOrigem, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        labelAux = Variaveis.tipoFilialPadrao.equals("A") ? new JLabel(" Cliente:") : new JLabel(" Conv\u00eanio:");
        labelAux.setDisplayedMnemonic('v');
        labelAux.setLabelFor(this.textCodigoConvenio);
        this.panelCentro.add((Component)labelAux, c);
        dim = new Dimension(70, 20);
        this.textCodigoConvenio.setPreferredSize(dim);
        this.textCodigoConvenio.setMinimumSize(dim);
        dim = new Dimension(100, 20);
        this.textCodigoPaciente.setPreferredSize(dim);
        this.textCodigoPaciente.setMinimumSize(dim);
        ++c.gridx;
        c.insets.right = 0;
        this.panelCentro.add((Component)(Variaveis.tipoFilialPadrao.equals("A") ? this.textCodigoPaciente : this.textCodigoConvenio), c);
        dim = new Dimension(20, 20);
        this.buttonBuscaConvenio.setPreferredSize(dim);
        this.buttonBuscaConvenio.setMinimumSize(dim);
        this.buttonBuscaPaciente.setPreferredSize(dim);
        this.buttonBuscaPaciente.setMinimumSize(dim);
        ++c.gridx;
        c.insets.left = 0;
        this.panelCentro.add((Component)(Variaveis.tipoFilialPadrao.equals("A") ? this.buttonBuscaPaciente : this.buttonBuscaConvenio), c);
        dim = new Dimension(80, 20);
        this.labelDescricaoConvenio.setPreferredSize(dim);
        this.labelDescricaoPaciente.setPreferredSize(dim);
        this.labelDescricaoConvenio.setMinimumSize(dim);
        this.labelDescricaoPaciente.setMinimumSize(dim);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = ioriginal;
        c.insets.right = 2;
        this.panelCentro.add((Component)(Variaveis.tipoFilialPadrao.equals("A") ? this.labelDescricaoPaciente : this.labelDescricaoConvenio), c);
        c.insets = ioriginal;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelCentro.add((Component)new JLabel(" C\u00e9lula:"), c);
        dim = new Dimension(Variaveis.tipoFilialPadrao.equals("A") ? 100 : 70, 20);
        this.labelCodigoCelula.setPreferredSize(dim);
        this.labelCodigoCelula.setMinimumSize(dim);
        this.labelCodigoCelula.setHorizontalAlignment(4);
        ++c.gridx;
        this.panelCentro.add((Component)this.labelCodigoCelula, c);
        dim = new Dimension(80, 20);
        this.labelDescricaoCelula.setPreferredSize(dim);
        this.labelDescricaoCelula.setMinimumSize(dim);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.insets.right = 2;
        this.panelCentro.add((Component)this.labelDescricaoCelula, c);
        c.insets = ioriginal;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelCentro.add((Component)this.panelMaterial, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelCentro.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonEnviar, this.buttonCancelar, this.buttonImprimir, this.buttonFechar), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        labelAux = new JLabel("Material");
        labelAux.setDisplayedMnemonic('M');
        labelAux.setLabelFor(this.textCodigoMaterial);
        this.panelMaterial.add((Component)labelAux, c);
        c.gridx = 3;
        labelAux = new JLabel("Quantidade");
        labelAux.setDisplayedMnemonic('Q');
        labelAux.setLabelFor(this.textQuantidadeMaterial);
        this.panelMaterial.add((Component)labelAux, c);
        c.gridx = 0;
        ++c.gridy;
        dim = new Dimension(70, 20);
        this.textCodigoMaterial.setPreferredSize(dim);
        this.textCodigoMaterial.setMinimumSize(dim);
        this.panelMaterial.add((Component)this.textCodigoMaterial, c);
        ++c.gridx;
        dim = new Dimension(20, 20);
        this.buttonBuscaMaterial.setPreferredSize(dim);
        this.buttonBuscaMaterial.setMinimumSize(dim);
        this.panelMaterial.add((Component)this.buttonBuscaMaterial, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        dim = new Dimension(50, 20);
        this.labelDescricaoMaterial.setPreferredSize(dim);
        this.labelDescricaoMaterial.setMinimumSize(dim);
        this.panelMaterial.add((Component)this.labelDescricaoMaterial, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        dim = new Dimension(80, 20);
        this.textQuantidadeMaterial.setPreferredSize(dim);
        this.textQuantidadeMaterial.setMinimumSize(dim);
        this.panelMaterial.add((Component)this.textQuantidadeMaterial, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        dim = new Dimension(40, 20);
        this.buttonOKMaterial.setPreferredSize(dim);
        this.buttonOKMaterial.setMinimumSize(dim);
        this.buttonOKMaterial.setMnemonic('O');
        this.panelMaterial.add((Component)this.buttonOKMaterial, c);
        c.gridwidth = 5;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelMaterial.add((Component)new JScrollPane(this.tabela), c);
        this.textCodigoConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EnviarMaterial.this.getDadosConvenio(EnviarMaterial.this.textCodigoConvenio.getText());
            }
        });
        this.textCodigoPaciente.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EnviarMaterial.this.getDadosPaciente(EnviarMaterial.this.textCodigoPaciente.getText());
            }
        });
        this.textCodigoMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EnviarMaterial.this.getDadosMaterial(EnviarMaterial.this.textCodigoMaterial.getText());
            }
        });
        this.textCodigoCelulaOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EnviarMaterial.this.getDadosCelulaOrigem(EnviarMaterial.this.textCodigoCelulaOrigem.getText());
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && EnviarMaterial.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(EnviarMaterial.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    EnviarMaterial.this.modelo.removeLine(EnviarMaterial.this.tabela.getSelectedRow());
                    EnviarMaterial.this.controlaCampos();
                } else if (e.getKeyCode() == 32 && EnviarMaterial.this.tabela.getSelectedRow() > -1) {
                    EnviarMaterial.this.textCodigoMaterial.setText(EnviarMaterial.this.modelo.getValueAt(EnviarMaterial.this.tabela.getSelectedRow(), 0).toString());
                    EnviarMaterial.this.labelDescricaoMaterial.setText(EnviarMaterial.this.modelo.getValueAt(EnviarMaterial.this.tabela.getSelectedRow(), 1).toString());
                    EnviarMaterial.this.textQuantidadeMaterial.setText(EnviarMaterial.this.modelo.getValueAt(EnviarMaterial.this.tabela.getSelectedRow(), 2).toString());
                    EnviarMaterial.this.isEditando = true;
                    EnviarMaterial.this.controlaCampos();
                    ScreenUtil.requisitarFoco(EnviarMaterial.this.textCodigoMaterial);
                }
            }
        });
    }

    private boolean validaEnviar() {
        if (!Funcoes.isNumeric(this.textCodigoCelulaOrigem.getText()) || this.labelDescricaoCelulaOrigem.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A c\u00e9lula de estoque origem deve ser informada", 2);
            return false;
        }
        if (!Funcoes.isNumeric(this.textCodigoConvenio.getText()) || this.labelDescricaoConvenio.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O conv\u00eanio de destino dos materiais deve ser informado", 2);
            return false;
        }
        if (this.modelo.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum material foi adicionado para ser enviado", 2);
            return false;
        }
        if (Funcoes.isNumeric(this.textCodigoCelulaOrigem.getText()) && Funcoes.isNumeric(this.labelCodigoCelula.getText()) && Integer.parseInt(this.textCodigoCelulaOrigem.getText()) == Integer.parseInt(this.labelCodigoCelula.getText())) {
            Funcoes.mensagem(this, "A c\u00e9lula de estoque de origem \u00e9 a mesma de destino, n\u00e3o \u00e9 permitido transferir materiais para a mesma c\u00e9lula de estoque", 2);
            return false;
        }
        return true;
    }

    protected void controlaCampos() {
        this.buttonNovo.setEnabled(this.status == 1 || this.codigoGerado >= 0);
        this.buttonEnviar.setEnabled(this.status != 1 && this.codigoGerado < 0);
        this.buttonCancelar.setEnabled(this.status != 1 && this.codigoGerado < 0);
        this.buttonImprimir.setEnabled(this.status != 1 && this.modelo.getRowCount() > 0);
        this.textCodigoConvenio.setEnabled(this.status != 1 && !this.isEditando);
        this.buttonBuscaConvenio.setEnabled(this.status != 1 && !this.isEditando);
        this.textCodigoPaciente.setEnabled(this.status != 1 && !this.isEditando);
        this.buttonBuscaPaciente.setEnabled(this.status != 1 && !this.isEditando);
        this.textCodigoMaterial.setEnabled(this.status != 1);
        this.buttonBuscaMaterial.setEnabled(this.status != 1);
        this.textCodigoCelulaOrigem.setEnabled(this.permitirAlterarCelulaOrigem && this.status != 1 && !this.isEditando);
        this.buttonBuscaCelulaOrigem.setEnabled(this.permitirAlterarCelulaOrigem && this.status != 1 && !this.isEditando);
        this.textQuantidadeMaterial.setEnabled(this.status != 1);
        this.buttonOKMaterial.setEnabled(this.status != 1);
        this.tabela.setEnabled(this.status != 1 && !this.isEditando);
    }

    protected void limparCampos() {
        this.modelo.clear();
        this.textCodigoConvenio.clear();
        this.textCodigoPaciente.clear();
        this.textCodigoMaterial.clear();
        this.textCodigoCelulaOrigem.clear();
        this.textQuantidadeMaterial.clear();
        this.labelDescricaoConvenio.setText("");
        this.labelDescricaoPaciente.setText("");
        this.labelDescricaoMaterial.setText("");
        this.labelDescricaoCelulaOrigem.setText("");
        this.labelCodigoCelula.setText("");
        this.labelDescricaoCelula.setText("");
        this.codigoGerado = -1;
        this.materialVO = null;
    }

    private void pegaCelulaPadraoEstacao() {
        try {
            CelulaEstoqueBean celula = new CelulaEstoqueService().getCelulaPadraoEstacao(Variaveis.filialPadrao);
            if (celula != null) {
                this.textCodigoCelulaOrigem.setText(celula.getCodigo().toString());
                this.labelDescricaoCelulaOrigem.setText(celula.getDescricao());
            } else {
                this.textCodigoCelulaOrigem.clear();
                this.labelDescricaoCelulaOrigem.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (356)");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonEnviar) {
            this.enviar();
        } else if (e.getSource() == this.buttonNovo) {
            this.limparCampos();
            this.pegaCelulaPadraoEstacao();
            this.status = 2;
            this.controlaCampos();
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                this.textCodigoPaciente.grabFocus();
            } else {
                this.textCodigoConvenio.grabFocus();
            }
        } else if (e.getSource() == this.buttonCancelar) {
            if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                this.limparCampos();
                this.status = 1;
                this.controlaCampos();
            }
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonBuscaConvenio) {
            this.buscaConvenio();
        } else if (e.getSource() == this.buttonBuscaCelulaOrigem) {
            this.buscaCelulaOrigem();
        } else if (e.getSource() == this.buttonBuscaPaciente) {
            this.buscaPaciente();
        } else if (e.getSource() == this.buttonBuscaMaterial) {
            this.buscaMaterial();
        } else if (e.getSource() == this.buttonImprimir) {
            this.menu.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() + this.buttonImprimir.getHeight());
        } else if (e.getSource() == this.buttonOKMaterial) {
            this.adicionarMaterial();
        } else if (e.getSource() == this.itemImprimirEtiqueta) {
            if (this.codigoGerado < 0) {
                this.codigoGerado = this.salvar(true, false);
            }
            try {
                ImprimirEtiquetasMaterialEnviado.imprimir(Variaveis.filialPadrao, String.valueOf(this.codigoGerado), this.textCodigoConvenio.getText());
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "EnviarMaterial (473)");
            }
            this.controlaCampos();
        } else if (e.getSource() == this.itemImprimirRecibo) {
            if (this.codigoGerado < 0) {
                this.codigoGerado = this.salvar(false, true);
            }
            try {
                ImprimirReciboMaterialEnviado.imprimir(Variaveis.filialPadrao, String.valueOf(this.codigoGerado), this.textCodigoConvenio.getText());
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "EnviarMaterial (484)");
            }
            this.controlaCampos();
        }
    }

    private void adicionarMaterial() {
        if (this.labelDescricaoCelula.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel enviar materiais sem uma c\u00e9lula de estoque relacionada", 2);
            return;
        }
        if (this.materialVO != null && this.materialVO.getImobilizado() != null && this.materialVO.getSolicitarPatrimonio().booleanValue() && this.materialVO.getImobilizado().booleanValue() && this.materialVO.getSolicitarPatrimonio().booleanValue()) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel enviar materiais que requerem patrim\u00f4nio ou sejam imobilizados", 2);
            return;
        }
        if (Funcoes.isNumeric(this.textCodigoMaterial.getText()) && !this.labelDescricaoMaterial.getText().equals("N\u00e3o cadastrado") && Funcoes.isNumeric(this.textQuantidadeMaterial.getText())) {
            int pos = this.modelo.localizar(0, this.textCodigoMaterial.getText());
            if (pos > -1 && !this.isEditando) {
                BigDecimal qtde = new BigDecimal(Funcoes.limpaDecimal(this.modelo.getValueAt(pos, 2).toString()));
                qtde = qtde.add(new BigDecimal(Funcoes.limpaDecimal(this.textQuantidadeMaterial.getText())));
                this.modelo.setValueAt(String.valueOf(qtde.intValue()), pos, 2);
            } else if (this.isEditando) {
                this.modelo.setValueAt(this.textCodigoMaterial.getText(), this.tabela.getSelectedRow(), 0);
                this.modelo.setValueAt(this.labelDescricaoMaterial.getText(), this.tabela.getSelectedRow(), 1);
                this.modelo.setValueAt(this.textQuantidadeMaterial.getText(), this.tabela.getSelectedRow(), 2);
            } else {
                this.modelo.addLine(new String[]{this.textCodigoMaterial.getText(), this.labelDescricaoMaterial.getText(), this.textQuantidadeMaterial.getText()});
            }
            this.isEditando = false;
        }
        this.controlaCampos();
        this.textCodigoMaterial.clear();
        this.labelDescricaoMaterial.setText("");
        this.textQuantidadeMaterial.clear();
        this.materialVO = null;
        ScreenUtil.requisitarFoco(this.textCodigoMaterial);
    }

    private void enviar() {
        if (this.codigoGerado < 0) {
            this.codigoGerado = this.salvar(false, false);
        }
    }

    private CelulaEstoqueVO getCelulaOrigem() {
        CelulaEstoqueVO celula = new CelulaEstoqueVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        celula.setFilial(filial);
        celula.setCodigo(Integer.parseInt(this.textCodigoCelulaOrigem.getText()));
        return celula;
    }

    private CelulaEstoqueVO getCelulaDestino() {
        CelulaEstoqueVO celula = new CelulaEstoqueVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        celula.setFilial(filial);
        celula.setCodigo(Integer.parseInt(this.labelCodigoCelula.getText()));
        return celula;
    }

    private ConvenioVO getConvenio() {
        ConvenioVO convenio = new ConvenioVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        convenio.setFilial(filial);
        convenio.setCodigo(Integer.parseInt(this.textCodigoConvenio.getText()));
        return convenio;
    }

    private PacienteVO getPaciente() {
        PacienteVO paciente = new PacienteVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        paciente.setFilial(filial);
        paciente.setCodigo(Integer.parseInt(this.textCodigoPaciente.getText()));
        return paciente;
    }

    private UsuarioVO getUsuario() {
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        return usuario;
    }

    private ArrayList<MaterialEnviadoMaterialBean> getListaMaterialEnviadoMaterial(MaterialEnviadoBean matEnvBean) {
        ArrayList<MaterialEnviadoMaterialBean> lista = new ArrayList<MaterialEnviadoMaterialBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigoMaterial = this.modelo.getValueAt(i, 0).toString();
            Double qtde = Double.parseDouble(this.modelo.getValueAt(i, 2).toString());
            MaterialVO material = new MaterialVO();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            material.setFilial(filial);
            material.setCodigo(Integer.parseInt(codigoMaterial));
            material.setDescricao(this.modelo.getValueAt(i, 1).toString());
            MaterialEnviadoMaterialBean matBean = new MaterialEnviadoMaterialBean();
            matBean.setFilial(filial);
            matBean.setMaterial(material);
            matBean.setMaterialEnviado((MaterialEnviadoVO)matEnvBean.toVO());
            matBean.setQuantidade(qtde);
            lista.add(matBean);
        }
        return lista;
    }

    private MaterialEnviadoBean getMaterialEnviado() {
        MaterialEnviadoBean matEnv = new MaterialEnviadoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        matEnv.setFilial(filial);
        matEnv.setCelulaDestino(this.getCelulaDestino());
        matEnv.setCelulaOrigem(this.getCelulaOrigem());
        matEnv.setUsuario(this.getUsuario());
        matEnv.setDataHora(new Date());
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            matEnv.setPaciente(this.getPaciente());
        } else {
            matEnv.setConvenio(this.getConvenio());
        }
        matEnv.setListaMateriais(this.getListaMaterialEnviadoMaterial(matEnv));
        return matEnv;
    }

    private TransfEstoqueBean getTransfEstoque() {
        TransfEstoqueBean transfEstoque = new TransfEstoqueBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        transfEstoque.setFilial(filial);
        transfEstoque.setUsuario(this.getUsuario());
        transfEstoque.setDataHora(new Date());
        transfEstoque.setCelulaOrigem(this.getCelulaOrigem());
        transfEstoque.setCelulaDestino(this.getCelulaDestino());
        transfEstoque.setOrigem("M");
        transfEstoque.setMateriais(this.getMateriaisTransferencia(transfEstoque));
        return transfEstoque;
    }

    private ArrayList<TransfEstoqueMaterialBean> getMateriaisTransferencia(TransfEstoqueBean transfBean) {
        ArrayList<TransfEstoqueMaterialBean> lista = new ArrayList<TransfEstoqueMaterialBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigoMaterial = this.modelo.getValueAt(i, 0).toString();
            Double qtde = Double.parseDouble(this.modelo.getValueAt(i, 2).toString());
            String descricaoMaterial = this.modelo.getValueAt(i, 1).toString();
            MaterialVO material = new MaterialVO();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            material.setFilial(filial);
            material.setCodigo(Integer.parseInt(codigoMaterial));
            material.setDescricao(descricaoMaterial);
            TransfEstoqueMaterialBean matBean = new TransfEstoqueMaterialBean();
            matBean.setFilial(filial);
            matBean.setMaterial(material);
            matBean.setTransfEstoque((TransfEstoqueVO)transfBean.toVO());
            matBean.setQuantidade(qtde);
            lista.add(matBean);
        }
        return lista;
    }

    private int salvar(boolean imprimindoEtiqueta, boolean imprimindoRecibo) {
        String codigo = "-1";
        if (this.validaEnviar()) {
            try {
                MaterialEnviadoBean bean = this.getMaterialEnviado();
                new MaterialEnviadoService().gravaAutoCopiaSemCommit(bean, this.status == 2 ? 0 : 1, Variaveis.filialPadrao, null);
                codigo = bean.getCodigo().toString();
                TransfEstoqueService transfService = new TransfEstoqueService();
                TransfEstoqueBean transfEstoque = this.getTransfEstoque();
                for (TransfEstoqueMaterialBean mat : transfEstoque.getMateriais()) {
                    SaldoEstoqueCelulaBean saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(transfEstoque.getFilial().getCodigo().toString(), mat.getMaterial().getCodigo().toString(), transfEstoque.getCelulaOrigem().getCodigo().toString());
                    if (saldo != null && !(saldo.getSaldo() < mat.getQuantidade())) continue;
                    Funcoes.mensagem(this, "Quantidade em estoque insuficiente para transferir o material:\n\"" + mat.getMaterial().getDescricao() + "\".\n\nQuantidade em estoque atual: " + Funcoes.formataDecimal(saldo == null ? 0.0 : saldo.getSaldo()), 2);
                    Conexao.anulaSQL();
                    return -1;
                }
                transfService.gravaAutoCopiaSemCommit(transfEstoque, this.status == 2 ? 0 : 1, Variaveis.filialPadrao, null);
                transfService.conciliaTransferencia(transfEstoque);
                Conexao.arquivaSQL();
                String mensagem = "Deseja imprimir as etiquetas de identifica\u00e7\u00e3o e o recibo de entrega dos materiais?";
                if (imprimindoEtiqueta) {
                    mensagem = "Deseja imprimir o recibo de entrega dos materiais?";
                } else if (imprimindoRecibo) {
                    mensagem = "Deseja imprimir as etiquetas de identifica\u00e7\u00e3o dos materiais?";
                }
                if (Funcoes.mensagem(this, mensagem, 4) == 0) {
                    SplashMensagem splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Aguarde... Imprimindo...");
                    if (!imprimindoEtiqueta) {
                        ImprimirEtiquetasMaterialEnviado.imprimir(Variaveis.filialPadrao, codigo, this.textCodigoConvenio.getText());
                    }
                    if (!imprimindoRecibo) {
                        ImprimirReciboMaterialEnviado.imprimir(Variaveis.filialPadrao, codigo, this.textCodigoConvenio.getText());
                    }
                    splash.apagar();
                }
                if (!imprimindoEtiqueta && !imprimindoRecibo) {
                    this.status = 1;
                    this.limparCampos();
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (567)");
                return -1;
            }
        }
        return Integer.parseInt(codigo);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300400400");
    }

    public static long getModuloAcessoCelulaEstoque() {
        return Long.parseLong("0300400401");
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(this.getTopLevelAncestor(), false, true);
        if (resultado != null) {
            this.textCodigoConvenio.setText(resultado.get("con_codigo").toString());
        }
        this.textCodigoConvenio.requestFocus();
    }

    private void buscaPaciente() {
        Hashtable resultado = Pesquisas.paciente(this.getTopLevelAncestor(), Variaveis.filialPadrao, true, false, false, false);
        if (resultado != null) {
            this.textCodigoPaciente.setText(resultado.get("pac_codigo").toString());
        }
        this.textCodigoPaciente.requestFocus();
    }

    private void buscaMaterial() {
        AbstractThreadVO vo = new MaterialService().pesquisaAtivosVO(this.getTopLevelAncestor(), new MaterialVO(), "Pesquisando material", Acesso.getAcesso(Material.getModuloAcesso()));
        if (vo != null) {
            this.textCodigoMaterial.setText(((MaterialVO)vo).getCodigo().toString());
        }
        this.textCodigoMaterial.requestFocus();
    }

    private void buscaCelulaOrigem() {
        AbstractThreadVO vo = new CelulaEstoqueService().pesquisaVO(this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Pesquisando c\u00e9lula de estoque", Acesso.getAcesso(CelulaEstoque.getModuloAcesso()));
        if (vo != null) {
            this.textCodigoCelulaOrigem.setText(((CelulaEstoqueVO)vo).getCodigo().toString());
        }
        this.textCodigoCelulaOrigem.requestFocus();
    }

    private void getDadosConvenio(String codigo) {
        block7: {
            this.labelCodigoCelula.setText("");
            this.labelDescricaoCelula.setText("");
            if (codigo != null && !Funcoes.textoVazio(codigo)) {
                try {
                    AbstractThreadVO vo = new ConvenioService().getVO(codigo);
                    if (vo != null) {
                        ConvenioVO con = (ConvenioVO)((AbstractThreadBean)vo).toVO();
                        this.labelDescricaoConvenio.setText(con.getFantasia());
                        if (con.getCelulaEstoque() != null) {
                            this.labelCodigoCelula.setText(con.getCelulaEstoque().getCodigo().toString());
                            this.labelDescricaoCelula.setText(con.getCelulaEstoque().getDescricao());
                        } else {
                            this.labelDescricaoCelula.setText("N\u00e3o cadastrado");
                        }
                        break block7;
                    }
                    this.labelDescricaoConvenio.setText("N\u00e3o cadastrado");
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (202)");
                }
            } else {
                this.labelDescricaoConvenio.setText("");
            }
        }
    }

    private void getDadosPaciente(String codigo) {
        block7: {
            this.labelCodigoCelula.setText("");
            this.labelDescricaoCelula.setText("");
            if (codigo != null && !Funcoes.textoVazio(codigo)) {
                try {
                    AbstractThreadVO vo = new PacienteService().getVO(codigo);
                    if (vo != null) {
                        PacienteVO pac = (PacienteVO)((AbstractThreadBean)vo).toVO();
                        this.labelDescricaoPaciente.setText(pac.getNome());
                        if (pac.getCelulaEstoque() != null) {
                            this.labelCodigoCelula.setText(pac.getCelulaEstoque().getCodigo().toString());
                            this.labelDescricaoCelula.setText(pac.getCelulaEstoque().getDescricao());
                        } else {
                            this.labelDescricaoCelula.setText("N\u00e3o cadastrado");
                        }
                        break block7;
                    }
                    this.labelDescricaoConvenio.setText("N\u00e3o cadastrado");
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (233)");
                }
            } else {
                this.labelDescricaoPaciente.setText("");
            }
        }
    }

    private void getDadosMaterial(String codigo) {
        block5: {
            if (codigo != null && !Funcoes.textoVazio(codigo)) {
                try {
                    AbstractThreadBean vo = new MaterialService().getAtivoVO(Variaveis.filialPadrao.toString(), codigo);
                    if (vo != null) {
                        MaterialVO mat = (MaterialVO)vo.toVO();
                        this.labelDescricaoMaterial.setText(mat.getDescricao());
                        this.materialVO = mat;
                        break block5;
                    }
                    this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (266)");
                }
            } else {
                this.labelDescricaoMaterial.setText("");
            }
        }
    }

    private void getDadosCelulaOrigem(String codigo) {
        block5: {
            if (codigo != null && !Funcoes.textoVazio(codigo)) {
                try {
                    AbstractThreadBean vo = new CelulaEstoqueService().getVO(codigo);
                    if (vo != null) {
                        CelulaEstoqueVO pac = (CelulaEstoqueVO)vo.toVO();
                        this.labelDescricaoCelulaOrigem.setText(pac.getDescricao());
                        break block5;
                    }
                    this.labelDescricaoCelulaOrigem.setText("N\u00e3o cadastrado");
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EnviarMaterial (471)");
                }
            } else {
                this.labelDescricaoCelulaOrigem.setText("");
            }
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoConvenio.hasFocus()) {
            this.buscaConvenio();
        } else if (this.textCodigoPaciente.hasFocus()) {
            this.buscaPaciente();
        } else if (this.textCodigoMaterial.hasFocus()) {
            this.buscaMaterial();
        }
        if (this.textCodigoCelulaOrigem.hasFocus()) {
            this.buscaCelulaOrigem();
        }
    }
}

