/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.laboratorio.DisposeListener;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class DialogoRequisicaoIncompleta
extends JDialog
implements ActionListener,
DisposeListener {
    public static final String CHAVE_IMPRIMIR = "campoImprimir";
    private JPanel panelDescricao = new JPanel(new GridBagLayout());
    private JButton buttonTodos = ComponenteFactory.novoJButton("Todos", 'T', this, null, null);
    private JButton buttonNenhum = ComponenteFactory.novoJButton("Nenhum", 'T', this, null, null);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JTable tableItens = new JTable();
    private ModeloResultSet modelo;
    private GridBagConstraints consDescricao = new GridBagConstraints();
    private boolean ok;
    private boolean marcarTodas = true;

    public static DialogoRequisicaoIncompleta novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoRequisicaoIncompleta((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoRequisicaoIncompleta((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoRequisicaoIncompleta(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public DialogoRequisicaoIncompleta(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public void centralizar() {
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
    }

    public void setMarcarTodas(boolean marcar) {
        this.marcarTodas = marcar;
    }

    public void setConfirmacaoImpressao(boolean confirmacao) {
        this.buttonTodos.setVisible(confirmacao);
        this.buttonNenhum.setVisible(confirmacao);
        this.buttonCancelar.setVisible(confirmacao);
    }

    public void setConfirmaCancela(boolean confirmacao) {
        this.buttonCancelar.setVisible(confirmacao);
    }

    public void addLinhaDescricao(String linhaDesc) {
        this.panelDescricao.add((Component)new JLabel(linhaDesc), this.consDescricao);
        ++this.consDescricao.gridy;
    }

    public void setModelo(ModeloResultSet modelo) {
        if (modelo != null) {
            this.modelo = modelo;
            for (Registro reg : modelo.getRegistros()) {
                reg.setValor(CHAVE_IMPRIMIR, this.marcarTodas);
            }
            this.tableItens.setModel(modelo);
            modelo.setColunaEditavel(CHAVE_IMPRIMIR);
            modelo.fireTableStructureChanged();
            modelo.fireTableDataChanged();
            if (this.tableItens.getColumnCount() == 2 || this.tableItens.getColumnCount() == 3) {
                TableColumnModel model = this.tableItens.getColumnModel();
                model.getColumn(0).setMaxWidth(65);
                model.getColumn(0).setMinWidth(65);
                if (this.tableItens.getColumnCount() == 3) {
                    model.getColumn(2).setMaxWidth(70);
                    model.getColumn(2).setMinWidth(70);
                }
            }
        }
    }

    public boolean ok() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if ((o == this.buttonTodos || o == this.buttonNenhum) && this.modelo != null) {
            for (Registro reg : this.modelo.getRegistros()) {
                reg.setValor(CHAVE_IMPRIMIR, o == this.buttonTodos);
            }
            this.modelo.fireTableDataChanged();
        } else if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        }
    }

    private void iniciar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panelAux = new JPanel(new FlowLayout(0, 3, 3));
        panel.add((Component)panelAux, "West");
        panelAux.add(this.buttonTodos);
        panelAux.add(this.buttonNenhum);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        panel.add((Component)panelAux, "Center");
        panelAux.add(this.buttonOk);
        panelAux.add(this.buttonCancelar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        this.getContentPane().add((Component)this.panelDescricao, "North");
        this.getContentPane().add((Component)new JScrollPane(this.tableItens), "Center");
        this.panelDescricao.setBorder(BorderFactory.createTitledBorder(""));
        this.tableItens.setPreferredScrollableViewportSize(new Dimension(450, 200));
        this.tableItens.getTableHeader().setReorderingAllowed(false);
        this.consDescricao.fill = 1;
        this.consDescricao.weightx = 0.5;
        this.consDescricao.weighty = 0.5;
        this.consDescricao.gridx = 0;
        this.consDescricao.gridy = 0;
    }
}

