/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.laboratorio.triagem.apoio.conferencialote.ConferenciaLote;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class DialogoExamesRequisicao
extends JDialog
implements ActionListener {
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Marcar todos", '\u0000', this, null, null);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar todos", '\u0000', this, null, null);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private List modelo;
    private List<Integer> conferidos = new ArrayList<Integer>();
    private boolean ok;

    public static DialogoExamesRequisicao novaInstancia(Object pai, String requisicao, List tubos) {
        if (pai instanceof Frame) {
            return new DialogoExamesRequisicao((Frame)pai, requisicao, tubos);
        }
        if (pai instanceof Dialog) {
            return new DialogoExamesRequisicao((Dialog)pai, requisicao, tubos);
        }
        return null;
    }

    public DialogoExamesRequisicao(Frame pai, String requisicao, List tubos) {
        super(pai, "Exames da requisi\u00e7\u00e3o " + requisicao, true);
        this.iniciar(tubos);
    }

    public DialogoExamesRequisicao(Dialog pai, String requisicao, List tubos) {
        super(pai, "Exames da requisi\u00e7\u00e3o " + requisicao, true);
        this.iniciar(tubos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            Boolean valor = o == this.buttonMarcarTodos ? Boolean.TRUE : Boolean.FALSE;
            for (int i = 2; i < this.modelo.size(); i += 3) {
                if (this.conferidos.contains(new Integer(i / 3))) continue;
                this.modelo.set(i, valor);
            }
            this.repaint();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public List<String> getSelecionados() {
        ArrayList<String> sels = new ArrayList<String>();
        for (int i = 2; i < this.modelo.size(); i += 3) {
            if (!((Boolean)this.modelo.get(i)).booleanValue() || this.conferidos.contains(new Integer(i / 3))) continue;
            sels.add((String)this.modelo.get(i - 2));
        }
        return sels;
    }

    private void iniciar(List tubos) {
        for (int i = 2; i < tubos.size(); i += 3) {
            if (((Boolean)tubos.get(i)).booleanValue()) {
                this.conferidos.add(new Integer(i / 3));
                continue;
            }
            tubos.set(i, Boolean.TRUE);
        }
        final JLabel label = new JLabel();
        label.setOpaque(true);
        label.setPreferredSize(new Dimension(10, 30));
        final JCheckBox check = new JCheckBox();
        check.setOpaque(true);
        final String[] colunas = new String[]{"Tubo", "Exame/Material", "Conferido"};
        this.modelo = tubos;
        JTable table = new JTable(new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2 && !DialogoExamesRequisicao.this.conferidos.contains(new Integer(row));
            }

            @Override
            public String getColumnName(int column) {
                return colunas[column];
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return column == 2 ? Boolean.class : String.class;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return DialogoExamesRequisicao.this.modelo.get(row * 3 + column);
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                DialogoExamesRequisicao.this.modelo.set(row * 3 + column, aValue);
            }

            @Override
            public int getRowCount() {
                return DialogoExamesRequisicao.this.modelo.size() / 3;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        });
        table.setDefaultRenderer(String.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color back;
                Color color = back = DialogoExamesRequisicao.this.conferidos.contains(new Integer(row)) ? ConferenciaLote.COR_LIDO : table.getBackground();
                if (isSelected) {
                    back = back == ConferenciaLote.COR_LIDO ? ScreenUtil.escurecerCor(back, 30) : table.getSelectionBackground();
                }
                label.setBackground(back);
                label.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                label.setFont(table.getFont());
                label.setText(value.toString());
                label.setHorizontalAlignment(column == 1 ? 2 : 0);
                return label;
            }
        });
        table.setDefaultRenderer(Boolean.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color back;
                boolean conferido = (Boolean)value;
                Color color = back = DialogoExamesRequisicao.this.conferidos.contains(new Integer(row)) ? ConferenciaLote.COR_LIDO : table.getBackground();
                if (isSelected) {
                    back = back == ConferenciaLote.COR_LIDO ? ScreenUtil.escurecerCor(back, 30) : table.getSelectionBackground();
                }
                check.setBackground(back);
                check.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                check.setHorizontalAlignment(0);
                check.setSelected(conferido);
                check.setEnabled(!DialogoExamesRequisicao.this.conferidos.contains(new Integer(row)));
                return check;
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel aux = new JPanel(new FlowLayout(0, 3, 3));
        this.getContentPane().add((Component)panel, "South");
        panel.add((Component)aux, "West");
        aux.add(this.buttonMarcarTodos);
        aux.add(this.buttonDesmarcarTodos);
        aux = new JPanel(new FlowLayout(2, 3, 3));
        panel.add((Component)aux, "Center");
        aux.add(this.buttonOk);
        aux.add(this.buttonCancelar);
        this.getContentPane().add((Component)new JScrollPane(table), "Center");
        for (int i = 0; i < table.getRowCount(); ++i) {
            JLabel l = new JLabel(table.getValueAt(i, 1).toString());
            l.setFont(table.getFont());
            int h = l.getPreferredSize().height;
            table.setRowHeight(i, l.getPreferredSize().height + 5);
        }
        table.getColumnModel().getColumn(0).setMaxWidth(35);
        table.getColumnModel().getColumn(2).setMaxWidth(75);
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
    }
}

