/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class DescritorCodigoLote {
    private String codigoFilial;
    private String codigoLote;
    private String codigoConvenio;

    public DescritorCodigoLote(String codigoFilial, String codigoLote, String codigoConvenio) {
        this.codigoFilial = codigoFilial;
        this.codigoLote = codigoLote;
        this.codigoConvenio = codigoConvenio;
    }

    public DescritorCodigoLote(String codigoDozeDigitos) {
        if (!Funcoes.textoVazio(codigoDozeDigitos) && codigoDozeDigitos.matches("\\d{12}")) {
            this.codigoFilial = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(0, 2));
            this.codigoConvenio = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(2, 6));
            this.codigoLote = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(6, 12));
        } else if (!Funcoes.textoVazio(codigoDozeDigitos) && codigoDozeDigitos.matches("\\d{15}")) {
            this.codigoFilial = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(0, 2));
            this.codigoConvenio = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(2, 6));
            this.codigoLote = StringUtil.removeZerosEsquerda(codigoDozeDigitos.substring(6, 15));
        }
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public String getCodigoLote() {
        return this.codigoLote;
    }

    public String getCodigoConvenio() {
        return this.codigoConvenio;
    }

    public boolean isValido() {
        return !Funcoes.textoVazio(this.codigoFilial) && !Funcoes.textoVazio(this.codigoLote) && !Funcoes.textoVazio(this.codigoConvenio);
    }
}

