/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;

public abstract class DescritorCodigoEtiqueta {
    public String codigo;
    public String filial;
    public String requisicao;
    public String tubo;
    public String filialApoio;
    public String requisicaoApoiado;

    public static DescritorCodigoEtiqueta getDescritor(String codigo) {
        DescritorCodigoEtiqueta descritorCodigoEtiqueta = null;
        int quantidadeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        if (ParametrosGerais.getDigitosTuboFilial() == 0 || ParametrosGerais.getDigitosTuboRequisicao() == 0 || ParametrosGerais.getDigitosTuboTubo() == 0) {
            descritorCodigoEtiqueta = null;
        } else if (codigo != null && codigo.matches("\\d{12}")) {
            descritorCodigoEtiqueta = new DescritorCodigoDozeDigitos(codigo);
        } else if (codigo != null && codigo.matches("\\d{10}")) {
            descritorCodigoEtiqueta = new DescritorCodigoDezDigitos(codigo);
        } else if (codigo != null && codigo.matches("\\d{".concat(Funcoes.preencheZero(quantidadeDigitos, 2)).concat("}"))) {
            descritorCodigoEtiqueta = new DescritorCodigoVarDigitos(codigo);
        }
        if (descritorCodigoEtiqueta != null && descritorCodigoEtiqueta.getTubo() != null && !Funcoes.textoVazio(descritorCodigoEtiqueta.getTubo())) {
            new TuboDao();
            if (!TuboDao.contemCadastro(descritorCodigoEtiqueta)) {
                descritorCodigoEtiqueta = null;
            }
        }
        return descritorCodigoEtiqueta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilialJalis(String filial) {
        Statement st;
        block5: {
            boolean bl;
            if (Funcoes.textoVazio(filial) || !Funcoes.textoVazio(filial) && !Funcoes.isNumeric(filial)) {
                return false;
            }
            String sql = "select max(fil_codigo) as codigofilial from filiais_postocoleta";
            st = Conexao.getStatement();
            try {
                ResultSet rs = st.executeQuery(sql);
                if (!rs.next()) break block5;
                bl = Integer.parseInt(filial) <= rs.getInt("codigofilial");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter dados da filial.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaEtiquetaJalis(String etiqueta) {
        Statement st;
        block9: {
            String string;
            String sql2;
            String sql1;
            block8: {
                if (Funcoes.textoVazio(etiqueta) || !Funcoes.textoVazio(etiqueta) && !Funcoes.isNumeric(etiqueta)) {
                    return null;
                }
                StringBuilder buf = new StringBuilder();
                buf.append("select a.fil_codigo, a.req_codigo, exa_codigo, mco_codigo from examerequisicao a ");
                buf.append(" where a.exr_codigoapoiado = '").append(etiqueta).append("'");
                buf.append(" order by a.fil_codigo, a.req_codigo ");
                sql1 = buf.toString();
                buf.setLength(0);
                buf.append("select a.fil_codigo, a.req_codigo, a.rec_kodigo from examerequisicaorecipiente a ");
                sql2 = buf.toString();
                st = Conexao.getStatement();
                if (DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado")) break block8;
                String string2 = null;
                Conexao.fecharStatement(st);
                return string2;
            }
            try {
                ResultSet rs2;
                StringBuilder buf2;
                ResultSet rs = st.executeQuery(sql1);
                if (rs.next()) {
                    buf2 = new StringBuilder(sql2.toString());
                    buf2.append(" where a.fil_codigo = ").append(rs.getString("fil_codigo"));
                    buf2.append(" and a.req_codigo = ").append(rs.getString("req_codigo"));
                    buf2.append(" and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                    buf2.append(" and a.mco_codigo = ").append(rs.getString("mco_codigo"));
                    buf2.append(" order by a.fil_codigo, a.req_codigo ");
                    rs2 = st.executeQuery(buf2.toString());
                } else {
                    buf2 = new StringBuilder(sql2.toString());
                    buf2.append(" where a.ere_codigoapoiado = '").append(etiqueta).append("' order by req_codigo ");
                    rs2 = st.executeQuery(buf2.toString());
                }
                if (rs2 == null || !rs2.next()) break block9;
                string = rs2.getString("fil_codigo") + "," + rs2.getString("req_codigo") + "," + rs2.getString("rec_kodigo");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter dados dos exames.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    public DescritorCodigoEtiqueta(String codigo) {
        this.codigo = codigo == null ? "" : codigo;
    }

    public String getFilial() {
        return this.filial;
    }

    public String getFilialApoio() {
        return this.filialApoio;
    }

    public String getRequisicaoApoiado() {
        return this.requisicaoApoiado;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public String getTubo() {
        return this.tubo;
    }

    public boolean equals(Object obj) {
        return obj instanceof DescritorCodigoEtiqueta && ((DescritorCodigoEtiqueta)obj).codigo.equals(this.codigo);
    }

    public int hashCode() {
        int hash = 0;
        for (char c : this.codigo.toCharArray()) {
            hash += c;
        }
        return hash;
    }

    public String getTuboPreenchido() {
        return Funcoes.preencheZero(this.tubo, ParametrosGerais.getDigitosTuboTubo());
    }

    public String getRequisicaoPreenchida() {
        return Funcoes.preencheZero(this.requisicao, ParametrosGerais.getDigitosTuboRequisicao());
    }

    public String getFilialDoPreenchida() {
        return Funcoes.preencheZero(this.filial, ParametrosGerais.getDigitosTuboFilial());
    }

    private static class DescritorCodigoVarDigitos
    extends DescritorCodigoEtiqueta {
        public DescritorCodigoVarDigitos(String etiqueta) {
            super(etiqueta);
            this.filial = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
            this.requisicao = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
            this.tubo = StringUtil.removeZerosEsquerda(this.codigo.substring(this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
            String novaEtiqueta = this.buscaEtiquetaJalis(etiqueta);
            if (!Funcoes.textoVazio(novaEtiqueta)) {
                this.filialApoio = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                this.requisicaoApoiado = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
                this.filial = novaEtiqueta.split(",")[0];
                this.requisicao = novaEtiqueta.split(",")[1];
                this.tubo = novaEtiqueta.split(",")[2];
            }
        }
    }

    private static class DescritorCodigoDezDigitos
    extends DescritorCodigoEtiqueta {
        public DescritorCodigoDezDigitos(String etiqueta) {
            super(etiqueta);
            String novaEtiqueta;
            if (this.codigo.matches("\\d{10}")) {
                this.filial = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                this.requisicao = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                this.tubo = StringUtil.removeZerosEsquerda(this.codigo.substring(this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
            }
            if (!Funcoes.textoVazio(novaEtiqueta = this.buscaEtiquetaJalis(etiqueta))) {
                this.filialApoio = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                this.requisicaoApoiado = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
                this.filial = novaEtiqueta.split(",")[0];
                this.requisicao = novaEtiqueta.split(",")[1];
                this.tubo = novaEtiqueta.split(",")[2];
            }
        }
    }

    private static class DescritorCodigoDozeDigitos
    extends DescritorCodigoEtiqueta {
        public DescritorCodigoDozeDigitos(String etiqueta) {
            super(etiqueta);
            if (this.codigo.matches("\\d{12}")) {
                this.filial = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                this.requisicao = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                this.tubo = StringUtil.removeZerosEsquerda(this.codigo.substring(this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
                String novaEtiqueta = this.buscaEtiquetaJalis(etiqueta);
                if (!Funcoes.textoVazio(novaEtiqueta)) {
                    this.filialApoio = StringUtil.removeZerosEsquerda(this.codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                    this.requisicaoApoiado = StringUtil.removeZerosEsquerda(this.codigo.substring(ParametrosGerais.getDigitosTuboFilial(), this.codigo.length() - ParametrosGerais.getDigitosTuboTubo()));
                    this.filial = novaEtiqueta.split(",")[0];
                    this.requisicao = novaEtiqueta.split(",")[1];
                    this.tubo = novaEtiqueta.split(",")[2];
                }
            }
        }
    }
}

