/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesCarregaLoteUtil;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesFiltroLoteUtil;
import jalis.service.triagem.LoteFilialService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class ConferenciaDeLotesFiltroLote
extends JPanel
implements ActionListener {
    private ModeloResultSet modeloLote2 = new ModeloResultSet("Lote", "lot_codigo", "Conv\u00eanio", "con_fantasia", "Data", "lot_datahora", "Data/Hora Recebido", "lot_datahoratriagem", "", "selecionado");
    private static final String SELECIONADO = "selecionado";
    private static final String TUBO_LIDO = "tuboLido";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBO_TRIADO = "tuboTriado";
    private static final String TUBOS_OK = "tubosOk";
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private JDialog dialogFiltro;
    private ModeloResultSet modeloLote;
    private ArrayList<DescritorCodigoEtiqueta> etqConferidas;
    private ArrayList<DescritorCodigoEtiqueta> etqLidas;
    private boolean recebeAutomatico;
    private JPanel panelFiltro = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Filtrando Lote"));
    private CheckItemFiltro checkConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao, true);
    private CheckItemFiltro checkLote = new CheckItemFiltro("Lote", "Filtrar", "Filtrando lotes", "fil_codigo = " + Variaveis.filialPadrao, true);
    private final JLabel lblDataInicial = new JLabel("Data Inicial:");
    private final TTextField txtDataInicial = new TTextField(5, 4);
    private final JLabel lblDataFinal = new JLabel("Data Final:");
    private final TTextField txtDataFinal = new TTextField(5, 4);
    private final JLabel lblHoraInicial = new JLabel("Hora Inicial:");
    private final TTextField txtHoraInicial = new TTextField(5, 6);
    private final JLabel lblHoraFinal = new JLabel("Hora Final:");
    private final TTextField txtHoraFinal = new TTextField(5, 6);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'N', this, null, null);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelarFiltro = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JButton buttonSelecionarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this, null, null);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this, null, null);
    private JTable tableLoteFiltro = new JTable();
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JCheckBox checkApresentarLotesRecebidos = ComponenteFactory.novoJCheckBox("Apresentar Lotes Recebidos", 'A', this);
    private JCheckBox checkIntervaloHora = ComponenteFactory.novoJCheckBox("Intervalo de Hora", 'I', this);
    private String PARAMETRO_CONFERENCIA_DE_LOTES = null;
    private final String PARAMETRO_CONVENIO = "convenios";
    private final String PARAMETRO_LOTES = "lotes";
    private final String PARAMETRO_DATA_INICIAL = "datainicial";
    private final String PARAMETRO_DATA_FINAL = "datafinal";
    private final String PARAMETRO_HORA_INICIAL = "horainicial";
    private final String PARAMETRO_HORA_FINAL = "horafinal";
    private final String PARAMETRO_INTERVALO_HORA = "intervalohora";
    private final String PARAMETRO_LOTES_RECEBIDOS = "lotesrecebidos";
    String[] convenios = null;
    String[] lotes = null;
    private boolean isExibeJejum = true;
    private String tempoJejum = "";

    public ConferenciaDeLotesFiltroLote(ModeloResultSet modeloLote, ArrayList<DescritorCodigoEtiqueta> etqConferidas, ArrayList<DescritorCodigoEtiqueta> etqLidas, boolean recebeAutomatico) {
        this.modeloLote = modeloLote;
        this.etqConferidas = etqConferidas;
        this.etqLidas = etqLidas;
        this.recebeAutomatico = recebeAutomatico;
        this.PARAMETRO_CONFERENCIA_DE_LOTES = "ultimoFiltro";
        this.carregaParametrosUsuario();
    }

    public void iniciar() {
        this.checkConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0}, 1, false, false, false);
        this.checkLote.setDados("loteapoio", new String[]{"lot_codigo", "lot_datahora"}, new String[]{"Lote", "Data/Hora"}, new int[]{70, 0}, 0, false, false, false);
        JPanel panelPrincipal = this.montarFiltros();
        this.modeloLote2.setColunaEditavel(SELECIONADO);
        JPanel aux2 = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Lote"));
        this.tableLoteFiltro = ComponenteFactory.novoJTable((TableModel)this.modeloLote2, 70, 0, 125, 125, 20);
        JScrollPane scroll = new JScrollPane(this.tableLoteFiltro);
        scroll.setPreferredSize(new Dimension(570, 270));
        aux2.add(scroll);
        panelPrincipal.add((Component)aux2, "Center");
        JPanel panelBotoes = new JPanel(new BorderLayout());
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonSelecionarTodos, this.buttonDesmarcarTodos), "West");
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOk, this.buttonCancelarFiltro), "East");
        panelBotoes.setPreferredSize(new Dimension(580, 50));
        panelPrincipal.add((Component)panelBotoes, "South");
        this.tableLoteFiltro.getTableHeader().addMouseListener(this.modeloLote2);
        this.tableLoteFiltro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConferenciaDeLotesFiltroLote.this.tableLoteFiltro.getSelectedRow();
                ConferenciaDeLotesFiltroLote.this.tableLoteFiltro.setFocusable(true);
                if (row >= 0 && e.getKeyCode() == 32) {
                    ConferenciaDeLotesFiltroLote.this.modeloLote2.getRegistro(row).setValor(ConferenciaDeLotesFiltroLote.SELECIONADO, !ConferenciaDeLotesFiltroLote.this.modeloLote2.getRegistro(row).getBoolean(ConferenciaDeLotesFiltroLote.SELECIONADO));
                    ConferenciaDeLotesFiltroLote.this.modeloLote2.fireTableRowsUpdated(row, row);
                }
            }
        });
        this.modeloLote2.setOrdenarColunas(true);
        this.dialogFiltro.setVisible(true);
    }

    private JPanel montarFiltros() {
        this.tableLoteFiltro.setModel(this.modeloLote2);
        this.dialogFiltro = new JDialog(Laboratorio.getInstancia(), "Filtrando Lote", true);
        this.dialogFiltro.setMinimumSize(new Dimension(600, 550));
        this.dialogFiltro.setLocationRelativeTo(Laboratorio.getInstancia());
        this.dialogFiltro.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        JPanel panelPrincipal = new JPanel();
        panelPrincipal.setMinimumSize(new Dimension(585, 550));
        this.dialogFiltro.add((Component)panelPrincipal, cons);
        JPanel panelGridBag = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Filtros"));
        panelGridBag.setPreferredSize(new Dimension(580, 160));
        panelPrincipal.add((Component)panelGridBag, "Center");
        cons.gridx = 0;
        panelGridBag.add((Component)this.checkLote, cons);
        ++cons.gridy;
        cons.gridx = 0;
        this.txtDataInicial.setPreferredSize(new Dimension(110, 20));
        this.buttonDataIni.setFocusable(false);
        JPanel panel1 = ComponenteFactory.novoJPanelBorderLayout(this.txtDataInicial, null, null, this.buttonDataIni, null);
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.lblDataInicial, null, null, panel1, null), cons);
        ++cons.gridy;
        cons.gridx = 0;
        this.txtDataFinal.setPreferredSize(new Dimension(110, 20));
        this.buttonDataFin.setFocusable(false);
        JPanel panel = ComponenteFactory.novoJPanelBorderLayout(this.txtDataFinal, null, null, this.buttonDataFin, null);
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.lblDataFinal, null, null, panel, null), cons);
        cons.gridx = 2;
        cons.gridy = 0;
        panelGridBag.add((Component)this.checkConvenio, cons);
        ++cons.gridy;
        this.txtHoraInicial.setPreferredSize(new Dimension(60, 20));
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.lblHoraInicial, null, null, this.txtHoraInicial, null), cons);
        ++cons.gridy;
        cons.gridx = 2;
        this.txtHoraFinal.setPreferredSize(new Dimension(60, 20));
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.lblHoraFinal, null, null, this.txtHoraFinal, null), cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.checkIntervaloHora, null, null, null, null), cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.checkApresentarLotesRecebidos, null, null, null, null), cons);
        cons.gridx = 2;
        panelGridBag.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, this.buttonConsultar, null), cons);
        Funcoes.montaEnter((JComponent)this.dialogFiltro.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.dialogFiltro.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConferenciaDeLotesFiltroLote.this.txtDataInicial.hasFocus()) {
                    Funcoes.mostraData(ConferenciaDeLotesFiltroLote.this.txtDataInicial, ConferenciaDeLotesFiltroLote.this.buttonDataIni, (JPanel)ConferenciaDeLotesFiltroLote.this.buttonDataIni.getParent(), true);
                } else if (ConferenciaDeLotesFiltroLote.this.txtDataFinal.hasFocus()) {
                    Funcoes.mostraData(ConferenciaDeLotesFiltroLote.this.txtDataFinal, ConferenciaDeLotesFiltroLote.this.buttonDataFin, (JPanel)ConferenciaDeLotesFiltroLote.this.buttonDataFin.getParent(), true);
                }
            }
        });
        return panelPrincipal;
    }

    private void consultarLotes() {
        if (this.checkIntervaloHora.isSelected() && (Funcoes.textoVazio(this.txtDataFinal.getText()) || Funcoes.textoVazio(this.txtDataInicial.getText()) || Funcoes.textoVazio(this.txtHoraFinal.getText()) || Funcoes.textoVazio(this.txtHoraInicial.getText()))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Os campos de Data e Hora devem ser preenchidos!", 2);
        } else {
            try {
                this.lotes = this.checkLote.isSelected() ? this.checkLote.getSelecionados() : null;
                this.convenios = this.checkConvenio.isSelected() ? this.checkConvenio.getSelecionados() : null;
                List<Registro> registros = ConferenciaDeLotesFiltroLoteUtil.pesquisarLotes(this.lotes, this.convenios, this.txtDataInicial, this.txtDataFinal, this.txtHoraInicial, this.txtHoraFinal, this.checkApresentarLotesRecebidos.isSelected());
                this.modeloLote2.limpar();
                for (Registro reg : registros) {
                    this.modeloLote2.addRegistro(reg);
                    this.modeloLote2.fireTableDataChanged();
                }
                this.gravaParametrosUsuario();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLoteFiltroLote: 198");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonConsultar) {
                this.consultarLotes();
            } else if (o == this.buttonSelecionarTodos || o == this.buttonDesmarcarTodos) {
                boolean marcar = o == this.buttonSelecionarTodos;
                for (Registro reg : this.modeloLote2.getRegistros()) {
                    reg.setValor(SELECIONADO, marcar);
                }
                this.modeloLote2.fireTableDataChanged();
            } else if (o == this.buttonOk) {
                for (Registro reg : this.modeloLote2.getRegistros()) {
                    ConferenciaDeLotesCarregaLoteUtil util;
                    Registro lote;
                    if (!((Boolean)reg.getValor(SELECIONADO)).booleanValue() || (lote = (util = new ConferenciaDeLotesCarregaLoteUtil(new LoteFilialService(), this.recebeAutomatico)).carregarLote(reg.getString("lot_codigo"), this.etqConferidas, this.isExibeJejum, this.tempoJejum, null, new ArrayList<String>())) == null || !this.modeloLote.getRegistros().stream().noneMatch(r -> r.getString("lot_codigo").equals(reg.getString("lot_codigo")))) continue;
                    this.marcarExamesRequisicoesOk(lote);
                    this.modeloLote.addRegistro(lote);
                }
                this.modeloLote.fireTableDataChanged();
                this.dialogFiltro.setVisible(false);
                this.limpaCampos();
            } else if (o == this.buttonCancelarFiltro) {
                this.limpaCampos();
                this.dialogFiltro.setVisible(false);
            } else if (o == this.buttonDataIni) {
                Funcoes.mostraData(this.txtDataInicial, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
            } else if (o == this.buttonDataFin) {
                Funcoes.mostraData(this.txtDataFinal, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaLoteFiltroLote: 217");
        }
    }

    private void marcarExamesRequisicoesOk(Registro lote) {
        for (Registro req : (List)lote.getValor("requisicoes")) {
            ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
            if (modExa == null) continue;
            Boolean reqOk = Boolean.TRUE;
            for (Registro exa : modExa.getRegistros()) {
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (modCol == null) continue;
                Boolean exaLido = Boolean.FALSE;
                Boolean exaOk = Boolean.TRUE;
                for (Registro col : modCol.getRegistros()) {
                    if (!col.getBoolean(TUBOS_OK) && !col.getBoolean(TUBO_CONFERIDO)) {
                        exaOk = Boolean.FALSE;
                    }
                    if (!col.getBoolean(TUBO_LIDO)) continue;
                    exaLido = Boolean.TRUE;
                }
                exa.setValor(TUBOS_OK, exaOk);
                exa.setValor(TUBO_LIDO, exaLido);
                if (exaOk.booleanValue()) continue;
                reqOk = Boolean.FALSE;
            }
            req.setValor(TUBOS_OK, reqOk);
        }
    }

    public void carregaParametrosUsuario() {
        String parametros = ParametrosUsuarios.getValor(this.PARAMETRO_CONFERENCIA_DE_LOTES);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "convenios");
            if (!Funcoes.textoVazio(tmp)) {
                this.checkConvenio.setSelecionados(tmp.split(";"));
                this.checkConvenio.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "lotes"))) {
                this.checkLote.setSelecionados(tmp.split(";"));
                this.checkLote.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "lotesrecebidos"))) {
                this.checkApresentarLotesRecebidos.setSelected(new Boolean(tmp));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "intervalohora"))) {
                this.checkIntervaloHora.setSelected(new Boolean(tmp));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.txtDataInicial.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.txtDataFinal.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.txtHoraInicial.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.txtHoraFinal.setText(tmp);
            }
        }
    }

    public void gravaParametrosUsuario() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTagPreenchida("convenios", this.convenios));
        buf.append(this.getTagPreenchida("lotes", this.lotes));
        buf.append(this.getTagPreenchida("datainicial", this.txtDataInicial.getText()));
        buf.append(this.getTagPreenchida("datafinal", this.txtDataFinal.getText()));
        buf.append(this.getTagPreenchida("horainicial", this.txtHoraInicial.getText()));
        buf.append(this.getTagPreenchida("horafinal", this.txtHoraFinal.getText()));
        buf.append(this.getTagPreenchida("intervalohora", this.checkIntervaloHora.isSelected()));
        buf.append(this.getTagPreenchida("lotesrecebidos", this.checkApresentarLotesRecebidos.isSelected()));
        ParametrosUsuarios.setValor(this.PARAMETRO_CONFERENCIA_DE_LOTES, buf.toString());
    }

    private String getTagPreenchida(String tag, Object valor) {
        if (tag != null) {
            String retorno = "<" + tag + ">";
            if (valor != null) {
                if (valor instanceof String[]) {
                    String[] aux = (String[])valor;
                    for (int i = 0; i < aux.length; ++i) {
                        retorno = retorno + aux[i];
                        if (i >= aux.length - 1) continue;
                        retorno = retorno + ";";
                    }
                } else {
                    retorno = retorno + valor.toString();
                }
            }
            retorno = retorno + "</" + tag + ">";
            return retorno;
        }
        return null;
    }

    private void limpaCampos() {
        this.modeloLote2.limpar();
        this.txtDataInicial.clear();
        this.txtDataFinal.clear();
        this.txtHoraInicial.clear();
        this.txtHoraFinal.clear();
    }
}

