/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.apoio;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.AdicionaMensagem;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.recepcao.util.SolicitarMotivoRecoleta;
import jalis.laboratorio.triagem.apoio.ConferenciaDeLotesFiltroLote;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.laboratorio.triagem.apoio.DialogoExamesRequisicao;
import jalis.laboratorio.triagem.apoio.DialogoRequisicaoIncompleta;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesCarregaLoteUtil;
import jalis.laboratorio.triagem.apoio.util.ConferenciaDeLotesUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.model.bean.estoque.EstoqueManualBean;
import jalis.model.bean.estoque.EstoqueManualMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.bean.triagem.MaterialIdentificadoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.EstoqueManualVO;
import jalis.service.cadastro.FilialService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.EstoqueManualService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.service.recepcao.ExameRequisicaoRecipienteService;
import jalis.service.triagem.LoteFilialService;
import jalis.service.triagem.MaterialIdentificadoService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.Legenda;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ConferenciaDeLotes
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener,
FocusListener,
TableCellRenderer {
    public static final Color COR_LIDO = new Color(180, 255, 180);
    public static final Color COR_TRIADO = new Color(130, 235, 255);
    private static final String RECEBER_AUTOMATICO = "ConferenciaDeLotes.receberAutomatico";
    private static final int IMPR_REQ = 0;
    private static final int IMPR_EXA = 1;
    private static final int ETQ_TRIAGEM = 0;
    private static final int ETQ_COLETA = 1;
    private static final int CODIGO_LOTE = 0;
    private static final int CODIGO_CONVENIO = 1;
    private static final String IMPR_INCOMPLETO = "imprimirIncompleto";
    private static final String REIMPRIMIR = "reimprimir";
    private static final String TUBO_LIDO = "tuboLido";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBO_TRIADO = "tuboTriado";
    private static final String TUBOS_OK = "tubosOk";
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private static final String COD_COLETA = "cod_coleta";
    private static final String DES_COLETA = "des_coleta";
    private static final String COD_TRIAGEM = "cod_triagem";
    private static final String DES_TRIAGEM = "des_triagem";
    private static Border bordaSimples = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static Border bordaSelecionada = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final JLabel labelRenderer = new JLabel();
    private ModeloResultSet modeloExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat.", "mco_abreviatura", "Exame", "exa_descricao", "Sit", "exr_situacao");
    private ModeloResultSet modeloCol = new ModeloResultSet("C\u00f3digo", "cod_coleta", "Descri\u00e7\u00e3o", "des_coleta");
    private ModeloResultSet modeloTri = new ModeloResultSet("C\u00f3digo", "cod_triagem", "Descri\u00e7\u00e3o", "des_triagem");
    private ModeloResultSet modeloLote = new ModeloResultSet("Lote", "lot_codigo", "Conv\u00eanio", "con_fantasia", "Data", "lot_datahora");
    private ModeloResultSet modeloReq = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome");
    private ModeloResultSet modeloReqOutro = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome");
    private JTextField textTubo = new TTextField(12, 1);
    private JTable tableLotes = ComponenteFactory.novoJTable((TableModel)this.modeloLote, (ListSelectionListener)this, new int[0]);
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloReq, (ListSelectionListener)this, new int[0]);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExa, (ListSelectionListener)this, new int[0]);
    private JTable tableColeta = ComponenteFactory.novoJTable((TableModel)this.modeloCol, (ListSelectionListener)this, new int[0]);
    private JTable tableTriagem = ComponenteFactory.novoJTable(this.modeloTri);
    private JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es", 'O', this, null, null, false);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JCheckBox checkAutomatico = ComponenteFactory.novoJCheckBox("Receber material autom\u00e1tico", this);
    private JPanel panelCaixa = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Caixa"));
    private JLabel labelCaixa = new JLabel("Caixa recebida");
    private JButton buttonCaixa = ComponenteFactory.novoJButton("Receber caixa", this);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", this, null, null);
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JMenuItem subImprimirTodos = ComponenteFactory.novoJMenu(this.menuImprimir, "Imprimir Todos", '\u0000');
    private JMenuItem subImprimir = ComponenteFactory.novoJMenu(this.menuImprimir, "", '\u0000');
    private JMenuItem itemImprimirTodosColeta = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirTodosTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirTodosMapa = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Mapa", (ActionListener)this);
    private JMenuItem itemImprimirColeta = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirTriagem = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirMapa = ComponenteFactory.novoJMenuItem(this.subImprimir, "Mapa", (ActionListener)this);
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemReceberMaterial = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Receber material", (ActionListener)this);
    private JMenuItem itemMarcarMaterialFaltante = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como material faltante", (ActionListener)this);
    private JMenuItem itemMarcarRecoleta = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como recoleta", (ActionListener)this);
    private ConferenciaDeLotesFiltroLote dialogFiltro;
    private Legenda panelLegenda = new Legenda(10);
    private ImageIcon imagemCongelado = ImagemUtils.carregaImagemJalis("congelado.gif");
    private ArrayList<DescritorCodigoEtiqueta> etqLidas = new ArrayList();
    private ArrayList<DescritorCodigoEtiqueta> etqConferidas = new ArrayList();
    private String codigoConvenio;
    private String codigoLoteSelecionado = "";
    private int referenciaImpressao = 0;
    private JTable tableReqImpressao = this.tableRequisicoes;
    private boolean acessoMarcarMaterialFaltante;
    private boolean acessoReceberMaterial;
    private boolean acessoMarcarRecoleta;
    private boolean conferindoLote = false;
    private boolean loteSalvo;
    private boolean isExibiuJejum = false;
    private String tempoJejum = "";
    private boolean caixaRecebida = false;
    private String etiquetaCaixaRecebida = null;
    private LoteFilialService loteFilialService = new LoteFilialService();
    private ExameRequisicaoRecipienteService exameRequisicaoRecipienteService = new ExameRequisicaoRecipienteService();

    public ConferenciaDeLotes() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return 300500300L;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        value = value == null ? "" : value;
        labelRenderer.setText(value.toString());
        if (table != null) {
            Color back;
            Color fore;
            boolean ok;
            labelRenderer.setFont(table.getFont());
            ModeloResultSet mod = (ModeloResultSet)table.getModel();
            Registro reg = mod.getRegistro(row);
            Color corTmp = COR_TRIADO;
            boolean bl = ok = this.isNotNull(reg) && reg.getBoolean(TUBO_TRIADO);
            if (!ok) {
                ok = this.isNotNull(reg) && (table == this.tableColeta && (reg.getBoolean(TUBO_CONFERIDO) || reg.getBoolean(TUBO_LIDO)) || reg.getBoolean(TUBOS_OK));
                corTmp = COR_LIDO;
            }
            if (table == this.tableLotes && row > -1 && ((List)reg.getValor("requisicoes")).stream().allMatch(requisicao -> requisicao.getBoolean(TUBOS_OK))) {
                ok = true;
                corTmp = COR_LIDO;
            }
            Color color = fore = isSelected ? table.getSelectionForeground() : table.getForeground();
            if (table == this.tableRequisicoes && reg.getBoolean("req_urgente")) {
                Color color2 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            if (table == this.tableExames && reg.getBoolean("exr_urgente")) {
                Color color3 = fore = isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED;
            }
            Color color4 = isSelected ? (ok ? ScreenUtil.escurecerCor(corTmp, 30) : table.getSelectionBackground()) : (back = ok ? corTmp : table.getBackground());
            if (table == this.tableExames && column != 2) {
                if (column == 3) {
                    labelRenderer.setToolTipText(Tipos.tipoSituacaoExame(value.toString()));
                }
                labelRenderer.setHorizontalAlignment(0);
            } else {
                labelRenderer.setToolTipText(table.getToolTipText());
                labelRenderer.setHorizontalAlignment(table != this.tableExames && column == 0 ? 0 : 2);
            }
            if (table == this.tableExames && column == 1 && reg.getBoolean("emc_materialcongelado")) {
                labelRenderer.setHorizontalTextPosition(10);
                labelRenderer.setIcon(this.imagemCongelado);
            } else {
                labelRenderer.setIcon(null);
            }
            labelRenderer.setBackground(back);
            labelRenderer.setForeground(fore);
        }
        return labelRenderer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonFechar) {
                if (this.getParent() != null) {
                    this.getParent().removeAll();
                }
                this.setVisible(false);
            } else if (o == this.buttonNovo) {
                this.limpaCampos();
                this.conferindoLote = true;
                this.loteSalvo = false;
                this.habilitarDesabilitarBotoes();
                this.buttonOpcoes.setEnabled(false);
                this.revalidate();
                this.repaint();
                ScreenUtil.requisitarFoco(this.textTubo);
            } else if (o == this.buttonCancelar) {
                if (this.verificaMateriaisRecebidos()) {
                    this.limpaCampos();
                    this.habilitarDesabilitarBotoes();
                    this.revalidate();
                    this.repaint();
                    ScreenUtil.requisitarFoco(this.textTubo);
                }
            } else if (o == this.buttonSalvar) {
                String mensagem = "O lote n\u00e3o est\u00e1 completamente conferido. Deseja salvar?";
                if (this.todasRequisicoesCompletas() || Funcoes.mensagem(this, mensagem, 4) == 0) {
                    this.salvarLote();
                }
            } else if (o == this.buttonImprimir) {
                this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() - this.menuImprimir.getPreferredSize().height - 1);
            } else if (o == this.buttonOpcoes) {
                this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - this.menuOpcoes.getPreferredSize().height - 1);
            } else if (o == this.buttonFiltrar) {
                this.dialogFiltro = new ConferenciaDeLotesFiltroLote(this.modeloLote, this.etqConferidas, this.etqLidas, this.checkAutomatico.isSelected());
                this.dialogFiltro.iniciar();
                this.controlarBotoesSemEdicaoRelizada(!this.etqConferidas.isEmpty());
            } else if (o == this.itemMarcarMaterialFaltante) {
                this.marcarMaterialFaltante();
            } else if (o == this.itemMarcarRecoleta) {
                this.marcarRecoleta();
            } else if (o == this.itemReceberMaterial) {
                this.receberMaterial();
            } else if (o == this.itemImprimirTriagem || o == this.itemImprimirColeta) {
                if (this.referenciaImpressao == 0) {
                    this.imprimirRequisicoes(this.tableReqImpressao.getSelectedRows(), o == this.itemImprimirTriagem ? 0 : 1);
                } else if (this.referenciaImpressao == 1) {
                    this.imprimirExames(this.tableExames.getSelectedRows(), o == this.itemImprimirTriagem ? 0 : 1);
                }
            } else if (o == this.itemImprimirTodosTriagem || o == this.itemImprimirTodosColeta) {
                if (this.referenciaImpressao == 0) {
                    this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableReqImpressao.getRowCount()), o == this.itemImprimirTodosTriagem ? 0 : 1);
                } else if (this.referenciaImpressao == 1) {
                    this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExames.getRowCount()), o == this.itemImprimirTodosTriagem ? 0 : 1);
                }
            } else if (o == this.itemImprimirMapa) {
                this.imprimirMapa();
            } else if (o == this.itemImprimirTodosMapa) {
                this.imprimirTodosMapa();
            } else if (o == this.checkAutomatico) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParametrosUsuarios.setValor(ConferenciaDeLotes.RECEBER_AUTOMATICO, String.valueOf(ConferenciaDeLotes.this.checkAutomatico.isSelected()));
                        ParametrosUsuarios.salvarParametros(true);
                    }
                });
            } else if (o == this.buttonCaixa) {
                this.validaEtiquetaMaterial();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaLote: 259");
        }
    }

    private void marcarMaterialFaltante() {
        int row = this.tableExames.getSelectedRow();
        ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
        Registro reg = mod.getRegistro(row);
        if (this.isNotNull(reg)) {
            this.marcarMaterialFaltante(reg);
            reg.setValor("exr_situacao", "F");
            reg.setValor("exr_intervalojejum", "");
            mod.fireTableDataChanged();
            this.tableExames.setRowSelectionInterval(row, row);
        }
    }

    private void marcarRecoleta() {
        int row = this.tableExames.getSelectedRow();
        ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
        Registro reg = mod.getRegistro(row);
        if (this.isNotNull(reg)) {
            this.marcarRecoleta(reg);
            reg.setValor("exr_situacao", "R");
            mod.fireTableDataChanged();
            this.tableExames.setRowSelectionInterval(row, row);
        }
    }

    private void receberMaterial() throws SQLException {
        int tamanhoCompleto;
        int row = this.tableExames.getSelectedRow();
        ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
        Registro reg = mod.getRegistro(row);
        String codigoEtiqueta = this.exameRequisicaoRecipienteService.retornaCodigoEtiqueta(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
        if (this.verificaTamanhoTubo(codigoEtiqueta, tamanhoCompleto = this.validaTamanhoTubo())) {
            this.adicionarEtiqueta(codigoEtiqueta, true, false);
            this.isExibiuJejum = false;
            this.tempoJejum = "";
            mod.fireTableDataChanged();
        }
        this.conferindoLote = true;
        this.habilitarDesabilitarBotoes();
    }

    private void imprimirTodosMapa() {
        block6: {
            block5: {
                if (this.referenciaImpressao != 0) break block5;
                for (Registro registro : this.modeloReq.getRegistros()) {
                    String codigoFilial = registro.getString("fil_codigo");
                    String codigoRequisicao = registro.getString("req_codigo");
                    try {
                        Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
                    }
                    catch (Exception ex) {
                        Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
                    }
                }
                break block6;
            }
            if (this.referenciaImpressao != 1) break block6;
            String codigoFilial = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("fil_codigo");
            String codigoRequisicao = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("req_codigo");
            try {
                Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
            }
            catch (Exception ex) {
                Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
            }
        }
    }

    private void imprimirMapa() {
        try {
            if (this.referenciaImpressao == 0) {
                for (int linha : this.tableRequisicoes.getSelectedRows()) {
                    String codigoFilial = this.modeloReq.getRegistro(linha).getString("fil_codigo");
                    String codigoRequisicao = this.modeloReq.getRegistro(linha).getString("req_codigo");
                    Impressao.imprimirMapa(codigoFilial, codigoRequisicao, true);
                }
            } else if (this.referenciaImpressao == 1) {
                String codigoFilial = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("fil_codigo");
                String codigoRequisicao = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getString("req_codigo");
                String[] exame = new String[]{};
                int[] material = new int[]{};
                for (int linha : this.tableExames.getSelectedRows()) {
                    int codigoMaterial = ((ModeloResultSet)this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getValor(MODELO_EXAMES)).getRegistro(linha).getInt("mco_codigo");
                    exame = ArraysUtil.concatenar(exame, new String[]{((ModeloResultSet)this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow()).getValor(MODELO_EXAMES)).getRegistro(linha).getString("exa_codigo")});
                    material = ArraysUtil.concatenar(material, new int[]{ExameUtil.getDadosMaterial(codigoFilial, codigoMaterial).getCodigo()});
                }
                Impressao.imprimirMapa(codigoFilial, codigoRequisicao, exame, material, true, false, -1);
            }
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "Erro ao imprimir o mapa", 1);
        }
    }

    private void validaEtiquetaMaterial() {
        MaterialIdentificadoBean matIdent;
        if (this.etiquetaCaixaRecebida != null && (matIdent = this.buscarDadosEtiqueta(this.etiquetaCaixaRecebida)) != null) {
            matIdent.setDataRetorno(new Date());
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            matIdent.setUsuarioRetorno(usuario);
            int resp = Funcoes.mensagem(this, "O material \u00e9 reutiliz\u00e1vel?", 4, true);
            try {
                new MaterialIdentificadoService().gravaAutoCopiaSemCommit(matIdent, 1, Variaveis.filialPadrao, null);
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                if (resp == 1) {
                    EstoqueManualBean estoqueManual = new EstoqueManualBean();
                    estoqueManual.setFilial(filial);
                    estoqueManual.setDataHora(new Date());
                    estoqueManual.setObservacao("Materiais inutilizados pelo recebimento de caixa - CONFERENCIA DE LOTE.");
                    estoqueManual.setUsuario(usuario);
                    EstoqueManualMaterialBean mat = new EstoqueManualMaterialBean();
                    mat.setFilial(filial);
                    mat.setCelula(matIdent.getCelula());
                    mat.setEstoqueManual((EstoqueManualVO)estoqueManual.toVO());
                    mat.setMaterial(matIdent.getMaterial());
                    mat.setQuantidade(1.0);
                    mat.setTipoOperacao("N");
                    ArrayList<EstoqueManualMaterialBean> listaMat = new ArrayList<EstoqueManualMaterialBean>();
                    listaMat.add(mat);
                    estoqueManual.setMateriais(listaMat);
                    new EstoqueManualService().gravaAutoCopiaSemCommit(estoqueManual, 0, Variaveis.filialPadrao, null, null);
                } else {
                    TransfEstoqueBean transf = new TransfEstoqueBean();
                    transf.setFilial(filial);
                    transf.setCelulaOrigem(matIdent.getCelula());
                    transf.setCelulaDestino(this.pegaCelulaPadraoEstacao());
                    transf.setDataHora(new Date());
                    transf.setOrigem("R");
                    transf.setUsuario(usuario);
                    TransfEstoqueMaterialBean auxMat = new TransfEstoqueMaterialBean();
                    auxMat.setFilial(filial);
                    auxMat.setMaterial(matIdent.getMaterial());
                    auxMat.setQuantidade(1.0);
                    ArrayList<TransfEstoqueMaterialBean> listaMat = new ArrayList<TransfEstoqueMaterialBean>();
                    listaMat.add(auxMat);
                    transf.setMateriais(listaMat);
                    new TransfEstoqueService().gravaAutoCopiaSemCommit(transf, 0, Variaveis.filialPadrao, null);
                    new TransfEstoqueService().conciliaTransferencia(transf);
                }
                Conexao.arquivaSQL();
                this.buttonCaixa.setEnabled(false);
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private boolean verificaMateriaisRecebidos() {
        for (int i = 0; i < this.modeloReq.getRowCount(); ++i) {
            Registro reg = this.modeloReq.getRegistro(i);
            ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
            if (!this.isNotNull(modExa)) continue;
            for (Registro exa : modExa.getRegistros()) {
                if (!exa.getBoolean(TUBOS_OK)) continue;
                return Funcoes.mensagem(this, "As informa\u00e7\u00f5es alteradas ser\u00e3o perdidas, Deseja continuar?", 4) == 0;
            }
        }
        return true;
    }

    private void limpaCampos() {
        this.isExibiuJejum = false;
        this.tempoJejum = "";
        this.limparModelos();
        this.panelCaixa.setVisible(false);
        this.conferindoLote = false;
        this.loteSalvo = false;
        this.caixaRecebida = false;
        this.buttonOpcoes.setEnabled(false);
        this.buttonFiltrar.setEnabled(false);
        this.checkAutomatico.setEnabled(false);
        this.modeloLote.limpar();
        this.modeloReq.limpar();
        this.modeloExa.limpar();
        this.modeloCol.limpar();
        this.modeloTri.limpar();
        this.modeloReqOutro.limpar();
        this.textTubo.setText("");
        this.setCheckAutomatico();
        this.codigoLoteSelecionado = "";
    }

    private boolean verificaTamanhoTubo(String codigoEtiqueta, int tamanhoCompleto) {
        return codigoEtiqueta.length() == tamanhoCompleto;
    }

    private int validaTamanhoTubo() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    private CelulaEstoqueVO pegaCelulaPadraoEstacao() {
        try {
            return (CelulaEstoqueVO)new CelulaEstoqueService().getCelulaPadraoEstacao(Variaveis.filialPadrao).toVO();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private MaterialIdentificadoBean buscarDadosEtiqueta(String etiqueta) {
        if (etiqueta != null && !Funcoes.textoVazio(etiqueta)) {
            int qtdeFilial = MaterialIdentificadoBean.QTDE_CARAC_FILIAL;
            int qtdeCelula = MaterialIdentificadoBean.QTDE_CARAC_CELULA;
            int qtdeMaterial = MaterialIdentificadoBean.QTDE_CARAC_MATERIAL;
            if (etiqueta.length() == qtdeFilial + qtdeCelula + qtdeMaterial) {
                String filial = etiqueta.substring(0, qtdeFilial);
                String celula = etiqueta.substring(qtdeFilial, qtdeFilial + qtdeCelula);
                String codigo = etiqueta.substring(qtdeFilial + qtdeCelula, qtdeFilial + qtdeCelula + qtdeMaterial);
                MaterialIdentificadoBean matBean = null;
                try {
                    matBean = (MaterialIdentificadoBean)new MaterialIdentificadoService().getBean(filial, celula, codigo);
                    if (matBean != null && matBean.getDataRetorno() != null) {
                        Funcoes.mensagem(this, "A etiqueta j\u00e1 foi recebida.", 2);
                        return null;
                    }
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "Erro ao carregar dados da etiqueta. - " + e.getMessage(), e.getStackTrace());
                    return null;
                }
                return matBean;
            }
            Funcoes.mensagem(this, "Etiqueta incorreta.", 2);
            return null;
        }
        return null;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textTubo && e.getKeyCode() == 10) {
            int tamanhoCompleto;
            String tmp = this.textTubo.getText();
            if (this.verificaTamanhoTubo(tmp, tamanhoCompleto = this.validaTamanhoTubo())) {
                this.adicionarEtiqueta(tmp, this.checkAutomatico.isSelected(), true);
                this.isExibiuJejum = false;
                this.tempoJejum = "";
                this.conferindoLote = true;
                this.habilitarDesabilitarBotoes();
            } else if (tmp.length() <= ParametrosGerais.getDigitosTuboRequisicao() && tmp.length() > 0) {
                this.selecionarExamesRequisicao(Variaveis.filialPadrao, StringUtil.removeZerosEsquerda(tmp), this.checkAutomatico.isSelected());
            } else if (tmp.length() > tamanhoCompleto || tmp.length() > ParametrosGerais.getDigitosTuboRequisicao() && tmp.length() < tamanhoCompleto) {
                Funcoes.mensagem(this, "O c\u00f3digo \"" + tmp + "\" n\u00e3o \u00e9 v\u00e1lido", 1);
            }
            this.textTubo.setText("");
            this.tableRequisicoes.repaint();
            this.tableExames.repaint();
            this.tableColeta.repaint();
            ScreenUtil.requisitarFoco(this.textTubo);
        } else if (o == this.tableRequisicoes && e.getKeyCode() == 39) {
            ScreenUtil.requisitarFoco(this.tableExames);
        } else if (o == this.tableExames && e.getKeyCode() == 37) {
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
        } else if (!(!this.conferindoLote || o == this.textTubo || !Character.isDigit(e.getKeyChar()) || e.isAltDown() && e.isControlDown() && e.isShiftDown())) {
            this.textTubo.setText(String.valueOf(e.getKeyChar()));
            ScreenUtil.requisitarFoco(this.textTubo);
        } else if (e.getKeyCode() == 113 && this.conferindoLote) {
            this.loteSalvo = false;
            this.habilitarDesabilitarBotoes();
            this.revalidate();
            this.repaint();
            this.dialogFiltro = new ConferenciaDeLotesFiltroLote(this.modeloLote, this.etqConferidas, this.etqLidas, this.checkAutomatico.isSelected());
            this.dialogFiltro.iniciar();
        } else if (e.getKeyCode() == 10 && this.conferindoLote && this.modeloReq.getRegistros().size() > 0) {
            this.salvarLote();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes || o == this.tableExames) {
            JTable table = (JTable)o;
            table.setBorder(bordaSelecionada);
            this.tableReqImpressao = o == this.tableExames ? this.tableReqImpressao : (JTable)o;
            int n = this.referenciaImpressao = o == this.tableRequisicoes ? 0 : 1;
            if (o == this.tableRequisicoes) {
                ListSelectionModel model = table.getSelectionModel();
                this.valueChanged(new ListSelectionEvent(model, model.getMinSelectionIndex(), model.getMaxSelectionIndex(), false));
            }
            this.atualizarTextoBotaoImprimir(table);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes || o == this.tableExames) {
            JTable table = (JTable)o;
            table.setBorder(bordaSimples);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o = e.getSource();
        if (o == this.tableLotes.getSelectionModel() && this.tableLotes.getSelectedRowCount() == 1) {
            this.carregarRequisicoesPorLote(this.tableLotes.getValueAt(this.tableLotes.getSelectedRow(), 0).toString());
            this.buttonOpcoes.setEnabled(true);
        }
        if (o == this.tableRequisicoes.getSelectionModel()) {
            JTable tableTemp = this.tableRequisicoes;
            this.carregaExamePorRequisicao();
            this.atualizarTextoBotaoImprimir(tableTemp);
        } else if (o == this.tableExames.getSelectionModel()) {
            this.carregarEtiquetasPorExame();
            this.atualizarTextoBotaoImprimir(this.tableExames);
        }
    }

    public void carregaExamePorRequisicao() {
        JTable tableTemp = this.tableRequisicoes;
        ModeloResultSet modTemp = (ModeloResultSet)tableTemp.getModel();
        if (tableTemp.getSelectedRowCount() > 1) {
            this.tableExames.setModel(this.modeloExa);
            this.tableColeta.setModel(this.modeloCol);
            this.tableTriagem.setModel(this.modeloTri);
            this.redimensionarColunas();
        } else {
            try {
                ModeloResultSet mrs;
                Registro reg;
                Registro registro = reg = tableTemp.getSelectedRow() < 0 ? modTemp.getRegistro(0) : modTemp.getRegistro(tableTemp.getSelectedRow());
                if (reg != null && (mrs = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) != null) {
                    this.loteSalvo = reg.getBoolean("lot_triagem");
                    this.controlaCamposCaixa(reg.getString("lot_caixaapoio"), reg.getDate("lot_datarecebeucaixa"), reg.getString("usr_codrecebeucaixa"));
                    this.etiquetaCaixaRecebida = reg.getString("lot_caixaapoio");
                    this.tableExames.setModel(mrs);
                    this.redimensionarColunas();
                    if (mrs.getRowCount() > 0) {
                        this.tableExames.setRowSelectionInterval(0, 0);
                    }
                } else {
                    this.tableExames.setModel(this.modeloExa);
                    this.tableColeta.setModel(this.modeloCol);
                    this.tableTriagem.setModel(this.modeloTri);
                    this.redimensionarColunas();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void carregarEtiquetasPorExame() {
        ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
        if (modExa != null) {
            if (this.tableExames.getSelectedRowCount() > 1) {
                this.tableColeta.setModel(this.modeloCol);
                this.tableTriagem.setModel(this.modeloTri);
            } else {
                Registro reg;
                Registro registro = reg = this.tableExames.getSelectedRow() < 0 ? modExa.getRegistro(0) : modExa.getRegistro(this.tableExames.getSelectedRow());
                if (reg != null) {
                    ModeloResultSet mrs = (ModeloResultSet)reg.getValor(MODELO_COLETA);
                    if (mrs != null) {
                        this.tableColeta.setModel(mrs);
                        if (this.isNotNull(reg) && (mrs = (ModeloResultSet)reg.getValor(MODELO_TRIAGEM)) != null) {
                            this.tableTriagem.setModel(mrs);
                        }
                    } else {
                        this.tableColeta.setModel(this.modeloCol);
                        this.tableTriagem.setModel(this.modeloTri);
                    }
                    this.redimensionarColunas();
                    this.habilitarOpcoes(modExa.getRegistro(this.tableExames.getSelectedRow()));
                }
            }
        }
    }

    private boolean carregarRequisicoesPorLote(String codigoDozeDigitos) {
        this.modeloReq.limpar();
        this.modeloReqOutro.limpar();
        this.modeloExa.limpar();
        this.modeloTri.limpar();
        this.modeloCol.limpar();
        if (this.tableLotes.getSelectedRow() >= 0) {
            this.modeloReq.addRegistros((List)this.modeloLote.getRegistro(this.tableLotes.getSelectedRow()).getValor("requisicoes"));
            this.carregaExamePorRequisicao();
            this.carregarEtiquetasPorExame();
        } else {
            this.modeloReq.addRegistros((List)this.modeloLote.getRegistro(0).getValor("requisicoes"));
            this.carregaExamePorRequisicao();
            this.carregarEtiquetasPorExame();
        }
        if (this.tableRequisicoes.getRowCount() > 0) {
            this.tableRequisicoes.setRowSelectionInterval(0, 0);
        }
        return this.tableLotes.getSelectedRow() >= 0;
    }

    private boolean possuiMaterialParaReceber(DescritorCodigoEtiqueta dce) {
        List<Registro> requisicoes = this.modeloReq.getRegistros();
        for (Registro requisicao : requisicoes) {
            ModeloResultSet modExa = (ModeloResultSet)requisicao.getValor(MODELO_EXAMES);
            if (modExa == null) continue;
            for (Registro exa : modExa.getRegistros()) {
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (modCol == null) continue;
                for (Registro col : modCol.getRegistros()) {
                    if (!exa.getString("exr_situacao").equals("F") || !col.getString(COD_COLETA).equals(dce.getTubo())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void adicionarEtiqueta(String etiqueta, boolean isReceberMaterial, boolean adicionaEtiqueta) {
        String requisicao;
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
        if (dce == null) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida", 1);
            return;
        }
        if (!this.contemCadastro(dce)) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada", 1);
            return;
        }
        if (this.etqConferidas.contains(dce) && !isReceberMaterial) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi conferida", 2);
            return;
        }
        if (this.etqLidas.contains(dce)) {
            if (!this.possuiMaterialParaReceber(dce)) {
                Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi adicionada", 2);
                return;
            }
        } else if (this.etqLidas.contains(dce) && isReceberMaterial) {
            this.etqLidas.remove(dce);
        }
        if (!this.modeloReq.contemValor("req_codigo", requisicao = dce.requisicao) && ConferenciaDeLotesUtil.etiquetaJaConferida(dce)) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi conferida em outro lote.", 2);
            return;
        }
        JTable tabela = this.tableRequisicoes;
        ModeloResultSet modelo = this.modeloReq;
        if (!this.modeloReq.contemValor("req_codigo", requisicao)) {
            List<DescritorCodigoLote> lotes = this.getLoteRequisicao(dce.filial, requisicao);
            if (lotes.isEmpty()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A requisi\u00e7\u00e3o \"" + requisicao + "\" n\u00e3o faz parte de um lote, e n\u00e3o ser\u00e1 adicionada.", 2);
                return;
            }
            for (DescritorCodigoLote lote : lotes) {
                Registro loteRegistro;
                ConferenciaDeLotesCarregaLoteUtil util = new ConferenciaDeLotesCarregaLoteUtil(this.loteFilialService, this.checkAutomatico.isSelected());
                String tubo = dce.getTubo();
                if (!adicionaEtiqueta) {
                    requisicao = null;
                    tubo = null;
                }
                if ((loteRegistro = util.carregarLote(lote.getCodigoLote(), this.etqConferidas, this.isExibiuJejum, this.tempoJejum, etiqueta, Arrays.asList(dce.getTubo()))) == null || this.modeloLote.getRegistros().stream().anyMatch(a -> a.getString("lot_codigo").equals(loteRegistro.getString("lot_codigo")))) continue;
                this.modeloLote.addRegistro(loteRegistro);
            }
            this.modeloLote.fireTableDataChanged();
            modelo = this.modeloReqOutro;
            this.modeloLote.fireTableDataChanged();
            if (this.tableLotes.getSelectedRow() < 0 && this.tableLotes.getRowCount() > 0) {
                this.tableLotes.setRowSelectionInterval(0, 0);
            }
            this.revalidate();
            this.repaint();
        }
        ArrayList<DescritorCodigoEtiqueta> tmp = new ArrayList<DescritorCodigoEtiqueta>();
        tmp.add(dce);
        this.etqLidas.add(dce);
        this.confereRequisicao(dce.filial, requisicao, tabela, modelo, tmp, isReceberMaterial);
        Integer[] guias = null;
        try {
            if (this.isAgrupaMultiguias(dce) && this.contemMultiguias(guias = RecepcaoUtil.verificaMultiGuias(dce.filial, requisicao))) {
                for (int i = 0; i < guias.length; ++i) {
                    this.confereRequisicao(dce.filial, String.valueOf(guias[i]), tabela, modelo, tmp, isReceberMaterial);
                }
            }
            guias = this.verificaAgrupaMultiguias(dce.filial, requisicao);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        if (guias != null) {
            for (int i = 0; i < guias.length; ++i) {
                this.confereRequisicao(dce.filial, String.valueOf(guias[i]), tabela, modelo, tmp, isReceberMaterial);
            }
        }
        ScreenUtil.requisitarFoco(tabela);
        this.marcarExamesRequisicoesOk(modelo);
        this.loteSalvo = false;
    }

    private boolean contemMultiguias(Integer[] guias) {
        return guias != null && guias.length > 0;
    }

    private boolean isAgrupaMultiguias(DescritorCodigoEtiqueta dce) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), dce.filial, dce.requisicao);
    }

    private Integer[] verificaAgrupaMultiguias(String filial, String requisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(filial, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(requisicao)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String filial, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, multiguias);
    }

    private void confereRequisicao(String filial, String requisicao, JTable tabela, ModeloResultSet modelo, ArrayList<DescritorCodigoEtiqueta> tmp, boolean isReceberMaterial) {
        int indice;
        if (!modelo.contemValor("req_codigo", requisicao)) {
            this.adicionarRequisicao(modelo, filial, requisicao);
            modelo.fireTableDataChanged();
        }
        if ((indice = modelo.getIndice("req_codigo", requisicao)) > -1 && tabela.getRowCount() - 1 >= indice) {
            tabela.setRowSelectionInterval(indice, indice);
        }
        this.conferirEtiquetas(tmp, modelo.getRegistro(indice), isReceberMaterial);
    }

    public boolean loteJaAdicionado(List<DescritorCodigoLote> lote, String requisicao) {
        int i;
        for (i = 0; i < this.tableLotes.getRowCount(); ++i) {
            for (DescritorCodigoLote descritorCodigoLote : lote) {
                if (!this.tableLotes.getValueAt(i, 0).equals(descritorCodigoLote.getCodigoLote())) continue;
                this.tableLotes.setRowSelectionInterval(i, i);
            }
        }
        for (i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
            if (!this.tableRequisicoes.getValueAt(i, 0).equals(requisicao)) continue;
            this.tableRequisicoes.setRowSelectionInterval(i, i);
            return true;
        }
        return false;
    }

    private void selecionarExamesRequisicao(String filial, String requisicao, boolean isReceberMaterial) {
        List tubos = this.getTubosRequisicao(filial, requisicao);
        boolean todosConferidos = tubos.stream().allMatch(a -> (Boolean)((Object[])a)[1]);
        if (tubos.isEmpty()) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" n\u00e3o cont\u00e9m etiquetas cadastradas", 1);
        } else if (todosConferidos) {
            if (this.modeloReq.contemValor("req_codigo", requisicao)) {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" j\u00e1 est\u00e1 completamente conferida", 2);
            } else {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + requisicao + "\" j\u00e1 est\u00e1 completamente conferida em outro lote", 2);
            }
        } else {
            List conf = this.getTubosRequisicaoConf(filial, requisicao);
            DialogoExamesRequisicao der = DialogoExamesRequisicao.novaInstancia(this.getTopLevelAncestor(), requisicao, conf);
            List<DescritorCodigoLote> lotes = this.getLoteRequisicao(filial, requisicao);
            if (der != null) {
                der.setVisible(true);
                if (der.ok()) {
                    int indice;
                    JTable tabela = this.tableRequisicoes;
                    ModeloResultSet modelo = this.modeloReq;
                    ArrayList<String> tubosSelecionados = new ArrayList();
                    if (!this.modeloReq.contemValor("req_codigo", requisicao)) {
                        lotes = this.getLoteRequisicao(filial, requisicao);
                        if (lotes.isEmpty()) {
                            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o faz parte de um lote.", 2);
                            return;
                        }
                        for (DescritorCodigoLote descritorCodigoLote : lotes) {
                            tubosSelecionados = this.getTubosSelecionados(der);
                            ConferenciaDeLotesCarregaLoteUtil util = new ConferenciaDeLotesCarregaLoteUtil(this.loteFilialService, this.checkAutomatico.isSelected());
                            Registro loteRegistro = null;
                            loteRegistro = util.carregarLote(descritorCodigoLote.getCodigoLote(), this.etqConferidas, this.isExibiuJejum, this.tempoJejum, requisicao, tubosSelecionados);
                            if (loteRegistro == null || this.loteJaAdicionado(lotes, requisicao)) continue;
                            modelo = this.modeloReqOutro;
                            this.modeloLote.addRegistro(loteRegistro);
                            this.modeloLote.fireTableDataChanged();
                        }
                    } else {
                        List loteFiltrado = this.modeloLote.getRegistros().stream().filter(a -> ((List)a.getValor("requisicoes")).stream().anyMatch(r -> r.getString("req_codigo").equalsIgnoreCase(requisicao))).collect(Collectors.toList());
                        for (Registro l : loteFiltrado) {
                            lotes.add(new DescritorCodigoLote(filial, l.getString("lot_codigo"), this.codigoConvenio));
                        }
                        tubosSelecionados = this.getTubosSelecionados(der);
                    }
                    if ((indice = modelo.getIndice("req_codigo", requisicao)) > -1) {
                        tabela.setRowSelectionInterval(indice, indice);
                    }
                    ArrayList<DescritorCodigoEtiqueta> arrayList = this.verificarTubosSelecionados(der, lotes, requisicao);
                    this.confereRequisicao(filial, requisicao, tabela, modelo, arrayList, isReceberMaterial);
                    this.marcarExamesRequisicoesOk(modelo);
                    this.loteSalvo = false;
                    if (!this.etqConferidas.isEmpty() || !tubosSelecionados.isEmpty()) {
                        this.controlarBotoesSemEdicaoRelizada(!this.etqConferidas.isEmpty());
                        this.buttonSalvar.setEnabled(!tubosSelecionados.isEmpty());
                    }
                }
            }
        }
    }

    private List<String> getTubosSelecionados(DialogoExamesRequisicao der) {
        ArrayList<String> tubosSelecionados = new ArrayList<String>();
        der.getSelecionados().forEach(tubo -> tubosSelecionados.add((String)tubo));
        return tubosSelecionados;
    }

    private ArrayList<DescritorCodigoEtiqueta> verificarTubosSelecionados(DialogoExamesRequisicao der, List<DescritorCodigoLote> lotes, String requisicao) {
        ArrayList<DescritorCodigoEtiqueta> etqs = new ArrayList<DescritorCodigoEtiqueta>();
        for (String tubo : der.getSelecionados()) {
            if (lotes.isEmpty()) continue;
            DescritorCodigoEtiqueta dce = ConferenciaDeLotesUtil.getEtiqueta(Variaveis.filialPadrao, requisicao, tubo);
            this.etqLidas.add(dce);
            etqs.add(dce);
        }
        if (etqs.isEmpty()) {
            this.controlarBotoesSemEdicaoRelizada(!this.etqLidas.isEmpty());
        }
        return etqs;
    }

    private void conferirEtiquetas(List<DescritorCodigoEtiqueta> etqs, Registro regReq, boolean isReceberMaterial) {
        ModeloResultSet modExa;
        ConferenciaDeLotesCarregaLoteUtil util = new ConferenciaDeLotesCarregaLoteUtil(this.loteFilialService, this.checkAutomatico.isSelected());
        if (this.isNotNull(regReq) && this.isNotNull(modExa = (ModeloResultSet)regReq.getValor(MODELO_EXAMES))) {
            for (Registro exa : modExa.getRegistros()) {
                boolean contemTubo = false;
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (this.isNotNull(modCol)) {
                    for (Registro col : modCol.getRegistros()) {
                        if (!this.contemTubo(etqs, col.getString(COD_COLETA))) continue;
                        contemTubo = true;
                        col.setValor(TUBO_LIDO, Boolean.TRUE);
                    }
                }
                if (!contemTubo || !this.isMateriaNaoRecebido(exa) || !isReceberMaterial) continue;
                util.receberMaterial(exa, this.isExibiuJejum, this.tempoJejum);
                exa.setValor("exr_situacao", "");
            }
            this.habilitarOpcoes(modExa.getRegistro(this.tableExames.getSelectedRow()));
        }
    }

    private boolean isMateriaNaoRecebido(Registro exa) {
        return exa.getString("exr_situacao").equalsIgnoreCase("T") || exa.getString("exr_situacao").equalsIgnoreCase("R") || exa.getString("exr_situacao").equalsIgnoreCase("F");
    }

    private boolean isNotNull(Object obj) {
        return obj != null;
    }

    private boolean contemTubo(List<DescritorCodigoEtiqueta> etqs, String tubo) {
        for (DescritorCodigoEtiqueta dce : etqs) {
            if (!dce.getTubo().equalsIgnoreCase(tubo)) continue;
            return true;
        }
        return false;
    }

    private void adicionarRequisicao(ModeloResultSet modReq, String filial, String requisicao) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null && modReq != null) {
            try {
                Registro reg = ConferenciaDeLotesUtil.carregaRequisicaoEtiqueta(st, filial, requisicao, this.modeloExa, this.etqConferidas, this.modeloCol, this.modeloTri);
                modReq.addRegistro(reg);
                modReq.fireTableDataChanged();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 630");
            }
        }
    }

    private boolean contemCadastro(DescritorCodigoEtiqueta dce) {
        try {
            return ConferenciaDeLotesUtil.contemCadastro(dce);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaDeLotes: 1298");
            return false;
        }
    }

    private List<DescritorCodigoLote> getLoteRequisicao(String filial, String requisicao) {
        try {
            return ConferenciaDeLotesUtil.getLoteRequisicao(filial, requisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaDeLotes: 1319");
            return null;
        }
    }

    private List getTubosRequisicao(String filial, String requisicao) {
        List<Object> tubos = new ArrayList();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                HashMap tmp = new HashMap();
                tubos = ConferenciaDeLotesUtil.getTubos(filial, requisicao, st, SQL);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaDeLotes: 1334");
            }
        }
        return tubos;
    }

    private List getTubosRequisicaoConf(String filial, String requisicao) {
        ArrayList<Object> tubos = new ArrayList<Object>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                HashMap<Object, Object> tmp = new HashMap();
                ArrayList conferidas = new ArrayList();
                List<String> confCodigo = ConferenciaDeLotesUtil.getTuboDeConferidas(filial, requisicao, st);
                confCodigo.forEach(conf -> conferidas.add(ConferenciaDeLotesUtil.getEtiqueta(filial, requisicao, conf)));
                tmp = ConferenciaDeLotesUtil.getExameDeConferidas(filial, requisicao, st, SQL);
                for (Integer n : tmp.keySet()) {
                    StringBuilder exa;
                    DescritorCodigoEtiqueta dce = ConferenciaDeLotesUtil.getEtiqueta(filial, requisicao, n.toString());
                    exa.append((exa = (StringBuilder)tmp.get(n)).indexOf("<html>") > -1 ? "</html>" : "");
                    tubos.add(n.toString());
                    tubos.add(exa.toString());
                    tubos.add(this.etqLidas.contains(dce) || conferidas.contains(dce));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaDeLotes: 1334");
            }
        }
        return tubos;
    }

    private void atualizarTextoBotaoImprimir(JTable table) {
        if (table == this.tableRequisicoes) {
            this.subImprimirTodos.setText("Imprimir Todas as Requisi\u00e7\u00f5es");
            this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Requisi\u00e7\u00f5es" : "Imprimir Requisi\u00e7\u00e3o");
        } else if (table == this.tableExames) {
            this.subImprimirTodos.setText("Imprimir Todos os Exames");
            this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Exames" : "Imprimir Exame");
        }
    }

    private void habilitarDesabilitarBotoes() {
        this.textTubo.setEnabled(this.conferindoLote);
        this.buttonNovo.setEnabled(!this.conferindoLote);
        this.buttonSalvar.setEnabled(this.conferindoLote);
        this.buttonImprimir.setEnabled(this.loteSalvo && this.etqLidas.isEmpty());
        this.buttonOpcoes.setEnabled(this.conferindoLote);
        this.buttonFechar.setEnabled(!this.conferindoLote || this.loteSalvo);
        this.buttonCancelar.setEnabled(this.conferindoLote && !this.loteSalvo);
        this.buttonFiltrar.setEnabled(this.conferindoLote);
        this.checkAutomatico.setEnabled(this.conferindoLote);
        if (this.tableLotes.getSelectedRow() >= 0 || this.tableRequisicoes.getSelectedRow() >= 0) {
            this.habilitarOpcoes(this.modeloLote.getRegistro(this.tableLotes.getSelectedRow()));
            this.buttonOpcoes.setEnabled(true);
        }
    }

    private void controlarBotoesSemEdicaoRelizada(boolean temEtqConferida) {
        this.textTubo.setEnabled(true);
        this.buttonNovo.setEnabled(true);
        this.buttonSalvar.setEnabled(false);
        this.buttonImprimir.setEnabled(temEtqConferida);
    }

    private void limparModelos() {
        for (Registro reg : this.modeloReqOutro.getRegistros()) {
            this.modeloReq.addRegistro(reg);
        }
        for (Registro reg : this.modeloReq.getRegistros()) {
            ModeloResultSet exa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
            if (exa == null) continue;
            for (Registro tmp : exa.getRegistros()) {
                ModeloResultSet mod = (ModeloResultSet)tmp.getValor(MODELO_COLETA);
                if (mod != null) {
                    mod.limpar();
                }
                if ((mod = (ModeloResultSet)tmp.getValor(MODELO_TRIAGEM)) == null) continue;
                mod.limpar();
            }
            exa.limpar();
        }
        this.modeloReq.limpar();
        this.modeloReqOutro.limpar();
        this.etqConferidas.clear();
        this.etqLidas.clear();
    }

    private void marcarMaterialFaltante(Registro reg) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null && this.isNotNull(reg)) {
            try {
                ConferenciaDeLotesUtil.updateRequisicaoFaltaMaterial(st, reg);
                if (this.exportarParaWeb()) {
                    this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "F", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                }
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 835");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarRecoleta(Registro reg) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String SQL = "";
        if (st != null && this.isNotNull(reg)) {
            try {
                String motivo = "";
                SolicitarMotivoRecoleta recoleta = SolicitarMotivoRecoleta.novaInstancia(this.getTopLevelAncestor(), false, Variaveis.filialPadrao);
                recoleta.setVisible(true);
                if (recoleta.getOK()) {
                    motivo = recoleta.getDescricaoMotivo();
                }
                SQL = ConferenciaDeLotesUtil.updateRequisicaoRecoleta(reg, st, motivo);
                if (this.exportarParaWeb()) {
                    this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "R", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                }
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                try {
                    if (!SMSUtil.isBloquearSMSRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
                        SMSUtil.criaLogSmsComDadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"), ExportaSMS.TipoSMS.RECOLETA, st, st2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!EmailUtil.isBloquearEmailRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
                        EmailUtil.criaLogEmail(Variaveis.filialPadrao, reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RECOLETA, true, st);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!PushUtil.isBloquearPushRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
                        PushUtil.criaLogPushComDadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"), TipoPush.RECOLETA, st, st2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.enviarMensagemWhatsappRecoleta(reg, st, st2);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 835");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void enviarMensagemWhatsappRecoleta(Registro reg, Statement st, Statement st2) {
        try {
            if (!WhatsAppUtil.isBloquearWhatsappRecoleta(Variaveis.filialPadrao, reg.getString("req_codigo"), st2)) {
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"), TipoWhatsapp.RECOLETA, st, st2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AdicionaMensagem novoAdicionaMensagem() {
        Container pai = this.getTopLevelAncestor();
        if (pai instanceof Frame) {
            return new AdicionaMensagem((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new AdicionaMensagem((Dialog)pai);
        }
        return null;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 907");
        }
    }

    private void alterarExameRequisicaoWeb(Statement st, Registro reg, String ... campos) throws Exception {
        String baseWeb = this.getBaseWeb();
        if (baseWeb != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(reg.getString("exa_codigo"));
            tmp.add("materialExameRequisicao");
            tmp.add(reg.getString("mco_codigo"));
            tmp.add("dataEnvioExameRequisicao");
            tmp.add("current_timestamp");
            for (String campo : campos) {
                tmp.add(campo);
            }
            DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexame", "A", true, tmp.toArray(new String[tmp.size()]));
        }
    }

    private String getBaseWeb() {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                return ConferenciaDeLotesUtil.getBaseWeb(st, SQL);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 957");
            }
        }
        return null;
    }

    private boolean exportarParaWeb() throws SQLException {
        FilialService filService = new FilialService();
        Statement st = Conexao.getStatement();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, Variaveis.filialPadrao);
        if (Funcoes.carregouVO(filialVO)) {
            return Funcoes.isExportarBaseWeb(filialVO);
        }
        return false;
    }

    private void habilitarOpcoes(Registro reg) {
        if (this.isNotNull(reg)) {
            String s = reg.getString("exr_situacao").trim();
            boolean semResultado = s.length() == 0;
            this.itemReceberMaterial.setVisible(this.acessoReceberMaterial && (s.equalsIgnoreCase("F") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("R")));
            this.itemMarcarMaterialFaltante.setVisible(this.acessoMarcarMaterialFaltante && semResultado);
            this.itemMarcarRecoleta.setVisible(this.acessoMarcarRecoleta && semResultado);
        }
    }

    private void atualizarExamesTriados(int[] indices) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                int[] rowsReq = this.tableRequisicoes.getSelectedRows();
                int[] rowsExa = this.tableExames.getSelectedRows();
                StringBuilder bui = new StringBuilder();
                for (Registro req : this.modeloReq.getRegistros(indices)) {
                    ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                    if (modExa == null) continue;
                    SQL = ConferenciaDeLotesUtil.buscaExameTriagem(st, bui, req, modExa);
                    boolean tuboTriado = true;
                    for (Registro exa : modExa.getRegistros()) {
                        if (exa.getBoolean(TUBO_TRIADO)) continue;
                        tuboTriado = false;
                        break;
                    }
                    req.setValor(TUBO_TRIADO, tuboTriado);
                    this.tableRequisicoes.repaint();
                    this.tableExames.repaint();
                    this.tableColeta.repaint();
                    this.tableTriagem.repaint();
                    if (rowsReq == null) continue;
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsReq)) {
                        this.tableRequisicoes.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                    if (rowsReq.length != 1) continue;
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsExa)) {
                        this.tableExames.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 1052");
            }
        }
    }

    private void imprimirRequisicoes(int[] indices, int tipo) {
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        List<Registro> list;
        String chaveImp = "campoImprimir";
        if (tipo == 0 && (list = this.getRequisicoesIncompletas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Imprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es incompletas");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisic\u00f5es listadas abaixo est\u00e3o incompletas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja imprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(IMPR_INCOMPLETO, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        if (tipo == 0 && (list = this.getRequisicoesJaTriadas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Imprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es j\u00e1 triados");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisi\u00e7\u00f5es listadas abaixo cont\u00eam etiquetas de triagem j\u00e1 impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        try {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            for (Registro reg : ((ModeloResultSet)this.tableReqImpressao.getModel()).getRegistros(indices)) {
                exames.clear();
                materiais.clear();
                ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
                if (modExa != null) {
                    for (Registro regExa : modExa.getRegistros()) {
                        ModeloResultSet modCol = (ModeloResultSet)regExa.getValor(MODELO_COLETA);
                        for (Registro regCol : modCol.getRegistros()) {
                            if (tipo != 1 && (!regCol.getBoolean(TUBO_CONFERIDO) || regCol.getBoolean(TUBO_TRIADO) && !regCol.getBoolean(REIMPRIMIR)) || exames.contains(regExa.getString("exa_codigo")) && materiais.contains(new Integer(regExa.getInt("mco_codigo")))) continue;
                            exames.add(regExa.getString("exa_codigo"));
                            materiais.add(new Integer(regExa.getInt("mco_codigo")));
                        }
                    }
                }
                if (exames.size() <= 0) continue;
                if (tipo == 0) {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), reg.getBoolean(REIMPRIMIR), Variaveis.login, 2);
                } else {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 1);
                }
                Conexao.arquivaSQL();
            }
            this.atualizarExamesTriados(indices);
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1145");
        }
    }

    private int[] getInteiros(ArrayList<Integer> lista) {
        int[] ints = new int[lista.size()];
        for (int i = 0; i < lista.size(); ++i) {
            ints[i] = lista.get(i);
        }
        return ints;
    }

    private void imprimirExames(int[] indices, int tipo) {
        Registro regReq;
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        List<Registro> list;
        String chaveImp = "campoImprimir";
        if (tipo == 0 && (list = this.getExamesIncompletos(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao");
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames incompletos");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("Os exames listados abaixo est\u00e3o incompletos e n\u00e3o ser\u00e3o impressos.");
                dri.setConfirmacaoImpressao(false);
                dri.centralizar();
                dri.setVisible(true);
            }
        }
        if (tipo == 0 && (list = this.getExamesJaTriados(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames j\u00e1 triados");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("As etiquetas de triagem dos exames listados abaixo j\u00e1 foram impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque os que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                for (Registro reg : mod.getRegistros()) {
                    reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                }
            }
        }
        if (this.isNotNull(regReq = ((ModeloResultSet)this.tableReqImpressao.getModel()).getRegistro(this.tableReqImpressao.getSelectedRow()))) {
            try {
                ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
                ArrayList<String> exames = new ArrayList<String>();
                ArrayList<Integer> materiais = new ArrayList<Integer>();
                for (Registro reg : modExa.getRegistros(indices)) {
                    ModeloResultSet modCol = (ModeloResultSet)reg.getValor(MODELO_COLETA);
                    for (Registro regCol : modCol.getRegistros()) {
                        if (tipo != 1 && (!regCol.getBoolean(TUBO_CONFERIDO) || regCol.getBoolean(TUBO_TRIADO) && !regCol.getBoolean(REIMPRIMIR))) continue;
                        exames.add(reg.getString("exa_codigo"));
                        materiais.add(new Integer(reg.getInt("mco_codigo")));
                    }
                }
                if (tipo == 0) {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 2);
                } else {
                    ImprimirEtiquetasColetaTriagem.imprimir(Variaveis.filialPadrao, regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), this.getInteiros(materiais), true, Variaveis.login, 1);
                }
                Conexao.arquivaSQL();
                this.atualizarExamesTriados(indices);
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1236");
            }
        }
    }

    private List<Registro> getRequisicoesIncompletas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            Registro reg = this.modeloReq.getRegistro(i);
            if (!this.isNotNull(reg) || reg.getBoolean(TUBOS_OK)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private boolean todasRequisicoesCompletas() {
        for (Registro lote : this.modeloLote.getRegistros()) {
            for (Registro reg : (List)lote.getValor("requisicoes")) {
                if (reg.getBoolean(TUBOS_OK)) continue;
                return false;
            }
        }
        return true;
    }

    private List<Registro> getRequisicoesJaTriadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (!this.isNotNull(reg) || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) == null) continue;
            boolean triado = false;
            for (int j = 0; !triado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                triado = this.isNotNull(r) && r.getBoolean(TUBO_TRIADO);
            }
            if (!triado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesIncompletos(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (!this.isNotNull(reg) || reg.getBoolean(TUBOS_OK)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesJaTriados(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (!this.isNotNull(reg) || !reg.getBoolean(TUBO_TRIADO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private String getDescricaoConvenio(DescritorCodigoLote dcl, String tipoBase) {
        Statement st = Conexao.getStatement();
        if (st != null && dcl != null) {
            try {
                return ConferenciaDeLotesUtil.getDescricaoConvenio(dcl, tipoBase);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaLote: 1376");
            }
        }
        return "";
    }

    private void salvarLote() {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                for (Registro lote : this.modeloLote.getRegistros()) {
                    int resp;
                    StringBuilder bui = new StringBuilder();
                    List registros = (List)lote.getValor("requisicoes");
                    if (!this.caixaRecebida && (resp = Funcoes.mensagem(this, "A caixa n\u00e3o foi recebida para o lote, deseja confirmar o recebimento?", 4)) == 0) {
                        this.buttonCaixa.doClick();
                    }
                    for (Registro req : registros) {
                        SQL = ConferenciaDeLotesUtil.updateRequisicaoComUsuario(st, req);
                        ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                        if (modExa != null) {
                            for (Registro exa : modExa.getRegistros()) {
                                if (!exa.getBoolean(TUBO_LIDO)) continue;
                                SQL = ConferenciaDeLotesUtil.updateExameRequisicaoTriagem(st, req, exa);
                                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                                if (modCol == null) continue;
                                for (Registro col : modCol.getRegistros()) {
                                    if (!col.getBoolean(TUBO_LIDO)) continue;
                                    SQL = ConferenciaDeLotesUtil.updateRequisicaoExameRecipienteTriagem(st, req, exa, col);
                                    col.setValor(TUBO_CONFERIDO, Boolean.TRUE);
                                    col.setValor(TUBO_LIDO, Boolean.FALSE);
                                }
                            }
                        }
                        if (ParametrosGerais.getExportarInterface() != 0) continue;
                        ExportarInterface.criaInterface(req.getString("fil_codigo"), req.getString("req_codigo"), "requisicao");
                    }
                    Map<String, Boolean> requisicoesConferidas = this.verificarRequisicoesConferidas(registros);
                    if (requisicoesConferidas.containsValue(Boolean.FALSE)) continue;
                    DescritorCodigoLote dcl = new DescritorCodigoLote(lote.getString("fil_codigo"), lote.getString("lot_codigo"), lote.getString("con_codigo"));
                    SQL = ConferenciaDeLotesUtil.updateLoteApoioTriagem(st, dcl);
                }
                this.etqConferidas.addAll(this.etqLidas);
                this.etqLidas.clear();
                this.loteSalvo = true;
                this.habilitarDesabilitarBotoes();
                this.buttonSalvar.setEnabled(false);
                this.buttonNovo.setEnabled(true);
                this.conferindoLote = false;
                this.buttonFiltrar.setEnabled(false);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConferenciaLote: 1307");
            }
        }
    }

    private Map<String, Boolean> verificarRequisicoesConferidas(List<Registro> registros) {
        HashMap<String, Boolean> requisicoesConferidas = new HashMap<String, Boolean>();
        for (Registro requisicao : registros) {
            ModeloResultSet modExa = (ModeloResultSet)requisicao.getValor(MODELO_EXAMES);
            if (modExa == null) continue;
            HashMap<String, Boolean> examesConferidos = new HashMap<String, Boolean>();
            for (Registro exa : modExa.getRegistros()) {
                ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                if (modCol == null) continue;
                boolean exaConf = modCol.getRegistros().stream().allMatch(col -> col.getValor(TUBO_CONFERIDO).equals(Boolean.TRUE));
                examesConferidos.put(exa.getString("exa_codigo"), exaConf);
            }
            if (!examesConferidos.containsValue(Boolean.FALSE)) continue;
            requisicoesConferidas.put(requisicao.getString("req_codigo"), Boolean.FALSE);
        }
        return requisicoesConferidas;
    }

    private void marcarExamesRequisicoesOk(ModeloResultSet modeloReqAtualizado) {
        this.atualizarModeloLote(modeloReqAtualizado);
        for (Registro lote : this.modeloLote.getRegistros()) {
            Boolean loteOk = Boolean.TRUE;
            List modReq = (List)lote.getValor("requisicoes");
            if (modReq == null) continue;
            for (Registro req : modReq) {
                ModeloResultSet modExa = (ModeloResultSet)req.getValor(MODELO_EXAMES);
                if (modExa == null) continue;
                Boolean reqOk = Boolean.TRUE;
                for (Registro exa : modExa.getRegistros()) {
                    ModeloResultSet modCol = (ModeloResultSet)exa.getValor(MODELO_COLETA);
                    if (modCol == null) continue;
                    Boolean exaLido = Boolean.FALSE;
                    Boolean exaOk = Boolean.TRUE;
                    for (Registro col : modCol.getRegistros()) {
                        if (!(col.getBoolean(TUBO_LIDO) || col.getBoolean(TUBO_CONFERIDO) || col.getBoolean(TUBOS_OK))) {
                            exaOk = Boolean.FALSE;
                        }
                        if (!col.getBoolean(TUBO_LIDO)) continue;
                        exaLido = Boolean.TRUE;
                    }
                    exa.setValor(TUBOS_OK, exaOk);
                    exa.setValor(TUBO_LIDO, exaLido);
                    if (exaOk.booleanValue()) continue;
                    reqOk = Boolean.FALSE;
                }
                if (!reqOk.booleanValue()) {
                    loteOk = Boolean.FALSE;
                }
                req.setValor(TUBOS_OK, reqOk);
            }
            lote.setValor(TUBOS_OK, loteOk);
            this.modeloLote.fireTableDataChanged();
            this.revalidate();
            this.repaint();
        }
    }

    private void atualizarModeloLote(ModeloResultSet modeloReqAtualizado) {
        List modReq = new ArrayList();
        for (Registro lote : this.modeloLote.getRegistros()) {
            modReq = (List)lote.getValor("requisicoes");
            if (modReq == null) continue;
            for (Registro req : modReq) {
                for (Registro reqAtualizada : modeloReqAtualizado.getRegistros()) {
                    if (!req.getString("fil_codigo").equals(reqAtualizada.getString("fil_codigo")) || !req.getString("req_codigo").equals(reqAtualizada.getString("req_codigo"))) continue;
                    req.setValor(MODELO_EXAMES, reqAtualizada.getValor(MODELO_EXAMES));
                }
            }
        }
    }

    private void iniciar() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de Lotes", "Confer\u00eancia de Lotes", "triagem/conferencia_lotes_apoio.jpg");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "South");
        panel.add((Component)this.panelCaixa, "North");
        JPanel aux = new JPanel(new FlowLayout(0, 3, 3));
        panel.add((Component)aux, "West");
        aux.add(this.buttonFiltrar);
        aux.add(this.buttonOpcoes);
        aux.add(this.checkAutomatico);
        aux = new JPanel(new FlowLayout(2, 3, 2));
        panel.add((Component)aux, "East");
        aux.add(this.buttonNovo);
        aux.add(this.buttonSalvar);
        aux.add(this.buttonCancelar);
        aux.add(this.buttonImprimir);
        aux.add(this.buttonFechar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.panelCaixa.add((Component)this.labelCaixa, cons);
        ++cons.gridx;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 0.0;
        this.panelCaixa.add((Component)this.buttonCaixa, cons);
        this.panelCaixa.setVisible(false);
        panel = new JPanel(new GridBagLayout());
        this.add((Component)panel, "Center");
        cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.weighty = 0.0;
        aux = new JPanel(new FlowLayout(0, 1, 0));
        panel.add((Component)aux, cons);
        aux = new JPanel(new FlowLayout(0, 1, 1));
        panel.add((Component)aux, cons);
        JLabel labelTubo = ComponenteFactory.novoJLabel("Tubo:", new Dimension(50, 20));
        aux.add(labelTubo);
        aux.add(this.textTubo);
        labelTubo.setLabelFor(this.textTubo);
        labelTubo.setDisplayedMnemonic('T');
        this.textTubo.addKeyListener(this);
        this.textTubo.setPreferredSize(new Dimension(120, 20));
        cons.fill = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.weighty = 1.0;
        cons.weightx = 0.4;
        cons.gridwidth = 1;
        cons.gridheight = 2;
        ++cons.gridy;
        cons.gridx = 0;
        aux = new JPanel(new BorderLayout());
        panel.add((Component)aux, cons);
        this.tableLotes.setDefaultRenderer(Object.class, this);
        this.tableLotes.addFocusListener(this);
        this.tableLotes.addKeyListener(this);
        this.tableLotes.getTableHeader().setResizingAllowed(true);
        aux.add((Component)this.novoJPanel(this.tableLotes, "Lotes"), "Center");
        cons.gridx = 1;
        cons.weightx = 0.8;
        cons.gridheight = 1;
        aux = new JPanel(new BorderLayout());
        panel.add((Component)aux, cons);
        this.tableRequisicoes.setDefaultRenderer(Object.class, this);
        this.tableRequisicoes.addFocusListener(this);
        this.tableRequisicoes.addKeyListener(this);
        aux.add((Component)this.novoJPanel(this.tableRequisicoes, "Requisi\u00e7\u00f5es"), "Center");
        cons.gridx = 1;
        cons.gridy = 2;
        this.tableExames.setDefaultRenderer(Object.class, this);
        this.tableExames.addFocusListener(this);
        this.tableExames.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableExames, "Exames"), cons);
        cons.weightx = 0.4;
        cons.gridx = 2;
        cons.gridy = 1;
        cons.gridheight = 1;
        this.tableColeta.setRowSelectionAllowed(false);
        this.tableColeta.setDefaultRenderer(Object.class, this);
        this.tableColeta.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableColeta, "Etiquetas Coleta"), cons);
        ++cons.gridy;
        this.tableTriagem.setRowSelectionAllowed(false);
        this.tableTriagem.setDefaultRenderer(Object.class, this);
        this.tableTriagem.addKeyListener(this);
        panel.add((Component)this.novoJPanel(this.tableTriagem, "Etiquetas Triagem"), cons);
        this.panelLegenda.addItem(COR_LIDO, "Tubo identificado");
        this.panelLegenda.addItem(COR_TRIADO, "Tubo triado");
        this.panelLegenda.addItem(Color.RED, "Urgente");
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 4;
        cons.fill = 2;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        panel.add((Component)this.panelLegenda.getPanel(), cons);
        this.acessoMarcarMaterialFaltante = Acesso.getAcesso(300500301L);
        this.acessoReceberMaterial = Acesso.getAcesso(300500302L);
        this.acessoMarcarRecoleta = Acesso.getAcesso(300500303L);
        this.checkAutomatico.setVisible(this.acessoReceberMaterial);
        this.setCheckAutomatico();
        this.buttonOpcoes.addKeyListener(this);
        this.buttonNovo.addKeyListener(this);
        this.buttonSalvar.addKeyListener(this);
        this.buttonCancelar.addKeyListener(this);
        this.buttonImprimir.addKeyListener(this);
        this.buttonFechar.addKeyListener(this);
        this.itemReceberMaterial.setVisible(false);
        this.itemMarcarMaterialFaltante.setVisible(false);
        this.itemMarcarRecoleta.setVisible(false);
        this.habilitarDesabilitarBotoes();
        this.configurarTeclas();
        this.redimensionarColunas();
        ScreenUtil.requisitarFoco(this.textTubo);
    }

    private void setCheckAutomatico() {
        if (this.checkAutomatico.isVisible()) {
            this.checkAutomatico.setSelected(StringUtil.getBoolean(ParametrosUsuarios.getValor(RECEBER_AUTOMATICO)));
        } else {
            this.checkAutomatico.setSelected(false);
        }
    }

    private JPanel novoJPanel(JTable tabela, String titulo) {
        JPanel panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder(titulo));
        panel.add((Component)new JScrollPane(tabela, 20, 30), "Center");
        return panel;
    }

    private void configurarTeclas() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(10, 0, false), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                }
            }
        });
    }

    private void redimensionarColunas() {
        this.tableRequisicoes.getColumnModel().getColumn(0).setMaxWidth(60);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(60);
        this.tableExames.getColumnModel().getColumn(0).setMaxWidth(50);
        this.tableExames.getColumnModel().getColumn(1).setMaxWidth(50);
        this.tableExames.getColumnModel().getColumn(3).setMaxWidth(20);
        this.tableColeta.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableColeta.getColumnModel().getColumn(0).setMinWidth(45);
        this.tableTriagem.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableTriagem.getColumnModel().getColumn(0).setMinWidth(45);
    }

    private void pesquisarLote() {
        Hashtable resultado = null;
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            String codigoConvenio2 = "";
            if (null != this.codigoConvenio) {
                codigoConvenio2 = this.codigoConvenio;
            }
            resultado = Pesquisas.loteApoioAlimentos(this.getTopLevelAncestor(), false, codigoConvenio2);
        } else {
            resultado = Pesquisas.loteapoio(this.getTopLevelAncestor(), false);
        }
        if (resultado != null) {
            StringBuilder bui = new StringBuilder();
            bui.append(StringUtil.preencheString(Variaveis.filialPadrao, 2, '0', 1));
            bui.append(StringUtil.preencheString(resultado.get("con_codigo").toString(), 4, '0', 1));
            bui.append(StringUtil.preencheString(resultado.get("lot_codigo").toString(), 9, '0', 1));
            this.codigoLoteSelecionado = bui.toString();
        }
    }

    private void controlaCamposCaixa(String caixa, Date dataRecebimentoCaixa, String usuarioRecebimentoCaixa) {
        this.caixaRecebida = caixa != null && !Funcoes.textoVazio(caixa) ? dataRecebimentoCaixa != null : true;
        this.panelCaixa.setVisible(caixa != null && !Funcoes.textoVazio(caixa));
        this.buttonCaixa.setVisible(!this.caixaRecebida);
        if (!this.caixaRecebida) {
            this.labelCaixa.setText("Caixa enviada: " + caixa);
        } else {
            this.labelCaixa.setText("Caixa " + caixa + " recebida em " + Funcoes.formataData("dd/MM/yyyy HH:mm", dataRecebimentoCaixa) + " por " + usuarioRecebimentoCaixa);
        }
    }

    @Override
    @Deprecated
    public void keyPressed(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    static {
        labelRenderer.setOpaque(true);
        labelRenderer.setBorder(bordaSimples);
    }
}

