/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.recepcao.util.SolicitarJejum;
import jalis.laboratorio.recepcao.util.SolicitarMotivoRecoleta;
import jalis.laboratorio.triagem.LabelLegenda;
import jalis.laboratorio.triagem.Observacao;
import jalis.laboratorio.triagem.RelatorioTriagem;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DialogoRequisicaoIncompleta;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.ImprimirMapa;
import jalis.relatorio.Editor;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class Triagem
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener,
FocusListener,
TableCellRenderer {
    private static final String ETIQUETA_AUTOMATICA = "Triagem.etiquetaAutomatica";
    private static final String MAPA_AUTOMATICO = "Triagem.mapaAutomatico";
    private static final String OCULTAR_INSTRUCOES = "Triagem.ocultarInstrucoes";
    private static final String OCULTAR_LEGENDA = "Triagem.ocultarLegenda";
    private static final String MAPA_APENAS_SELECIONADO = "Triagem.imprimirMapaSelecionado";
    private static final int IMPR_REQ = 0;
    private static final int IMPR_EXA = 1;
    private static final String IMPR_INCOMPLETO = "imprimirIncompleto";
    private static final String REIMPRIMIR = "reimprimir";
    private static final String TUBO_LIDO = "tuboLido";
    private static final String TUBO_CONFERIDO = "tuboConferido";
    private static final String TUBO_TRIADO = "tuboTriado";
    private static final String MODELO_EXAMES_LIDO = "modelo_exames_lido";
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String MODELO_COLETA = "modelo_coleta";
    private static final String MODELO_TRIAGEM = "modelo_triagem";
    private static final String COD_COLETA = "cod_coleta";
    private static final String DES_COLETA = "des_coleta";
    private static final String COD_TRIAGEM = "cod_triagem";
    private static final String DES_TRIAGEM = "des_triagem";
    private static final Color COR_LIDO = new Color(180, 255, 180);
    private static final Color COR_TRIADO = new Color(130, 235, 255);
    private final int ETIQUETAS_COLETA = 1;
    private final int ETIQUETAS_TRIAGEM = 2;
    private final int REQUISICAO = 1;
    private final int EXAME = 2;
    private int tabelaSelecionada = 1;
    private final long codigoAcesso = 300300106L;
    private final boolean acessoBotaoSalvar = Acesso.getAcesso(Triagem.getAcessoBotaoSalvar());
    private static Border bordaSimples = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static Border bordaSelecionada = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final JLabel labelRenderer = new JLabel();
    private static final ModeloResultSet modeloExaLido;
    private static final ModeloResultSet modeloExa;
    private static final ModeloResultSet modeloCol;
    private static final ModeloResultSet modeloTri;
    private final ModeloResultSet modeloReq = new ModeloResultSet("Fil.", "fil_codigo", "C\u00f3digo", "req_codigo", "Paciente", "pac_nome");
    private final TTextField textTubo = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private final JLabel labelConvenio = new JLabel();
    private final JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloReq, (ListSelectionListener)this, new int[0]);
    private final JTable tableExamesLido = ComponenteFactory.novoJTable((TableModel)modeloExaLido, (ListSelectionListener)this, new int[0]);
    private final JTable tableExames = ComponenteFactory.novoJTable((TableModel)modeloExa, (ListSelectionListener)this, new int[0]);
    private final JTable tableColeta = ComponenteFactory.novoJTable((TableModel)modeloCol, (ListSelectionListener)this, new int[0]);
    private final JTable tableTriagem = ComponenteFactory.novoJTable(modeloTri);
    private final JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es \u25bc", 'O', this, null, null);
    private final JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private final JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private final JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private final JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private final JCheckBox checkEtiquetaAutomatica = ComponenteFactory.novoJCheckBox(this.acessoBotaoSalvar ? "Imprimir etiq." : "Imprimir etiquetas", 'm', this, null, true, "Imprimir etiquetas de triagem ao finalizar a confer\u00eancia do tubo");
    private final JCheckBox checkMapaAutomatico = ComponenteFactory.novoJCheckBox("Imprimir mapas", 'p', this, null, true, "Imprimir mapas ao finalizar a confer\u00eancia do tubo");
    private final JPanel panelInstrucoes = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Instru\u00e7\u00f5es"));
    private final JTextArea textInstrucoes = new JTextArea();
    private final JScrollPane scrollInstrucoes = new JScrollPane(this.textInstrucoes);
    private JPanel panelCores = new JPanel(new FlowLayout(0, 0, 0));
    private final LabelLegenda legendaTriado = new LabelLegenda(COR_TRIADO, "Triado/Conferido");
    private final LabelLegenda legendaLido = new LabelLegenda(COR_LIDO, "Lido");
    private final LabelLegenda legendaUrgente = new LabelLegenda(Color.RED, "Urgente");
    private final LabelLegenda legendaNaoColetado = new LabelLegenda(Color.GRAY, "N\u00e3o Coletado");
    private final JPopupMenu menuImprimir = new JPopupMenu();
    private final JMenuItem subImprimirTodos = ComponenteFactory.novoJMenu(this.menuImprimir, "Imprimir Todos", '\u0000');
    private final JMenuItem subImprimir = ComponenteFactory.novoJMenu(this.menuImprimir, "", '\u0000');
    private final JMenuItem itemImprimirTodosColeta = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta coleta", (ActionListener)this);
    private final JMenuItem itemImprimirTodosTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Etiqueta triagem", (ActionListener)this);
    private final JMenuItem itemImprimirColeta = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta coleta", (ActionListener)this);
    private final JMenuItem itemImprimirTriagem = ComponenteFactory.novoJMenuItem(this.subImprimir, "Etiqueta triagem", (ActionListener)this);
    private final JMenuItem itemImprimirTodasRelatorioRequisicoes = ComponenteFactory.novoJMenuItem(this.subImprimirTodos, "Relat\u00f3rio de todas as requisi\u00e7\u00f5es", (ActionListener)this);
    private final JMenuItem itemImprimirRelatorioRequisicoes = ComponenteFactory.novoJMenuItem(this.subImprimir, "Relat\u00f3rio das requisi\u00e7\u00f5es selecionadas", (ActionListener)this);
    private final JPopupMenu menuOpcoes = new JPopupMenu();
    private final JMenuItem itemReceberMaterial = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Receber material", (ActionListener)this);
    private final JMenuItem itemMarcarMaterialFaltante = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como material faltante", (ActionListener)this);
    private final JMenuItem itemMarcarRecoleta = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Marcar como recoleta", (ActionListener)this);
    private final JMenuItem itemObservacaoExame = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Observa\u00e7\u00e3o do exame", (ActionListener)this);
    private final JMenuItem itemOcultarInstrucoes = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Ocultar instru\u00e7\u00f5es", (ActionListener)this);
    private final JMenuItem itemOcultarLegenda = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Ocultar legenda", (ActionListener)this);
    private final JMenuItem itemConfigurarRelatorio = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Configurar relat\u00f3rio", (ActionListener)this);
    private final JCheckBoxMenuItem itemImprimirMapaSelecionado = new JCheckBoxMenuItem("Imprimir mapas de tubos selecionados");
    private final JPanel panel = new JPanel(new BorderLayout());
    private final ArrayList<DescritorCodigoEtiqueta> etiquetas = new ArrayList();
    private boolean acaoCancelar = false;
    private final boolean acessoMarcarMaterialFaltante = Acesso.getAcesso(300300101L);
    private final boolean acessoReceberMaterial = Acesso.getAcesso(300300102L);
    private final boolean acessoObservacaoExame = Acesso.getAcesso(300300103L);
    private final boolean acessoRequisicaoNaoColetada = Acesso.getAcesso(300300104L);
    private final boolean acessoMarcarRecoleta = Acesso.getAcesso(300300105L);
    private final boolean acessoImprimirRelatorio = Acesso.getAcesso(300300106L);
    private int colunaRequisicaoPai = 0;

    public Triagem() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return 300300100L;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        value = value == null ? "" : value;
        labelRenderer.setText(value.toString());
        if (table != null) {
            Color back;
            Color fore;
            boolean ok;
            labelRenderer.setFont(table.getFont());
            if (Laboratorio.getInstancia().getExtendedState() == 6) {
                this.redimensionarLinhas(16);
            } else {
                this.redimensionarLinhas(32);
            }
            ModeloResultSet mod = (ModeloResultSet)table.getModel();
            Registro reg = mod.getRegistro(row);
            Color corTmp = COR_TRIADO;
            boolean bl = ok = reg != null && reg.getBoolean(TUBO_TRIADO);
            if (!ok) {
                ok = reg != null && reg.getBoolean(TUBO_LIDO);
                corTmp = COR_LIDO;
            }
            Color color = isSelected ? (ok ? Color.WHITE : table.getSelectionForeground()) : (fore = table.getForeground());
            Color color2 = isSelected ? (ok ? ScreenUtil.escurecerCor(corTmp, 120) : table.getSelectionBackground()) : (back = ok ? corTmp : table.getBackground());
            if (table == this.tableRequisicoes && reg.getBoolean("req_urgente")) {
                fore = Color.RED;
            } else if (table == this.tableExames && reg.getString("exr_situacao").equals("T")) {
                back = Color.GRAY;
            } else if (table == this.tableExamesLido && column == 2) {
                labelRenderer.setToolTipText(Tipos.tipoSituacaoExame(value.toString()));
                labelRenderer.setHorizontalAlignment(2);
            } else if (table == this.tableRequisicoes) {
                labelRenderer.setVerticalAlignment(1);
            } else if (table == this.tableColeta) {
                labelRenderer.setVerticalAlignment(1);
                if (table == this.tableTriagem) {
                    labelRenderer.setVerticalAlignment(1);
                } else {
                    labelRenderer.setToolTipText(table.getToolTipText());
                }
                labelRenderer.setHorizontalAlignment(2);
            }
            modeloExa.setTamanhoColunas(this.tableExames, 50, 30, 0, 20);
            this.modeloReq.setTamanhoColunas(this.tableRequisicoes, 20, 55, 0);
            modeloExaLido.setTamanhoColunas(this.tableExamesLido, 50, 30, 0, 20);
            labelRenderer.setBackground(back);
            labelRenderer.setForeground(fore);
        }
        return labelRenderer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonFechar) {
                if (this.getParent() != null) {
                    this.getParent().removeAll();
                }
                this.setVisible(false);
            } else if (o == this.buttonNovo) {
                this.novo();
            } else if (o == this.buttonCancelar) {
                if (Funcoes.mensagem(this, "Deseja cancelar a triagem?", 4) == 0) {
                    this.limparTela();
                    this.habilitarDesabilitarEstado(false);
                    this.buttonFechar.setEnabled(true);
                    ScreenUtil.requisitarFoco(this.buttonNovo);
                }
            } else if (o == this.buttonImprimir) {
                this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() - this.menuImprimir.getPreferredSize().height - 1);
            } else if (o == this.buttonOpcoes) {
                this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - this.menuOpcoes.getPreferredSize().height - 1);
            } else if (o == this.itemMarcarMaterialFaltante) {
                int row = this.tableExamesLido.getSelectedRow();
                ModeloResultSet mod = (ModeloResultSet)this.tableExamesLido.getModel();
                Registro reg = mod.getRegistro(row);
                if (reg != null) {
                    this.marcarMaterialFaltante(reg);
                    reg.setValor("exr_situacao", "F");
                    mod.fireTableDataChanged();
                    this.tableExamesLido.setRowSelectionInterval(row, row);
                }
            } else if (o == this.buttonSalvar) {
                this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableRequisicoes.getRowCount()), 2, false, o);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Triagem.this.novo();
                    }
                });
                this.buttonFechar.setEnabled(true);
            } else if (o == this.itemMarcarRecoleta) {
                int row = this.tableExamesLido.getSelectedRow();
                ModeloResultSet mod = (ModeloResultSet)this.tableExamesLido.getModel();
                Registro reg = mod.getRegistro(row);
                if (reg != null) {
                    this.marcarRecoleta(reg);
                    if (!this.acaoCancelar) {
                        reg.setValor("exr_situacao", "R");
                    } else {
                        reg.setValor("exr_situacao", "");
                        this.acaoCancelar = false;
                    }
                    mod.fireTableDataChanged();
                    this.tableExamesLido.setRowSelectionInterval(row, row);
                }
            } else if (o == this.itemReceberMaterial) {
                int row = this.tableExamesLido.getSelectedRow();
                ModeloResultSet mod = (ModeloResultSet)this.tableExamesLido.getModel();
                Registro reg = mod.getRegistro(row);
                if (reg != null) {
                    this.receberMaterial(reg, true);
                    reg.setValor("exr_situacao", null);
                    mod.fireTableDataChanged();
                    this.tableExamesLido.setRowSelectionInterval(row, row);
                }
            } else if (o == this.itemObservacaoExame) {
                int row = this.tableExamesLido.getSelectedRow();
                ModeloResultSet mod = (ModeloResultSet)this.tableExamesLido.getModel();
                Registro reg = mod.getRegistro(row);
                if (reg != null) {
                    Observacao obs = new Observacao((Frame)this.getTopLevelAncestor());
                    obs.setExame(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("exa_descricao"), String.valueOf(reg.getInt("mco_codigo")));
                    obs.setObs(reg.getString("exr_obs"));
                    obs.setVisible(true);
                    if (obs.isOK()) {
                        reg.setValor("exr_obs", obs.getObs());
                    }
                }
            } else if (o == this.itemOcultarInstrucoes) {
                this.panelInstrucoes.setVisible(!this.panelInstrucoes.isVisible());
                ParametrosUsuarios.setValor(OCULTAR_INSTRUCOES, this.panelInstrucoes.isVisible() ? "false" : "true");
                this.alterarTextoOcultar();
            } else if (o == this.itemOcultarLegenda) {
                this.panelCores.setVisible(!this.panelCores.isVisible());
                ParametrosUsuarios.setValor(OCULTAR_LEGENDA, this.panelCores.isVisible() ? "false" : "true");
                this.alterarTextoOcultar();
            } else if (o == this.itemConfigurarRelatorio) {
                this.configurarRelatorio();
            } else if (o == this.itemImprimirTodosColeta) {
                if (this.tabelaSelecionada == 1) {
                    this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableRequisicoes.getRowCount()), 1, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Triagem.this.novo();
                        }
                    });
                } else if (this.tabelaSelecionada == 2) {
                    this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExamesLido.getRowCount()), 1);
                }
            } else if (o == this.itemImprimirTodosTriagem) {
                if (this.tabelaSelecionada == 1) {
                    this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableRequisicoes.getRowCount()), 2, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Triagem.this.novo();
                        }
                    });
                } else if (this.tabelaSelecionada == 2) {
                    this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExamesLido.getRowCount()), 2);
                }
            } else if (o == this.itemImprimirColeta) {
                if (this.tabelaSelecionada == 1) {
                    this.imprimirRequisicoes(this.tableRequisicoes.getSelectedRows(), 1, true);
                } else if (this.tabelaSelecionada == 2) {
                    this.imprimirExames(this.tableExamesLido.getSelectedRows(), 1);
                }
            } else if (o == this.itemImprimirTriagem) {
                if (this.tabelaSelecionada == 1) {
                    this.imprimirRequisicoes(this.tableRequisicoes.getSelectedRows(), 2, true);
                } else if (this.tabelaSelecionada == 2) {
                    this.imprimirExames(this.tableExamesLido.getSelectedRows(), 2);
                }
            } else if (o == this.itemImprimirRelatorioRequisicoes) {
                this.imprimirRelatorioRequisicoes(this.tableRequisicoes.getSelectedRows());
            } else if (o == this.itemImprimirTodasRelatorioRequisicoes) {
                this.tableRequisicoes.selectAll();
                this.imprimirRelatorioRequisicoes(this.tableRequisicoes.getSelectedRows());
            } else if (o == this.checkEtiquetaAutomatica) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParametrosUsuarios.setValor(Triagem.ETIQUETA_AUTOMATICA, String.valueOf(Triagem.this.checkEtiquetaAutomatica.isSelected()));
                        ParametrosUsuarios.salvarParametros(true);
                    }
                });
            } else if (o == this.checkMapaAutomatico) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParametrosUsuarios.setValor(Triagem.MAPA_AUTOMATICO, String.valueOf(Triagem.this.checkMapaAutomatico.isSelected()));
                        ParametrosUsuarios.setValor(Triagem.MAPA_APENAS_SELECIONADO, String.valueOf(Triagem.this.itemImprimirMapaSelecionado.isSelected()));
                        ParametrosUsuarios.salvarParametros(true);
                        Triagem.this.itemImprimirMapaSelecionado.setVisible(Triagem.this.checkMapaAutomatico.isSelected());
                    }
                });
            } else if (o == this.itemImprimirMapaSelecionado) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParametrosUsuarios.setValor(Triagem.MAPA_APENAS_SELECIONADO, String.valueOf(Triagem.this.itemImprimirMapaSelecionado.isSelected()));
                        ParametrosUsuarios.salvarParametros(true);
                    }
                });
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Triagem");
        }
    }

    private void novo() {
        if (this.tableRequisicoes.getRowCount() > 0) {
            this.limparTela();
        }
        this.habilitarDesabilitarEstado(true);
        ScreenUtil.requisitarFoco(this.textTubo);
    }

    private void limparTela() {
        this.textTubo.clear();
        this.labelConvenio.setText("");
        this.etiquetas.clear();
        this.limparModelos();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textTubo && e.getKeyCode() == 10) {
            this.adicionarEtiqueta(this.textTubo.getText());
            this.textTubo.setText("");
            this.buttonFechar.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textTubo);
        } else if (o == this.tableRequisicoes && e.getKeyCode() == 127) {
            int indice = this.tableRequisicoes.getSelectedRow();
            Registro reg = this.modeloReq.getRegistro(indice);
            if (reg != null) {
                String req = reg.getString("req_codigo");
                if (Funcoes.mensagem(this, "Deseja remover a requisi\u00e7\u00e3o " + req + " ?", 4) == 0) {
                    this.removerRegistroRequisicao(indice);
                    this.removerEtiquetas(req);
                    int n = indice = indice > this.modeloReq.getRowCount() - 1 ? this.modeloReq.getRowCount() - 1 : indice;
                    if (indice > -1) {
                        this.tableRequisicoes.setRowSelectionInterval(indice, indice);
                    } else {
                        ScreenUtil.requisitarFoco(this.textTubo);
                    }
                    this.buttonImprimir.setEnabled(this.tableRequisicoes.getRowCount() > 0);
                }
            }
        } else if (o == this.tableRequisicoes && e.getKeyCode() == 39) {
            ScreenUtil.requisitarFoco(this.tableExamesLido);
        } else if (o == this.tableExamesLido && e.getKeyCode() == 37) {
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        this.itemObservacaoExame.setVisible(o == this.tableExamesLido && this.acessoObservacaoExame);
        if (o == this.tableRequisicoes || o == this.tableExamesLido) {
            JTable table = (JTable)o;
            table.setBorder(bordaSelecionada);
            this.atualizarTextoBotaoImprimir(table);
            this.tabelaSelecionada = o == this.tableRequisicoes ? 1 : 2;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes || o == this.tableExamesLido) {
            JTable table = (JTable)o;
            table.setBorder(bordaSimples);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o = e.getSource();
        if (o != this.tableColeta.getSelectionModel() && o != this.tableTriagem.getSelectionModel()) {
            this.textInstrucoes.setText("");
        }
        if (o == this.tableRequisicoes.getSelectionModel()) {
            if (this.tableRequisicoes.getSelectedRowCount() > 1) {
                this.tableExamesLido.setModel(modeloExaLido);
                this.tableExames.setModel(modeloExa);
                this.tableColeta.setModel(modeloCol);
                this.tableTriagem.setModel(modeloTri);
            } else {
                ModeloResultSet mrsExaLido;
                Registro reg = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow());
                if (reg != null && (mrsExaLido = (ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO)) != null) {
                    this.tableExamesLido.setModel(mrsExaLido);
                    ModeloResultSet mrsExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
                    if (mrsExa != null) {
                        this.tableExames.setModel(mrsExa);
                    }
                    if (mrsExaLido.getRowCount() > 0) {
                        this.tableExamesLido.setRowSelectionInterval(0, 0);
                    }
                }
            }
            this.atualizarTextoBotaoImprimir(this.tableRequisicoes);
        } else if (o == this.tableExamesLido.getSelectionModel()) {
            ModeloResultSet modExaLido = (ModeloResultSet)this.tableExamesLido.getModel();
            if (modExaLido != null) {
                ModeloResultSet mrsExaLido;
                Registro reg = modExaLido.getRegistro(this.tableExamesLido.getSelectedRow());
                if (this.tableExamesLido.getSelectedRowCount() > 1) {
                    this.tableColeta.setModel(modeloCol);
                    this.tableTriagem.setModel(modeloTri);
                } else if (reg != null && (mrsExaLido = (ModeloResultSet)reg.getValor(MODELO_COLETA)) != null) {
                    this.tableColeta.setModel(mrsExaLido);
                    if (reg != null && (mrsExaLido = (ModeloResultSet)reg.getValor(MODELO_TRIAGEM)) != null) {
                        this.tableTriagem.setModel(mrsExaLido);
                    }
                }
                if (reg != null) {
                    this.textInstrucoes.setText(reg.getString("emc_prepamostra"));
                }
                this.habilitarOpcoes(modExaLido.getRegistro(this.tableExamesLido.getSelectedRow()));
            }
            this.atualizarTextoBotaoImprimir(this.tableExamesLido);
            this.redimensionarColunas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requisicaoColetada(String filial, String requisicao) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select a.req_telacoleta, b.exr_situacao from requisicao a ");
            buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ").append(filial);
            buf.append(" and a.req_codigo = ").append(requisicao);
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                if (rs.getString("exr_situacao").equals("T")) continue;
                retorno = true;
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Triagem (505)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean todosExamesColetados(String filial, String requisicao) {
        boolean retorno = true;
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select a.req_telacoleta, b.exr_situacao from requisicao a ");
            buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ").append(filial);
            buf.append(" and a.req_codigo = ").append(requisicao);
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                if (!rs.getString("exr_situacao").equals("T")) continue;
                retorno = false;
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Triagem (505)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void adicionarEtiqueta(String etiqueta) {
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
        if (Funcoes.textoVazio(etiqueta)) {
            return;
        }
        if (dce == null) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida", 1);
        } else {
            new TuboDao();
            if (!TuboDao.contemCadastro(dce)) {
                Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada", 1);
            } else if (this.etiquetas.contains(dce)) {
                Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" j\u00e1 foi adicionada", 1);
            } else if (!this.requisicaoColetada(dce.getFilial(), dce.getRequisicao()) && !this.acessoRequisicaoNaoColetada) {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o " + dce.getRequisicao() + " n\u00e3o pode ser inclu\u00edda pois ainda n\u00e3o foi coletada", 1);
            } else {
                String msg = this.adicionarRequisicao(dce.getFilial(), dce.getRequisicao(), dce.getTubo());
                if (!Funcoes.textoVazio(msg)) {
                    Funcoes.mensagem(this, msg, 2);
                    return;
                }
                final int indice = this.modeloReq.getIndice("req_codigo", dce.getRequisicao());
                if (indice >= 0) {
                    this.etiquetas.add(dce);
                    String codigosRequisicoes = this.buscaCodigoMultiguia(dce.getFilial(), dce.getRequisicao());
                    boolean requisicoesImprimiuEtiqueta = false;
                    for (String codigoRequisicao : codigosRequisicoes.split(",")) {
                        ModeloResultSet modExaLido;
                        Registro regReq = this.modeloReq.getRegistro(this.modeloReq.getIndice("req_codigo", codigoRequisicao = codigoRequisicao.trim()));
                        if (regReq == null || (modExaLido = (ModeloResultSet)regReq.getValor(MODELO_EXAMES_LIDO)) == null) continue;
                        boolean reqLida = true;
                        boolean reqTriada = true;
                        for (Registro regExa : modExaLido.getRegistros()) {
                            boolean exaOk = true;
                            ModeloResultSet modCol = (ModeloResultSet)regExa.getValor(MODELO_COLETA);
                            if (modCol != null) {
                                for (Registro regCol : modCol.getRegistros()) {
                                    if (dce.getTubo().equals(regCol.getValor(COD_COLETA))) {
                                        regCol.setValor(TUBO_LIDO, Boolean.TRUE);
                                    }
                                    if (regCol.getBoolean(TUBO_CONFERIDO)) continue;
                                    reqTriada = false;
                                }
                            }
                            if (exaOk) {
                                regExa.setValor(TUBO_LIDO, Boolean.TRUE);
                                regExa.setValor(TUBO_CONFERIDO, Boolean.TRUE);
                                continue;
                            }
                            reqLida = false;
                        }
                        regReq.setValor(TUBO_LIDO, reqLida);
                        regReq.setValor(TUBO_TRIADO, reqTriada);
                        if (!reqLida || requisicoesImprimiuEtiqueta) continue;
                        if (this.checkEtiquetaAutomatica.isSelected()) {
                            requisicoesImprimiuEtiqueta = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Triagem.this.imprimirRequisicoes(new int[]{indice}, 2, true);
                                }
                            });
                        }
                        if (!this.checkMapaAutomatico.isSelected()) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Triagem.this.imprimirMapas(indice);
                            }
                        });
                    }
                    this.tableRequisicoes.repaint();
                    this.tableExamesLido.repaint();
                    this.tableExames.repaint();
                    this.tableColeta.repaint();
                    if (indice > -1) {
                        this.tableRequisicoes.setRowSelectionInterval(indice, indice);
                    }
                    this.buttonImprimir.setEnabled(this.tableRequisicoes.getRowCount() > 0);
                    this.buttonSalvar.setEnabled(this.tableRequisicoes.getRowCount() > 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String adicionarRequisicao(String filial, String requisicao, String tubo) {
        st = Conexao.getStatement();
        retorno = "";
        codigosMultiguia = "";
        this.colunaRequisicaoPai = 0;
        if (st == null) return retorno;
        try {
            codigosMultiguia = this.buscaCodigoMultiguia(filial, requisicao);
            requisicao = codigosMultiguia.split(",")[this.colunaRequisicaoPai].trim();
            regReq = null;
            if (this.modeloReq.contemValor("req_codigo", requisicao)) {
                regReq = this.modeloReq.getRegistro(this.modeloReq.getIndice("req_codigo", requisicao));
            }
            tipoRecipiente = "C";
            v0 = isAgruparColeta = ParametrosGerais.getAgruparInterface() == 0;
            if (!isAgruparColeta) {
                tipoRecipiente = "T";
            }
            bui = new StringBuilder();
            bui.append(" select a.fil_codigo ");
            bui.append("       ,a.req_codigo as codigo ");
            bui.append("       ,a.exa_codigo ");
            bui.append("       ,a.mco_codigo ");
            bui.append("   from examerequisicaorecipiente a ");
            bui.append("   left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("   left join recipientes f on a.fil_codigo = f.fil_codigo and a.rec_kodigo = f.rec_codigo ");
            bui.append("  where a.fil_codigo = ").append(filial);
            bui.append("    and a.req_codigo IN (").append(codigosMultiguia).append(") ");
            bui.append("    and (not b.req_excluida or b.req_origemagendamento) ");
            bui.append("    and f.rec_tipo = '").append(tipoRecipiente).append("' ");
            rsChave = Conexao.executeQuery(Conexao.getStatement(), bui.toString());
            chave = new StringBuilder(" (");
            i = 0;
            possuiEtiqueta = false;
            while (rsChave.next()) {
                if (i++ > 0) {
                    chave.append(", ");
                }
                possuiEtiqueta = true;
                chave.append(" (").append(rsChave.getInt("fil_codigo")).append(", ").append(rsChave.getInt("codigo")).append(", '").append(rsChave.getString("exa_codigo")).append("', ").append(rsChave.getInt("mco_codigo")).append(") ");
            }
            chave.append(") ");
            if (!possuiEtiqueta) ** GOTO lbl316
            bui.setLength(0);
            bui.append(" select distinct aux.* ");
            bui.append("       ,i.exr_situacao ");
            bui.append("       ,i.exr_dataetqtriagem ");
            bui.append("       ,(aux.req_urgente or coalesce(i.exr_urgente, false)) as req_urgente ");
            bui.append("       ,i.exr_obs ");
            bui.append("  from examerequisicao i ");
            bui.append("  join (select a.fil_codigo ");
            bui.append("       \t\t\t\t,codreq.requisicao as req_codigo ");
            bui.append("       \t\t\t\t,a.exa_codigo ");
            bui.append("       \t\t\t\t,a.mco_codigo ");
            bui.append("       \t\t\t\t,a.err_datatriagem ");
            bui.append("       \t\t\t\t,c.pac_nome ");
            bui.append("       \t\t\t\t,d.exa_descricao ");
            bui.append("       \t\t\t\t,a.rec_codigo ");
            bui.append("       \t\t\t\t,a.ere_tipo ");
            bui.append("       \t\t\t\t,f.rec_codigo as ").append("cod_coleta");
            bui.append("       \t\t\t\t,f.rec_descricao as ").append("des_coleta");
            bui.append("       \t\t\t\t,h.rec_codigo as ").append("cod_triagem");
            bui.append("       \t\t\t\t,h.rec_descricao as ").append("des_triagem");
            bui.append("       \t\t\t\t,j.prz_codigo ");
            bui.append("       \t\t\t\t,j.emc_solicitarjejum ");
            bui.append("       \t\t\t\t,b.con_codigo ");
            bui.append("       \t\t\t\t,j.emc_prepamostra ");
            bui.append("       \t\t\t\t,b.des_codigo ");
            bui.append("       \t\t\t\t,b.req_telacoleta ");
            bui.append("       \t\t\t\t,k.mco_abreviatura ");
            bui.append("                    ,b.req_urgente ");
            bui.append("   \t\t\t\tfrom examerequisicaorecipiente a ");
            bui.append("   \t\t\t\tleft join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("   \t\t\t\tleft join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
            bui.append("   \t\t\t\tleft join exames d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo ");
            if (isAgruparColeta) {
                bui.append("   \t\t\t\tleft join recipcoleta e on a.fil_codigo = e.fil_codigo and a.rec_codigo = e.rec_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
            } else {
                bui.append("   \t\t\t\tleft join reciptriagem e on a.fil_codigo = e.fil_codigo and a.rec_codigo = e.rec_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
            }
            bui.append("                join (select MIN(exr.req_codigo) as requisicao ");
            bui.append("                            ,rco.rec_codigo as recipiente ");
            bui.append("                        from examerequisicao exr ");
            if (isAgruparColeta) {
                bui.append("                        join recipcoleta rco on exr.fil_codigo = rco.fil_codigo and exr.exa_codigo = rco.exa_codigo and exr.mco_codigo = rco.mco_codigo ");
            } else {
                bui.append("                        join reciptriagem rco on exr.fil_codigo = rco.fil_codigo and exr.exa_codigo = rco.exa_codigo and exr.mco_codigo = rco.mco_codigo ");
            }
            bui.append("                       where exr.fil_codigo = ").append(filial);
            bui.append("                         and exr.req_codigo IN (").append(codigosMultiguia).append(") ");
            bui.append("                    group by exr.req_codigo,rco.rec_codigo) codreq on e.rec_codigo = codreq.recipiente and a.req_codigo = codreq.requisicao ");
            bui.append("   \t\t\t\tleft join recipientes f on a.fil_codigo = f.fil_codigo and a.rec_kodigo = f.rec_codigo ");
            bui.append("   \t\t\t\tleft join reciptriagem g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            bui.append("   \t\t\t\tleft join recipientes h on g.fil_codigo = h.fil_codigo and g.rec_codigo = h.rec_codigo ");
            bui.append("   \t\t\t\tleft join examerequisicao i on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo and a.exa_codigo = i.exa_codigo and a.mco_codigo = i.mco_codigo ");
            bui.append("   \t\t\t\tleft join examematcoleta j on a.fil_codigo = j.fil_codigo and a.exa_codigo = j.exa_codigo and a.mco_codigo = j.mco_codigo ");
            bui.append("   \t\t\t\tleft join materialcoleta k on a.fil_codigo = k.fil_codigo and a.mco_codigo = k.mco_codigo ");
            bui.append("  \t\t\t where a.fil_codigo = ").append(filial);
            bui.append("    \t\t\t and a.req_codigo IN (").append(codigosMultiguia).append(") ");
            bui.append("    \t\t\t and (not b.req_excluida or b.req_origemagendamento) ");
            bui.append("           and f.rec_tipo ='").append(tipoRecipiente).append("' ");
            bui.append("           and (i.fil_codigo, i.req_codigo, i.exa_codigo, i.mco_codigo) in ").append(chave.toString());
            bui.append("       ) aux on aux.fil_codigo = i.fil_codigo and i.req_codigo IN (").append(codigosMultiguia).append(") and aux.exa_codigo = i.exa_codigo and aux.mco_codigo = i.mco_codigo ");
            bui.append("   where i.exr_excluido = false ");
            bui.append("  order by aux.exa_codigo, aux.mco_codigo, ");
            bui.append("cod_coleta").append(", ").append("cod_triagem");
            res = Conexao.executeQuery(st, bui.toString());
            tubosColetado = new ArrayList<String>();
lbl173:
            // 3 sources

            while (res.next()) {
                if (!tubo.equals(res.getString("rec_codigo")) || !isAgruparColeta || !res.getString("ere_tipo").equals("T")) ** GOTO lbl-1000
                retorno = "A etiqueta digitada n\u00e3o foi encontrada ou n\u00e3o \u00e9 uma etiqueta de coleta.";
                var17_18 = "A etiqueta digitada n\u00e3o foi encontrada ou n\u00e3o \u00e9 uma etiqueta de coleta.";
                ** GOTO lbl186
            }
            ** GOTO lbl197
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (679)");
            }
            catch (Throwable var35_39) {
                Conexao.fecharStatement(new Statement[]{st});
                throw var35_39;
            }
lbl186:
            // 1 sources

            Conexao.fecharStatement(new Statement[]{st});
            return var17_18;
lbl-1000:
            // 1 sources

            {
                if (!tubo.equals(res.getString("rec_codigo")) || isAgruparColeta || !res.getString("ere_tipo").equals("C")) ** GOTO lbl-1000
                retorno = "A etiqueta digitada n\u00e3o foi encontrada ou n\u00e3o \u00e9 uma etiqueta de triagem.";
                var17_19 = "A etiqueta digitada n\u00e3o foi encontrada ou n\u00e3o \u00e9 uma etiqueta de triagem.";
            }
            Conexao.fecharStatement(new Statement[]{st});
            return var17_19;
lbl-1000:
            // 1 sources

            {
                if (tubosColetado.contains(res.getString("cod_coleta"))) ** GOTO lbl173
                tubosColetado.add(res.getString("cod_coleta"));
                ** GOTO lbl173
lbl197:
                // 1 sources

                requisicoesContemTubo = false;
                for (String codigoRequisicao : codigosMultiguia.split(",")) {
                    codigoRequisicao = codigoRequisicao.trim();
                    regReq = null;
                    if (this.modeloReq.contemValor("req_codigo", codigoRequisicao)) {
                        regReq = this.modeloReq.getRegistro(this.modeloReq.getIndice("req_codigo", codigoRequisicao));
                    }
                    if (tubosColetado.contains(tubo) && res.first()) {
                        strComQuebra = new StringBuilder("<html>");
                        strComQuebra.append(res.getString("pac_nome")).append("</html>");
                        reg = new Registro();
                        reg.setValor("fil_codigo", res.getString("fil_codigo"));
                        reg.setValor("req_codigo", codigoRequisicao);
                        reg.setValor("pac_nome", strComQuebra.toString());
                        reg.setValor("req_urgente", res.getBoolean("req_urgente"));
                        exame = null;
                        listExa = new ArrayList<String>();
                        modExaLido = (ModeloResultSet)Triagem.modeloExaLido.clone();
                        modExa = (ModeloResultSet)Triagem.modeloExa.clone();
                        modCol = null;
                        modTri = null;
                        if (regReq != null && regReq.getString("req_codigo").equals(codigoRequisicao)) {
                            modExaLido = (ModeloResultSet)regReq.getValor("modelo_exames_lido");
                            modExa = (ModeloResultSet)regReq.getValor("modelo_exames");
                            for (Registro r : modExaLido.getRegistros()) {
                                listExa.add(r.getString("exa_codigo") + r.getString("mco_codigo"));
                            }
                        }
                        do {
                            chaveExame = res.getString("exa_codigo") + res.getString("mco_codigo");
                            pos = modExaLido.getIndice("chave", res.getString("exa_codigo") + res.getString("mco_codigo"));
                            if (!listExa.contains(chaveExame) || pos > -1) {
                                if (pos > -1) {
                                    exame = modExaLido.getRegistro(pos);
                                    modCol = (ModeloResultSet)exame.getValor("modelo_coleta");
                                    modTri = (ModeloResultSet)exame.getValor("modelo_triagem");
                                } else {
                                    exame = new Registro();
                                    modCol = (ModeloResultSet)Triagem.modeloCol.clone();
                                    exame.setValor("modelo_coleta", modCol);
                                    modTri = (ModeloResultSet)Triagem.modeloTri.clone();
                                    exame.setValor("modelo_triagem", modTri);
                                }
                                if (exame.getBoolean("tuboLido")) continue;
                                exame.setValor("exa_codigo", res.getString("exa_codigo"));
                                exame.setValor("mco_codigo", res.getObject("mco_codigo"));
                                exame.setValor("rec_codigo", res.getString("rec_codigo"));
                                exame.setValor("mco_abreviatura", res.getObject("mco_abreviatura"));
                                exame.setValor("exa_descricao", res.getString("exa_descricao"));
                                exame.setValor("exr_situacao", res.getString("exr_situacao"));
                                exame.setValor("fil_codigo", res.getString("fil_codigo"));
                                exame.setValor("req_codigo", res.getString("req_codigo"));
                                exame.setValor("prz_codigo", res.getString("prz_codigo"));
                                exame.setValor("emc_solicitarjejum", res.getBoolean("emc_solicitarjejum"));
                                exame.setValor("tuboTriado", res.getObject("err_datatriagem") != null);
                                exame.setValor("exr_obs", res.getString("exr_obs"));
                                exame.setValor("con_codigo", res.getString("con_codigo"));
                                exame.setValor("emc_prepamostra", res.getString("emc_prepamostra"));
                                exame.setValor("exr_situacao", res.getString("exr_situacao"));
                                exame.setValor("exr_dataetqtriagem", res.getString("exr_dataetqtriagem"));
                                exame.setValor("chave", res.getString("exa_codigo") + res.getString("mco_codigo"));
                                exame.setValor("codigoDestino", res.getString("des_codigo"));
                                listExa.add(chaveExame);
                            }
                            if (exame != null && exame.getString("req_codigo").equals(codigoRequisicao) && (Funcoes.objectIsNull(regReq) || !Funcoes.objectIsNull(regReq) && regReq.getString("req_codigo").equals(codigoRequisicao))) {
                                chaveColeta = res.getString("cod_coleta");
                                if (chaveColeta != null && !modCol.contemValor("cod_coleta", res.getString("cod_coleta"))) {
                                    strComQuebra.setLength(0);
                                    strComQuebra.append("<html>").append(res.getString("des_coleta")).append("</html>");
                                    coleta = new Registro();
                                    coleta.setValor("cod_coleta", chaveColeta);
                                    coleta.setValor("des_coleta", strComQuebra.toString());
                                    if (tubo.equals(chaveColeta)) {
                                        coleta.setValor("tuboLido", Boolean.TRUE);
                                    }
                                    coleta.setValor("tuboConferido", res.getObject("err_datatriagem") != null);
                                    if (!modCol.contemValor("cod_coleta", res.getString("cod_coleta"))) {
                                        modCol.addRegistro(coleta);
                                    }
                                }
                                if ((chaveTriagem = res.getString("cod_triagem")) != null && !modTri.contemValor("cod_triagem", res.getString("cod_triagem"))) {
                                    triagem = new Registro();
                                    strComQuebra.setLength(0);
                                    strComQuebra.append("<html>").append(res.getString("des_triagem")).append("</html>");
                                    triagem.setValor("cod_triagem", chaveTriagem);
                                    triagem.setValor("des_triagem", strComQuebra.toString());
                                    triagem.setValor("tuboTriado", res.getObject("err_datatriagem") != null);
                                    if (!modTri.contemValor("cod_triagem", res.getString("cod_triagem"))) {
                                        modTri.addRegistro(triagem);
                                    }
                                }
                                if (exame == null) continue;
                                if (tubosColetado.contains(res.getString("cod_coleta")) && res.getString("cod_coleta") != null && res.getString("cod_coleta").equals(tubo)) {
                                    if (this.acessoRequisicaoNaoColetada || !res.getString("exr_situacao").equals("T")) {
                                        if (pos >= 0) continue;
                                        modExaLido.addRegistro(exame);
                                        this.removeNaoLido(exame, modExa, modExaLido, tubo);
                                        continue;
                                    }
                                    if (modExa.getIndice("chave", exame.getValor("chave")) != -1) continue;
                                    modExa.addRegistro(exame);
                                    continue;
                                }
                                if (modExa.getIndice("chave", exame.getValor("chave")) == -1) {
                                    modExa.addRegistro(exame);
                                }
                                this.removeNaoLido(exame, modExa, modExaLido, tubo);
                                continue;
                            }
                            listExa.remove(chaveExame);
                        } while (res.next());
                        reg.setValor("modelo_exames_lido", modExaLido);
                        reg.setValor("modelo_exames", modExa);
                        if (!this.modeloReq.contemValor("req_codigo", reg.getString("req_codigo")) && modExaLido.getRowCount() > 0) {
                            this.modeloReq.addRegistro(reg);
                            requisicoesContemTubo = true;
                        } else if (modExaLido.getRowCount() == 0 && codigosMultiguia.split(",")[this.colunaRequisicaoPai].trim().equals(codigoRequisicao) && !ParametrosGerais.isAgruparGuiasInterface() && !requisicoesContemTubo) {
                            retorno = "Os exames do tubo digitado ainda n\u00e3o foram coletados!";
                        }
                        this.modeloReq.fireTableDataChanged();
                        Triagem.modeloExa.fireTableDataChanged();
                        Triagem.modeloExaLido.fireTableDataChanged();
                    }
                    if (codigosMultiguia.split(",").length <= 1 || this.etiquetas.contains(dce = DescritorCodigoEtiqueta.getDescritor(codigoRequisicao = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codigoRequisicao, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo())))) continue;
                    this.etiquetas.add(dce);
                }
            }
lbl316:
            // 2 sources

            Conexao.fecharStatement(new Statement[]{st});
            return retorno;
            Conexao.fecharStatement(new Statement[]{st});
            return retorno;
        }
    }

    private String buscaCodigoMultiguia(String filial, String requisicao) {
        StringBuilder codigosMultiguia = new StringBuilder();
        try {
            if (ParametrosGerais.isAgruparGuiasInterface() || this.possuiLabExterno(filial, requisicao)) {
                Integer[] aux = RecepcaoUtil.verificaMultiGuias(String.valueOf(filial), String.valueOf(requisicao), true);
                for (int i = 0; i < aux.length; ++i) {
                    codigosMultiguia.append(aux[i]);
                    if (i >= aux.length - 1) continue;
                    codigosMultiguia.append(", ");
                }
            } else {
                Integer[] aux = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
                int n = aux.length;
                for (int i = 0; i < n; ++i) {
                    int requisicaoAtual = aux[i];
                    if (!this.modeloReq.contemValor(this.modeloReq.getColumnName(1), String.valueOf(requisicaoAtual)) && !String.valueOf(requisicaoAtual).equals(requisicao)) continue;
                    if (!codigosMultiguia.toString().isEmpty()) {
                        codigosMultiguia.append(", ");
                    }
                    codigosMultiguia.append(requisicaoAtual);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (690)");
        }
        return codigosMultiguia.toString();
    }

    private boolean possuiLabExterno(String filial, String requisicao) throws SQLException {
        if (DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao)) {
            return DBUtil.requisicaoAgrupaMultiguiasLabExternoLote(Conexao.getStatement(), filial, requisicao);
        }
        return false;
    }

    private boolean todosLidos(String tubo, Registro exame) {
        int todosLidos = ((ModeloResultSet)exame.getValor(MODELO_COLETA)).getRowCount();
        for (Registro r : ((ModeloResultSet)exame.getValor(MODELO_COLETA)).getRegistros()) {
            if (!r.getBoolean(TUBO_LIDO) && (r.getBoolean(TUBO_LIDO) || !r.getValor(COD_COLETA).equals(tubo))) continue;
            --todosLidos;
        }
        return todosLidos == 0;
    }

    private void removeNaoLido(Registro exame, ModeloResultSet modExa, ModeloResultSet modExaLido, String tubo) {
        int exc = modExa.getIndice("chave", exame.getValor("chave"));
        if (exc > -1 && this.todosLidos(tubo, exame)) {
            modExa.removerRegistro(exc);
        }
    }

    private void atualizarTextoBotaoImprimir(JTable table) {
        if (table == this.tableRequisicoes) {
            this.subImprimirTodos.setText("Imprimir Todas as Requisi\u00e7\u00f5es");
            this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Requisi\u00e7\u00f5es" : "Imprimir Requisi\u00e7\u00e3o");
        } else if (table == this.tableExamesLido) {
            this.subImprimirTodos.setText("Imprimir Todos os Exames");
            this.subImprimir.setText(table.getSelectedRowCount() > 1 ? "Imprimir Exames" : "Imprimir Exame");
        }
    }

    private void habilitarDesabilitarEstado(boolean triando) {
        this.textTubo.setEnabled(triando);
        this.checkEtiquetaAutomatica.setEnabled(triando);
        this.checkMapaAutomatico.setEnabled(triando);
        this.buttonNovo.setEnabled(!triando);
        this.buttonCancelar.setEnabled(triando);
        this.buttonOpcoes.setEnabled(triando);
        this.buttonSalvar.setEnabled(triando && this.tableRequisicoes.getRowCount() > 0);
        this.buttonImprimir.setEnabled(triando && this.tableRequisicoes.getRowCount() > 0);
    }

    private void limparModelos() {
        while (this.modeloReq.getRegistro(0) != null) {
            this.removerRegistroRequisicao(0);
        }
    }

    private void removerRegistroRequisicao(int indice) {
        Registro reg = this.modeloReq.getRegistro(indice);
        if (reg != null) {
            this.limpaModeloExame((ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO));
            this.limpaModeloExame((ModeloResultSet)reg.getValor(MODELO_EXAMES));
            this.modeloReq.removerRegistro(indice);
            this.modeloReq.fireTableDataChanged();
        }
    }

    private void limpaModeloExame(ModeloResultSet exa) {
        if (exa != null) {
            for (Registro tmp : exa.getRegistros()) {
                ModeloResultSet mod = (ModeloResultSet)tmp.getValor(MODELO_COLETA);
                if (mod != null) {
                    mod.limpar();
                }
                if ((mod = (ModeloResultSet)tmp.getValor(MODELO_TRIAGEM)) == null) continue;
                mod.limpar();
            }
            exa.limpar();
        }
    }

    private void removerEtiquetas(String requisicao) {
        if (requisicao != null) {
            ArrayList<DescritorCodigoEtiqueta> tmp = new ArrayList<DescritorCodigoEtiqueta>();
            for (DescritorCodigoEtiqueta dce : this.etiquetas) {
                if (!dce.getRequisicao().equals(requisicao)) continue;
                tmp.add(dce);
            }
            for (DescritorCodigoEtiqueta dce : tmp) {
                this.etiquetas.remove(dce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarRecoleta(Registro reg) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null && reg != null) {
            block17: {
                try {
                    String justificativa = "";
                    String motivoRecoleta = "";
                    int codigoMotivo = 0;
                    SolicitarMotivoRecoleta recoleta = SolicitarMotivoRecoleta.novaInstancia(this.getTopLevelAncestor(), false, !Funcoes.textoVazio(reg.getString("fil_codigo")) ? reg.getString("fil_codigo") : Variaveis.filialPadrao);
                    recoleta.setVisible(true);
                    if (recoleta.getOK()) {
                        justificativa = recoleta.getDescricaoMotivo();
                        codigoMotivo = recoleta.getCodigoMotivo();
                        motivoRecoleta = recoleta.getMotivoRecoleta();
                        StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '");
                        bui.append("R");
                        bui.append("', exr_datarecoleta = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("', ");
                        bui.append(" usr_codrecoleta = '").append(StringUtil.textoDB(Variaveis.login)).append("', ");
                        bui.append(" exr_motivorecoleta = '").append(StringUtil.textoDB(justificativa)).append("' ");
                        if (codigoMotivo > 0) {
                            bui.append(" ,mrc_codigo = '").append(codigoMotivo).append("' ");
                        }
                        bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
                        bui.append(" and req_codigo = ");
                        bui.append(reg.getString("req_codigo"));
                        bui.append(" and exa_codigo = '");
                        bui.append(reg.getString("exa_codigo"));
                        bui.append("' and mco_codigo = ");
                        bui.append(reg.getString("mco_codigo"));
                        DBUtil.gravaLogSituacaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "R", false);
                        Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
                        if (this.exportarParaWeb()) {
                            this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "R", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                        }
                        ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                        Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                        try {
                            if (!SMSUtil.isBloquearSMSRecoleta(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                                SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RECOLETA, st, st2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!EmailUtil.isBloquearEmailRecoleta(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                                EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RECOLETA, true, st);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!PushUtil.isBloquearPushRecoleta(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                                PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RECOLETA, st, st2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.enviarMensagemWhatsappRecoleta(reg, st, st2);
                        Conexao.arquivaSQL();
                        break block17;
                    }
                    if (!recoleta.getCancelado() && !recoleta.isMarcarRecoleta()) break block17;
                    this.acaoCancelar = true;
                }
                catch (Exception e) {
                    try {
                        Conexao.fecharStatement(st);
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (882)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2);
                }
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void enviarMensagemWhatsappRecoleta(Registro reg, Statement st, Statement st2) {
        try {
            if (!WhatsAppUtil.isBloquearWhatsappRecoleta(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RECOLETA, st, st2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void marcarMaterialFaltante(Registro reg) {
        Statement st = Conexao.getStatement();
        if (st != null && reg != null) {
            try {
                StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '");
                bui.append("F");
                bui.append("', exr_datamaterial = null, usr_codmaterial = null, exr_dataentregaprev = null, exr_intervalojejum = null where fil_codigo = ");
                bui.append(reg.getString("fil_codigo"));
                bui.append(" and req_codigo = ");
                bui.append(reg.getString("req_codigo"));
                bui.append(" and exa_codigo = '");
                bui.append(reg.getString("exa_codigo"));
                bui.append("' and mco_codigo = ");
                bui.append(reg.getString("mco_codigo"));
                DBUtil.gravaLogSituacaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "F", false);
                Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
                if (this.exportarParaWeb()) {
                    this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "F", "dataColetaExameRequisicao", "", "horaColetaExameRequisicao", "");
                }
                ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), Integer.parseInt(reg.getString("req_codigo")), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receberMaterial(Registro reg, boolean perguntarJejum) {
        Statement st = Conexao.getStatement();
        if (st != null && reg != null) {
            try {
                Date entrega = ExameUtil.calculaDataEntrega(reg.getString("fil_codigo"), reg.getString("prz_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("con_codigo"), reg.getString("codigoDestino"));
                String dataEntrega = entrega != null ? Funcoes.formataData("MM/dd/yyyy HH:mm", entrega) : null;
                String tempoJejum = null;
                if (perguntarJejum && reg.getBoolean("emc_solicitarjejum")) {
                    String solicitarJejum = this.solicitarJejum();
                    tempoJejum = !Funcoes.textoVazio(solicitarJejum) ? "'" + solicitarJejum + "'" : null;
                }
                StringBuilder bui = new StringBuilder("update examerequisicao set exr_situacao = '', ");
                bui.append("exr_datamaterial = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("', ");
                bui.append("usr_codmaterial = '");
                bui.append(Variaveis.login);
                bui.append("', exr_dataentregaprev = ");
                if (dataEntrega != null) {
                    bui.append("'").append(dataEntrega).append("'");
                } else {
                    bui.append("null");
                }
                if (tempoJejum != null) {
                    bui.append(", exr_intervalojejum = ");
                    bui.append(tempoJejum);
                }
                bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
                bui.append(" and req_codigo = ");
                bui.append(reg.getString("req_codigo"));
                bui.append(" and exa_codigo = '");
                bui.append(reg.getString("exa_codigo"));
                bui.append("' and mco_codigo = ");
                bui.append(reg.getString("mco_codigo"));
                DBUtil.gravaLogSituacaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "", false);
                Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
                this.salvarTelaColeta(reg.getString("fil_codigo"), reg.getString("req_codigo"));
                if (this.exportarParaWeb()) {
                    this.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "", "dataColetaExameRequisicao", Funcoes.formataData("dd/MM/yyyy", new Date()), "horaColetaExameRequisicao", Funcoes.formataData("HH:mm", new Date()));
                }
                Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (838)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void salvarTelaColeta(String filial, String requisicao) throws SQLException {
        Statement st;
        if (this.todosExamesColetados(filial, requisicao) && (st = Conexao.getStatement()) != null) {
            StringBuilder bui = new StringBuilder("update requisicao set req_telacoleta = ");
            bui.append(true);
            bui.append(" where fil_codigo = ");
            bui.append(filial);
            bui.append(" and req_codigo = ");
            bui.append(requisicao);
            Conexao.executeUpdate(filial, st, bui.toString());
        }
    }

    private String solicitarJejum() {
        SolicitarJejum sj = SolicitarJejum.novaInstancia(this.getTopLevelAncestor());
        if (sj != null) {
            sj.setVisible(true);
            return sj.getTempoJejum().trim();
        }
        return "";
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (866)");
        }
    }

    private void alterarExameRequisicaoWeb(Statement st, Registro reg, String ... campos) throws Exception {
        String baseWeb = this.getBaseWeb();
        if (baseWeb != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(reg.getString("exa_codigo"));
            tmp.add("materialExameRequisicao");
            tmp.add(reg.getString("mco_codigo"));
            tmp.add("dataEnvioExameRequisicao");
            tmp.add("current_timestamp");
            for (String campo : campos) {
                tmp.add(campo);
            }
            DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexame", "A", true, tmp.toArray(new String[tmp.size()]));
        }
    }

    private String getBaseWeb() {
        return Funcoes.textoVazio(Variaveis.codigoBaseWeb) ? null : Variaveis.codigoBaseWeb;
    }

    private boolean exportarParaWeb() {
        return !Funcoes.textoVazio(Variaveis.codigoBaseWeb);
    }

    private void habilitarOpcoes(Registro reg) {
        if (reg != null) {
            String s = reg.getString("exr_situacao").trim();
            boolean semResultado = s.length() == 0;
            this.itemReceberMaterial.setVisible(this.acessoReceberMaterial && (s.equalsIgnoreCase("F") || s.equalsIgnoreCase("T")));
            this.itemMarcarMaterialFaltante.setVisible(this.acessoMarcarMaterialFaltante && semResultado);
            this.itemMarcarRecoleta.setVisible(this.acessoMarcarRecoleta && semResultado);
            this.itemImprimirTodasRelatorioRequisicoes.setVisible(this.acessoImprimirRelatorio);
            this.itemImprimirRelatorioRequisicoes.setVisible(this.acessoImprimirRelatorio);
            this.buttonOpcoes.setEnabled(this.itemReceberMaterial.isVisible() || this.itemMarcarMaterialFaltante.isVisible());
        }
    }

    private void atualizarExamesTriados(int[] indices) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                int[] rowsReq = this.tableRequisicoes.getSelectedRows();
                int[] rowsExa = this.tableExamesLido.getSelectedRows();
                for (Registro req : this.modeloReq.getRegistros(rowsReq)) {
                    ModeloResultSet modExaLido = (ModeloResultSet)req.getValor(MODELO_EXAMES_LIDO);
                    if (modExaLido == null) continue;
                    boolean tuboTriado = true;
                    for (Registro exa : modExaLido.getRegistros()) {
                        if (exa.getBoolean(TUBO_TRIADO)) continue;
                        tuboTriado = false;
                        break;
                    }
                    req.setValor(TUBO_TRIADO, tuboTriado);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Triagem.this.tableRequisicoes.repaint();
                            Triagem.this.tableExamesLido.repaint();
                            Triagem.this.tableExames.repaint();
                            Triagem.this.tableColeta.repaint();
                            Triagem.this.tableTriagem.repaint();
                        }
                    });
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsReq)) {
                        this.tableRequisicoes.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                    if (rowsReq.length != 1) continue;
                    for (Object inter : (Object)ArraysUtil.getIntervalos(rowsExa)) {
                        this.tableExamesLido.addRowSelectionInterval((int)inter[0], (int)inter[1]);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (984)");
            }
        }
    }

    private void imprimirRequisicoes(int[] indices, int etiqueta, boolean isImprimir) {
        this.imprimirRequisicoes(indices, etiqueta, isImprimir, null);
    }

    private void imprimirRequisicoes(int[] indices, int etiqueta, boolean isImprimir, Object origem) {
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        List<Registro> list;
        String chaveImp = "campoImprimir";
        Statement st = Conexao.getStatement();
        if (isImprimir && (list = this.getRequisicoesNaoTriadas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Imprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es para imprimir");
            if (dri != null) {
                dri.setModelo(mod);
                dri.addLinhaDescricao("Marque as requisi\u00e7\u00f5es que deseja imprimir.");
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    isImprimir = false;
                } else {
                    for (Registro reg : mod.getRegistros()) {
                        reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                    }
                }
            }
        }
        if (isImprimir && etiqueta == 2 && (list = this.getRequisicoesJaTriadas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es j\u00e1 triadas");
            if (dri != null) {
                dri.setMarcarTodas(false);
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisi\u00e7\u00f5es listadas abaixo cont\u00eam etiquetas de triagem j\u00e1 impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    isImprimir = false;
                } else {
                    for (Registro reg : mod.getRegistros()) {
                        reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                    }
                }
            }
        }
        if (isImprimir && etiqueta == 1 && (list = this.getRequisicoesJaColetadas(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "req_codigo", "Nome", "pac_nome", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es j\u00e1 coletadas");
            if (dri != null) {
                dri.setMarcarTodas(false);
                dri.setModelo(mod);
                dri.addLinhaDescricao("As requisi\u00e7\u00f5es listadas abaixo cont\u00eam etiquetas de coleta j\u00e1 impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque as que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    isImprimir = false;
                } else {
                    for (Registro reg : mod.getRegistros()) {
                        reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                    }
                }
            }
        }
        try {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            ArrayList<String> multiguias = new ArrayList<String>();
            for (Registro reg : this.modeloReq.getRegistros(indices)) {
                this.colunaRequisicaoPai = 0;
                int linhaSelecionada = this.modeloReq.getIndice("req_codigo", reg.getString("req_codigo"));
                int[] indiceSelecionado = new int[]{};
                if (linhaSelecionada > -1) {
                    indiceSelecionado = new int[]{linhaSelecionada};
                }
                if (reg.getBoolean(TUBO_CONFERIDO) || reg.getBoolean(TUBO_LIDO) || reg.getBoolean(IMPR_INCOMPLETO) || reg.getBoolean(REIMPRIMIR)) {
                    exames.clear();
                    materiais.clear();
                    ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO);
                    if (modExa != null) {
                        for (Registro regExa : modExa.getRegistros()) {
                            if (!regExa.getBoolean(TUBO_CONFERIDO)) continue;
                            exames.add(regExa.getString("exa_codigo"));
                            materiais.add(regExa.getInt("mco_codigo"));
                        }
                    }
                    int[] mat = new int[materiais.size()];
                    int pos = 0;
                    Iterator<Object> iterator = materiais.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        mat[pos++] = i;
                    }
                    if ((ParametrosGerais.isEtiquetaComoTriado() || !Funcoes.objectIsNull(origem) && origem == this.buttonSalvar) && (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO)) != null) {
                        for (Registro regExa : modExa.getRegistros()) {
                            ModeloResultSet modCol = (ModeloResultSet)regExa.getValor(MODELO_COLETA);
                            if (modCol == null) continue;
                            for (Registro regCol : modCol.getRegistros()) {
                                ModeloResultSet tubosLido;
                                if (regCol.getValor(TUBO_LIDO) == null || !((Boolean)regCol.getValor(TUBO_LIDO)).booleanValue()) continue;
                                if (!((Boolean)regCol.getValor(TUBO_CONFERIDO)).booleanValue()) {
                                    String codigosRequisicoes = this.buscaCodigoMultiguia(reg.getString("fil_codigo"), reg.getString("req_codigo"));
                                    this.atualizarDadosEtqTriagem(st, reg.getString("fil_codigo"), codigosRequisicoes, regExa.getString("exa_codigo"), regExa.getString("mco_codigo"), regCol.getString(COD_COLETA), Variaveis.login, isImprimir);
                                }
                                if ((tubosLido = (ModeloResultSet)regExa.getValor(MODELO_TRIAGEM)) != null) {
                                    for (Registro tubo : tubosLido.getRegistros()) {
                                        tubo.setValor(TUBO_TRIADO, true);
                                    }
                                }
                                regExa.setValor(TUBO_TRIADO, true);
                            }
                        }
                    }
                    if (isImprimir || ParametrosGerais.isEtiquetaComoTriado()) {
                        if (exames.size() > 0 && etiqueta == 2) {
                            if (reg.getBoolean("campoImprimir") && !multiguias.contains(reg.getString("req_codigo"))) {
                                Impressao.imprimirEtiquetaTriagem(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, Variaveis.login, reg.getBoolean(REIMPRIMIR), true);
                                this.atualizarMultiguias(reg, multiguias);
                            }
                        } else if (exames.size() > 0 && etiqueta == 1 && reg.getBoolean("campoImprimir") && !multiguias.contains(reg.getString("req_codigo"))) {
                            ImprimirEtiquetasColetaTriagem.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, reg.getBoolean(REIMPRIMIR), Variaveis.login, 1, false);
                            this.atualizarMultiguias(reg, multiguias);
                        }
                    }
                    Conexao.arquivaSQL();
                }
                this.tableRequisicoes.setRowSelectionInterval(indices[0], indices[0]);
                this.atualizarExamesTriados(indiceSelecionado);
                ++this.colunaRequisicaoPai;
            }
            this.colunaRequisicaoPai = 0;
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), e.getStackTrace(), "Triagem (1081)");
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (1083)");
        }
    }

    private void atualizarMultiguias(Registro reg, List<String> multiguias) {
        String[] codigosRequisicoes = this.buscaCodigoMultiguia(reg.getString("fil_codigo"), reg.getString("req_codigo")).split(",");
        if (codigosRequisicoes.length > 1) {
            for (String codReq : codigosRequisicoes) {
                multiguias.add(codReq.trim());
            }
        }
    }

    private void imprimirExames(int[] indices, int etiqueta) {
        Registro regReq;
        DialogoRequisicaoIncompleta dri;
        ModeloResultSet mod;
        Statement st = Conexao.getStatement();
        String chaveImp = "campoImprimir";
        boolean imp = false;
        List<Registro> list = this.getExamesNaoTriados(indices);
        if (list != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao");
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames para imprimir");
            if (dri != null) {
                dri.setModelo(mod);
                dri.setConfirmacaoImpressao(false);
                dri.setConfirmaCancela(true);
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    imp = false;
                }
                imp = true;
            }
        }
        if (etiqueta == 2 && (list = this.getExamesJaTriados(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames j\u00e1 triados");
            if (dri != null) {
                dri.setMarcarTodas(false);
                dri.setModelo(mod);
                dri.addLinhaDescricao("As etiquetas de triagem dos exames listados abaixo j\u00e1 foram impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque os que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    imp = false;
                } else {
                    for (Registro reg : mod.getRegistros()) {
                        reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                    }
                }
            }
        }
        if (etiqueta == 1 && (list = this.getExamesJaColetados(indices)) != null) {
            mod = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Nome", "exa_descricao", "Reimprimir", chaveImp);
            mod.addRegistros(list);
            mod.setColunaEditavel(chaveImp);
            dri = DialogoRequisicaoIncompleta.novaInstancia(this.getTopLevelAncestor(), "Exames j\u00e1 triados");
            if (dri != null) {
                dri.setMarcarTodas(false);
                dri.setModelo(mod);
                dri.addLinhaDescricao("As etiquetas de coleta dos exames listados abaixo j\u00e1 foram impressas.");
                dri.addLinhaDescricao(" ");
                dri.addLinhaDescricao("Marque os que deseja reimprimir.");
                dri.centralizar();
                dri.setVisible(true);
                if (!dri.ok()) {
                    imp = false;
                } else {
                    for (Registro reg : mod.getRegistros()) {
                        reg.setValor(REIMPRIMIR, dri.ok() && reg.getBoolean(chaveImp));
                    }
                }
            }
        }
        if ((regReq = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow())) != null) {
            try {
                ModeloResultSet modExa = (ModeloResultSet)this.tableExamesLido.getModel();
                ArrayList<String> exames = new ArrayList<String>();
                ArrayList<Integer> materiais = new ArrayList<Integer>();
                for (Registro reg : modExa.getRegistros(indices)) {
                    if (!reg.getBoolean(TUBO_CONFERIDO) && !imp || reg.getBoolean(TUBO_TRIADO) && !reg.getBoolean(REIMPRIMIR) || !reg.getBoolean(REIMPRIMIR) && (etiqueta != 2 || !imp)) continue;
                    exames.add(reg.getString("exa_codigo"));
                    materiais.add(reg.getInt("mco_codigo"));
                }
                int[] mat = new int[materiais.size()];
                int pos = 0;
                Iterator iterator = materiais.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    mat[pos++] = i;
                }
                if (exames.size() > 0 && etiqueta == 2) {
                    for (Registro regExa : modExa.getRegistros()) {
                        ModeloResultSet modCol;
                        if (!exames.contains(regExa.getString("exa_codigo")) || (modCol = (ModeloResultSet)regExa.getValor(MODELO_COLETA)) == null) continue;
                        boolean todosTriados = true;
                        for (Registro regCol : modCol.getRegistros()) {
                            ModeloResultSet tubosLido;
                            if (regCol.getValor(TUBO_LIDO) != null && ((Boolean)regCol.getValor(TUBO_LIDO)).booleanValue()) {
                                this.atualizarDadosEtqTriagem(st, regReq.getString("fil_codigo"), regReq.getString("req_codigo"), regExa.getString("exa_codigo"), regExa.getString("mco_codigo"), regCol.getString(COD_COLETA), Variaveis.login, imp);
                                regCol.setValor(TUBO_CONFERIDO, true);
                            }
                            if (regCol.getValor(TUBO_CONFERIDO) == null || !((Boolean)regCol.getValor(TUBO_CONFERIDO)).booleanValue()) {
                                todosTriados = false;
                            }
                            if ((tubosLido = (ModeloResultSet)regExa.getValor(MODELO_TRIAGEM)) == null) continue;
                            for (Registro tubo : tubosLido.getRegistros()) {
                                tubo.setValor(TUBO_TRIADO, true);
                            }
                        }
                        if (!todosTriados) continue;
                        regExa.setValor(TUBO_TRIADO, true);
                    }
                    ImprimirEtiquetasColetaTriagem.imprimir(regReq.getString("fil_codigo"), regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, true, Variaveis.login, 2, false);
                } else if (exames.size() > 0 && etiqueta == 1) {
                    ImprimirEtiquetasColetaTriagem.imprimir(regReq.getString("fil_codigo"), regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, true, Variaveis.login, 1, false);
                }
                Conexao.arquivaSQL();
                this.atualizarExamesTriados(indices);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), e.getStackTrace(), "Triagem (1172)");
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (1174)");
            }
        }
    }

    private void imprimirRelatorioRequisicoes(int[] indices) {
        StringBuilder buf = new StringBuilder("(");
        ArrayList<String> filiais = new ArrayList<String>();
        for (int i : indices) {
            if (!filiais.contains(this.modeloReq.getRegistro(i).getString("fil_codigo"))) {
                filiais.add(this.modeloReq.getRegistro(i).getString("fil_codigo"));
            }
            buf.append("((a.fil_codigo = ").append(this.modeloReq.getRegistro(i).getString("fil_codigo"));
            buf.append(" and a.req_codigo = ").append(this.modeloReq.getRegistro(i).getString("req_codigo")).append(" ) and (");
            ModeloResultSet modExaLido = (ModeloResultSet)modeloExaLido.clone();
            modExaLido = (ModeloResultSet)this.modeloReq.getRegistro(i).getValor(MODELO_EXAMES_LIDO);
            for (Registro r : modExaLido.getRegistros()) {
                ModeloResultSet modCol = (ModeloResultSet)((ModeloResultSet)r.getValor(MODELO_COLETA)).clone();
                modCol.filtrar(TUBO_LIDO, String.valueOf(Boolean.TRUE));
                buf.append(" (");
                for (Registro coleta : modCol.getRegistros()) {
                    if (!coleta.getBoolean(TUBO_LIDO)) continue;
                    buf.append("( b.exa_codigo = '").append(r.getString("exa_codigo")).append("' and ");
                    buf.append("  b.mco_codigo = ").append(r.getString("mco_codigo")).append(" and ");
                    buf.append("err.rec_codigo = ").append(coleta.getString(COD_COLETA)).append(" ) ");
                    if (!modCol.getRegistro(modCol.getRowCount() - 1).equals(coleta) && modCol.getRowCount() > 1) {
                        buf.append(" or ");
                        continue;
                    }
                    buf.append(")");
                }
                if (!modExaLido.getRegistro(modExaLido.getRowCount() - 1).equals(r) && modExaLido.getRowCount() > 1) {
                    buf.append(" or ");
                    continue;
                }
                buf.append(")");
            }
            buf.append(")");
            if (indices[indices.length - 1] == i) continue;
            buf.append(") or (");
        }
        buf.append(")");
        String[] fil = new String[filiais.size()];
        for (int i = 0; i < filiais.size(); ++i) {
            fil[i] = (String)filiais.get(i);
        }
        final JDialog dialogo = new JDialog((JFrame)this.getTopLevelAncestor(), "Listagem de requisi\u00e7\u00f5es triadas", true);
        JPanel panel = new JPanel(new BorderLayout());
        dialogo.add((Component)panel, "Center");
        RelatorioTriagem relatorioTriagem = new RelatorioTriagem();
        relatorioTriagem.imprimirPressionado(buf.toString(), panel, dialogo, new Runnable(){

            @Override
            public void run() {
                dialogo.dispose();
            }
        });
        dialogo.setSize(new Dimension(700, 500));
        dialogo.setVisible(true);
    }

    private void configurarRelatorio() {
        block12: {
            try {
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(300300106L);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                String modelo = "";
                if (rs.next()) {
                    modelo = rs.getString("rel_xml");
                }
                Editor editor = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando relat\u00f3rio", true);
                if (RelatorioTriagem.campos != null) {
                    editor.setCamposDoBanco(RelatorioTriagem.campos);
                }
                if (!Funcoes.textoVazio(modelo)) {
                    editor.setAtributos(rs.getString("rel_xml"));
                }
                editor.setVariaveis(null);
                editor.setVisible(true);
                if (!editor.ok()) break block12;
                buf.delete(0, buf.length());
                buf.append("select rel_codigo from relatoriosistema where rel_codigo = ");
                buf.append(300300106L);
                rs = Conexao.executeQuery(st, buf.toString());
                buf.delete(0, buf.length());
                if (rs.next()) {
                    buf.append("update relatoriosistema set rel_xml = '");
                    buf.append(StringUtil.textoDB(editor.getAtributos()));
                    buf.append("' where rel_codigo = ");
                    buf.append(300300106L);
                } else {
                    buf.append("insert into relatoriosistema(rel_codigo, rel_xml) values (");
                    buf.append(300300106L);
                    buf.append(", '");
                    buf.append(StringUtil.textoDB(editor.getAtributos()));
                    buf.append("')");
                }
                try {
                    String[] filiaisIntegracao;
                    Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                        if (filial.equals(Variaveis.filialPadrao)) continue;
                        IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
                    }
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
            }
        }
    }

    private void imprimirMapas(int indice) {
        boolean naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100302"));
        Registro regReq = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow());
        if (regReq != null) {
            try {
                boolean agruparMultiguias;
                Object[] guias = new Integer[]{Integer.parseInt(regReq.getString("req_codigo"))};
                boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), regReq.getString("fil_codigo"), (Integer[])guias);
                if (agruparMultiguias) {
                    guias = RecepcaoUtil.verificaMultiGuias(regReq.getString("fil_codigo"), regReq.getString("req_codigo"));
                    guias = guias == null || guias.length == 0 ? new Integer[]{Integer.parseInt(regReq.getString("req_codigo"))} : ArraysUtil.concatenar(guias, new Integer[]{Integer.parseInt(regReq.getString("req_codigo"))});
                }
                if (guias != null && guias.length > 1) {
                    Arrays.sort(guias);
                }
                if (guias != null) {
                    for (Object req : guias) {
                        ModeloResultSet mrs;
                        String[] exames = null;
                        if (this.itemImprimirMapaSelecionado.isSelected() && (mrs = (ModeloResultSet)regReq.getValor(MODELO_EXAMES_LIDO)) != null) {
                            ArrayList<String> list = new ArrayList<String>();
                            for (int i = 0; i < mrs.getRowCount(); ++i) {
                                Registro r = mrs.getRegistro(i);
                                list.add(r.getString("exa_codigo"));
                                list.add(r.getString("mco_codigo"));
                            }
                            exames = list.toArray(new String[list.size()]);
                        }
                        if (!ImprimirMapa.imprimir(regReq.getString("fil_codigo"), String.valueOf(req), exames, null, false, false, naoPermiteVisualizarPaciente, -1)) continue;
                        String tempo = ParametrosLocais.getParametro("tempoImpressaoMapa");
                        Thread.sleep(tempo != null && tempo.matches("\\d+") ? (long)Integer.parseInt(tempo) : 0L);
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Triagem (1288)");
            }
        }
    }

    private List<Registro> getRequisicoesIncompletas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null || reg.getBoolean(TUBO_TRIADO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getRequisicoesNaoTriadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private boolean todasRequisicoesCompletas() {
        for (Registro reg : this.modeloReq.getRegistros()) {
            if (reg.getBoolean(TUBO_CONFERIDO)) continue;
            return false;
        }
        return true;
    }

    private List<Registro> getRequisicoesJaTriadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO)) == null) continue;
            boolean triado = false;
            for (int j = 0; !triado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                triado = r != null && (r.getBoolean(TUBO_TRIADO) || r.getValor("err_datatriagem") != null);
            }
            if (!triado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getRequisicoesJaColetadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES_LIDO)) == null) continue;
            boolean coletado = false;
            for (int j = 0; !coletado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                coletado = r != null && r.getBoolean(TUBO_LIDO);
            }
            if (!coletado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesIncompletos(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExamesLido.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (reg == null || reg.getBoolean(TUBO_LIDO) || reg.getBoolean(TUBO_TRIADO) || reg.getBoolean(TUBO_CONFERIDO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesNaoTriados(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExamesLido.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (reg == null || reg.getBoolean(TUBO_TRIADO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesJaTriados(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExamesLido.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (reg == null || !reg.getBoolean(TUBO_TRIADO) && reg.getValor("err_datatriagem") == null) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getExamesJaColetados(int[] indices) {
        ArrayList<Registro> list = null;
        ModeloResultSet modExa = (ModeloResultSet)this.tableExamesLido.getModel();
        for (int i : indices) {
            Registro reg = modExa.getRegistro(i);
            if (reg == null || !reg.getBoolean(TUBO_LIDO)) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private void iniciar() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Triagem", "Triagem de etiquetas", "triagem/triagem_etiquetas.jpg");
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.add((Component)panelBotoes, "South");
        JPanel aux = new JPanel(new FlowLayout(0, 3, 3));
        panelBotoes.add((Component)aux, "West");
        aux.add(this.buttonOpcoes);
        aux.add(this.checkEtiquetaAutomatica);
        aux.add(this.checkMapaAutomatico);
        panelBotoes.add((Component)aux, "West");
        aux = new JPanel(new FlowLayout(2, 3, 2));
        panelBotoes.add((Component)aux, "East");
        aux.add(this.buttonNovo);
        if (this.acessoBotaoSalvar) {
            aux.add(this.buttonSalvar);
        }
        aux.add(this.buttonCancelar);
        aux.add(this.buttonImprimir);
        aux.add(this.buttonFechar);
        panelBotoes.add((Component)aux, "East");
        aux = new JPanel(new BorderLayout());
        this.add(aux);
        JPanel panelCentral = new JPanel();
        aux.add((Component)panelCentral, "Center");
        GridBagLayout gbl_panelCentral = new GridBagLayout();
        panelCentral.setLayout(gbl_panelCentral);
        this.tableRequisicoes.setDefaultRenderer(Object.class, this);
        this.tableRequisicoes.addFocusListener(this);
        this.tableRequisicoes.addKeyListener(this);
        JPanel panelRequisicao = this.novoJPanel(this.tableRequisicoes, "Requisi\u00e7\u00f5es");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.weightx = 1.25;
        cons.weighty = 1.0;
        cons.gridheight = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 1;
        panelCentral.add((Component)panelRequisicao, cons);
        this.tableExamesLido.setDefaultRenderer(Object.class, this);
        this.tableExamesLido.addFocusListener(this);
        this.tableExamesLido.addKeyListener(this);
        JPanel panelExamesLidos = this.novoJPanel(this.tableExamesLido, "Exames Lidos");
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 1.4;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 1;
        cons.gridy = 1;
        panelCentral.add((Component)panelExamesLidos, cons);
        this.tableExames.setDefaultRenderer(Object.class, this);
        this.tableExames.addFocusListener(this);
        this.tableExames.addKeyListener(this);
        JPanel panelOutrosExames = this.novoJPanel(this.tableExames, "Exames da Requisi\u00e7\u00e3o");
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 1.4;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 1;
        cons.gridy = 2;
        panelCentral.add((Component)panelOutrosExames, cons);
        aux = new JPanel();
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 1.35;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 2;
        cons.gridy = 1;
        cons.gridheight = 2;
        panelCentral.add((Component)aux, cons);
        aux.setLayout(new GridBagLayout());
        JPanel panelTubos = new JPanel();
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        aux.add((Component)panelTubos, cons);
        panelTubos.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 0.5;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        this.tableColeta.setRowSelectionAllowed(false);
        this.tableColeta.setDefaultRenderer(Object.class, this);
        panelTubos.add((Component)this.novoJPanel(this.tableColeta, "Etiquetas Coleta"), cons);
        cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.weightx = 0.5;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 1;
        cons.gridx = 1;
        cons.gridy = 0;
        this.tableTriagem.setRowSelectionAllowed(false);
        this.tableTriagem.setDefaultRenderer(Object.class, this);
        panelTubos.add((Component)this.novoJPanel(this.tableTriagem, "Etiquetas Triagem"), cons);
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 0, 0);
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 1;
        aux.add((Component)this.panelInstrucoes, cons);
        this.panelInstrucoes.add((Component)this.scrollInstrucoes, "Center");
        this.textInstrucoes.setEditable(false);
        this.textInstrucoes.setLineWrap(true);
        this.textInstrucoes.setWrapStyleWord(true);
        JPanel panelPesquisa = new JPanel();
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 0, 0);
        cons.weightx = 1.0;
        cons.gridwidth = 3;
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        panelCentral.add((Component)panelPesquisa, cons);
        panelPesquisa.setLayout(new BorderLayout(0, 0));
        aux = new JPanel(new FlowLayout(0, 1, 1));
        panelPesquisa.add(aux);
        JLabel label = ComponenteFactory.novoJLabel("Tubo:", new Dimension(50, 20));
        aux.add(label);
        aux.add(this.textTubo);
        label.setLabelFor(this.textTubo);
        label.setDisplayedMnemonic('T');
        this.textTubo.addKeyListener(this);
        this.textTubo.setPreferredSize(new Dimension(120, 20));
        cons = new GridBagConstraints();
        cons.gridwidth = 3;
        cons.weightx = 1.0;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 3;
        this.panelCores = new JPanel(new FlowLayout(0, 0, 0));
        panelCentral.add((Component)this.panelCores, cons);
        this.panelCores.add(this.legendaLido);
        this.panelCores.add(this.legendaTriado);
        this.panelCores.add(this.legendaUrgente);
        this.panelCores.add(this.legendaNaoColetado);
        this.checkEtiquetaAutomatica.setSelected(this.checkEtiquetaAutomatica.isVisible() && StringUtil.getBoolean(ParametrosUsuarios.getValor(ETIQUETA_AUTOMATICA)));
        this.checkMapaAutomatico.setSelected(this.checkMapaAutomatico.isVisible() && StringUtil.getBoolean(ParametrosUsuarios.getValor(MAPA_AUTOMATICO)));
        this.itemImprimirMapaSelecionado.setSelected(this.itemImprimirMapaSelecionado.isVisible() && StringUtil.getBoolean(ParametrosUsuarios.getValor(MAPA_APENAS_SELECIONADO)));
        this.itemObservacaoExame.setVisible(false);
        this.itemImprimirMapaSelecionado.addActionListener(this);
        this.itemImprimirMapaSelecionado.setVisible(this.checkMapaAutomatico.isVisible() && this.checkMapaAutomatico.isSelected());
        this.menuOpcoes.add(this.itemImprimirMapaSelecionado);
        this.panelInstrucoes.setVisible(!Boolean.parseBoolean(ParametrosUsuarios.getValor(OCULTAR_INSTRUCOES)));
        this.panelCores.setVisible(!Boolean.parseBoolean(ParametrosUsuarios.getValor(OCULTAR_LEGENDA)));
        modeloExaLido.setTamanhoColunas(this.tableExamesLido, 60, 30, 0, 20);
        modeloExa.setTamanhoColunas(this.tableExames, 60, 30, 0, 20);
        this.modeloReq.setTamanhoColunas(this.tableRequisicoes, 20, 55, 0);
        this.alterarTextoOcultar();
        this.habilitarDesabilitarEstado(false);
        this.redimensionarColunas();
        this.redimensionarLinhas(32);
        this.buttonNovo.doClick();
    }

    private void alterarTextoOcultar() {
        if (Boolean.parseBoolean(ParametrosUsuarios.getValor(OCULTAR_INSTRUCOES))) {
            this.itemOcultarInstrucoes.setText("Mostrar instru\u00e7\u00f5es");
        } else {
            this.itemOcultarInstrucoes.setText("Ocultar instru\u00e7\u00f5es");
        }
        if (Boolean.parseBoolean(ParametrosUsuarios.getValor(OCULTAR_LEGENDA))) {
            this.itemOcultarLegenda.setText("Mostrar legenda");
        } else {
            this.itemOcultarLegenda.setText("Ocultar legenda");
        }
    }

    private JPanel novoJPanel(JTable tabela, String titulo) {
        JPanel panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder(titulo));
        panel.add((Component)new JScrollPane(tabela), "Center");
        return panel;
    }

    private void redimensionarColunas() {
        this.tableRequisicoes.getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableRequisicoes.getColumnModel().getColumn(1).setMaxWidth(45);
        this.tableRequisicoes.getColumnModel().getColumn(1).setMinWidth(45);
        this.tableExamesLido.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableExamesLido.getColumnModel().getColumn(1).setMaxWidth(30);
        this.tableExamesLido.getColumnModel().getColumn(3).setMaxWidth(20);
        this.tableExames.getColumnModel().getColumn(0).setMaxWidth(45);
        this.tableExames.getColumnModel().getColumn(1).setMaxWidth(30);
        this.tableExames.getColumnModel().getColumn(3).setMaxWidth(20);
        this.tableColeta.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tableColeta.getColumnModel().getColumn(0).setMinWidth(30);
        this.tableTriagem.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tableTriagem.getColumnModel().getColumn(0).setMinWidth(30);
    }

    private void redimensionarLinhas(int size) {
        this.tableRequisicoes.setRowHeight(size);
        this.tableColeta.setRowHeight(size);
        this.tableTriagem.setRowHeight(size);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void atualizarDadosEtqTriagem(Statement st, String filial, String requisicao, String exame, String material, String tubo, String usuario, boolean imprimir) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicaorecipiente ");
        sql.append("    set usr_codtriagem = '").append(usuario).append("' ");
        sql.append("       ,err_datatriagem =  '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("' ");
        sql.append("  where fil_codigo = ").append(filial);
        sql.append("    and req_codigo IN (").append(requisicao).append(")");
        sql.append("    and exa_codigo = '").append(exame).append("' ");
        sql.append("    and mco_codigo = ").append(material);
        sql.append("    and rec_codigo = ").append(tubo);
        Conexao.executeUpdate(filial, st, sql);
        sql.setLength(0);
        sql.append(" update examerequisicao ");
        sql.append("    set usr_codtriagem = '").append(usuario).append("' ");
        sql.append("       ,exr_datatriagem =  '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("' ");
        if (imprimir) {
            sql.append("       ,exr_dataetqtriagem =  '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("' ");
            sql.append("       ,usr_codetqtriagem = '").append(usuario).append("' ");
        }
        sql.append("  where fil_codigo = ").append(filial);
        sql.append("    and req_codigo IN (").append(requisicao).append(")");
        sql.append("    and exa_codigo = '").append(exame).append("' ");
        sql.append("    and mco_codigo = ").append(material);
        Conexao.executeUpdate(filial, st, sql);
    }

    public static long getAcessoBotaoSalvar() {
        return Long.parseLong("0300300108");
    }

    static {
        labelRenderer.setOpaque(true);
        labelRenderer.setBorder(bordaSimples);
        modeloExaLido = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat.", "mco_abreviatura", "Descri\u00e7\u00e3o", "exa_descricao", "Sit", "exr_situacao");
        modeloExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat.", "mco_abreviatura", "Descri\u00e7\u00e3o", "exa_descricao", "Sit", "exr_situacao");
        modeloCol = new ModeloResultSet("C\u00f3d", COD_COLETA, "Descri\u00e7\u00e3o", DES_COLETA);
        modeloTri = new ModeloResultSet("C\u00f3d", COD_TRIAGEM, "Descri\u00e7\u00e3o", DES_TRIAGEM);
    }
}

