/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

class RelatorioTriagem
extends FrmRelPadrao {
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "urgenteRequisicao", "gestanteRequisicao", "dumRequisicao", "anomesIdadeRequisicao", "observacaoRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "alturaRequisicao", "pesoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "situacaoExameRequisicao", "dataColetaExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "tempoJejumExameRequisicao", "codigoPaciente", "descricaoMaterialInformadoExameRequisicao", "urgenteExameRequisicao", "dataTriagemExameRequisicao", "tempoDiureseExameRequisicao", "dataMaterialSetorExameRequisicao", "dataEtqColetaExameRequisicao", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "fumantePaciente", "diabeticoPaciente", "dumPaciente", "anomesIdadePaciente", "idadePaciente", "codigoSetor", "descricaoSetor", "codigoExame", "descricaoExame", "codigoAMBExame", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoTubo"});

    RelatorioTriagem() {
    }

    public void imprimirPressionado(String where, JPanel panel, JDialog dialogo, Runnable acaoFechar) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = this.getSql(where);
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("sexoPaciente") || campos[i].equals("sexoExame") ? Tipos.tipoSexo(rs.getString(campos[i])) : (campos[i].equals("situacaoExameRequisicao") ? Tipos.tipoSituacaoExame(rs.getString(campos[i])) : (campos[i].equals("corPaciente") ? Tipos.tipoCor(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("fumantePaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente")) : (campos[i].equalsIgnoreCase("diabeticoPaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente")) : (campos[i].equalsIgnoreCase("urgenteRequisicao") ? (rs.getBoolean("urgenteRequisicao") ? "Sim" : "N\u00e3o") : (campos[i].equalsIgnoreCase("urgenteExameRequisicao") ? (rs.getBoolean("urgenteExameRequisicao") ? "Sim" : "N\u00e3o") : (campos[i].equals("anomesIdadeRequisicao") || campos[i].equals("anomesIdadePaciente") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("tempoDiureseExameRequisicao") ? rs.getString("tempoDiureseExameRequisicao") : rs.getObject(campos[i])))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioTriagem.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(panel);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    if (acaoFechar != null) {
                        gerador.setAcaoFechar(acaoFechar);
                    }
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    panel.revalidate();
                }
            } else {
                Funcoes.mensagem(null, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private StringBuilder getSql(String where) {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao,\t");
        buf.append("a.req_urgente as urgenteRequisicao, ");
        buf.append("a.req_obs as observacaoRequisicao, ");
        buf.append("a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, ");
        buf.append("a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao, ");
        buf.append("a.req_neonato as neonatoRequisicao,  ");
        buf.append("a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("b.exr_situacao as situacaoExameRequisicao,");
        buf.append("b.exr_datamaterial as dataColetaExameRequisicao,\t");
        buf.append("b.exr_motivorecoleta as motivoRecoletaExameRequisicao, ");
        buf.append("b.exr_datatriagem as dataTriagemExameRequisicao, ");
        buf.append("b.exr_dataetqcoleta as dataEtqColetaExameRequisicao, ");
        buf.append("b.exr_tempodiurese as tempoDiureseExameRequisicao, ");
        buf.append("b.exr_datamaterialsetor as dataMaterialSetorExameRequisicao,\t");
        buf.append("b.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExameRequisicao, ");
        buf.append("b.exr_data as dataInsercaoExameRequisicao, b.exr_obs as observacaoExameRequisicao, ");
        buf.append("b.exr_intervalojejum as tempoJejumExameRequisicao, ");
        buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("paciente.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
        buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
        buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
        buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
        buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
        buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
        buf.append("paciente.pac_dum as dumPaciente, ");
        buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame, c.exa_sexo as sexoExame,  ");
        buf.append("c.exa_horaentrada as horaEntradaExame, c.exa_horasaida as horaSaidaExame, ");
        buf.append("c.exa_filtro as textoFiltroExame, c.exa_proibido as proibidoExame, ");
        buf.append("c.exa_idademax as idadeMaximaExame, c.exa_idademin as idadeMinimaExame, ");
        buf.append("c.exa_idademaxtipo as tipoIdadeMaximaExame, c.exa_idademintipo as tipoIdadeMinimaExame, ");
        buf.append("c.exa_proibidoweb as proibidoWebExame, c.exa_qtdeamostras as quantidadeAmostrasExame, ");
        buf.append("d.emc_codigocbhpm as codigoCBHPMExame, ");
        buf.append("d.emc_codigoamb as codigoAMBExame, ");
        buf.append("err.rec_codigo as codigoTubo, ");
        buf.append("setor.set_codigo as codigoSetor, setor.set_descricao as descricaoSetor, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from requisicao a ");
        buf.append("join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append("left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join examerequisicaorecipiente err on b.fil_codigo = err.fil_codigo and b.req_codigo = err.req_codigo and b.exa_codigo = err.exa_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where ").append(where);
        buf.append(" order by setor.set_codigo, a.req_codigo, c.exa_codigo, err.rec_codigo ");
        return buf;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300300106");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0300300107");
    }

    @Override
    public void imprimirPressionado() {
    }
}

