/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.triagem.CheckBoxRenderer;
import jalis.laboratorio.triagem.DialogoExames;
import jalis.laboratorio.triagem.DialogoSetor;
import jalis.laboratorio.triagem.ExameRequisicaoSetor;
import jalis.laboratorio.triagem.LabelLegenda;
import jalis.laboratorio.triagem.ObjetoExame;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.bean.triagem.ExameRequisicaoSetorBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.triagem.ExameRequisicaoSetorService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ReceberMaterial
extends FrmPadrao
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static final String CODIGO_DA_ETIQUETA_INVALIDO = "C\u00f3digo da etiqueta inv\u00e1lido";
    private static final String CODIGO_DA_ETIQUETA_NAO_CADASTRADA = "C\u00f3digo da etiqueta n\u00e3o est\u00e1 cadastrada.";
    JPanel panelCentral = new JPanel(new GridBagLayout());
    JPanel panelTabelas = new JPanel(new BorderLayout());
    JPanel panelRequisicoes = new JPanel(new BorderLayout());
    JPanel panelExames = new JPanel(new BorderLayout());
    JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0, 3, 2));
    JPanel panelBotoesDireita = new JPanel(new FlowLayout(2, 3, 2));
    JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    JButton buttonBuscaSetores = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    JButton buttonBuscaRequisicao = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    JButton buttonBuscaSetor = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    JButton buttonOk = ComponenteFactory.novoJButton(this, false);
    JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir \u25bc", 'I', this);
    JPopupMenu menuImprimir = new JPopupMenu();
    JMenu itemImprimirEtiquetaColeta = ComponenteFactory.novoJMenu(this.menuImprimir, "Etiqueta de coleta", '\u0000');
    JMenu itemImprimirEtiquetaTriagem = ComponenteFactory.novoJMenu(this.menuImprimir, "Etiqueta de triagem", '\u0000');
    JMenu itemImprimirMapa = ComponenteFactory.novoJMenu(this.menuImprimir, "Mapa", '\u0000');
    JMenuItem itemImprimirEtiquetaColetaSelecionado = ComponenteFactory.novoJMenuItem(this.itemImprimirEtiquetaColeta, "Selecionado", (ActionListener)this);
    JMenuItem itemImprimirEtiquetaColetaTodos = ComponenteFactory.novoJMenuItem(this.itemImprimirEtiquetaColeta, "Todos", (ActionListener)this);
    JMenuItem itemImprimirEtiquetaTriagemSelecionado = ComponenteFactory.novoJMenuItem(this.itemImprimirEtiquetaTriagem, "Selecionado", (ActionListener)this);
    JMenuItem itemImprimirEtiquetaTriagemTodos = ComponenteFactory.novoJMenuItem(this.itemImprimirEtiquetaTriagem, "Todos", (ActionListener)this);
    JMenuItem itemImprimirMapaSelecionado = ComponenteFactory.novoJMenuItem(this.itemImprimirMapa, "Selecionado", (ActionListener)this);
    JMenuItem itemImprimirMapaTodos = ComponenteFactory.novoJMenuItem(this.itemImprimirMapa, "Todos", (ActionListener)this);
    TTextField textRequisicaoTubo = new TTextField(12, 1);
    TTextField textSituacao = new TTextField(200, 3);
    JComboBox comboOperacao = new JComboBox<String>(new String[]{"Entrada", "Sa\u00edda"});
    TTextField textSetores = new TTextField();
    TTextField textSetorEntSai = new TTextField(3, 1);
    JLabel labelDescSetor = new JLabel();
    JPanel panelDescSetor = ComponenteFactory.novoJPanelBorderLayout(this.labelDescSetor, null, null, null, null);
    JLabel labelPaciente = new JLabel();
    JPanel panelPaciente = ComponenteFactory.novoJPanelBorderLayout(this.labelPaciente, null, null, null, null);
    JLabel labelSetor = ComponenteFactory.novoJLabel("Setor(es):", 'e', null, this.textSetores);
    JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o", 'R', null, this.textRequisicaoTubo);
    JLabel labelSituacao = ComponenteFactory.novoJLabel("Situa\u00e7\u00e3o", 'a', null, this.textSituacao);
    JLabel labelOperacao = ComponenteFactory.novoJLabel("Opera\u00e7\u00e3o", 'O', null, this.comboOperacao);
    JLabel labelSetorEntSaida = ComponenteFactory.novoJLabel("Setor Entrada/Sa\u00edda:", 't', null, this.textSetorEntSai);
    private Map<String, List<String>> mapExameRequisicao = new HashMap<String, List<String>>();
    private Map<String, List<String>> mapExameRequisicaoGravacao = new HashMap<String, List<String>>();
    private JPanel panelLegenda = new JPanel(new FlowLayout(0));
    private LabelLegenda legendaUrgente = new LabelLegenda(Color.RED, "Urgente");
    ModeloGridTable modeloRequisicao = new ModeloGridTable(new String[]{"Filial", "Requisi\u00e7\u00e3o", "Paciente", "Situa\u00e7\u00e3o", "Opera\u00e7\u00e3o", "Setor"});
    ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Rec"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }
    };
    JTable tableRequisicao = new JTable(this.modeloRequisicao);
    JTable tableExame = new JTable(this.modeloExame);
    private static DescritorCodigoEtiqueta dce = null;
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_PACIENTE = 2;
    private final int COLUNA_SITUACAO = 3;
    private final int COLUNA_OPERACAO = 4;
    private final int COLUNA_SETOR = 5;
    private final int COLUNA_EXAMES = 6;
    private final int COLUNA_CHAVE_CONSULTA = 7;
    private final int COLUNA_TIPO_OPERACAO = 8;
    private final int COLUNA_ETIQUETA = 9;
    private final int COLUNA_URGENTE = 10;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_RECEBIDO = 3;
    private final int COLUNA_URGENTE_EXAME = 4;
    private final int TIPO_ETIQUETA_COLETA = 1;
    private final int TIPO_ETIQUETA_TRIAGEM = 2;
    private boolean acesso_sem_entrada = Acesso.getAcesso(300800001L);
    private int status = 1;
    private boolean requisicaoUrgente = false;
    private ExameRequisicaoSetorService service = new ExameRequisicaoSetorService();

    public ReceberMaterial() {
        this.montaTela();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReceberMaterial.this.novo();
                Funcoes.adicionarCtrlI(ReceberMaterial.this.getTopLevelAncestor(), ReceberMaterial.this.panelCentral, Variaveis.filialPadrao, ReceberMaterial.this.tableRequisicao.getSelectedRow() > -1 ? ReceberMaterial.this.modeloRequisicao.getValueAt(ReceberMaterial.this.tableRequisicao.getSelectedRow(), 1).toString() : "");
            }
        });
    }

    public static long getModuloAcesso() {
        return 300800000L;
    }

    public static long getModuloAcessoAddExameSemResultado() {
        return 300800002L;
    }

    public static long getModuloAcessoNaoAddReqSemTubo() {
        return 300800003L;
    }

    public static boolean getNaoAddReqSemTubo() {
        return Acesso.getAcesso(ReceberMaterial.getModuloAcessoNaoAddReqSemTubo());
    }

    public static boolean getAddExameSemResultado() {
        return Acesso.getAcesso(ReceberMaterial.getModuloAcessoAddExameSemResultado());
    }

    private void config() {
        Dimension d = null;
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentral, "Center");
        this.panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        d = new Dimension(130, 20);
        this.textSetores.setPreferredSize(d);
        this.textSetores.setMaximumSize(d);
        this.textSetores.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textRequisicaoTubo.setPreferredSize(d);
        this.textRequisicaoTubo.setMaximumSize(d);
        this.textRequisicaoTubo.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.buttonBuscaRequisicao.setMinimumSize(d);
        this.buttonBuscaSetores.setMinimumSize(d);
        this.buttonBuscaSetor.setMinimumSize(d);
        d = new Dimension(72, 20);
        this.comboOperacao.setPreferredSize(d);
        this.comboOperacao.setMinimumSize(d);
        this.comboOperacao.setMaximumSize(d);
        this.comboOperacao.setEnabled(false);
        this.textSituacao.setText("");
        d = new Dimension(210, 20);
        this.textSituacao.setPreferredSize(d);
        this.textSituacao.setMinimumSize(d);
        this.textSituacao.setSize(d);
        this.buttonOk.setText("OK");
        d = new Dimension(40, 20);
        this.buttonOk.setMaximumSize(d);
        this.buttonOk.setMinimumSize(d);
        this.buttonOk.setPreferredSize(d);
        this.textSetorEntSai.setText("");
        d = new Dimension(50, 20);
        this.textSetorEntSai.setPreferredSize(d);
        this.textSetorEntSai.setMinimumSize(d);
        this.textSetorEntSai.setMaximumSize(d);
        d = new Dimension(180, 20);
        this.labelDescSetor.setPreferredSize(d);
        this.labelDescSetor.setMinimumSize(d);
        this.panelDescSetor.setBorder(new TitledBorder(""));
        this.panelDescSetor.setPreferredSize(d);
        this.panelDescSetor.setMinimumSize(d);
        this.panelDescSetor.setSize(d);
        d = new Dimension(215, 20);
        this.labelPaciente.setPreferredSize(d);
        this.labelPaciente.setMinimumSize(d);
        this.labelPaciente.setMaximumSize(d);
        this.panelPaciente.setBorder(new TitledBorder(""));
        d = new Dimension(215, 20);
        this.panelPaciente.setPreferredSize(d);
        this.panelPaciente.setMaximumSize(d);
        this.panelPaciente.setMinimumSize(d);
        this.panelPaciente.setSize(d);
        this.panelRequisicoes.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)new JScrollPane(this.tableRequisicao), "Center");
        this.panelExames.setBorder(new TitledBorder("Exames"));
        this.panelExames.add((Component)new JScrollPane(this.tableExame), "Center");
        this.modeloRequisicao.setColumnSize(new int[]{30, 70, 0, 0, 70, 40}, this.tableRequisicao);
        this.tableRequisicao.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel retorno = new JLabel(value != null ? value.toString() : "");
                Color cor = Color.RED;
                if (isSelected) {
                    cor = ScreenUtil.escurecerCor(Color.RED, 40);
                }
                retorno.setFont(table.getFont());
                if (table.getModel().getValueAt(row, 10) != null && table.getModel().getValueAt(row, 10) instanceof Boolean && ((Boolean)table.getModel().getValueAt(row, 10)).booleanValue()) {
                    retorno.setBackground(cor);
                    retorno.setOpaque(true);
                } else if (isSelected) {
                    retorno.setOpaque(isSelected);
                    retorno.setBackground(table.getSelectionBackground());
                }
                return retorno;
            }
        });
        this.modeloExame.setColumnSize(new int[]{70, 45, 0, 40}, this.tableExame);
        this.tableExame.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private ImageIcon imagemCongelado = ImagemUtils.carregaImagemJalis("congelado.gif");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel retorno = new JLabel(value != null ? value.toString() : "");
                retorno.setFont(table.getFont());
                Color cor = Color.RED;
                if (isSelected) {
                    cor = ScreenUtil.escurecerCor(Color.RED, 40);
                }
                if (table.getModel().getValueAt(row, 5) != null && table.getModel().getValueAt(row, 5) instanceof Boolean && ((Boolean)table.getModel().getValueAt(row, 5)).booleanValue()) {
                    retorno.setBackground(cor);
                    retorno.setOpaque(true);
                } else if (isSelected) {
                    retorno.setOpaque(isSelected);
                    retorno.setBackground(table.getSelectionBackground());
                }
                if (column == 1 && table.getModel().getValueAt(row, 6) != null && table.getModel().getValueAt(row, 6) instanceof Boolean && ((Boolean)table.getModel().getValueAt(row, 6)).booleanValue()) {
                    retorno.setHorizontalTextPosition(10);
                    retorno.setIcon(this.imagemCongelado);
                }
                return retorno;
            }
        });
        this.tableExame.getColumnModel().getColumn(3).setCellRenderer(new CheckBoxRenderer());
        this.textSetores.setEditable(false);
        this.textSetores.setToolTipText("<html>Delete - Remove o filtro selecionado<br>F2 - Adiciona um novo filtro</html>");
        this.buttonBuscaRequisicao.setFocusable(false);
        this.buttonBuscaSetores.setFocusable(false);
        this.labelDescSetor.setEnabled(false);
        this.labelPaciente.setEnabled(false);
        this.buttonOk.setEnabled(false);
        this.panelBotoesEsquerda.add(this.buttonImprimir);
        this.panelBotoesEsquerda.add(this.panelLegenda);
        this.panelBotoesDireita.add(this.buttonNovo);
        this.panelBotoesDireita.add(this.buttonSalvar);
        this.panelBotoesDireita.add(this.buttonCancelar);
        this.panelBotoesDireita.add(this.buttonFechar);
    }

    private void montaTela() {
        this.config();
        Funcoes.criaBarraDescricao(this, "Receber material/setor", "Recebimento de materiais enviados para o setor respons\u00e1vel", "triagem/receber_material_setor.jpg");
        this.panelLegenda.add(this.legendaUrgente);
        GridBagConstraints c = new GridBagConstraints();
        Insets i = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = i;
        this.panelCentral.add((Component)this.labelSetor, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.panelCentral.add((Component)this.textSetores, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.anchor = 17;
        this.panelCentral.add((Component)this.buttonBuscaSetores, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.panelCentral.add((Component)this.labelSetorEntSaida, c);
        ++c.gridx;
        c.insets = i;
        this.panelCentral.add((Component)this.textSetorEntSai, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.panelCentral.add((Component)this.buttonBuscaSetor, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.panelDescSetor, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.labelRequisicao, c);
        c.gridx = 6;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.labelOperacao, c);
        c.gridx += 2;
        c.gridwidth = 0;
        this.panelCentral.add((Component)this.labelSituacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.textRequisicaoTubo, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelCentral.add((Component)this.buttonBuscaRequisicao, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.anchor = 17;
        this.panelCentral.add((Component)this.panelPaciente, c);
        c.gridx += 3;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.comboOperacao, c);
        c.gridx += 2;
        c.fill = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelCentral.add((Component)this.textSituacao, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelCentral.add((Component)this.buttonOk, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 11;
        c.fill = 1;
        this.panelCentral.add((Component)this.panelRequisicoes, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 11;
        c.gridheight = 2;
        c.fill = 1;
        this.panelCentral.add((Component)this.panelExames, c);
        c.gridy += 2;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelCentral.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, this.panelBotoesDireita, this.panelBotoesEsquerda), c);
        Funcoes.montaEnter((JComponent)this.panelCentral);
        Funcoes.montaEnter((JComponent)this.panelBotoesDireita);
        this.textRequisicaoTubo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberMaterial.this.buscaRequisicao();
            }
        });
        this.tableRequisicao.getSelectionModel().addListSelectionListener(this);
        this.tableExame.getModel().addTableModelListener(this);
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ReceberMaterial.this.tableRequisicao.getSelectedRow() > -1) {
                    ReceberMaterial.this.modeloExame.clear();
                    ReceberMaterial.this.modeloRequisicao.removeLine(ReceberMaterial.this.tableRequisicao.getSelectedRow());
                    if (ReceberMaterial.this.modeloRequisicao.getRowCount() == 0) {
                        ReceberMaterial.this.habilitarCampos();
                    }
                }
            }
        });
        this.textSetores.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ReceberMaterial.this.textSetores.clear();
                }
            }
        });
        this.textSetorEntSai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberMaterial.this.preencheDescSetor();
            }
        });
        this.tableRequisicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ReceberMaterial.this.tableRequisicao.getSelectedRow() > -1) {
                    ReceberMaterial.this.alteraDescSitucao(ReceberMaterial.this.tableRequisicao.getSelectedRow());
                }
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && ReceberMaterial.this.tableRequisicao.getSelectedRow() > -1) {
                    int row = ReceberMaterial.this.tableRequisicao.getSelectedRow();
                    ReceberMaterial.this.tableRequisicao.setRowSelectionInterval(row, row);
                    e.setKeyCode(35);
                    ReceberMaterial.this.alteraDescSitucao(ReceberMaterial.this.tableRequisicao.getSelectedRow());
                }
            }
        });
    }

    private void alteraDescSitucao(int linha) {
        this.textSituacao.setText((String)this.modeloRequisicao.getValueAt(linha, 3));
        this.textSetorEntSai.setText((String)this.modeloRequisicao.getValueAt(linha, 5));
        this.textRequisicaoTubo.setText((String)this.modeloRequisicao.getValueAt(linha, 1));
        this.labelPaciente.setText((String)this.modeloRequisicao.getValueAt(linha, 2));
        if (this.modeloRequisicao.getValueAt(linha, 9) instanceof DescritorCodigoEtiqueta) {
            dce = (DescritorCodigoEtiqueta)this.modeloRequisicao.getValueAt(linha, 9);
        }
        if (!((String)this.modeloRequisicao.getValueAt(linha, 4)).equalsIgnoreCase(this.comboOperacao.getSelectedItem().toString())) {
            this.comboOperacao.setSelectedIndex(this.comboOperacao.getSelectedIndex() == 0 ? 1 : 0);
        }
        this.buttonOk.setEnabled(true);
        this.comboOperacao.setEnabled(false);
        this.textSetorEntSai.setEnabled(false);
        this.textRequisicaoTubo.setEnabled(false);
        this.buttonBuscaSetor.setEnabled(false);
        this.buttonBuscaRequisicao.setEnabled(false);
        this.buttonBuscaSetores.setEnabled(false);
        ScreenUtil.requisitarFoco(this.textSituacao);
    }

    private void preencheDescSetor() {
        if (this.textSetorEntSai.getText().trim().length() > 0) {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    StringBuilder buf = new StringBuilder("select set_descricao from setores where fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and set_codigo = ");
                    buf.append(this.textSetorEntSai.getText());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.labelDescSetor.setText(rs.getString("set_descricao"));
                    } else {
                        this.labelDescSetor.setText("N\u00e3o cadastrado");
                    }
                    rs.close();
                }
                catch (SQLException sqlex) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do setor.\n" + sqlex.getMessage(), sqlex.getStackTrace());
                }
                Conexao.fecharStatement(st);
            }
        } else {
            this.labelDescSetor.setText("N\u00e3o cadastrado");
        }
    }

    private void buscaSetor() {
        Hashtable resultado = Pesquisas.setor(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textSetorEntSai.setText(resultado.get("set_codigo").toString());
        }
        this.textSetorEntSai.requestFocus();
    }

    private void novo() {
        this.mapExameRequisicaoGravacao.clear();
        this.mapExameRequisicao.clear();
        this.modeloExame.clear();
        this.modeloRequisicao.clear();
        this.setAtributos(ParametrosUsuarios.getValor("ReceberMaterialSetor.filtro"));
        this.textSituacao.setText("");
        this.status = 2;
        this.habilitarCampos();
        ScreenUtil.requisitarFoco(this.textSetorEntSai);
    }

    private String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("setores", this.textSetores.getText()));
        bui.append(StringUtil.getTag("setorEntSai", this.textSetorEntSai.getText()));
        return StringUtil.getTag("filtro", bui.toString());
    }

    private void setAtributos(String atr) {
        String str = StringUtil.getValor(atr, "filtro");
        this.textSetores.setText(StringUtil.getValor(str, "setores"));
        this.textSetorEntSai.setText(StringUtil.getValor(str, "setorEntSai"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        } else if (e.getSource() == this.buttonBuscaRequisicao) {
            this.pesquisaRequisicao();
        } else if (e.getSource() == this.buttonBuscaSetores) {
            this.pesquisaSetor();
        } else if (e.getSource() == this.buttonBuscaSetor) {
            this.buscaSetor();
        } else if (e.getSource() == this.buttonOk) {
            this.confirma();
        } else if (e.getSource() == this.buttonImprimir) {
            this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() + this.buttonImprimir.getHeight());
        } else if (e.getSource() == this.itemImprimirEtiquetaColetaSelecionado) {
            this.imprimirEtiquetaSelecionada(1, this.tableRequisicao.getSelectedRow());
        } else if (e.getSource() == this.itemImprimirEtiquetaTriagemSelecionado) {
            this.imprimirEtiquetaSelecionada(2, this.tableRequisicao.getSelectedRow());
        } else if (e.getSource() == this.itemImprimirEtiquetaColetaTodos) {
            this.imprimirTodasEtiquetas(1);
        } else if (e.getSource() == this.itemImprimirEtiquetaTriagemTodos) {
            this.imprimirTodasEtiquetas(2);
        } else if (e.getSource() == this.itemImprimirMapaTodos) {
            this.imprimirTodosMapas();
        } else if (e.getSource() == this.itemImprimirMapaSelecionado) {
            this.imprimirMapaSelecionado(this.tableRequisicao.getSelectedRow());
        }
    }

    private void imprimirTodasEtiquetas(int tipoEtiqueta) {
        if (this.modeloRequisicao.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
            this.imprimirEtiquetaSelecionada(tipoEtiqueta, i);
        }
    }

    private void imprimirEtiquetaSelecionada(int tipoEtiqueta, int linhaSelecionada) {
        if (linhaSelecionada < 0) {
            Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada.", 2);
            return;
        }
        String filial = this.modeloRequisicao.getValueAt(linhaSelecionada, 0).toString();
        String requisicao = this.modeloRequisicao.getValueAt(linhaSelecionada, 1).toString();
        if (tipoEtiqueta == 1) {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            ArrayList lista = (ArrayList)this.modeloRequisicao.getValueAt(linhaSelecionada, 6);
            for (ObjetoExame o : lista) {
                if (!o.getRecebido()) continue;
                exames.add(o.getCodigo());
                materiais.add(o.getMaterial().getCodigo());
            }
            if (exames.size() > 0) {
                int[] mats = new int[materiais.size()];
                for (int i = 0; i < materiais.size(); ++i) {
                    mats[i] = (Integer)materiais.get(i);
                }
                try {
                    Impressao.imprimirEtiquetaColeta(filial, requisicao, exames.toArray(new String[exames.size()]), mats, true);
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            ArrayList<String> examesComMateriais = new ArrayList<String>();
            ArrayList lista = (ArrayList)this.modeloRequisicao.getValueAt(linhaSelecionada, 6);
            for (ObjetoExame o : lista) {
                if (!o.getRecebido()) continue;
                examesComMateriais.add(o.getCodigo());
                examesComMateriais.add(String.valueOf(o.getMaterial().getCodigo()));
            }
            if (examesComMateriais.size() > 0) {
                try {
                    Impressao.imprimirEtiquetaTriagem(filial, requisicao, examesComMateriais.toArray(new String[examesComMateriais.size()]), Variaveis.login, true, false);
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void imprimirTodosMapas() {
        if (this.modeloRequisicao.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
            this.imprimirMapaSelecionado(i);
        }
    }

    private void imprimirMapaSelecionado(int linhaSelecionada) {
        if (linhaSelecionada < 0) {
            Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada.", 2);
            return;
        }
        String filial = this.modeloRequisicao.getValueAt(linhaSelecionada, 0).toString();
        String requisicao = this.modeloRequisicao.getValueAt(linhaSelecionada, 1).toString();
        try {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            ArrayList lista = (ArrayList)this.modeloRequisicao.getValueAt(linhaSelecionada, 6);
            for (ObjetoExame o : lista) {
                if (!o.getRecebido()) continue;
                exames.add(o.getCodigo());
                materiais.add(o.getMaterial().getCodigo());
            }
            if (exames.size() > 0) {
                String[] listaExames = exames.toArray(new String[exames.size()]);
                int[] listaMateriais = new int[materiais.size()];
                for (int i = 0; i < materiais.size(); ++i) {
                    listaMateriais[i] = (Integer)materiais.get(i);
                }
                Impressao.imprimirMapa(filial, requisicao, listaExames, listaMateriais, false, false, -1);
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberMaterial (633)");
        }
    }

    private void pesquisaSetor() {
        DialogoSetor dlg = DialogoSetor.novaInstancia(this.getTopLevelAncestor());
        if (!Funcoes.textoVazio(this.textSetores.getText())) {
            dlg.setSelecionados(this.textSetores.getText().split(","));
        }
        dlg.setVisible(true);
        if (dlg.getOK()) {
            this.textSetores.clear();
            StringBuilder buf = new StringBuilder();
            for (String s : dlg.getSelecionados()) {
                if (!Funcoes.textoVazio(buf.toString())) {
                    buf.append(", ");
                }
                buf.append(s);
            }
            this.textSetores.setText(buf.toString());
        }
    }

    private void pesquisaRequisicao() {
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, false, false);
        if (resultado != null) {
            this.textRequisicaoTubo.setText(resultado.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaRequisicao() {
        Statement st;
        block16: {
            if (Funcoes.textoVazio(this.textRequisicaoTubo.getText())) {
                return;
            }
            if (ReceberMaterial.getNaoAddReqSemTubo()) {
                DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(this.textRequisicaoTubo.getText());
                if (dce == null) {
                    this.labelPaciente.setText(CODIGO_DA_ETIQUETA_INVALIDO);
                    this.textRequisicaoTubo.setText("");
                    ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
                    return;
                }
                if (!this.contemCadastro(dce)) {
                    this.labelPaciente.setText(CODIGO_DA_ETIQUETA_NAO_CADASTRADA);
                    this.textRequisicaoTubo.setText("");
                    ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
                    return;
                }
            }
            dce = null;
            if (this.textRequisicaoTubo.getText().length() > ParametrosGerais.getDigitosTuboRequisicao()) {
                dce = this.checaEtiqueta(this.textRequisicaoTubo.getText());
                if (dce != null && dce.getRequisicao() != null) {
                    this.textRequisicaoTubo.setText(dce.getRequisicao());
                } else {
                    this.textRequisicaoTubo.clear();
                    ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
                    return;
                }
            }
            this.labelPaciente.setText("");
            st = Conexao.getStatement();
            try {
                boolean agruparMultiguias;
                String[] guias = new String[]{this.textRequisicaoTubo.getText()};
                boolean bl = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dce == null ? Variaveis.filialPadrao : dce.getFilial(), this.textRequisicaoTubo.getText()) ? true : (agruparMultiguias = false);
                if (agruparMultiguias) {
                    Integer[] is = RecepcaoUtil.verificaMultiGuias(st, dce == null ? Variaveis.filialPadrao : dce.getFilial(), this.textRequisicaoTubo.getText(), true);
                    guias = new String[is.length];
                    int pos = 0;
                    for (Integer i : is) {
                        guias[pos++] = String.valueOf(i);
                    }
                }
                StringBuilder bui = new StringBuilder();
                bui.append("select distinct b.pac_nome, coalesce(a.req_urgente, false) as req_urgente from requisicao a ");
                bui.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                bui.append("where a.fil_codigo = ").append(dce == null ? Variaveis.filialPadrao : dce.getFilial());
                bui.append(" and a.req_codigo in (");
                for (int i = 0; i < guias.length; ++i) {
                    if (i > 0) {
                        bui.append(", ");
                    }
                    bui.append(guias[i]);
                }
                bui.append(") ");
                bui.append(" and a.req_excluida = false ");
                bui.append(" limit 1 ");
                ResultSet rs = Conexao.executeQuery(st, bui);
                if (rs.next()) {
                    this.labelPaciente.setText(rs.getString("pac_nome"));
                    this.requisicaoUrgente = rs.getBoolean("req_urgente");
                    this.buttonOk.setEnabled(true);
                    break block16;
                }
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada.", 2);
                this.textRequisicaoTubo.clear();
                ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReceberMaterial");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
        ScreenUtil.requisitarFoco(this.comboOperacao);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            this.modeloExame.clear();
            ArrayList lista = (ArrayList)this.modeloRequisicao.getValueAt(this.tableRequisicao.getSelectedRow(), 6);
            for (ObjetoExame o : lista) {
                if (!ReceberMaterial.getAddExameSemResultado()) {
                    this.modeloExame.addLine(new Object[]{o.getCodigo(), o.getMaterial().getAbreviatura(), o.getDescricao(), o.getRecebido(), o.getCodigo().concat(o.getMaterial().getCodigo() + ""), new Boolean(o.isUrgente()), new Boolean(o.isMaterialCongelado())});
                    continue;
                }
                if (!Funcoes.textoVazio(o.getSituacao())) continue;
                this.modeloExame.addLine(new Object[]{o.getCodigo(), o.getMaterial().getAbreviatura(), o.getDescricao(), o.getRecebido(), o.getCodigo().concat(o.getMaterial().getCodigo() + ""), new Boolean(o.isUrgente()), new Boolean(o.isMaterialCongelado())});
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int linha = e.getFirstRow();
        int coluna = e.getColumn();
        if (coluna != 3) {
            return;
        }
        boolean b = (Boolean)this.modeloExame.getValueAt(linha, 3);
        ((ObjetoExame)((ArrayList)this.modeloRequisicao.getValueAt(this.tableRequisicao.getSelectedRow(), 6)).get(linha)).setRecebido(b);
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.modeloExame.clear();
            this.modeloRequisicao.clear();
            this.status = 1;
            this.habilitarCampos();
            this.buttonNovo.grabFocus();
            this.buttonOk.setEnabled(false);
            this.mapExameRequisicaoGravacao.clear();
            this.mapExameRequisicao.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirma() {
        if (this.textRequisicaoTubo.getText().isEmpty()) {
            this.buttonOk.setEnabled(false);
            return;
        }
        if (this.textSetorEntSai.getText().isEmpty() || this.labelDescSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Campo setor deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textSetorEntSai);
            return;
        }
        Statement st = Conexao.getStatement();
        try {
            int i;
            boolean agruparMultiguias;
            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(dce == null ? Variaveis.filialPadrao : dce.getFilial(), dce != null ? dce.getRequisicao() : this.textRequisicaoTubo.getText(), true);
            if (multiguias != null) {
                for (int i2 = 0; i2 < multiguias.length; ++i2) {
                    if (!this.mapExameRequisicao.containsKey(multiguias[i2].toString())) {
                        this.mapExameRequisicao.put(multiguias[i2].toString(), new ArrayList());
                    }
                    if (this.mapExameRequisicaoGravacao.containsKey(multiguias[i2].toString())) continue;
                    this.mapExameRequisicaoGravacao.put(multiguias[i2].toString(), new ArrayList());
                }
            }
            boolean bl = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dce == null ? Variaveis.filialPadrao : dce.getFilial(), this.textRequisicaoTubo.getText()) ? true : (agruparMultiguias = false);
            if (multiguias != null && multiguias.length > 1 && !agruparMultiguias && Funcoes.mensagem(this, "A requisi\u00e7\u00e3o faz parte de uma multiguia, deseja adicionar os exames da multiguia?", 4) == 1) {
                multiguias = new Integer[]{Integer.parseInt(dce != null ? dce.getRequisicao() : this.textRequisicaoTubo.getText())};
            }
            StringBuilder bui = new StringBuilder();
            bui.append("select distinct a.exa_codigo, a.mco_codigo, b.exa_descricao, a.exr_datamaterialsetor, a.usr_codmaterialsetor, a.req_codigo, a.fil_codigo, a.exr_situacao, ");
            bui.append("coalesce(a.exr_urgente, false) as exr_urgente, coalesce(emc.emc_materialcongelado, false) as emc_materialcongelado ");
            if (!Funcoes.textoVazio(this.textSetores.getText())) {
                bui.append(", c.set_codigo ");
            }
            if (this.comboOperacao.getSelectedIndex() == 1) {
                bui.append(", e.set_codigo as setorEntrada ");
            } else {
                bui.append(", ").append(this.textSetorEntSai.getText()).append("as setorEntrada ");
            }
            if (dce != null) {
                bui.append(", d.rec_codigo ");
            }
            bui.append("from examerequisicao a ");
            bui.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            bui.append("left join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
            if (!Funcoes.textoVazio(this.textSetores.getText())) {
                bui.append("left join examesetor c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
            }
            bui.append("left join examerequisicaorecipiente d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo  and a.req_codigo = d.req_codigo ");
            if (this.comboOperacao.getSelectedIndex() == 1) {
                bui.append("left join examerequisicaosetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo  and a.req_codigo = e.req_codigo ");
            }
            bui.append("where a.fil_codigo = ").append(dce == null ? Variaveis.filialPadrao : dce.getFilial());
            if (multiguias != null && multiguias.length > 1) {
                bui.append(" and a.req_codigo in (");
                for (i = 0; i < multiguias.length; ++i) {
                    if (i > 0) {
                        bui.append(", ");
                    }
                    bui.append(multiguias[i]);
                }
                bui.append(") ");
            } else {
                bui.append(" and a.req_codigo = ").append(this.textRequisicaoTubo.getText());
            }
            if (!Funcoes.textoVazio(this.textSetores.getText())) {
                if (this.comboOperacao.getSelectedIndex() == 1) {
                    if (!Funcoes.textoVazio(this.textSetorEntSai)) {
                        bui.append(" and (e.set_codigo = ").append(this.textSetorEntSai.getText());
                        bui.append("   or e.set_codigo in (").append(this.textSetores.getText()).append(")) and e.ert_operacao = '").append("E").append("' ");
                    }
                } else {
                    bui.append(" and c.set_codigo in (").append(this.textSetores.getText()).append(") ");
                }
            } else if (this.comboOperacao.getSelectedIndex() == 1 && !this.acesso_sem_entrada) {
                bui.append(" and e.set_codigo is not null");
            }
            bui.append(" and a.exr_excluido = false ");
            if (dce != null) {
                if (multiguias != null && multiguias.length > 1) {
                    bui.append(" and d.req_codigo in (");
                    for (i = 0; i < multiguias.length; ++i) {
                        if (i > 0) {
                            bui.append(", ");
                        }
                        bui.append(multiguias[i]);
                    }
                    bui.append(") ");
                } else {
                    bui.append(" and d.req_codigo = ").append(this.textRequisicaoTubo.getText());
                }
                bui.append(" and d.rec_codigo = ").append(dce.getTubo());
                bui.append(" and d.fil_codigo = ").append(dce.getFilial());
            }
            bui.append(" order by a.fil_codigo ");
            bui.append(", exr_urgente desc, a.req_codigo ");
            if (dce != null) {
                bui.append(", d.rec_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, bui);
            ArrayList<ObjetoExame> exames = new ArrayList<ObjetoExame>();
            String codigos = "";
            ArrayList<Object> listaMultiguias = new ArrayList();
            int reqAnterior = -1;
            while (rs.next()) {
                if (!(multiguias == null || multiguias.length <= 1 || agruparMultiguias || reqAnterior != -1 && reqAnterior == rs.getInt("req_codigo"))) {
                    if (reqAnterior > -1) {
                        this.adicionaRequisicao(String.valueOf(reqAnterior), exames, codigos);
                    }
                    exames = new ArrayList();
                    reqAnterior = rs.getInt("req_codigo");
                    codigos = "";
                    listaMultiguias.clear();
                }
                ExameRequisicaoSetor ers = new ExameRequisicaoSetor(dce == null ? Variaveis.filialPadrao : dce.getFilial(), null, rs.getInt("mco_codigo"), rs.getString("req_codigo"), DBUtil.campoNull(rs.getString("setorEntrada")) ? null : Integer.valueOf(Integer.parseInt(rs.getString("setorEntrada"))), rs.getString("exa_codigo"), Variaveis.login, null, null, null);
                ers.verificaOperacao();
                if (this.comboOperacao.getSelectedIndex() == 1 && ers.getOperacao() != null && ers.getOperacao().equalsIgnoreCase("E")) {
                    if (!this.textSetorEntSai.getText().isEmpty() && Integer.parseInt(this.textSetorEntSai.getText()) != ers.getSetor()) {
                        codigos = codigos.concat(ers.getCodigo() + ", ");
                        continue;
                    }
                    this.textSetorEntSai.setText(ers.getSetor() + "");
                    this.preencheDescSetor();
                } else if (this.comboOperacao.getSelectedIndex() == 0 && ers.getOperacao() != null && ers.getOperacao().equalsIgnoreCase("E") || ers.getOperacao() != null && ers.getOperacao().equalsIgnoreCase("S") && this.comboOperacao.getSelectedIndex() == 1 || this.comboOperacao.getSelectedIndex() == 1 && ers.getOperacao() == null && !this.acesso_sem_entrada) continue;
                int pos = this.pesquisaExameAdicionado(rs.getString("exa_codigo"), rs.getInt("mco_codigo"), exames);
                if (pos > -1) {
                    listaMultiguias = exames.get(pos).getMultiguias();
                }
                if (!listaMultiguias.contains(rs.getString("req_codigo"))) {
                    listaMultiguias.add(rs.getString("req_codigo"));
                }
                ObjetoExame e = new ObjetoExame(rs.getString("exa_codigo"), rs.getString("exa_descricao"), ExameUtil.getDadosMaterial(dce == null ? Variaveis.filialPadrao : dce.getFilial(), rs.getInt("mco_codigo")), rs.getString("usr_codmaterialsetor"), rs.getTimestamp("exr_datamaterialsetor"), rs.getString("exr_situacao"), true, listaMultiguias, rs.getBoolean("exr_urgente"), rs.getBoolean("emc_materialcongelado"));
                this.mapExameRequisicao.get(rs.getString("req_codigo")).add(e.getCodigo());
                if (exames.contains(e) || pos >= 0) continue;
                exames.add(e);
                listaMultiguias = new ArrayList();
            }
            this.adicionaRequisicao(reqAnterior > -1 ? String.valueOf(reqAnterior) : this.textRequisicaoTubo.getText(), exames, codigos);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ReceberMaterial");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.buttonOk.setEnabled(false);
        this.textRequisicaoTubo.clear();
        this.labelPaciente.setText("");
        this.textSituacao.setText("");
        this.requisicaoUrgente = false;
        ScreenUtil.requisitarFoco(this.textRequisicaoTubo);
        this.habilitarCampos();
    }

    private boolean temExameSemMaterial(ArrayList<ObjetoExame> exames) {
        boolean retorno = false;
        int i = 0;
        while (!exames.isEmpty() && i < exames.size()) {
            ObjetoExame e = exames.get(i);
            if (e.getSituacao().equalsIgnoreCase("T") || e.getSituacao().equalsIgnoreCase("F")) {
                retorno = true;
                exames.remove(i);
                continue;
            }
            ++i;
        }
        return retorno;
    }

    private void adicionaRequisicao(String requisicaoTubo, ArrayList<ObjetoExame> exames, String outrosExames) {
        boolean semMaterial = this.temExameSemMaterial(exames);
        if (exames.size() > 0) {
            if (semMaterial) {
                Funcoes.mensagem(this, "Alguns exames n\u00e3o ser\u00e3o adicionados pois n\u00e3o foram coletados. Verifique antes de adicionar a requisi\u00e7\u00e3o ao setor.", 2);
            }
            Object[] obj = null;
            int pos = -1;
            if (this.tableRequisicao.getRowCount() > -1 && (pos = this.modeloRequisicao.localizar(7, requisicaoTubo + this.textSetorEntSai.getText() + this.comboOperacao.getSelectedIndex())) == -1) {
                obj = new Object[]{dce == null ? Variaveis.filialPadrao : dce.getFilial(), requisicaoTubo, this.labelPaciente.getText(), this.textSituacao.getText(), this.comboOperacao.getSelectedItem().toString(), this.textSetorEntSai.getText(), exames, requisicaoTubo + this.textSetorEntSai.getText() + this.comboOperacao.getSelectedIndex(), this.comboOperacao.getSelectedIndex(), dce, new Boolean(this.requisicaoUrgente)};
            }
            if (obj != null) {
                this.modeloRequisicao.addLine(obj);
                this.tableRequisicao.setRowSelectionInterval(this.tableRequisicao.getRowCount() - 1, this.tableRequisicao.getRowCount() - 1);
            } else {
                this.tableRequisicao.setValueAt(this.textSituacao.getText(), pos, 3);
                ArrayList ex = null;
                if (pos != -1) {
                    ex = (ArrayList)this.modeloRequisicao.getValueAt(pos, 6);
                    this.tableRequisicao.setRowSelectionInterval(pos, pos);
                    this.tableRequisicao.scrollRectToVisible(this.tableRequisicao.getCellRect(pos, 0, false));
                }
                for (ObjetoExame o : exames) {
                    if (!ReceberMaterial.getAddExameSemResultado()) {
                        this.addLinhaExame(ex, o);
                        continue;
                    }
                    if (!Funcoes.textoVazio(o.getSituacao())) continue;
                    this.addLinhaExame(ex, o);
                }
            }
        } else if (semMaterial) {
            Funcoes.mensagem(this, "Nenhum exame da requisi\u00e7\u00e3o foi coletado. Verifique antes de adicionar a requisi\u00e7\u00e3o ao setor.", 2);
        } else if (outrosExames.trim().length() > 0 && this.comboOperacao.getSelectedIndex() == 1) {
            if (Funcoes.mensagem(this, "Os exames " + (dce != null ? "deste tubo " : " desta requisi\u00e7\u00e3o ") + "se encontram em outro setor.\nDeseja visualizar para efetuar a sa\u00edda?", 4, true) == 0) {
                DialogoExames dlg = DialogoExames.novaInstancia(this.getTopLevelAncestor(), requisicaoTubo, outrosExames, dce == null ? Variaveis.filialPadrao : dce.getFilial());
                dlg.setVisible(true);
                if (dlg.getOK()) {
                    this.textSetorEntSai.setText(dlg.getSelecionado());
                    this.comboOperacao.setSelectedIndex(1);
                    this.confirma();
                    return;
                }
            }
        } else {
            String msg;
            String string = msg = Funcoes.textoVazio(this.textSetores) ? "em nenhum setor." : "nos setores selecionados.";
            if (this.comboOperacao.getSelectedIndex() == 1) {
                Funcoes.mensagem(this, "Os exames " + (dce != null ? "do tubo " : " desta requisi\u00e7\u00e3o ") + "n\u00e3o se encontram " + msg + "\nVerifique se foi efetuada a entrada de material no setor de sa\u00edda.", 2);
            } else if (Funcoes.textoVazio(this.textSetores)) {
                Funcoes.mensagem(this, "Os exames " + (dce != null ? "do tubo " : " desta requisi\u00e7\u00e3o ") + "j\u00e1 se encontram no setor " + this.textSetorEntSai.getText().trim() + ".", 2);
            } else {
                Funcoes.mensagem(this, "Os exames " + (dce != null ? "do tubo " : " desta requisi\u00e7\u00e3o ") + " n\u00e3o foram localizados para o setores selecionados.", 2);
            }
        }
    }

    private void addLinhaExame(ArrayList<ObjetoExame> ex, ObjetoExame o) {
        Object[] objEx = new Object[]{o.getCodigo(), o.getMaterial(), o.getDescricao(), o.getRecebido(), o.getCodigo().concat(o.getMaterial().getCodigo() + ""), this.textSetorEntSai.getText(), this.comboOperacao.getSelectedIndex()};
        if (this.modeloExame.localizar(4, o.getCodigo().concat(o.getMaterial().getCodigo() + "")) == -1) {
            this.modeloExame.addLine(objEx);
            if (ex != null && !ex.contains(o)) {
                ex.add(o);
            }
        }
    }

    private int pesquisaExameAdicionado(String exame, int material, ArrayList<ObjetoExame> exames) {
        int pos = -1;
        for (int i = 0; i < exames.size(); ++i) {
            ObjetoExame e = exames.get(i);
            if (!e.getCodigo().equalsIgnoreCase(exame) || e.getMaterial().getCodigo() != material) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private void habilitarCampos() {
        this.textRequisicaoTubo.setEnabled(this.status == 2);
        this.buttonBuscaRequisicao.setEnabled(this.status == 2);
        this.buttonBuscaSetores.setEnabled(this.status == 2);
        this.comboOperacao.setEnabled(this.status == 2);
        this.textSituacao.setEnabled(this.status == 2);
        this.textSetorEntSai.setEnabled(this.status == 2);
        this.buttonBuscaSetor.setEnabled(this.status == 2);
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonSalvar.setEnabled(this.status == 2);
        this.buttonCancelar.setEnabled(this.status == 2);
    }

    @Override
    public void pressioneiF2() {
        if (this.textRequisicaoTubo.hasFocus()) {
            this.pesquisaRequisicao();
        } else if (this.textSetores.hasFocus()) {
            this.pesquisaSetor();
        } else if (this.textSetorEntSai.hasFocus()) {
            this.buscaSetor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvar() {
        ParametrosUsuarios.setValor("ReceberMaterialSetor.filtro", this.getAtributos());
        Statement st = Conexao.getStatement();
        try {
            for (int i = 0; i < this.tableRequisicao.getRowCount(); ++i) {
                ArrayList exames = (ArrayList)this.modeloRequisicao.getValueAt(i, 6);
                String codigoRequisicao = String.valueOf(this.modeloRequisicao.getValueAt(i, 1).toString());
                for (ObjetoExame o : exames) {
                    if (!o.getRecebido()) continue;
                    ArrayList<String> requisicoes = o.getMultiguias();
                    for (String req : requisicoes) {
                        if (!this.mapExameRequisicao.get(req).contains(o.getCodigo()) || this.mapExameRequisicaoGravacao.get(req).contains(o.getCodigo())) continue;
                        this.gravaExameRequisicaoSetor(Integer.parseInt(this.modeloRequisicao.getValueAt(i, 5).toString()), StringUtil.textoDB(o.getCodigo()), o.getMaterial().getCodigo(), Integer.parseInt(req), this.modeloRequisicao.getValueAt(i, 3).toString(), Integer.parseInt(this.modeloRequisicao.getValueAt(i, 8).toString()) == 0 ? "E" : "S", this.modeloRequisicao.getValueAt(i, 0).toString());
                        this.mapExameRequisicaoGravacao.get(req).add(o.getCodigo());
                    }
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar.\n" + ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.novo();
    }

    private void gravaExameRequisicaoSetor(Integer setor, String codigoExame, int codigoMaterial, Integer requisicao, String situacao, String operacao, String filialExame) throws Exception {
        Date dataHoraCadastro = new Date();
        ExameRequisicaoSetorBean bean = new ExameRequisicaoSetorBean();
        FilialVO filial = new FilialVO();
        ExameVO exame = new ExameVO();
        MaterialColetaVO material = new MaterialColetaVO();
        SetorVO setorEntSai = new SetorVO();
        UsuarioVO usuario = new UsuarioVO();
        filial.setCodigo(Integer.parseInt(filialExame));
        exame.setCodigo(codigoExame);
        material.setCodigo(codigoMaterial);
        setorEntSai.setCodigo(setor);
        usuario.setCodigo(Variaveis.login);
        bean.setFilial(filial);
        bean.setRequisicao(requisicao);
        bean.setExame(exame);
        bean.setMaterial(material);
        bean.setOperacao(operacao);
        bean.setSetor(setorEntSai);
        bean.setSituacaoMaterial(StringUtil.textoDB(situacao));
        bean.setUsuario(usuario);
        bean.setDataHora(dataHoraCadastro);
        this.service.gravaAutoCopiaSemCommit(bean, 0, filial.getCodigo().toString(), filial.getCodigo().toString());
        this.service.atualizaSituacaoMultiguiaRecebimentoMaterialTubo(bean);
    }

    private DescritorCodigoEtiqueta checaEtiqueta(String etiqueta) {
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
        if (dce == null) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida.", 2);
        } else if (!this.contemCadastro(dce)) {
            Funcoes.mensagem(this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada.", 2);
            return null;
        }
        return dce;
    }

    private boolean contemCadastro(DescritorCodigoEtiqueta dce) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                boolean agruparMultiguias;
                String[] guias = null;
                if (dce != null) {
                    guias = new String[]{dce.getRequisicao()};
                }
                boolean bl = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dce == null ? Variaveis.filialPadrao : dce.getFilial(), this.textRequisicaoTubo.getText()) ? true : (agruparMultiguias = false);
                if (agruparMultiguias) {
                    Integer[] is = RecepcaoUtil.verificaMultiGuias(st, dce.getFilial(), dce.getRequisicao(), true);
                    guias = new String[is.length];
                    int pos = 0;
                    for (Integer i : is) {
                        guias[pos++] = String.valueOf(i);
                    }
                }
                StringBuilder bui = new StringBuilder("select a.fil_codigo from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ");
                bui.append(dce.getFilial());
                bui.append(" and a.req_codigo in (");
                for (int i = 0; i < guias.length; ++i) {
                    if (i > 0) {
                        bui.append(", ");
                    }
                    bui.append(guias[i]);
                }
                bui.append(") and a.rec_codigo = ");
                bui.append(dce.getTubo());
                bui.append(" and c.exr_excluido = false ");
                return Conexao.executeQuery(st, bui.toString()).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberMaterial");
            }
        }
        return false;
    }
}

