/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.bean.cadastro.exame.ExameMatColetaBean;
import jalis.model.bean.cadastro.exame.SetorBean;
import jalis.model.bean.recepcao.ExameRequisicaoBean;
import jalis.model.bean.recepcao.ExameRequisicaoLaminasBean;
import jalis.model.dao.cadastro.exame.SetorDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameSetorVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.recepcao.ExameRequisicaoLaminasService;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TTitledBorder;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdentificarLamina
extends FrmCadPadrao
implements ActionListener {
    private static final long ACESSO_ACESSAR = Long.parseLong("0301000000");
    public static final int DIGITOS_ETIQUETA = 4;
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_PACIENTE = 2;
    private final int COLUNA_EXAMES = 3;
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_DESCRICAO_EXAME = 1;
    private final int COLUNA_MATERIAL = 2;
    private final int COLUNA_SITUACAO = 3;
    private final int COLUNA_QUANTIDADE_LAMINAS = 4;
    private final int COLUNA_IDENTIFICACOES = 5;
    private final int COLUNA_OBJETO = 6;
    private final int RETORNO_OK = 0;
    private final int RETORNO_ALGUNS = 1;
    private final int RETORNO_TODOS = 2;
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelTubo = new JLabel("Tubo:");
    private TTextField textTubo = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private JButton buttonImprimirRequisicao = new JButton("Imprimir");
    private JButton buttonImprimirExame = new JButton("Imprimir");
    private JButton buttonImprimirTodasRequisicoes = new JButton("Imprimir Todas");
    private JButton buttonGerarIdentificadorExames = new JButton("Gerar identificador dos exames");
    private JCheckBox checkImprimirAutomaticamente = new JCheckBox("Imprimir automaticamente ap\u00f3s gerar");
    private JPanel panelAdicionar = new JPanel(new GridBagLayout());
    private JPanel panelEsquerda = new JPanel(new GridBagLayout());
    private JPanel panelDireita = new JPanel(new GridBagLayout());
    private JPanel panelRequisicao = new JPanel(new BorderLayout());
    private JPanel panelExame = new JPanel(new BorderLayout());
    private JPanel panelImprimirRequisicao = new JPanel(new FlowLayout(2));
    private JPanel panelImprimirExame = new JPanel(new BorderLayout());
    private JSplitPane split = new JSplitPane(0, this.panelEsquerda, this.panelDireita);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JScrollPane scrollRequisicoes = new JScrollPane();
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Exame", "Material", "Sit.", "C\u00f3pias", "Identifica\u00e7\u00f5es"});
    private JTable tableExames = new JTable(this.modeloExames);
    private JScrollPane scrollExames = new JScrollPane();
    private KeyAdapter keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() == IdentificarLamina.this.textTubo && !Funcoes.textoVazio(IdentificarLamina.this.textTubo) && e.getKeyCode() == 10) {
                String etiqueta = IdentificarLamina.this.textTubo.getText();
                DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
                if (dce == null) {
                    Funcoes.mensagem(IdentificarLamina.this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida.", 2);
                    IdentificarLamina.this.textTubo.selectAll();
                } else {
                    new TuboDao();
                    if (!TuboDao.contemCadastro(dce)) {
                        Funcoes.mensagem(IdentificarLamina.this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada", 1);
                        IdentificarLamina.this.textTubo.selectAll();
                    } else {
                        IdentificarLamina.this.carregarRequisicao(dce.getFilial(), dce.getRequisicao());
                        IdentificarLamina.this.textTubo.clear();
                    }
                }
            }
        }
    };

    public IdentificarLamina() {
        Funcoes.criaBarraDescricao(this, "Identificar l\u00e2mina", "Identifica\u00e7\u00e3o e impress\u00e3o de etiquetas de l\u00e2mina", "triagem/etiqueta_lamina.jpg");
        this.botaoEditar.setVisible(false);
        this.botaoCancelar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.split.setResizeWeight(0.6);
        this.modeloRequisicoes.setColumnSize(new int[]{50, 90, 0}, this.tableRequisicoes);
        this.modeloExames.setColumnSize(new int[]{60, 0, 80, 35, 60, 0}, this.tableExames);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.scrollRequisicoes.setViewportView(this.tableRequisicoes);
        this.scrollExames.setViewportView(this.tableExames);
        this.buttonImprimirRequisicao.addActionListener(this);
        this.buttonImprimirTodasRequisicoes.addActionListener(this);
        this.buttonImprimirExame.addActionListener(this);
        this.buttonGerarIdentificadorExames.addActionListener(this);
        this.textTubo.addKeyListener(this.keyListener);
        this.textTubo.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.textTubo.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.tableRequisicoes.setSelectionMode(0);
        this.modeloRequisicoes.ordenarColuna(1);
        this.modeloRequisicoes.setSentidoOrdenacao(1);
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IdentificarLamina.this.controlaCampos();
                int row = IdentificarLamina.this.tableRequisicoes.getSelectedRow();
                if (row > -1) {
                    IdentificarLamina.this.modeloExames.clear();
                    ArrayList lista = (ArrayList)IdentificarLamina.this.modeloRequisicoes.getValueAt(row, 3);
                    if (lista != null) {
                        for (int i = 0; i < lista.size(); ++i) {
                            ExameRequisicaoBean exame = (ExameRequisicaoBean)lista.get(i);
                            try {
                                ExameMatColetaVO exameMatCol = (ExameMatColetaVO)new ExameMatColetaService().getVO(exame.getFilial().getCodigo().toString(), exame.getExame().getCodigo(), exame.getMaterialColeta().getCodigo().toString());
                                exame.setQuantidadeLaminas(exameMatCol.getQuantidadeLaminas());
                            }
                            catch (Exception e1) {
                                ErrorLogger.mostraMensagem(IdentificarLamina.this, "N\u00e3o foi poss\u00edvel carregar dados do exame.\n" + e1.getMessage(), e1.getStackTrace());
                                return;
                            }
                            IdentificarLamina.this.modeloExames.addLine(new Object[]{exame.getExame().getCodigo(), exame.getExame().getDescricao(), exame.getMaterialColeta().getDescricao(), exame.getSituacao(), exame.getQuantidadeLaminas() == null ? 0 : exame.getQuantidadeLaminas(), exame.getListaIdentificadoresLamina(" - "), exame});
                        }
                    }
                    IdentificarLamina.this.modeloExames.ordenarColunaSemTrocarSentido(IdentificarLamina.this.modeloExames.getColunaOrdenacao());
                } else {
                    IdentificarLamina.this.modeloExames.clear();
                }
            }
        });
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    IdentificarLamina.this.removerRequisicao(IdentificarLamina.this.tableRequisicoes.getSelectedRow());
                }
            }
        });
        this.scrollExames.setPreferredSize(new Dimension(200, 20));
        this.scrollExames.setMinimumSize(new Dimension(200, 20));
        this.tableExames.setSelectionMode(0);
        this.modeloExames.ordenarColuna(0);
        this.modeloExames.setSentidoOrdenacao(1);
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IdentificarLamina.this.controlaCampos();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = c.insets;
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelAdicionar, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(10, insets.left, insets.bottom, insets.right);
        this.painelCentral.add((Component)this.split, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelEsquerda.add((Component)this.panelRequisicao, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelEsquerda.add((Component)this.panelImprimirRequisicao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDireita.add((Component)this.panelExame, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelDireita.add((Component)this.panelImprimirExame, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelTubo.setLabelFor(this.textTubo);
        this.labelTubo.setDisplayedMnemonic('u');
        this.panelAdicionar.add((Component)this.labelTubo, c);
        ++c.gridx;
        this.textTubo.setPreferredSize(new Dimension(150, 20));
        this.textTubo.setMinimumSize(new Dimension(150, 20));
        this.panelAdicionar.add((Component)this.textTubo, c);
        ++c.gridx;
        c.insets = insets;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.panelAdicionar.add((Component)new JLabel(), c);
        this.panelRequisicao.setPreferredSize(new Dimension(350, 20));
        this.panelRequisicao.setMinimumSize(new Dimension(300, 20));
        this.panelRequisicao.setBorder(new TTitledBorder("Requisi\u00e7\u00f5es", 'R', this.painelCentral, this.tableRequisicoes));
        this.panelRequisicao.add((Component)this.scrollRequisicoes, "Center");
        this.panelExame.setBorder(new TTitledBorder("Exames da requisi\u00e7\u00e3o selecionada", 'x', this.painelCentral, this.tableExames));
        this.panelExame.add((Component)this.scrollExames, "Center");
        this.buttonImprimirTodasRequisicoes.setMnemonic('T');
        this.panelImprimirRequisicao.add(this.buttonImprimirTodasRequisicoes);
        this.buttonImprimirRequisicao.setMnemonic('I');
        this.panelImprimirRequisicao.add(this.buttonImprimirRequisicao);
        JPanel panelImprimirExameEsquerda = new JPanel(new FlowLayout(0));
        this.checkImprimirAutomaticamente.setMnemonic('a');
        panelImprimirExameEsquerda.add(this.checkImprimirAutomaticamente);
        JPanel panelImprimirExameDireita = new JPanel(new FlowLayout(2));
        this.buttonGerarIdentificadorExames.setMnemonic('G');
        panelImprimirExameDireita.add(this.buttonGerarIdentificadorExames);
        this.buttonImprimirExame.setMnemonic('m');
        panelImprimirExameDireita.add(this.buttonImprimirExame);
        this.panelImprimirExame.add((Component)panelImprimirExameEsquerda, "West");
        this.panelImprimirExame.add((Component)panelImprimirExameDireita, "East");
        Funcoes.montaEnter((JComponent)this.painelCentral);
        ScreenUtil.requisitarFoco(this.textTubo);
        this.controlaCampos();
    }

    private void removerRequisicao(int row) {
        if (row > -1) {
            this.modeloRequisicoes.removeLine(row);
            this.modeloExames.clear();
        }
    }

    private void gerarEtiqueta(ExameRequisicaoBean exame) {
        ArrayList<ExameSetorVO> setores;
        if (exame != null && (setores = exame.getSetores()) != null) {
            for (int i = 0; i < setores.size(); ++i) {
                SetorVO setorVO;
                ExameSetorVO aux = setores.get(i);
                if (aux == null || (setorVO = aux.getSetor()) == null) continue;
                boolean encontrado = false;
                for (int j = 0; exame.getIdentificadores() != null && j < exame.getIdentificadores().size(); ++j) {
                    if (exame.getIdentificadores().get(j).getSetor().getCodigo().intValue() != setorVO.getCodigo().intValue()) continue;
                    encontrado = true;
                    break;
                }
                if (encontrado) continue;
                SetorBean setorBean = null;
                try {
                    setorBean = (SetorBean)new SetorService().get(setorVO.getFilial().getCodigo().toString(), setorVO.getCodigo().toString());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do setor.\n" + e.getMessage(), e.getStackTrace());
                    return;
                }
                if (setorBean == null || setorBean.getIdentificadorLamina() == null) continue;
                StringBuilder buf = new StringBuilder();
                Integer sequence = null;
                try {
                    sequence = new SetorDao().ultimoValorSequence(setorBean.getIdentificadorLamina().getSequence());
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel requisitar sequ\u00eancia.\n" + e.getMessage(), e.getStackTrace());
                    return;
                }
                buf.append(setorBean.getIdentificadorLamina().getSigla());
                buf.append(Funcoes.preencheZero(sequence, 4));
                buf.append("/");
                buf.append(Funcoes.formataData("yyyy", new Date()).substring(2, 4));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                ExameMatColetaBean exameMatBean = null;
                try {
                    exameMatBean = (ExameMatColetaBean)new ExameMatColetaService().getBean(exame.getFilial().getCodigo().toString(), exame.getExame().getCodigo(), exame.getMaterialColeta().getCodigo().toString());
                }
                catch (Exception e2) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do exame.\n" + e2.getMessage(), e2.getStackTrace());
                    return;
                }
                ExameRequisicaoLaminasBean bean = new ExameRequisicaoLaminasBean();
                bean.setInserir(true);
                bean.setFilial(exame.getFilial());
                bean.setRequisicao(exame.getRequisicao());
                bean.setExame(exame.getExame());
                bean.setMaterial(exame.getMaterialColeta());
                bean.setDataHora(new Date());
                bean.setIdentificador(buf.toString());
                bean.setQuantidadeLaminas(exameMatBean.getQuantidadeLaminas() == null ? 0 : exameMatBean.getQuantidadeLaminas());
                bean.setSetor(setorVO);
                bean.setUsuario(usuario);
                try {
                    new ExameRequisicaoLaminasService().insert(bean, sequence, exame.getFilial().getCodigo().toString(), null);
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar identifica\u00e7\u00e3o de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
                }
                if (exame.getIdentificadores() == null) {
                    ArrayList<ExameRequisicaoLaminasBean> id = new ArrayList<ExameRequisicaoLaminasBean>();
                    id.add(bean);
                    exame.setIdentificadores(id);
                    continue;
                }
                exame.getIdentificadores().add(bean);
            }
        }
    }

    private void controlaCampos() {
        boolean enabledRequisicao = this.tableRequisicoes.getSelectedRow() > -1;
        boolean enabledExames = this.tableExames.getSelectedRow() > -1 && !Funcoes.textoVazio(this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 5).toString());
        boolean enabledTodasRequisicoes = this.tableRequisicoes.getRowCount() > 0;
        int situacao = this.verificaExamesNaoConfiguradosRequisicao(this.tableRequisicoes.getSelectedRow());
        boolean inserindo = this.getStatus() == 2;
        this.textTubo.setEnabled(inserindo);
        this.buttonImprimirExame.setEnabled(enabledExames && inserindo);
        this.buttonImprimirRequisicao.setEnabled(enabledRequisicao && inserindo);
        this.buttonImprimirTodasRequisicoes.setEnabled(enabledTodasRequisicoes && inserindo);
        this.buttonGerarIdentificadorExames.setEnabled(enabledRequisicao && (situacao == 1 || situacao == 2) && inserindo);
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
    }

    @Override
    public void novo() {
        this.setStatus(2);
        this.textTubo.clear();
        this.modeloExames.clear();
        this.modeloRequisicoes.clear();
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textTubo);
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.buttonImprimirRequisicao) {
            int row2 = this.tableRequisicoes.getSelectedRow();
            if (row2 > -1) {
                this.imprimirRequisicao(row2, true);
            }
        } else if (e.getSource() == this.buttonImprimirTodasRequisicoes) {
            this.imprimirTodasRequisicoes();
        } else if (e.getSource() == this.buttonImprimirExame) {
            this.imprimirExame();
        } else if (e.getSource() == this.buttonGerarIdentificadorExames && (row = this.tableRequisicoes.getSelectedRow()) > -1) {
            this.configurarEtiquetaExames((ArrayList)this.modeloRequisicoes.getValueAt(row, 3));
            this.tableRequisicoes.clearSelection();
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void configurarEtiquetaExames(ArrayList<ExameRequisicaoBean> exames) {
        if (exames != null) {
            Collections.sort(exames);
            Integer codigoFilial = null;
            Integer codigoRequisicao = null;
            for (int i = 0; i < exames.size(); ++i) {
                ExameRequisicaoBean exame = exames.get(i);
                codigoFilial = exame.getFilial().getCodigo();
                codigoRequisicao = exame.getRequisicao();
                this.gerarEtiqueta(exame);
            }
            if (this.checkImprimirAutomaticamente.isSelected()) {
                try {
                    Impressao.imprimirEtiquetaLamina(codigoFilial, codigoRequisicao);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir etiquetas de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    private void imprimirExame() {
        int row = this.tableRequisicoes.getSelectedRow();
        int rowExame = this.tableExames.getSelectedRow();
        if (row > -1 && rowExame > -1) {
            ExameRequisicaoBean exame = (ExameRequisicaoBean)this.modeloExames.getValueAt(rowExame, 6);
            if (exame.getIdentificadores() == null) {
                Funcoes.mensagem(this, "Nenhum identificador gerado para o exame \"" + exame.getExame().getDescricao() + "\".", 2);
                return;
            }
            Integer codigoFilial = Integer.parseInt(this.modeloRequisicoes.getValueAt(row, 0).toString());
            Integer codigoRequisicao = Integer.parseInt(this.modeloRequisicoes.getValueAt(row, 1).toString());
            String codigoExame = exame.getExame().getCodigo();
            Integer codigoMaterial = exame.getMaterialColeta().getCodigo();
            try {
                Impressao.imprimirEtiquetaLamina(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir etiquetas de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void imprimirRequisicao(int row, boolean verificarIdentificadores) {
        if (row > -1) {
            Integer filial = Integer.parseInt(this.modeloRequisicoes.getValueAt(row, 0).toString());
            Integer requisicao = Integer.parseInt(this.modeloRequisicoes.getValueAt(row, 1).toString());
            if (verificarIdentificadores) {
                int resp;
                int retorno = this.verificaExamesNaoConfiguradosRequisicao(row);
                if (retorno == 2) {
                    Funcoes.mensagem(this, "Nenhum exame com identificador configurado na requisi\u00e7\u00e3o.", 2);
                    return;
                }
                if (retorno == 1 && (resp = Funcoes.mensagem(this, "H\u00e1 exames sem identificador configurado na requisi\u00e7\u00e3o.\nDeseja imprimir os exames com identificador?", 4)) == 1) {
                    return;
                }
            }
            try {
                Impressao.imprimirEtiquetaLamina(filial, requisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir etiquetas de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private int verificaExamesNaoConfiguradosRequisicao(int row) {
        if (row > -1) {
            boolean todosSem = true;
            boolean algumSem = false;
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(row, 3);
            for (int i = 0; i < exames.size(); ++i) {
                ExameRequisicaoBean aux = (ExameRequisicaoBean)exames.get(i);
                if (aux.getIdentificadores() == null) {
                    algumSem = true;
                    continue;
                }
                todosSem = false;
            }
            if (todosSem) {
                return 2;
            }
            if (algumSem) {
                return 1;
            }
        }
        return 0;
    }

    private void imprimirTodasRequisicoes() {
        int resp;
        int i;
        int retorno = -1;
        for (i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
            int aux = this.verificaExamesNaoConfiguradosRequisicao(i);
            if (retorno == -1) {
                retorno = aux;
                continue;
            }
            if (aux == 1) {
                retorno = 1;
                continue;
            }
            if (aux == 2) {
                if (retorno != 0) continue;
                retorno = 1;
                continue;
            }
            if (aux != 0 || retorno != 2) continue;
            retorno = 1;
        }
        if (retorno == 2) {
            Funcoes.mensagem(this, "Nenhum exame com identificador configurado nas requisi\u00e7\u00f5es.", 2);
            return;
        }
        if (retorno == 1 && (resp = Funcoes.mensagem(this, "H\u00e1 exames sem identificador configurado nas requisi\u00e7\u00f5es.\nDeseja imprimir os exames com identificador?", 4)) == 1) {
            return;
        }
        for (i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
            this.imprimirRequisicao(i, false);
        }
    }

    private void carregarRequisicao(String codigoFilial, String codigoRequisicao) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", codigoFilial);
        chaves.put("req_codigo", codigoRequisicao);
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            String filialAux = this.modeloRequisicoes.getValueAt(i, 0).toString();
            String requisicaoAux = this.modeloRequisicoes.getValueAt(i, 1).toString();
            if (!codigoFilial.equalsIgnoreCase(filialAux) || !codigoRequisicao.equalsIgnoreCase(requisicaoAux)) continue;
            Funcoes.mensagem(this.getTopLevelAncestor(), "A requisi\u00e7\u00e3o j\u00e1 foi inserida.", 5);
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
            return;
        }
        RequisicaoVO requisicao = null;
        try {
            requisicao = (RequisicaoVO)new RequisicaoService().getVO(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (requisicao == null) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o n\u00e3o foi localizada.", 2);
            return;
        }
        ArrayList<ExameRequisicaoBean> exames = null;
        try {
            exames = new ExameRequisicaoService().getBeans(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados dos exames.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (exames == null) {
            Funcoes.mensagem(this, "Nenhum exame configur\u00e1vel localizado para a requisi\u00e7\u00e3o.", 2);
            return;
        }
        this.modeloRequisicoes.addLine(new Object[]{requisicao.getFilial().getCodigo(), requisicao.getCodigo(), requisicao.getPaciente().getNome(), exames});
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            String filialAux = this.modeloRequisicoes.getValueAt(i, 0).toString();
            String requisicaoAux = this.modeloRequisicoes.getValueAt(i, 1).toString();
            if (!codigoFilial.equalsIgnoreCase(filialAux) || !codigoRequisicao.equalsIgnoreCase(requisicaoAux)) continue;
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
        }
    }
}

