/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class DialogoSetor
extends AbstractDialogoOKCancelar {
    private boolean ok = false;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Setor", "Sel"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }
    };
    private JTable table = new JTable(this.modelo);

    public static DialogoSetor novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoSetor((Frame)pai, "Pesquisa de setores");
        }
        if (pai instanceof Dialog) {
            return new DialogoSetor((Dialog)pai, "Pesquisa de setores");
        }
        return null;
    }

    public DialogoSetor(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public DialogoSetor(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)new JScrollPane(this.table), "Center");
        this.setSize(new Dimension(300, 400));
        ScreenUtil.centralizar(this);
        this.modelo.setColumnSize(new int[]{70, 0, 30}, this.table);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && DialogoSetor.this.table.getSelectedRow() > -1) {
                    DialogoSetor.this.modelo.setValueAt((Boolean)DialogoSetor.this.modelo.getValueAt(DialogoSetor.this.table.getSelectedRow(), 2) == false, DialogoSetor.this.table.getSelectedRow(), 2);
                }
            }
        });
        this.buscaSetores();
        ScreenUtil.requisitarFoco(this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaSetores() {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select set_codigo, set_descricao from setores where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" order by set_descricao ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            while (rs.next()) {
                this.modelo.addLine(new Object[]{rs.getInt("set_codigo"), rs.getString("set_descricao"), false});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoSetor (538)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public String[] getSelecionados() {
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!((Boolean)this.modelo.getValueAt(i, 2)).booleanValue()) continue;
            tmp.add(this.modelo.getValueAt(i, 0).toString());
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    public void setSelecionados(String[] selecionados) {
        block0: for (String s : selecionados) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().trim().equalsIgnoreCase(s.trim())) continue;
                this.modelo.setValueAt(true, i, 2);
                continue block0;
            }
        }
    }
}

