/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class DialogoExames
extends AbstractDialogoOKCancelar {
    private String requisicao;
    private String codigos;
    private String filial;
    private String setor;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Filial", "Material", "C\u00f3digo", "Exame", "Setor", "Local"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    };
    private JTable table = new JTable(this.modelo);

    public static DialogoExames novaInstancia(Object pai, String requisicao, String codigos, String filial) {
        if (pai instanceof Frame) {
            return new DialogoExames((Frame)pai, "Exames encontrados em outro setor", requisicao, codigos, filial);
        }
        if (pai instanceof Dialog) {
            return new DialogoExames((Dialog)pai, "Exames encontrados em outro setor", requisicao, codigos, filial);
        }
        return null;
    }

    public DialogoExames(Dialog pai, String titulo, String requisicao, String codigos, String filial) {
        super(pai, titulo);
        this.filial = filial;
        this.requisicao = requisicao;
        this.codigos = codigos;
        this.montaTela();
    }

    public DialogoExames(Frame pai, String titulo, String requisicao, String codigos, String filial) {
        super(pai, titulo);
        this.filial = filial;
        this.requisicao = requisicao;
        this.codigos = codigos;
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)new JScrollPane(this.table), "Center");
        this.setSize(new Dimension(565, 300));
        ScreenUtil.centralizar(this);
        this.modelo.setColumnSize(new int[]{30, 50, 50, 200, 35, 200}, this.table);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 10 && (row = DialogoExames.this.table.getSelectedRow()) > -1) {
                    if (row - 1 == -1) {
                        row = 1;
                    }
                    DialogoExames.this.table.setRowSelectionInterval(row - 1, row - 1);
                }
            }
        });
        this.buscaExames();
        this.table.setRowSelectionInterval(0, 0);
        ScreenUtil.requisitarFoco(this.table);
    }

    public String getSelecionado() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            return this.modelo.getValueAt(row, 4).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaExames() {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select a.fil_codigo as filial, a.exa_codigo as exa_codigo, c.exa_descricao as descExame ,d.mco_descricao as descMaterial,  b.set_codigo as codSetor, b.set_descricao as descSetor ");
            buf.append("from examerequisicaosetor a ");
            buf.append("left join setores  b on a.fil_codigo = b.fil_codigo and a.set_codigo = b.set_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
            if (this.setor != null) {
                buf.append("left join examerequisicaosetor e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.fil_codigo and a.mco_codigo = e.mco_codigo and a.exa_codigo = e.exa_codigo and a.set_codigo = e.set_codigo and e.ert_operacao = '").append("S");
            }
            buf.append("where a.fil_codigo = ").append(this.filial).append(" and a.req_codigo = ").append(this.requisicao).append(" and a.ert_codigo in (").append(this.codigos.substring(0, this.codigos.length() - 2)).append(") ");
            buf.append(" and a.ert_operacao = '").append("E").append("' ");
            if (this.setor != null) {
                buf.append(" and a.set_codigo = ").append(this.setor);
                buf.append(" and (e.ert_codigo is null or e.ert_codigo < a.ert_codigo ) ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            while (rs.next()) {
                this.modelo.addLine(new Object[]{rs.getInt("filial"), rs.getString("descMaterial"), rs.getString("exa_codigo"), rs.getString("descExame"), rs.getInt("codSetor"), rs.getString("descSetor")});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExames");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

