/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem;

import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.triagem.ExamesTuboRender;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.recepcao.ExameRequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TTitledBorder;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConferenciaTubos
extends FrmCadPadrao {
    private static final long ACESSO_ACESSAR = Long.parseLong("0301100000");
    public static final int DIGITOS_ETIQUETA = 4;
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_PACIENTE = 2;
    private final int COLUNA_EXAMES = 3;
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_DESCRICAO_EXAME = 1;
    private final int COLUNA_MATERIAL = 2;
    private final int COLUNA_SITUACAO = 3;
    private final int COLUNA_OBJETO = 4;
    private final int RETORNO_OK = 0;
    private final int RETORNO_ALGUNS = 1;
    private final int RETORNO_TODOS = 2;
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelTubo = new JLabel("Tubo:");
    private TTextField textTubo = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private JPanel panelAdicionar = new JPanel(new GridBagLayout());
    private JPanel panelEsquerda = new JPanel(new GridBagLayout());
    private JPanel panelDireita = new JPanel(new GridBagLayout());
    private JPanel panelRequisicao = new JPanel(new BorderLayout());
    private JPanel panelExame = new JPanel(new BorderLayout());
    private JSplitPane split = new JSplitPane(0, this.panelEsquerda, this.panelDireita);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JScrollPane scrollRequisicoes = new JScrollPane();
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Exame", "Material", "Situa\u00e7\u00e3o"});
    private JTable tableExames = new JTable(this.modeloExames);
    private JScrollPane scrollExames = new JScrollPane();
    private KeyAdapter keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() == ConferenciaTubos.this.textTubo && !Funcoes.textoVazio(ConferenciaTubos.this.textTubo) && e.getKeyCode() == 10) {
                String etiqueta = ConferenciaTubos.this.textTubo.getText();
                DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(etiqueta);
                if (dce == null) {
                    Funcoes.mensagem(ConferenciaTubos.this, "A etiqueta \"" + etiqueta + "\" n\u00e3o \u00e9 v\u00e1lida.", 2);
                    ConferenciaTubos.this.textTubo.selectAll();
                } else {
                    new TuboDao();
                    if (!TuboDao.contemCadastro(dce)) {
                        Funcoes.mensagem(ConferenciaTubos.this, "A etiqueta \"" + etiqueta + "\" n\u00e3o est\u00e1 cadastrada", 1);
                        ConferenciaTubos.this.textTubo.selectAll();
                    } else {
                        ConferenciaTubos.this.carregarRequisicao(dce.getFilial(), dce.getRequisicao(), true, true);
                        ConferenciaTubos.this.textTubo.clear();
                    }
                }
                ScreenUtil.requisitarFoco(ConferenciaTubos.this.textTubo);
            }
        }
    };

    public ConferenciaTubos() {
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de tubos", "Confer\u00eancia da situa\u00e7\u00e3o do resultado dos exames do tubo", "triagem/conferencia_tubo.jpg");
        this.botaoEditar.setVisible(false);
        this.botaoCancelar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.split.setResizeWeight(0.6);
        this.modeloRequisicoes.setColumnSize(new int[]{50, 90, 0}, this.tableRequisicoes);
        this.modeloExames.setColumnSize(new int[]{60, 0, 80, 100}, this.tableExames);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.scrollRequisicoes.setViewportView(this.tableRequisicoes);
        this.scrollExames.setViewportView(this.tableExames);
        this.textTubo.addKeyListener(this.keyListener);
        this.tableRequisicoes.setSelectionMode(0);
        this.modeloRequisicoes.ordenarColuna(1);
        this.modeloRequisicoes.setSentidoOrdenacao(1);
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConferenciaTubos.this.controlaCampos();
                int row = ConferenciaTubos.this.tableRequisicoes.getSelectedRow();
                if (row > -1) {
                    ConferenciaTubos.this.modeloExames.clear();
                    ArrayList lista = (ArrayList)ConferenciaTubos.this.modeloRequisicoes.getValueAt(row, 3);
                    if (lista != null) {
                        for (int i = 0; i < lista.size(); ++i) {
                            ExameRequisicaoBean exame = (ExameRequisicaoBean)lista.get(i);
                            try {
                                ExameMatColetaVO exameMatCol = (ExameMatColetaVO)new ExameMatColetaService().getVO(exame.getFilial().getCodigo().toString(), exame.getExame().getCodigo(), exame.getMaterialColeta().getCodigo().toString());
                                exame.setQuantidadeLaminas(exameMatCol.getQuantidadeLaminas());
                            }
                            catch (Exception e1) {
                                ErrorLogger.mostraMensagem(ConferenciaTubos.this, "N\u00e3o foi poss\u00edvel carregar dados do exame.\n" + e1.getMessage(), e1.getStackTrace());
                                return;
                            }
                            ConferenciaTubos.this.modeloExames.addLine(new Object[]{exame.getExame().getCodigo(), exame.getExame().getDescricao(), exame.getMaterialColeta().getDescricao(), Tipos.tipoSituacaoExame(exame.getSituacao()), exame});
                        }
                    }
                    ConferenciaTubos.this.modeloExames.ordenarColunaSemTrocarSentido(ConferenciaTubos.this.modeloExames.getColunaOrdenacao());
                } else {
                    ConferenciaTubos.this.modeloExames.clear();
                }
            }
        });
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ConferenciaTubos.this.removerRequisicao(ConferenciaTubos.this.tableRequisicoes.getSelectedRow());
                }
            }
        });
        this.scrollExames.setPreferredSize(new Dimension(200, 20));
        this.scrollExames.setMinimumSize(new Dimension(200, 20));
        this.tableExames.setSelectionMode(0);
        this.modeloExames.ordenarColuna(0);
        this.modeloExames.setSentidoOrdenacao(1);
        this.tableExames.setDefaultRenderer(Object.class, new ExamesTuboRender());
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConferenciaTubos.this.controlaCampos();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = c.insets;
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelAdicionar, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(10, insets.left, insets.bottom, insets.right);
        this.painelCentral.add((Component)this.split, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelEsquerda.add((Component)this.panelRequisicao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDireita.add((Component)this.panelExame, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelTubo.setLabelFor(this.textTubo);
        this.labelTubo.setDisplayedMnemonic('u');
        this.labelTubo.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.panelAdicionar.add((Component)this.labelTubo, c);
        ++c.gridx;
        this.textTubo.setPreferredSize(new Dimension(150, 20));
        this.textTubo.setMinimumSize(new Dimension(150, 20));
        this.panelAdicionar.add((Component)this.textTubo, c);
        ++c.gridx;
        c.insets = insets;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.panelAdicionar.add((Component)new JLabel(), c);
        this.panelRequisicao.setPreferredSize(new Dimension(350, 20));
        this.panelRequisicao.setMinimumSize(new Dimension(300, 20));
        TTitledBorder b1 = new TTitledBorder("Requisi\u00e7\u00f5es", 'R', this.painelCentral, this.tableRequisicoes);
        this.panelRequisicao.setBorder(b1);
        this.panelRequisicao.add((Component)this.scrollRequisicoes, "Center");
        TTitledBorder b2 = new TTitledBorder("Exames da requisi\u00e7\u00e3o selecionada", 'x', this.painelCentral, this.tableExames);
        this.panelExame.setBorder(b2);
        this.panelExame.add((Component)this.scrollExames, "Center");
        Funcoes.montaEnter((JComponent)this.painelCentral);
        ScreenUtil.requisitarFoco(this.textTubo);
        this.controlaCampos();
    }

    private void removerRequisicao(int row) {
        if (row > -1) {
            this.modeloRequisicoes.removeLine(row);
            this.modeloExames.clear();
        }
    }

    private void controlaCampos() {
        this.textTubo.setEnabled(this.getStatus() == 2);
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
    }

    @Override
    public void novo() {
        this.textTubo.clear();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textTubo);
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    private void carregarRequisicao(String codigoFilial, String codigoRequisicao, boolean posicionarRequisicaoPrincipal, boolean pesquisarMultiguia) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", codigoFilial);
        chaves.put("req_codigo", codigoRequisicao);
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            String filialAux = this.modeloRequisicoes.getValueAt(i, 0).toString();
            String requisicaoAux = this.modeloRequisicoes.getValueAt(i, 1).toString();
            if (!codigoFilial.equalsIgnoreCase(filialAux) || !codigoRequisicao.equalsIgnoreCase(requisicaoAux) || !posicionarRequisicaoPrincipal) continue;
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
            return;
        }
        RequisicaoVO requisicao = null;
        try {
            requisicao = (RequisicaoVO)new RequisicaoService().getVO(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (requisicao == null) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o n\u00e3o foi localizada.", 2);
            return;
        }
        ArrayList<ExameRequisicaoBean> exames = null;
        try {
            chaves.put("exr_excluido", false);
            exames = new ExameRequisicaoService().getBeans(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados dos exames.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        Integer[] multiguias = null;
        if (pesquisarMultiguia) {
            try {
                multiguias = RecepcaoUtil.verificaMultiGuias(codigoFilial, codigoRequisicao);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as multiguias.\n" + ex.getMessage(), ex.getStackTrace());
                return;
            }
        }
        boolean inserirMultiguias = false;
        if (multiguias != null && multiguias.length > 0) {
            Integer[] mensagem = "";
            Integer[] integerArray = multiguias;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = integerArray[i];
                if (!Funcoes.textoVazio((String)mensagem)) {
                    mensagem = (String)mensagem + ", ";
                }
                mensagem = (String)mensagem + String.valueOf(i2);
            }
            inserirMultiguias = Funcoes.mensagem(this, "A requisi\u00e7\u00e3o possui as seguintes multiguias:\n " + (String)mensagem, 4) == 0;
        }
        this.modeloRequisicoes.addLine(new Object[]{requisicao.getFilial().getCodigo(), requisicao.getCodigo(), requisicao.getPaciente().getNome(), exames});
        if (inserirMultiguias && multiguias != null && multiguias.length > 0) {
            for (Integer i : multiguias) {
                this.carregarRequisicao(codigoFilial, String.valueOf(i), false, false);
            }
        }
        if (posicionarRequisicaoPrincipal) {
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                String filialAux = this.modeloRequisicoes.getValueAt(i, 0).toString();
                String requisicaoAux = this.modeloRequisicoes.getValueAt(i, 1).toString();
                if (!codigoFilial.equalsIgnoreCase(filialAux) || !codigoRequisicao.equalsIgnoreCase(requisicaoAux)) continue;
                this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
            }
        }
    }
}

