/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados.assinaturadigital;

import br.com.thread.pdfbox.cos.COSArray;
import br.com.thread.pdfbox.cos.COSBase;
import br.com.thread.pdfbox.cos.COSDictionary;
import br.com.thread.pdfbox.cos.COSName;
import br.com.thread.pdfbox.io.IOUtils;
import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.pdmodel.PDPage;
import br.com.thread.pdfbox.pdmodel.PDPageContentStream;
import br.com.thread.pdfbox.pdmodel.PDResources;
import br.com.thread.pdfbox.pdmodel.common.COSObjectable;
import br.com.thread.pdfbox.pdmodel.common.PDRectangle;
import br.com.thread.pdfbox.pdmodel.common.PDStream;
import br.com.thread.pdfbox.pdmodel.font.FontMappers;
import br.com.thread.pdfbox.pdmodel.font.FontMapping;
import br.com.thread.pdfbox.pdmodel.font.PDFont;
import br.com.thread.pdfbox.pdmodel.font.PDType0Font;
import br.com.thread.pdfbox.pdmodel.font.PDType1Font;
import br.com.thread.pdfbox.pdmodel.graphics.form.PDFormXObject;
import br.com.thread.pdfbox.pdmodel.graphics.image.PDImageXObject;
import br.com.thread.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import br.com.thread.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import br.com.thread.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import br.com.thread.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import br.com.thread.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import br.com.thread.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import br.com.thread.pdfbox.pdmodel.interactive.form.PDAcroForm;
import br.com.thread.pdfbox.pdmodel.interactive.form.PDSignatureField;
import br.com.thread.pdfbox.util.Matrix;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.assinaturadigital.CMSProcessableInputStream;
import jalis.laboratorio.resultados.assinaturadigital.DadosAssinaturaDigitalDTO;
import jalis.util.Funcoes;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class AssinaturaDigitalPDF
implements SignatureInterface {
    private static final float PROPORCAO_LARGURA_PADRAO_IMAGEM = 0.5f;
    private static final float PROPORCAO_ALTURA_PADRAO_IMAGEM = 0.95f;
    private PrivateKey privateKey;
    private byte[] certificado;
    private Certificate[] certificateChain;
    private DadosAssinaturaDigitalDTO dadosAssinatura;
    private List<URI> fontesInstaladasSO;

    public AssinaturaDigitalPDF(DadosAssinaturaDigitalDTO dadosAssinatura) {
        this.dadosAssinatura = dadosAssinatura;
    }

    private void carregarCertificado(DadosAssinaturaDigitalDTO dadosAssinatura) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        if (this.certificado == null || !Arrays.equals(this.certificado, dadosAssinatura.getCertificado())) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(new ByteArrayInputStream(dadosAssinatura.getCertificado()), dadosAssinatura.getSenhaCertificado().toCharArray());
            Enumeration<String> aliases = keystore.aliases();
            Certificate cert = null;
            while (cert == null && aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.privateKey = (PrivateKey)keystore.getKey(alias, dadosAssinatura.getSenhaCertificado().toCharArray());
                Certificate[] certChain = keystore.getCertificateChain(alias);
                if (certChain == null) continue;
                this.certificateChain = certChain;
                cert = certChain[0];
                if (!(cert instanceof X509Certificate)) continue;
                this.validarUsoDoCertificado((X509Certificate)cert);
            }
        }
    }

    public void validarUsoDoCertificado(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> extendedKeyUsage;
        boolean[] keyUsage = x509Certificate.getKeyUsage();
        if (keyUsage != null && !keyUsage[0] && !keyUsage[1]) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Certificado Digital n\u00e3o possui assinatura digital", 2);
        }
        if (!((extendedKeyUsage = x509Certificate.getExtendedKeyUsage()) == null || extendedKeyUsage.contains(KeyPurposeId.id_kp_emailProtection.toString()) || extendedKeyUsage.contains(KeyPurposeId.id_kp_codeSigning.toString()) || extendedKeyUsage.contains(KeyPurposeId.anyExtendedKeyUsage.toString()) || extendedKeyUsage.contains("1.2.840.113583.1.1.5") || extendedKeyUsage.contains("1.3.6.1.4.1.311.10.3.12"))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Certificado n\u00e3o possui assinatura de codigo", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] assinarPDF() throws Exception {
        this.carregarCertificado(this.dadosAssinatura);
        PDDocument documentoPDF = PDDocument.load((InputStream)this.dadosAssinatura.getPdfOriginal());
        PDSignature assinatura = this.construirAssinatura(documentoPDF);
        InputStream modeloComAssinatura = this.construirModeloDeDocumentoComAssinatura(documentoPDF);
        ByteArrayOutputStream pdfAssinadoEmBytes = new ByteArrayOutputStream();
        try (SignatureOptions opcoesDaAssinatura = new SignatureOptions();){
            opcoesDaAssinatura.setVisualSignature(modeloComAssinatura);
            opcoesDaAssinatura.setPage(documentoPDF.getNumberOfPages() - 1);
            documentoPDF.addSignature(assinatura, (SignatureInterface)this, opcoesDaAssinatura);
            documentoPDF.saveIncremental((OutputStream)pdfAssinadoEmBytes);
        }
        finally {
            pdfAssinadoEmBytes.close();
            documentoPDF.close();
        }
        return pdfAssinadoEmBytes.toByteArray();
    }

    private PDSignature construirAssinatura(PDDocument doc) throws IOException {
        int permissao = this.lerPermissoesDocumento(doc);
        if (permissao == 1) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Documento n\u00e3o permite altera\u00e7\u00e3o", 2);
        }
        PDSignature signature = new PDSignature();
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm(null);
        if (doc.getVersion() >= 1.5f && permissao == 0) {
            this.definirPermissao(doc, signature, permissao);
        }
        if (acroForm != null && acroForm.getNeedAppearances() && acroForm.getFields().isEmpty()) {
            acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        if (!Funcoes.textoVazio(this.dadosAssinatura.getLocal())) {
            signature.setLocation(this.dadosAssinatura.getLocal());
        }
        if (!Funcoes.textoVazio(this.dadosAssinatura.getRazao())) {
            signature.setReason(this.dadosAssinatura.getRazao());
        }
        signature.setSignDate(Calendar.getInstance());
        return signature;
    }

    private int lerPermissoesDocumento(PDDocument doc) {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base = doc.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (base instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject(COSName.REFERENCE)) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            return this.carregarPermissoes(refArray);
        }
        return 0;
    }

    private int carregarPermissoes(COSArray refArray) {
        COSBase baseTmp = null;
        for (int i = 0; i < refArray.size(); ++i) {
            COSDictionary sigRefDict;
            baseTmp = refArray.getObject(i);
            if (!(baseTmp instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)baseTmp).getDictionaryObject(COSName.TRANSFORM_METHOD)) || !((baseTmp = sigRefDict.getDictionaryObject(COSName.TRANSFORM_PARAMS)) instanceof COSDictionary)) continue;
            return this.validarPermissoes((COSDictionary)baseTmp);
        }
        return 0;
    }

    private int validarPermissoes(COSDictionary transformDict) {
        int permissoes = transformDict.getInt(COSName.P, 2);
        if (permissoes < 1 || permissoes > 3) {
            permissoes = 2;
        }
        return permissoes;
    }

    private void definirPermissao(PDDocument doc, PDSignature signature, int accessPermissions) throws IOException {
        for (PDSignature sig : doc.getSignatureDictionaries()) {
            if (COSName.DOC_TIME_STAMP.equals((Object)sig.getCOSObject().getItem(COSName.TYPE)) || !sig.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            throw new IOException("DocMDP transform method not allowed if an approval signature exists");
        }
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.TRANSFORM_PARAMS);
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.SIG_REF);
        referenceDict.setItem(COSName.TRANSFORM_METHOD, (COSBase)COSName.DOCMDP);
        referenceDict.setItem(COSName.DIGEST_METHOD, (COSBase)COSName.getPDFName((String)"SHA1"));
        referenceDict.setItem(COSName.TRANSFORM_PARAMS, (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem(COSName.REFERENCE, (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            X509Certificate cert = (X509Certificate)this.certificateChain[0];
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha1Signer, cert));
            gen.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificateChain)));
            CMSProcessableInputStream msg = new CMSProcessableInputStream(content);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg, false);
            return signedData.getEncoded();
        }
        catch (GeneralSecurityException | CMSException | OperatorCreationException e) {
            throw new IOException(e);
        }
    }

    private InputStream construirModeloDeDocumentoComAssinatura(PDDocument documentoPDF) throws IOException {
        int paginaParaImprimirAssinatura = documentoPDF.getNumberOfPages() - 1;
        PDDocument documentoPDFEmBranco = new PDDocument();
        PDPage ultimaPaginaDoPDF = new PDPage(documentoPDF.getPage(paginaParaImprimirAssinatura).getMediaBox());
        documentoPDFEmBranco.addPage(ultimaPaginaDoPDF);
        PDAcroForm acroForm = new PDAcroForm(documentoPDFEmBranco);
        documentoPDFEmBranco.getDocumentCatalog().setAcroForm(acroForm);
        PDSignatureField signatureField = new PDSignatureField(acroForm);
        PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
        List acroFormFields = acroForm.getFields();
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        acroForm.getCOSObject().setDirect(true);
        acroFormFields.add(signatureField);
        PDRectangle retanguloImpressaoAssinatura = this.construirRetanguloAssinatura(ultimaPaginaDoPDF, documentoPDF.getSignatureDictionaries().size());
        widget.setRectangle(retanguloImpressaoAssinatura);
        PDFormXObject formaPDFEmBranco = new PDFormXObject(new PDStream(documentoPDFEmBranco));
        formaPDFEmBranco.setResources(new PDResources());
        formaPDFEmBranco.setFormType(1);
        PDRectangle bbox = new PDRectangle(retanguloImpressaoAssinatura.getWidth(), retanguloImpressaoAssinatura.getHeight());
        formaPDFEmBranco.setBBox(bbox);
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(formaPDFEmBranco.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        widget.setAppearance(appearance);
        try (PDPageContentStream cs = new PDPageContentStream(documentoPDFEmBranco, appearanceStream);){
            float proporcaoLarguraImagem = 0.0f;
            float proporcaoAlturaImagem = 0.0f;
            if (this.dadosAssinatura.getImagem() != null) {
                proporcaoLarguraImagem = this.calcularProporcaoLarguraImagem();
                proporcaoAlturaImagem = this.calcularProporcaoAlturaImagem();
                this.inserirImagemNaAssinaturaDigital(documentoPDFEmBranco, retanguloImpressaoAssinatura, cs, proporcaoLarguraImagem, proporcaoAlturaImagem);
            }
            this.escreverMensagemNaAssinaturaDigital(documentoPDFEmBranco, retanguloImpressaoAssinatura, cs, proporcaoLarguraImagem);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        documentoPDFEmBranco.save((OutputStream)baos);
        documentoPDFEmBranco.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private float calcularProporcaoLarguraImagem() {
        float proporcaoLargura = this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraImagem() > 0 ? this.dadosAssinatura.getDimensoesAssinaturaDigital().getProporcaoLarguraImagem() : 0.5f;
        return this.dadosAssinatura.getDimensoesAssinaturaDigital().isEstenderImagem() ? 1.0f : proporcaoLargura;
    }

    private float calcularProporcaoAlturaImagem() {
        float proporcaoAltura = this.dadosAssinatura.getDimensoesAssinaturaDigital().getAlturaImagem() > 0 ? (float)this.dadosAssinatura.getDimensoesAssinaturaDigital().getAlturaImagem() / (float)this.dadosAssinatura.getAlturaAssinatura() : 0.95f;
        return this.dadosAssinatura.getDimensoesAssinaturaDigital().isEstenderImagem() ? 1.0f : proporcaoAltura;
    }

    private void inserirImagemNaAssinaturaDigital(PDDocument documentoPDFEmBranco, PDRectangle retanguloImpressaoAssinatura, PDPageContentStream cs, float proporcaoLargura, float proporcaoAltura) throws IOException {
        Matrix dimensaoImagem = Matrix.getScaleInstance((float)proporcaoLargura, (float)proporcaoAltura);
        cs.saveGraphicsState();
        cs.transform(dimensaoImagem);
        PDImageXObject imagem = PDImageXObject.createFromByteArray((PDDocument)documentoPDFEmBranco, (byte[])IOUtils.toByteArray((InputStream)this.dadosAssinatura.getImagem()), (String)"");
        float posicaoImagem = this.posicaoBase() ? 0.0f : (float)this.dadosAssinatura.getAlturaAssinatura() - retanguloImpressaoAssinatura.getHeight() * proporcaoAltura + 1.0f;
        cs.drawImage(imagem, 0.0f, posicaoImagem, retanguloImpressaoAssinatura.getWidth(), retanguloImpressaoAssinatura.getHeight() * proporcaoAltura);
        cs.restoreGraphicsState();
    }

    private void escreverMensagemNaAssinaturaDigital(PDDocument documentoPDFEmBranco, PDRectangle retanguloImpressaoAssinatura, PDPageContentStream cs, float proporcaoLarguraImagem) throws IOException {
        PDFont fonte = this.carregarFonte(documentoPDFEmBranco);
        float tamanhoFonte = Funcoes.textoVazio(this.dadosAssinatura.getDimensoesAssinaturaDigital().getNomeFonte()) ? this.getProporcaoFonteItext() : (float)this.dadosAssinatura.getDimensoesAssinaturaDigital().getFonte().getSize();
        float alturaTexto = fonte.getFontDescriptor().getFontBoundingBox().getHeight() * tamanhoFonte;
        float larguraImpressaoEscrita = this.calcularLarguraImpressaoEscrita(retanguloImpressaoAssinatura.getWidth());
        List<String> linhasAssinaturaEscrita = this.formatarEscritaAssinatura(larguraImpressaoEscrita, fonte, tamanhoFonte);
        cs.beginText();
        cs.setFont(fonte, tamanhoFonte);
        cs.setNonStrokingColor(Color.BLACK);
        float esquerda = 0.0f;
        if (this.dadosAssinatura.getImagem() != null) {
            esquerda = retanguloImpressaoAssinatura.getWidth() * proporcaoLarguraImagem;
        }
        if (this.posicaoTopo() || this.posicaoAbsoluta()) {
            for (int linha = 0; linha < linhasAssinaturaEscrita.size(); ++linha) {
                float posicao = this.calcularPosicaoDaEscritaPeloTopo(alturaTexto, linha + 1);
                cs.setTextMatrix(Matrix.getTranslateInstance((float)esquerda, (float)posicao));
                cs.showText(linhasAssinaturaEscrita.get(linha));
            }
        }
        if (this.posicaoBase()) {
            float alturaTotalEscrita = (float)linhasAssinaturaEscrita.size() * alturaTexto;
            float espacoEmBranco = (float)this.dadosAssinatura.getAlturaAssinatura() - alturaTotalEscrita / 1000.0f;
            for (int linha = 0; linha < linhasAssinaturaEscrita.size(); ++linha) {
                float posicao = this.calcularPosicaoDaEscritaPelaBase(alturaTexto, linha + 1, espacoEmBranco);
                cs.setTextMatrix(Matrix.getTranslateInstance((float)esquerda, (float)posicao));
                cs.showText(linhasAssinaturaEscrita.get(linha));
            }
        }
        cs.endText();
    }

    private float calcularPosicaoDaEscritaPelaBase(float alturaTexto, int linha, float espacoEmBranco) {
        return (float)this.dadosAssinatura.getAlturaAssinatura() - espacoEmBranco - alturaTexto / 1000.0f * (float)linha;
    }

    private float calcularPosicaoDaEscritaPeloTopo(float alturaTexto, int linha) {
        return (float)this.dadosAssinatura.getAlturaAssinatura() - alturaTexto / 1000.0f * (float)linha;
    }

    private PDRectangle construirRetanguloAssinatura(PDPage ultimaPaginaDoPdf, int assinaturasExistentes) {
        int largura = this.getLarguraPadraoItext();
        if (this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraAssinatura() > 0) {
            largura = this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraAssinatura();
        }
        float margemInferior = this.calcularMargemInferior();
        float llx = 0.0f;
        float lly = 0.0f;
        float ury = 0.0f;
        float urx = 0.0f;
        if (this.alinhaEsquerda()) {
            llx = (float)this.dadosAssinatura.getMargemEsquerda() + this.dadosAssinatura.getMargemAssinatura() + 1.0f;
            lly = margemInferior;
            urx = (float)this.dadosAssinatura.getMargemEsquerda() + this.dadosAssinatura.getMargemAssinatura() + (float)largura;
            ury = margemInferior + (float)this.dadosAssinatura.getAlturaAssinatura();
        } else if (this.alinhaCentro()) {
            int larguraPagina = (int)ultimaPaginaDoPdf.getCropBox().getWidth();
            int margemAux = (larguraPagina - largura) / 2;
            if (assinaturasExistentes > 0) {
                margemAux += largura * assinaturasExistentes + 4;
            }
            llx = margemAux;
            lly = margemInferior;
            urx = margemAux + largura;
            ury = margemInferior + (float)this.dadosAssinatura.getAlturaAssinatura();
        } else {
            PDRectangle medidaPagina = ultimaPaginaDoPdf.getMediaBox();
            llx = medidaPagina.getUpperRightX() - ((float)this.dadosAssinatura.getMargemDireita() + this.dadosAssinatura.getMargemAssinatura() + (float)largura);
            lly = margemInferior;
            urx = medidaPagina.getUpperRightX() - ((float)this.dadosAssinatura.getMargemDireita() + this.dadosAssinatura.getMargemAssinatura());
            ury = margemInferior + (float)this.dadosAssinatura.getAlturaAssinatura();
        }
        PDRectangle rect = new PDRectangle();
        rect.setLowerLeftX(llx);
        rect.setLowerLeftY(lly);
        rect.setUpperRightX(urx);
        rect.setUpperRightY(ury);
        return rect;
    }

    private int getLarguraPadraoItext() {
        int largura = 100 * this.dadosAssinatura.getAlturaAssinatura() / 70;
        largura = 190 * largura / 100;
        return largura;
    }

    private float calcularMargemInferior() {
        int margemInferior = this.dadosAssinatura.getMargemInferior();
        if (this.tipoExterno()) {
            margemInferior += this.dadosAssinatura.getAlturaRodape();
        } else if (this.dadosAssinatura.getPosicaoVerticalAssinatura() == 11) {
            margemInferior += this.dadosAssinatura.getAlturaRodape() - this.dadosAssinatura.getAlturaAssinatura() - this.dadosAssinatura.getPosicaoVerticalAbsolutaAssinatura();
        }
        if (this.posicaoTopo() && this.tipoInterno() && this.dadosAssinatura.getAlturaRodape() > this.dadosAssinatura.getAlturaAssinatura()) {
            margemInferior += this.dadosAssinatura.getAlturaRodape() - this.dadosAssinatura.getAlturaAssinatura();
        }
        if (this.posicaoBase() && this.tipoInterno()) {
            ++margemInferior;
        }
        return margemInferior;
    }

    private float calcularLarguraImpressaoEscrita(float larguraRetanguloImpressaoAssDigital) {
        if (this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraAssinatura() > 0) {
            return (float)this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraAssinatura() - (float)this.dadosAssinatura.getDimensoesAssinaturaDigital().getLarguraImagem();
        }
        float larguraImpressao = larguraRetanguloImpressaoAssDigital;
        if (this.dadosAssinatura.getImagem() != null) {
            larguraImpressao = larguraRetanguloImpressaoAssDigital * 0.5f;
        }
        return larguraImpressao;
    }

    private List<String> formatarEscritaAssinatura(float larguraImpressao, PDFont font, float fontSize) throws IOException {
        ArrayList<String> linhasEscritaAssinatura = new ArrayList<String>();
        Map<Integer, String> palavras = this.carregarEscritaAssinatura();
        float larguraPadraoPdfBox = this.dadosAssinatura.getImagem() != null ? larguraImpressao : larguraImpressao * 0.75f;
        float margemSeguranca = (larguraPadraoPdfBox *= 1000.0f) * 0.025f;
        StringBuilder frase = new StringBuilder();
        for (int i = 0; i < palavras.size(); ++i) {
            String palavra = palavras.get(i);
            float larguraPalavra = font.getStringWidth(palavra) * fontSize;
            float larguraFrase = font.getStringWidth(frase.toString()) * fontSize;
            if (larguraFrase + larguraPalavra <= margemSeguranca + larguraPadraoPdfBox) {
                frase.append(palavra + " ");
                continue;
            }
            linhasEscritaAssinatura.add(frase.toString());
            frase.delete(0, frase.length());
            frase.append(palavra + " ");
        }
        if (frase.length() > 0) {
            linhasEscritaAssinatura.add(frase.toString());
        }
        return linhasEscritaAssinatura;
    }

    private Map<Integer, String> carregarEscritaAssinatura() {
        HashMap<Integer, String> palavras = new HashMap<Integer, String>();
        if (!Funcoes.textoVazio(this.dadosAssinatura.getAssinaturaPersonalizada())) {
            this.carregaAssinaturaPersonalizada(palavras);
        } else {
            this.carregarAssinaturaDigital(palavras);
        }
        return palavras;
    }

    private void carregarAssinaturaDigital(Map<Integer, String> palavras) {
        SimpleDateFormat data = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat hora = new SimpleDateFormat("HH:mm:ss");
        palavras.put(0, "Assinado");
        palavras.put(1, "digitalmente");
        palavras.put(2, "por");
        String[] nomeCertificadoSeparado = this.carregarNomeDoCertificadoDigital().split(" ");
        int c = palavras.size();
        for (String nome : nomeCertificadoSeparado) {
            palavras.put(c, nome);
            ++c;
        }
        palavras.put(c, "Data: " + data.format(this.dadosAssinatura.getData()));
        palavras.put(++c, hora.format(this.dadosAssinatura.getData()));
    }

    private void carregaAssinaturaPersonalizada(Map<Integer, String> palavras) {
        for (int i = 0; i < this.dadosAssinatura.getAssinaturaPersonalizada().split("\n").length; ++i) {
            palavras.put(i, this.dadosAssinatura.getAssinaturaPersonalizada().split("\n")[i]);
        }
    }

    private String carregarNomeDoCertificadoDigital() {
        X509Certificate cert = (X509Certificate)this.certificateChain[0];
        X500Name x500Name = new X500Name(cert.getSubjectX500Principal().getName());
        RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
    }

    private float getProporcaoFonteItext() {
        float tamanho = 0.0f;
        if (this.dadosAssinatura.getAlturaAssinatura() <= 40) {
            tamanho = 5.0f;
        } else {
            tamanho = (float)this.dadosAssinatura.getAlturaAssinatura() * 0.1f + 1.0f;
            if (this.dadosAssinatura.getImagem() == null) {
                tamanho += 1.0f;
            }
        }
        return tamanho;
    }

    private PDFont carregarFonte(PDDocument documentoEmBranco) {
        PDType1Font fonte = null;
        String nomeFonte = Funcoes.textoVazio(this.dadosAssinatura.getDimensoesAssinaturaDigital().getNomeFonte()) ? "Arial" : this.dadosAssinatura.getDimensoesAssinaturaDigital().getNomeFonte();
        try {
            FontMapping fonteMapeada = FontMappers.instance().getTrueTypeFont(nomeFonte, null);
            if (fonteMapeada != null && fonteMapeada.getFont() != null) {
                fonte = PDType0Font.load((PDDocument)documentoEmBranco, (InputStream)((TrueTypeFont)fonteMapeada.getFont()).getOriginalData());
            }
            if (fonte != null && !fonteMapeada.isFallback()) {
                return fonte;
            }
            String pathFonte = this.carregarFonteInstaladaSO();
            if (!Funcoes.textoVazio(pathFonte)) {
                if (pathFonte.endsWith("ttf")) {
                    try (TrueTypeFont ttf = new TTFParser().parse(new File(pathFonte));){
                        fonte = PDType0Font.load((PDDocument)new PDDocument(), (TrueTypeFont)ttf, (boolean)false);
                    }
                }
                if (pathFonte.endsWith("otf")) {
                    OpenTypeFont otf = new OTFParser().parse(new File(pathFonte));
                    fonte = PDType0Font.load((PDDocument)documentoEmBranco, (TrueTypeFont)otf, (boolean)false);
                }
            }
            if (fonte == null) {
                fonte = PDType1Font.HELVETICA;
            }
        }
        catch (Exception e) {
            fonte = PDType1Font.HELVETICA;
        }
        return fonte;
    }

    private String carregarFonteInstaladaSO() {
        if (this.fontesInstaladasSO == null) {
            this.fontesInstaladasSO = new FontFileFinder().find();
        }
        String pathFonte = "";
        for (URI f : this.fontesInstaladasSO) {
            if (!f.getPath().toUpperCase().contains(this.dadosAssinatura.getDimensoesAssinaturaDigital().getNomeFonte().toUpperCase())) continue;
            pathFonte = f.getPath();
            break;
        }
        return pathFonte;
    }

    private boolean posicaoAbsoluta() {
        return this.dadosAssinatura.getPosicaoVerticalAssinatura() == 11;
    }

    private boolean posicaoTopo() {
        return this.dadosAssinatura.getPosicaoVerticalAssinatura() == 1;
    }

    private boolean posicaoBase() {
        return this.dadosAssinatura.getPosicaoVerticalAssinatura() == 3;
    }

    private boolean tipoInterno() {
        return this.dadosAssinatura.getTipoAssinaturaRodape() == 0;
    }

    private boolean tipoExterno() {
        return this.dadosAssinatura.getTipoAssinaturaRodape() == 1;
    }

    private boolean alinhaEsquerda() {
        return this.dadosAssinatura.getPosicaoHorizontalAssinatura() == 2;
    }

    private boolean alinhaCentro() {
        return this.dadosAssinatura.getPosicaoHorizontalAssinatura() == 0;
    }
}

