/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.laboratorio.resultados.X509KeySelector;
import jalis.util.Funcoes;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ValidarXMLAssinado {
    private static String TAG_VALIDAR_XML = "Signature";
    private static String CODIFICACAO = "ISO-8859-1";

    public static boolean validaXML(String xmlCertificado, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws Exception {
        if (Funcoes.textoVazio(xmlCertificado) || xmlCertificado.indexOf(TAG_VALIDAR_XML) == -1) {
            return true;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        ByteArrayInputStream is = new ByteArrayInputStream(xmlCertificado.getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)is, CODIFICACAO);
        InputSource io = new InputSource(reader);
        io.setEncoding(CODIFICACAO);
        Document doc = dbf.newDocumentBuilder().parse(io);
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", TAG_VALIDAR_XML);
        if (nl.getLength() == 0) {
            return false;
        }
        DOMValidateContext valContext = new DOMValidateContext(new X509KeySelector(), nl.item(0));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            boolean sv = signature.getSignatureValue().validate(valContext);
            if (!sv) {
                Iterator<Reference> k = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (k.hasNext()) {
                    boolean bl = k.next().validate(valContext);
                    ++j;
                }
            }
            return false;
        }
        return true;
    }
}

