/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.resultados.ThreadImpAutoListener;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Statement;
import javax.swing.event.EventListenerList;

class ThreadImpressaoAutomatica
extends Thread {
    private EventListenerList listenerList = new EventListenerList();
    private boolean executando;
    private boolean automatico;
    private String consulta;

    public ThreadImpressaoAutomatica(String consulta, boolean automatico) {
        super("Impressao automatica - thread");
        this.consulta = consulta;
        this.automatico = automatico;
    }

    public void addThreadImpAutoListener(ThreadImpAutoListener l) {
        this.listenerList.add(ThreadImpAutoListener.class, l);
    }

    public void removeThreadImpAutoListener(ThreadImpAutoListener l) {
        this.listenerList.remove(ThreadImpAutoListener.class, l);
    }

    public void iniciar() {
        this.executando = true;
        this.start();
    }

    public void parar() {
        this.executando = false;
    }

    public void esperar(int segundos) throws Exception {
        int tempoEspera = segundos * 10;
        for (int contador = 0; this.executando && contador < tempoEspera; ++contador) {
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block11: {
            this.fireIniciouExecucao();
            st = null;
            if (this.consulta == null) break block11;
lbl4:
            // 2 sources

            try {
                block4: while (this.executando) {
                    block12: {
                        st = Conexao.getStatement();
                        if (st == null) {
                            this.executando = false;
                        }
                        regs = null;
                        if (st != null) {
                            regs = Registro.getRegistros(st.executeQuery(this.consulta));
                        }
                        Conexao.fecharStatement(new Statement[]{st});
                        if (regs == null) continue;
                        this.fireExecutouConsulta(regs);
                        for (i = 0; i < regs.length && this.executando; ++i) {
                            this.fireProcessouRegistro(regs[i], i);
                            ThreadImpressaoAutomatica.sleep(100L);
                        }
                        this.fireProcessouTodos();
                        if (!this.automatico) {
                            this.executando = false;
                            continue;
                        }
                        tempo = 0;
                        if (!Funcoes.isNumeric(ParametrosLocais.getParametro("tempoPesquisaMapas")) || (tempo = Integer.parseInt(ParametrosLocais.getParametro("tempoPesquisaMapas"))) < 0) break block12;
                        contador = 0;
                        if (tempo == 0) {
                            tempo = 3;
                        }
                        while (contador < tempo) {
                            ThreadImpressaoAutomatica.sleep(1000L);
                            if (!this.executando) continue block4;
                            ++contador;
                        }
                        ** GOTO lbl4
                    }
                    ThreadImpressaoAutomatica.sleep(3000L);
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage() + " SQL: " + this.consulta, e.getStackTrace(), "ThreadImpressaoAutomatica: 105");
                }
                catch (Throwable var5_6) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var5_6;
                }
                Conexao.fecharStatement(new Statement[]{st});
            }
            Conexao.fecharStatement(new Statement[]{st});
        }
        this.fireTerminouExecucao();
    }

    private void fireIniciouExecucao() {
        for (ThreadImpAutoListener ouvinte : (ThreadImpAutoListener[])this.listenerList.getListeners(ThreadImpAutoListener.class)) {
            ouvinte.iniciouExecucao();
        }
    }

    private void fireExecutouConsulta(Registro[] registros) {
        for (ThreadImpAutoListener ouvinte : (ThreadImpAutoListener[])this.listenerList.getListeners(ThreadImpAutoListener.class)) {
            ouvinte.executouConsulta(registros);
        }
    }

    private void fireProcessouRegistro(Registro reg, int posicao) throws Exception {
        for (ThreadImpAutoListener ouvinte : (ThreadImpAutoListener[])this.listenerList.getListeners(ThreadImpAutoListener.class)) {
            ouvinte.processouRegistro(reg, posicao);
        }
    }

    private void fireProcessouTodos() {
        for (ThreadImpAutoListener ouvinte : (ThreadImpAutoListener[])this.listenerList.getListeners(ThreadImpAutoListener.class)) {
            ouvinte.processouTodos();
        }
    }

    private void fireTerminouExecucao() {
        for (ThreadImpAutoListener ouvinte : (ThreadImpAutoListener[])this.listenerList.getListeners(ThreadImpAutoListener.class)) {
            ouvinte.terminouExecucao();
        }
    }
}

